' ======= KONFIGURATION =======

datenbank = "stats3"
user      = "postgres"
passwort  = "postgres"
ordner    = "output"

' =============================


' Zum erstellen der notwendigen Tabellen, folgendes Statements aufrufen:
' CREATE TABLE bev_nat
' (
'   gdenr integer NOT NULL,
'   gdname character varying(100) NOT NULL,
'   geschlecht character(1),
'   jahr integer,
'   alterstart integer,
'	alterend integer,
'   anzahl integer
' ) 
'
' Das ganze noch zwei mal wiederholen mit den Tabellennamen trend_optimistisch, trend_pessimistisch und trend_mittel.

' -- Procedure--


Set InternetExplorer = CreateObject("internetexplorer.application")

InternetExplorer.navigate2 "about:blank"
InternetExplorer.width = 400
InternetExplorer.height = 600
InternetExplorer.toolbar = false
InternetExplorer.menubar = false
InternetExplorer.statusbar = false
InternetExplorer.visible = True

statusText = "<p style='color:#003366'>Import Excel To Postgres 2.2  - " & Date & "</p>"
SetStatusText(statusText & "Initialisiere..")


Set connection = CreateConnection(datenbank, user, passwort)



basePath = CreateObject("Scripting.FileSystemObject").GetAbsolutePathName(".") & "\" & ordner

Set folder = CreateObject("Scripting.FileSystemObject").GetFolder(basePath)

numberOfExcelFiles = 0
For each excelFile in folder.Files
  If  (isExcelFile(excelFile.Name)) Then
    numberOfExcelFiles = numberOfExcelFiles + 1
  End If
Next

Dim excelFiles()
ReDim excelFiles(numberOfExcelFiles - 1)

i = 0
For each excelFile in folder.Files
  If (isExcelFile(excelFile.Name)) Then
    excelFiles(i) = CStr(excelFile.Name)
    i = i + 1
  End If
Next


Set excel = CreateObject("Excel.Application")


For each excelFile in SortArray(excelFiles)

    Set workbook = excel.Workbooks.Open(basePath & "\" & excelFile)
    
    GemeindeName = workbook.Sheets("Bevlkerungsdaten").Range("C5").Value
    GemeindeNummer = workbook.Sheets("Bevlkerungsdaten").Range("B5").Value
    statusText = statusText & "Gemeinde <strong>" & GemeindeName & "</strong><br/>"
    SetStatusText(statusText)
    deleteOldData(GemeindeNummer)
    
    
    startAge =workbook.Sheets("Bevlkerungsdaten").Range("A18").Value
 
    If IsNumeric(startAge) Then
	  rangeYears = "G15:BR15"
	  rangeAge = "C18:C128"
	  isAnnual = True
	Else
		rangeYears = "G15:Y15"
	  	rangeAge = "C18:C39"
		isAnnual= False
    End If
   
   		gemeindeName = ensureGdeName(gemeindeName)
   
   		ExtractValues workbook.Sheets("Perspektive_nat_Entwicklung "), "trend_natuerlich", _
	      GemeindeName, GemeindeNummer,rangeYears , rangeAge, "G15", "C18", "G18", isAnnual
	      
	    ExtractValues workbook.Sheets("Optimistischer Trend"), "trend_optimistisch", _
	      GemeindeName, GemeindeNummer, rangeYears, rangeAge, "G15", "C18", "G18", isAnnual
	    
	    ExtractValues workbook.Sheets("Pessimistischer Trend"), "trend_pessimistisch", _
	      GemeindeName, GemeindeNummer, rangeYears, rangeYears, "G15", "C18", "G18", isAnnual
	   On Error Resume Next
		ExtractValues workbook.Sheets("Mittlerer Trend"), "trend_mittel", _
	      GemeindeName, GemeindeNummer, rangeYears, rangeYears, "G15", "C18", "G18", isAnnual
		On Error GoTo 0
   
   
    statusText = statusText & "<br/>"
    
    excel.ActiveWorkbook.Close False
Next

'connection.CloseInternetExplorer.Quit

excel.Quit


'---Subs and Functions--

' Erstellt und ffnet die Verbindung zur Datenbank mithilfe der Parameter. Das Schliessen nicht vergessen!
Function CreateConnection(DatabaseName, UserID, Password)
    Set cn = CreateObject("ADODB.Connection")
    cn.ConnectionString = "PROVIDER=PostgreSQL;" & _
        "DATA SOURCE=127.0.0.1;" & _
        "LOCATION=" & DatabaseName & ";" & _
        "USER ID=" & UserID & ";" & _
        "PASSWORD=" & Password & ";"
    cn.Open
    Set CreateConnection = cn
End Function

' Fhrt die Einfge-Query aus in die angegebene Tabelle mit den Parametern
Sub ExecuteInsertQuery(tabelle, gemeindeName, gemeindeNummer, geschlecht, year, startAge, endAge, anzahl)
  
  query = "INSERT INTO " & tabelle & "(gdenr, gdname, geschlecht, jahr, alterstart, alterend, anzahl) " & _
    "VALUES (" & gemeindeNummer & ", '" & gemeindeName & "', '" & geschlecht & "', " & year & ", " & startAge & ", " & endAge & "," & anzahl & ")"
  connection.Execute(query)
End Sub

' Ermittelt die Anzahl pro Geschlecht und fgt danach beide in die Datenbank ein
Sub WriteToDatabase(tabelle, gemeindeName, gemeindeNummer, year, startAge, endAge, range)
  ExecuteInsertQuery tabelle, gemeindeName, gemeindeNummer, "m", year, startAge, endAge, CInt(range.Value)
  ExecuteInsertQuery tabelle, gemeindeName, gemeindeNummer, "w", year, startAge, endAge, CInt(range.Offset(0, 1).Value) 
End Sub

' Durchluft die Datenfelder:
' - rangeJahre gibt den Bereich aller Jahre an, fr die Daten vorhanden sind
' - rangeAlter ist die Range, in der die Alter der Personen gespeichert sind
' - startJahre, das Feld mit dem ersten Jahrgang
' - startAlter, das Feld mit dem Alter '0'
' - startDaten, die obere, linke Ecke an der die tatschlichen Daten beginnen
Sub ExtractValues(sheet, tabelle, gemeindeName, gemeindeNummer, rangeJahre, rangeAlter, startJahre, startAlter, startDaten, isYearly)
  Dim Year, StartAge, EndAge,AnzahlJahre
  Dim DataRange
  Dim ageRange
  AnzahlJahre = sheet.Range(rangeJahre).Count
  AnzahlAlter = sheet.Range(rangeAlter).Count
  
  For Row = 0 To AnzahlJahre Step 3
    Year = sheet.Range(startJahre).Offset(0, Row + 1).Value
    
    For Col = 0 To AnzahlAlter - 1
      Set DataRange = sheet.Range(startDaten).Offset(Col, Row)
      If IsNumeric(DataRange.Value) Then
        If isYearly Then
        	StartAge = sheet.Range(startAlter).Offset(Col, 0).Value
        	EndAge = StartAge
        Else 
        	ageRange = Split(sheet.Range(startAlter).Offset(Col, 0).Value, "-")
        	StartAge = CInt(ageRange(0))
        	EndAge = CInt(ageRange(1))
        End If
        WriteToDatabase tabelle, gemeindeName, gemeindeNummer, Year, StartAge, EndAge, DataRange
      End If
    Next
    
    SetStatusText(statusText & "&nbsp;&nbsp;&nbsp;&nbsp;" & sheet.Name & ": " & CInt(100 * Row  / AnzahlJahre) & "% fertig")
  Next
  
  statusText = statusText & "&nbsp;&nbsp;&nbsp;&nbsp;" & sheet.Name & ": 100% fertig<br/>"
End Sub

Sub SetStatusText(text)
  InternetExplorer.Document.Body.InnerHTML = text
End Sub

function SortArray(arrShort)
  dim i, j, temp
  for i = UBound(arrShort) - 1 To 0 Step -1
    for j= 0 to i
      if arrShort(j)>arrShort(j+1) then
        temp=arrShort(j+1)
        arrShort(j+1)=arrShort(j)
        arrShort(j)=temp
      end if
    next
  next
  SortArray = arrShort
end Function

Function isExcelFile(name)
	nameArray = Split(name, ".", -1, vbBinaryCompare)
	cond = InStr(1,nameArray( UBound(nameArray)),"xls", vbTextCompare)
	startChars = Left(nameArray(0),2)
	isExcelFile = (cond<>0)and(startChars<>"~$")
End Function

'Pruef ob Gdename ein ' hat und ersetzt es durch ''
Function ensureGdeName(name) 
	nameArray = Split(name, "'", -1, vbBinaryCompare)
	name = nameArray(0)
	For i = 1 To UBound(nameArray)
		name = name & "''"&nameArray(i)
	Next
	ensureGdeName = name
End Function

'Loescht die alten Daten der Gde aus der Tabelle
Sub deleteOldData(gdenr)
	connection.Execute("delete from trend_natuerlich where gdenr =" & gdenr)
	connection.Execute("delete from trend_optimistisch where gdenr =" & gdenr)
	connection.Execute("delete from trend_pessimistisch where gdenr =" & gdenr)
	connection.Execute("delete from trend_mittel where gdenr =" & gdenr)
End Sub
