package ch.hsr.worldfiletool;

import static org.junit.Assert.*;

import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.junit.Test;

public class WorldFileToolTest {
	
	/**
	 * writing my first tests ever.
	 * show a lil' mercy. ;)
	 */

	@Test
	public void testMain() {
		WorldFileTool.main(new String[] {});
		assertNotNull(WorldFileTool.wftswing);
	}
	
	@Test
	public void testRead_kml() throws IOException {
		int[] angles = { 45, 135, 225, 315};
		for (int angle: angles) {
		File testfile = new File("testkml.kml");
		create_test_image();
		String kml_test = 
			"<?xml version=\"1.0\" encoding=\"utf-8\"?>" + "\n" +
			"<kml xmlns=\"http://earth.google.com/kml/2.2\">" + "\n" +
			"<GroundOverlay>" + "\n" +
			"    <name>test</name>" + "\n" +
			"    <Icon>" + "\n" +
			"        <href>testimage.png</href>" + "\n" +
			"        <viewBoundScale>0.75</viewBoundScale>" + "\n" +
			"    </Icon>" + "\n" +
			"    <LatLonBox>" + "\n" +
			"        <north>47.22384390486059</north>" + "\n" +
			"        <west>8.815489285344636</west>" + "\n" +
			"        <south>47.22345122640866</south>" + "\n" +
			"        <east>8.816304349533887</east>" + "\n" +
			"        <rotation>" + angle + "</rotation>" + "\n" +	
			"    </LatLonBox>" + "\n" +
			"    <Metadata>" + "\n" +
			"        <floor>0</floor>" + "\n" +
			"        <background>0</background>" + "\n" +
			"        <priority>0</priority>" + "\n" +
			"    </Metadata>" + "\n" +
			"</GroundOverlay>" + "\n" +
			"</kml>" + "\n";
		BufferedWriter bw = new BufferedWriter(new FileWriter(testfile));
		bw.write(kml_test);
		bw.close();
		WorldFileTool wft = new WorldFileTool();
		wft.read_kml(System.getProperty("user.dir"), testfile);
		assertEquals("Name", wft.name, "test");
		assertEquals("View", wft.view, "0.75");
		assertEquals("Image", wft.image, "testimage.png");
		assertEquals("North", wft.north, "47.22385666691027");
		assertEquals("West", wft.west, "8.81502877407771");
		assertEquals("South", wft.south, "47.22343846435898");
		assertEquals("East", wft.east, "8.816764860800813");
		assertEquals("Image Height", wft.image_height, 213);
		assertEquals("Image Width", wft.image_width, 213);
		del_test_files();
		}
	}

	@Test
	public void testRead_image() throws IOException {
		int[][] coord = {{-1, 0}, {0, 0}, {1, 0}};
		for (int[] xy: coord) {
		String image_test =
			"0.0057987615" + "\n" +
			xy[0] + "\n" +
			xy[1] + "\n" +
			"-0.0057987615" + "\n" +
			"5.2211660445" + "\n" +
			"48.1645342726" + "\n";
			create_test_image();
			BufferedWriter bw = new BufferedWriter(new FileWriter(new File("testimage.pgw")));
			bw.write(image_test);
			bw.close();
			WorldFileTool wft = new WorldFileTool();
			wft.read_image(System.getProperty("user.dir"), new File("testimage.png"));
			assertEquals("Image", wft.image, "testimage.png");
			assertEquals("North", wft.north, "48.1645342726");
			assertEquals("West", wft.west, "5.2211660445");
			assertEquals("South", wft.south, "47.0047819726");
			assertEquals("East", wft.east, "5.801042194500001");
			assertEquals("Image Height", wft.image_height, 200);
			assertEquals("Image Width", wft.image_width, 100);
			del_test_files();
		}
	}

	@Test
	public void testCheck_ext() {
		final String[] ext = { "jpg", "jpeg", "png", "gif", "tif", "tiff" };
		WorldFileTool wft = new WorldFileTool();
		assertFalse(wft.check_ext(new File("testfile"), ext));
		assertTrue(wft.check_ext(new File("testfile.jpg"), ext));
		assertTrue(wft.check_ext(new File("testfile.png"), ext));
		assertTrue(wft.check_ext(new File("testfile.gif"), ext));
		assertTrue(wft.check_ext(new File("testfile.tif"), ext));
		assertTrue(wft.check_ext(new File("testfile.tiff"), ext));
	}

	private void create_test_image() throws IOException {
		File testimage = new File("testimage.png");
		BufferedImage bitest = new BufferedImage(100, 200, BufferedImage.TYPE_INT_RGB);
		ImageIO.write(bitest, "png", testimage);
	}
	
	private void del_test_files() {
		new File("testimage.png").delete();
		new File("testimage_ori.png").delete();
		new File("testimage.pgw").delete();
		new File("testkml.kml").delete();
	}
}
