/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.worldfiletool.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RotateImage {
    public static BufferedImage rotate_vectors(File file, double vecx, double vecy) {
        BufferedImage bi = null;
        AffineTransform at = null;
        double angle = 0.0;
        try {
            bi = ImageIO.read(file);
            at = new AffineTransform();
            double dist_vec = Math.sqrt(Math.pow(vecx, 2.0) + Math.pow(vecy, 2.0));
            angle = Math.toDegrees(Math.acos(vecy / dist_vec));
            if (vecx < 0.0) {
                angle = -angle;
            }
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return RotateImage.rotate(at, bi, angle);
    }

    public static BufferedImage rotate_angle(File file, double angle) {
        BufferedImage bi = null;
        AffineTransform at = null;
        angle = -angle;
        try {
            bi = ImageIO.read(file);
            at = new AffineTransform();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return RotateImage.rotate(at, bi, angle);
    }

    private static AffineTransform translate(AffineTransform at, BufferedImage bi, double angle) {
        double ytrans = 0.0;
        double xtrans = 0.0;
        if (0.0 < angle && angle < 90.0) {
            ytrans = RotateImage.transform_point(0.0, 0.0, at).getY();
            xtrans = RotateImage.transform_point(0.0, bi.getHeight(), at).getX();
        } else if (90.0 < angle && angle < 180.0) {
            ytrans = RotateImage.transform_point(0.0, bi.getHeight(), at).getY();
            xtrans = RotateImage.transform_point(bi.getWidth(), bi.getHeight(), at).getX();
        } else if (180.0 < angle && angle < 270.0) {
            ytrans = RotateImage.transform_point(bi.getWidth(), bi.getHeight(), at).getY();
            xtrans = RotateImage.transform_point(bi.getWidth(), 0.0, at).getX();
        } else if (270.0 < angle && angle < 360.0) {
            ytrans = RotateImage.transform_point(bi.getWidth(), 0.0, at).getY();
            xtrans = RotateImage.transform_point(0.0, 0.0, at).getX();
        }
        AffineTransform att = new AffineTransform();
        att.translate(-xtrans, -ytrans);
        return att;
    }

    private static Point2D transform_point(double x, double y, AffineTransform at) {
        Point2D.Double p2d = new Point2D.Double(x, y);
        return at.transform(p2d, null);
    }

    private static BufferedImage rotate(AffineTransform at, BufferedImage bi, double angle) {
        while (angle > 360.0) {
            angle -= 360.0;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        at.rotate(Math.toRadians(angle), bi.getWidth() / 2, bi.getHeight() / 2);
        at.preConcatenate(RotateImage.translate(at, bi, angle));
        AffineTransformOp ato = new AffineTransformOp(at, null);
        bi = ato.filter(bi, null);
        return bi;
    }
}

