/*
 * Tabellen erzeugen
 */
CREATE TABLE Abteilung (
  AbtNr INTEGER  PRIMARY KEY,
  Name VARCHAR(20)
);

CREATE TABLE Angestellter (
  PersNr INTEGER  PRIMARY KEY,
  Name VARCHAR(20) NOT NULL,
  Tel INTEGER ,
  Salaer DECIMAL (7,2) NOT NULL,
  Chef INTEGER ,
  AbtNr INTEGER  NOT NULL,
  Wohnort VARCHAR(20),
  Eintrittsdatum DATE DEFAULT 'now',
  Bonus DECIMAL (7,2) DEFAULT 0,
  CHECK (Salaer between 1000 and 20000)
);

CREATE TABLE AbtLeitung (
  AbtNr INTEGER,
  AbtChef INTEGER  NOT NULL,
  PRIMARY KEY(AbtNr),
  UNIQUE(AbtChef)
);

CREATE TABLE Projekt (
  ProjNr INTEGER PRIMARY KEY,
  Bezeichnung char(20),
  StartZeit DATE,
  Dauer INTEGER ,
  Aufwand INTEGER ,
  ProjLeiter INTEGER 
);

CREATE TABLE ProjektZuteilung (
  PersNr INTEGER  NOT NULL,
  ProjNr INTEGER   NOT NULL,
  ZeitAnteil INTEGER  NOT NULL,
  StartZeit DATE,
  Dauer INTEGER ,
  PRIMARY KEY (PersNr, ProjNr),
  CHECK (Zeitanteil between 10 and 90)
);


CREATE Sequence S_Angestellter START WITH 2000 INCREMENT BY 10; 
CREATE Sequence S_Abteilung; 
CREATE Sequence S_Projekt; 

/*
 * Testdaten einfllen
 */
-- TABLE  ABTEILUNG

INSERT INTO ABTEILUNG VALUES
(1, 'Verkauf');
INSERT INTO ABTEILUNG VALUES
(2, 'Marketing');
INSERT INTO ABTEILUNG VALUES
(3, 'Entwicklung');
INSERT INTO ABTEILUNG VALUES
(4, 'Finanzen');
INSERT INTO ABTEILUNG VALUES
(5, 'QS');
 
-- TABLE  ANGESTELLTER

INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)  VALUES
(1001, 'Marxer, Markus', 234, 10580, NULL, 1, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(1002, 'Widmer, Anna', 301, 12010, NULL, 2, 'Adligenswil');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(1010, 'Steiner, Hans', 409, 10867, NULL, 3, 'Hitzkirch');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(1019, 'Affolter, Vreni', 233, 4123, 1001, 1, 'Zuerich');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(1100, 'Widmer, Karl', 450, 7500, 1010, 3, 'Emmen');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(1123, 'Meier, Franz', 240, 9765, 1001, 1, 'Zug');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2098, 'Zuercher, Hedi', 249, 10019, 1001, 1, 'Horw');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2109, 'Heiniger, Urs', 345, 4098, 1002, 2, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2298, 'Pauli, Monika', 478, 5089, 1010, 3, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2345, 'Becker, Fritz', 310, 6346, 1002, 2, 'Hochdorf');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2567, 'Ammann, Fritz', 467, 7890, 1010, 3, 'Baar');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2601, 'Wehrli, Anton', NULL, 5980, 2567, 3, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2666, 'Beeler, Hans', NULL, 3780, 2567, 3, 'Rotkreuz');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(2701, 'Graber, Berta', 451, 4590, 1100, 3, 'Sursee');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(3000, 'Aarburg, Werner', 400, 9000, 1100, 3, 'Abtwil');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(3019, 'Kern, Veronika', 401, 4800, 3000, 3, 'Sins');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(3333, 'Wernli, Peter', 112, 8978, 1001, 1, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(3338, 'Kramer, Luise', NULL, 4000, 3000, 3, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(4000, 'Rey, Herbert', 480, 15000,  NULL, 4, 'Adligenswil');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(4010, 'Danuser, Vreni', 481, 5100, 4000, 4, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(nextval('S_Angestellter'), 'Schnell, Marie', 601, 5100, 4000, 4, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES
(nextval('S_Angestellter'), 'Gschwind, Fritz', 602, 5900, 4000, 4, 'Luzern');
INSERT INTO ANGESTELLTER (PersNr,Name,Tel,Salaer,Chef,AbtNr,Wohnort)VALUES 
(nextval('S_Angestellter'), 'Test, Hans', 602, 5900, 4000, 4, 'Luzern');
 
-- TABLE  ABTLEITUNG (ABTCHEF, ABTNR)

INSERT INTO ABTLEITUNG VALUES
(1, 1001);
INSERT INTO ABTLEITUNG VALUES
(2, 1002);
INSERT INTO ABTLEITUNG VALUES
(3, 1010);
INSERT INTO ABTLEITUNG VALUES
(4, 3000);
 
-- TABLE  PROJEKT 

INSERT INTO PROJEKT VALUES 
(25, 'Saturn', To_Date('01.01.94', 'DD.MM.YY'), 30, 120, 1001);
INSERT INTO PROJEKT VALUES
(26, 'Mars', To_Date('01.12.92', 'DD.MM.YY'), 500, 1000, 1100);
INSERT INTO PROJEKT VALUES
(27, 'Uranus', NULL, NULL, NULL, 1100);
INSERT INTO PROJEKT VALUES
(30, 'Jupiter', To_Date('12.02.93', 'DD.MM.YY'), 10, 50, 1001);

 
-- TABLE  ProjektZuteilung (PERSNR,PROJNR,ZEITANTEIL, STARTZEIT, DAUER)

INSERT INTO ProjektZuteilung VALUES
(1001, 26, 30, NULL,NULL);	
INSERT INTO ProjektZuteilung VALUES
(1001, 27, 30, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(1001, 30, 10, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(1019, 25, 90, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(1100, 26, 50, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(1123, 25, 50, To_Date('01.01.94', 'DD.MM.YY'),NULL);	
INSERT INTO ProjektZuteilung VALUES
(1123, 30, 90, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2098, 26, 20, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2098, 27, 31, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2298, 26, 89, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2601, 25, 30, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2601, 26, 40, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2601, 30, 40, NULL,NULL);
INSERT INTO ProjektZuteilung VALUES
(2701, 26, 90, NULL,NULL);

/*
 * Fremdschlssel setzen
 */
 ALTER TABLE Angestellter 
 ADD CONSTRAINT fk_AngAng 
    FOREIGN KEY (Chef) REFERENCES Angestellter (PersNr)
 ;
 
 ALTER TABLE Angestellter 
 ADD CONSTRAINT fk_AngAbt 
    FOREIGN KEY (AbtNr) REFERENCES Abteilung (AbtNr)
 ;
 
 ALTER TABLE AbtLeitung 
 ADD CONSTRAINT fk_AbtLAbt 
    FOREIGN KEY (AbtNr) REFERENCES Abteilung (AbtNr)
    ON DELETE CASCADE
 ;
 
 ALTER TABLE AbtLeitung 
 ADD CONSTRAINT fk_AbtLAng 
    FOREIGN KEY (AbtChef) REFERENCES Angestellter(PersNr)
    ON DELETE CASCADE
 ;
 
 ALTER TABLE Projekt 
 ADD CONSTRAINT fk_ProjAng 
    FOREIGN KEY (ProjLeiter) REFERENCES Angestellter(PersNr)
 ;
 
 ALTER TABLE ProjektZuteilung 
 ADD CONSTRAINT fk_ProjzAng 
    FOREIGN KEY (PersNr) REFERENCES Angestellter(PersNr)
    ON DELETE CASCADE
 ;
 
 ALTER TABLE ProjektZuteilung 
 ADD CONSTRAINT fk_ProjzProj 
    FOREIGN KEY (ProjNr) REFERENCES Projekt(ProjNr)
    ON DELETE CASCADE
;