--
-- PostgreSQL database dump
--

-- Started on 2010-01-14 09:43:26 CET

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 2272 (class 1259 OID 62643)
-- Dependencies: 2566 2567 2568 991 3
-- Name: staedte_schweiz; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE staedte_schweiz (
    "UNI" integer NOT NULL,
    "UTM" character(4),
    "JOG" character varying(7),
    "PC" smallint,
    "SORT_NAME" character varying,
    "FULL_NAME" character varying,
    "FULL_NAME_ND" character varying,
    the_geom geometry,
    CONSTRAINT enforce_dims_geom CHECK ((st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_geom CHECK (((geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_geom CHECK ((st_srid(the_geom) = 21781))
);


--
-- TOC entry 2571 (class 0 OID 62643)
-- Dependencies: 2272
-- Data for Name: staedte_schweiz; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514346, 'MS81', 'NL32-05', NULL, 'GORDEVIO', 'Gordevio', 'Gordevio', '010100002015550000E8F935F20966254185D2BCC3281AFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512576, 'MT95', 'NL32-02', NULL, 'AADORF', 'Aadorf', 'Aadorf', '010100002015550000C85F10EAF6AB254146AA34943BC30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512578, 'MT24', 'NL32-02', 3, 'AARAU', 'Aarau', 'Aarau', '010100002015550000A0D3C7AF2CB82341000D719C5A4D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512580, 'LT61', 'NL32-01', NULL, 'AARBERG', 'Aarberg', 'Aarberg', '010100002015550000E1EDE0404FF321412480A41405C20941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512581, 'MT14', 'NL32-01', NULL, 'AARBURG', 'Aarburg', 'Aarburg', '0101000020155500005B5EFF5B0660234144314F3A50630D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512595, 'MT03', 'NL32-01', NULL, 'AARWANGEN', 'Aarwangen', 'Aarwangen', '010100002015550000C31A2ABAB5072341ADBA09840B400C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512596, 'MT84', 'NL32-02', NULL, 'AATHAL', 'Aathal', 'Aathal', '010100002015550000D3FDEBA0AB5F2541BE36E7A08DB40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512597, 'LS65', 'NL32-04', NULL, 'ABLANDSCHEN', 'Abländschen', 'Ablandschen', '0101000020155500004EFD0ACB74FC21419DC8C291D6320341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512598, 'NT25', 'NL32-02', NULL, 'ABTWIL', 'Abtwil', 'Abtwil', '0101000020155500000E4794F3A4A2264154A829E18CF00E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512600, 'MT47', 'NL32-02', NULL, 'ACHEBERG', 'Acheberg', 'Acheberg', '01010000201555000061362BF5F33F2441D2DC9189AA841041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512601, 'MS12', 'NL32-04', NULL, 'ACKERSAND', 'Ackersand', 'Ackersand', '010100002015550000519A7209765123414AC043EEBE5EFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512602, 'MS86', 'NL32-05', NULL, 'ACLA', 'Acla', 'Acla', '0101000020155500002A4F1681D6912541D154B3C9C7370441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512603, 'NS47', 'NL32-05', NULL, 'ACLASDAFORA', 'Aclas Dafora', 'Aclas Dafora', '01010000201555000096953582B16E27413296442B144B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512604, 'MS85', 'NL32-05', NULL, 'ACQUACALDA', 'Acquacalda', 'Acquacalda', '010100002015550000F2EF6EB5619325411B9EBB3A71DC0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512605, 'MS94', 'NL32-05', NULL, 'ACQUAROSSA', 'Acquarossa', 'Acquarossa', '01010000201555000046FB2D75B0DA25412629B8EE2EC00141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512606, 'LS65', 'NL32-04', NULL, 'ADANNES', 'Adannes', 'Adannes', '0101000020155500009F2434D366DE2141A9EADDD464850241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512607, 'LS84', 'NL32-04', NULL, 'ADELBODEN', 'Adelboden', 'Adelboden', '010100002015550000C51293094E9C2241A430853A4B110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512608, 'MT51', 'NL32-02', NULL, 'ADLIGENSWIL', 'Adligenswil', 'Adligenswil', '010100002015550000507723DD3B762441F81BA05C90080A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512609, 'MT64', 'NL32-02', NULL, 'ADLISWIL', 'Adliswil', 'Adliswil', '0101000020155500006741170143CC244177D9E66E99710D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512610, 'MS38', 'NL32-05', NULL, 'AECHERLI', 'Aecherli', 'Aecherli', '0101000020155500009C0AF4CE5C0B244116A040BA57D90641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512611, 'LS78', 'NL32-04', NULL, 'AECKENMATT', 'Aeckenmatt', 'Aeckenmatt', '0101000020155500000CC880DDAF1A22411FA8C665F40A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512612, 'LT93', 'NL32-01', NULL, 'AEDERMANNSDORF', 'Aedermannsdorf', 'Aedermannsdorf', '0101000020155500001A6259C7D9AE2241C69018D099260D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512616, 'MS27', 'NL32-04', NULL, 'AELGAU', 'Aelgäu', 'Aelgau', '01010000201555000091D5324B9D8A2341CB16AAB18FED0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512619, 'MS48', 'NL32-05', NULL, 'AELGGIALP', 'Aelggi Alp', 'Aelggi Alp', '0101000020155500002E1151C37429244109FFFA94B7660641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512621, 'MS89', 'NL32-05', NULL, 'AESCH', 'Aesch', 'Aesch', '01010000201555000044E648D0217A2541BBC4EEF6BE9A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512622, 'MT43', 'NL32-02', NULL, 'AESCH', 'Aesch', 'Aesch', '01010000201555000046093ECE342F24411841EB924EBC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512623, 'LT95', 'NL32-01', NULL, 'AESCH', 'Aesch', 'Aesch', '0101000020155500000B758EF38DAE2241BE451FACAC690F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512624, 'MS09', 'NL32-04', NULL, 'AESCHAU', 'Aeschau', 'Aeschau', '01010000201555000087482519C71223411D18EFD228BA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512625, 'NT33', 'NL32-02', NULL, 'AESCHER', 'Aescher', 'Aescher', '0101000020155500006E12251681E02641A54149AE3C270D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512626, 'MS06', 'NL32-04', NULL, 'AESCHI', 'Aeschi', 'Aeschi', '0101000020155500000D7BC300D0EB2241A3C13DED11550441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512627, 'MS07', 'NL32-04', NULL, 'AESCHLEN', 'Aeschlen', 'Aeschlen', '01010000201555000002B6F8C49EEB22412EB41790AA3C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512628, 'LS68', 'NL32-04', NULL, 'AESCHLENBERG', 'Aeschlenberg', 'Aeschlenberg', '010100002015550000A7F0AAA5E7E821418F863BCAAF230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512629, 'MT52', 'NL32-02', NULL, 'AETTENSCHWIL', 'Aettenschwil', 'Aettenschwil', '010100002015550000E2B233230975244119521A14DC9D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512630, 'MT63', 'NL32-02', NULL, 'AEUGST', 'Aeugst', 'Aeugst', '0101000020155500009F5674F326B924419085E2EFD4C20C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512631, 'NT06', 'NL32-02', NULL, 'AFFELTRANGEN', 'Affeltrangen', 'Affeltrangen', '01010000201555000008DB3F73DFF92541D4F7FB89921E1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512632, 'MT01', 'NL32-01', NULL, 'AFFOLTERN', 'Affoltern', 'Affoltern', '0101000020155500009CA3D66464FE2241F6B1E3F0DBFC0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512633, 'MT53', 'NL32-02', NULL, 'AFFOLTERN', 'Affoltern', 'Affoltern', '01010000201555000076E6A36542A524416C5E8322B3FB0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512635, 'LS92', 'NL32-04', NULL, 'AGARN', 'Agarn', 'Agarn', '0101000020155500005173CCE7C1D82241A6E8DEDFE829FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512638, 'LS71', 'NL32-04', NULL, 'AGETTES', 'Agettes', 'Agettes', '0101000020155500009769E4CD242E22415A034CA8A371FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512639, 'LS17', 'NL32-04', NULL, 'AGIEZ', 'Agiez', 'Agiez', '0101000020155500000E335FA8CA2820412CD5888B9C480541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512641, 'MR89', 'NL32-08', NULL, 'AGNO', 'Agno', 'Agno', '0101000020155500000E564451F6A52541A0EE89AB9DCDF640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512642, 'MR99', 'NL32-08', NULL, 'AGRA', 'Agra', 'Agra', '010100002015550000EEB9D57297CE2541CA84E2AFC85FF640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512643, 'LS43', 'NL32-04', NULL, 'AIGLE', 'Aigle', 'Aigle', '010100002015550000EAB566EC7B3321415B71E34FFDA2FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512651, 'MS65', 'NL32-05', NULL, 'AIROLO', 'Airolo', 'Airolo', '01010000201555000083D018A38C072541A91F31AF54D30241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512652, 'MT22', 'NL32-02', NULL, 'ALBERSWIL', 'Alberswil', 'Alberswil', '0101000020155500003D446C72209C234147DCDDE9D0210B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512653, 'LS55', 'NL32-04', NULL, 'ALBEUVE', 'Albeuve', 'Albeuve', '01010000201555000063B12F4E7C702141F73CEA97F8860241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512654, 'LS93', 'NL32-04', NULL, 'ALBINEN', 'Albinen', 'Albinen', '01010000201555000098C935D495C42241EEC5F8386F420041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512656, 'LS78', 'NL32-04', NULL, 'ALBLIGEN', 'Albligen', 'Albligen', '0101000020155500000CB12C41D30622416CA79FF50F0B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512664, 'LT91', 'NL32-01', NULL, 'ALCHENSTORF', 'Alchenstorf', 'Alchenstorf', '010100002015550000DD2A2C94F0C222416C5C3968D4A90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512669, 'MS54', 'NL32-05', NULL, 'ALLACQUA', 'All’Acqua', 'All’Acqua', '0101000020155500006C909D0F36B82441585A33CA30210241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512672, 'LS04', 'NL32-04', NULL, 'ALLAMAN', 'Allaman', 'Allaman', '010100002015550000D0A7AC9775C01F4111ABFA34B1E70141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512673, 'LT55', 'NL32-01', NULL, 'ALLE', 'Alle', 'Alle', '0101000020155500006CB44E97909B2141B216C768E1F60E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512674, 'LS97', 'NL32-04', NULL, 'ALLMENDINGEN', 'Allmendingen', 'Allmendingen', '010100002015550000EA1F59BFE7A52241E723F5D5D8750541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512675, 'LS89', 'NL32-04', NULL, 'ALLMENDINGEN', 'Allmendingen', 'Allmendingen', '010100002015550000F4AD9109F47D22414BC64105A0B80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512678, 'LT86', 'NL32-01', NULL, 'ALLSCHWIL', 'Allschwil', 'Allschwil', '010100002015550000F181A5273387224199BA0AFD7B451041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512682, 'NS82', 'NL32-06', NULL, 'ALPEBRAITA', 'Alpe Braita', 'Alpe Braita', '010100002015550000562230721A732841A788C1B392F9FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512685, 'MS83', 'NL32-05', NULL, 'ALPEDELLACOSTA', 'Alpe della Costa', 'Alpe della Costa', '010100002015550000013A3364F4952541E02DF6908C990041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512689, 'NS13', 'NL32-05', NULL, 'ALPEDIBOGGIO', 'Alpe di Boggio', 'Alpe di Boggio', '01010000201555000027FDA018A868264158A4E94681700041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512690, 'NS03', 'NL32-05', NULL, 'ALPEDICAVA', 'Alpe di Cava', 'Alpe di Cava', '010100002015550000EC02CD962C0E264177BD4348B6A20041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512691, 'NS13', 'NL32-05', NULL, 'ALPEDICORTAS', 'Alpe di Cortas', 'Alpe di Cortas', '010100002015550000F99339BEB67B2641D80446A9F41F0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512692, 'NS13', 'NL32-05', NULL, 'ALPEDICRASTERA', 'Alpe di Crastera', 'Alpe di Crastera', '01010000201555000019F86934BD902641636F9FBC23740041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512694, 'MS71', 'NL32-05', NULL, 'ALPEDINACCIO', 'Alpe di Naccio', 'Alpe di Naccio', '0101000020155500004EC4E27BC53E25411B117144CA45FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512695, 'NS04', 'NL32-05', NULL, 'ALPEDIQUARNAJO', 'Alpe di Quarnajo', 'Alpe di Quarnajo', '010100002015550000843EBB421E022641FFB839BF1B370241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512696, 'NS04', 'NL32-05', NULL, 'ALPEDISCIERU', 'Alpe di Scieru', 'Alpe di Scieru', '010100002015550000D0C675FFB30C264182342AE624C40141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512697, 'NS13', 'NL32-05', NULL, 'ALPEDITRESCOLMEN', 'Alpe di Trescolmen', 'Alpe di Trescolmen', '010100002015550000063927F2AD5D2641AD554045451D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512700, 'MS62', 'NL32-05', NULL, 'ALPEPORCARESCIO', 'Alpe Porcarescio', 'Alpe Porcarescio', '0101000020155500003BF5CB87F2CE2441F5C0766E80EFFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512701, 'NS04', 'NL32-05', NULL, 'ALPEPULGABIO', 'Alpe Pulgabio', 'Alpe Pulgabio', '010100002015550000171BC2E34C172641D74B9C8330510141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512703, 'MS75', 'NL32-05', NULL, 'ALPERITOM', 'Alpe Ritóm', 'Alpe Ritom', '010100002015550000CD7B9DB842392541E5285C0D49100341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512706, 'MS62', 'NL32-05', NULL, 'ALPESFILLE', 'Alpe Sfille', 'Alpe Sfille', '0101000020155500003BF5CB87F2CE2441F5C0766E80EFFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512709, 'NS73', 'NL32-06', NULL, 'ALPGRUM', 'Alp Grüm', 'Alp Grum', '0101000020155500007BC682CFAE662841F705209AC91C0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512711, 'MS64', 'NL32-05', NULL, 'ALPIANO', 'Al Piano', 'Al Piano', '0101000020155500004FF5F3880C0925413A7377E8153E0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512713, 'MS26', 'NL32-05', NULL, 'ALPIGLEN', 'Alpiglen', 'Alpiglen', '010100002015550000CDB2F59884A923417789757A6CAB0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512714, 'MS17', 'NL32-04', NULL, 'ALPIGLEN', 'Alpiglen', 'Alpiglen', '01010000201555000080D87BDE303B2341A296EBD9E4770541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512715, 'NS98', 'NL32-06', NULL, 'ALPLARETDADAINT', 'Alp Laret-Dadaint', 'Alp Laret-Dadaint', '01010000201555000039723F0EFEC7284134E5BA2671D20641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512716, 'MS49', 'NL32-05', NULL, 'ALPNACH', 'Alpnach', 'Alpnach', '010100002015550000271E0B09F63B2441698A39D69D700841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512718, 'MT40', 'NL32-05', NULL, 'ALPNACHSTAD', 'Alpnachstad', 'Alpnachstad', '010100002015550000CCE91496B74524417D3DCDF1EFAA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512720, 'NS35', 'NL32-05', NULL, 'ALPSCHMORRAS', 'Alp Schmorras', 'Alp Schmorras', '01010000201555000030521FB6752C27412012A4FD933A0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512724, 'MT71', 'NL32-02', NULL, 'ALPTHAL', 'Alpthal', 'Alpthal', '01010000201555000086B981ABAF4525414F364E0A234E0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512727, 'MS91', 'NL32-05', NULL, 'ALSASSO', 'Al Sasso', 'Al Sasso', '0101000020155500008E7DA158B5DF25410250225B685CFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512728, 'MS75', 'NL32-05', NULL, 'ALTANCA', 'Altanca', 'Altanca', '0101000020155500003FD9EF47B8392541D5BD08B1809C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512729, 'MS79', 'NL32-05', 4, 'ALTDORF', 'Altdorf', 'Altdorf', '0101000020155500005C35FF48D22025417528A27EE3940741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512732, 'MT77', 'NL32-02', NULL, 'ALTEN', 'Alten', 'Alten', '0101000020155500004A128A3936172541B0373EC343A71041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512733, 'MT82', 'NL32-02', NULL, 'ALTENDORF', 'Altendorf', 'Altendorf', '010100002015550000ACC0ADAE7A7F254186724D7385AD0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512734, 'NT45', 'NL32-02', NULL, 'ALTENRHEIN', 'Altenrhein', 'Altenrhein', '01010000201555000065BAA7039C2A2741116121A017E60F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512738, 'LS68', 'NL32-04', NULL, 'ALTERSWIL', 'Alterswil', 'Alterswil', '010100002015550000F19ED9D1EFE821410898C531965D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512739, 'NT17', 'NL32-02', NULL, 'ALTERSWILEN', 'Alterswilen', 'Alterswilen', '010100002015550000F0C9F1149E3C2641D8ED415528CF1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512740, 'NS38', 'NL32-05', NULL, 'ALTFELSBERG', 'Alt-Felsberg', 'Alt-Felsberg', '0101000020155500004D908028B4112741F88A9E7B504A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512742, 'MT22', 'NL32-01', NULL, 'ALTISHOFEN', 'Altishofen', 'Altishofen', '010100002015550000A6B392921588234122082B07FACE0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512745, 'NT17', 'NL32-02', NULL, 'ALTNAU', 'Altnau', 'Altnau', '01010000201555000091CE79C056772641A707A582CBD11041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512747, 'NT22', 'NL32-02', NULL, 'ALTSANKTJOHANN', 'Alt Sankt Johann', 'Alt Sankt Johann', '010100002015550000C002703AC393264148FA241339C40B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512748, 'NT44', 'NL32-02', NULL, 'ALTSTATTEN', 'Altstätten', 'Altstatten', '0101000020155500000E472D411E23274116A40E76B6890E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512749, 'MT94', 'NL32-02', NULL, 'ALTTOGGENBURG', 'Alt Toggenburg', 'Alt Toggenburg', '010100002015550000E7B9BCAEE7D425417E43CBE1D66A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512751, 'NS47', 'NL32-05', NULL, 'ALVANEU', 'Alvaneu', 'Alvaneu', '010100002015550000B680F52A196F274143C83FB933110541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512754, 'NS47', 'NL32-05', NULL, 'ALVASCHEIN', 'Alvaschein', 'Alvaschein', '010100002015550000E5E323104F3D2741F26D4009BC0B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512756, 'NS44', 'NL32-05', NULL, 'AMBACH', 'Am Bach', 'Am Bach', '010100002015550000A22F6AE6C23827417A642F905FE00141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512757, 'MS74', 'NL32-05', NULL, 'AMBRI', 'Ambri', 'Ambri', '010100002015550000C7D6AD0FF33925413424F57B9C620241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512760, 'NT11', 'NL32-02', NULL, 'AMDEN', 'Amden', 'Amden', '01010000201555000020AE6925E63B264117802196890E0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512762, 'NT26', 'NL32-02', NULL, 'AMRISWIL', 'Amriswil', 'Amriswil', '010100002015550000D636709B6A96264102A1D3A06E421041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512763, 'LS97', 'NL32-04', NULL, 'AMSOLDINGEN', 'Amsoldingen', 'Amsoldingen', '010100002015550000630AAF8AEEA522415813FF9FF23B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512765, 'MS77', 'NL32-05', NULL, 'AMSTEG', 'Amsteg', 'Amsteg', '010100002015550000BFF701AA542C25411E6125ED40000641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512766, 'NS36', 'NL32-05', NULL, 'ANDEER', 'Andeer', 'Andeer', '010100002015550000458285F470F92641640707B608E30341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512769, 'MS66', 'NL32-05', NULL, 'ANDERMATT', 'Andermatt', 'Andermatt', '010100002015550000BED5BE954306254128030C95AF2E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512770, 'NS08', 'NL32-05', NULL, 'ANDEST', 'Andest', 'Andest', '01010000201555000004F1FF3186382641F948B570084E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512771, 'NT25', 'NL32-02', NULL, 'ANDWIL', 'Andwil', 'Andwil', '010100002015550000E11CA41CD6842641D9A78358A8270F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512772, 'NS83', 'NL32-06', NULL, 'ANGELICUSTODI', 'Angeli Custodi', 'Angeli Custodi', '01010000201555000030AFCFCE307B284162B4AAE196E50041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512773, 'MS84', 'NL32-05', NULL, 'ANGONE', 'Angone', 'Angone', '010100002015550000A4F6B718F0A82541F04797D08B820141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512774, 'KS82', 'NL32-04', NULL, 'ANIERES', 'Anières', 'Anieres', '01010000201555000096D8BB967ADF1E41D82540AA78E2FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512776, 'MS95', 'NL32-05', NULL, 'ANVEUDA', 'Anvéuda', 'Anveuda', '0101000020155500008C14131D55BB25418049C5EE59DF0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512777, 'MS94', 'NL32-05', NULL, 'ANZONICO', 'Anzonico', 'Anzonico', '01010000201555000010F9FCA7F1B2254181FBF56C47830141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512779, 'NT34', 'NL32-02', 4, 'APPENZELL', 'Appenzell', 'Appenzell', '01010000201555000070D04F1892D52641286C678AE9D30D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512785, 'LS05', 'NL32-04', NULL, 'APPLES', 'Apples', 'Apples', '010100002015550000908E66FB51EA1F41549DC0191E080341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512786, 'LS71', 'NL32-04', NULL, 'APRO', 'Apro', 'Apro', '010100002015550000490880B1F00522418BC657BB0172FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512788, 'MS94', 'NL32-05', NULL, 'AQUILA', 'Aquila', 'Aquila', '010100002015550000C5E50E51DAD9254109087BBBD86D0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512789, 'MS82', 'NL32-05', NULL, 'AQUINO', 'Aquino', 'Aquino', '010100002015550000866D419C7F972541C6FAA33C6D7CFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512791, 'LS72', 'NL32-04', NULL, 'ARBAZ', 'Arbaz', 'Arbaz', '010100002015550000EA5A6418322E2241522D4726A0B4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512792, 'NS01', 'NL32-05', NULL, 'ARBEDO', 'Arbedo', 'Arbedo', '010100002015550000E5A19A482A1B2641FB201F4256C1FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512796, 'NT36', 'NL32-02', NULL, 'ARBON', 'Arbon', 'Arbon', '010100002015550000BFF020E732E526411D4A5D8157291041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512797, 'MS81', 'NL32-05', NULL, 'ARCEGNO', 'Arcegno', 'Arcegno', '010100002015550000041FA7BFC3662541FE67C7CCD0BEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512798, 'LT72', 'NL32-01', NULL, 'ARCH', 'Arch', 'Arch', '0101000020155500007DB3149B7C422241021399B2131D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512799, 'LS57', 'NL32-04', NULL, 'ARCONCIEL', 'Arconciel', 'Arconciel', '010100002015550000AE6C31174C8F21411420B11905B10541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512800, 'MS94', 'NL32-05', NULL, 'ARDET', 'Ardet', 'Ardet', '010100002015550000C22AAF2A24BC25411B60AF88AF310241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512801, 'NS98', 'NL32-06', NULL, 'ARDEZ', 'Ardez', 'Ardez', '010100002015550000E175926291BE284132A5449B2C970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512802, 'LS61', 'NL32-04', NULL, 'ARDON', 'Ardon', 'Ardon', '010100002015550000B343B094BCDD21419E3602D3A572FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512808, 'MS99', 'NL32-05', NULL, 'ARGSEELI', 'Argseeli', 'Argseeli', '010100002015550000B66A53B73DC9254120A4DAA56ADA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512809, 'MT06', 'NL32-01', NULL, 'ARISDORF', 'Arisdorf', 'Arisdorf', '010100002015550000ACEC52108B10234137B28DA64F0C1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512810, 'MT53', 'NL32-02', NULL, 'ARISTAU', 'Aristau', 'Aristau', '010100002015550000F8797D380274244171DCFAF543F90C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512811, 'LT95', 'NL32-01', NULL, 'ARLESHEIM', 'Arlesheim', 'Arlesheim', '0101000020155500004671DCBD56B8224146ECA9F4AAA30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512813, 'LS17', 'NL32-04', NULL, 'ARNEX', 'Arnex', 'Arnex', '0101000020155500009C99100A9F282041514A6346B70E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512814, 'LS99', 'NL32-04', NULL, 'ARNI', 'Arni', 'Arni', '010100002015550000827F3FAE3FCD22411E7D6F44022D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512817, 'MS48', 'NL32-05', NULL, 'ARNIALP', 'Arni Alp', 'Arni Alp', '010100002015550000BFFF5C013F332441808C196305A10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512818, 'MR98', 'NL32-08', NULL, 'AROGNO', 'Arogno', 'Arogno', '010100002015550000E2A1EA5C26ED25416ABC4ABFA5F0F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512819, 'LR89', 'NL32-04', NULL, 'AROLLA', 'Arolla', 'Arolla', '010100002015550000B4DE69AE876A2241C3CB745F9EEBF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512820, 'NS58', 'NL32-05', NULL, 'AROSA', 'Arosa', 'Arosa', '01010000201555000063429D1D8C8027411F45D99BB46E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512823, 'MR99', 'NL32-05', NULL, 'AROSIO', 'Arosio', 'Arosio', '0101000020155500002FF31CB626C325413A16D0642AA1F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512824, 'NS39', 'NL32-05', NULL, 'ARTASCHIEW', 'Artaschiew', 'Artaschiew', '010100002015550000613F8C6D06242741BEFFFB75EC330841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512825, 'MT61', 'NL32-02', NULL, 'ARTH', 'Arth', 'Arth', '0101000020155500003010E39F3ECF2441279DEE5D1D0D0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512829, 'LS52', 'NL32-04', NULL, 'ARVEYES', 'Arveyes', 'Arveyes', '01010000201555000082E8408D856F21411A8733F2CCB8FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512830, 'NS02', 'NL32-05', NULL, 'ARVIGO', 'Arvigo', 'Arvigo', '010100002015550000A95F9C9380412641A154AFDBB37EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512831, 'KS84', 'NL32-04', NULL, 'ARZIER', 'Arzier', 'Arzier', '0101000020155500006E782ADF71D01E4140A0DC7EABEE0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512833, 'MR98', 'NL32-08', NULL, 'ARZO', 'Arzo', 'Arzo', '0101000020155500003A685F0C10DA25416C58C5E96A1EF440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512834, 'MS64', 'NL32-05', NULL, 'ARZO', 'Arzo', 'Arzo', '01010000201555000035C8D01C99CC2441620DF51478AE0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512835, 'NS69', 'NL32-05', NULL, 'ASCHARINA', 'Ascharina', 'Ascharina', '010100002015550000F0D97DBDB3CB27414164C272C1BA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512837, 'MS81', 'NL32-05', NULL, 'ASCONA', 'Ascona', 'Ascona', '010100002015550000F253E5B61071254157965240634CFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512838, 'LS16', 'NL32-04', NULL, 'ASSENS', 'Assens', 'Assens', '0101000020155500009C6445069C6320410CE7AE3093EA0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512839, 'MR89', 'NL32-05', NULL, 'ASTANO', 'Astano', 'Astano', '0101000020155500004330AC6D4691254179990F064FB2F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512840, 'LT64', 'NL32-01', NULL, 'ASUEL', 'Asuel', 'Asuel', '01010000201555000045734882B9C2214174052D469C480E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512841, 'LS35', 'NL32-04', NULL, 'ATTALENS', 'Attalens', 'Attalens', '010100002015550000EE690A1996EE2041A80D7017298A0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512842, 'MS79', 'NL32-05', NULL, 'ATTINGHAUSEN', 'Attinghausen', 'Attinghausen', '010100002015550000B665860A310D2541DA3C9330C9590741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512843, 'LT93', 'NL32-01', NULL, 'ATTISWIL', 'Attiswil', 'Attiswil', '010100002015550000C11DCA1BF8AE22413EC128AAFA3E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512844, 'MT73', 'NL32-02', NULL, 'AU', 'Au', 'Au', '0101000020155500007A25B00845122541D6E8929818540C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512845, 'MT94', 'NL32-02', NULL, 'AU', 'Au', 'Au', '01010000201555000008FFB70B13CB2541EC1D0ADD136A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512846, 'NT45', 'NL32-02', NULL, 'AU', 'Au', 'Au', '0101000020155500000893CC760E53274113EB6A91B93C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512847, 'LT96', 'NL32-01', NULL, 'AU', 'Au', 'Au', '01010000201555000029549BAECFCB2241F1E45021C0451041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512849, 'LS05', 'NL32-04', NULL, 'AUBONNE', 'Aubonne', 'Aubonne', '01010000201555000086011ADBD7C01F41D783B3E095210241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512852, 'MT35', 'NL32-02', NULL, 'AUENSTEIN', 'Auenstein', 'Auenstein', '01010000201555000018C5B52A14E923419E3CA5FBCCC20E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512853, 'MS47', 'NL32-05', NULL, 'AUFDEMSTOCK', 'Auf dem Stock', 'Auf dem Stock', '010100002015550000AE8EDC55302A2441E49AD8AB3B450541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512854, 'NS39', 'NL32-05', NULL, 'AUFDERHOHE', 'Auf der Hohe', 'Auf der Hohe', '01010000201555000053CE58359EDE26411242F137C62C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512855, 'NS03', 'NL32-05', NULL, 'AUGIO', 'Augio', 'Augio', '010100002015550000A583048D43402641D5E69755E4A60041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512856, 'MT06', 'NL32-01', NULL, 'AUGST', 'Augst', 'Augst', '010100002015550000D3C967A011F3224131E749070A291041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512861, 'LS38', 'NL32-04', NULL, 'AUMONT', 'Aumont', 'Aumont', '010100002015550000B30C44CE6FF0204110EB5C946B620641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512862, 'MS71', 'NL32-05', NULL, 'AURESSIO', 'Auressio', 'Auressio', '010100002015550000C80AA721153E2541C3F9039023A1FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512863, 'MS72', 'NL32-05', NULL, 'AURIGENO', 'Aurigeno', 'Aurigeno', '010100002015550000E132ADB1AA472541A3CE4BC4FC89FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512864, 'MS33', 'NL32-05', NULL, 'AUSSERBINN', 'Ausserbinn', 'Ausserbinn', '0101000020155500005E2F9A6609FB23412E3881C564BD0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512865, 'MT86', 'NL32-02', NULL, 'AUSSERDINHARD', 'Ausserdinhard', 'Ausserdinhard', '010100002015550000AE31CF287C5C25411B51F4F3A0521041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512866, 'MT72', 'NL32-02', NULL, 'AUSSEREALTMATT', 'Äussere Altmatt', 'Aussere Altmatt', '0101000020155500002025C3001A3B2541B0218D282FFB0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512867, 'NS35', 'NL32-05', NULL, 'AUSSERFERRERA', 'Ausserferrera', 'Ausserferrera', '010100002015550000C10400988BFA2641BBF086DB64350341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512868, 'NS27', 'NL32-05', NULL, 'AUSSERGLAS', 'Ausserglas', 'Ausserglas', '010100002015550000BC6EB1EECEC52641331D6ED279FF0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512869, 'LS70', 'NL32-04', NULL, 'AUSSERHOLLIGEN', 'Ausserholligen', 'Ausserholligen', '010100002015550000F08A82BF2438224133274B0E0147F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512870, 'LS96', 'NL32-04', NULL, 'AUSSERLATTERBACH', 'Ausser Latterbach', 'Ausser Latterbach', '010100002015550000A90070E6F9AF2241CEA909C2538E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512872, 'MT64', 'NL32-02', NULL, 'AUSSERSIHL', 'Aussersihl', 'Aussersihl', '0101000020155500003DBDD28E55DF2441B0DA1C9F66200E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512873, 'LS47', 'NL32-04', NULL, 'AUTIGNY', 'Autigny', 'Autigny', '01010000201555000034017A0E8653214139573DB741780541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512874, 'LT30', 'NL32-04', NULL, 'AUVERNIER', 'Auvernier', 'Auvernier', '01010000201555000000B2C3316FFB2041A9104E441EA50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512875, 'MT52', 'NL32-02', NULL, 'AUW', 'Auw', 'Auw', '0101000020155500009290D47FB17424411475C52CA9110C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512877, 'MS71', 'NL32-05', NULL, 'AVEGNO', 'Avegno', 'Avegno', '0101000020155500002DEFE3333B5C254123287FE20AA5FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512878, 'LS59', 'NL32-04', NULL, 'AVENCHES', 'Avenches', 'Avenches', '01010000201555000011BA385913682141F94DB77AF0800741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512883, 'LS58', 'NL32-04', NULL, 'AVRY', 'Avry', 'Avry', '010100002015550000868F724E9671214181F7A91859250641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512886, 'MT70', 'NL32-05', NULL, 'AXENSTEIN', 'Axenstein', 'Axenstein', '010100002015550000DEF8DDA0AB0B2541A47807570CEF0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512887, 'LS72', 'NL32-04', NULL, 'AYENT', 'Ayent', 'Ayent', '010100002015550000D275914A44422241A71887668BB4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512888, 'LS91', 'NL32-04', NULL, 'AYER', 'Ayer', 'Ayer', '010100002015550000BDF25CCAD5B02241B00AA24B89FEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512889, 'MT62', 'NL32-02', NULL, 'BAAR', 'Baar', 'Baar', '01010000201555000056E02A5EA7CD244163AD0FB54CDC0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512890, 'MT72', 'NL32-02', NULL, 'BACH', 'Bäch', 'Bach', '010100002015550000F5790994E64D2541ACBD9E600EE40B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512891, 'MT66', 'NL32-02', NULL, 'BACHENBULACH', 'Bachenbülach', 'Bachenbulach', '0101000020155500003CA3F44EE2D3244138532DEA11EF0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512892, 'LS96', 'NL32-04', NULL, 'BACHLEN', 'Bächlen', 'Bachlen', '0101000020155500006C2314FA179C22419B749EF0611A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512893, 'MT56', 'NL32-02', NULL, 'BACHS', 'Bachs', 'Bachs', '01010000201555000046998F24D7982441E7C40E9DEB121041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512895, 'MS02', 'NL32-04', NULL, 'BACHTOLEN', 'Bachtolen', 'Bachtolen', '01010000201555000063B1FB3A15292341D7A8CBF884B8FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512896, 'MT45', 'NL32-02', NULL, 'BADEN', 'Baden', 'Baden', '010100002015550000D811622DDC4A2441CF3AE75A69740F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512899, 'NT30', 'NL32-02', NULL, 'BADRAGAZ', 'Bad Ragaz', 'Bad Ragaz', '010100002015550000F7C1E953351827412F16F4D348540941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512901, 'LS66', 'NL32-04', NULL, 'BADSCHWARZSEE', 'Bad-Schwarzsee', 'Bad-Schwarzsee', '010100002015550000340B2D66A5F2214174166B984E8E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512903, 'LS60', 'NL32-04', NULL, 'BAGNES', 'Bagnes', 'Bagnes', '010100002015550000D1847AC958C92141BE0800EC7C48F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512911, 'NT30', 'NL32-05', NULL, 'BALEN', 'Balen', 'Balen', '010100002015550000D258508CAF0E274124423A975D190941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512912, 'NR07', 'NL32-08', NULL, 'BALERNA', 'Balerna', 'Balerna', '010100002015550000D2EE35911103264166F59FB1293DF340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512916, 'NT45', 'NL32-02', NULL, 'BALGACH', 'Balgach', 'Balgach', '010100002015550000C62B68C7A2492741E2CAB185C0010F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512917, 'LS07', 'NL32-04', NULL, 'BALLAIGUES', 'Ballaigues', 'Ballaigues', '0101000020155500001A87450581DA1F4105C57A8378850541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512919, 'KS95', 'NL32-04', NULL, 'BALLENS', 'Ballens', 'Ballens', '01010000201555000067AC44E56F9A1F416A96E7713C0A0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512920, 'MT42', 'NL32-02', NULL, 'BALLWIL', 'Ballwil', 'Ballwil', '0101000020155500006D6A5BE2C05724416617A845B2280B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512921, 'MS27', 'NL32-05', NULL, 'BALM', 'Balm', 'Balm', '010100002015550000D70818F35AD02341DD81E727BEB50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512922, 'LT81', 'NL32-01', NULL, 'BALMBEIMESSEN', 'Balm bei Messen', 'Balm bei Messen', '0101000020155500009BEFEFD65B4C22418C8BA2F45B6F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512924, 'MS88', 'NL32-05', NULL, 'BALMENEGG', 'Balmenegg', 'Balmenegg', '010100002015550000B3324D67C16725414DD97571083E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512927, 'MT04', 'NL32-01', NULL, 'BALSTHAL', 'Balsthal', 'Balsthal', '01010000201555000003A64F690BE022410DB9C8B503610D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512928, 'MT75', 'NL32-02', NULL, 'BALTENSWIL', 'Baltenswil', 'Baltenswil', '0101000020155500008C27FB9AAB19254180AF58BF98D10E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512929, 'MS12', 'NL32-04', NULL, 'BALTSCHIEDER', 'Baltschieder', 'Baltschieder', '0101000020155500001AFA2A4A2551234194ED1D90ED2DFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512931, 'MR89', 'NL32-05', NULL, 'BANCO', 'Banco', 'Banco', '0101000020155500008E6C33A7B3A52541E0D20B8B6541F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512932, 'LT81', 'NL32-01', NULL, 'BANGERTEN', 'Bangerten', 'Bangerten', '010100002015550000198A4086096A224182B652DAADC10941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512933, 'MT03', 'NL32-01', NULL, 'BANNWIL', 'Bannwil', 'Bannwil', '01010000201555000028786D62FDF3224135559BDBBF3F0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512935, 'MS09', 'NL32-04', NULL, 'BARAU', 'Bärau', 'Barau', '0101000020155500008A0C7A3767302341CF2221AF7E2E0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512936, 'LS69', 'NL32-04', NULL, 'BARBERECHE', 'Barberêche', 'Barbereche', '010100002015550000048516707FAD2141882C067BDD450741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512937, 'LS40', 'NL32-04', NULL, 'BARBERINE', 'Barberine', 'Barberine', '01010000201555000048EE5B340228214117D2E10BC166F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512941, 'MT84', 'NL32-02', NULL, 'BARETSWIL', 'Bäretswil', 'Baretswil', '010100002015550000F7D05A09DF902541FF1E9D40FDB70D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512942, 'LT80', 'NL32-01', NULL, 'BARISWIL', 'Bäriswil', 'Bariswil', '0101000020155500002AA8B988DA7D2241BFF8E884EF4D0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512943, 'LS90', 'NL32-04', NULL, 'BARMA', 'Barma', 'Barma', '0101000020155500008D5928E30CC52241CA5373DC81A3FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512946, 'LS31', 'NL32-04', NULL, 'BARME', 'Barme', 'Barme', '01010000201555000054C014B921E22041CF261EC37721FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512949, 'LT84', 'NL32-01', NULL, 'BARSCHWIL', 'Bärschwil', 'Barschwil', '010100002015550000FB7FF1130B602241C26551F1C1470E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512953, 'MT87', 'NL32-02', NULL, 'BASADINGEN', 'Basadingen', 'Basadingen', '010100002015550000C4767CA9FD502541EC082671F61C1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512954, 'LT96', 'NL32-01', 1, 'BASEL', 'Basel', 'Basel', '010100002015550000E16AE67360AE224186AE5A1C91621041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512965, 'LT64', 'NL32-01', NULL, 'BASSECOURT', 'Bassecourt', 'Bassecourt', '0101000020155500001B2DC02F50D62141CCE71FAE92D40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512966, 'LS61', 'NL32-04', NULL, 'BASSENENDAZ', 'Basse-Nendaz', 'Basse-Nendaz', '010100002015550000DDC10A10DDFB2141D13515FE57FEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512967, 'MT75', 'NL32-02', NULL, 'BASSERSDORF', 'Bassersdorf', 'Bassersdorf', '010100002015550000DDCC7FDC950525415258441634440F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512969, 'NS39', 'NL32-05', NULL, 'BATANJA', 'Batänja', 'Batanja', '010100002015550000AB0315837D1A274177F17BF5FEF80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512970, 'LT81', 'NL32-01', NULL, 'BATTERKINDEN', 'Bätterkinden', 'Batterkinden', '010100002015550000814D5D5EA6872241761BCA1765A90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512971, 'MS69', 'NL32-05', NULL, 'BAUEN', 'Bauen', 'Bauen', '01010000201555000034AC0A537EF82441F9070C7630400841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512972, 'LS18', 'NL32-04', NULL, 'BAULMES', 'Baulmes', 'Baulmes', '010100002015550000FDFCA2686A33204190B1B9F3BA2F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512973, 'MT84', 'NL32-02', NULL, 'BAUMA', 'Bauma', 'Bauma', '0101000020155500000CAA4F312F9A2541A11FF8187F2C0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512975, 'NT45', 'NL32-02', NULL, 'BAURIET', 'Bauriet', 'Bauriet', '010100002015550000E8FA8C3DA03E2741759A32A055AE0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512976, 'LS17', 'NL32-04', NULL, 'BAVOIS', 'Bavois', 'Bavois', '010100002015550000F35EF27A5546204141B2F79073D30441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512978, 'NS36', 'NL32-05', NULL, 'BAVUGLS', 'Bavugls', 'Bavugls', '01010000201555000057AC0987630D27417912578F14E50341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512980, 'NT04', 'NL32-02', NULL, 'BAZENHEID', 'Bazenheid', 'Bazenheid', '01010000201555000008C21659960F26419AB071207BA90E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512982, 'MS07', 'NL32-04', NULL, 'BEATENBERG', 'Beatenberg', 'Beatenberg', '010100002015550000844BB2F9751D2341B213F6CD88030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512984, 'MT50', 'NL32-05', NULL, 'BECKENRIED', 'Beckenried', 'Beckenried', '01010000201555000045FF5E5BB6B22441E82FA49923B00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512987, 'NS68', 'NL32-05', NULL, 'BEDRA', 'Bedra', 'Bedra', '0101000020155500003670E0E54C01284186E36985F9B70641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512988, 'MS64', 'NL32-05', NULL, 'BEDRETTO', 'Bedretto', 'Bedretto', '0101000020155500008DBCE7C202CC24416C07DA19265C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512990, 'MT69', 'NL32-02', NULL, 'BEGGINGEN', 'Beggingen', 'Beggingen', '010100002015550000F2770C4235DA24418D74DB0605E41141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512991, 'KS84', 'NL32-04', NULL, 'BEGNINS', 'Begnins', 'Begnins', '010100002015550000B0C1B9B3910B1F41A02FB4D906790141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512992, 'NS67', 'NL32-05', NULL, 'BEIDERSAGE', 'Bei der Säge', 'Bei der Sage', '0101000020155500001C46BFBA60E427419423C7D98C400641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512995, 'MT33', 'NL32-02', NULL, 'BEINWIL', 'Beinwil', 'Beinwil', '010100002015550000AFE91856A5112441A6C7BA541FBB0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512996, 'LT94', 'NL32-01', NULL, 'BEINWIL', 'Beinwil', 'Beinwil', '0101000020155500005768178FE5A42241C7B51289260E0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512997, 'MS23', 'NL32-04', NULL, 'BELALP', 'Belalp', 'Belalp', '0101000020155500003F413E2EF38C2341DD9A31A604800041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512998, 'LS58', 'NL32-04', NULL, 'BELFAUX', 'Belfaux', 'Belfaux', '01010000201555000018C9514599852141B675F433C9980641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512999, 'NS56', 'NL32-05', NULL, 'BELLALUNA', 'Bellaluna', 'Bellaluna', '010100002015550000E7C2E966C3972741C9B9F077FAA10441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513001, 'LT50', 'NL32-04', NULL, 'BELLECHASSE', 'Bellechasse', 'Bellechasse', '010100002015550000D52BA1B829862141DE890795E3A10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513002, 'LT63', 'NL32-01', NULL, 'BELLELAY', 'Bellelay', 'Bellelay', '010100002015550000BF1B1108B5AE2141C1D45C6486B30C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513003, 'LS59', 'NL32-04', NULL, 'BELLERIVE', 'Bellerive', 'Bellerive', '0101000020155500002364180B4D5E2141689DA900F1F40741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513004, 'KS82', 'NL32-04', NULL, 'BELLEVUE', 'Bellevue', 'Bellevue', '010100002015550000D1197C9ABA8E1E413F331BFED573FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513005, 'NS01', 'NL32-05', 3, 'BELLINZONA', 'Bellinzona', 'Bellinzona', '010100002015550000B4A0644D110726410FA6596E11BEFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513006, 'LT61', 'NL32-01', NULL, 'BELLMUND', 'Bellmund', 'Bellmund', '010100002015550000CCB961B2C7D5214103A646C6E7A90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513007, 'MS34', 'NL32-05', NULL, 'BELLWALD', 'Bellwald', 'Bellwald', '010100002015550000F7E46FABA4FA2341D83B3AFD146B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513009, 'LS25', 'NL32-04', NULL, 'BELMONTSURLAUSANNE', 'Belmont-sur-Lausanne', 'Belmont-sur-Lausanne', '010100002015550000E3E9B84DCB942041129BBE0A1BC70241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513010, 'LS89', 'NL32-04', NULL, 'BELP', 'Belp', 'Belp', '010100002015550000801322F10A74224115672777B07E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513012, 'MS55', 'NL32-05', NULL, 'BELVEDERE', 'Belvédère', 'Belvedere', '010100002015550000BD9450DA598524419800475E26400341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513013, 'NT02', 'NL32-02', NULL, 'BENKEN', 'Benken', 'Benken', '01010000201555000052EDDF6E99F52541AB946A8B56F00B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513014, 'MT77', 'NL32-02', NULL, 'BENKEN', 'Benken', 'Benken', '01010000201555000004A099908A162541579396711FFE1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513015, 'LS27', 'NL32-04', NULL, 'BERCHER', 'Bercher', 'Bercher', '0101000020155500005247AB231EA02041129C9CE7B2090541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513016, 'NT17', 'NL32-02', NULL, 'BERG', 'Berg', 'Berg', '01010000201555000034820CD60A472641D64DCB55B0951041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513018, 'NS56', 'NL32-05', NULL, 'BERGUN', 'Bergün', 'Bergun', '01010000201555000064CB1AC281B6274168E2D478B7310441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513019, 'MT54', 'NL32-02', NULL, 'BERIKON', 'Berikon', 'Berikon', '0101000020155500003658086D297D2441D0218A2058E10D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513020, 'MT68', 'NL32-02', NULL, 'BERINGEN', 'Beringen', 'Beringen', '010100002015550000864461A001E524418CCE0B9086531141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513021, 'MS22', 'NL32-05', NULL, 'BERISAL', 'Berisal', 'Berisal', '01010000201555000048EAC3DC9CBF2341D926D8D8F9BFFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513023, 'LS89', 'NL32-04', 1, 'BERN', 'Bern', 'Bern', '010100002015550000043A0EEB2E602241F749317672F20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513029, 'NT45', 'NL32-02', NULL, 'BERNECK', 'Berneck', 'Berneck', '010100002015550000C62B68C7A2492741E2CAB185C0010F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513035, 'KS71', 'NL32-04', NULL, 'BERNEX', 'Bernex', 'Bernex', '0101000020155500006DE9C784ED3B1E4184596D285B36FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513044, 'NS74', 'NL32-05', NULL, 'BERNINAHAUSER', 'Berninahäuser', 'Berninahauser', '0101000020155500002A37EC44C53C284170CB241E07FF0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513047, 'MT32', 'NL32-02', NULL, 'BEROMUNSTER', 'Beromünster', 'Beromunster', '010100002015550000529B0073570824419557237422D30B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513049, 'NT21', 'NL32-02', NULL, 'BERSCHIS', 'Berschis', 'Berschis', '0101000020155500003E6E7CFAFDBC264140C564FF91A60A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513050, 'MS81', 'NL32-05', NULL, 'BERZONA', 'Berzona', 'Berzona', '0101000020155500006335530E51A22541B63AED1D8722FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513055, 'NS09', 'NL32-05', NULL, 'BETSCHWANDEN', 'Betschwanden', 'Betschwanden', '010100002015550000A71CC16DF7F925410FAAA874F88B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513056, 'LS75', 'NL32-04', NULL, 'BETTELRIED', 'Bettelried', 'Bettelried', '010100002015550000289906F8592E2241A4200182CABE0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513057, 'MS23', 'NL32-05', NULL, 'BETTEN', 'Betten', 'Betten', '0101000020155500008334920BF4C82341177B5D4AAFBB0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513058, 'LT97', 'NL32-01', NULL, 'BETTINGEN', 'Bettingen', 'Bettingen', '0101000020155500007E8D43D7B1CB224177E66EF19D9C1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513059, 'LT82', 'NL32-01', NULL, 'BETTLACH', 'Bettlach', 'Bettlach', '010100002015550000AA081CDB7F42224104498014CACA0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513060, 'LS61', 'NL32-04', NULL, 'BEUSON', 'Beuson', 'Beuson', '0101000020155500005EB82F77D6FB21412EF08AF18B8AFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513061, 'LT30', 'NL32-04', NULL, 'BEVAIX', 'Bevaix', 'Bevaix', '010100002015550000C8C3EA247ADD20415A0EE7C239320841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513063, 'NS65', 'NL32-05', NULL, 'BEVERS', 'Bevers', 'Bevers', '010100002015550000301D2CE01008284138F56288E8530341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513064, 'LT73', 'NL32-01', NULL, 'BEVILARD', 'Bévilard', 'Bevilard', '0101000020155500004F4DAB7EA0F321411411EC93F53E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513065, 'LS42', 'NL32-04', NULL, 'BEX', 'Bex', 'Bex', '01010000201555000057A90565425121413D351EA46ED2FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513066, 'MT46', 'NL32-02', NULL, 'BEZNAU', 'Beznau', 'Beznau', '0101000020155500006BE99E7F1C2D24411D186FFAF7E60F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513069, 'MS93', 'NL32-05', NULL, 'BIASCA', 'Biasca', 'Biasca', '0101000020155500007558863462E62541962D8148A2650041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513070, 'MS84', 'NL32-05', NULL, 'BIASCHINA', 'Biaschina', 'Biaschina', '010100002015550000A4F6B718F0A82541F04797D08B820141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513074, 'MT72', 'NL32-02', NULL, 'BIBERBRUCKE', 'Biberbrücke', 'Biberbrucke', '010100002015550000E2B4B53CBE44254176469640B8350B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513075, 'LS69', 'NL32-04', NULL, 'BIBEREN', 'Biberen', 'Biberen', '0101000020155500006FE2651C72CB2141A4B68A4F172D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513076, 'LT92', 'NL32-01', NULL, 'BIBERIST', 'Biberist', 'Biberist', '0101000020155500006D0DB83373912241CCE433A40F910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513077, 'MT79', 'NL32-02', NULL, 'BIBERN', 'Bibern', 'Bibern', '0101000020155500006170415A7F282541AA9E86DF68C91141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513078, 'NS03', 'NL32-05', NULL, 'BIBORGO', 'Biborgo', 'Biborgo', '010100002015550000A047FF19E5172641802546BB6ADD0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513079, 'MT95', 'NL32-02', NULL, 'BICHELSEE', 'Bichelsee', 'Bichelsee', '010100002015550000C18AACFB23C025412B36EB2CEA500F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513080, 'MS90', 'NL32-05', NULL, 'BIDOGNO', 'Bidogno', 'Bidogno', '010100002015550000E8435CFCF6F425412350EBDC7090F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513081, 'MS34', 'NL32-05', NULL, 'BIEL', 'Biel', 'Biel', '0101000020155500003F3EEB65861824417B9E65BA1AA60141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513082, 'LT62', 'NL32-01', 2, 'BIEL', 'Biel', 'Biel', '010100002015550000EAA08E48C4DF21419413322284570B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513086, 'KS95', 'NL32-04', NULL, 'BIERE', 'Bière', 'Biere', '010100002015550000A4D616E97E721F41FB7AA9A8580B0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513090, 'LT90', 'NL32-04', NULL, 'BIGENTHAL', 'Bigenthal', 'Bigenthal', '0101000020155500001351AF9662B922411215A9D1B6660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513091, 'LS99', 'NL32-04', NULL, 'BIGLEN', 'Biglen', 'Biglen', '01010000201555000085875AF56AB922411E06A715D02C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513092, 'MS73', 'NL32-05', NULL, 'BIGNASCO', 'Bignasco', 'Bignasco', '01010000201555000092DA4091ED132541345FFB5D1D570041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513093, 'MS90', 'NL32-05', NULL, 'BIGORIO', 'Bigorio', 'Bigorio', '01010000201555000050433D471AE12541F5859A8E8619F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513094, 'NT02', 'NL32-02', NULL, 'BILTEN', 'Bilten', 'Bilten', '0101000020155500003BBCBC0979F6254157EA1022A9420B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513095, 'MS33', 'NL32-05', NULL, 'BINN', 'Binn', 'Binn', '0101000020155500002B04EC0E350F2441458828BE3D840041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513102, 'LT96', 'NL32-01', NULL, 'BINNINGEN', 'Binningen', 'Binningen', '010100002015550000B9B1B09CD39A2241B7B0809395281041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513105, 'MR99', 'NL32-05', NULL, 'BIOGGIO', 'Bioggio', 'Bioggio', '010100002015550000F0D18E829BB92541FE2B14421DB8F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513106, 'LS16', 'NL32-04', NULL, 'BIOLEYORJULAZ', 'Bioley-Orjulaz', 'Bioley-Orjulaz', '0101000020155500009C6445069C6320410CE7AE3093EA0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513107, 'MT54', 'NL32-02', NULL, 'BIRMENSDORF', 'Birmensdorf', 'Birmensdorf', '010100002015550000806DE3E1AC9A244177561791CDE20D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513109, 'MT45', 'NL32-02', NULL, 'BIRMENSTORF', 'Birmenstorf', 'Birmenstorf', '0101000020155500005341106D8F2D24410C23321B40390F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513110, 'MS90', 'NL32-05', NULL, 'BIRONICO', 'Bironico', 'Bironico', '0101000020155500000C2281387AD6254116B33F1189FFF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513111, 'MT35', 'NL32-02', NULL, 'BIRR', 'Birr', 'Birr', '0101000020155500001733F9E53D10244134AD4EFB29FE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513113, 'MT33', 'NL32-02', NULL, 'BIRRWIL', 'Birrwil', 'Birrwil', '010100002015550000CF2CC8648111244172D0916B06F50C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513115, 'LT96', 'NL32-01', NULL, 'BIRSFELDEN', 'Birsfelden', 'Birsfelden', '010100002015550000C34BF24135B8224170F4A953A7451041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513117, 'MS78', 'NL32-05', NULL, 'BIRTSCHEN', 'Birtschen', 'Birtschen', '010100002015550000F86F7BE67D2125413246AC2B35E70641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513118, 'NT06', 'NL32-02', NULL, 'BISSEGG', 'Bissegg', 'Bissegg', '01010000201555000052F7655EC9022641A08A011ED2751041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513119, 'MR98', 'NL32-08', NULL, 'BISSONE', 'Bissone', 'Bissone', '010100002015550000E2A1EA5C26ED25416ABC4ABFA5F0F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513120, 'MS23', 'NL32-04', NULL, 'BITSCH', 'Bitsch', 'Bitsch', '01010000201555000031ABE4170C8D23415484A9F01E460041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513121, 'NS44', 'NL32-05', NULL, 'BIVIO', 'Bivio', 'Bivio', '01010000201555000025430A275C7E274194C9A3C6EF210241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513132, 'NS39', 'NL32-05', NULL, 'BLAS', 'Bläs', 'Blas', '010100002015550000E765B9B3700F2741AF6C2D149AA50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513133, 'MR09', 'NL32-04', NULL, 'BLATTEN', 'Blatten', 'Blatten', '01010000201555000033C2D6FEDC012341B749B460A006F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513134, 'MS23', 'NL32-04', NULL, 'BLATTEN', 'Blatten', 'Blatten', '010100002015550000A2A2F0F6119723419C1D210965460041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513135, 'MS04', 'NL32-04', NULL, 'BLATTEN', 'Blatten', 'Blatten', '010100002015550000AFD9E2B68F322341D8856EACA12B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513136, 'MT41', 'NL32-02', NULL, 'BLATTEN', 'Blatten', 'Blatten', '010100002015550000CCB919C426312441EF5AF87D98CB0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513137, 'LT85', 'NL32-01', NULL, 'BLAUEN', 'Blauen', 'Blauen', '01010000201555000021823DCE7B7D224120D45DDC772F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513140, 'LS95', 'NL32-04', NULL, 'BLAUSEE', 'Blausee', 'Blausee', '0101000020155500000F4672A32BD8224136077AFA87BF0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513148, 'MS34', 'NL32-05', NULL, 'BLITZINGEN', 'Blitzingen', 'Blitzingen', '01010000201555000076FEDF4B850E244191079B73B8A50141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513149, 'LS34', 'NL32-04', NULL, 'BLONAY', 'Blonay', 'Blonay', '01010000201555000047AFED95430C2141443E4AF39ADB0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513150, 'LS87', 'NL32-04', NULL, 'BLUMENSTEIN', 'Blumenstein', 'Blumenstein', '01010000201555000012C898480C882241E240CA86AA750541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513153, 'MS46', 'NL32-05', NULL, 'BODEN', 'Boden', 'Boden', '01010000201555000073819FA7B53E2441E9E3B5C5785E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513154, 'MS69', 'NL32-05', NULL, 'BODEN', 'Boden', 'Boden', '010100002015550000E24E5D8B56F924411C2060479C580741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513156, 'MS93', 'NL32-05', NULL, 'BODIO', 'Bodio', 'Bodio', '01010000201555000062DFB44B07BE25415E285B95779C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513159, 'NS54', 'NL32-05', NULL, 'BOGIA', 'Bögia', 'Bogia', '010100002015550000B23C7DEB5A922741A34E2A7E35240241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513160, 'KS83', 'NL32-04', NULL, 'BOGISBOSSEY', 'Bogis-Bossey', 'Bogis-Bossey', '010100002015550000B527B04627A51E4104333145B75A0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513161, 'NS00', 'NL32-05', NULL, 'BOGNO', 'Bogno', 'Bogno', '0101000020155500000134E926042726410A03127E5C0CFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513162, 'MS82', 'NL32-05', NULL, 'BOLASTRO', 'Bolastro', 'Bolastro', '010100002015550000927A5239DC6E2541DD6443D2695EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513163, 'NS68', 'NL32-05', NULL, 'BOLGEN', 'Bolgen', 'Bolgen', '01010000201555000049B7335BFFD9274109690E8C36790641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513164, 'LT80', 'NL32-04', NULL, 'BOLL', 'Boll', 'Boll', '01010000201555000057701E44BC91224182EF96606C660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513166, 'LT80', 'NL32-04', NULL, 'BOLLIGEN', 'Bolligen', 'Bolligen', '010100002015550000B64C0DDD136A2241A85ECB452BA00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513168, 'LS76', 'NL32-04', NULL, 'BOLTIGEN', 'Boltigen', 'Boltigen', '010100002015550000AF5932EB692E2241928696322F1A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513169, 'MS69', 'NL32-05', NULL, 'BOLZBACH', 'Bolzbach', 'Bolzbach', '0101000020155500005084436FEAF8244152B94E4A66CC0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513170, 'NS38', 'NL32-05', NULL, 'BONADUZ', 'Bonaduz', 'Bonaduz', '010100002015550000A30D5D0BCAE02641297C2FAE7AD10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513171, 'LT56', 'NL32-01', NULL, 'BONCOURT', 'Boncourt', 'Boncourt', '010100002015550000A36410991D572141078C26D8CADF0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513172, 'LT66', 'NL32-01', NULL, 'BONFOL', 'Bonfol', 'Bonfol', '010100002015550000BD0082628CA521415C2E7DDF74A40F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513173, 'MS17', 'NL32-04', NULL, 'BONIGEN', 'Bönigen', 'Bonigen', '01010000201555000014802B4D41632341EC1201E010CB0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513174, 'MT34', 'NL32-02', NULL, 'BONISWIL', 'Boniswil', 'Boniswil', '010100002015550000E8CB815D61072441BAA2144874680D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513176, 'LS67', 'NL32-04', NULL, 'BONNEFONTAINE', 'Bonnefontaine', 'Bonnefontaine', '010100002015550000ACE1D5DCFFC02141CCCF101568760541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513178, 'MT54', 'NL32-02', NULL, 'BONSTETTEN', 'Bonstetten', 'Bonstetten', '010100002015550000641EACECBAAE2441F07CDC9E03700D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513179, 'LS29', 'NL32-04', NULL, 'BONVILLARS', 'Bonvillars', 'Bonvillars', '010100002015550000A678700E878320417FE544B4E9130741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513180, 'KS84', 'NL32-04', NULL, 'BOREX', 'Borex', 'Borex', '010100002015550000AC567FF31FBA1E41D38A48E6D9CD0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513182, 'MS71', 'NL32-05', NULL, 'BORGNONE', 'Borgnone', 'Borgnone', '010100002015550000C6B6CBD25F20254159ECC33ED2B5FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513183, 'NS43', 'NL32-05', NULL, 'BORGONOVO', 'Borgonovo', 'Borgonovo', '01010000201555000075EB087C28632741FCED2E1675890041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513184, 'MS17', 'NL32-04', NULL, 'BORT', 'Bort', 'Bort', '010100002015550000727FFA0F3845234111D4EF15333E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513185, 'MS62', 'NL32-05', NULL, 'BOSCOGURIN', 'Bosco Gurin', 'Bosco Gurin', '0101000020155500005FA91EC422C4244175BADF2C92BDFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513187, 'LS69', 'NL32-04', NULL, 'BOSINGEN', 'Bösingen', 'Bosingen', '010100002015550000C805FA095DCB2141F64117194AB90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513190, 'LS26', 'NL32-04', NULL, 'BOTTENS', 'Bottens', 'Bottens', '0101000020155500006B86D86C8E772041D62B7323C1E90341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513191, 'MT23', 'NL32-02', NULL, 'BOTTENWIL', 'Bottenwil', 'Bottenwil', '010100002015550000782BAF884C9B234154D0D8CD0AF10C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513192, 'NT17', 'NL32-02', NULL, 'BOTTIGHOFEN', 'Bottighofen', 'Bottighofen', '0101000020155500009095D8E96F6326419E1D870BD9ED1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513193, 'LT96', 'NL32-01', NULL, 'BOTTMINGEN', 'Bottmingen', 'Bottmingen', '010100002015550000C8DA8F9ED99A2241A9EAF71DA10B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513194, 'MT46', 'NL32-02', NULL, 'BOTTSTEIN', 'Böttstein', 'Bottstein', '01010000201555000097DF3A620F19244163EF04B1F2491041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513195, 'LT31', 'NL32-01', NULL, 'BOUDEVILLIERS', 'Boudevilliers', 'Boudevilliers', '01010000201555000048E40014C1052141CFB6BC406F8C0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513196, 'LT30', 'NL32-04', NULL, 'BOUDRY', 'Boudry', 'Boudry', '0101000020155500005887DB1481E72041DAF2B280D06B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513197, 'LR68', 'NL32-07', NULL, 'BOURGSAINTPIERRE', 'Bourg-Saint-Pierre', 'Bourg-Saint-Pierre', '01010000201555000025CD58F5F9C821414FEDB3314C36F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513199, 'LS33', 'NL32-04', NULL, 'BOUVERET', 'Bouveret', 'Bouveret', '0101000020155500002F5BBC2CB7ED20416DE88220FCBA0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513200, 'LS50', 'NL32-04', NULL, 'BOVERNIER', 'Bovernier', 'Bovernier', '010100002015550000A184638CC47821416DEE877EDE4AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513201, 'LS99', 'NL32-04', NULL, 'BOWIL', 'Bowil', 'Bowil', '010100002015550000272640702BE122417FB96FE56FB90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513202, 'MT35', 'NL32-02', NULL, 'BOZEN', 'Bözen', 'Bozen', '0101000020155500001F5B2C2420CB2341889736F26BA90F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513203, 'NS76', 'NL32-06', NULL, 'BRAIL', 'Brail', 'Brail', '010100002015550000D8573609065F2841F26BC824A8BA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513205, 'LS72', 'NL32-04', NULL, 'BRAMOIS', 'Bramois', 'Bramois', '010100002015550000831EF394353822415A75094F2F59FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513206, 'NS16', 'NL32-05', NULL, 'BRAND', 'Brand', 'Brand', '010100002015550000261DC2503759264152D89987A7470441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513207, 'LS93', 'NL32-04', NULL, 'BRATSCH', 'Bratsch', 'Bratsch', '0101000020155500001C313E2DC6EC224160BC8C97349EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513209, 'MS99', 'NL32-05', NULL, 'BRAUNWALD', 'Braunwald', 'Braunwald', '010100002015550000C239A1366EE62541152CF19280500841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513210, 'NR09', 'NL32-05', NULL, 'BRE', 'Brè', 'Bre', '010100002015550000C44EAE0630002641918C982BEFC2F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513212, 'LR69', 'NL32-04', NULL, 'BRECHOLEY', 'Brecholey', 'Brecholey', '010100002015550000FED16C99B60522412CB24D9706ECF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513215, 'NS07', 'NL32-05', NULL, 'BREIL', 'Breíl', 'Breil', '0101000020155500000DF0AE67001B26416A4948C3A1110641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513216, 'MT75', 'NL32-02', NULL, 'BREITE', 'Breite', 'Breite', '010100002015550000C611BED3D02225412063987CE97F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513217, 'LT95', 'NL32-01', NULL, 'BREITENBACH', 'Breitenbach', 'Breitenbach', '0101000020155500008BCAAD5A2F9122416847FE71D6810E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513218, 'MS38', 'NL32-05', NULL, 'BREITENFELD', 'Breitenfeld', 'Breitenfeld', '0101000020155500003217EF790FDA23418C5FB288DE290641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513221, 'LT80', 'NL32-04', NULL, 'BREMGARTEN', 'Bremgarten', 'Bremgarten', '0101000020155500007962DAC841562241F63289080BDA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513222, 'MT44', 'NL32-02', NULL, 'BREMGARTEN', 'Bremgarten', 'Bremgarten', '0101000020155500009CA86AAA7B5F2441CAE1613ADD190E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513226, 'LS37', 'NL32-04', NULL, 'BRENLES', 'Brenles', 'Brenles', '01010000201555000022E013DFA2F9204168549296D6CC0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513228, 'MR99', 'NL32-05', NULL, 'BRENO', 'Breno', 'Breno', '010100002015550000C38E974557B92541EA8C0C9DE42BF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513229, 'LS98', 'NL32-04', NULL, 'BRENZIKOFEN', 'Brenzikofen', 'Brenzikofen', '010100002015550000BF4CF18BA5B9224120E38F5082970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513231, 'LT95', 'NL32-01', NULL, 'BRETZWIL', 'Bretzwil', 'Bretzwil', '01010000201555000077229F3329CC22411CB7020252820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513232, 'NS46', 'NL32-05', NULL, 'BRIENZ', 'Brienz', 'Brienz', '0101000020155500006640ABDB945B27416B2640D71CD50441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513233, 'MS27', 'NL32-05', NULL, 'BRIENZ', 'Brienz', 'Brienz', '010100002015550000BB64510466B22341D777DBE5B2EE0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513238, 'MS37', 'NL32-05', NULL, 'BRIENZWILER', 'Brienzwiler', 'Brienzwiler', '010100002015550000360713E74DDA23410E800EE412B60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513240, 'MS22', 'NL32-04', NULL, 'BRIG', 'Brig', 'Brig', '010100002015550000112C955D45972341C36AB67C33A5FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513243, 'MS12', 'NL32-04', NULL, 'BRIGERBAD', 'Brigerbad', 'Brigerbad', '010100002015550000EE2F365246792341AEAA2B3BD02FFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513244, 'LS71', 'NL32-04', NULL, 'BRIGNON', 'Brignon', 'Brignon', '0101000020155500002AC64FE2EA0522417F1ADD8535FEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513246, 'MS82', 'NL32-05', NULL, 'BRIONE', 'Brione', 'Brione', '0101000020155500009D8C55A62379254107CB660E00ECFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513248, 'LT85', 'NL32-01', NULL, 'BRISLACH', 'Brislach', 'Brislach', '010100002015550000079B4A9B56872241C82E82C8B1BB0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513249, 'MS70', 'NL32-05', NULL, 'BRISSAGO', 'Brissago', 'Brissago', '0101000020155500003A1A67545C532541C2054D2CD060FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513251, 'MS77', 'NL32-05', NULL, 'BRISTEN', 'Bristen', 'Bristen', '010100002015550000E8F4D395463625418E36FE66E1000641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513253, 'MT23', 'NL32-01', NULL, 'BRITTNAU', 'Brittnau', 'Brittnau', '010100002015550000000F537AEF7D23417AAD982E6D7C0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513254, 'LS56', 'NL32-04', NULL, 'BROC', 'Broc', 'Broc', '0101000020155500004FBBAAACD88421416F5B5364FFE10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513255, 'MS37', 'NL32-05', NULL, 'BROCH', 'Broch', 'Broch', '010100002015550000DD17F705ADF8234152D2446087CF0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513256, 'MS73', 'NL32-05', NULL, 'BROGLIO', 'Broglio', 'Broglio', '010100002015550000400FBE7D8A312541CF5A61CBBDCC0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513257, 'NT05', 'NL32-02', NULL, 'BRONSCHHOFEN', 'Bronschhofen', 'Bronschhofen', '0101000020155500009AC97D1D76FA2541B531A45B59C90F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513258, 'MS73', 'NL32-05', NULL, 'BRONTALLO', 'Brontallo', 'Brontallo', '0101000020155500009829E133F31D254182AF748CB8570041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513259, 'LT20', 'NL32-04', NULL, 'BROTDESSOUS', 'Brot-Dessous', 'Brot-Dessous', '010100002015550000D289BE99F1B52041A7B80DE7736D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513260, 'LT20', 'NL32-04', NULL, 'BROTPLAMBOZ', 'Brot-Plamboz', 'Brot-Plamboz', '010100002015550000EB29FDC832B620416AD4875840E10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513264, 'MT35', 'NL32-02', NULL, 'BRUGG', 'Brugg', 'Brugg', '0101000020155500000056DC0FD20F2441E4F2B7E3E1AB0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513263, 'LT61', 'NL32-01', NULL, 'BRUGG', 'Brügg', 'Brugg', '01010000201555000010478CCB6CF32141D9C48E98A1A90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513265, 'NT25', 'NL32-02', NULL, 'BRUGGEN', 'Bruggen', 'Bruggen', '0101000020155500000AA697BE77AC26412B5A65D07EF10E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513267, 'MS37', 'NL32-05', NULL, 'BRUNIGEN', 'Brünigen', 'Brunigen', '0101000020155500003B1F93C733EE2341F3C46FDBC2B60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513269, 'NT04', 'NL32-02', NULL, 'BRUNNADERN', 'Brunnadern', 'Brunnadern', '010100002015550000455C2BAF4E2E2641554BF2D963C40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513271, 'MT60', 'NL32-05', NULL, 'BRUNNEN', 'Brunnen', 'Brunnen', '010100002015550000E982A7E5C301254189F21F2275EE0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513272, 'LT81', 'NL32-01', NULL, 'BRUNNENTHAL', 'Brunnenthal', 'Brunnenthal', '0101000020155500008335161E226022417C87837077350A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513273, 'MR98', 'NL32-08', NULL, 'BRUSINOARSIZIO', 'Brusino Arsizio', 'Brusino Arsizio', '0101000020155500004F7C063C3CD92541642ED281C179F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513274, 'NS82', 'NL32-06', NULL, 'BRUSIO', 'Brusio', 'Brusio', '01010000201555000035DFE2BD329C2841348B7A0CF01CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513275, 'LS60', 'NL32-04', NULL, 'BRUSON', 'Bruson', 'Bruson', '0101000020155500002EDA32404EC921411758FDB8B0D4F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513276, 'LT50', 'NL32-01', NULL, 'BRUTTELEN', 'Brüttelen', 'Bruttelen', '01010000201555000054E5111C0DA421411BA77AC41D4F0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513277, 'MT75', 'NL32-02', NULL, 'BRUTTEN', 'Brütten', 'Brutten', '010100002015550000C611BED3D02225412063987CE97F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513278, 'MT75', 'NL32-02', NULL, 'BRUTTISELLEN', 'Brüttisellen', 'Bruttisellen', '010100002015550000FD784AF19F0F25411EBB3C37E50A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513279, 'MT05', 'NL32-01', NULL, 'BUBENDORF', 'Bubendorf', 'Bubendorf', '010100002015550000F76D6D0A25FD22416E6F8803AD300F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513280, 'MT83', 'NL32-02', NULL, 'BUBIKON', 'Bubikon', 'Bubikon', '010100002015550000D0B3FA035B7425411E74BE3550CE0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513281, 'MT76', 'NL32-02', NULL, 'BUCH', 'Buch', 'Buch', '010100002015550000435AEAF1140E25412246368E1B501041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513282, 'MT67', 'NL32-02', NULL, 'BUCHBERG', 'Buchberg', 'Buchberg', '01010000201555000044A3F89876E62441C215A923DA881041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513284, 'MS15', 'NL32-04', NULL, 'BUCHEN', 'Buchen', 'Buchen', '01010000201555000034F2FEDDC36323413331DC64AD6F0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513285, 'NS59', 'NL32-05', NULL, 'BUCHEN', 'Buchen', 'Buchen', '010100002015550000EF3CAEF9949A2741D607E75E047B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513286, 'NT45', 'NL32-02', NULL, 'BUCHEN', 'Buchen', 'Buchen', '010100002015550000D22F8C7C2F21274183BB23CB26AB0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513287, 'LS98', 'NL32-04', NULL, 'BUCHHOLTERBERG', 'Buchholterberg', 'Buchholterberg', '010100002015550000DB2CEB716AD72241AE1E045AB7D10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513288, 'NT35', 'NL32-02', NULL, 'BUCHLER', 'Büchler', 'Buchler', '010100002015550000E812860EB30E2741ED5D15C067FB0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513289, 'MT51', 'NL32-02', NULL, 'BUCHRAIN', 'Buchrain', 'Buchrain', '010100002015550000E73043E7016C244104B3BDF3E57B0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513290, 'NT32', 'NL32-02', NULL, 'BUCHS', 'Buchs', 'Buchs', '0101000020155500009E9DBEB0AA00274148E8ED5C0E950B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513292, 'MT55', 'NL32-02', NULL, 'BUCHS', 'Buchs', 'Buchs', '0101000020155500007D95000B9399244138F3A1C8383E0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513291, 'MT24', 'NL32-02', NULL, 'BUCHS', 'Buchs', 'Buchs', '01010000201555000064F4FEB601C2234111A2F911AA4D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513293, 'MT78', 'NL32-02', NULL, 'BUCHTHALEN', 'Buchthalen', 'Buchthalen', '010100002015550000DE815EE6DE152541C66B9E8EFB541141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513295, 'MS37', 'NL32-05', NULL, 'BUHLEN', 'Bühlen', 'Buhlen', '010100002015550000F21E33548CDA234164936C5C47420541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513296, 'NT34', 'NL32-02', NULL, 'BUHLER', 'Bühler', 'Buhler', '01010000201555000084B11A7550DE2641E58C4B1891820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513297, 'MS69', 'NL32-05', NULL, 'BUHLRUTI', 'Bühlrüti', 'Buhlruti', '010100002015550000D10251956ED12441F247E58141900741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513298, 'MT31', 'NL32-02', NULL, 'BUHOLZ', 'Buholz', 'Buholz', '010100002015550000E79F156EFACD2341814F5C20BA3B0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513301, 'LT56', 'NL32-01', NULL, 'BUIX', 'Buix', 'Buix', '010100002015550000DAE628EFD9602141063EC50EADA50F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513302, 'MT66', 'NL32-02', NULL, 'BULACH', 'Bülach', 'Bulach', '010100002015550000C99E2A9BAED3244158D743B67C141041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513303, 'LS56', 'NL32-04', NULL, 'BULLE', 'Bulle', 'Bulle', '010100002015550000D50F3C0EE6702141C9F709355CE20341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513304, 'LS18', 'NL32-04', NULL, 'BULLET', 'Bullet', 'Bullet', '010100002015550000DD2E50869F472041739C4BFB9EA20641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513305, 'MS18', 'NL32-04', NULL, 'BUMBACH', 'Bumbach', 'Bumbach', '010100002015550000AE999CF9A8622341D7315A605B600641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513306, 'LS79', 'NL32-04', NULL, 'BUMPLIZ', 'Bümpliz', 'Bumpliz', '010100002015550000C6246FC5992E2241912F998B622C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513309, 'LS69', 'NL32-04', NULL, 'BUNDTELS', 'Bundtels', 'Bundtels', '0101000020155500007BE297F747CB2141359C060B7D450741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513312, 'MT50', 'NL32-05', NULL, 'BUOCHS', 'Buochs', 'Buochs', '010100002015550000752D6F97FC942441D70A528A9EAE0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513313, 'MT52', 'NL32-02', NULL, 'BUONAS', 'Buonas', 'Buonas', '010100002015550000BAAB0F37F0A624411E6BA0E599F20A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513314, 'MS02', 'NL32-04', NULL, 'BURCHEN', 'Bürchen', 'Burchen', '010100002015550000E4F4901F303323411C4641081A45FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513315, 'LT45', 'NL32-01', NULL, 'BURE', 'Bure', 'Bure', '0101000020155500008C29D7B30F4D2141A4C47F9048320F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513319, 'LT72', 'NL32-01', NULL, 'BURENANDERAARE', 'Büren an der Aare', 'Buren an der Aare', '0101000020155500006E02CFC4D82422414FE98ADF3EE30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513320, 'MS59', 'NL32-05', NULL, 'BURENNIDDEMBACH', 'Büren nid dem Bach', 'Buren nid dem Bach', '01010000201555000035119DC46E8B244106CE8DCE553A0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513321, 'LT85', 'NL32-01', NULL, 'BURG', 'Burg', 'Burg', '010100002015550000A8F5740C624C22415CE00D27612F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513322, 'LT91', 'NL32-01', NULL, 'BURGDORF', 'Burgdorf', 'Burgdorf', '010100002015550000CC2C9F5E30B922413B2381FF1FC20941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513327, 'LS88', 'NL32-04', NULL, 'BURGISTEIN', 'Burgistein', 'Burgistein', '0101000020155500000D642A9C2A6A224164A4C7C242230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513328, 'MS38', 'NL32-05', NULL, 'BURGLEN', 'Bürglen', 'Burglen', '010100002015550000683966329001244126288289129F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513329, 'MS79', 'NL32-05', NULL, 'BURGLEN', 'Bürglen', 'Burglen', '010100002015550000A1819BB7BE2A25419D09967681950741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513330, 'NT16', 'NL32-02', NULL, 'BURGLEN', 'Bürglen', 'Burglen', '01010000201555000009BC4D7AE13D2641963899B15C5B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513332, 'MT32', 'NL32-02', NULL, 'BURON', 'Büron', 'Buron', '010100002015550000A82399E8E3D6234182172F32450B0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513333, 'KS94', 'NL32-04', NULL, 'BURSINEL', 'Bursinel', 'Bursinel', '0101000020155500006C11B9039C471F4135E018333E770141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513334, 'KS94', 'NL32-04', NULL, 'BURSINS', 'Bursins', 'Bursins', '010100002015550000F7EA55D705341F4133BD80ACB8B10141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513335, 'LS67', 'NL32-04', NULL, 'BURSTERA', 'Burstera', 'Burstera', '010100002015550000388DA8C8ACF221410BAD99BA34C80441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513336, 'NS36', 'NL32-05', NULL, 'BURTGAS', 'Burtgas', 'Burtgas', '010100002015550000EDC0B5577EE526413B7FB48B05E10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513337, 'KS84', 'NL32-04', NULL, 'BURTIGNY', 'Burtigny', 'Burtigny', '01010000201555000026946995720C1F4110D96F89CFEC0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513338, 'NS02', 'NL32-05', NULL, 'BUSEN', 'Busen', 'Busen', '010100002015550000AAB549171F422641A67E337F2997FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513340, 'LT84', 'NL32-01', NULL, 'BUSSERACH', 'Büsserach', 'Busserach', '010100002015550000982D26785F8722414C7E7DF9E0470E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513342, 'LS15', 'NL32-04', NULL, 'BUSSIGNY', 'Bussigny', 'Bussigny', '0101000020155500003AD0FA6F0B45204153636EBD49040341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513343, 'MT83', 'NL32-02', NULL, 'BUSSKIRCH', 'Busskirch', 'Busskirch', '010100002015550000169117379388254155DDF7C2E75B0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513344, 'LT71', 'NL32-01', NULL, 'BUSSWIL', 'Busswil', 'Busswil', '010100002015550000D88F7CE10C1122418AEF8D87876F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513346, 'NT04', 'NL32-02', NULL, 'BUTSCHWIL', 'Bütschwil', 'Butschwil', '010100002015550000849CA40E7D10264122F9ECD4CBFB0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513347, 'LS19', 'NL32-04', NULL, 'BUTTES', 'Buttes', 'Buttes', '0101000020155500009A5303F8573E2041B0200D97A78A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513348, 'MT31', 'NL32-02', NULL, 'BUTTISHOLZ', 'Buttisholz', 'Buttisholz', '010100002015550000DC691F6ABED723417DE72A04F5750A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513349, 'MT43', 'NL32-02', NULL, 'BUTTWIL', 'Buttwil', 'Buttwil', '010100002015550000F01B35237960244111B7F7DF72BE0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513350, 'MT02', 'NL32-01', NULL, 'BUTZBERG', 'Bützberg', 'Butzberg', '01010000201555000055D55066C40723410AB56F0B24060C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513351, 'MT16', 'NL32-01', NULL, 'BUUS', 'Buus', 'Buus', '0101000020155500001302BBAD634B2341E6A72690E00C1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513354, 'NS13', 'NL32-05', NULL, 'CABBIOLO', 'Cabbiolo', 'Cabbiolo', '0101000020155500002455D69600732641E85D145984370041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513355, 'MR99', 'NL32-05', NULL, 'CADEMPINO', 'Cadempino', 'Cadempino', '010100002015550000685AAFBC6BC3254122E45B07632DF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513356, 'MS91', 'NL32-05', NULL, 'CADENAZZO', 'Cadenazzo', 'Cadenazzo', '0101000020155500008E7DA158B5DF25410250225B685CFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513357, 'MR99', 'NL32-05', NULL, 'CADRO', 'Cadro', 'Cadro', '010100002015550000D1CD22E988F5254183E3CCACE3A8F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513359, 'MS90', 'NL32-05', NULL, 'CAGIALLO', 'Cagiallo', 'Cagiallo', '0101000020155500003288A2F23FF525412FED4D61AA1CF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513360, 'MS93', 'NL32-05', NULL, 'CAGNAGO', 'Cagnago', 'Cagnago', '0101000020155500009DE08159BEB32541AEEC1FFA9CD50041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513361, 'MS84', 'NL32-05', NULL, 'CALA', 'Cala', 'Cala', '010100002015550000B9B976682C8B25417B8F416482460141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513365, 'NS28', 'NL32-05', NULL, 'CALORTSCH', 'Calörtsch', 'Calortsch', '010100002015550000E8CDB3D8CFAF2641F181AE64D9580641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513366, 'MS84', 'NL32-05', NULL, 'CALPIOGNA', 'Calpiogna', 'Calpiogna', '010100002015550000DC785FD5288025419DA2A17E5E2D0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513368, 'NS12', 'NL32-05', NULL, 'CAMA', 'Cama', 'Cama', '0101000020155500001B8D04E53A602641BC2F0B60649CFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513369, 'NS26', 'NL32-05', NULL, 'CAMANA', 'Camana', 'Camana', '010100002015550000E4CCC35EA79E264198B5E8F2E4870441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513373, 'NS01', 'NL32-05', NULL, 'CAMORINO', 'Camorino', 'Camorino', '010100002015550000286D7E07E2FD2541240DBFCA2261FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513374, 'NS82', 'NL32-06', NULL, 'CAMPASCIO', 'Campascio', 'Campascio', '0101000020155500003E4ECB3AB19C28417BF7FF5F35A9FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513375, 'NS64', 'NL32-05', NULL, 'CAMPFER', 'Campfer', 'Campfer', '0101000020155500006926D62056D827411A6E3A086E2C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513376, 'MS97', 'NL32-05', NULL, 'CAMPLIUN', 'Campliun', 'Campliun', '01010000201555000018F31AB890E92541AFD41B9EB8D30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513377, 'MS62', 'NL32-05', NULL, 'CAMPO', 'Campo', 'Campo', '0101000020155500004555DC4A8ECE2441E3DB430E13D7FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513378, 'MS64', 'NL32-05', NULL, 'CAMPO', 'Campo', 'Campo', '01010000201555000073A923E7FFD6244137753E893A3B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513380, 'MS95', 'NL32-05', NULL, 'CAMPOBLENIO', 'Campo Blenio', 'Campo Blenio', '010100002015550000DDB8AF2708CF2541083B09BABE1A0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513381, 'NS82', 'NL32-06', NULL, 'CAMPOCOLOGNO', 'Campocologno', 'Campocologno', '010100002015550000339142A339A728410D1003163B38FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513385, 'NS75', 'NL32-05', NULL, 'CAMPOVASTO', 'Campovasto', 'Campovasto', '010100002015550000362E57B08C2528413F75C1D08C910341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513386, 'NS34', 'NL32-05', NULL, 'CAMPSUT', 'Campsut', 'Campsut', '010100002015550000FA9404CD001A2741198038A1F6500241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513387, 'MR99', 'NL32-05', NULL, 'CANOBBIO', 'Canobbio', 'Canobbio', '0101000020155500001A28EF0DA9E125412B79F799F831F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513388, 'LR68', 'NL32-07', NULL, 'CANTINEDEPROZ', 'Cantine-de-Proz', 'Cantine-de-Proz', '010100002015550000461E98ADC9BE2141281E4498EF4EF440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513390, 'MR98', 'NL32-08', NULL, 'CAPOLAGO', 'Capolago', 'Capolago', '010100002015550000216BFB9819F825419CCDF973E596F440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513391, 'NS01', 'NL32-05', NULL, 'CARENA', 'Carena', 'Carena', '0101000020155500007B279496DE2F26415460827321DDFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513392, 'KS71', 'NL32-04', NULL, 'CAROUGE', 'Carouge', 'Carouge', '01010000201555000029807D2F3E781E41EFF2764F4232FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513393, 'NS28', 'NL32-05', NULL, 'CARRERA', 'Carrera', 'Carrera', '010100002015550000BAA9D63087A52641B7197100C9910641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513394, 'KS61', 'NL32-04', NULL, 'CARTIGNY', 'Cartigny', 'Cartigny', '01010000201555000020FDB54082EB1D41866AF5E20E3CFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513396, 'NS53', 'NL32-05', NULL, 'CASACCIA', 'Casaccia', 'Casaccia', '010100002015550000CAA208BA698A2741E85DAE88B1010141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513398, 'NR08', 'NL32-08', NULL, 'CASIMA', 'Casima', 'Casima', '0101000020155500002ABBD0FBB41626416AF8D105F927F440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513399, 'MR99', 'NL32-08', NULL, 'CASLANO', 'Caslano', 'Caslano', '010100002015550000A00A603A68BA254151228B83C65CF640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513404, 'MS94', 'NL32-05', NULL, 'CASSINA', 'Cassina', 'Cassina', '010100002015550000F573CA3169B22541E9156F790EF70141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513406, 'NR09', 'NL32-05', NULL, 'CASTAGNOLA', 'Castagnola', 'Castagnola', '01010000201555000086DD26C7790026416D6C9D71284FF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513407, 'NS33', 'NL32-05', NULL, 'CASTASEGNA', 'Castasegna', 'Castasegna', '010100002015550000FFCE50AA713127416EDFC2B3294A0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513412, 'NT60', 'NL32-05', NULL, 'CASTELS', 'Castels', 'Castels', '010100002015550000DD2EA6D92BD527416917D307D4F50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513413, 'NR07', 'NL32-08', NULL, 'CASTELSANPIETRO', 'Castel San Pietro', 'Castel San Pietro', '010100002015550000AE2E78CFC70226419310D3FFF0B0F340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513414, 'NS48', 'NL32-05', NULL, 'CASTIEL', 'Castiel', 'Castiel', '010100002015550000EED941EC31572741ADA3679CC4510741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513415, 'NS01', 'NL32-05', NULL, 'CASTIONE', 'Castione', 'Castione', '0101000020155500004231F225871026413C193C7B3DA7FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513416, 'MS94', 'NL32-05', NULL, 'CASTRO', 'Castro', 'Castro', '010100002015550000F4B4898622D0254151EB6B4931330241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513418, 'NS03', 'NL32-05', NULL, 'CAUCO', 'Cauco', 'Cauco', '010100002015550000C4B23C10E240264164AD66171F330041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513419, 'LS44', 'NL32-04', NULL, 'CAUX', 'Caux', 'Caux', '0101000020155500000F93DA7714202141EC7AEFD446670141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513424, 'MS63', 'NL32-05', NULL, 'CAVERGNO', 'Cavergno', 'Cavergno', '0101000020155500001B5191E8E70925411456BB5D84560041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513425, 'MS80', 'NL32-05', NULL, 'CAVIANO', 'Caviano', 'Caviano', '0101000020155500000A5C33E2CC71254185AA513C0BF1F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513428, 'NS37', 'NL32-05', NULL, 'CAZIS', 'Cazis', 'Cazis', '01010000201555000010FD5C77DDF626413204156E32780541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513429, 'NS65', 'NL32-05', NULL, 'CELERINA', 'Celerina', 'Celerina', '010100002015550000C3A2C2FEFAFE2741D2EFFA28EDDE0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513430, 'KS83', 'NL32-04', NULL, 'CELIGNY', 'Céligny', 'Celigny', '010100002015550000ACEA9DB43DCD1E4128DD5F5E6E590041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513436, 'MS62', 'NL32-05', NULL, 'CERENTINO', 'Cerentino', 'Cerentino', '0101000020155500008BA4995774EC2441F95CCEC9314EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513438, 'KS72', 'NL32-04', NULL, 'CERN', 'Cern', 'Cern', '010100002015550000279975E341151E4185F1D7A08294FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513439, 'LS56', 'NL32-04', NULL, 'CERNIAT', 'Cerniat', 'Cerniat', '0101000020155500009C6186DACAAC2141359859D3451B0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513440, 'LT41', 'NL32-01', NULL, 'CERNIER', 'Cernier', 'Cernier', '0101000020155500002F2675ACD90F2141D50479E1F5FF0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513441, 'NS00', 'NL32-05', NULL, 'CERTARA', 'Certara', 'Certara', '01010000201555000001E52C0D51272641264C27859698F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513445, 'MS62', 'NL32-05', NULL, 'CEVIO', 'Cevio', 'Cevio', '010100002015550000F3669B98550A254128FDF44577C5FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513446, 'LS49', 'NL32-04', NULL, 'CHABREY', 'Chabrey', 'Chabrey', '0101000020155500009E52A73EA140214174B27FFD7E2F0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513448, 'LS82', 'NL32-04', NULL, 'CHALAIS', 'Chalais', 'Chalais', '0101000020155500004F8E087E7E7E2241C0441E12EA40FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513450, 'MT52', 'NL32-02', NULL, 'CHAM', 'Cham', 'Cham', '0101000020155500008FC2B74A3FB02441948D6ABACFA00B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513451, 'KS72', 'NL32-04', NULL, 'CHAMBESY', 'Chambésy', 'Chambesy', '010100002015550000610375122C7A1E41610D5E546201FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513452, 'LS61', 'NL32-04', NULL, 'CHAMOSON', 'Chamoson', 'Chamoson', '01010000201555000039BC2F8AA2C92141F3CC80201273FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513454, 'LS28', 'NL32-04', NULL, 'CHAMPAGNE', 'Champagne', 'Champagne', '0101000020155500004A08B28C737920419B17B33E69DA0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513455, 'LS31', 'NL32-04', NULL, 'CHAMPERY', 'Champéry', 'Champery', '0101000020155500004D43F78876F620412CF724ADD807FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513456, 'LR59', 'NL32-04', NULL, 'CHAMPEX', 'Champex', 'Champex', '010100002015550000B0A040D0BB8C21412A7DCA17C7EEF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513458, 'LS60', 'NL32-04', NULL, 'CHAMPSEC', 'Champsec', 'Champsec', '010100002015550000978088EF6BDD2141321406B27760F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513459, 'LS18', 'NL32-04', NULL, 'CHAMPVENT', 'Champvent', 'Champvent', '0101000020155500000DCA5B034D47204100C860E8D32E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513460, 'GM21', 'NL31-06', NULL, 'CHANCY', 'Chancy', 'Chancy', '0101000020155500007C9AD38C1BAE1D41E3B4BCD1F558FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513461, 'LS92', 'NL32-04', NULL, 'CHANDOLIN', 'Chandolin', 'Chandolin', '010100002015550000B16C43CAACA622418567E8CC91CDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513462, 'KS84', 'NL32-04', NULL, 'CHANGINS', 'Changins', 'Changins', '0101000020155500005A875441AAF61E41FCC170F1DA050141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513463, 'NS66', 'NL32-05', NULL, 'CHANTS', 'Chants', 'Chants', '010100002015550000F2B4547578E727418281307B71AB0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513464, 'LS27', 'NL32-04', NULL, 'CHAPELLE', 'Chapelle', 'Chapelle', '010100002015550000AD4A3A0BF2A920415D6E904A70CF0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513465, 'LS35', 'NL32-04', NULL, 'CHARDONNE', 'Chardonne', 'Chardonne', '01010000201555000018B9E83E5FDA204132B4121BFC160241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513468, 'LS56', 'NL32-04', NULL, 'CHARMEY', 'Charmey', 'Charmey', '010100002015550000B6EE75F4BDAC2141CA878AD05FE10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513470, 'LT65', 'NL32-01', NULL, 'CHARMOILLE', 'Charmoille', 'Charmoille', '01010000201555000045E9D437AECC2141321DD6AB37F60E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513472, 'LS50', 'NL32-04', NULL, 'CHARRATLESCHENES', 'Charrat-les-Chênes', 'Charrat-les-Chenes', '010100002015550000DDF29C11199721419A488B6C7131FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513479, 'KR72', 'NL32-07', NULL, 'CHATEAUDEBONMONT', 'Château de Bonmont', 'Chateau de Bonmont', '01010000201555000018B8B7EE9A601E41B8FC0FCD9A22D840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513480, 'LS54', 'NL32-04', NULL, 'CHATEAUDOEX', 'Château-d’Oex', 'Chateau-d’Oex', '01010000201555000069FFFD0849982141B265468295D80141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513481, 'LS71', 'NL32-04', NULL, 'CHATEAUNEUF', 'Châteauneuf', 'Chateauneuf', '010100002015550000C87AE1BB02102241A4D059D7AFE5FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513482, 'KS72', 'NL32-04', NULL, 'CHATELAINE', 'Châtelaine', 'Chatelaine', '01010000201555000022489D58A0641E416628998663A7FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513486, 'LS35', 'NL32-04', NULL, 'CHATELSAINTDENIS', 'Châtel-Saint-Denis', 'Chatel-Saint-Denis', '010100002015550000B5511B98A90C21412ED72DB331C30241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513487, 'LS47', 'NL32-04', NULL, 'CHATONNAYE', 'Châtonnaye', 'Chatonnaye', '01010000201555000046C66E13DB2121410E9DFBB355B30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513490, 'LT40', 'NL32-01', NULL, 'CHAUMONTDEPURY', 'Chaumont-de-Pury', 'Chaumont-de-Pury', '010100002015550000B965644C402D2141C6A3A3417A510941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513492, 'LS15', 'NL32-04', NULL, 'CHAVANNES', 'Chavannes', 'Chavannes', '010100002015550000C635902EE2442041E98C4D8D64CA0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513493, 'LS38', 'NL32-04', NULL, 'CHAVANNESLECHENE', 'Chavannes-le-Chêne', 'Chavannes-le-Chene', '010100002015550000E50B97698EC8204101C06722C9290641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513494, 'LS47', 'NL32-04', NULL, 'CHAVANNESSOUSORSONNENS', 'Chavannes-sous-Orsonnens', 'Chavannes-sous-Orsonnens', '010100002015550000A12E557A9E3F214156A498FEB3780541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513495, 'LS17', 'NL32-04', NULL, 'CHAVORNAY', 'Chavornay', 'Chavornay', '0101000020155500009DC0C0FDA74620411077894C3E470541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513496, 'LS37', 'NL32-04', NULL, 'CHEIRY', 'Cheiry', 'Cheiry', '0101000020155500007B11043E29E62041240C4D6407B50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513497, 'LS50', 'NL32-04', NULL, 'CHEMIN', 'Chemin', 'Chemin', '0101000020155500007EE51213D782214188DDB4F2824AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48559, 'KS82', 'NL32-04', NULL, 'CHENEBOUGERIES', 'Chêne-Bougeries', 'Chene-Bougeries', '01010000201555000097472266ECA01E413C2DB24065A3FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513499, 'KS82', 'NL32-04', NULL, 'CHENEBOURG', 'Chêne-Bourg', 'Chene-Bourg', '0101000020155500005CAB472E1FC91E41ED56EC9CD1A0FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513500, 'LS28', 'NL32-04', NULL, 'CHENEPAQUIER', 'Chêne-Pâquier', 'Chene-Paquier', '010100002015550000A5FFD93F7DBE2041101713AA39F00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513503, 'LS82', 'NL32-04', NULL, 'CHERMIGNONDENBAS', 'Chermignon-d’en Bas', 'Chermignon-d’en Bas', '010100002015550000525020F7565622411BE4CD2ABC40FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513504, 'LS82', 'NL32-04', NULL, 'CHERMIGNONDENHAUT', 'Chermignon-d’en Haut', 'Chermignon-d’en Haut', '010100002015550000CD1B1C925F60224182AA130C8DB4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513505, 'LS16', 'NL32-04', NULL, 'CHESEAUX', 'Cheseaux', 'Cheseaux', '01010000201555000090E015257B5920418D0281271AB10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513508, 'LS42', 'NL32-04', NULL, 'CHESIERES', 'Chesières', 'Chesieres', '0101000020155500009B14B7E58E652141E6B44AA6FC2CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513509, 'LT44', 'NL32-01', NULL, 'CHEVENEZ', 'Chevenez', 'Chevenez', '010100002015550000FF072195BC4C21411081349AA74A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513513, 'LS49', 'NL32-04', NULL, 'CHEVROUX', 'Chevroux', 'Chevroux', '010100002015550000238FD823C10E2141AA6E25770E830741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513514, 'LS25', 'NL32-04', NULL, 'CHEXBRES', 'Chexbres', 'Chexbres', '010100002015550000B355542060C620413CF1D326A3170241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513516, 'LS38', 'NL32-04', NULL, 'CHEYRES', 'Cheyres', 'Cheyres', '0101000020155500005630DF71CCC8204197062202959D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513517, 'LT41', 'NL32-01', NULL, 'CHEZARDSAINTMARTIN', 'Chézard-Saint-Martin', 'Chezard-Saint-Martin', '010100002015550000C7D506B2A1232141881B56C76EFF0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513518, 'LS39', 'NL32-04', NULL, 'CHEZLEBART', 'Chez-le-Bart', 'Chez-le-Bart', '01010000201555000035C5C58667C92041A3C0C81E13BF0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513519, 'NR07', 'NL32-08', NULL, 'CHIASSO', 'Chiasso', 'Chiasso', '010100002015550000831EA1FA961726418D52760EA4CCF240');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513520, 'NS04', 'NL32-05', NULL, 'CHIAVASCO', 'Chiavasco', 'Chiavasco', '010100002015550000C736FED9FD022641A61E95B872890141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513522, 'MS84', 'NL32-05', NULL, 'CHIGGIOGNA', 'Chiggiogna', 'Chiggiogna', '010100002015550000C1B5622A698A25414246B88D2DF40141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513525, 'LS82', 'NL32-04', NULL, 'CHIPPIS', 'Chippis', 'Chippis', '01010000201555000028FC855C888822419CB52B790041FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513526, 'MS84', 'NL32-05', NULL, 'CHIRONICO', 'Chironico', 'Chironico', '0101000020155500005C9BECC82E952541563E628637470141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513528, 'LT74', 'NL32-01', NULL, 'CHOINDEZ', 'Choindez', 'Choindez', '0101000020155500001EAFF2ECD62E22415C92C5BD2A600D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513529, 'NS38', 'NL32-05', 3, 'CHUR', 'Chur', 'Chur', '010100002015550000AA7CCB99A11B2741C9DA96975A4B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513531, 'NS48', 'NL32-05', NULL, 'CHURWALDEN', 'Churwalden', 'Churwalden', '0101000020155500002437BF2C08312741AC65C99EF0650641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513533, 'PS06', 'NL32-06', NULL, 'CIERFS', 'Cierfs', 'Cierfs', '010100002015550000EA8B752FDE12294135945F4CE7990441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513535, 'LS55', 'NL32-04', NULL, 'CIERNESPICAT', 'Ciernes-Picat', 'Ciernes-Picat', '0101000020155500006FEEEBA963AC2141D45AB5BB154C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513536, 'NS00', 'NL32-05', NULL, 'CIMADERA', 'Cimadera', 'Cimadera', '0101000020155500009742CF0E3F1D26410DE0D69EEC96F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513537, 'MS62', 'NL32-05', NULL, 'CIMALMOTTO', 'Cimalmotto', 'Cimalmotto', '0101000020155500004555DC4A8ECE2441E3DB430E13D7FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513538, 'NS76', 'NL32-06', NULL, 'CINUSKEL', 'Cinuskel', 'Cinuskel', '0101000020155500005F5C4970895528414BB8EF81797F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513540, 'NS02', 'NL32-05', NULL, 'CLARO', 'Claro', 'Claro', '010100002015550000374CC2D33B102641A2ADE073031BFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513542, 'NS67', 'NL32-05', NULL, 'CLAVADEL', 'Clavadel', 'Clavadel', '010100002015550000D4B7D3957ED02741B44C9B6E233E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513545, 'NS36', 'NL32-05', NULL, 'CLUGIN', 'Clugin', 'Clugin', '010100002015550000022DDE3C1AEF2641A54B2079E71B0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513551, 'LT55', 'NL32-01', NULL, 'COEUVE', 'Coeuve', 'Coeuve', '01010000201555000079CFF7440B88214198CD0A4D056B0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513553, 'KS72', 'NL32-04', NULL, 'COINTRIN', 'Cointrin', 'Cointrin', '01010000201555000006FCB2641D651E41EB08647A2B1BFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513555, 'LT31', 'NL32-01', NULL, 'COLDESROCHES', 'Col des Roches', 'Col des Roches', '0101000020155500006F656DCB11F22041C84C59FFE9C60941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513557, 'LS42', 'NL32-04', NULL, 'COLLOMBEY', 'Collombey', 'Collombey', '0101000020155500004730C1072F292141636D45F01848FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513559, 'LS41', 'NL32-04', NULL, 'COLLONGES', 'Collonges', 'Collonges', '01010000201555000099E69502ED5A2141E7E1D524078FFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513561, 'LS05', 'NL32-04', NULL, 'COLOMBIER', 'Colombier', 'Colombier', '010100002015550000D3BF0D92210920412E31FDF71B070341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513562, 'LT30', 'NL32-04', NULL, 'COLOMBIER', 'Colombier', 'Colombier', '01010000201555000000B2C3316FFB2041A9104E441EA50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513563, 'KS72', 'NL32-04', NULL, 'COLOVREX', 'Colovrex', 'Colovrex', '010100002015550000610375122C7A1E41610D5E546201FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513564, 'NS43', 'NL32-05', NULL, 'COLTURA', 'Coltura', 'Coltura', '0101000020155500003A20388B1E4F27414456C4E843870041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513565, 'MR99', 'NL32-05', NULL, 'COMANO', 'Comano', 'Comano', '010100002015550000B691E79E94D72541CC2387056D30F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513567, 'LS37', 'NL32-04', NULL, 'COMBREMONTLEPETIT', 'Combremont-le-Petit', 'Combremont-le-Petit', '0101000020155500007B11043E29E62041240C4D6407B50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513568, 'MS61', 'NL32-05', NULL, 'COMOLOGNO', 'Comologno', 'Comologno', '010100002015550000AAC43AC1C8012541667D9C0BCB99FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513569, 'MS97', 'NL32-05', NULL, 'COMPADIALS', 'Compadials', 'Compadials', '010100002015550000541D74490CC225416ADE31E7C3960541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513570, 'PT00', 'NL32-06', NULL, 'COMPATSCH', 'Compatsch', 'Compatsch', '010100002015550000581878EF57302941ECFC35532CEB0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513571, 'KS71', 'NL32-04', NULL, 'COMPESIERES', 'Compesières', 'Compesieres', '0101000020155500001A16AD3329631E41961AFFAF0B4CFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513572, 'MS94', 'NL32-05', NULL, 'COMPROVASCO', 'Comprovasco', 'Comprovasco', '01010000201555000046FB2D75B0DA25412629B8EE2EC00141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513573, 'LS29', 'NL32-04', NULL, 'CONCISE', 'Concise', 'Concise', '010100002015550000CFD1D6A351A12041506ADFAFC6120741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513575, 'KS71', 'NL32-04', NULL, 'CONFIGNON', 'Confignon', 'Confignon', '0101000020155500006DE9C784ED3B1E4184596D285B36FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513578, 'NS46', 'NL32-05', NULL, 'CONTERS', 'Conters', 'Conters', '01010000201555000086C0AE1CC75C27410AC6D9467B270441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513579, 'NS59', 'NL32-05', NULL, 'CONTERS', 'Conters', 'Conters', '0101000020155500006315918717C32741A57C9BCDF00B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513580, 'LS62', 'NL32-04', NULL, 'CONTHEY', 'Conthey', 'Conthey', '010100002015550000AB7699DAF0FB214131C27455BC59FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513581, 'MS91', 'NL32-05', NULL, 'CONTONE', 'Contone', 'Contone', '010100002015550000890BD86CA6D52541E4383BA2DD5AFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513582, 'MS81', 'NL32-05', NULL, 'CONTRA', 'Contra', 'Contra', '0101000020155500006C5B99F7C898254181FEFB278839FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513586, 'LS72', 'NL32-04', NULL, 'COPPET', 'Coppet', 'Coppet', '01010000201555000014FEE5D116102241B2A90A0BE0B4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513587, 'KS83', 'NL32-04', NULL, 'COPPET', 'Coppet', 'Coppet', '0101000020155500002408AE5E53CC1E411C27252F4CCBFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513588, 'LS43', 'NL32-04', NULL, 'CORBEYRIER', 'Corbeyrier', 'Corbeyrier', '0101000020155500005BA580A0A83321419084B3204A450041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513589, 'MS71', 'NL32-05', NULL, 'CORCAPOLO', 'Corcapolo', 'Corcapolo', '010100002015550000F0AD08B38A3E2541679B9BC992B9FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513590, 'LS48', 'NL32-04', NULL, 'CORCELLES', 'Corcelles', 'Corcelles', '010100002015550000DA6237D1303621413646DD2555D40641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513591, 'LT83', 'NL32-01', NULL, 'CORCELLES', 'Corcelles', 'Corcelles', '0101000020155500000B9CEA45854222417676F89B50EC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513592, 'LS59', 'NL32-04', NULL, 'CORDAST', 'Cordast', 'Cordast', '010100002015550000570335ED91A32141DDC3D6F201460741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513593, 'LS83', 'NL32-04', NULL, 'CORDONA', 'Cordona', 'Cordona', '0101000020155500006828275E7D9222412A9C11A125080041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513595, 'LT52', 'NL32-01', NULL, 'CORGEMONT', 'Corgémont', 'Corgemont', '010100002015550000C1A48871B79A21418786AB314B920B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513596, 'MS81', 'NL32-05', NULL, 'CORIPPO', 'Corippo', 'Corippo', '010100002015550000A22C345A0398254117412965DE94FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513597, 'LS58', 'NL32-04', NULL, 'CORMINBOEUF', 'Corminboeuf', 'Corminboeuf', '010100002015550000331E8E3889852141C6ED94DEE25E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513598, 'LT41', 'NL32-01', NULL, 'CORNAUX', 'Cornaux', 'Cornaux', '010100002015550000017C13D229552141EB4FA38C29380A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513601, 'LT65', 'NL32-01', NULL, 'CORNOL', 'Cornol', 'Cornol', '010100002015550000188A4E3D1CAF21411F854561C6820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513602, 'KS82', 'NL32-04', NULL, 'CORSIER', 'Corsier', 'Corsier', '01010000201555000006CBBCFE06DF1E4119C44358B06EFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513604, 'LS39', 'NL32-04', NULL, 'CORTAILLOD', 'Cortaillod', 'Cortaillod', '010100002015550000DC920DBB4EF12041A113A7BD9C310841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513605, 'MS70', 'NL32-05', NULL, 'CORTASCIO', 'Cortascio', 'Cortascio', '010100002015550000B3CDF86A2A352541D3C90972F45CFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513606, 'MS74', 'NL32-05', NULL, 'CORTE', 'Corte', 'Corte', '0101000020155500006DAF5346681C254115561B97F6EC0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513607, 'MS63', 'NL32-05', NULL, 'CORTEGRANDE', 'Corte Grande', 'Corte Grande', '0101000020155500002F7785D1C5CD244160C1952C1C530041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513608, 'MS63', 'NL32-05', NULL, 'CORTEGRANDE', 'Corte Grande', 'Corte Grande', '010100002015550000D15F00772FCD2441A112141ECA000141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513611, 'LS06', 'NL32-04', NULL, 'COSSONAY', 'Cossonay', 'Cossonay', '010100002015550000844CBCF2C4272041D02BB5723DED0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513616, 'LS47', 'NL32-04', NULL, 'COTTENS', 'Cottens', 'Cottens', '010100002015550000822A20098D5D2141F33ABBFAF1B10541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513620, 'LT74', 'NL32-01', NULL, 'COURFAIVRE', 'Courfaivre', 'Courfaivre', '010100002015550000BE139BCFCCF321410A862BAE649A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513621, 'LT55', 'NL32-01', NULL, 'COURGENAY', 'Courgenay', 'Courgenay', '01010000201555000018E1745A9F91214166F3BA1F39830E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513622, 'LS59', 'NL32-04', NULL, 'COURGEVAUX', 'Courgevaux', 'Courgevaux', '010100002015550000B00E3F85E9852141ED303B3749BA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513623, 'LS59', 'NL32-04', NULL, 'COURLEVON', 'Courlevon', 'Courlevon', '010100002015550000F99C6D78D985214183DE24B462800741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513624, 'LT74', 'NL32-01', NULL, 'COURRENDLIN', 'Courrendlin', 'Courrendlin', '010100002015550000478D8521022522411F5F57081B9A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513625, 'LT74', 'NL32-01', NULL, 'COURROUX', 'Courroux', 'Courroux', '010100002015550000964D6E0609252241BDD06B66EB0D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513626, 'LT73', 'NL32-01', NULL, 'COURT', 'Court', 'Court', '0101000020155500001591250F3511224138BD43DEC23E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513627, 'LT55', 'NL32-01', NULL, 'COURTEDOUX', 'Courtedoux', 'Courtedoux', '01010000201555000094645AE97960214177D2552823840E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513628, 'LT52', 'NL32-01', NULL, 'COURTELARY', 'Courtelary', 'Courtelary', '0101000020155500007F66E8533D732141EF556B49FA920B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513629, 'LT55', 'NL32-01', NULL, 'COURTEMAICHE', 'Courtemaîche', 'Courtemaiche', '010100002015550000389E46DD976A21414521018C916B0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513630, 'LS69', 'NL32-04', NULL, 'COURTEPIN', 'Courtepin', 'Courtepin', '0101000020155500002E3683204FC12141D8347285B40B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513631, 'LT74', 'NL32-01', NULL, 'COURTETELLE', 'Courtételle', 'Courtetelle', '01010000201555000054D29E8D8107224138E9FCED28D40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513632, 'LS59', 'NL32-04', NULL, 'COURTION', 'Courtion', 'Courtion', '010100002015550000BEEAD96EEE71214104683BB4D8460741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513633, 'LS71', 'NL32-04', NULL, 'COUTA', 'Couta', 'Couta', '010100002015550000F49AE32B1A2E22414DE1DFB372A2FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513634, 'LS19', 'NL32-04', NULL, 'COUVET', 'Couvet', 'Couvet', '0101000020155500008EFB131B437020417D21C6D44DFC0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513636, 'NS46', 'NL32-05', NULL, 'CRADIGLLAI', 'Cra digl Lai', 'Cra digl Lai', '0101000020155500006B60A07848352741A24EBC4C46E90341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513637, 'MS71', 'NL32-05', NULL, 'CRANA', 'Crana', 'Crana', '010100002015550000CA5BCF9FAA15254135818B37F50FFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513638, 'LS82', 'NL32-04', NULL, 'CRANS', 'Crans', 'Crans', '010100002015550000A6C9464A5E6022414C18ED2B5928FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513639, 'KS83', 'NL32-04', NULL, 'CRANS', 'Crans', 'Crans', '0101000020155500002B878ADFB2CD1E412C7C828C52930041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513641, 'KS83', 'NL32-04', NULL, 'CRASSIER', 'Crassier', 'Crassier', '010100002015550000FD9511989FA51E413ED33E599B940041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513642, 'NS54', 'NL32-05', NULL, 'CRASTA', 'Crasta', 'Crasta', '010100002015550000E0A4DB74A1C527416FEAD8876B7C0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513644, 'LT83', 'NL32-01', NULL, 'CREMINES', 'Crémines', 'Cremines', '0101000020155500004D6EA7CB5E4C22415651ADF266B20C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513645, 'NS02', 'NL32-05', NULL, 'CRESCIANO', 'Cresciano', 'Cresciano', '0101000020155500007C5A6DCDDDFB25410788E55A8E8BFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513646, 'LS59', 'NL32-04', NULL, 'CRESSIER', 'Cressier', 'Cressier', '010100002015550000AD80CE5DC19921413733C886F5B90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513647, 'LT51', 'NL32-01', NULL, 'CRESSIER', 'Cressier', 'Cressier', '01010000201555000075FB55A7E65E21418630753D26C40941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513648, 'NS34', 'NL32-05', NULL, 'CRESTA', 'Cresta', 'Cresta', '010100002015550000E01E5E75602E27418D306DEE2F190241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513651, 'MS94', 'NL32-05', NULL, 'CRICH', 'Crich', 'Crich', '010100002015550000381D9A38F3BC2541EEBA273705840141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513653, 'LS15', 'NL32-04', NULL, 'CRISSIER', 'Crissier', 'Crissier', '010100002015550000E05DA4C2074F20412DACFCF9D8030341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513655, 'MS84', 'NL32-05', NULL, 'CROCE', 'Croce', 'Croce', '0101000020155500001A89D515288A254178837E3A112E0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513656, 'PS08', 'NL32-06', NULL, 'CRUSCH', 'Crusch', 'Crusch', '010100002015550000EC148683EC1629412A86F5B4D5170741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513657, 'LT40', 'NL32-04', NULL, 'CUDREFIN', 'Cudrefin', 'Cudrefin', '010100002015550000FD653EE88954214152CF79B1F3680841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513659, 'MS91', 'NL32-05', NULL, 'CUGNASCO', 'Cugnasco', 'Cugnasco', '010100002015550000877B126135B72541C24B96F21ECAFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513660, 'LS16', 'NL32-04', NULL, 'CUGY', 'Cugy', 'Cugy', '0101000020155500005B8E2F01496D204132F398535E760341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513661, 'LS38', 'NL32-04', NULL, 'CUGY', 'Cugy', 'Cugy', '01010000201555000012C8364D6B04214157B850ECBC9B0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513662, 'LS25', 'NL32-04', NULL, 'CULLY', 'Cully', 'Cully', '0101000020155500007981447F61A82041EFD30B0BAE180241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513663, 'NS17', 'NL32-05', NULL, 'CUMBELS', 'Cumbels', 'Cumbels', '010100002015550000F278F035936126414FC9A03EF6690541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513665, 'MS86', 'NL32-05', NULL, 'CURAGLIA', 'Curaglia', 'Curaglia', '0101000020155500007C7A3475FCA42541C03CB24CE2E60441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513666, 'NS00', 'NL32-05', NULL, 'CURTINA', 'Curtina', 'Curtina', '010100002015550000DD2D4B0D1B0926415BA7A4F9A593F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513668, 'MT77', 'NL32-02', NULL, 'DACHSEN', 'Dachsen', 'Dachsen', '010100002015550000F1F852EC890C25410FB45BACC61A1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513669, 'MT22', 'NL32-01', NULL, 'DAGMERSELLEN', 'Dagmersellen', 'Dagmersellen', '01010000201555000092F7C991D99123416981384726090C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513670, 'LS16', 'NL32-04', NULL, 'DAILLENS', 'Daillens', 'Daillens', '010100002015550000457E0447B73B20419DDD6A5851EC0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513672, 'LS82', 'NL32-04', NULL, 'DAILLEY', 'Dailley', 'Dailley', '01010000201555000028E279F357562241492558D62359FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513673, 'LS41', 'NL32-04', NULL, 'DAILLY', 'Dailly', 'Dailly', '010100002015550000EEA5BA69135B2141509FAAAE9E76FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513674, 'MS59', 'NL32-05', NULL, 'DALLENWIL', 'Dallenwil', 'Dallenwil', '010100002015550000396FC72EB18124410B8BBBF2F4FF0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513675, 'MS84', 'NL32-05', NULL, 'DALPE', 'Dalpe', 'Dalpe', '0101000020155500000500D908696C25417BEE71B71BF20141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513678, 'LT44', 'NL32-01', NULL, 'DAMVANT', 'Damvant', 'Damvant', '01010000201555000056B4E8C2A4112141C8E4B7FA38120E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513679, 'NS04', 'NL32-05', NULL, 'DANDRIO', 'Dandrio', 'Dandrio', '010100002015550000CD1FD5C8001726419C2C6D52138B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513680, 'MT24', 'NL32-01', NULL, 'DANIKEN', 'Däniken', 'Daniken', '0101000020155500008983516E1C872341DB28CC8A05120E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513681, 'NS07', 'NL32-05', NULL, 'DANIS', 'Danis', 'Danis', '0101000020155500000BC3E2CC5A112641D7617043ECD60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513682, 'KS62', 'NL32-04', NULL, 'DARDAGNY', 'Dardagny', 'Dardagny', '010100002015550000701B3D8BEFD71D41349670F34DB1FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513683, 'MS06', 'NL32-04', NULL, 'DARLIGEN', 'Därligen', 'Darligen', '010100002015550000B35B716C8D272341572F617AEA8F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513684, 'LS86', 'NL32-04', NULL, 'DARSTETTEN', 'Därstetten', 'Darstetten', '0101000020155500001B9056273B6A224137D0458610540441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513685, 'MT45', 'NL32-02', NULL, 'DATTWIL', 'Dättwil', 'Dattwil', '010100002015550000137EDA0A33412441C997C943143A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513688, 'NS68', 'NL32-05', NULL, 'DAVOSDORF', 'Davos Dorf', 'Davos Dorf', '010100002015550000B6FF666A0DE32741BB62634C2BEE0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513689, 'NS68', 'NL32-05', NULL, 'DAVOSPLATZ', 'Davos Platz', 'Davos Platz', '010100002015550000B6FF666A0DE32741BB62634C2BEE0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513690, 'NT14', 'NL32-02', NULL, 'DEGERSHEIM', 'Degersheim', 'Degersheim', '010100002015550000FE9B2E96DA5E26418ACCA84A7D3C0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513691, 'LT80', 'NL32-04', NULL, 'DEISSWIL', 'Deisswil', 'Deisswil', '0101000020155500002ED47D1BE97D22410CF2541A54660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513692, 'LT93', 'NL32-01', NULL, 'DEITINGEN', 'Deitingen', 'Deitingen', '010100002015550000FF7C64ABDCB8224109C3C1D828050C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513694, 'LT74', 'NL32-01', 3, 'DELEMONT', 'Delémont', 'Delemont', '0101000020155500007C887C3D5D112241A2D1FD6A020E0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513696, 'MT25', 'NL32-02', NULL, 'DENSBUREN', 'Densbüren', 'Densburen', '010100002015550000F606B844B9B723417267C3B4FA340F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513701, 'LT92', 'NL32-01', NULL, 'DERENDINGEN', 'Derendingen', 'Derendingen', '0101000020155500002E7F798129A52241CD1FE2ED17CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513703, 'LS54', 'NL32-04', NULL, 'DEVANT', 'Devant', 'Devant', '0101000020155500000B93331D2A8E214121C99FBBF2640141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513708, 'MS38', 'NL32-05', NULL, 'DIECHTERSMATT', 'Diechtersmatt', 'Diechtersmatt', '0101000020155500009C0AF4CE5C0B244116A040BA57D90641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513709, 'MT05', 'NL32-01', NULL, 'DIEGTEN', 'Diegten', 'Diegten', '010100002015550000B040E1D48E242341F61BFB1384BD0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513710, 'MT55', 'NL32-02', NULL, 'DIELSDORF', 'Dielsdorf', 'Dielsdorf', '0101000020155500009049DE4405A32441227AA33C88B20F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513711, 'LS96', 'NL32-04', NULL, 'DIEMTIGEN', 'Diemtigen', 'Diemtigen', '0101000020155500006C2314FA179C22419B749EF0611A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513714, 'NT44', 'NL32-02', NULL, 'DIEPOLDSAU', 'Diepoldsau', 'Diepoldsau', '0101000020155500001D387A40175E274157DA12E929900E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513715, 'NS09', 'NL32-05', NULL, 'DIESBACH', 'Diesbach', 'Diesbach', '010100002015550000D748B4C0610E26411BB134EACD190841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513717, 'LT71', 'NL32-01', NULL, 'DIESSBACH', 'Diessbach', 'Diessbach', '0101000020155500005E4822E0D124224177D2E365706F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513718, 'LT51', 'NL32-01', NULL, 'DIESSE', 'Diesse', 'Diesse', '01010000201555000032E189DD9B902141B65069CFD6AA0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513719, 'MT88', 'NL32-02', NULL, 'DIESSENHOFEN', 'Diessenhofen', 'Diessenhofen', '0101000020155500001C60CBC381502541B22F4340DE561141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513720, 'MT55', 'NL32-02', 3, 'DIETIKON', 'Dietikon', 'Dietikon', '010100002015550000E82F4E554A8624413ED3FD4E6FC90E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513721, 'MT75', 'NL32-02', NULL, 'DIETLIKON', 'Dietlikon', 'Dietlikon', '01010000201555000067E52580CD0525412698C8224D0A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513722, 'MT52', 'NL32-02', NULL, 'DIETWIL', 'Dietwil', 'Dietwil', '010100002015550000749F34AA20892441ECD4C1C1022B0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513723, 'NS28', 'NL32-05', NULL, 'DIGG', 'Digg', 'Digg', '010100002015550000A9805671A2C226411C5C90426B080741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513724, 'MT86', 'NL32-02', NULL, 'DINHARD', 'Dinhard', 'Dinhard', '010100002015550000AE31CF287C5C25411B51F4F3A0521041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513725, 'MR99', 'NL32-05', NULL, 'DINO', 'Dino', 'Dino', '010100002015550000D1CD22E988F5254183E3CCACE3A8F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513726, 'MS87', 'NL32-05', NULL, 'DISENTIS', 'Disentis', 'Disentis', '01010000201555000084C0BD07C49A25417BC517970D200541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513727, 'MS97', 'NL32-05', NULL, 'DISLA', 'Disla', 'Disla', '0101000020155500008AA2DDF0A2B82541E29530A33D220541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513728, 'MR29', 'NL32-04', NULL, 'DISTEL', 'Distel', 'Distel', '010100002015550000A060FD5EFE8E2341F2F075B95680F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513730, 'LS06', 'NL32-04', NULL, 'DIZY', 'Dizy', 'Dizy', '010100002015550000F05496D2FF1320418689AF3A17280441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513731, 'MT37', 'NL32-02', NULL, 'DOGERN', 'Dogern', 'Dogern', '0101000020155500006D32E7F140FB23414703EB363FA01041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513739, 'NS38', 'NL32-05', NULL, 'DOMAT', 'Domat', 'Domat', '010100002015550000A9C0453F38FE26413D5B8517610E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513741, 'LT41', 'NL32-01', NULL, 'DOMBRESSON', 'Dombresson', 'Dombresson', '010100002015550000482108BF69372141AF37BC49F0FE0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513742, 'LS49', 'NL32-04', NULL, 'DOMDIDIER', 'Domdidier', 'Domdidier', '0101000020155500001EB7B5F6255421412C82647D73470741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513745, 'LS37', 'NL32-04', NULL, 'DOMPIERRE', 'Dompierre', 'Dompierre', '01010000201555000043A1B445B3032141C00AD70873060541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513746, 'LS49', 'NL32-04', NULL, 'DOMPIERRE', 'Dompierre', 'Dompierre', '0101000020155500006FF4BFB2234A214121D87210C50D0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513747, 'LS59', 'NL32-04', NULL, 'DONATYRE', 'Donatyre', 'Donatyre', '010100002015550000BAB1F10E007221416D4E720FBF800741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513748, 'MS94', 'NL32-05', NULL, 'DONGIO', 'Dongio', 'Dongio', '0101000020155500006024ABD6F7DA254180B49EA64B860141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513749, 'LS27', 'NL32-04', NULL, 'DONNELOYE', 'Donneloye', 'Donneloye', '010100002015550000B6C29DA384A02041F7C828E663B70541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513750, 'MT20', 'NL32-02', NULL, 'DOPPLESCHWAND', 'Doppleschwand', 'Doppleschwand', '0101000020155500007F113170A7BA2341B90EFBD57D530941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513751, 'LS41', 'NL32-04', NULL, 'DORENAZ', 'Dorénaz', 'Dorenaz', '010100002015550000E0CAEF2CE96421412B8CCDAAD21AFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513753, 'NS58', 'NL32-05', NULL, 'DORFLI', 'Dörfli', 'Dorfli', '010100002015550000616D2ABB63B127418F18676535E80641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513755, 'LT95', 'NL32-01', NULL, 'DORNACH', 'Dornach', 'Dornach', '010100002015550000BBF2CA1C5FB822414C9E174FC2690F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513756, 'LS98', 'NL32-04', NULL, 'DORNHALDEN', 'Dornhalden', 'Dornhalden', '010100002015550000C63B703EBDAF22414061E9F8855D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513757, 'NS09', 'NL32-05', NULL, 'DORNHAUS', 'Dornhaus', 'Dornhaus', '010100002015550000CAF8A67BE0032641BBDFC6AEC58C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513758, 'MT44', 'NL32-02', NULL, 'DOTTIKON', 'Dottikon', 'Dottikon', '0101000020155500007407FEAE53242441FD132D5F3A510E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513759, 'MT46', 'NL32-02', NULL, 'DOTTINGEN', 'Döttingen', 'Dottingen', '0101000020155500005CAFE241832C2441855582834C671041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513769, 'LR59', 'NL32-07', NULL, 'DRANSE', 'Dranse', 'Dranse', '010100002015550000C6EA1209EBB421416FDE86963092F640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513777, 'LS98', 'NL32-04', NULL, 'DREILIGASS', 'Dreiligass', 'Dreiligass', '010100002015550000226B8B9A87E122414F2121893CEA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513778, 'MS17', 'NL32-04', NULL, 'DREISCHUBEL', 'Dreischübel', 'Dreischubel', '01010000201555000098C81AA60B3B23412024E534B1EB0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513787, 'MT74', 'NL32-02', NULL, 'DUBENDORF', 'Dübendorf', 'Dubendorf', '010100002015550000C1BA09C73C062541BCE7918F7F960E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513788, 'LS69', 'NL32-04', NULL, 'DUDINGEN', 'Düdingen', 'Dudingen', '0101000020155500002E3683204FC12141D8347285B40B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513794, 'NS02', 'NL32-05', NULL, 'DUNO', 'Duno', 'Duno', '01010000201555000050D3EF2AE7052641C4DBA4B2298DFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513797, 'MT83', 'NL32-02', NULL, 'DURNTEN', 'Dürnten', 'Durnten', '010100002015550000B282C7AFE9912541B070101367D00C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513799, 'NS77', 'NL32-05', NULL, 'DURRBODEN', 'Dürrboden', 'Durrboden', '010100002015550000552656F07417284140ABE08F1D990541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513800, 'MT34', 'NL32-02', NULL, 'DURRENASCH', 'Dürrenäsch', 'Durrenasch', '010100002015550000FFAE4D808FF32341215FCDB1A0A10D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513801, 'MS89', 'NL32-05', NULL, 'DURRENBODEN', 'Dürrenboden', 'Durrenboden', '010100002015550000173C2FE3348D2541AABA89E1D0490841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513802, 'MT01', 'NL32-01', NULL, 'DURRENROTH', 'Dürrenroth', 'Durrenroth', '0101000020155500006775B04A001C234158E746643E370A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513805, 'NS27', 'NL32-05', NULL, 'DUTJEN', 'Dutjen', 'Dutjen', '01010000201555000080C6EAF05392264183C713AB251C0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513806, 'NS17', 'NL32-05', NULL, 'DUVIN', 'Duvin', 'Duvin', '010100002015550000571B70277B75264174D6A0FABF6B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513807, 'KS82', 'NL32-04', NULL, 'EAUXVIVES', 'Eaux-Vives', 'Eaux-Vives', '010100002015550000C3AFFA04D38C1E416563D8A2B5A4FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513810, 'MT41', 'NL32-02', NULL, 'EBIKON', 'Ebikon', 'Ebikon', '010100002015550000D12D70D049622441E7849F408B410A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513811, 'MS27', 'NL32-04', NULL, 'EBLIGEN', 'Ebligen', 'Ebligen', '01010000201555000023869B34B68A23419B92A6A6A9B30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513812, 'NT03', 'NL32-02', NULL, 'EBNAT', 'Ebnat', 'Ebnat', '010100002015550000607FC1FFDA2F26418A0FAD31EDA20C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513814, 'LS16', 'NL32-04', NULL, 'ECHALLENS', 'Echallens', 'Echallens', '0101000020155500004253AA51BB6D20414B74BE640E240441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513815, 'LS56', 'NL32-04', NULL, 'ECHARLENS', 'Echarlens', 'Echarlens', '010100002015550000EB913D4E097121414B1B6E2E28560441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513816, 'LS61', 'NL32-04', NULL, 'ECONE', 'Ecône', 'Econe', '0101000020155500001886DE8A73BF2141163E369DEA17FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513817, 'LS36', 'NL32-04', NULL, 'ECUBLENS', 'Ecublens', 'Ecublens', '010100002015550000BC640A4833D12041CABD04B195AC0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513818, 'LS57', 'NL32-04', NULL, 'ECUVILLENS', 'Ecuvillens', 'Ecuvillens', '0101000020155500008886140E667B2141F372D85A5DB10541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513820, 'MT35', 'NL32-02', NULL, 'EFFINGEN', 'Effingen', 'Effingen', '0101000020155500007F84DDB8C0DE23419483C53F15AA0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513821, 'MT75', 'NL32-02', NULL, 'EFFRETIKON', 'Effretikon', 'Effretikon', '010100002015550000988DEA3F172D25411826E648BA0C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513822, 'MT04', 'NL32-01', NULL, 'EGERKINGEN', 'Egerkingen', 'Egerkingen', '0101000020155500002535A5994411234106510734BB610D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513823, 'MT73', 'NL32-02', NULL, 'EGG', 'Egg', 'Egg', '0101000020155500003FC1C08DED2E2541925F3F42873D0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513824, 'NS48', 'NL32-05', NULL, 'EGGA', 'Egga', 'Egga', '0101000020155500009928F63CA530274115D535C2D19F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513825, 'LS94', 'NL32-04', NULL, 'EGGENSCHWAND', 'Eggenschwand', 'Eggenschwand', '010100002015550000998682D64BD8224161AE62FDD5110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513826, 'MT44', 'NL32-02', NULL, 'EGGENWIL', 'Eggenwil', 'Eggenwil', '0101000020155500009CA86AAA7B5F2441CAE1613ADD190E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513827, 'MS12', 'NL32-04', NULL, 'EGGERBERG', 'Eggerberg', 'Eggerberg', '01010000201555000065E4651A1151234175BC593BB9A1FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513828, 'NT35', 'NL32-02', NULL, 'EGGERSRIET', 'Eggersriet', 'Eggersriet', '010100002015550000173E7F194EFA26419E00017A226D0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513830, 'MS09', 'NL32-04', NULL, 'EGGIWIL', 'Eggiwil', 'Eggiwil', '010100002015550000505C3D42C31C2341E4BFFBC76D800741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513832, 'MT66', 'NL32-02', NULL, 'EGLISAU', 'Eglisau', 'Eglisau', '0101000020155500003BB9CCB0DFDC2441C02D28B69E6B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513833, 'MT34', 'NL32-02', NULL, 'EGLISWIL', 'Egliswil', 'Egliswil', '010100002015550000E21CC30D1B072441265E421943DC0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513834, 'NT26', 'NL32-02', NULL, 'EGNACH', 'Egnach', 'Egnach', '0101000020155500008215ECBF9FBD26416121A79453441041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513836, 'MT32', 'NL32-02', NULL, 'EICH', 'Eich', 'Eich', '01010000201555000016D0CEE6E0FE23415F9125370F250B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513837, 'NT44', 'NL32-02', NULL, 'EICHBERG', 'Eichberg', 'Eichberg', '01010000201555000021910228E4232741D6088587F0150E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513838, 'MT40', 'NL32-02', NULL, 'EIGENTHAL', 'Eigenthal', 'Eigenthal', '0101000020155500000B10C0C5A61D244129E360DAFE560941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513840, 'MT26', 'NL32-01', NULL, 'EIKEN', 'Eiken', 'Eiken', '01010000201555000002F41137F18F2341BD25897DAE2A1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513841, 'LS97', 'NL32-04', NULL, 'EINIGEN', 'Einigen', 'Einigen', '0101000020155500003D4A185CCCC322410E22EA73343C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513842, 'MT81', 'NL32-02', NULL, 'EINSIEDELN', 'Einsiedeln', 'Einsiedeln', '010100002015550000E4A55CACF95825414659867F3BC30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513844, 'MS02', 'NL32-04', NULL, 'EISCHOLL', 'Eischoll', 'Eischoll', '01010000201555000050748C280C1F23413194C3AA28B8FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513846, 'LS81', 'NL32-04', NULL, 'EISON', 'Eison', 'Eison', '01010000201555000092E4EED0696022419A5AF7E22B16FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513847, 'MS11', 'NL32-04', NULL, 'EISTEN', 'Eisten', 'Eisten', '010100002015550000948ADA62B8652341CE7EBF9E1078FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513849, 'MT86', 'NL32-02', NULL, 'ELGG', 'Elgg', 'Elgg', '010100002015550000B20F9D8F1398254148D91EE9AFFB0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513852, 'MT77', 'NL32-02', NULL, 'ELLIKONAMRHEIN', 'Ellikon am Rhein', 'Ellikon am Rhein', '0101000020155500003CA9A616A1032541265BD016ABA61041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513853, 'MT86', 'NL32-02', NULL, 'ELLIKONANDERTHUR', 'Ellikon an der Thur', 'Ellikon an der Thur', '010100002015550000E05A0F9FA17925410240000B98701041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513854, 'NS19', 'NL32-05', NULL, 'ELM', 'Elm', 'Elm', '01010000201555000042F0CFD6CB5326417AEB74F0B61F0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513855, 'MT86', 'NL32-02', NULL, 'ELSAU', 'Elsau', 'Elsau', '010100002015550000EC49630CC8662541F9109C8F0F191041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513856, 'LS95', 'NL32-04', NULL, 'ELSIGBACH', 'Elsigbach', 'Elsigbach', '0101000020155500002EFDA58E36B022411DA8F8DB22BF0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513857, 'MS11', 'NL32-04', NULL, 'EMBD', 'Embd', 'Embd', '01010000201555000067E5F5CB713D2341EFF7DDE51BEAFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513858, 'MT66', 'NL32-02', NULL, 'EMBRACH', 'Embrach', 'Embrach', '01010000201555000094018CA01FFB2441FCCB1D9653F10F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513860, 'MT41', 'NL32-02', NULL, 'EMMEN', 'Emmen', 'Emmen', '0101000020155500005E149792834E244112DA6EB9A8400A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513861, 'MT41', 'NL32-02', NULL, 'EMMENBRUCKE', 'Emmenbrücke', 'Emmenbrucke', '010100002015550000E2D81366E43A2441AE03CE90E8050A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513862, 'MT00', 'NL32-04', NULL, 'EMMENMATT', 'Emmenmatt', 'Emmenmatt', '0101000020155500004E03FF26AF0823413A21CB45B3670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513865, 'MT60', 'NL32-05', NULL, 'EMMETTEN', 'Emmetten', 'Emmetten', '010100002015550000720A060F70D0244171760712BCB10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513867, 'NT17', 'NL32-02', NULL, 'EMMISHOFEN', 'Emmishofen', 'Emmishofen', '010100002015550000237AA048C4452641BD7175357C091141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513868, 'LS30', 'NL32-04', NULL, 'EMOSSON', 'Emosson', 'Emosson', '010100002015550000D4AF76CAF213214181A91F8197DBF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513875, 'LT80', 'NL32-04', NULL, 'ENGEHALDE', 'Engehalde', 'Engehalde', '0101000020155500005D37302E594C2241C9264C2D3D660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513876, 'MS58', 'NL32-05', NULL, 'ENGELBERG', 'Engelberg', 'Engelberg', '010100002015550000098127066E962441E4FC2F9072DF0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513877, 'LT61', 'NL32-01', NULL, 'ENGELBERG', 'Engelberg', 'Engelberg', '0101000020155500009A92C07F16B8214170BC5C215A700A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513881, 'NT10', 'NL32-05', NULL, 'ENGI', 'Engi', 'Engi', '010100002015550000DBADF0F69D4826411592CE3265060941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513887, 'LS57', 'NL32-04', NULL, 'ENLAGOTTAZ', 'En la Gottaz', 'En la Gottaz', '010100002015550000F2362DEC2885214127FD8AAC7D030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513888, 'NT00', 'NL32-02', NULL, 'ENNENDA', 'Ennenda', 'Ennenda', '01010000201555000097D81B34172026415D157C5FACB00941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513889, 'MT40', 'NL32-05', NULL, 'ENNETBURGEN', 'Ennetbürgen', 'Ennetburgen', '010100002015550000C271D6434763244195CC6A0C27E60841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513890, 'MT20', 'NL32-05', NULL, 'ENNETEGG', 'Ennetegg', 'Ennetegg', '0101000020155500009787454611A7234142F7DD3C17DF0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513891, 'LS55', 'NL32-04', NULL, 'ENNEY', 'Enney', 'Enney', '0101000020155500002A991DD8AC7A2141E7FD43CC7A340341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513892, 'LS53', 'NL32-04', NULL, 'ENSEX', 'Ensex', 'Ensex', '01010000201555000085C45ED4C78321419ABF4BBFBA090041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513893, 'LS68', 'NL32-04', NULL, 'ENTENMOOS', 'Entenmoos', 'Entenmoos', '01010000201555000004203A3AEDDE2141EF7EE40CE1E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513895, 'MT20', 'NL32-05', NULL, 'ENTLEBUCH', 'Entlebuch', 'Entlebuch', '0101000020155500007BCB0413C9C42341DF8CA1EE00E00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513899, 'LS25', 'NL32-04', NULL, 'EPALINGES', 'Epalinges', 'Epalinges', '0101000020155500008FECFB85F5802041236ACEC2C5010341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513900, 'LS17', 'NL32-04', NULL, 'EPAUTHEYRES', 'Epautheyres', 'Epautheyres', '010100002015550000B2F6ABF29F6E2041549C87176F7F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513901, 'LS17', 'NL32-04', NULL, 'EPENDES', 'Ependes', 'Ependes', '0101000020155500004FC08445AC642041A47413F9D87F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513902, 'LS57', 'NL32-04', NULL, 'EPENDES', 'Ependes', 'Ependes', '010100002015550000AE88B5183F9921417594D338DCB00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513903, 'LS41', 'NL32-04', NULL, 'EPINASSEY', 'Épinassey', 'Epinassey', '010100002015550000656512A7E44621414A11BBFCB003FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513904, 'MT14', 'NL32-01', NULL, 'EPTINGEN', 'Eptingen', 'Eptingen', '010100002015550000179AE4FB852E2341336644EAE2490E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513905, 'LS62', 'NL32-04', NULL, 'ERDE', 'Erde', 'Erde', '01010000201555000092467273F7FB214119821E7688CDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513907, 'MT11', 'NL32-01', NULL, 'ERISWIL', 'Eriswil', 'Eriswil', '01010000201555000053D4524E8D43234147DFEF2D01380A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513908, 'MS08', 'NL32-04', NULL, 'ERIZ', 'Eriz', 'Eriz', '010100002015550000C56C2F503313234116D1761DDC240641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513909, 'LT51', 'NL32-01', NULL, 'ERLACH', 'Erlach', 'Erlach', '010100002015550000CAEC3CEC69862141023D27927E890941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513910, 'NT16', 'NL32-02', NULL, 'ERLEN', 'Erlen', 'Erlen', '01010000201555000060B59C7AE06E2641AFBB37608D5D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513911, 'MT63', 'NL32-02', NULL, 'ERLENBACH', 'Erlenbach', 'Erlenbach', '010100002015550000D8842AD5B1FD2441CCB4083F823A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513912, 'LS86', 'NL32-04', NULL, 'ERLENBACHIMSIMMENTAL', 'Erlenbach im Simmental', 'Erlenbach im Simmental', '01010000201555000058C27AFC14922241BEE423E21E8E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513916, 'NT07', 'NL32-02', NULL, 'ERMATINGEN', 'Ermatingen', 'Ermatingen', '01010000201555000005573FF68E142641CCF53E2055241141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513917, 'MS33', 'NL32-05', NULL, 'ERNEN', 'Ernen', 'Ernen', '0101000020155500002B74D6D2E7FA2341ECA259344AF70041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513919, 'LS93', 'NL32-04', NULL, 'ERSCHMATT', 'Erschmatt', 'Erschmatt', '010100002015550000805DDCAABEE22241E239478BF29DFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513920, 'LT84', 'NL32-01', NULL, 'ERSCHWIL', 'Erschwil', 'Erschwil', '0101000020155500006E3D90E66387224170D0F5C5F80D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513921, 'LT91', 'NL32-01', NULL, 'ERSIGEN', 'Ersigen', 'Ersigen', '0101000020155500006A6F271159A5224196C672A7C4350A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513922, 'MS78', 'NL32-05', NULL, 'ERSTFELD', 'Erstfeld', 'Erstfeld', '01010000201555000019E1A883C71725418A903D86B4AC0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513923, 'MS12', 'NL32-04', NULL, 'ESCH', 'Esch', 'Esch', '010100002015550000A787BEA94D5123417059205E5646FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513924, 'MT42', 'NL32-02', NULL, 'ESCHENBACH', 'Eschenbach', 'Eschenbach', '010100002015550000B4EBE856EA572441105A55D3CBEE0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513925, 'MT93', 'NL32-02', NULL, 'ESCHENBACH', 'Eschenbach', 'Eschenbach', '010100002015550000D6643613DEB92541DC0082F1835F0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513926, 'MT87', 'NL32-02', NULL, 'ESCHENZ', 'Eschenz', 'Eschenz', '010100002015550000F18F936EB4952541167B7EB266021141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513928, 'NT06', 'NL32-02', NULL, 'ESCHIKOFEN', 'Eschikofen', 'Eschikofen', '01010000201555000097B616FCE6EE2541FE4DEF48F9911041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513929, 'MT95', 'NL32-02', NULL, 'ESCHLIKON', 'Eschlikon', 'Eschlikon', '0101000020155500005CC61AC97ED32541C461917D538C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513931, 'MS19', 'NL32-04', NULL, 'ESCHOLZMATT', 'Escholzmatt', 'Escholzmatt', '010100002015550000025AE3DDE6752341C549160D23F60741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513933, 'KS95', 'NL32-04', NULL, 'ESSERTINESSURROLLE', 'Essertines-sur-Rolle', 'Essertines-sur-Rolle', '010100002015550000C46FCC0D485D1F41380BB2663C5E0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513935, 'LS55', 'NL32-04', NULL, 'ESTAVANNENSDESSOUS', 'Estavannens-Dessous', 'Estavannens-Dessous', '010100002015550000BC109386A88421419BD3FF6E4D340341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513936, 'LS55', 'NL32-04', NULL, 'ESTAVANNENSDESSUS', 'Estavannens-Dessus', 'Estavannens-Dessus', '010100002015550000BC109386A88421419BD3FF6E4D340341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513938, 'LS39', 'NL32-04', NULL, 'ESTAVAYERLELAC', 'Estavayer-le-Lac', 'Estavayer-le-Lac', '0101000020155500000CDAEF66C3F020415CB160C01D100741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513939, 'LT41', 'NL32-01', NULL, 'ETITSAVAGNIER', 'etit-Savagnier', 'etit-Savagnier', '0101000020155500003AF928946E2D2141BEEBB5A447C50941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513940, 'LT95', 'NL32-01', NULL, 'ETTINGEN', 'Ettingen', 'Ettingen', '010100002015550000251601421591224121ED364161A30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513941, 'MT22', 'NL32-02', NULL, 'ETTISWIL', 'Ettiswil', 'Ettiswil', '0101000020155500008010208400A62341AA5C50451A220B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513943, 'MT82', 'NL32-02', NULL, 'ETZEL', 'Etzel', 'Etzel', '010100002015550000A31A97191D7625413917F0A60A390B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513945, 'MT36', 'NL32-02', NULL, 'ETZGEN', 'Etzgen', 'Etzgen', '010100002015550000C901075654D423412CAAEBFBA4651041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513946, 'MT87', 'NL32-02', NULL, 'ETZWILEN', 'Etzwilen', 'Etzwilen', '010100002015550000CD4B17235C782541747E41FA59011141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513947, 'LS71', 'NL32-04', NULL, 'EUSEIGNE', 'Euseigne', 'Euseigne', '010100002015550000E90F74B63C422241C80FB789F689FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513949, 'MT81', 'NL32-02', NULL, 'EUTHAL', 'Euthal', 'Euthal', '010100002015550000D9602D1AC08025414957CB2A0C8C0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513950, 'LT62', 'NL32-01', NULL, 'EVILARD', 'Evilard', 'Evilard', '01010000201555000070FFCC31DBD52141E440F845B61D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513951, 'LR49', 'NL32-04', NULL, 'EVIONNAZ', 'Evionnaz', 'Evionnaz', '0101000020155500003D89908A2A502141F99C185B487DF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513952, 'LS80', 'NL32-04', NULL, 'EVOLENE', 'Evolène', 'Evolene', '010100002015550000A03F49508E74224109CC4B5FAA2EFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513953, 'LS43', 'NL32-04', NULL, 'EXERGILLOD', 'Exergillod', 'Exergillod', '01010000201555000086D19805AD5B2141527B69167E0A0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513955, 'MS12', 'NL32-04', NULL, 'EYHOLZ', 'Eyholz', 'Eyholz', '010100002015550000CF6B35A0546F2341EAF37B7185BBFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513957, 'KS84', 'NL32-04', NULL, 'EYSINS', 'Eysins', 'Eysins', '010100002015550000C3E1330A28CE1E41F726E0A336CD0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513958, 'MS63', 'NL32-05', NULL, 'FAEDO', 'Faedo', 'Faedo', '010100002015550000BE44ECEF6DEB2441555939748FC80041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513959, 'MS14', 'NL32-04', NULL, 'FAFLERALP', 'Fafleralp', 'Fafleralp', '010100002015550000C6C2EED3814623419A5B7167EE650141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513960, 'LS98', 'NL32-04', NULL, 'FAHRNI', 'Fahrni', 'Fahrni', '0101000020155500007F322BE97FD72241C5B5AC96EA5D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513961, 'MT43', 'NL32-02', NULL, 'FAHRWANGEN', 'Fahrwangen', 'Fahrwangen', '010100002015550000018F8D470F252441A6C5278FB52F0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513962, 'LT45', 'NL32-01', NULL, 'FAHY', 'Fahy', 'Fahy', '010100002015550000748F69B26B2F2141C9508AD92ABF0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513963, 'MS84', 'NL32-05', NULL, 'FAIDO', 'Faido', 'Faido', '0101000020155500003DDF522069802541DC9AA8C37AF30141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513965, 'MS03', 'NL32-04', NULL, 'FALDUMALP', 'Faldum Alp', 'Faldum Alp', '010100002015550000FA0429FDA10A23416CDF850422B70041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513966, 'NS18', 'NL32-05', NULL, 'FALERA', 'Falera', 'Falera', '010100002015550000E3A68C43D7732641A6C97E982C8D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513969, 'MT74', 'NL32-02', NULL, 'FALLANDEN', 'Fällanden', 'Fallanden', '0101000020155500006B6B3FA581102541B66375904A230E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513970, 'NT40', 'NL32-05', NULL, 'FANAS', 'Fanas', 'Fanas', '0101000020155500007EF4604CB67127417C240B0D1D240941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513971, 'LS82', 'NL32-04', NULL, 'FANG', 'Fang', 'Fang', '0101000020155500009B189224A89C22419C8FDF23A259FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513972, 'MT10', 'NL32-04', NULL, 'FANKHAUS', 'Fankhaus', 'Fankhaus', '0101000020155500001634385DCF61234135A9F3E75AA30841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513973, 'LS59', 'NL32-04', NULL, 'FAOUG', 'Faoug', 'Faoug', '010100002015550000E4BFE597FD7B214122F5D04C76BA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513974, 'NS36', 'NL32-05', NULL, 'FARDUN', 'Fardün', 'Fardun', '0101000020155500007A230DD0BCEE264146123FD5C8550441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513975, 'MS67', 'NL32-05', NULL, 'FARNIGEN', 'Färnigen', 'Farnigen', '01010000201555000056C1B0B838D32441B563EF1F34870541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513977, 'LS57', 'NL32-04', NULL, 'FARVAGNYLEGRAND', 'Farvagny-le-Grand', 'Farvagny-le-Grand', '0101000020155500009F6850CE4F71214118FA3B7AC03D0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513978, 'LS57', 'NL32-04', NULL, 'FARVAGNYLEPETIT', 'Farvagny-le-Petit', 'Farvagny-le-Petit', '01010000201555000068E5B037557B21411246DF2777770541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513983, 'MS06', 'NL32-04', NULL, 'FAULENSEE', 'Faulensee', 'Faulensee', '0101000020155500001B1BE3A8BAF52241B93F420D1B8F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513986, 'MT84', 'NL32-02', NULL, 'FEHRALTORF', 'Fehraltorf', 'Fehraltorf', '010100002015550000E2B1C3B21A552541DF03BA8A96610E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513987, 'MT96', 'NL32-02', NULL, 'FELBEN', 'Felben', 'Felben', '01010000201555000071E6F71FEFBD254176D2E6390E901041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513988, 'MS33', 'NL32-05', NULL, 'FELD', 'Feld', 'Feld', '010100002015550000851016223F2324416BF943C804850041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513989, 'MT83', 'NL32-02', NULL, 'FELDBACH', 'Feldbach', 'Feldbach', '01010000201555000097EC8B47C06A25419FC9A892BC930C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513990, 'MT97', 'NL32-02', NULL, 'FELDBACH', 'Feldbach', 'Feldbach', '010100002015550000F92D0DCBE3D92541F979BA6CF2211141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513991, 'LT93', 'NL32-01', NULL, 'FELDBRUNNEN', 'Feldbrunnen', 'Feldbrunnen', '01010000201555000070DB9BC368912241EEBDB2C6DE040C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513993, 'NS38', 'NL32-05', NULL, 'FELDIS', 'Feldis', 'Feldis', '010100002015550000059B7A9D64F5264124B16079B85F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513994, 'MT73', 'NL32-02', NULL, 'FELDMEILEN', 'Feldmeilen', 'Feldmeilen', '010100002015550000AE7D263CC20725415A9BF44832010D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513995, 'MS57', 'NL32-05', NULL, 'FELDMOOS', 'Feldmoos', 'Feldmoos', '010100002015550000634E1B768F8D244176FAFE3295830541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513996, 'NT45', 'NL32-02', NULL, 'FELDMOOS', 'Feldmoos', 'Feldmoos', '010100002015550000E8FA8C3DA03E2741759A32A055AE0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513999, 'NS38', 'NL32-05', NULL, 'FELSBERG', 'Felsberg', 'Felsberg', '0101000020155500004D908028B4112741F88A9E7B504A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514000, 'LT80', 'NL32-04', NULL, 'FELSENAU', 'Felsenau', 'Felsenau', '010100002015550000E84FD079594C2241C2041FFE23A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514010, 'MS03', 'NL32-04', NULL, 'FERDEN', 'Ferden', 'Ferden', '010100002015550000FA0429FDA10A23416CDF850422B70041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514011, 'LT60', 'NL32-04', NULL, 'FERENBALM', 'Ferenbalm', 'Ferenbalm', '01010000201555000017D3A1A57CCB214101621806FE660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514012, 'LS85', 'NL32-04', NULL, 'FERMELBERG', 'Fermelberg', 'Fermelberg', '010100002015550000D46FB7B24B6A2241F657BE9CDF840241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514017, 'LR58', 'NL32-07', NULL, 'FERRET', 'Ferret', 'Ferret', '010100002015550000784ABB8F368221411D61B71E87C4F440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514031, 'LS93', 'NL32-04', NULL, 'FESCHEL', 'Feschel', 'Feschel', '010100002015550000BA596925B3E2224180CCDC29DF080041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514035, 'NS98', 'NL32-06', NULL, 'FETAN', 'Fetan', 'Fetan', '010100002015550000861CE91BEDD128410C913AA0DAD30641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514038, 'MT78', 'NL32-02', NULL, 'FEUERTHALEN', 'Feuerthalen', 'Feuerthalen', '010100002015550000481B517D510C25419A5E82B4BA371141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514039, 'MT72', 'NL32-02', NULL, 'FEUSISBERG', 'Feusisberg', 'Feusisberg', '0101000020155500009A3BB7B9234E2541EAE1C7D628AA0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514040, 'LS64', 'NL32-04', NULL, 'FEUTERSOEY', 'Feutersoey', 'Feutersoey', '010100002015550000942A8CDA33E82141383E0128E9290141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514042, 'LS43', 'NL32-04', NULL, 'FEYDEY', 'Feydey', 'Feydey', '0101000020155500003FB670A49F472141E45F63DAEC0A0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514043, 'NS28', 'NL32-05', NULL, 'FIDAZ', 'Fidaz', 'Fidaz', '0101000020155500007A2202727FA4264107B865E06F3F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514044, 'NS59', 'NL32-05', NULL, 'FIDERIS', 'Fideris', 'Fideris', '010100002015550000DFAE1FA4EAA42741CC08D7F74B420841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514047, 'NS69', 'NL32-05', NULL, 'FIDERISERALPDURANNA', 'Fideriser Alp Duranna', 'Fideriser Alp Duranna', '010100002015550000108D8366E1CD2741E2C98BCA61990741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514048, 'MS33', 'NL32-05', NULL, 'FIESCH', 'Fiesch', 'Fiesch', '01010000201555000096A5F057E4F02341AC462C60EEF60041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514049, 'MS34', 'NL32-05', NULL, 'FIESCHERTHAL', 'Fiescherthal', 'Fiescherthal', '010100002015550000B569193FC6FA2341475DBDA32F310141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514050, 'MS74', 'NL32-05', NULL, 'FIESSO', 'Fiesso', 'Fiesso', '010100002015550000B090F9762C4E25416DD08277012A0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514051, 'LS18', 'NL32-04', NULL, 'FIEZ', 'Fiez', 'Fiez', '010100002015550000D69CB5A0956520411AB8AF733ADB0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514052, 'LS85', 'NL32-04', NULL, 'FILDERICH', 'Filderich', 'Filderich', '010100002015550000C68C450E447422410C59E885B2F80241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514053, 'NS56', 'NL32-05', NULL, 'FILISUR', 'Filisur', 'Filisur', '010100002015550000B2FEFAAB628D2741236CD079B5DA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514054, 'NT01', 'NL32-02', NULL, 'FILZBACH', 'Filzbach', 'Filzbach', '01010000201555000088A74D1455322641D10FDF51CCD30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514059, 'MS11', 'NL32-04', NULL, 'FINDELNBEISTALDENREID', 'Findeln bei Staldenreid', 'Findeln bei Staldenreid', '010100002015550000A8A36860C56F2341ED4B5AB38B78FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514060, 'LS40', 'NL32-04', NULL, 'FINHAUT', 'Finhaut', 'Finhaut', '010100002015550000D5323EFD4232214144E9521CDA4DF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514064, 'LR69', 'NL32-04', NULL, 'FIONNAY', 'Fionnay', 'Fionnay', '010100002015550000A7CC0FB0A1FB2141F76C042829ECF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514066, 'MT94', 'NL32-02', NULL, 'FISCHENTHAL', 'Fischenthal', 'Fischenthal', '0101000020155500006CDD41333BB82541283BDE80E3BA0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514067, 'MT95', 'NL32-02', NULL, 'FISCHINGEN', 'Fischingen', 'Fischingen', '010100002015550000567E425357D42541BBD4841FA2DE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514068, 'MT67', 'NL32-02', NULL, 'FLAACH', 'Flaach', 'Flaach', '0101000020155500008F16495B0DFA2441445EE7766C891041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514069, 'LS79', 'NL32-04', NULL, 'FLAMATT', 'Flamatt', 'Flamatt', '0101000020155500000F112423F2FC2141E0AD1709EE7E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514070, 'NT30', 'NL32-02', NULL, 'FLASCH', 'Fläsch', 'Flasch', '0101000020155500006404BC84B9212741DD01331A368F0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514071, 'NT15', 'NL32-02', NULL, 'FLAWIL', 'Flawil', 'Flawil', '010100002015550000EF619F110E54264191CF8F5C4AE90E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514074, 'NS37', 'NL32-05', NULL, 'FLERDEN', 'Flerden', 'Flerden', '01010000201555000083B47A8352E326419233E2BC4E3C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514076, 'LS19', 'NL32-04', NULL, 'FLEURIER', 'Fleurier', 'Fleurier', '01010000201555000090AE46965952204178494510ABC30741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514077, 'NS28', 'NL32-05', NULL, 'FLIMS', 'Flims', 'Flims', '010100002015550000825E1FF8E89A264178D822439D040741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514081, 'NS17', 'NL32-05', NULL, 'FLOND', 'Flond', 'Flond', '0101000020155500005FB8A2BFB84C264101EB7C84DD150641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514084, 'MS49', 'NL32-05', NULL, 'FLUELI', 'Flüeli', 'Flueli', '010100002015550000FEA69A7CB93C244112DD9DB1204F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514085, 'MS79', 'NL32-05', NULL, 'FLUELN', 'Flüeln', 'Flueln', '0101000020155500009050F2C7C10C2541DBA1AB0393CD0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514087, 'LS93', 'NL32-04', NULL, 'FLUHALP', 'Fluhalp', 'Fluhalp', '01010000201555000029361D8181D82241440CA02F58F00041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514090, 'MS29', 'NL32-05', NULL, 'FLUHLI', 'Flühli', 'Fluhli', '0101000020155500002969BE40C89D2341C214009767830741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514092, 'NT21', 'NL32-02', NULL, 'FLUMS', 'Flums', 'Flums', '010100002015550000D7628E4258BD26410CD2552FAF6C0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514093, 'MT78', 'NL32-02', NULL, 'FLURLINGEN', 'Flurlingen', 'Flurlingen', '010100002015550000481B517D510C25419A5E82B4BA371141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514095, 'LT31', 'NL32-01', NULL, 'FONTAINEMELON', 'Fontainemelon', 'Fontainemelon', '010100002015550000BE8A8D5EDB052141D5FB88EE55C60941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514096, 'MS65', 'NL32-05', NULL, 'FONTANA', 'Fontana', 'Fontana', '010100002015550000552164E7C7F32441749757C845980241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514097, 'NS98', 'NL32-06', NULL, 'FONTANA', 'Fontana', 'Fontana', '010100002015550000147DABC050E62841BC599548D79C0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514098, 'LT55', 'NL32-01', NULL, 'FONTENAIS', 'Fontenais', 'Fontenais', '010100002015550000092064C3F67D214180C6885190830E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514101, 'LS35', 'NL32-04', NULL, 'FOREL', 'Forel', 'Forel', '0101000020155500003B011302D5DA2041510ED98392FE0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514102, 'LS37', 'NL32-04', NULL, 'FOREL', 'Forel', 'Forel', '010100002015550000B31D80DA18DC20410C1F7A5E717B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514103, 'MS82', 'NL32-05', NULL, 'FORNA', 'Forna', 'Forna', '0101000020155500006F435CA60BAB2541E11AE50DDF66FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514104, 'MR89', 'NL32-08', NULL, 'FORNASETTE', 'Fornasette', 'Fornasette', '01010000201555000078C4B35ADA7D2541DEE5CC722954F640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514107, 'MS63', 'NL32-05', NULL, 'FOROGLIO', 'Foroglio', 'Foroglio', '010100002015550000BA4BEB6AA2EB2441C43E85FFAA8E0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514108, 'KS83', 'NL32-04', NULL, 'FOUNEX', 'Founex', 'Founex', '0101000020155500004ED39A89C8CC1E41CAFEE92F8A1F0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514113, 'LT60', 'NL32-04', NULL, 'FRASCHELS', 'Fräschels', 'Fraschels', '010100002015550000E6041EB891CB214150D2EB7DCBDA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514114, 'MS83', 'NL32-05', NULL, 'FRASCO', 'Frasco', 'Frasco', '01010000201555000057BE047A6B8225412EAD4B8E5C240041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514115, 'LT81', 'NL32-01', NULL, 'FRAUBRUNNEN', 'Fraubrunnen', 'Fraubrunnen', '0101000020155500008133F6F5CB7D2241E992049E8B350A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514116, 'MT96', 'NL32-02', 3, 'FRAUENFELD', 'Frauenfeld', 'Frauenfeld', '01010000201555000059B946C9E2AA2541AC9B809C6A551041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514117, 'LT70', 'NL32-04', NULL, 'FRAUENKAPPELEN', 'Frauenkappelen', 'Frauenkappelen', '01010000201555000056E0C7AEDF1022415B69F9DE68660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514118, 'NS57', 'NL32-05', NULL, 'FRAUENKIRCH', 'Frauenkirch', 'Frauenkirch', '010100002015550000E2EB6F39FCC627412244833B12030641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514124, 'MS43', 'NL32-05', NULL, 'FREICHE', 'Freiche', 'Freiche', '01010000201555000074901CDE223724418C520FB4B9BF0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514125, 'LT96', 'NL32-01', NULL, 'FREIDORF', 'Freidorf', 'Freidorf', '010100002015550000A1CE399F0BC22241D3012BA9BE281041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514126, 'MT82', 'NL32-02', NULL, 'FREIENBACH', 'Freienbach', 'Freienbach', '010100002015550000E515D200C4572541976EF326B6E40B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514127, 'LS52', 'NL32-04', NULL, 'FRENIERES', 'Frenières', 'Frenieres', '010100002015550000F5931FED736F21419C475A520145FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514128, 'MT06', 'NL32-01', NULL, 'FRENKENDORF', 'Frenkendorf', 'Frenkendorf', '01010000201555000031E9C2D22BF322411C8AD75C42DE0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514130, 'LS58', 'NL32-04', 3, 'FRIBOURG', 'Fribourg', 'Fribourg', '010100002015550000CD36FF2D5BA32141D8E2FF58685E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514134, 'MT26', 'NL32-02', NULL, 'FRICK', 'Frick', 'Frick', '010100002015550000ADF2B6ADC3A323411E23076F1BE20F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514135, 'MT04', 'NL32-01', NULL, 'FRIEDAU', 'Friedau', 'Friedau', '0101000020155500009077F403E424234147160170FB9B0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514136, 'LT60', 'NL32-04', NULL, 'FRIESWIL', 'Frieswil', 'Frieswil', '010100002015550000F9A246B849E92141C0F89FAB7EDA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514137, 'MS83', 'NL32-05', NULL, 'FRODA', 'Froda', 'Froda', '01010000201555000039E6AA10206E254149EADF89E05C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514138, 'MS64', 'NL32-05', NULL, 'FRODA', 'Froda', 'Froda', '01010000201555000034BA5FE89DFE2441A6A8D31C48B10141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514140, 'LS26', 'NL32-04', NULL, 'FROIDEVILLE', 'Froideville', 'Froideville', '01010000201555000090C21D1B5D8B2041CB50844A12AF0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514142, 'LS45', 'NL32-04', NULL, 'FRUENCE', 'Fruence', 'Fruence', '010100002015550000BD06631A8E162141D87C7EB506890241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514143, 'NS05', 'NL32-05', NULL, 'FRUNT', 'Frunt', 'Frunt', '010100002015550000DBA5893D3D3C26414BB6A77466970341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514144, 'LS95', 'NL32-04', NULL, 'FRUTIGEN', 'Frutigen', 'Frutigen', '010100002015550000C2BDC58710CE2241CBA34C8F1D6D0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514145, 'MS48', 'NL32-05', NULL, 'FRUTT', 'Frutt', 'Frutt', '010100002015550000C91DCAEF7C3D244134090164A42D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514146, 'LS84', 'NL32-04', NULL, 'FUHRE', 'Fuhre', 'Fuhre', '010100002015550000C51293094E9C2241A430853A4B110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514147, 'PS06', 'NL32-06', NULL, 'FULDERA', 'Fuldera', 'Fuldera', '010100002015550000EA9A5D0B56272941BAB7EE4B01630441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514148, 'MT13', 'NL32-01', NULL, 'FULENBACH', 'Fulenbach', 'Fulenbach', '010100002015550000E6594754DD38234110E61C65BDB40C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514149, 'MT37', 'NL32-02', NULL, 'FULL', 'Full', 'Full', '010100002015550000526D9E61FA0E24417C168BFEA9831041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514150, 'MT06', 'NL32-01', NULL, 'FULLINSDORF', 'Füllinsdorf', 'Fullinsdorf', '010100002015550000546C8FF4CA062341C44EEAA48DDE0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514151, 'LS51', 'NL32-04', NULL, 'FULLY', 'Fully', 'Fully', '010100002015550000EBC8093A07832141EE25992BE7A5FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514160, 'NT30', 'NL32-05', NULL, 'FURKELS', 'Furkels', 'Furkels', '0101000020155500009FE358B19618274167F23E0A671A0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514161, 'NS59', 'NL32-05', NULL, 'FURNA', 'Furna', 'Furna', '010100002015550000EF163101D97C274100B693A299770841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514163, 'NS37', 'NL32-05', NULL, 'FURSTENAUBRUCK', 'Fürstenaubruck', 'Furstenaubruck', '010100002015550000F638AE3FD1002741B0C811B436790541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514164, 'NS17', 'NL32-05', NULL, 'FURTH', 'Furth', 'Furth', '0101000020155500002B86329DE56126419F7BFDA013300541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514165, 'MS74', 'NL32-05', NULL, 'FUSIO', 'Fusio', 'Fusio', '010100002015550000BA5AACD0DA262541C319C60ECB790141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514167, 'MT68', 'NL32-02', NULL, 'GACHLINGEN', 'Gächlingen', 'Gachlingen', '010100002015550000A84BFBEDB7BD24411091F4AA636F1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514168, 'MT86', 'NL32-02', NULL, 'GACHNANG', 'Gachnang', 'Gachnang', '01010000201555000063C63F0ABF8D25413672729F63371041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514169, 'MS57', 'NL32-05', NULL, 'GADMEN', 'Gadmen', 'Gadmen', '010100002015550000F49B1789B46F24416C1CFF6F28820541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514170, 'NS67', 'NL32-05', NULL, 'GADMEN', 'Gadmen', 'Gadmen', '01010000201555000016BA0A16990C284135255D979A0B0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514173, 'NT20', 'NL32-05', NULL, 'GAFARRA', 'Gafarra', 'Gafarra', '010100002015550000EFF7BF315DC92641C9A0CCCA57120941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514174, 'NT60', 'NL32-05', NULL, 'GAFIEN', 'Gafien', 'Gafien', '0101000020155500009E238412FBE8274138390C773FF80841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514175, 'NT34', 'NL32-02', NULL, 'GAIS', 'Gais', 'Gais', '0101000020155500000E56350D58F22641D0C7E7B4AD4A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514178, 'MS11', 'NL32-04', NULL, 'GALGERN', 'Galgern', 'Galgern', '0101000020155500000CDE125EC05B234104EE2F27CE03FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514183, 'LS93', 'NL32-04', NULL, 'GALM', 'Galm', 'Galm', '010100002015550000BE2B841A9CE22241790DD71DAB7C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514185, 'LT50', 'NL32-04', NULL, 'GALMIZ', 'Galmiz', 'Galmiz', '010100002015550000E640705CD6A32141CBE54EB982670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514186, 'LT51', 'NL32-01', NULL, 'GALS', 'Gals', 'Gals', '01010000201555000070E9D411B96821417BE0ADF30B8A0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514187, 'MS03', 'NL32-04', NULL, 'GAMPEL', 'Gampel', 'Gampel', '010100002015550000562B9F2CD500234159E887C9C59EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514188, 'LT50', 'NL32-01', NULL, 'GAMPELEN', 'Gampelen', 'Gampelen', '01010000201555000066DAEEA7A668214190A5CE3825500941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514189, 'NT32', 'NL32-02', NULL, 'GAMS', 'Gams', 'Gams', '0101000020155500008AF3033631EC2641E45C2D69CD060C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514190, 'MS12', 'NL32-04', NULL, 'GAMSEN', 'Gamsen', 'Gamsen', '0101000020155500001CAE0A944E832341508472D15330FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514191, 'NR09', 'NL32-05', NULL, 'GANDRIA', 'Gandria', 'Gandria', '01010000201555000086DD26C7790026416D6C9D71284FF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514193, 'LT83', 'NL32-01', NULL, 'GANSBRUNNEN', 'Gänsbrunnen', 'Gansbrunnen', '010100002015550000E3614A5115602241323991D281780C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514194, 'NT04', 'NL32-02', NULL, 'GANTERSCHWIL', 'Ganterschwil', 'Ganterschwil', '010100002015550000F80F73CCB71926413134C6EA67700E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514208, 'MT45', 'NL32-02', NULL, 'GEBENSTORF', 'Gebenstorf', 'Gebenstorf', '010100002015550000E06BB41498232441AC805C2BC1720F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514209, 'MT42', 'NL32-02', NULL, 'GELFINGEN', 'Gelfingen', 'Gelfingen', '0101000020155500003A5123A31A302441F80A429DE5600B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514212, 'MT15', 'NL32-01', NULL, 'GELTERKINDEN', 'Gelterkinden', 'Gelterkinden', '01010000201555000010D65B1DCF4123411D80CA9BD16B0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514216, 'LS93', 'NL32-04', NULL, 'GEMMIPASS', 'Gemmipass', 'Gemmipass', '010100002015550000CC062FCB76BA22415F1139E308F00041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514218, 'LT95', 'NL32-01', NULL, 'GEMPEN', 'Gempen', 'Gempen', '010100002015550000E9EE736A01CC224139093EFEF3690F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514223, 'MR97', 'NL32-08', NULL, 'GENESTRERIO', 'Genestrerio', 'Genestrerio', '01010000201555000024F0705BBAE4254194022E7C6838F340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514231, 'KS82', 'NL32-04', 1, 'GENEVE', 'Genève', 'Geneve', '01010000201555000097472266ECA01E413C2DB24065A3FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514243, 'KS84', 'NL32-04', NULL, 'GENOLIER', 'Genolier', 'Genolier', '010100002015550000FDEB198A87CF1E412FC2A91AE37A0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514248, 'MS47', 'NL32-05', NULL, 'GENTHALHUTTEN', 'Genthalhütten', 'Genthalhutten', '0101000020155500009795EEDFE547244137DF326A60800541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514250, 'LS79', 'NL32-04', NULL, 'GERETSRIED', 'Geretsried', 'Geretsried', '01010000201555000048C36D98CB1022417AB7752BCE7E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514253, 'LT80', 'NL32-04', NULL, 'GERISTEIN', 'Geristein', 'Geristein', '0101000020155500003E631CD2E17D2241DC8BDAAC21DA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514254, 'LT92', 'NL32-01', NULL, 'GERLAFINGEN', 'Gerlafingen', 'Gerlafingen', '0101000020155500004D6C10C4579B2241F46BEA9037570B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514256, 'MT86', 'NL32-02', NULL, 'GERLIKON', 'Gerlikon', 'Gerlikon', '010100002015550000C860D5A58C972541DB985C75BE371041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514257, 'MT41', 'NL32-02', NULL, 'GERLISWIL', 'Gerliswil', 'Gerliswil', '01010000201555000074D2B34EBD3A2441134D06CECE3F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514258, 'MS80', 'NL32-05', NULL, 'GERRA', 'Gerra', 'Gerra', '01010000201555000096ECC0BD9E7B2541AB75897C3266FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514259, 'MS82', 'NL32-05', NULL, 'GERRA', 'Gerra', 'Gerra', '0101000020155500007F8B62C5AB82254181F18EB2F1D4FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514261, 'MT60', 'NL32-05', NULL, 'GERSAU', 'Gersau', 'Gersau', '010100002015550000D44E90E824DA2441E67B01DE2DEC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514262, 'MS58', 'NL32-05', NULL, 'GERSCHNIALP', 'Gerschnialp', 'Gerschnialp', '0101000020155500009BA5D7339C962441EDA25F4D8DA50641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514264, 'LS88', 'NL32-04', NULL, 'GERZENSEE', 'Gerzensee', 'Gerzensee', '0101000020155500005B8F3BCCE09122414E6A9B161ED10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514265, 'MS44', 'NL32-05', NULL, 'GESCHINEN', 'Geschinen', 'Geschinen', '010100002015550000698AAE093C4A244110534616F11B0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514266, 'MT22', 'NL32-01', NULL, 'GETTNAU', 'Gettnau', 'Gettnau', '010100002015550000A88CBE3979882341B50B3E9C5DE70A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514267, 'MT32', 'NL32-02', NULL, 'GEUENSEE', 'Geuensee', 'Geuensee', '0101000020155500005FEDCC1F03D72341EDEC9F1B5ED10B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514268, 'MS64', 'NL32-05', NULL, 'GHEIBA', 'Gheiba', 'Gheiba', '010100002015550000B28036B1D508254141279F3BFA770141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514270, 'MT93', 'NL32-02', NULL, 'GIBSWIL', 'Gibswil', 'Gibswil', '010100002015550000A69EA6D3C6B82541B1A36BBC18470D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514271, 'MS27', 'NL32-05', NULL, 'GIDISDORF', 'Gidisdorf', 'Gidisdorf', '010100002015550000B5A74744D6B223416E8F72571B070541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514272, 'LS74', 'NL32-04', NULL, 'GIEBEL', 'Giebel', 'Giebel', '0101000020155500004825FEE9504C2241D84BCB190C110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514273, 'MS27', 'NL32-05', NULL, 'GIESSBACH', 'Giessbach', 'Giessbach', '010100002015550000505C3666AAA823416300F7EC9A7A0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514278, 'LS68', 'NL32-04', NULL, 'GIFFERS', 'Giffers', 'Giffers', '0101000020155500008C5B9EC008CB21412021CDA216EA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514280, 'KS94', 'NL32-04', NULL, 'GILLY', 'Gilly', 'Gilly', '0101000020155500003A97E1BA07481F41E7D963AE22B10141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514281, 'KS95', 'NL32-04', NULL, 'GIMEL', 'Gimel', 'Gimel', '010100002015550000C081DE96B6491F4160E6B597B4980241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514282, 'MS15', 'NL32-04', NULL, 'GIMMELWALD', 'Gimmelwald', 'Gimmelwald', '010100002015550000F19E11F0F2592341A72A0FC5A6FB0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514286, 'KS84', 'NL32-04', NULL, 'GINGINS', 'Gingins', 'Gingins', '010100002015550000E45D7DB196BA1E414F9DC707BE070141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514287, 'MS93', 'NL32-05', NULL, 'GIORNICO', 'Giornico', 'Giornico', '0101000020155500009DE08159BEB32541AEEC1FFA9CD50041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514288, 'NS02', 'NL32-05', NULL, 'GIOVA', 'Giova', 'Giova', '010100002015550000AAB549171F422641A67E337F2997FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514289, 'MT26', 'NL32-02', NULL, 'GIPFOBERFRICK', 'Gipf-Oberfrick', 'Gipf-Oberfrick', '010100002015550000EF033427F49923410265EC8DD2E10F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514290, 'MT84', 'NL32-02', NULL, 'GIRENBAD', 'Girenbad', 'Girenbad', '010100002015550000539A12B3219125416C528FA5177E0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514291, 'MT85', 'NL32-02', NULL, 'GIRENBAD', 'Girenbad', 'Girenbad', '01010000201555000025D87A610C8F2541385F8D09474D0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514294, 'MS38', 'NL32-05', NULL, 'GISWIL', 'Giswil', 'Giswil', '0101000020155500009C0AF4CE5C0B244116A040BA57D90641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514295, 'NS01', 'NL32-05', NULL, 'GIUBIASCO', 'Giubiasco', 'Giubiasco', '0101000020155500000A0A094898FD25412E934824E9D4FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514296, 'MS72', 'NL32-05', NULL, 'GIUMAGLIO', 'Giumaglio', 'Giumaglio', '010100002015550000E9B46337EF3C25413AD1FB310DE4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514297, 'KS84', 'NL32-04', NULL, 'GIVRINS', 'Givrins', 'Givrins', '010100002015550000245BA85F12CF1E41087F6501FF400141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514298, 'KS94', 'NL32-04', NULL, 'GLAND', 'Gland', 'Gland', '010100002015550000FBF52922951F1F41808F7D746C780141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514302, 'NS57', 'NL32-05', NULL, 'GLARIS', 'Glaris', 'Glaris', '010100002015550000E4B8CC4978BD2741249A2D0A03C80541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514307, 'NT00', 'NL32-02', 4, 'GLARUS', 'Glarus', 'Glarus', '01010000201555000090F9A01E321626411F73FA00D9AF0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514311, 'MT65', 'NL32-02', NULL, 'GLATTBRUGG', 'Glattbrugg', 'Glattbrugg', '010100002015550000E59932A05EF22441D7365B833CCF0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514313, 'NT15', 'NL32-02', NULL, 'GLATTBURG', 'Glattburg', 'Glattburg', '010100002015550000CC80D5A6BB532641C66BA7292F230F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514314, 'NS25', 'NL32-05', NULL, 'GLATTENBERG', 'Glattenberg', 'Glattenberg', '010100002015550000F08049BDE6D126419A63336A29A50341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514315, 'MT66', 'NL32-02', NULL, 'GLATTFELDEN', 'Glattfelden', 'Glattfelden', '010100002015550000A6C3023BADBF24412D6D646CDA4D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514322, 'MS55', 'NL32-05', NULL, 'GLETSCH', 'Gletsch', 'Gletsch', '01010000201555000014C9E2D78D7124416145787E4F050341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514323, 'LS44', 'NL32-04', NULL, 'GLION', 'Glion', 'Glion', '0101000020155500004053968AFC1F2141A1BF772D612D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514324, 'MS22', 'NL32-04', NULL, 'GLIS', 'Glis', 'Glis', '0101000020155500007B4BF3D4568D2341A3A5E3C5DB30FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514327, 'LT64', 'NL32-01', NULL, 'GLOVELIER', 'Glovelier', 'Glovelier', '0101000020155500006762508897C22141543916E3E39A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514329, 'MS20', 'NL32-05', NULL, 'GMEINALP', 'Gmeinalp', 'Gmeinalp', '0101000020155500003195C527DFD423411F63E812533BFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514330, 'NS01', 'NL32-05', NULL, 'GNOSCA', 'Gnosca', 'Gnosca', '01010000201555000097890D3C7C062641BD18A5839DA5FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514331, 'NT35', 'NL32-02', NULL, 'GOLDACH', 'Goldach', 'Goldach', '010100002015550000FDB7384BEEF926419768364006A70F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514333, 'MT61', 'NL32-02', NULL, 'GOLDAU', 'Goldau', 'Goldau', '01010000201555000075994CBF3AE32441398E545252D40941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514334, 'MT93', 'NL32-02', NULL, 'GOLDINGEN', 'Goldingen', 'Goldingen', '010100002015550000E1248FEAE0D62541EF5A272592D50C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514335, 'MS08', 'NL32-04', NULL, 'GOLDIWIL', 'Goldiwil', 'Goldiwil', '010100002015550000056D26D879EB2241BFD085485DEA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514336, 'MS17', 'NL32-04', NULL, 'GOLDSWIL', 'Goldswil', 'Goldswil', '0101000020155500002F19A92D36592341C8853817BC040541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514337, 'LS06', 'NL32-04', NULL, 'GOLLION', 'Gollion', 'Gollion', '010100002015550000490B26B66D27204149D62A2F73790341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514338, 'NT02', 'NL32-02', NULL, 'GOMMISWALD', 'Gommiswald', 'Gommiswald', '01010000201555000098D1AEE54EF5254188DB202B3B2A0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514340, 'MT12', 'NL32-01', NULL, 'GONDISWIL', 'Gondiswil', 'Gondiswil', '010100002015550000309B53FF334D2341176A534AECE50A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514341, 'MS31', 'NL32-05', NULL, 'GONDO', 'Gondo', 'Gondo', '010100002015550000C2153CD36DF2234171D4AAF35980FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514342, 'NT24', 'NL32-02', NULL, 'GONTEN', 'Gonten', 'Gonten', '0101000020155500006A353B4237AE2641CAFA8FE10AD00D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514343, 'MT33', 'NL32-02', NULL, 'GONTENSCHWIL', 'Gontenschwil', 'Gontenschwil', '0101000020155500007D33D94C3BEA23413651E808A9B90C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514344, 'MS03', 'NL32-04', NULL, 'GOPPENSTEIN', 'Goppenstein', 'Goppenstein', '010100002015550000D04636A9B00A234198E7352D3C7D0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514345, 'MS23', 'NL32-05', NULL, 'GOPPISBERG', 'Goppisberg', 'Goppisberg', '01010000201555000032B015C1EFBE2341A81DE3555EBB0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514347, 'MS81', 'NL32-05', NULL, 'GORDOLA', 'Gordola', 'Gordola', '0101000020155500004027F45FD6A225412CC7AA60F83AFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514348, 'NS01', 'NL32-05', NULL, 'GORDUNO', 'Gorduno', 'Gorduno', '0101000020155500005F2E9FC4C60626418B7A8E92D731FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514349, 'LS29', 'NL32-04', NULL, 'GORGIER', 'Gorgier', 'Gorgier', '010100002015550000383545AE7BBF2041D602D13C69BF0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514354, 'MS66', 'NL32-05', NULL, 'GOSCHENEN', 'Göschenen', 'Goschenen', '0101000020155500002904A232DFFB244161C80BD2E2A10441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514355, 'MS66', 'NL32-05', NULL, 'GOSCHENENALP', 'Göschenenalp', 'Goschenenalp', '010100002015550000BCE2D32C48C024412B6070DCA7640441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514358, 'MT44', 'NL32-02', NULL, 'GOSLIKON', 'Göslikon', 'Goslikon', '01010000201555000072E22089A74B2441EBE8CD37E3520E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514359, 'MT83', 'NL32-02', NULL, 'GOSSAU', 'Gossau', 'Gossau', '0101000020155500007648586350562541B19D443F18400D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514360, 'NT15', 'NL32-02', NULL, 'GOSSAU', 'Gossau', 'Gossau', '010100002015550000E024B39B597B2641DE4D3D84DAEC0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514364, 'LS51', 'NL32-04', NULL, 'GOTTEFREY', 'Gottefrey', 'Gottefrey', '010100002015550000AA20D8C854AB214142A0524C7118FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514368, 'NT17', 'NL32-02', NULL, 'GOTTLIEBEN', 'Gottlieben', 'Gottlieben', '0101000020155500002CED1966E4312641E807A2D794251141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514370, 'LS16', 'NL32-04', NULL, 'GOUMOENSLAVILLE', 'Goumoens-la-Ville', 'Goumoens-la-Ville', '010100002015550000919A612FF259204143A0C413CA5E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514372, 'NT32', 'NL32-02', NULL, 'GRABS', 'Grabs', 'Grabs', '0101000020155500008AF3033631EC2641E45C2D69CD060C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514373, 'MS01', 'NL32-04', NULL, 'GRACHEN', 'Grächen', 'Grachen', '010100002015550000EA712705973D234125E79F318402FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514375, 'MS59', 'NL32-05', NULL, 'GRAFENORT', 'Grafenort', 'Grafenort', '0101000020155500009F5BBEA94978244181BD9A07CB510741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514376, 'LS06', 'NL32-04', NULL, 'GRANCY', 'Grancy', 'Grancy', '01010000201555000065049183AB0920417AF1BBDBCAB40341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514380, 'LS49', 'NL32-04', NULL, 'GRANDCOUR', 'Grandcour', 'Grandcour', '0101000020155500000816D67D9A222141B865DFE686820741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514386, 'LT44', 'NL32-01', NULL, 'GRANDFONTAINE', 'Grandfontaine', 'Grandfontaine', '0101000020155500009A0EAF5A6825214142D519899A4B0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514396, 'LT41', 'NL32-01', NULL, 'GRANDSAVAGNIER', 'Grand-Savagnier', 'Grand-Savagnier', '01010000201555000038A2C0645337214139688E7409C50941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514397, 'LS48', 'NL32-04', NULL, 'GRANDSIVAZ', 'Grandsivaz', 'Grandsivaz', '01010000201555000031CF412BDF3F21414AFD6B4B66260641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514398, 'LS18', 'NL32-04', NULL, 'GRANDSON', 'Grandson', 'Grandson', '010100002015550000155824795E6F2041A6A98D22EBA00641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514399, 'LT83', 'NL32-01', NULL, 'GRANDVAL', 'Grandval', 'Grandval', '0101000020155500000B9CEA45854222417676F89B50EC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514400, 'LS55', 'NL32-04', NULL, 'GRANDVILLARD', 'Grandvillard', 'Grandvillard', '010100002015550000801FDE79988421410C3ECF7267FA0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514403, 'LS38', 'NL32-04', NULL, 'GRANGES', 'Granges', 'Granges', '01010000201555000035B39A9F0E0E214106EAD4A1C3ED0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514405, 'LS82', 'NL32-04', NULL, 'GRANGESPRESSION', 'Granges-près-Sion', 'Granges-pres-Sion', '010100002015550000500DF2D960602241D0904816C140FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514406, 'MT34', 'NL32-02', NULL, 'GRANICHEN', 'Gränichen', 'Granichen', '010100002015550000EC5E842DEAD52341A33E850480DA0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514418, 'LS71', 'NL32-04', NULL, 'GRAVELON', 'Gravelon', 'Gravelon', '01010000201555000051E565B84A4C224131FDFB105AA2FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514419, 'MR99', 'NL32-05', NULL, 'GRAVESANO', 'Gravesano', 'Gravesano', '0101000020155500002FF31CB626C325413A16D0642AA1F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514430, 'MT74', 'NL32-02', NULL, 'GREIFENSEE', 'Greifensee', 'Greifensee', '0101000020155500003EF132D62C242541DF73BB8681240E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514432, 'LT95', 'NL32-01', NULL, 'GRELLINGEN', 'Grellingen', 'Grellingen', '0101000020155500007E071B61CAA42241C0758CEBC7F50E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514433, 'LT72', 'NL32-01', NULL, 'GRENCHEN', 'Grenchen', 'Grenchen', '010100002015550000EB442AA7C12E2241BE9B2EBCEC900B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514434, 'MS23', 'NL32-05', NULL, 'GRENGIOLS', 'Grengiols', 'Grengiols', '0101000020155500005DAD23BE16D323418F7AE5F81C820041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514437, 'MT51', 'NL32-02', NULL, 'GREPPEN', 'Greppen', 'Greppen', '010100002015550000488EE856FA9D2441E61A2DB49AD00941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514439, 'MS71', 'NL32-05', NULL, 'GRESSO', 'Gresso', 'Gresso', '010100002015550000CA5BCF9FAA15254135818B37F50FFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514440, 'MS84', 'NL32-05', NULL, 'GRIBBIO', 'Gribbio', 'Gribbio', '010100002015550000C1B5622A698A25414246B88D2DF40141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514446, 'MS05', 'NL32-04', NULL, 'GRIESALP', 'Griesalp', 'Griesalp', '010100002015550000BFC724450F0A234174E7254C1DFA0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514451, 'LS91', 'NL32-04', NULL, 'GRIMENTZ', 'Grimentz', 'Grimentz', '010100002015550000EC9C70F8C7A62241870B055961FEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514452, 'LS72', 'NL32-04', NULL, 'GRIMISUAT', 'Grimisuat', 'Grimisuat', '0101000020155500004C6B64C72C2E22410F97E60B08CDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514453, 'LS85', 'NL32-04', NULL, 'GRIMMIALP', 'Grimmialp', 'Grimmialp', '010100002015550000B6166C7E456A2241AAA7D4D991320341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514457, 'MS37', 'NL32-05', NULL, 'GRINDELFELD', 'Grindelfeld', 'Grindelfeld', '010100002015550000998C252596EE23418C3BB0B811090541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514458, 'MS26', 'NL32-05', NULL, 'GRINDELWALD', 'Grindelwald', 'Grindelwald', '010100002015550000EDB4B8D85BBD234124F850F0ECE50341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514459, 'PS09', 'NL32-06', NULL, 'GRIOSCH', 'Griosch', 'Griosch', '0101000020155500003A01AD85DB0A294196B0DED3CEFD0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514463, 'LS75', 'NL32-04', NULL, 'GRODOEY', 'Grodoey', 'Grodoey', '010100002015550000C768476155382241EF62963FDE840241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514464, 'LS58', 'NL32-04', NULL, 'GROLLEY', 'Grolley', 'Grolley', '010100002015550000F52E173EBA7B21412656F49EDCD20641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514466, 'LS82', 'NL32-04', NULL, 'GRONE', 'Grône', 'Grone', '01010000201555000058A14C755756224119E2F302F0CCFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514467, 'NS12', 'NL32-05', NULL, 'GRONO', 'Grono', 'Grono', '010100002015550000C38B607782562641D8B6E1B2DC26FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514468, 'LT71', 'NL32-01', NULL, 'GROSSAFFOLTERN', 'Grossaffoltern', 'Grossaffoltern', '0101000020155500009D99BFE8E61A2241603105A3ACFB0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514469, 'NS67', 'NL32-05', NULL, 'GROSSALPEN', 'Grossalpen', 'Grossalpen', '01010000201555000030E84B75A7EF274109122DEE26940541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514470, 'MT77', 'NL32-02', NULL, 'GROSSANDELFINGEN', 'Grossandelfingen', 'Grossandelfingen', '01010000201555000005ED1554CB2A2541D428E2B2E0A71041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514480, 'NS98', 'NL32-06', NULL, 'GROSSFETAN', 'Gross-Fetan', 'Gross-Fetan', '010100002015550000861CE91BEDD128410C913AA0DAD30641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514481, 'LS69', 'NL32-04', NULL, 'GROSSGURMELS', 'Gross Gurmels', 'Gross Gurmels', '0101000020155500007EB03D568CAD2141A8D925EAC37F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514482, 'LS99', 'NL32-04', NULL, 'GROSSHOCHSTETTEN', 'Gross Höchstetten', 'Gross Hochstetten', '01010000201555000072D6A8A067C3224116E138DB1AB90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514491, 'MT22', 'NL32-02', NULL, 'GROSSWANGEN', 'Grosswangen', 'Grosswangen', '0101000020155500004EB9A77ADDB9234141837582CCE80A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514495, 'LS91', 'NL32-04', NULL, 'GRUBEN', 'Gruben', 'Gruben', '010100002015550000CC148D571CED22411EAF8AFCA073FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514497, 'LS64', 'NL32-04', NULL, 'GRUND', 'Grund', 'Grund', '010100002015550000CB8AD03244E82141F0857B1BB59D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514498, 'MS47', 'NL32-05', NULL, 'GRUND', 'Grund', 'Grund', '010100002015550000BA867FD12434244102B624F6A3450541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514499, 'LS88', 'NL32-04', NULL, 'GRUNDBACH', 'Grundbach', 'Grundbach', '01010000201555000003EC8CAD2C6A22418E0350715CE90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514500, 'MT83', 'NL32-02', NULL, 'GRUNINGEN', 'Grüningen', 'Gruningen', '010100002015550000CE7A30538E56254175E30F5E32060D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514501, 'NT40', 'NL32-05', NULL, 'GRUSCH', 'Grüsch', 'Grusch', '0101000020155500007A5B68F23668274138BB283D1FE90841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514504, 'LS56', 'NL32-04', NULL, 'GRUYERES', 'Gruyères', 'Gruyeres', '0101000020155500008B7C73AEBD7A2141BE88CDB1606E0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514505, 'LS52', 'NL32-04', NULL, 'GRYON', 'Gryon', 'Gryon', '0101000020155500004C572CA187832141348F257B4644FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514506, 'LS64', 'NL32-04', NULL, 'GSTAAD', 'Gstaad', 'Gstaad', '010100002015550000A8CC72C84CF2214162CDDDA285D70141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514508, 'LS63', 'NL32-04', NULL, 'GSTEIG', 'Gsteig', 'Gsteig', '0101000020155500000F5C428223E8214174AC0C211DB60041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514509, 'MS16', 'NL32-04', NULL, 'GSTEIG', 'Gsteig', 'Gsteig', '010100002015550000DA3AEE1F60592341523FBD21F0900441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514510, 'NS88', 'NL32-06', NULL, 'GUARDA', 'Guarda', 'Guarda', '010100002015550000944F93A9C1A02841F265964C03930641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514511, 'MT62', 'NL32-02', NULL, 'GUBEL', 'Gubel', 'Gubel', '010100002015550000D446CF76AAEB2441E33E60D52A6A0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514513, 'LS59', 'NL32-04', NULL, 'GUEVAUX', 'Guévaux', 'Guevaux', '01010000201555000040BA9B964A6821419C6D20EAA32E0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514515, 'LS78', 'NL32-04', NULL, 'GUGGISBERG', 'Guggisberg', 'Guggisberg', '010100002015550000F5F98A71A81022414240BEF980E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514520, 'NS13', 'NL32-05', NULL, 'GUMEGNA', 'Gumegna', 'Gumegna', '0101000020155500000CE24BA6679026411492ACCA05AE0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514521, 'LT80', 'NL32-04', NULL, 'GUMLIGEN', 'Gümligen', 'Gumligen', '01010000201555000009A1FAA9FC7322411615700332A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514522, 'LS74', 'NL32-04', NULL, 'GUMMELI', 'Gummeli', 'Gummeli', '01010000201555000020DA29284A3822415015CF057A290141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514523, 'LS69', 'NL32-04', NULL, 'GUMMENEN', 'Gümmenen', 'Gummenen', '0101000020155500005977D5D446DF2141D5F4F9E3E12C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514527, 'MS07', 'NL32-04', NULL, 'GUNTEN', 'Gunten', 'Gunten', '01010000201555000002B6F8C49EEB22412EB41790AA3C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514529, 'MT14', 'NL32-01', NULL, 'GUNZGEN', 'Gunzgen', 'Gunzgen', '010100002015550000E0EE1548CD2E2341576DDC0343620D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514530, 'MT32', 'NL32-02', NULL, 'GUNZWIL', 'Gunzwil', 'Gunzwil', '0101000020155500006C6A7E4B34082441EA35AF66090D0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514531, 'NS15', 'NL32-05', NULL, 'GURALETSCH', 'Guraletsch', 'Guraletsch', '010100002015550000E5A9B18C3746264120CA581E42980341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514534, 'LS88', 'NL32-04', NULL, 'GURNIGELBAD', 'Gurnigelbad', 'Gurnigelbad', '0101000020155500008246892F485622414BC5C06755E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514537, 'MS77', 'NL32-05', NULL, 'GURTNELLEN', 'Gurtnellen', 'Gurtnellen', '010100002015550000DEC0D72EA9182541E813EACF21C50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514539, 'LS84', 'NL32-04', NULL, 'GUTSCH', 'Gütsch', 'Gutsch', '010100002015550000C05D540D515622418AE8576426D70141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514540, 'MS46', 'NL32-05', NULL, 'GUTTANNEN', 'Guttannen', 'Guttannen', '010100002015550000093E576285482441FB8371E5CA980441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514541, 'NT27', 'NL32-02', NULL, 'GUTTINGEN', 'Güttingen', 'Guttingen', '0101000020155500000D6306B1408B2641476EDF61C2B51041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514542, 'LS97', 'NL32-04', NULL, 'GWATT', 'Gwatt', 'Gwatt', '0101000020155500001BADDFC3D7B922417399D9571C3C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514546, 'MS17', 'NL32-04', NULL, 'HABKERN', 'Habkern', 'Habkern', '010100002015550000727FFA0F3845234111D4EF15333E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514547, 'MT35', 'NL32-02', NULL, 'HABSBURG', 'Habsburg', 'Habsburg', '010100002015550000DB61A0F424062441A9E0957799710F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514549, 'MT96', 'NL32-02', NULL, 'HAGENBUCH', 'Hagenbuch', 'Hagenbuch', '010100002015550000BD03EBD96CAB25416D06E722841B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514550, 'MT14', 'NL32-01', NULL, 'HAGENDORF', 'Hägendorf', 'Hagendorf', '010100002015550000B28BB4E1923823419F679E605C9C0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514551, 'NT25', 'NL32-02', NULL, 'HAGGENSCHWIL', 'Häggenschwil', 'Haggenschwil', '0101000020155500001A4BFA5DE1B42641BC75E7D703DA0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514552, 'MT44', 'NL32-02', NULL, 'HAGGLINGEN', 'Hägglingen', 'Hagglingen', '010100002015550000720FA2A8282E2441625C8D5FA1510E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514553, 'LT61', 'NL32-01', NULL, 'HAGNECK', 'Hagneck', 'Hagneck', '010100002015550000C3FF6A46FEB721411F6F6B048CFC0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514556, 'NS39', 'NL32-05', NULL, 'HALDENSTEIN', 'Haldenstein', 'Haldenstein', '010100002015550000D2A3AFBACA2427412F97A68929C00741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514557, 'LS89', 'NL32-04', NULL, 'HALEN', 'Halen', 'Halen', '010100002015550000043A0EEB2E602241F749317672F20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514558, 'MT58', 'NL32-02', NULL, 'HALLAU', 'Hallau', 'Hallau', '0101000020155500003681803E5EAA2441BD661D12EA511141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514564, 'MS39', 'NL32-05', NULL, 'HALTEN', 'Halten', 'Halten', '01010000201555000004705E60E400244146A3230B90C00741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514565, 'MT43', 'NL32-02', NULL, 'HAMIKON', 'Hämikon', 'Hamikon', '010100002015550000904DE08339432441405CE69F55490C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514567, 'MS46', 'NL32-05', NULL, 'HANDEGG', 'Handegg', 'Handegg', '01010000201555000018E83D35F65224416BB998F289EB0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514568, 'MS11', 'NL32-04', NULL, 'HANNIGALP', 'Hannigalp', 'Hannigalp', '010100002015550000EC1A39699E5123419EEF7A962777FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514572, 'MT20', 'NL32-05', NULL, 'HASLE', 'Hasle', 'Hasle', '0101000020155500007A3AA2FDFDBA23410916848ECAA50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514573, 'LT90', 'NL32-01', NULL, 'HASLE', 'Hasle', 'Hasle', '01010000201555000025E2588627C32241D9982F166A4E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514574, 'NT24', 'NL32-02', NULL, 'HASLEN', 'Haslen', 'Haslen', '010100002015550000485E938E2EC12641655DB267BD450E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514578, 'LS96', 'NL32-04', NULL, 'HASLI', 'Hasli', 'Hasli', '0101000020155500009D3DD0CDDECD22417E79A0279C8E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514580, 'NS09', 'NL32-05', NULL, 'HATZINGEN', 'Hätzingen', 'Hatzingen', '010100002015550000CAF8A67BE0032641BBDFC6AEC58C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514581, 'LS80', 'NL32-04', NULL, 'HAUDERES', 'Haudères', 'Hauderes', '0101000020155500004597C193A67E22416B31169E2347F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514582, 'MT14', 'NL32-01', NULL, 'HAUENSTEIN', 'Hauenstein', 'Hauenstein', '0101000020155500003FD55D60194C234196D6FBD395100E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514583, 'NT25', 'NL32-02', NULL, 'HAUPTWIL', 'Hauptwil', 'Hauptwil', '010100002015550000510438DEF98D2641E45817F55C9C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514584, 'MS37', 'NL32-05', NULL, 'HAUSEN', 'Hausen', 'Hausen', '010100002015550000BDD738043C022441457D92C6957D0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514585, 'MT63', 'NL32-02', NULL, 'HAUSEN', 'Hausen', 'Hausen', '0101000020155500000E938CCBE9D62441420A8D318B8A0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514587, 'LS57', 'NL32-04', NULL, 'HAUTERIVE', 'Hauterive', 'Hauterive', '010100002015550000630E5612598521418C600D2530B10541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514589, 'LS56', 'NL32-04', NULL, 'HAUTEVILLE', 'Hauteville', 'Hauteville', '01010000201555000005BBE6C7FF8E2141AA7B3967868F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514591, 'NT44', 'NL32-02', NULL, 'HEERBRUGG', 'Heerbrugg', 'Heerbrugg', '0101000020155500006E266593AF5D27414E68C4850CCA0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514593, 'MT86', 'NL32-02', NULL, 'HEGI', 'Hegi', 'Hegi', '01010000201555000037B01E5A385D25410DF2D93B8DF70F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514594, 'MS09', 'NL32-04', NULL, 'HEIDBUHL', 'Heidbühl', 'Heidbuhl', '0101000020155500002D17E901C12623410FFCCD0DB5460741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514595, 'NT45', 'NL32-02', NULL, 'HEIDEN', 'Heiden', 'Heiden', '0101000020155500005A487365F5212741453FE7FB5F370F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514596, 'LS97', 'NL32-04', NULL, 'HEILIGENSCHWENDI', 'Heiligenschwendi', 'Heiligenschwendi', '0101000020155500007459D51F93E1224110C7563A56B00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514597, 'LS98', 'NL32-04', NULL, 'HEIMBERG', 'Heimberg', 'Heimberg', '010100002015550000C63B703EBDAF22414061E9F8855D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514598, 'MS08', 'NL32-04', NULL, 'HEIMENSCHWAND', 'Heimenschwand', 'Heimenschwand', '010100002015550000E2FC53EB54EB2241E7EFD04410980641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514599, 'LT91', 'NL32-01', NULL, 'HEIMISWIL', 'Heimiswil', 'Heimiswil', '010100002015550000D71E3B10FACC22414E57461252C20941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514601, 'LS78', 'NL32-04', NULL, 'HEITENRIED', 'Heitenried', 'Heitenried', '01010000201555000047FA7B58DEFC2141B67170773AD10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514602, 'MS89', 'NL32-05', NULL, 'HEITMANNSEGG', 'Heitmannsegg', 'Heitmannsegg', '0101000020155500000AD8391B627A2541A7E58BADDA600741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514603, 'MT31', 'NL32-02', NULL, 'HELLBUHL', 'Hellbühl', 'Hellbuhl', '0101000020155500004823A3A25413244102029F6C4E040A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514607, 'NT13', 'NL32-02', NULL, 'HEMBERG', 'Hemberg', 'Hemberg', '010100002015550000F29580F94E5626414F3D1D740A540D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514608, 'MT88', 'NL32-02', NULL, 'HEMISHOFEN', 'Hemishofen', 'Hemishofen', '0101000020155500002F931376A0812541000098ED993B1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514610, 'MT68', 'NL32-02', NULL, 'HEMMENTHAL', 'Hemmenthal', 'Hemmenthal', '01010000201555000022EE23C0D2DA2441BAEA97BD278D1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514611, 'MT15', 'NL32-01', NULL, 'HEMMIKEN', 'Hemmiken', 'Hemmiken', '010100002015550000BD32F33EA04B2341401AEE4C076C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514612, 'NT05', 'NL32-02', NULL, 'HENAU', 'Henau', 'Henau', '010100002015550000F6D908D2232C2641CAF300BCA6590F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514613, 'MT44', 'NL32-02', NULL, 'HENDSCHIKEN', 'Hendschiken', 'Hendschiken', '010100002015550000C4C9D6B77E1A2441D2D5D682D5500E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514615, 'MT76', 'NL32-02', NULL, 'HENGGART', 'Henggart', 'Henggart', '01010000201555000079BBC7B57B2B2541FD996E9405511041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514616, 'LT93', 'NL32-01', NULL, 'HERBETSWIL', 'Herbetswil', 'Herbetswil', '01010000201555000003CFF0BC00A52241146B954086260D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514617, 'MT78', 'NL32-02', NULL, 'HERBLINGEN', 'Herblingen', 'Herblingen', '01010000201555000039AED4B96A1F254157D07C793D721141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514619, 'MS01', 'NL32-04', NULL, 'HERBRIGGEN', 'Herbriggen', 'Herbriggen', '010100002015550000B8D2D5849D2923413C964A58261AFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514621, 'MT97', 'NL32-02', NULL, 'HERDERN', 'Herdern', 'Herdern', '010100002015550000867814AF13AA254155323CAE44AC1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514622, 'LS71', 'NL32-04', NULL, 'HEREMENCE', 'Hérémence', 'Heremence', '01010000201555000097A376F82F382241C55062D6CAFDFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514626, 'MS99', 'NL32-05', NULL, 'HERGERSBODEN', 'Hergersboden', 'Hergersboden', '010100002015550000074CADBFABB525412F4082CD079F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514627, 'MT40', 'NL32-05', NULL, 'HERGISWIL', 'Hergiswil', 'Hergiswil', '0101000020155500003C5CC76D5F592441DE43CD7EB4E50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514628, 'MT21', 'NL32-01', NULL, 'HERGISWIL', 'Hergiswil', 'Hergiswil', '010100002015550000804F9DBBE07E234141CB32EE65390A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514630, 'NT24', 'NL32-02', 3, 'HERISAU', 'Herisau', 'Herisau', '010100002015550000379426D282852641CE4C2772DFB30E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514631, 'KS83', 'NL32-04', NULL, 'HERMANCE', 'Hermance', 'Hermance', '01010000201555000015DFA326FEF31E416BF186DC0255FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514633, 'MT44', 'NL32-02', NULL, 'HERMETSCHWIL', 'Hermetschwil', 'Hermetschwil', '010100002015550000E0A11E67FA5F2441A8617FBB276C0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514634, 'LS88', 'NL32-04', NULL, 'HERMISWIL', 'Hermiswil', 'Hermiswil', '0101000020155500002AEB9F5135602241B4F6B47CF1D00641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514635, 'NT17', 'NL32-02', NULL, 'HERRENHOF', 'Herrenhof', 'Herrenhof', '0101000020155500003A6238E8366E2641C6B6A8BB72971041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514636, 'MT73', 'NL32-02', NULL, 'HERRLIBERG', 'Herrliberg', 'Herrliberg', '010100002015550000AE7D263CC20725415A9BF44832010D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514637, 'MT50', 'NL32-02', NULL, 'HERTENSTEIN', 'Hertenstein', 'Hertenstein', '010100002015550000C798876A5E8A244128BD7E41B8950941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514638, 'MT46', 'NL32-02', NULL, 'HERTENSTEIN', 'Hertenstein', 'Hertenstein', '0101000020155500001FE4F6D48A4A2441E0C9671F39E80F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514639, 'MT25', 'NL32-02', NULL, 'HERZBERG', 'Herzberg', 'Herzberg', '010100002015550000CDD3577403AE23411EBDA04BC5FA0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514640, 'MT02', 'NL32-01', NULL, 'HERZOGENBUCHSEE', 'Herzogenbuchsee', 'Herzogenbuchsee', '0101000020155500005F8C432146EA224144EC05BEE6910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514641, 'LT82', 'NL32-01', NULL, 'HESSIGKOFEN', 'Hessigkofen', 'Hessigkofen', '010100002015550000399B59FF1C602241D6D5AA80141D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514642, 'MT76', 'NL32-02', NULL, 'HETTLINGEN', 'Hettlingen', 'Hettlingen', '0101000020155500007BCCC39E483525416776A8B855511041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514643, 'MT42', 'NL32-02', NULL, 'HILDISRIEDEN', 'Hildisrieden', 'Hildisrieden', '010100002015550000CE923CF0602624411243E48597260B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514644, 'LS97', 'NL32-04', NULL, 'HILTERFINGEN', 'Hilterfingen', 'Hilterfingen', '010100002015550000B664EC05B7CD224171C768E934760541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514645, 'LT95', 'NL32-01', NULL, 'HIMMELRIED', 'Himmelried', 'Himmelried', '01010000201555000095949C2CD1A4224144F49F80DFBB0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514646, 'LT80', 'NL32-01', NULL, 'HINDELBANK', 'Hindelbank', 'Hindelbank', '01010000201555000042412B86BC872241A6DE0077E1870941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514647, 'NT10', 'NL32-05', NULL, 'HINTERDORF', 'Hinterdorf', 'Hinterdorf', '010100002015550000263976FCD65226413410B25E60CD0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514648, 'LS63', 'NL32-04', NULL, 'HINTEREWINDSPILLEN', 'Hintere-Windspillen', 'Hintere-Windspillen', '010100002015550000728AE4D232FC2141D54E2B45DAEF0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514650, 'MS58', 'NL32-05', NULL, 'HINTERHORBIS', 'Hinter Horbis', 'Hinter Horbis', '010100002015550000572C02E95CA02441E7FBF168F2DF0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514651, 'LT70', 'NL32-04', NULL, 'HINTERKAPPELEN', 'Hinterkappelen', 'Hinterkappelen', '010100002015550000D24FA9169F2E22419CEA502030A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514652, 'NT45', 'NL32-02', NULL, 'HINTERLOCHEN', 'Hinterlochen', 'Hinterlochen', '010100002015550000FEE9F17F632B27413B8D3EE850720F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514653, 'MS09', 'NL32-04', NULL, 'HINTERNETSCHBUHL', 'Hinter Netschbühl', 'Hinter Netschbuhl', '0101000020155500000D2CBE8ED612234164809D4D42800741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514654, 'NS15', 'NL32-05', NULL, 'HINTERRHEIN', 'Hinterrhein', 'Hinterrhein', '010100002015550000F2381C491A6F26415981947E1FEE0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514656, 'LS63', 'NL32-04', NULL, 'HINTERWALLEGG', 'Hinter Wallegg', 'Hinter Wallegg', '010100002015550000E7EDA31A28DE2141027CF0D81AF00041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514658, 'MT83', 'NL32-02', NULL, 'HINWIL', 'Hinwil', 'Hinwil', '010100002015550000782EE3B78B8725419C0CDCB37D430D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514659, 'LS78', 'NL32-04', NULL, 'HIRSCHHORN', 'Hirschhorn', 'Hirschhorn', '0101000020155500005E00982F7F2E22416F37DA4F61E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514660, 'MT62', 'NL32-02', NULL, 'HIRZEL', 'Hirzel', 'Hirzel', '0101000020155500004DEFC411C4FE244148B4B77903190C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514661, 'MT84', 'NL32-02', NULL, 'HITTNAU', 'Hittnau', 'Hittnau', '0101000020155500002438FB3684862541DC1784C3142B0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514662, 'MT43', 'NL32-02', NULL, 'HITZKIRCH', 'Hitzkirch', 'Hitzkirch', '010100002015550000C63BFE795D392441C72EEE0AEA480C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514665, 'MT42', 'NL32-02', NULL, 'HOCHDORF', 'Hochdorf', 'Hochdorf', '01010000201555000003637509D9432441515DD2E5BA610B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514667, 'PS19', 'NL32-06', NULL, 'HOCHFINSTERMUNZ', 'Hochfinstermünz', 'Hochfinstermunz', '010100002015550000684CD7CB566C29417C86E43472BA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514668, 'LT95', 'NL32-01', NULL, 'HOCHWALD', 'Hochwald', 'Hochwald', '010100002015550000B47B7C6A39C222413A48A26FF12F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514670, 'NT35', 'NL32-02', NULL, 'HOF', 'Hof', 'Hof', '0101000020155500004DFF02EB8E0D27417827334012A90F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514671, 'MT79', 'NL32-02', NULL, 'HOFEN', 'Hofen', 'Hofen', '010100002015550000AFCA6AAD821E2541501A2C680EE61141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514672, 'LT85', 'NL32-01', NULL, 'HOFSTETTEN', 'Hofstetten', 'Hofstetten', '0101000020155500009CCC7C29787D22411C5A938B60690F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514673, 'MT85', 'NL32-02', NULL, 'HOFSTETTEN', 'Hofstetten', 'Hofstetten', '01010000201555000070E3ABB6C98E25416E2CD8582D870F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514675, 'NS34', 'NL32-05', NULL, 'HOHENHAUS', 'Hohenhaus', 'Hohenhaus', '010100002015550000AC22E89DC1102741608E82D22ADC0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514676, 'MT42', 'NL32-02', NULL, 'HOHENRAIN', 'Hohenrain', 'Hohenrain', '01010000201555000070872AF96D5724419BBBB5407F9C0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514684, 'MS37', 'NL32-05', NULL, 'HOHFLUH', 'Hohfluh', 'Hohfluh', '0101000020155500004886F7900C0C2441CB998F0CDBB70541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514687, 'MT04', 'NL32-01', NULL, 'HOLDERBANK', 'Holderbank', 'Holderbank', '01010000201555000050F5C1B05D072341FD9A50187A9B0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514688, 'MS11', 'NL32-04', NULL, 'HOLLERBIEL', 'Hollerbiel', 'Hollerbiel', '010100002015550000EE19065D187A23418D22884DA81DFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514690, 'MT05', 'NL32-01', NULL, 'HOLSTEIN', 'Hölstein', 'Holstein', '010100002015550000271E78D5E7102341F7C852D82BBD0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514691, 'MS58', 'NL32-05', NULL, 'HOLZHOSTATT', 'Holzhostatt', 'Holzhostatt', '010100002015550000C659B2D7BAA02441B1AB76E9276C0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514692, 'MT83', 'NL32-02', NULL, 'HOMBRECHTIKON', 'Hombrechtikon', 'Hombrechtikon', '010100002015550000FE961D40E56025411A844FAA10930C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514693, 'NT07', 'NL32-02', NULL, 'HOMBURG', 'Homburg', 'Homburg', '010100002015550000DD77D68B3EE425418651DCBE6EE81041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514694, 'LS96', 'NL32-04', NULL, 'HONDRICH', 'Hondrich', 'Hondrich', '010100002015550000210833C6D5D722413DCB19A0B88E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514695, 'MT64', 'NL32-02', NULL, 'HONGG', 'Höngg', 'Hongg', '01010000201555000075C60F5D70C12441A761103C92920E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514696, 'MT63', 'NL32-02', NULL, 'HORGEN', 'Horgen', 'Horgen', '0101000020155500000715B62D45F4244109435C7D21C60C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514697, 'MT97', 'NL32-02', NULL, 'HORHAUSEN', 'Hörhausen', 'Horhausen', '01010000201555000056D98CF2ACD025414CFBD970A9E71041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514698, 'NT35', 'NL32-02', NULL, 'HORN', 'Horn', 'Horn', '01010000201555000060BCE47C8EF92641547EF204EAE00F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514699, 'LS74', 'NL32-04', NULL, 'HORNKESSEL', 'Hornkessel', 'Hornkessel', '010100002015550000317E4273530622417A591E2247110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514702, 'MT36', 'NL32-02', NULL, 'HORNUSSEN', 'Hornussen', 'Hornussen', '010100002015550000B928C5B501CB234117775E4E54E30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514703, 'MT40', 'NL32-02', NULL, 'HORW', 'Horw', 'Horw', '0101000020155500009646263D264F2441D239392B10590941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514705, 'MS66', 'NL32-05', NULL, 'HOSPENTHAL', 'Hospenthal', 'Hospenthal', '010100002015550000020D5B4D88F22441C87E8B24A1F30341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514706, 'LS42', 'NL32-04', NULL, 'HUEMOZ', 'Huémoz', 'Huemoz', '01010000201555000077E04C5F6A512141E574DAE305BAFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514707, 'MT94', 'NL32-02', NULL, 'HULFTEGG', 'Hulftegg', 'Hulftegg', '0101000020155500008F1A2ADC2FD52541BF362F77F1300E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514708, 'MS69', 'NL32-05', NULL, 'HUNDWALD', 'Hundwald', 'Hundwald', '01010000201555000010754E105BDB24417E4E0032CE900741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514709, 'NT24', 'NL32-02', NULL, 'HUNDWIL', 'Hundwil', 'Hundwil', '01010000201555000048CA7319AFA3264144257880E0420E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514710, 'MT52', 'NL32-02', NULL, 'HUNENBERG', 'Hünenberg', 'Hunenberg', '010100002015550000FD1A1E6DD2922441B7BFFDFB65650B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514711, 'LS97', 'NL32-04', NULL, 'HUNIBACH', 'Hünibach', 'Hunibach', '010100002015550000F2A6F213ADCD2241BBB0AF351BB00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514713, 'MT67', 'NL32-02', NULL, 'HUNTWANGEN', 'Hüntwangen', 'Huntwangen', '010100002015550000C2FD90344CB52441CC7C410573A41041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514714, 'LS89', 'NL32-04', NULL, 'HUNZIGENBRUGG', 'Hunzigenbrügg', 'Hunzigenbrugg', '0101000020155500009F5E5B67E4872241E63F1273C47E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514716, 'MT82', 'NL32-02', NULL, 'HURDEN', 'Hurden', 'Hurden', '010100002015550000065130E91B752541A9EE18BF9F200C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514719, 'MS67', 'NL32-05', NULL, 'HUSEN', 'Husen', 'Husen', '0101000020155500004114F1083DFB24412FF07ACC904F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514722, 'LT10', 'NL32-04', NULL, 'HUTTENBERG', 'Hüttenberg', 'Huttenberg', '01010000201555000076B6E7E3EB342041B00E10FECC380841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514723, 'MT96', 'NL32-02', NULL, 'HUTTLINGEN', 'Hüttlingen', 'Huttlingen', '01010000201555000074A350A399DB254145DD917C3E741041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514724, 'MT11', 'NL32-01', NULL, 'HUTTWIL', 'Huttwil', 'Huttwil', '010100002015550000A58F388266432341DDC9363DCFAB0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514725, 'MT87', 'NL32-02', NULL, 'HUTTWILEN', 'Hüttwilen', 'Huttwilen', '010100002015550000D35559D07E962541E6ED0C0A8CAB1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514726, 'MT70', 'NL32-02', NULL, 'IBACH', 'Ibach', 'Ibach', '010100002015550000B4097BA3081F2541CC4D348B0B640941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514727, 'LS73', 'NL32-04', NULL, 'IFFIGEN', 'Iffigen', 'Iffigen', '0101000020155500005AF55A704F4C22416C9C38FB8DEF0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514729, 'NS49', 'NL32-05', NULL, 'IGIS', 'Igis', 'Igis', '01010000201555000001BB88C5E44A27411BECE31AF4AB0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514732, 'NS17', 'NL32-05', NULL, 'ILANZ', 'Ilanz', 'Ilanz', '0101000020155500008393D69D8D6A2641B5DC88BD81180641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514734, 'NS96', 'NL32-06', NULL, 'ILFUORN', 'Il Fuorn', 'Il Fuorn', '0101000020155500002C1E6FAE17CC28414870135689030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514735, 'MT70', 'NL32-05', NULL, 'ILLGAU', 'Illgau', 'Illgau', '010100002015550000005A037801512541547834266BF30841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514737, 'LT70', 'NL32-04', NULL, 'ILLISWIL', 'Illiswil', 'Illiswil', '0101000020155500005A1E63B4E4102241B17B60AC4FA00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514738, 'MT74', 'NL32-02', NULL, 'ILLNAU', 'Illnau', 'Illnau', '010100002015550000C6C67FD134412541E45F41B3309A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514741, 'LS66', 'NL32-04', NULL, 'IMFANG', 'Im Fang', 'Im Fang', '010100002015550000BCB926A093DE2141A43ACB10E3A60341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514743, 'LS77', 'NL32-04', NULL, 'IMKLOSTER', 'Im Kloster', 'Im Kloster', '01010000201555000029F47C2AB0FC214155960803EE3B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514745, 'MT51', 'NL32-02', NULL, 'IMMENSEE', 'Immensee', 'Immensee', '0101000020155500005529580332B1244164CB8E62517F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514746, 'MS80', 'NL32-05', NULL, 'INDEMINI', 'Indemini', 'Indemini', '010100002015550000FE39F5FD009025416B01462A36F5F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514747, 'LS93', 'NL32-04', NULL, 'INDEN', 'Inden', 'Inden', '01010000201555000075D483E78FBA2241D7F873F256420041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514749, 'MS65', 'NL32-05', NULL, 'INDERSCHWEIG', 'In der Schweig', 'In der Schweig', '01010000201555000022B9882D08CB2441EED256A69D7D0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514750, 'MT70', 'NL32-02', NULL, 'INGENBOHL', 'Ingenbohl', 'Ingenbohl', '010100002015550000A4EA4BFF730B25410E7CF292F1280941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514752, 'NS26', 'NL32-05', NULL, 'INNERCAMANA', 'Innercamana', 'Innercamana', '0101000020155500008E7D2B3E509E2641EE4DB40EC7C10441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514753, 'NS35', 'NL32-05', NULL, 'INNERFERRERA', 'Innerferrera', 'Innerferrera', '0101000020155500001C40110548FB26419CBF9464A2C10241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514755, 'NS27', 'NL32-05', NULL, 'INNERHOF', 'Inner Hof', 'Inner Hof', '010100002015550000865DD409FDCD2641C0409A7ADC210641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514756, 'NS48', 'NL32-05', NULL, 'INNERPRADEN', 'Inner Praden', 'Inner Praden', '0101000020155500005370B8DDA94D2741AEB6B48DCC160741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514759, 'MT91', 'NL32-02', NULL, 'INNERTHAL', 'Innerthal', 'Innerthal', '0101000020155500001E89928D0CBC25417824E07D5D900A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514760, 'MS47', 'NL32-05', NULL, 'INNERTKIRCHEN', 'Innertkirchen', 'Innertkirchen', '0101000020155500003B3CCF9660202441A00459FBEF0A0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514762, 'LT50', 'NL32-01', NULL, 'INS', 'Ins', 'Ins', '010100002015550000A28652DF59862141C1E410CC974F0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514764, 'MS17', 'NL32-04', NULL, 'INTERLAKEN', 'Interlaken', 'Interlaken', '010100002015550000D6C2AADB5E4523413A5EC7EB66CA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514765, 'MS71', 'NL32-05', NULL, 'INTRAGNA', 'Intragna', 'Intragna', '01010000201555000030D1A1FA98482541A2B87BB9DBBAFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514767, 'MS77', 'NL32-05', NULL, 'INTSCHI', 'Intschi', 'Intschi', '010100002015550000BFF701AA542C25411E6125ED40000641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514768, 'MT41', 'NL32-02', NULL, 'INWIL', 'Inwil', 'Inwil', '010100002015550000ED9E4554F5612441553D32CB57B50A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514769, 'MS92', 'NL32-05', NULL, 'IRAGNA', 'Iragna', 'Iragna', '01010000201555000037B6438BF2E62541741017E9B7E3FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514771, 'MT84', 'NL32-02', NULL, 'IRGENHAUSEN', 'Irgenhausen', 'Irgenhausen', '010100002015550000362CD636D97225416E4620FEB2290E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514773, 'MS17', 'NL32-04', NULL, 'ISELTWALD', 'Iseltwald', 'Iseltwald', '0101000020155500004F3089970B81234161AF924DB4050541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514774, 'MS16', 'NL32-04', NULL, 'ISENFLUH', 'Isenfluh', 'Isenfluh', '0101000020155500008D8E600B9F5923419C04954F3EE30341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514776, 'MS69', 'NL32-05', NULL, 'ISENTHAL', 'Isenthal', 'Isenthal', '010100002015550000E16E8397DEE42441DE38856727050841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514777, 'MR89', 'NL32-05', NULL, 'ISEO', 'Iseo', 'Iseo', '010100002015550000C483C1B6C9AF2541F962E369DB42F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514778, 'LS61', 'NL32-04', NULL, 'ISERABLES', 'Iserables', 'Iserables', '010100002015550000B5A80DB3A1DD2141E40867704117FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514779, 'MS69', 'NL32-05', NULL, 'ISLETEN', 'Isleten', 'Isleten', '010100002015550000B6A52061B4F82441C4944C664B060841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514780, 'MT86', 'NL32-02', NULL, 'ISLIKON', 'Islikon', 'Islikon', '0101000020155500003FC6BA5E7C8D25411BF97EFD56541041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514781, 'NS54', 'NL32-05', NULL, 'ISOLA', 'Isola', 'Isola', '0101000020155500004CF7241C9EB12741A846E27E0F7A0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514782, 'MS90', 'NL32-05', NULL, 'ISONE', 'Isone', 'Isone', '010100002015550000DBE9F7191CF42541EACE046DC4EBFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514784, 'LR59', 'NL32-04', NULL, 'ISSERT', 'Issert', 'Issert', '010100002015550000D67367499D8C214198DC3A702E07F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514785, 'LS82', 'NL32-04', NULL, 'ITRAVERS', 'Itravers', 'Itravers', '010100002015550000B9E946CA6C6A22417609F639FECCFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514787, 'MT26', 'NL32-02', NULL, 'ITTENTHAL', 'Ittenthal', 'Ittenthal', '010100002015550000D7C9C4D845B7234178D6EF0B4E0E1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514788, 'MT97', 'NL32-02', NULL, 'ITTINGEN', 'Ittingen', 'Ittingen', '010100002015550000FF72083F49A02541E8D7AED3E7AB1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514789, 'LT70', 'NL32-04', NULL, 'JAGGISBACHAU', 'Jaggisbachau', 'Jaggisbachau', '01010000201555000010959F1CF6062241CEF28FB477660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514790, 'LS66', 'NL32-04', NULL, 'JAUN', 'Jaun', 'Jaun', '010100002015550000CB7C3DDC87F2214175A95F00B6A60341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514793, 'LS42', 'NL32-04', NULL, 'JAVERNE', 'Javerne', 'Javerne', '010100002015550000F12A6D3E45652141824B81B4CD5DFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514794, 'LT81', 'NL32-01', NULL, 'JEGENSTORF', 'Jegenstorf', 'Jegenstorf', '010100002015550000121FDA62EE732241861F3F95B4C10941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514795, 'NS39', 'NL32-05', NULL, 'JELI', 'Jeli', 'Jeli', '01010000201555000030A70847A4232741DBAF63E5CD6D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514796, 'NS59', 'NL32-05', NULL, 'JENAZ', 'Jenaz', 'Jenaz', '0101000020155500001C2286A9AB90274128CD85A2DE790841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514797, 'NT40', 'NL32-02', NULL, 'JENINS', 'Jenins', 'Jenins', '010100002015550000A9E17F99CE3F2741CE5746D683580941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514799, 'LT60', 'NL32-04', NULL, 'JERISBERGHOF', 'Jerisberghof', 'Jerisberghof', '010100002015550000EBF4B21193C12141C64B59F61B670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514800, 'LS69', 'NL32-04', NULL, 'JEUSS', 'Jeuss', 'Jeuss', '01010000201555000025966C3C99AD2141545BD179AAB90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514802, 'MT83', 'NL32-02', NULL, 'JONA', 'Jona', 'Jona', '01010000201555000099B62C592C9225418EC04FA881960C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514803, 'MT53', 'NL32-02', NULL, 'JONEN', 'Jonen', 'Jonen', '01010000201555000036C0AE1C88872441B8CDA8A11D340D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514804, 'NT05', 'NL32-02', NULL, 'JONSCHWIL', 'Jonschwil', 'Jonschwil', '010100002015550000C4F133B9CE1826412831977A171E0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514815, 'NS44', 'NL32-05', NULL, 'JUF', 'Juf', 'Juf', '010100002015550000E8AA78B7C3562741EAACDEF89DE30141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514827, 'KS92', 'NL32-04', NULL, 'JUSSY', 'Jussy', 'Jussy', '0101000020155500004D8C5756E62E1F415CD6C3B607F6FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514828, 'MT06', 'NL32-01', NULL, 'KAISERAUGST', 'Kaiseraugst', 'Kaiseraugst', '010100002015550000D3C967A011F3224131E749070A291041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514830, 'MS38', 'NL32-05', NULL, 'KAISERSTUHL', 'Kaiserstuhl', 'Kaiserstuhl', '010100002015550000683966329001244126288289129F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514831, 'MT56', 'NL32-02', NULL, 'KAISERSTUHL', 'Kaiserstuhl', 'Kaiserstuhl', '010100002015550000DA8758FC7D8E24417BB8AE6988691041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514832, 'MT26', 'NL32-02', NULL, 'KAISTEN', 'Kaisten', 'Kaisten', '010100002015550000BF68900C5BAD2341673DB5BD1B2B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514833, 'LS64', 'NL32-04', NULL, 'KALBERHONI', 'Kalberhöni', 'Kalberhoni', '01010000201555000018CBD4F14BDE2141B4CECFCFB2D70141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514834, 'MT97', 'NL32-02', NULL, 'KALCHRAIN', 'Kalchrain', 'Kalchrain', '010100002015550000EC42DE4998B32541EFB5990896C91041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514835, 'LS78', 'NL32-04', NULL, 'KALCHSTATTEN', 'Kalchstätten', 'Kalchstatten', '010100002015550000A4FD07F5C3FC2141B0B1FFE8A0E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514837, 'LT60', 'NL32-01', NULL, 'KALLNACH', 'Kallnach', 'Kallnach', '0101000020155500004CA871348DD5214145E4407C7D4E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514839, 'NT02', 'NL32-02', NULL, 'KALTBRUNN', 'Kaltbrunn', 'Kaltbrunn', '01010000201555000046AB1E5A2BFF2541FB9EC460072B0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514841, 'LS95', 'NL32-04', NULL, 'KANDERGRUND', 'Kandergrund', 'Kandergrund', '0101000020155500003870C4E720D822416078CB066EF90241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514843, 'LS94', 'NL32-04', NULL, 'KANDERSTEG', 'Kandersteg', 'Kandersteg', '010100002015550000998682D64BD8224161AE62FDD5110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514846, 'MT63', 'NL32-02', NULL, 'KAPPEL', 'Kappel', 'Kappel', '01010000201555000054691F8D41CD244177802E1E19500C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514847, 'NT03', 'NL32-02', NULL, 'KAPPEL', 'Kappel', 'Kappel', '010100002015550000CF48A4BC8B2F264165447D9FD1DC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514849, 'LT61', 'NL32-01', NULL, 'KAPPELEN', 'Kappelen', 'Kappelen', '01010000201555000009A2668E85DF2141387A3FC531C20941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514850, 'LT60', 'NL32-04', NULL, 'KAPPELI', 'Käppeli', 'Kappeli', '010100002015550000A0BB38B579D52141DCCB7BBAAFDA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514853, 'MT90', 'NL32-02', NULL, 'KASERN', 'Käsern', 'Kasern', '0101000020155500000AA4652796C725419C192916C3350941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514854, 'MS33', 'NL32-05', NULL, 'KASERSTATT', 'Käserstatt', 'Kaserstatt', '0101000020155500001348754CEB042441E4A48C36A8F70041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514855, 'MT40', 'NL32-02', NULL, 'KASTANIENBAUM', 'Kastanienbaum', 'Kastanienbaum', '010100002015550000063F24C8F2622441D2B28EFAF2590941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514856, 'NS18', 'NL32-05', NULL, 'KASTRIS', 'Kästris', 'Kastris', '010100002015550000E29E053E2B7426416571D0F949530641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514858, 'MT86', 'NL32-02', NULL, 'KEFIKON', 'Kefikon', 'Kefikon', '0101000020155500003FC16EB7E279254177446293A4531041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514859, 'LS89', 'NL32-04', NULL, 'KEHRSATZ', 'Kehrsatz', 'Kehrsatz', '01010000201555000017D5C332306022412BDBCBC58BB80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514860, 'MT50', 'NL32-05', NULL, 'KEHRSITEN', 'Kehrsiten', 'Kehrsiten', '0101000020155500002DADFEF216772441AF33E89F12E70841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514862, 'MS18', 'NL32-04', NULL, 'KEMMERIBODENBAD', 'Kemmeribodenbad', 'Kemmeribodenbad', '010100002015550000CA38969B996C2341CF36693B98600641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514864, 'MT75', 'NL32-02', NULL, 'KEMPTTHAL', 'Kemptthal', 'Kemptthal', '01010000201555000024839218AE362541E00F0BA041470F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514868, 'LT81', 'NL32-01', NULL, 'KERNENRIED', 'Kernenried', 'Kernenried', '0101000020155500004983F8BB97912241178527C8BCFB0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514869, 'MS49', 'NL32-05', NULL, 'KERNS', 'Kerns', 'Kerns', '010100002015550000B5F7421957462441038F437758C30741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514870, 'LT60', 'NL32-04', NULL, 'KERZERS', 'Kerzers', 'Kerzers', '0101000020155500007E409B649EC12141E15696B502A10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514872, 'NT27', 'NL32-02', NULL, 'KESSWIL', 'Kesswil', 'Kesswil', '010100002015550000FCBDCACC629526410760C72E46991041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514873, 'LS96', 'NL32-04', NULL, 'KIEN', 'Kien', 'Kien', '01010000201555000014C4274AEFE12241D34C60F124E10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514874, 'MS27', 'NL32-05', NULL, 'KIENHOLZ', 'Kienholz', 'Kienholz', '010100002015550000AEFDA40B75BC234117D3F12E1BB50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514875, 'MS05', 'NL32-04', NULL, 'KIENTAL', 'Kiental', 'Kiental', '010100002015550000E34DEB06F7FF22414716F2DBC16D0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514879, 'LS98', 'NL32-04', NULL, 'KIESEN', 'Kiesen', 'Kiesen', '010100002015550000A9E683E7D59B2241A090641947970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514884, 'MT64', 'NL32-02', NULL, 'KILCHBERG', 'Kilchberg', 'Kilchberg', '01010000201555000028E81604F3DF2441479122B0B2720D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514885, 'MT55', 'NL32-02', NULL, 'KILLWANGEN', 'Killwangen', 'Killwangen', '01010000201555000059AF9241A5682441021E619DEE010F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514886, 'MS79', 'NL32-05', NULL, 'KINZERALP', 'Kinzeralp', 'Kinzeralp', '0101000020155500001131F30AF651254148ED033BD80B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514888, 'MS03', 'NL32-04', NULL, 'KIPPEL', 'Kippel', 'Kippel', '010100002015550000E85E1DE19614234130D104A431F10041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514889, 'LT91', 'NL32-01', NULL, 'KIRCHBERG', 'Kirchberg', 'Kirchberg', '0101000020155500006A6F271159A5224196C672A7C4350A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514890, 'NT05', 'NL32-02', NULL, 'KIRCHBERG', 'Kirchberg', 'Kirchberg', '0101000020155500006BB6DE6FA3FB2541A487C817C3E10E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514891, 'MT86', 'NL32-02', NULL, 'KIRCHDINHARD', 'Kirchdinhard', 'Kirchdinhard', '01010000201555000063CCC60249662541D19C4C6DF6521041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514892, 'LS88', 'NL32-04', NULL, 'KIRCHDORF', 'Kirchdorf', 'Kirchdorf', '01010000201555000064B03E04E69122415CB6D4AF37970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514893, 'LT70', 'NL32-01', NULL, 'KIRCHLINDACH', 'Kirchlindach', 'Kirchlindach', '010100002015550000A6603BDB72422241A3E7568EF3130941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514897, 'LT96', 'NL32-01', NULL, 'KLEINBASEL', 'Klein-Basel', 'Klein-Basel', '010100002015550000A3C0980494A42241D8EE166187621041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514898, 'MT02', 'NL32-01', NULL, 'KLEINDIETWIL', 'Kleindietwil', 'Kleindietwil', '0101000020155500007046868CCF1B2341395734A8F3E40A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514903, 'LS89', 'NL32-04', NULL, 'KLEINHOCHSTETTEN', 'Kleinhöchstetten', 'Kleinhochstetten', '0101000020155500000A1B00F9DF872241D9FBD916ABB80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514904, 'LT97', 'NL32-01', NULL, 'KLEINHUNINGEN', 'Kleinhüningen', 'Kleinhuningen', '010100002015550000919DFC388DA422412AE5C6F77B7F1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514905, 'LT85', 'NL32-01', NULL, 'KLEINLUTZEL', 'Kleinlützel', 'Kleinlutzel', '01010000201555000003D87A068F4222417862E1697AF50E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514914, 'MT47', 'NL32-02', NULL, 'KLINGNAU', 'Klingnau', 'Klingnau', '010100002015550000F6A848F25C2C244144F7CFB840841041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514921, 'NA62', 'NM32-08', NULL, 'KLOSTERSBRUCKE', 'Klosters Brücke', 'Klosters Brucke', '010100002015550000EE1B810738AE27416E8B0DF1EC152041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514922, 'NS69', 'NL32-05', NULL, 'KLOSTERSDORF', 'Klosters Dorf', 'Klosters Dorf', '010100002015550000A87CD71120F52741FDC797611AD80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514924, 'NS69', 'NL32-05', NULL, 'KLOSTERSPLATZ', 'Klosters Platz', 'Klosters Platz', '010100002015550000B48DBBBF92F52741AF967DF83A9E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514925, 'NS69', 'NL32-05', NULL, 'KLOSTERSSERNEUS', 'Klosters Serneus', 'Klosters Serneus', '0101000020155500001EE2B1FE48E12741A2BE81AAA9D50741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514927, 'MT65', 'NL32-02', NULL, 'KLOTEN', 'Kloten', 'Kloten', '0101000020155500000A5FB57FF2F124412E7C8A6E0A430F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514928, 'LS86', 'NL32-04', NULL, 'KLUSI', 'Klusi', 'Klusi', '01010000201555000014DA15021E8822411FA7C498118E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514929, 'MT53', 'NL32-02', NULL, 'KNONAU', 'Knonau', 'Knonau', '0101000020155500007C4109ACD1A524419579F67BFF4D0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514930, 'MT22', 'NL32-02', NULL, 'KNUTWIL', 'Knutwil', 'Knutwil', '010100002015550000DC35CFC347C323410820DB33B8D00B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514931, 'MT47', 'NL32-02', NULL, 'KOBLENZ', 'Koblenz', 'Koblenz', '010100002015550000A9799A6046222441ADDA5E16F6BD1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514933, 'MT85', 'NL32-02', NULL, 'KOLLBRUNN', 'Kollbrunn', 'Kollbrunn', '010100002015550000C707131EC6672541E24FEE97844A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514934, 'MT24', 'NL32-02', NULL, 'KOLLIKEN', 'Kölliken', 'Kolliken', '010100002015550000253AC177D4A423414B39F6B80A9F0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514935, 'LS79', 'NL32-04', 3, 'KONIZ', 'Köniz', 'Koniz', '0101000020155500004F4ACB706D422241B485DDA671F20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514938, 'LS99', 'NL32-04', NULL, 'KONOLFINGEN', 'Konolfingen', 'Konolfingen', '010100002015550000E427FBC870C3224132876040347F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514940, 'LS99', 'NL32-04', NULL, 'KONOLFINGENDORF', 'Konolfingen Dorf', 'Konolfingen Dorf', '01010000201555000072D6A8A067C3224116E138DB1AB90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514942, 'LT92', 'NL32-01', NULL, 'KOPPIGEN', 'Koppigen', 'Koppigen', '01010000201555000065F3359A25AF2241B894EDE48DE30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514943, 'NT16', 'NL32-02', NULL, 'KRADOLF', 'Kradolf', 'Kradolf', '0101000020155500008B57E3869A5B2641B8CA1733B73F1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514944, 'MS06', 'NL32-04', NULL, 'KRATTIGEN', 'Krattigen', 'Krattigen', '0101000020155500009DC5D27DBFFF2241A12EF5125A550441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514946, 'LT90', 'NL32-01', NULL, 'KRAUCHTHAL', 'Krauchthal', 'Krauchthal', '010100002015550000EF5C5ED38D9B2241A3712C1E174E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514947, 'MS27', 'NL32-05', NULL, 'KRAUTMETTLI', 'Krautmettli', 'Krautmettli', '01010000201555000089A4E5BEAEBC2341E1D0E47F4F410541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514948, 'MT00', 'NL32-04', NULL, 'KREUZBRUCKE', 'Kreuzbrücke', 'Kreuzbrucke', '0101000020155500008B595CD56B2623410C0E7D8B35680841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514950, 'NT17', 'NL32-02', NULL, 'KREUZLINGEN', 'Kreuzlingen', 'Kreuzlingen', '010100002015550000FDBF49298C4F2641BC124412EB091141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514951, 'LS69', 'NL32-04', NULL, 'KRIECHENWIL', 'Kriechenwil', 'Kriechenwil', '010100002015550000110962F748D52141CF80A74A2EB90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514953, 'NS68', 'NL32-05', NULL, 'KRIEGSMATTE', 'Kriegsmatte', 'Kriegsmatte', '01010000201555000034F1255DC00128411FC3324D1A7E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514954, 'LT92', 'NL32-01', NULL, 'KRIEGSTETTEN', 'Kriegstetten', 'Kriegstetten', '010100002015550000A41E08DB0EAF2241E25FA80144910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514956, 'MT40', 'NL32-02', 3, 'KRIENS', 'Kriens', 'Kriens', '010100002015550000002B831218452441B9A3760C88920941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514958, 'NT04', 'NL32-02', NULL, 'KRINAU', 'Krinau', 'Krinau', '010100002015550000F9032D233F072641D07104EC31870D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514959, 'NT25', 'NL32-02', NULL, 'KRONBUHL', 'Kronbühl', 'Kronbuhl', '01010000201555000068D27C5738C92641192D5E7429680F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514962, 'MS19', 'NL32-04', NULL, 'KROSCHENBRUNNEN', 'Kröschenbrunnen', 'Kroschenbrunnen', '010100002015550000F15CD47F3A5823414CF20C6E86BB0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514963, 'NT13', 'NL32-02', NULL, 'KRUMMENAU', 'Krummenau', 'Krummenau', '0101000020155500007210C70EBD4D26418B25E4539A6B0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514965, 'NS59', 'NL32-05', NULL, 'KUBLIS', 'Küblis', 'Kublis', '010100002015550000859C83E141AF2741B892CDDC95090841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514966, 'MT62', 'NL32-02', NULL, 'KUENZ', 'Kuenz', 'Kuenz', '010100002015550000BF3F963175EB24411CB5F0B410A40B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514968, 'MS68', 'NL32-05', NULL, 'KULM', 'Kulm', 'Kulm', '01010000201555000063794A7BB1032541F800BACB67E50641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514969, 'MT61', 'NL32-02', NULL, 'KULM', 'Kulm', 'Kulm', '01010000201555000065DF0145A8BB244113EAA89E25D20941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514971, 'NS57', 'NL32-05', NULL, 'KUMMA', 'Kumma', 'Kumma', '010100002015550000E2EB6F39FCC627412244833B12030641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514973, 'MT44', 'NL32-02', NULL, 'KUNTEN', 'Künten', 'Kunten', '010100002015550000B634F77C7C5524414DD6B2C752530E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514979, 'MT64', 'NL32-02', NULL, 'KUSNACHT', 'Küsnacht', 'Kusnacht', '0101000020155500006FE75BFFA2F324417A1D6D83D4730D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514980, 'MT51', 'NL32-02', NULL, 'KUSSNACHT', 'Küssnacht', 'Kussnacht', '0101000020155500007C8F4B679C9D2441C6ACE17C66440A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514983, 'MT25', 'NL32-02', NULL, 'KUTTIGEN', 'Küttigen', 'Kuttigen', '010100002015550000686855FAF2B7234159F2EA8B2AC10E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514984, 'LT82', 'NL32-01', NULL, 'KUTTIGKOFEN', 'Küttigkofen', 'Kuttigkofen', '010100002015550000697CBB1BE0732241FE9F506B38E30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514985, 'MT85', 'NL32-02', NULL, 'KYBURG', 'Kyburg', 'Kyburg', '010100002015550000009039F02254254191B7E13130490F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514986, 'NS18', 'NL32-05', NULL, 'LAAX', 'Laax', 'Laax', '01010000201555000031EDED44B78726416AB81245FE8E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514988, 'LS41', 'NL32-04', NULL, 'LABALMAZ', 'La Balmaz', 'La Balmaz', '0101000020155500005185F7CED95A21416190953D3B1BFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514989, 'LS70', 'NL32-04', NULL, 'LABARMA', 'La Barma', 'La Barma', '0101000020155500005A0360E10C2E2241E61BEECF745FF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514992, 'KS96', 'NL32-04', NULL, 'LABBAYE', 'L’Abbaye', 'L’Abbaye', '010100002015550000555D1B4E03611F412AE6A2AC45670441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514997, 'LT10', 'NL32-04', NULL, 'LABREVINE', 'La Brévine', 'La Brevine', '010100002015550000E8E4F5CB0B5D2041085AD2A3BAE40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515001, 'LT53', 'NL32-01', NULL, 'LACHAUX', 'La Chaux', 'La Chaux', '0101000020155500001750B5ACA65F2141EC813A7E2D070C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515003, 'LT32', 'NL32-01', 3, 'LACHAUXDEFONDS', 'La Chaux-de-Fonds', 'La Chaux-de-Fonds', '01010000201555000003F724219DF22041B37F65C56BE80A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515006, 'MT82', 'NL32-02', NULL, 'LACHEN', 'Lachen', 'Lachen', '010100002015550000191AB1FD36932541D6308DBAECAE0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515007, 'LS34', 'NL32-04', NULL, 'LACHIESAZ', 'La Chièsaz', 'La Chiesaz', '0101000020155500001238253743022141BE196886E2DB0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515009, 'LS53', 'NL32-04', NULL, 'LACOMBALLAZ', 'La Comballaz', 'La Comballaz', '0101000020155500006346DE4DEF6F2141317AA59AC9B70041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515012, 'LS09', 'NL32-04', NULL, 'LACOTEAUXFEES', 'La Côte-aux-Fées', 'La Cote-aux-Fees', '010100002015550000EEAAE4887816204148F5C4ADA0520741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515013, 'KS72', 'NL32-04', NULL, 'LACOULOUVRENIERE', 'La Coulouvrenière', 'La Coulouvreniere', '010100002015550000CF237CA8B9781E41E939FE640AA6FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515014, 'LS71', 'NL32-04', NULL, 'LACRETA', 'La Crêta', 'La Creta', '010100002015550000DC945A4F4B4C2241C323ADB5F289FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515015, 'KS75', 'NL32-04', NULL, 'LACURE', 'La Cure', 'La Cure', '0101000020155500007EE267D170441E413A981F404EF30141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515017, 'KS97', 'NL32-04', NULL, 'LADERNIER', 'La Dernier', 'La Dernier', '010100002015550000189497ECEAB11F418864ADECBC120541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515018, 'LS95', 'NL32-04', NULL, 'LADHOLZ', 'Ladholz', 'Ladholz', '0101000020155500002EFDA58E36B022411DA8F8DB22BF0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515019, 'NS39', 'NL32-05', NULL, 'LADILS', 'Ladils', 'Ladils', '010100002015550000B948E5B014F226416F0A2733A8680841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515020, 'NS18', 'NL32-05', NULL, 'LADIR', 'Ladir', 'Ladir', '0101000020155500007ACB2B3CE7692641B76C8200478C0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515025, 'LT32', 'NL32-01', NULL, 'LAFERRIERE', 'La Ferrière', 'La Ferriere', '010100002015550000857CAED35E062141E84D50EFD7E70A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515026, 'LS62', 'NL32-04', NULL, 'LAFONTAINE', 'La Fontaine', 'La Fontaine', '01010000201555000092467273F7FB214119821E7688CDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515027, 'LS53', 'NL32-04', NULL, 'LAFORCLAZ', 'La Forclaz', 'La Forclaz', '010100002015550000823AB80DCC6F2141337207EFFD430041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515028, 'LR58', 'NL32-07', NULL, 'LAFOULY', 'La Fouly', 'La Fouly', '0101000020155500002D6326FF2C782141557DDB76AF38F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515032, 'LS72', 'NL32-04', NULL, 'LAGIETEDELE', 'La Giète Délé', 'La Giete Dele', '010100002015550000F05749AB4D4C2241B75ACFB45328FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515035, 'LS80', 'NL32-04', NULL, 'LAGOUILLE', 'La Gouille', 'La Gouille', '0101000020155500005AB5D39C856A22415F32E0F56A5FF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515036, 'LT62', 'NL32-01', NULL, 'LAHEUTTE', 'La Heutte', 'La Heutte', '0101000020155500006A302D2810CC214125BA54AAA0910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515042, 'LT53', 'NL32-01', NULL, 'LAJOUX', 'Lajoux', 'Lajoux', '010100002015550000B2A5B74C0E9B2141E2AF049BB8ED0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515043, 'MS12', 'NL32-04', NULL, 'LALDEN', 'Lalden', 'Lalden', '010100002015550000FD33DACF35652341B6484F29D62EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515044, 'LS54', 'NL32-04', NULL, 'LALECHERETTE', 'La Lécherette', 'La Lecherette', '0101000020155500000B93331D2A8E214121C99FBBF2640141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515050, 'LT51', 'NL32-01', NULL, 'LAMBOING', 'Lamboing', 'Lamboing', '010100002015550000490FFC3B5FA42141EA705EC287AA0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515052, 'LS51', 'NL32-04', NULL, 'LAMEREUNE', 'La Méreune', 'La Mereune', '010100002015550000D75F9C8BF86E2141689B54796E1AFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515053, 'LR89', 'NL32-04', NULL, 'LAMONTA', 'La Monta', 'La Monta', '010100002015550000B4DE69AE876A2241C3CB745F9EEBF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515060, 'NS02', 'NL32-05', NULL, 'LANDARENCA', 'Landarenca', 'Landarenca', '01010000201555000007AFD35131412641D633DB1C79F2FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515061, 'MS29', 'NL32-05', NULL, 'LANDBRUGG', 'Landbrugg', 'Landbrugg', '010100002015550000D3D36ECA789D234192AA8C6E1A310841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515062, 'LT90', 'NL32-04', NULL, 'LANDISWIL', 'Landiswil', 'Landiswil', '0101000020155500007B5F72501FD722412761694E05670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515063, 'NS49', 'NL32-05', NULL, 'LANDQUART', 'Landquart', 'Landquart', '0101000020155500000623C323FC402741F02D0AB6DFAA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515065, 'NS49', 'NL32-05', NULL, 'LANDQUARTFABRIKEN', 'Landquart Fabriken', 'Landquart Fabriken', '0101000020155500000623C323FC402741F02D0AB6DFAA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515069, 'LT51', 'NL32-01', NULL, 'LANEUVEVILLE', 'La Neuveville', 'La Neuveville', '0101000020155500007CA42C068A862141169C29724CFD0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515071, 'MT04', 'NL32-01', NULL, 'LANGENBRUCK', 'Langenbruck', 'Langenbruck', '010100002015550000320C71044F0723411A05DE2162D50D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515072, 'LS97', 'NL32-04', NULL, 'LANGENSCHACHEN', 'Längenschachen', 'Langenschachen', '010100002015550000194C652AAAE122411B7ADDC8893C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515075, 'MT02', 'NL32-01', NULL, 'LANGENTHAL', 'Langenthal', 'Langenthal', '0101000020155500002A073A4F7E1B234145306E5078060C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515078, 'MT00', 'NL32-04', NULL, 'LANGNAU', 'Langnau', 'Langnau', '010100002015550000BA7156B89812234108AF028ADC670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515079, 'MT22', 'NL32-01', NULL, 'LANGNAU', 'Langnau', 'Langnau', '0101000020155500004A28CDBA1F7E2341E6A43A7B9E080C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515080, 'MT63', 'NL32-02', NULL, 'LANGNAU', 'Langnau', 'Langnau', '0101000020155500001019C76682D62441EA96E1E857FE0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515081, 'NT17', 'NL32-02', NULL, 'LANGRICKENBACH', 'Langrickenbach', 'Langrickenbach', '0101000020155500003A6238E8366E2641C6B6A8BB72971041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515083, 'NS58', 'NL32-05', NULL, 'LANGWIES', 'Langwies', 'Langwies', '01010000201555000004E157842C932741B8C1F4079C1E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515085, 'LS80', 'NL32-04', NULL, 'LANNAZ', 'Lannaz', 'Lannaz', '010100002015550000B3C4FE447B6A2241103F34DD68A2FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515089, 'LS60', 'NL32-04', NULL, 'LAPERREYRE', 'La Perreyre', 'La Perreyre', '010100002015550000CEF2A23A88E72141E5AD767214D4F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515091, 'KS61', 'NL32-04', NULL, 'LAPLAINE', 'La Plaine', 'La Plaine', '01010000201555000097EE737867D71D418CD396C2863DFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515093, 'KS71', 'NL32-04', NULL, 'LAPRAILLE', 'La Praille', 'La Praille', '010100002015550000B81F634C23641E4104A9708C9B33FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515094, 'LS07', 'NL32-04', NULL, 'LAPRAZ', 'La Praz', 'La Praz', '0101000020155500005D6BF044FED81F41B04E7199E49D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515098, 'KS84', 'NL32-04', NULL, 'LAREDOUTE', 'La Redoute', 'La Redoute', '010100002015550000C35B073D38F61E413A039FA9F6CB0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515099, 'NS42', 'NL32-05', NULL, 'LARET', 'Laret', 'Laret', '010100002015550000126FFDA8F4632741BC428B72B4150041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515100, 'NS68', 'NL32-05', NULL, 'LARET', 'Laret', 'Laret', '010100002015550000A037545318EC2741BDB1F0E021630741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515101, 'LT62', 'NL32-01', NULL, 'LAREUCHENETTE', 'La Reuchenette', 'La Reuchenette', '010100002015550000651EA03ECDDF21415A8E117E6B910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515103, 'LS57', 'NL32-04', NULL, 'LAROCHE', 'La Roche', 'La Roche', '010100002015550000817C7AAC1399214100F15BAC29030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515104, 'NS83', 'NL32-06', NULL, 'LAROSA', 'La Rösa', 'La Rosa', '010100002015550000EBDD6A8F387A28418BB7BA1652590141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515105, 'LS93', 'NL32-04', NULL, 'LARSI', 'Larsi', 'Larsi', '01010000201555000076686E6182B02241C876C8DE267C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515109, 'LT31', 'NL32-01', NULL, 'LASAGNE', 'La Sagne', 'La Sagne', '0101000020155500002A359E7463D4204197F0883FD8C70941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515111, 'LS17', 'NL32-04', NULL, 'LASARRAZ', 'La Sarraz', 'La Sarraz', '01010000201555000059AD89CD472820413AF785E5EC9A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515115, 'LS54', 'NL32-04', NULL, 'LATINE', 'La Tine', 'La Tine', '0101000020155500009FD707074766214120225EC078D90141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515116, 'LS80', 'NL32-04', NULL, 'LATOUR', 'La Tour', 'La Tour', '010100002015550000107C862B91742241DA0DE0F7DDBAF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515117, 'LS34', 'NL32-04', NULL, 'LATOURDEPEILZ', 'La Tour-de-Peilz', 'La Tour-de-Peilz', '010100002015550000C8C166C927F820411E9C3B9C46A20141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515118, 'LS56', 'NL32-04', NULL, 'LATOURDETREME', 'La Tour-de-Trême', 'La Tour-de-Treme', '010100002015550000D50F3C0EE6702141C9F709355CE20341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515119, 'NS56', 'NL32-05', NULL, 'LATSCH', 'Latsch', 'Latsch', '010100002015550000AD7C069714B62741C3EFA419976B0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515120, 'LS74', 'NL32-04', NULL, 'LAUENEN', 'Lauenen', 'Lauenen', '010100002015550000D9A8DFFD3E102241D577CC27A0290141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515121, 'MT60', 'NL32-02', NULL, 'LAUERZ', 'Lauerz', 'Lauerz', '01010000201555000058C960FD39F724414CEA701E909B0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515123, 'MT15', 'NL32-01', NULL, 'LAUFELFINGEN', 'Läufelfingen', 'Laufelfingen', '010100002015550000192DB3B71C42234171241D3830840E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515125, 'LT85', 'NL32-01', NULL, 'LAUFEN', 'Laufen', 'Laufen', '01010000201555000072332A90AF732241F402BDFF9DBB0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515126, 'MT78', 'NL32-02', NULL, 'LAUFEN', 'Laufen', 'Laufen', '0101000020155500000B1423DD8A022541D21EEF046F371141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515127, 'MT26', 'NL32-02', NULL, 'LAUFENBURG', 'Laufenburg', 'Laufenburg', '01010000201555000030A82F47EFB6234120E1F3002B651041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515128, 'LS69', 'NL32-04', NULL, 'LAUPEN', 'Laupen', 'Laupen', '010100002015550000A8970DE934DF21418DDC10A514B90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515129, 'LT94', 'NL32-01', NULL, 'LAUPERSDORF', 'Laupersdorf', 'Laupersdorf', '0101000020155500006436B8EE5ACC224120AE6550C9600D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515130, 'MT00', 'NL32-04', NULL, 'LAUPERSWIL', 'Lauperswil', 'Lauperswil', '01010000201555000033381B95C5FE22418D16F3298C670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515131, 'NS01', 'NL32-05', NULL, 'LAURA', 'Laura', 'Laura', '0101000020155500006F78C43401392641C0BD59CA233AFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515132, 'LS25', 'NL32-04', 1, 'LAUSANNE', 'Lausanne', 'Lausanne', '010100002015550000CA8065FED08020416797965FE0C70241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515133, 'MT05', 'NL32-01', NULL, 'LAUSEN', 'Lausen', 'Lausen', '0101000020155500008F50994DE8062341B1A7A455BC6A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515134, 'MS16', 'NL32-04', NULL, 'LAUTERBRUNNEN', 'Lauterbrunnen', 'Lauterbrunnen', '010100002015550000629C2A1BAE63234132175A4A93A90341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515144, 'MS82', 'NL32-05', NULL, 'LAVERTEZZO', 'Lavertezzo', 'Lavertezzo', '0101000020155500001A7D317BC1972541B4631BD3A508FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515145, 'LS42', 'NL32-04', NULL, 'LAVEY', 'Lavey', 'Lavey', '01010000201555000085FD489D265B2141FEF80E806AEAFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515146, 'LS41', 'NL32-04', NULL, 'LAVEYLESBAINS', 'Lavey-les-Bains', 'Lavey-les-Bains', '010100002015550000EEA5BA69135B2141509FAAAE9E76FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515148, 'NS87', 'NL32-06', NULL, 'LAVIN', 'Lavin', 'Lavin', '01010000201555000026A861776F832841CB9D14B00F550641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515150, 'MS84', 'NL32-05', NULL, 'LAVORGO', 'Lavorgo', 'Lavorgo', '010100002015550000CF70550CAB942541A3EA7DD1FEBA0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515151, 'MS33', 'NL32-05', NULL, 'LAX', 'Lax', 'Lax', '010100002015550000B5B533E000E723418883E23CAFBC0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515154, 'KS86', 'NL32-04', NULL, 'LEBRASSUS', 'Le Brassus', 'Le Brassus', '0101000020155500008A1C693B9BE71E4172E0056B48830341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515155, 'LS57', 'NL32-04', NULL, 'LEBRY', 'Le Bry', 'Le Bry', '01010000201555000056B8F48A337B2141EFF916EDAA030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515156, 'LS60', 'NL32-04', NULL, 'LECHABLE', 'Le Châble', 'Le Chable', '010100002015550000A06D1F3F46BF214154D5DAC4B948F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515157, 'LS25', 'NL32-04', NULL, 'LECHALETAGOBET', 'Le Chalet-à-Gobet', 'Le Chalet-a-Gobet', '0101000020155500003BBF4E9F158B2041F1909C78473B0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515158, 'LS34', 'NL32-04', NULL, 'LECHATELARD', 'Le Châtelard', 'Le Chatelard', '0101000020155500001A33BE3E2B162141B296F9D16FA10141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515159, 'LS25', 'NL32-04', NULL, 'LECHATELARD', 'Le Châtelard', 'Le Chatelard', '0101000020155500001A5A8DA7868A204108BC6FE8B1530241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515161, 'LS48', 'NL32-04', NULL, 'LECHELLES', 'Léchelles', 'Lechelles', '010100002015550000918492FCFD5321411EE80ECEA6D30641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515162, 'KS86', 'NL32-04', NULL, 'LECHENIT', 'Le Chenit', 'Le Chenit', '0101000020155500009140257002FC1E41E2397C808EBC0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515166, 'LS54', 'NL32-04', NULL, 'LECONTOUR', 'Le Contour', 'Le Contour', '010100002015550000696CDD6320A221415E6F18CFBC2A0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515167, 'LS46', 'NL32-04', NULL, 'LECRET', 'Le Crêt', 'Le Cret', '010100002015550000D3D753BC03212141A1EC9E7340AA0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515171, 'LS40', 'NL32-04', NULL, 'LEFAYS', 'Le Fays', 'Le Fays', '0101000020155500007DEB93CC795A2141CD371D873FD8F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515173, 'NS12', 'NL32-05', NULL, 'LEGGIA', 'Leggia', 'Leggia', '0101000020155500001B8D04E53A602641BC2F0B60649CFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515178, 'KS72', 'NL32-04', NULL, 'LEGRANDSACONNEX', 'Le Grand-Saconnex', 'Le Grand-Saconnex', '0101000020155500009A41DE99B0791E41F9AD0A509A8DFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515180, 'MT37', 'NL32-02', NULL, 'LEIBSTADT', 'Leibstadt', 'Leibstadt', '0101000020155500005D4E1ED82E052441DE9946E279831041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515181, 'NT16', 'NL32-02', NULL, 'LEIMBACH', 'Leimbach', 'Leimbach', '010100002015550000BD97964928512641C6FB188D2C791041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515182, 'NS16', 'NL32-05', NULL, 'LEIS', 'Leis', 'Leis', '0101000020155500003A3754EE8859264108CC260CC50D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515183, 'MS06', 'NL32-04', NULL, 'LEISSIGEN', 'Leissigen', 'Leissigen', '010100002015550000C071B4FCAE1323413E8F99E6AA550441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515187, 'LT51', 'NL32-01', NULL, 'LELANDERON', 'Le Landeron', 'Le Landeron', '010100002015550000D3B5E750B0722141019FD88DC1C30941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515189, 'MS90', 'NL32-05', NULL, 'LELGIO', 'Lelgio', 'Lelgio', '0101000020155500000DDD2BE4D2E02541FECE004A4D8DF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515190, 'MS29', 'NL32-04', NULL, 'LELIN', 'Lelin', 'Lelin', '0101000020155500009CE2E52CA4892341268C2F998D300841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515193, 'LT21', 'NL32-01', NULL, 'LELOCLE', 'Le Locle', 'Le Locle', '010100002015550000FBBFB9BFD5B62041D8583F69C0020A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515200, 'LS15', 'NL32-04', NULL, 'LEMONTSURLAUSANNE', 'Le Mont-sur-Lausanne', 'Le Mont-sur-Lausanne', '0101000020155500007DE487CBFC6C20413856FCB993020341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515202, 'LT72', 'NL32-01', NULL, 'LENGNAU', 'Lengnau', 'Lengnau', '0101000020155500006EDFE01BE3242241E56D790FF5900B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515203, 'LS74', 'NL32-04', NULL, 'LENK', 'Lenk', 'Lenk', '010100002015550000B9D2ED52504C2241AE720F0E409D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515206, 'LT43', 'NL32-01', NULL, 'LENOIRMONT', 'Le Noirmont', 'Le Noirmont', '0101000020155500003BB9CCFC552E214119B222004E080C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515207, 'LS82', 'NL32-04', NULL, 'LENS', 'Lens', 'Lens', '0101000020155500004C1FF578565622410E62012188B4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515208, 'NS47', 'NL32-05', NULL, 'LENZ', 'Lenz', 'Lenz', '0101000020155500003ADEE351444727413224F4A3CF0C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515209, 'MT34', 'NL32-02', NULL, 'LENZBURG', 'Lenzburg', 'Lenzburg', '0101000020155500009FB4C7BDD40624411AC5843512500E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515211, 'NS47', 'NL32-05', NULL, 'LENZERHEIDE', 'Lenzerheide', 'Lenzerheide', '010100002015550000A6DF7D2BC03B2741DA7231A03FF30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515213, 'LT41', 'NL32-01', NULL, 'LEPAQUIER', 'Le Pâquier', 'Le Paquier', '010100002015550000E2202FE4784121417F6B200B82720A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515216, 'LT42', 'NL32-01', NULL, 'LEPEUCHAPATTE', 'Le Peuchapatte', 'Le Peuchapatte', '010100002015550000C63294D83E2E21410FE198AC66CE0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515217, 'KS97', 'NL32-04', NULL, 'LEPONT', 'Le Pont', 'Le Pont', '010100002015550000D7ADB4716D611F41278CF9602AA10441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515222, 'NS82', 'NL32-06', NULL, 'LEPRESE', 'Le Prese', 'Le Prese', '010100002015550000B812F52228872841E6EC6637F3FEFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515227, 'KS71', 'NL32-04', NULL, 'LESACACIAS', 'Les Acacias', 'Les Acacias', '01010000201555000029807D2F3E781E41EFF2764F4232FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515230, 'LS44', 'NL32-04', NULL, 'LESAVANTS', 'Les Avants', 'Les Avants', '010100002015550000468863902D2A2141D56D1B84EBA00141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515231, 'LS19', 'NL32-04', NULL, 'LESBAYARDS', 'Les Bayards', 'Les Bayards', '010100002015550000E0FC0A15D62A20413A9E22D05DFF0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515232, 'LT42', 'NL32-01', NULL, 'LESBOIS', 'Les Bois', 'Les Bois', '01010000201555000072CF8EB272102141FC4B30595F5B0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515233, 'LT21', 'NL32-01', NULL, 'LESBRENETS', 'Les Brenets', 'Les Brenets', '010100002015550000F04AD8DA29992041FF9A1757D5030A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515234, 'LT42', 'NL32-01', NULL, 'LESBREULEUX', 'Les Breuleux', 'Les Breuleux', '01010000201555000073A1FB03D84B2141E0D2B412B3CD0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515235, 'KS97', 'NL32-04', NULL, 'LESCHARBONNIERES', 'Les Charbonnières', 'Les Charbonnieres', '010100002015550000D7ADB4716D611F41278CF9602AA10441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515236, 'KS72', 'NL32-04', NULL, 'LESCHARMILLES', 'Les Charmilles', 'Les Charmilles', '01010000201555000022489D58A0641E416628998663A7FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515237, 'LT30', 'NL32-01', NULL, 'LESCOEUDRES', 'Les Coeudres', 'Les Coeudres', '010100002015550000B01013505AC02041EFD5ACF9B4540941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515239, 'LS42', 'NL32-04', NULL, 'LESDEVENS', 'Les Dévens', 'Les Devens', '01010000201555000073905F894C472141ACCD6873AB46FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515241, 'LS53', 'NL32-04', NULL, 'LESDIABLERETS', 'Les Diablerets', 'Les Diablerets', '010100002015550000E21EC5A4E9A12141ACB9B01B25430041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515243, 'KS86', 'NL32-04', NULL, 'LESENTIER', 'Le Sentier', 'Le Sentier', '010100002015550000ECA2E97374FC1E41A36D60E972F60341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515244, 'LS53', 'NL32-04', NULL, 'LESEPEY', 'Le Sépey', 'Le Sepey', '0101000020155500008346C68CD8652141105A8CB5157E0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515245, 'LS51', 'NL32-04', NULL, 'LESGARETTES', 'Les Garettes', 'Les Garettes', '0101000020155500004043EF53278321419E70BE407F8DFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515246, 'LT31', 'NL32-01', NULL, 'LESGENEVEYSSURCOFFRANE', 'Les Geneveys-sur-Coffrane', 'Les Geneveys-sur-Coffrane', '0101000020155500000D7590EDF5F1204144764E5D038D0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515247, 'LT53', 'NL32-01', NULL, 'LESGENEVEZ', 'Les Genevez', 'Les Genevez', '0101000020155500003707E658F19A2141F614163DE9790C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515249, 'LT31', 'NL32-01', NULL, 'LESHAUTSGENEVEYS', 'Les Hauts-Geneveys', 'Les Hauts-Geneveys', '010100002015550000BE8A8D5EDB052141D5FB88EE55C60941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515251, 'LS40', 'NL32-04', NULL, 'LESMARECOTTES', 'Les Marécottes', 'Les Marecottes', '010100002015550000A95E438B914621416FB4CCEE8134FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515252, 'LS54', 'NL32-04', NULL, 'LESMOSSES', 'Les Mosses', 'Les Mosses', '010100002015550000DD6C0E970B8E2141021047F826F10041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515253, 'LS54', 'NL32-04', NULL, 'LESMOULINS', 'Les Moulins', 'Les Moulins', '0101000020155500008B7E58A3488E21411FB5549ABED80141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515254, 'KS82', 'NL32-04', NULL, 'LESPAQUIS', 'Les Pâquis', 'Les Paquis', '01010000201555000097472266ECA01E413C2DB24065A3FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515256, 'LS52', 'NL32-04', NULL, 'LESPLANSSURBEX', 'Les Plans-sur-Bex', 'Les Plans-sur-Bex', '0101000020155500004C572CA187832141348F257B4644FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515257, 'LS34', 'NL32-04', NULL, 'LESPLEIADES', 'Les Pléiades', 'Les Pleiades', '010100002015550000164455815D0221412B2ED121C8150241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515258, 'LT43', 'NL32-01', NULL, 'LESPOMMERATS', 'Les Pommerats', 'Les Pommerats', '01010000201555000085B0738C504221416164608B8AB50C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515260, 'LT20', 'NL32-01', NULL, 'LESPONTSDEMARTEL', 'Les Ponts-de-Martel', 'Les Ponts-de-Martel', '010100002015550000E4B291406CAC20414026EEF2801B0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515263, 'LS50', 'NL32-04', NULL, 'LESRAPPES', 'Les Rappes', 'Les Rappes', '010100002015550000EE57B3B5B378214158A2C17B12D7F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515266, 'LS55', 'NL32-04', NULL, 'LESSOC', 'Lessoc', 'Lessoc', '010100002015550000912429AE6A702141CEE54BAC124D0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515267, 'LS35', 'NL32-04', NULL, 'LESTHIOLEYRES', 'Les Thioleyres', 'Les Thioleyres', '0101000020155500000625962CBDC62041750FAEC353C50241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515269, 'LS50', 'NL32-04', NULL, 'LESVALETTES', 'Les Valettes', 'Les Valettes', '0101000020155500000A4B4F0AB26E21419DBDE86C3E4BF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515270, 'LS09', 'NL32-04', NULL, 'LESVERRIERES', 'Les Verrières', 'Les Verrieres', '0101000020155500009226B32DE70C204125B23DA3E8C60741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515272, 'MT64', 'NL32-02', NULL, 'LETTEN', 'Letten', 'Letten', '010100002015550000875C518318D52441105214C6A6930E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515273, 'NT00', 'NL32-05', NULL, 'LEUGGELBACH', 'Leuggelbach', 'Leuggelbach', '0101000020155500008DBF776F7D0D2641C93815C178C70841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515274, 'LS93', 'NL32-04', NULL, 'LEUK', 'Leuk', 'Leuk', '01010000201555000027812225A8C422417A05AC99469DFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515275, 'LS93', 'NL32-04', NULL, 'LEUKERBAD', 'Leukerbad', 'Leukerbad', '01010000201555000098F6538383C42241A56E48233BB60041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515277, 'NT06', 'NL32-02', NULL, 'LEUTMERKEN', 'Leutmerken', 'Leutmerken', '010100002015550000B532BC7D15032641C6E5F810DF581041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515278, 'MT34', 'NL32-02', NULL, 'LEUTWIL', 'Leutwil', 'Leutwil', '0101000020155500003EE3B63B89FD2341C8CE4AB915680D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515279, 'LT82', 'NL32-01', NULL, 'LEUZIGEN', 'Leuzigen', 'Leuzigen', '01010000201555000054A9A25E3C562241718E0184F9560B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515280, 'KS85', 'NL32-04', NULL, 'LEVAUD', 'Le Vaud', 'Le Vaud', '010100002015550000A4B38655E4F81E412065CC3A50270241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515282, 'LS90', 'NL32-04', NULL, 'LEVICHIESSO', 'Le Vichiesso', 'Le Vichiesso', '0101000020155500003F9C6F341FC52241CBDABA6FE9BBF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515283, 'LS43', 'NL32-04', NULL, 'LEYSIN', 'Leysin', 'Leysin', '010100002015550000C1ACB153BA5121418A354F369A440041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515284, 'LS61', 'NL32-04', NULL, 'LEYTRON', 'Leytron', 'Leytron', '01010000201555000004E0A8308ABF2141FF448EBC82FFFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515286, 'NT04', 'NL32-02', NULL, 'LICHTENSTEIG', 'Lichtensteig', 'Lichtensteig', '010100002015550000FDC967DEA01A26411EC32F0BB9C20D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515287, 'LR59', 'NL32-04', NULL, 'LIDDES', 'Liddes', 'Liddes', '0101000020155500009D82CF25F7B421418194682EFD05F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515288, 'LS89', 'NL32-04', NULL, 'LIEBEFELD', 'Liebefeld', 'Liebefeld', '010100002015550000EFF990E2584C2241AC848667562C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515289, 'LS69', 'NL32-04', NULL, 'LIEBISTORF', 'Liebistorf', 'Liebistorf', '010100002015550000CB7AEF6B7CC121412B267DAF4EF30741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515290, 'MT42', 'NL32-02', NULL, 'LIELI', 'Lieli', 'Lieli', '01010000201555000046415EE6664D2441865D12EFF5D50B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515291, 'NT43', 'NL32-02', NULL, 'LIENZ', 'Lienz', 'Lienz', '01010000201555000011A3BDF36F2527414F780B76652E0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515292, 'LT85', 'NL32-01', NULL, 'LIESBERG', 'Liesberg', 'Liesberg', '010100002015550000FFE64829614C224184B03CA5A7810E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515293, 'MT05', 'NL32-01', 3, 'LIESTAL', 'Liestal', 'Liestal', '0101000020155500000FEEA12717FD2241AB33079A956A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515295, 'LT51', 'NL32-01', NULL, 'LIGERZ', 'Ligerz', 'Ligerz', '01010000201555000060D1EDDB43A42141CFDF477EB9360A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515296, 'LT51', 'NL32-01', NULL, 'LIGNIERES', 'Lignières', 'Lignieres', '010100002015550000D5898291D37221419FBBC3628F370A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515297, 'MR97', 'NL32-08', NULL, 'LIGORNETTO', 'Ligornetto', 'Ligornetto', '010100002015550000878B90F672E425414FC8F02A30ACF340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515300, 'MT75', 'NL32-02', NULL, 'LINDAU', 'Lindau', 'Lindau', '010100002015550000854576D40A23254116152F9902460F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515302, 'LS98', 'NL32-04', NULL, 'LINDEN', 'Linden', 'Linden', '010100002015550000DACF20004EE12241916F095DBC0B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515305, 'LT50', 'NL32-04', NULL, 'LINDENHOF', 'Lindenhof', 'Lindenhof', '010100002015550000D8FEE8CF6972214137DB756626DC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515306, 'LT80', 'NL32-04', NULL, 'LINDENTHAL', 'Lindenthal', 'Lindenthal', '010100002015550000F03E16D4B19122410E3038EF39DA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515309, 'NS09', 'NL32-05', NULL, 'LINTHAL', 'Linthal', 'Linthal', '01010000201555000084F3BCD5A1F02541CE9F4FD965170841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515315, 'MS89', 'NL32-05', NULL, 'LIPPLISBUHL', 'Lipplisbühl', 'Lipplisbuhl', '010100002015550000F4C6F9ECA25B254196B72D7665460841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515317, 'LS06', 'NL32-04', NULL, 'LISLE', 'L’Isle', 'L’Isle', '010100002015550000BE22B534DCD71F412D878DDB35F00341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515318, 'MT41', 'NL32-02', NULL, 'LITTAU', 'Littau', 'Littau', '010100002015550000CCB919C426312441EF5AF87D98CB0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515319, 'LT90', 'NL32-04', NULL, 'LITTEWIL', 'Littewil', 'Littewil', '0101000020155500005B5FF66B8FA5224199E35A488D660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515321, 'NS53', 'NL32-05', NULL, 'LOBBIA', 'Löbbia', 'Lobbia', '010100002015550000CAA208BA698A2741E85DAE88B1010141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515322, 'MS81', 'NL32-05', 4, 'LOCARNO', 'Locarno', 'Locarno', '010100002015550000CB8B4F6FEE8425419C7C2B46EDC2FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515325, 'MS45', 'NL32-05', NULL, 'LOCH', 'Loch', 'Loch', '010100002015550000A62B5C1CE85D24416EB30B1B9C900241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515326, 'MS66', 'NL32-05', NULL, 'LOCH', 'Loch', 'Loch', '010100002015550000BA7C32BE0C062541B64F3C2894680441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515327, 'MS71', 'NL32-05', NULL, 'LOCO', 'Loco', 'Loco', '0101000020155500009705006F083425413C6ADE34DF9FFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515328, 'MS72', 'NL32-05', NULL, 'LODANO', 'Lodano', 'Lodano', '0101000020155500002AD713C8643D2541D6F6FCA17CFCFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515329, 'MS92', 'NL32-05', NULL, 'LODRINO', 'Lodrino', 'Lodrino', '01010000201555000015C5C9B63AE725413FC5017CF16FFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515330, 'MS38', 'NL32-05', NULL, 'LOHALP', 'Lohalp', 'Lohalp', '0101000020155500009D1E6A65A4CF2341302540B621110741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515331, 'NS36', 'NL32-05', NULL, 'LOHN', 'Lohn', 'Lohn', '010100002015550000D82A19635FEE2641E8E96F4DAA8F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515332, 'MT78', 'NL32-02', NULL, 'LOHN', 'Lohn', 'Lohn', '01010000201555000089F6F1B3F61E254136D24FD625AC1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515334, 'MT96', 'NL32-02', NULL, 'LOMMIS', 'Lommis', 'Lommis', '0101000020155500003AD31F8D74DC254166255F22651D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515336, 'KS85', 'NL32-04', NULL, 'LONGIROD', 'Longirod', 'Longirod', '01010000201555000071600106E30C1F415C523BCDB3260241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515344, 'MS80', 'NL32-05', NULL, 'LOSONE', 'Losone', 'Losone', '010100002015550000A7C26A9E3F6725419B58478F40D7FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515345, 'NS12', 'NL32-05', NULL, 'LOSTALLO', 'Lostallo', 'Lostallo', '010100002015550000E242ECF9A673264160D273C47F87FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515346, 'MT24', 'NL32-01', NULL, 'LOSTORF', 'Lostorf', 'Lostorf', '010100002015550000B1F6F5762E7D2341C88F8BCDAA4B0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515353, 'MS94', 'NL32-05', NULL, 'LOTTIGNA', 'Lottigna', 'Lottigna', '010100002015550000D466BB1369DA2541040A7A3812FA0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515354, 'MT02', 'NL32-01', NULL, 'LOTZWIL', 'Lotzwil', 'Lotzwil', '0101000020155500001F0336CE9E1B234112C4566FA9920B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515355, 'LS60', 'NL32-04', NULL, 'LOURTIER', 'Lourtier', 'Lourtier', '0101000020155500005FDC5D0E80E72141C3F1C8F94760F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515356, 'MS83', 'NL32-05', NULL, 'LOVALD', 'Lovald', 'Lovald', '010100002015550000E7FB988DDC63254140E718DC17960041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515360, 'PS06', 'NL32-06', NULL, 'LU', 'Lü', 'Lu', '0101000020155500009480F0C2CB262941F4DE6F03DD9C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515365, 'LS37', 'NL32-04', NULL, 'LUCENS', 'Lucens', 'Lucens', '010100002015550000741EBFEFEFE52041B84BD9B03B410541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515374, 'NT00', 'NL32-05', NULL, 'LUCHSINGEN', 'Luchsingen', 'Luchsingen', '01010000201555000096CA102A950326417CDDF76EA9C60841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515375, 'MS94', 'NL32-05', NULL, 'LUDIANO', 'Ludiano', 'Ludiano', '0101000020155500005165A28741E5254172B9AF062F4D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515378, 'MR99', 'NL32-05', 3, 'LUGANO', 'Lugano', 'Lugano', '010100002015550000AC407ED44DEC2541FB0783D7FA4BF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515383, 'LS39', 'NL32-04', NULL, 'LULLY', 'Lully', 'Lully', '0101000020155500008C312229D5E620412A058D4D6B100741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515384, 'NS16', 'NL32-05', NULL, 'LUMBREIN', 'Lumbrein', 'Lumbrein', '01010000201555000001C4904D574426412A329F4492F30441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515386, 'NS01', 'NL32-05', NULL, 'LUMINO', 'Lumino', 'Lumino', '0101000020155500002AE14ADEE9242641B7CA24FCC436FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515389, 'MS38', 'NL32-05', NULL, 'LUNGERN', 'Lungern', 'Lungern', '010100002015550000B1DD968FB2012441F2D791B42C650641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515394, 'NS16', 'NL32-05', NULL, 'LUNSCHANIA', 'Lunschania', 'Lunschania', '010100002015550000E8836215945826413C9D09BC6CBB0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515395, 'LS69', 'NL32-04', NULL, 'LURTIGEN', 'Lurtigen', 'Lurtigen', '01010000201555000002489E22A6AD2141161B961391F30741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515397, 'MT51', 'NL32-02', NULL, 'LUTERBACH', 'Luterbach', 'Luterbach', '010100002015550000D63ACD7B7FA7244102C094E4E7440A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515398, 'LT93', 'NL32-01', NULL, 'LUTERBACH', 'Luterbach', 'Luterbach', '0101000020155500004BEF10B622A52241B6146F84FF040C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515399, 'MT11', 'NL32-01', NULL, 'LUTHERN', 'Luthern', 'Luthern', '010100002015550000B3920FD3306B2341F559809DFFFE0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515400, 'NT04', 'NL32-02', NULL, 'LUTISBURG', 'Lütisburg', 'Lutisburg', '010100002015550000D8B1791B6A192641F2674B0E4DAA0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515403, 'LS25', 'NL32-04', NULL, 'LUTRY', 'Lutry', 'Lutry', '010100002015550000D5537659A8942041C97DBFB1358D0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515405, 'MS27', 'NL32-05', NULL, 'LUTSCHENTAL', 'Lütschental', 'Lutschental', '010100002015550000B5A74744D6B223416E8F72571B070541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515406, 'MS16', 'NL32-04', NULL, 'LUTSCHENTHAL', 'Lütschenthal', 'Lutschenthal', '010100002015550000DBBAC695737723413EBE9B4EDB1D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515410, 'LT90', 'NL32-01', NULL, 'LUTZELFLUH', 'Lützelflüh', 'Lutzelfluh', '0101000020155500004A150ACBDAE022413FF5F4F0BE4E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515412, 'NS17', 'NL32-05', NULL, 'LUVIS', 'Luvis', 'Luvis', '0101000020155500000F2337009C60264198410F2B9E170641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515413, 'NS59', 'NL32-05', NULL, 'LUZEIN', 'Luzein', 'Luzein', '010100002015550000962EBAB5D4AE274191781F1C76430841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515415, 'MT41', 'NL32-02', 2, 'LUZERN', 'Luzern', 'Luzern', '01010000201555000074D2B34EBD3A2441134D06CECE3F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515419, 'NT30', 'NL32-02', NULL, 'LUZIENSTEIG', 'Luziensteig', 'Luziensteig', '0101000020155500006D85BD5D57212741EDC2EFD017C90941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515420, 'LT71', 'NL32-01', NULL, 'LYSS', 'Lyss', 'Lyss', '010100002015550000600579B53AFD2141E695450BD9FB0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515421, 'LT91', 'NL32-01', NULL, 'LYSSACH', 'Lyssach', 'Lyssach', '010100002015550000979C82DC5FA52241EC72829DDDFB0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515425, 'MT02', 'NL32-01', NULL, 'MADISWIL', 'Madiswil', 'Madiswil', '010100002015550000F35EA60DAF1B23411843072DC2580B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515431, 'NS04', 'NL32-05', NULL, 'MADRA', 'Madra', 'Madra', '010100002015550000CD1FD5C8001726419C2C6D52138B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515434, 'NS75', 'NL32-05', NULL, 'MADULEIN', 'Madulein', 'Madulein', '0101000020155500000E15F9DC16252841DDB5D4516BCB0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515435, 'MS81', 'NL32-05', NULL, 'MAGADINO', 'Magadino', 'Magadino', '01010000201555000074FAD6AA6AAD25417DBA3B89DE54FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515437, 'MT06', 'NL32-01', NULL, 'MAGDEN', 'Magden', 'Magden', '0101000020155500005192BC911724234135CE5B1370291041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515438, 'NT14', 'NL32-02', NULL, 'MAGDENAU', 'Magdenau', 'Magdenau', '010100002015550000003187CB8C4A264186B3EAC986AE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515441, 'MS72', 'NL32-05', NULL, 'MAGGIA', 'Maggia', 'Maggia', '0101000020155500007D14921F6F472541B323610FC5FDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515450, 'LT62', 'NL32-01', NULL, 'MAGGLINGEN', 'Magglingen', 'Magglingen', '01010000201555000000B45A15FBCB2141580D74F3D11D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515451, 'MR89', 'NL32-08', NULL, 'MAGLIASINA', 'Magliasina', 'Magliasina', '010100002015550000B1FF259E50B02541C10021054C5BF640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515454, 'LS61', 'NL32-04', NULL, 'MAGNOT', 'Magnot', 'Magnot', '0101000020155500001EA1A3C8D1E721417781426242E6FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515455, 'NT40', 'NL32-02', NULL, 'MAIENFELD', 'Maienfeld', 'Maienfeld', '01010000201555000096F5880B9F2B2741A51A4BB143900941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515457, 'MT16', 'NL32-01', NULL, 'MAISPRACH', 'Maisprach', 'Maisprach', '0101000020155500005EAB0124C6372341F68522FDAB0C1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515459, 'NS48', 'NL32-05', NULL, 'MALADERS', 'Maladers', 'Maladers', '010100002015550000EE8B3C8DCD39274196C301B9A4140741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515460, 'NT40', 'NL32-05', NULL, 'MALANS', 'Malans', 'Malans', '0101000020155500001E155FA0974027411D05DA11C1E40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515462, 'NS48', 'NL32-05', NULL, 'MALIX', 'Malix', 'Malix', '0101000020155500009928F63CA530274115D535C2D19F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515463, 'LT63', 'NL32-01', NULL, 'MALLERAY', 'Malleray', 'Malleray', '01010000201555000097219951C4E921419C2D0EC60A3F0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515464, 'NS45', 'NL32-05', NULL, 'MALMIGIUER', 'Malmigiuer', 'Malmigiuer', '0101000020155500005E41CB619F4927415F7C6A878BB10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515468, 'NS53', 'NL32-05', NULL, 'MALOJA', 'Maloja', 'Maloja', '01010000201555000035562B86059E2741B30CFE56DC3D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515471, 'MT30', 'NL32-02', NULL, 'MALTERS', 'Malters', 'Malters', '0101000020155500008389AAFBB60924415657577420900941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515472, 'MS93', 'NL32-05', NULL, 'MALVAGLIA', 'Malvaglia', 'Malvaglia', '01010000201555000085DA41C58CEF254103CE199E14140141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515473, 'MT97', 'NL32-02', NULL, 'MAMMERN', 'Mammern', 'Mammern', '01010000201555000066ACF9A30CB325417C9977FF7C031141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515474, 'PS08', 'NL32-06', NULL, 'MANAS', 'Manas', 'Manas', '0101000020155500003A577511C61F29417BF1279D088D0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515475, 'MT73', 'NL32-02', NULL, 'MANNEDORF', 'Männedorf', 'Mannedorf', '01010000201555000024C553E99D2F254139C9E54CD58F0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515476, 'LS48', 'NL32-04', NULL, 'MANNENS', 'Mannens', 'Mannens', '01010000201555000087183D1D0436214174B945CC88600641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515478, 'MR99', 'NL32-05', NULL, 'MANNO', 'Manno', 'Manno', '010100002015550000685AAFBC6BC3254122E45B07632DF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515479, 'LS75', 'NL32-04', NULL, 'MANNRIED', 'Mannried', 'Mannried', '010100002015550000164E13495F2E2241983966BC96320341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515480, 'LS35', 'NL32-04', NULL, 'MARACON', 'Maracon', 'Maracon', '010100002015550000D6098340CAF82041E815588FA8FD0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515481, 'MS18', 'NL32-04', NULL, 'MARBACH', 'Marbach', 'Marbach', '010100002015550000D3095B6B79582341E2B17365D30D0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515484, 'KS85', 'NL32-04', NULL, 'MARCHISSY', 'Marchissy', 'Marchissy', '010100002015550000A4B38655E4F81E412065CC3A50270241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515486, 'LT85', 'NL32-01', NULL, 'MARIASTEIN', 'Mariastein', 'Mariastein', '0101000020155500009CCC7C29787D22411C5A938B60690F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515487, 'LT40', 'NL32-01', NULL, 'MARIN', 'Marin', 'Marin', '0101000020155500000654B176F34A214159E4AC0AC6500941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515491, 'LS58', 'NL32-04', NULL, 'MARLYLEGRAND', 'Marly-le-Grand', 'Marly-le-Grand', '01010000201555000076AF73CE3FA32141080BD4C99BEA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515493, 'NS44', 'NL32-05', NULL, 'MARMORERA', 'Marmorera', 'Marmorera', '0101000020155500006369AFB4F37D2741BA397AD1CF5B0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515494, 'MR98', 'NL32-08', NULL, 'MAROGGIA', 'Maroggia', 'Maroggia', '0101000020155500007C054FA1D0F7254192FF85ABAC0AF540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515495, 'LS56', 'NL32-04', NULL, 'MARSENS', 'Marsens', 'Marsens', '010100002015550000EB913D4E097121414B1B6E2E28560441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515496, 'NT07', 'NL32-02', NULL, 'MARSTETTEN', 'Märstetten', 'Marstetten', '01010000201555000084C3E874FB0B2641652FB6D11FB01041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515498, 'MT77', 'NL32-02', NULL, 'MARTHALEN', 'Marthalen', 'Marthalen', '0101000020155500000C1C5601FD1625416CA3C99F37C41041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515501, 'LS50', 'NL32-04', NULL, 'MARTIGNYBOURG', 'Martigny-Bourg', 'Martigny-Bourg', '010100002015550000A184638CC47821416DEE877EDE4AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515502, 'LS50', 'NL32-04', NULL, 'MARTIGNYCOMBE', 'Martigny-Combe', 'Martigny-Combe', '010100002015550000A184638CC47821416DEE877EDE4AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515503, 'LS50', 'NL32-04', NULL, 'MARTIGNYCROIX', 'Martigny-Croix', 'Martigny-Croix', '0101000020155500007EE51213D782214188DDB4F2824AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515504, 'LS50', 'NL32-04', NULL, 'MARTIGNYVILLE', 'Martigny-Ville', 'Martigny-Ville', '010100002015550000159B1463D5782141D423B5A3AABEF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515506, 'PS19', 'NL32-06', NULL, 'MARTINSBRUCK', 'Martinsbruck', 'Martinsbruck', '01010000201555000072CD71E7325A2941724FBB66CB090841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515507, 'NT06', 'NL32-02', NULL, 'MARWIL', 'Märwil', 'Marwil', '010100002015550000383799404A172641E20B418CC91F1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515508, 'LT80', 'NL32-04', NULL, 'MARZILI', 'Marzili', 'Marzili', '0101000020155500005D37302E594C2241C9264C2D3D660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515509, 'NS49', 'NL32-05', NULL, 'MASANS', 'Masans', 'Masans', '01010000201555000045CDB68DB62E2741F28F57CC37C10741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515510, 'NS57', 'NL32-05', NULL, 'MASCHENBODEN', 'Mäschenboden', 'Maschenboden', '010100002015550000DA9B4932B7C8274154010AAC931B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515511, 'MT53', 'NL32-02', NULL, 'MASCHWANDEN', 'Maschwanden', 'Maschwanden', '010100002015550000BBD1BBB219922441F46A418BFF4C0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515512, 'LS71', 'NL32-04', NULL, 'MASE', 'Mase', 'Mase', '0101000020155500005DDCD59A4B4C22412B713CCEBEFDFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515514, 'MR99', 'NL32-05', NULL, 'MASSAGNO', 'Massagno', 'Massagno', '01010000201555000041165971F0E12541D27080BA31BEF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515515, 'NT40', 'NL32-05', NULL, 'MASTRILS', 'Mastrils', 'Mastrils', '010100002015550000B1EBE1DCC72C2741F1DBB5EA9EE20841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515516, 'LS52', 'NL32-04', NULL, 'MATELON', 'Matélon', 'Matelon', '0101000020155500004C572CA187832141348F257B4644FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515517, 'NS36', 'NL32-05', NULL, 'MATHON', 'Mathon', 'Mathon', '0101000020155500000F07FF10C5E42641893B707EC8540441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515518, 'NT10', 'NL32-05', NULL, 'MATT', 'Matt', 'Matt', '010100002015550000263976FCD65226413410B25E60CD0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515519, 'LT80', 'NL32-04', NULL, 'MATTE', 'Matte', 'Matte', '0101000020155500006047EDC442562241845158723D660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515520, 'MS65', 'NL32-05', NULL, 'MATTELI', 'Mätteli', 'Matteli', '010100002015550000CB5BB983FDDE244120E86D6EB67E0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515521, 'LS74', 'NL32-04', NULL, 'MATTEN', 'Matten', 'Matten', '010100002015550000F456B94851422241436719010E110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515522, 'MS16', 'NL32-04', NULL, 'MATTEN', 'Matten', 'Matten', '0101000020155500005C1C0C33694F234107C48B76B7900441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515524, 'LS89', 'NL32-04', NULL, 'MATTENHOF', 'Mattenhof', 'Mattenhof', '01010000201555000084B4F296584C22412AC740C36FF20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515533, 'LT93', 'NL32-01', NULL, 'MATZENDORF', 'Matzendorf', 'Matzendorf', '010100002015550000B31F7AD1B2B82241125A6584AF260D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515534, 'LS79', 'NL32-04', NULL, 'MATZENRIED', 'Matzenried', 'Matzenried', '010100002015550000B18A98A3D51022416451C67B9BF20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515535, 'MT96', 'NL32-02', NULL, 'MATZINGEN', 'Matzingen', 'Matzingen', '0101000020155500006FD3FF8E09BF254198367955411C1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515536, 'LS19', 'NL32-04', NULL, 'MAUBORGET', 'Mauborget', 'Mauborget', '010100002015550000ABE1F469E3652041D0F348EF054F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515538, 'MT22', 'NL32-02', NULL, 'MAUENSEE', 'Mauensee', 'Mauensee', '0101000020155500002EDD660B83C3234191EC6732EA5C0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515539, 'MT74', 'NL32-02', NULL, 'MAUR', 'Maur', 'Maur', '0101000020155500008A043AD6A0242541076856C2B4B00D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515540, 'MS07', 'NL32-04', NULL, 'MAUREN', 'Mauren', 'Mauren', '010100002015550000F70AB35A6B272341CF5D8099B6030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515541, 'LR79', 'NL32-04', NULL, 'MAUVOISIN', 'Mauvoisin', 'Mauvoisin', '0101000020155500004E52EE73C10F2241A450AD4E4F04F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515545, 'LS91', 'NL32-04', NULL, 'MAYOUX', 'Mayoux', 'Mayoux', '010100002015550000BC065361BAA622416A91CBB5F9E5FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515547, 'MS90', 'NL32-05', NULL, 'MEDEGLIA', 'Medeglia', 'Medeglia', '01010000201555000085B1259F33D6254176DDAD045073FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515551, 'MS86', 'NL32-05', NULL, 'MEDELS', 'Medels', 'Medels', '010100002015550000C5A5EB56499B25419E66D0F945AC0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515554, 'NS25', 'NL32-05', NULL, 'MEDELSIMRHEINWALD', 'Medels im Rheinwald', 'Medels im Rheinwald', '0101000020155500005A9DF84209A1264156B869E8B6F20241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515556, 'NS58', 'NL32-05', NULL, 'MEDERGEN', 'Medergen', 'Medergen', '010100002015550000FE538652E1A72741C27848962AAD0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515557, 'MT51', 'NL32-02', NULL, 'MEGGEN', 'Meggen', 'Meggen', '010100002015550000BB5019594C8024411FCA1A2B23CF0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515561, 'NS07', 'NL32-05', NULL, 'MEIERHOF', 'Meierhof', 'Meierhof', '0101000020155500005C67993D322F26412B57ABBA69D90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515562, 'MT51', 'NL32-02', NULL, 'MEIERSKAPPEL', 'Meierskappel', 'Meierskappel', '01010000201555000015E06A773E9D24413EE41D9332B80A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515563, 'MT73', 'NL32-02', NULL, 'MEILEN', 'Meilen', 'Meilen', '0101000020155500006D4117C49B1125418A5487CACA010D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48736, 'KS82', 'NL32-04', NULL, 'MEINIER', 'Meinier', 'Meinier', '01010000201555000078D3D91236F21E4187B1FD9DE085FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515565, 'LT72', 'NL32-01', NULL, 'MEINISBERG', 'Meinisberg', 'Meinisberg', '010100002015550000CE94CD50001B224108675A2418570B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515566, 'MS37', 'NL32-05', NULL, 'MEIRINGEN', 'Meiringen', 'Meiringen', '010100002015550000E468C5B72F0C2441382E2E5EF57D0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515567, 'MT43', 'NL32-02', NULL, 'MEISTERSCHWANDEN', 'Meisterschwanden', 'Meisterschwanden', '010100002015550000018F8D470F252441A6C5278FB52F0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515570, 'NR08', 'NL32-08', NULL, 'MELANO', 'Melano', 'Melano', '0101000020155500001AF73CCAA001264159D4B4250D80F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515571, 'MT12', 'NL32-01', NULL, 'MELCHNAU', 'Melchnau', 'Melchnau', '01010000201555000051A4F6623A392341FA4DD10738930B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515572, 'MS48', 'NL32-05', NULL, 'MELCHTAL', 'Melchtal', 'Melchtal', '01010000201555000033D766BBCE462441CD8CC44CA7150741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515574, 'NS01', 'NL32-05', NULL, 'MELERA', 'Melera', 'Melera', '0101000020155500007B279496DE2F26415460827321DDFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515580, 'MR98', 'NL32-08', NULL, 'MELIDE', 'Melide', 'Melide', '01010000201555000085CB93000EE32541068BAB2815EFF540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515581, 'MT45', 'NL32-02', NULL, 'MELLINGEN', 'Mellingen', 'Mellingen', '0101000020155500002226DA6FAF372441649C28B4D9C50E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515582, 'NT31', 'NL32-02', NULL, 'MELS', 'Mels', 'Mels', '01010000201555000015CD01259DE52641E6443F53D6FC0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515583, 'MR97', 'NL32-08', NULL, 'MENDRISIO', 'Mendrisio', 'Mendrisio', '0101000020155500003677A888ABF82541A6417FFC56AFF340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515586, 'MT33', 'NL32-02', NULL, 'MENZIKEN', 'Menziken', 'Menziken', '0101000020155500004F4063FCED072441A872F765D7800C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515587, 'MT62', 'NL32-02', NULL, 'MENZINGEN', 'Menzingen', 'Menzingen', '010100002015550000F6176B7953F524415419CC0DA3A40B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515588, 'MT21', 'NL32-02', NULL, 'MENZNAU', 'Menznau', 'Menznau', '010100002015550000EB4258D250B0234167E32F69CA3A0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515593, 'LS82', 'NL32-04', NULL, 'MERDESSONNET', 'Merdessonnet', 'Merdessonnet', '010100002015550000A4A3C921626022412EFCD6EEF4CCFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515594, 'MT53', 'NL32-02', NULL, 'MERENSCHWAND', 'Merenschwand', 'Merenschwand', '010100002015550000848649DC59742441DD469F6F76850C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515595, 'MS81', 'NL32-05', NULL, 'MERGOSCIA', 'Mergoscia', 'Mergoscia', '010100002015550000672919B793A225414B2875C2BFAEFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515596, 'MR98', 'NL32-08', NULL, 'MERIDE', 'Meride', 'Meride', '010100002015550000059D5D2DE4E32541C5D76922BF93F440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515597, 'MT78', 'NL32-02', NULL, 'MERISHAUSEN', 'Merishausen', 'Merishausen', '0101000020155500000CE5C9C6E8F72441C2650A58F5AA1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515598, 'MS07', 'NL32-04', NULL, 'MERLIGEN', 'Merligen', 'Merligen', '0101000020155500003C440CD795FF22410CA3186D0C030541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515600, 'LT84', 'NL32-01', NULL, 'MERVELIER', 'Mervelier', 'Mervelier', '0101000020155500002945E94DE46922410D95670EF6D30D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515603, 'NS13', 'NL32-05', NULL, 'MESOCCO', 'Mesocco', 'Mesocco', '0101000020155500009A6E60680E862641AFDA9304FCE60041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515606, 'LT81', 'NL32-01', NULL, 'MESSEN', 'Messen', 'Messen', '010100002015550000D210B2D43E56224159F8B10475350A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515607, 'LS95', 'NL32-04', NULL, 'METSCH', 'Metsch', 'Metsch', '0101000020155500007B7EC09244BA22419410F8DA6C4B0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515608, 'MT96', 'NL32-02', NULL, 'METTENDORF', 'Mettendorf', 'Mettendorf', '01010000201555000020DBB4B0CDD12541BC9FA83EDC731041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515609, 'NT06', 'NL32-02', NULL, 'METTLEN', 'Mettlen', 'Mettlen', '010100002015550000B0B08E78972A2641FF5E9F02913D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515610, 'MT53', 'NL32-02', NULL, 'METTMENSTETTEN', 'Mettmenstetten', 'Mettmenstetten', '01010000201555000018E4421C7DAF24415D8B7F2569880C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515611, 'LT85', 'NL32-01', NULL, 'METZERLEN', 'Metzerlen', 'Metzerlen', '01010000201555000091E049F5056022411E979DD2632F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515612, 'LS41', 'NL32-04', NULL, 'MEX', 'Mex', 'Mex', '010100002015550000C12E2A4EC13C2141BD60E6095B90FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515613, 'KS72', 'NL32-04', NULL, 'MEYRIN', 'Meyrin', 'Meyrin', '0101000020155500000FEFE23BD6281E41CB54EECB501FFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515614, 'LS47', 'NL32-04', NULL, 'MEZIERES', 'Mézières', 'Mezieres', '0101000020155500009B30725E7B2121411FA10EC7BDCB0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515615, 'MS90', 'NL32-05', NULL, 'MEZZOVICO', 'Mezzovico', 'Mezzovico', '0101000020155500004B2902C1AECC2541CFA954403B8AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515618, 'LT65', 'NL32-01', NULL, 'MIECOURT', 'Miécourt', 'Miecourt', '010100002015550000464C85C108B921413FF1C52675F60E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515619, 'LS83', 'NL32-04', NULL, 'MIEGE', 'Miège', 'Miege', '0101000020155500005ED34B968292224119C5175C7F9CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515620, 'LS41', 'NL32-04', NULL, 'MIEVILLE', 'Miéville', 'Mieville', '0101000020155500005185F7CED95A21416190953D3B1BFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515621, 'MR89', 'NL32-05', NULL, 'MIGLIEGLIA', 'Miglieglia', 'Miglieglia', '0101000020155500000C6440FD70A52541FEA88F5C2DB5F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515622, 'LS93', 'NL32-04', NULL, 'MILIUT', 'Miliüt', 'Miliut', '01010000201555000075D483E78FBA2241D7F873F256420041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515623, 'MS81', 'NL32-05', NULL, 'MINUSIO', 'Minusio', 'Minusio', '0101000020155500003C9BAC90BB8E254124D626501C38FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515625, 'NS82', 'NL32-06', NULL, 'MIRALAGO', 'Miralago', 'Miralago', '01010000201555000057F369A9AC9128419F375926EF8DFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515630, 'LS95', 'NL32-04', NULL, 'MITHOLZ', 'Mitholz', 'Mitholz', '01010000201555000022A31D5F36D8224180DCFC07A2850241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515632, 'MS38', 'NL32-05', NULL, 'MITTELARNI', 'Mittel Arni', 'Mittel Arni', '0101000020155500008CBB49ACFFCF234143EA22CA6F630641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515636, 'MS03', 'NL32-04', NULL, 'MITTHAL', 'Mitthal', 'Mitthal', '010100002015550000F8A36701CE0A23418BF1565070090041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515639, 'NT60', 'NL32-02', NULL, 'MITTLERSASS', 'Mittlersass', 'Mittlersass', '0101000020155500006241273F31DE274153EB4D88C86A0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515641, 'NT04', 'NL32-02', NULL, 'MOGELSBERG', 'Mogelsberg', 'Mogelsberg', '01010000201555000093068227B02D2641726F737C2D380E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515642, 'MS72', 'NL32-05', NULL, 'MOGHEGNO', 'Moghegno', 'Moghegno', '010100002015550000C24D90909F3D254129A0D23CB488FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515643, 'MS74', 'NL32-05', NULL, 'MOGNO', 'Mogno', 'Mogno', '010100002015550000E271D582DC3025417D4B175B6A7A0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515644, 'MT16', 'NL32-01', NULL, 'MOHLIN', 'Möhlin', 'Mohlin', '0101000020155500002F0F9D1B6E41234194D9DA90AE461041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515647, 'MS38', 'NL32-05', NULL, 'MOHRLIALP', 'Möhrlialp', 'Mohrlialp', '0101000020155500008668BAD8A0E3234163900B0BE7D70641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515651, 'MS92', 'NL32-05', NULL, 'MOLENO', 'Moleno', 'Moleno', '01010000201555000096071A6DD4F12541837B9F61F789FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515655, 'KS96', 'NL32-04', NULL, 'MOLLENS', 'Mollens', 'Mollens', '0101000020155500009A3AEFB83A9B1F41A00483D4057E0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515656, 'LS46', 'NL32-04', NULL, 'MOLLETTES', 'Mollettes', 'Mollettes', '010100002015550000126C9E200E532141602F2F99DD1C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515657, 'NT01', 'NL32-02', NULL, 'MOLLIS', 'Mollis', 'Mollis', '01010000201555000033C3FE272E1F2641BB9CD0D2575E0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515658, 'NT21', 'NL32-02', NULL, 'MOLS', 'Mols', 'Mols', '010100002015550000100CD4E4769526412A1A88D3C8A20A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515659, 'MS86', 'NL32-05', NULL, 'MOMPETAVETSCH', 'Mompetavetsch', 'Mompetavetsch', '010100002015550000DF490DE7109125412A574D5273E50441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515662, 'NS69', 'NL32-05', NULL, 'MONBIEL', 'Monbiel', 'Monbiel', '010100002015550000D907C9945713284156F89986F4A10741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515664, 'MT74', 'NL32-02', NULL, 'MONCHALTORF', 'Mönchaltorf', 'Monchaltorf', '0101000020155500005DAA40A26242254148792B85B1780D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515665, 'NS46', 'NL32-05', NULL, 'MONS', 'Mons', 'Mons', '0101000020155500001C545582163E27419CB45370FA970441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515666, 'NS57', 'NL32-05', NULL, 'MONSTEIN', 'Monstein', 'Monstein', '010100002015550000A915293354BE27419E3BED9D43540541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515667, 'LS15', 'NL32-04', NULL, 'MONTAGIBERT', 'Montagibert', 'Montagibert', '0101000020155500008CA9A9B0D66C20415A741B67AEC80241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515668, 'MR99', 'NL32-08', NULL, 'MONTAGNOLA', 'Montagnola', 'Montagnola', '010100002015550000238646A251CE25411FA9ABF78FD3F640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515669, 'LS51', 'NL32-04', NULL, 'MONTAGNON', 'Montagnon', 'Montagnon', '010100002015550000EE6C51956EAB214147C25D560900FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515670, 'LS18', 'NL32-04', NULL, 'MONTAGNY', 'Montagny', 'Montagny', '01010000201555000081B60BF320652041F3F8C792892D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515672, 'LS48', 'NL32-04', NULL, 'MONTAGNYLAVILLE', 'Montagny-la-Ville', 'Montagny-la-Ville', '010100002015550000D936F14B0A4021411879A4B4329A0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515673, 'LS82', 'NL32-04', NULL, 'MONTANA', 'Montana', 'Montana', '010100002015550000A6C9464A5E6022414C18ED2B5928FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515675, 'LS82', 'NL32-04', NULL, 'MONTANAVILLAGE', 'Montana-Village', 'Montana-Village', '01010000201555000004CC1EE56E7422410DE4DC1B7028FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515680, 'LS54', 'NL32-04', NULL, 'MONTBOVON', 'Montbovon', 'Montbovon', '01010000201555000067B3B1705966214123CFBB8C5E130241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515682, 'LS17', 'NL32-04', NULL, 'MONTCHERAND', 'Montcherand', 'Montcherand', '01010000201555000088FF9E46F6282041462090C081820541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515683, 'MS75', 'NL32-05', NULL, 'MONTE', 'Monte', 'Monte', '0101000020155500004E45F92F4E1B2541CBA61E326C0E0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515688, 'NS01', 'NL32-05', NULL, 'MONTECARASSO', 'Monte Carasso', 'Monte Carasso', '010100002015550000645FC9884EFD254181A1C648AF48FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515690, 'MS90', 'NL32-05', NULL, 'MONTECENERI', 'Monte Ceneri', 'Monte Ceneri', '010100002015550000FF0DA8D9BDB725416E82B88090E2FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515699, 'LT53', 'NL32-01', NULL, 'MONTFAUCON', 'Montfaucon', 'Montfaucon', '010100002015550000AEA94417A77321411E9E7C5F67EE0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515700, 'LS42', 'NL32-04', NULL, 'MONTHEY', 'Monthey', 'Monthey', '010100002015550000F063F1E31729214143AA835D4DD4FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515703, 'MS81', 'NL32-05', NULL, 'MONTIDELLATRINITA', 'Monti della Trinità', 'Monti della Trinita', '010100002015550000DE2DDD35E07A254172D231128AC1FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515704, 'NS01', 'NL32-05', NULL, 'MONTIDICO', 'Monti di Cò', 'Monti di Co', '0101000020155500006CFA2938432F2641D8A43195ACC4FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515705, 'NS11', 'NL32-05', NULL, 'MONTIDILANES', 'Monti di Lanés', 'Monti di Lanes', '010100002015550000695869C12F6126419666C6E01541FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515707, 'MS91', 'NL32-05', NULL, 'MONTIDIODRO', 'Monti di Odro', 'Monti di Odro', '010100002015550000C7072B7124B62541F11C63253B99FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515708, 'MS90', 'NL32-05', NULL, 'MONTIDIPIANTURINO', 'Monti di Pianturino', 'Monti di Pianturino', '010100002015550000A2F663BBFCDF2541C0255999A1E8FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515711, 'LT56', 'NL32-01', NULL, 'MONTIGNEZ', 'Montignez', 'Montignez', '01010000201555000038C60248AA6A2141C016FF0C7AA50F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515713, 'NS01', 'NL32-05', NULL, 'MONTIMONEDA', 'Monti Moneda', 'Monti Moneda', '010100002015550000961D138FD0252641F6AD37D673DBFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515715, 'NS01', 'NL32-05', NULL, 'MONTIRUSCADA', 'Monti Ruscada', 'Monti Ruscada', '010100002015550000285F0F9FEC3926413AC7F671D3DEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515716, 'NS11', 'NL32-05', NULL, 'MONTIVIFF', 'Monti Viff', 'Monti Viff', '01010000201555000014C23C7F184D264136F85A16943DFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515717, 'LS06', 'NL32-04', NULL, 'MONTLAVILLE', 'Mont-la-Ville', 'Mont-la-Ville', '010100002015550000A371AFE43CD81F41A9CF2AB11A2A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515720, 'LS34', 'NL32-04', 4, 'MONTREUX', 'Montreux', 'Montreux', '010100002015550000226ACC871216214105FBE8178A670141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515721, 'KS96', 'NL32-04', NULL, 'MONTRICHER', 'Montricher', 'Montricher', '0101000020155500000F6119E593AF1F418D5CB1DF5FB70341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515722, 'KS94', 'NL32-04', NULL, 'MONTSURROLLE', 'Mont-sur-Rolle', 'Mont-sur-Rolle', '0101000020155500001A9BE91674701F41E8E2D4CEE1E90141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515723, 'MT23', 'NL32-02', NULL, 'MOOSLEERAU', 'Moosleerau', 'Moosleerau', '010100002015550000AC6B2FA9F6B82341FF48BF6C05B80C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515728, 'NR07', 'NL32-08', NULL, 'MORBIOINFERIORE', 'Morbio Inferiore', 'Morbio Inferiore', '010100002015550000F95D7EA54B1726417383302E6B40F340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515729, 'NR07', 'NL32-08', NULL, 'MORBIOSUPERIORE', 'Morbio Superiore', 'Morbio Superiore', '0101000020155500003BA4845000172641CB55453A32B4F340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515731, 'LS42', 'NL32-04', NULL, 'MORCLES', 'Morcles', 'Morcles', '01010000201555000085FD489D265B2141FEF80E806AEAFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515733, 'MR98', 'NL32-08', NULL, 'MORCOTE', 'Morcote', 'Morcote', '010100002015550000F6DB81E568CF2541C976801F7204F540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515734, 'MS23', 'NL32-05', NULL, 'MOREL', 'Mörel', 'Morel', '0101000020155500006ABBB28507B52341DC2E49082A810041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515735, 'LS39', 'NL32-04', NULL, 'MORENS', 'Morens', 'Morens', '0101000020155500009D8E91228E0E21418D4A4311420F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515736, 'MT71', 'NL32-02', NULL, 'MORGARTEN', 'Morgarten', 'Morgarten', '0101000020155500004DD7FF34260A254187A5BFD651840A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515738, 'LS05', 'NL32-04', NULL, 'MORGES', 'Morges', 'Morges', '010100002015550000175D9459C11C20417689CB8C58920241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515739, 'LS87', 'NL32-04', NULL, 'MORGETEN', 'Morgeten', 'Morgeten', '0101000020155500003E72A174544C2241AEC48F97D5C70441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515741, 'LS32', 'NL32-04', NULL, 'MORGINS', 'Morgins', 'Morgins', '0101000020155500003AA29361BCEC2041EBAC7347D363FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515745, 'LT61', 'NL32-01', NULL, 'MORIGEN', 'Mörigen', 'Morigen', '01010000201555000018CAE2EFD0CB214125F5141F35360A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515746, 'MT35', 'NL32-02', NULL, 'MORIKEN', 'Möriken', 'Moriken', '0101000020155500003AA47E6D8E06244177962FB6E1C30E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515748, 'NS17', 'NL32-05', NULL, 'MORISSEN', 'Morissen', 'Morissen', '010100002015550000812ACCCE40612641749556CCD8A30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515751, 'MT70', 'NL32-05', NULL, 'MORSCHACH', 'Morschach', 'Morschach', '01010000201555000065E61C569315254151349EB3A5EF0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515752, 'NT35', 'NL32-02', NULL, 'MORSCHWIL', 'Mörschwil', 'Morschwil', '0101000020155500007431623F7DDC26416760AB4404A40F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515753, 'NS74', 'NL32-05', NULL, 'MORTERATSCH', 'Morteratsch', 'Morteratsch', '010100002015550000E784CF79C5282841A5F5173C77FC0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515757, 'MS81', 'NL32-05', NULL, 'MOSCIA', 'Moscia', 'Moscia', '0101000020155500004B16FEAE016725415F312CB2084BFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515758, 'NT04', 'NL32-02', NULL, 'MOSNANG', 'Mosnang', 'Mosnang', '01010000201555000040B52C6C85FC2541BA72CC2E13340E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515759, 'MS71', 'NL32-05', NULL, 'MOSOGNO', 'Mosogno', 'Mosogno', '010100002015550000A941FC66272025414B12FADA9A29FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515761, 'LS19', 'NL32-04', NULL, 'MOTIERS', 'Môtiers', 'Motiers', '010100002015550000BC595E126D5C2041533E200823FD0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515762, 'LS70', 'NL32-04', NULL, 'MOTOT', 'Motôt', 'Motot', '010100002015550000F08A82BF2438224133274B0E0147F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515763, 'MS94', 'NL32-05', NULL, 'MOTTO', 'Motto', 'Motto', '010100002015550000CC06E7DBFAEE254166106DD4DA870141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515764, 'LS37', 'NL32-04', NULL, 'MOUDON', 'Moudon', 'Moudon', '010100002015550000368DAF31ACD12041DB78A66C2C940441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515765, 'LT73', 'NL32-01', NULL, 'MOUTIER', 'Moutier', 'Moutier', '010100002015550000761D3BCAF724224116723D1B63EC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515766, 'LT75', 'NL32-01', NULL, 'MOVELIER', 'Movelier', 'Movelier', '01010000201555000018AED944C5FD2141169007F9DABB0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515767, 'MR99', 'NL32-05', NULL, 'MUGENA', 'Mugena', 'Mugena', '0101000020155500003480A20813B925416A4FD918AC9FF840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515768, 'NR08', 'NL32-08', NULL, 'MUGGIO', 'Muggio', 'Muggio', '0101000020155500009CFD13528420264178C421E1669DF440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515769, 'MT24', 'NL32-02', NULL, 'MUHEN', 'Muhen', 'Muhen', '01010000201555000016DD873F83B82341FA7AA95CA39F0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515770, 'MT53', 'NL32-02', NULL, 'MUHLAU', 'Mühlau', 'Muhlau', '010100002015550000FE83BBAE617E244116E8EB2F084C0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515771, 'MS34', 'NL32-05', NULL, 'MUHLEBACH', 'Mühlebach', 'Muhlebach', '01010000201555000044BC12EFC8042441A6F7779E8D310141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515772, 'LT60', 'NL32-04', NULL, 'MUHLEBERG', 'Mühleberg', 'Muhleberg', '01010000201555000051B1BECA4FDF21413F03C29EC8660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515773, 'NT11', 'NL32-02', NULL, 'MUHLEHORN', 'Mühlehorn', 'Muhlehorn', '0101000020155500006186A069F84F2641697C533F5FD60A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515774, 'NS45', 'NL32-05', NULL, 'MUHLEN', 'Mühlen', 'Muhlen', '010100002015550000FE938EB42869274145AC32A153CD0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515775, 'LS88', 'NL32-04', NULL, 'MUHLETHURNEN', 'Mühlethurnen', 'Muhlethurnen', '010100002015550000FD1F475D167422416643AE6D16970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515776, 'MT94', 'NL32-02', NULL, 'MUHLRUTI', 'Mühlrüti', 'Muhlruti', '010100002015550000AC89484205DF2541586A13AFB6310E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515777, 'NS37', 'NL32-05', NULL, 'MULDAIN', 'Muldain', 'Muldain', '0101000020155500008919325F02292741D8C6EB607C430541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515779, 'NT07', 'NL32-02', NULL, 'MULLHEIM', 'Müllheim', 'Mullheim', '010100002015550000BC7CD411D2E425410641802D88AE1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515780, 'MT04', 'NL32-01', NULL, 'MUMLISWIL', 'Mümliswil', 'Mumliswil', '010100002015550000383C6D09CBE92241DC1AE81AF4D40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515781, 'MT16', 'NL32-01', NULL, 'MUMPF', 'Mumpf', 'Mumpf', '01010000201555000030AFA6D7A2682341CE61F42E20471041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515782, 'LT80', 'NL32-01', NULL, 'MUNCHENBUCHSEE', 'Münchenbuchsee', 'Munchenbuchsee', '010100002015550000E115CACC405622411E6342E4D84D0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515783, 'LT96', 'NL32-01', NULL, 'MUNCHENSTEIN', 'Münchenstein', 'Munchenstein', '010100002015550000EE8EEDFF45B8224186A4C356BE0B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515784, 'NT05', 'NL32-02', NULL, 'MUNCHWILEN', 'Münchwilen', 'Munchwilen', '010100002015550000106890E469E725419022858DF9530F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515785, 'MS12', 'NL32-04', NULL, 'MUND', 'Mund', 'Mund', '010100002015550000A7FCCDFB2E792341378407C09BA3FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515788, 'LS99', 'NL32-04', NULL, 'MUNSINGEN', 'Münsingen', 'Munsingen', '0101000020155500001DB5D0E0BD9B224118AE4413E17E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515789, 'MS44', 'NL32-05', NULL, 'MUNSTER', 'Münster', 'Munster', '0101000020155500005EDCF78D3C40244152468AFD831B0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515792, 'NT17', 'NL32-02', NULL, 'MUNSTERLINGEN', 'Münsterlingen', 'Munsterlingen', '0101000020155500005FA20C8B386D2641A624DE224BEE1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515798, 'LT50', 'NL32-01', NULL, 'MUNSTSCHEMIER', 'Münstschemier', 'Munstschemier', '01010000201555000099860B37189A2141C84DDF725D150941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515799, 'NS46', 'NL32-05', NULL, 'MUNTER', 'Munter', 'Munter', '010100002015550000993472998234274177FF08F0075D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515800, 'NT26', 'NL32-02', NULL, 'MUOLEN', 'Muolen', 'Muolen', '010100002015550000015811A390A02641E92C6FE7F3251041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515803, 'MT80', 'NL32-05', NULL, 'MUOTATHAL', 'Muotathal', 'Muotathal', '0101000020155500008DEF4F810F6525413F0D0C91D9BA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515814, 'NT11', 'NL32-02', NULL, 'MURG', 'Murg', 'Murg', '0101000020155500009FDFBAA39B6D2641F3198A8605D90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515816, 'MT13', 'NL32-01', NULL, 'MURGENTHAL', 'Murgenthal', 'Murgenthal', '010100002015550000396EF5C0022F23417E20D1CA8BB40C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515817, 'LS89', 'NL32-04', NULL, 'MURI', 'Muri', 'Muri', '010100002015550000446826111A6A2241AF76BD0C77F20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515818, 'MT43', 'NL32-02', NULL, 'MURI', 'Muri', 'Muri', '010100002015550000F01B35237960244111B7F7DF72BE0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515820, 'MS15', 'NL32-04', NULL, 'MURREN', 'Mürren', 'Murren', '010100002015550000EB40E0F6DD59234113637DA78C350341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515821, 'LS59', 'NL32-04', NULL, 'MURTEN', 'Murten', 'Murten', '010100002015550000EEC386F9F38F2141FE605E5FEB2D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515824, 'MS39', 'NL32-05', NULL, 'MUSSEN', 'Müssen', 'Mussen', '010100002015550000EA826BF885CF2341C0F61EC9074B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515825, 'PS06', 'NL32-06', NULL, 'MUSTAIR', 'Müstair', 'Mustair', '0101000020155500007F1059A3A64E2941035F3973E2A20441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515827, 'NS36', 'NL32-05', NULL, 'MUTTEN', 'Mutten', 'Mutten', '010100002015550000EC22C67ADA152741EA1E7A30A2CD0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515828, 'LT96', 'NL32-01', NULL, 'MUTTENZ', 'Muttenz', 'Muttenz', '0101000020155500006CE56593E3CB22413C4B6228D70B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515831, 'MT00', 'NL32-04', NULL, 'MUTZLENBERG', 'Mützlenberg', 'Mutzlenberg', '0101000020155500008195F3EDCEF42241780687EF4DA10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515836, 'NT01', 'NL32-02', NULL, 'NAFELS', 'Näfels', 'Nafels', '010100002015550000903DF389FE142641445F6EAB68970A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515837, 'MT74', 'NL32-02', NULL, 'NANIKON', 'Nänikon', 'Nanikon', '0101000020155500003705C2FAD73725419CF8B10CC1250E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515843, 'NS36', 'NL32-05', NULL, 'NARGLIESA', 'Nargliesa', 'Nargliesa', '010100002015550000B98B71D1282A274177F30C65D9950441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515844, 'NS45', 'NL32-05', NULL, 'NASCHAREGNAS', 'Nascharegnas', 'Nascharegnas', '01010000201555000082DD97735F5E2741426EB36EF93F0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515845, 'MS23', 'NL32-04', NULL, 'NATERS', 'Naters', 'Naters', '010100002015550000EEB944AA2B972341BE82BC587F0C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515852, 'LS72', 'NL32-04', NULL, 'NAX', 'Nax', 'Nax', '010100002015550000D82D4C7D4C4C224112EFA5492359FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515853, 'NS55', 'NL32-05', NULL, 'NAZ', 'Naz', 'Naz', '010100002015550000B20A03E455C127419E7FB44326BF0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515854, 'MT22', 'NL32-01', NULL, 'NEBIKON', 'Nebikon', 'Nebikon', '01010000201555000026776B7C2E88234128F3BCCF12950B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515855, 'NT14', 'NL32-02', NULL, 'NECKER', 'Necker', 'Necker', '01010000201555000039A9F681D53726414DFADC2D21FF0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515856, 'MT76', 'NL32-02', NULL, 'NEFTENBACH', 'Neftenbach', 'Neftenbach', '010100002015550000105BD6CFE8212541B67B5ED9C2331041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515857, 'MS94', 'NL32-05', NULL, 'NEGRENTINO', 'Negrentino', 'Negrentino', '01010000201555000045BE3F1E69D0254108A8DE044EF90141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515863, 'MS47', 'NL32-05', NULL, 'NESSENTHAL', 'Nessenthal', 'Nessenthal', '0101000020155500008031BB37025224417F903CD5E9460541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515864, 'NT12', 'NL32-02', NULL, 'NESSLAU', 'Nesslau', 'Nesslau', '010100002015550000CED4D863C7612641C87A4C8577330C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515866, 'NT01', 'NL32-02', NULL, 'NETSTAL', 'Netstal', 'Netstal', '010100002015550000738CE7E6000C2641D87548B6EBE80941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515869, 'LT40', 'NL32-01', 3, 'NEUCHATEL', 'Neuchâtel', 'Neuchatel', '0101000020155500001CE91856103721417A37705855170941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515873, 'MT32', 'NL32-02', NULL, 'NEUDORF', 'Neudorf', 'Neudorf', '0101000020155500001B1E27FD7C1224413C2513CEB55F0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515882, 'MT45', 'NL32-02', NULL, 'NEUENHOF', 'Neuenhof', 'Neuenhof', '0101000020155500004A27A8A6D65424412D3B55F9F03A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515883, 'MT31', 'NL32-02', NULL, 'NEUENKIRCH', 'Neuenkirch', 'Neuenkirch', '010100002015550000A53BFBC00C132441D8AEC14C1B780A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515884, 'LT96', 'NL32-01', NULL, 'NEUEWELT', 'Neuewelt', 'Neuewelt', '010100002015550000F593F3A03DB82241B9AFF5C9B2281041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515885, 'NS38', 'NL32-05', NULL, 'NEUFELSBERG', 'Neu-Felsberg', 'Neu-Felsberg', '0101000020155500004D908028B4112741F88A9E7B504A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515886, 'MS07', 'NL32-04', NULL, 'NEUHAUS', 'Neuhaus', 'Neuhaus', '010100002015550000D639998D723123413409E47500CA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515887, 'MT78', 'NL32-02', NULL, 'NEUHAUSEM', 'Neuhausem', 'Neuhausem', '0101000020155500000B1423DD8A022541D21EEF046F371141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515889, 'MT62', 'NL32-02', NULL, 'NEUHEIM', 'Neuheim', 'Neuheim', '01010000201555000048DD686A1DF52441AE921D0889DE0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515890, 'NS27', 'NL32-05', NULL, 'NEUKIRCH', 'Neukirch', 'Neukirch', '010100002015550000C23E6CA732B126412B5D192A51710541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515892, 'NT26', 'NL32-02', NULL, 'NEUKIRCH', 'Neukirch', 'Neukirch', '0101000020155500008215ECBF9FBD26416121A79453441041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515894, 'NS17', 'NL32-05', NULL, 'NEUKIRCHBEIILANZ', 'Neukirch bei Ilanz', 'Neukirch bei Ilanz', '01010000201555000017B7CD93094D26416E67BDADFADB0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515895, 'MT00', 'NL32-04', NULL, 'NEUMUHLE', 'Neumühle', 'Neumuhle', '01010000201555000091E7077BA0082341227BB9F899A10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515897, 'MT68', 'NL32-02', NULL, 'NEUNKIRCH', 'Neunkirch', 'Neunkirch', '010100002015550000F3C5DF0FEABD2441E50E29506F521141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515898, 'NT12', 'NL32-02', NULL, 'NEUSANKTJOHANN', 'Neu Sankt Johann', 'Neu Sankt Johann', '0101000020155500000A08A808EB57264111C63BD995320C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515900, 'LS58', 'NL32-04', NULL, 'NEYRUZ', 'Neyruz', 'Neyruz', '010100002015550000868F724E9671214181F7A91859250641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515901, 'LT61', 'NL32-01', NULL, 'NIDAU', 'Nidau', 'Nidau', '010100002015550000CCB961B2C7D5214103A646C6E7A90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515904, 'NT00', 'NL32-05', NULL, 'NIDFURN', 'Nidfurn', 'Nidfurn', '0101000020155500008CD55A54310D264187339D655C010941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515910, 'MT03', 'NL32-01', NULL, 'NIEDERBIPP', 'Niederbipp', 'Niederbipp', '010100002015550000B411E3F92DE022414C014B304CB30C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515911, 'MT03', 'NL32-01', NULL, 'NIEDERBUCHSITEN', 'Niederbuchsiten', 'Niederbuchsiten', '01010000201555000075708DB589072341B193A17FC2ED0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515912, 'NT15', 'NL32-02', NULL, 'NIEDERBUREN', 'Niederbüren', 'Niederburen', '0101000020155500009245A4903A5D2641778E4BD3F45D0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515913, 'MT25', 'NL32-02', NULL, 'NIEDERERLINSBACH', 'Niedererlinsbach', 'Niedererlinsbach', '010100002015550000CE93181A939A23413331401361860E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515914, 'MS03', 'NL32-04', NULL, 'NIEDERGAMPEL', 'Niedergampel', 'Niedergampel', '0101000020155500007F8C27AFCDF622411A84AC017B9EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515917, 'MS02', 'NL32-04', NULL, 'NIEDERGESTELN', 'Niedergesteln', 'Niedergesteln', '010100002015550000116C9BA9EB1E2341DB166354C09FFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515918, 'MT24', 'NL32-01', NULL, 'NIEDERGOSGEN', 'Niedergösgen', 'Niedergosgen', '0101000020155500008983516E1C872341DB28CC8A05120E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515919, 'MT34', 'NL32-02', NULL, 'NIEDERHALLWIL', 'Niederhallwil', 'Niederhallwil', '010100002015550000E8CB815D61072441BAA2144874680D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515920, 'NT15', 'NL32-02', NULL, 'NIEDERHELFENSCHWIL', 'Niederhelfenschwil', 'Niederhelfenschwil', '0101000020155500008E9B82D016532641D7DB622FF9960F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515921, 'MT34', 'NL32-02', NULL, 'NIEDERLENZ', 'Niederlenz', 'Niederlenz', '010100002015550000D258AB95B106244135CEFCEBF9890E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515922, 'NS19', 'NL32-05', NULL, 'NIEDERN', 'Niedern', 'Niedern', '010100002015550000FEE823C5085E26417CD2DFB2B4E60741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515923, 'NT00', 'NL32-05', NULL, 'NIEDERNSTAFEL', 'Niedern Stafel', 'Niedern Stafel', '010100002015550000C655D7ED4D212641CB62F4DC1DC90841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515924, 'MS59', 'NL32-05', NULL, 'NIEDERRICKENBACH', 'Niederrickenbach', 'Niederrickenbach', '01010000201555000073D5D513729F2441BE3A156B6D010841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515925, 'MS17', 'NL32-04', NULL, 'NIEDERRIED', 'Niederried', 'Niederried', '010100002015550000FB23CD590A6D2341C08569E2193F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515926, 'MT45', 'NL32-02', NULL, 'NIEDERROHRDORF', 'Niederrohrdorf', 'Niederrohrdorf', '010100002015550000CA886F31564B244122BFA345B2C60E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515927, 'LS79', 'NL32-04', NULL, 'NIEDERSCHERLI', 'Niederscherli', 'Niederscherli', '0101000020155500000264A2CB912E22417341FB92AE7E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515928, 'MT43', 'NL32-02', NULL, 'NIEDERSCHONGAU', 'Nieder-Schongau', 'Nieder-Schongau', '01010000201555000046093ECE342F24411841EB924EBC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515929, 'NT26', 'NL32-02', NULL, 'NIEDERSOMMERI', 'Niedersommeri', 'Niedersommeri', '010100002015550000ABC17AFDEE8B2641BE13B726DD7B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515931, 'MS68', 'NL32-05', NULL, 'NIEDERSURENENALP', 'Nieder Surenen Alp', 'Nieder Surenen Alp', '01010000201555000063C8668BBDBE24413DD7238DCF330641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515933, 'NT01', 'NL32-02', NULL, 'NIEDERURNEN', 'Niederurnen', 'Niederurnen', '0101000020155500007A8B4278D00A2641784EE4D97BD00A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515934, 'NT05', 'NL32-02', NULL, 'NIEDERUZWIL', 'Niederuzwil', 'Niederuzwil', '010100002015550000BB3FAF16732C2641DCD0BA7DC11F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515935, 'MS34', 'NL32-05', NULL, 'NIEDERWALD', 'Niederwald', 'Niederwald', '010100002015550000EFC7DA72A80E24419D0C4611D36B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515936, 'MT56', 'NL32-02', NULL, 'NIEDERWENINGEN', 'Niederweningen', 'Niederweningen', '010100002015550000D9AF53B59C712441E6E2E68FF5111041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515937, 'LS98', 'NL32-04', NULL, 'NIEDERWICHTRACH', 'Niederwichtrach', 'Niederwichtrach', '010100002015550000DA28FC2FB8A5224180E38994250B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515943, 'LT51', 'NL32-01', NULL, 'NODS', 'Nods', 'Nods', '010100002015550000919F767DD87C2141CAA926772EAB0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515944, 'MT67', 'NL32-02', NULL, 'NOHL', 'Nohl', 'Nohl', '01010000201555000042F1BD12FBF82441CA7B7E51301A1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515946, 'LT20', 'NL32-04', NULL, 'NOIRAIGUE', 'Noiraigue', 'Noiraigue', '0101000020155500009E50AF1C08AC204113836741CE6D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515950, 'NT46', 'NL32-02', NULL, 'NONNENHORN', 'Nonnenhorn', 'Nonnenhorn', '0101000020155500006A8DAED20B462741742FCCE15E851041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515951, 'NS12', 'NL32-05', NULL, 'NORANTOLA', 'Norantola', 'Norantola', '0101000020155500005F597A46E95F26410B2EC10E2910FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515956, 'LS48', 'NL32-04', NULL, 'NOREAZ', 'Noréaz', 'Noreaz', '01010000201555000063408302D653214118EFCD58DA5F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515957, 'MT32', 'NL32-02', NULL, 'NOTTWIL', 'Nottwil', 'Nottwil', '010100002015550000B7F6D1A041EB23415778442A71EA0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515958, 'MR89', 'NL32-05', NULL, 'NOVAGGIO', 'Novaggio', 'Novaggio', '010100002015550000F7B32F4386AF2541B75CBC1DA3B6F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515959, 'LS18', 'NL32-04', NULL, 'NOVALLES', 'Novalles', 'Novalles', '01010000201555000028F9EDAAA65B20414F4B8C4CA6DB0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515960, 'MR97', 'NL32-08', NULL, 'NOVAZZANO', 'Novazzano', 'Novazzano', '01010000201555000008A126A01FEF254160E3152F32C6F240');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515961, 'LS61', 'NL32-04', NULL, 'NOVELI', 'Noveli', 'Noveli', '0101000020155500000FA8BA74D90522412DF285E4D0A2FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515964, 'NS15', 'NL32-05', NULL, 'NUFENEN', 'Nufenen', 'Nufenen', '010100002015550000C271B01C108D26415086F538DAF00241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515967, 'LT95', 'NL32-01', NULL, 'NUNNINGEN', 'Nunningen', 'Nunningen', '0101000020155500004D976848ACAE22416B9511990A820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515968, 'MT75', 'NL32-02', NULL, 'NURENSDORF', 'Nürensdorf', 'Nurensdorf', '010100002015550000A62F462D391925416A4E544A66450F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515969, 'MT80', 'NL32-05', NULL, 'NUSCHLAU', 'Nuschlau', 'Nuschlau', '0101000020155500003832D421E95A2541C675609A13F40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515970, 'MT87', 'NL32-02', NULL, 'NUSSBAUMEN', 'Nussbaumen', 'Nussbaumen', '01010000201555000077872155DE782541043E34AC72C71041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515971, 'LS85', 'NL32-04', NULL, 'NYDEGG', 'Nydegg', 'Nydegg', '01010000201555000048D7D98F476A2241F9A29BBAABF80241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515972, 'KS84', 'NL32-04', NULL, 'NYON', 'Nyon', 'Nyon', '010100002015550000401AE860400A1F41502F89F159CB0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515974, 'NT26', 'NL32-02', NULL, 'OBERAACH', 'Oberaach', 'Oberaach', '01010000201555000008852D3F23822641DA4050B8677B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515979, 'NS57', 'NL32-05', NULL, 'OBERALP', 'Oberalp', 'Oberalp', '0101000020155500008B45D0B5D9C72741DD5C12F1528F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515985, 'LS79', 'NL32-04', NULL, 'OBERBALM', 'Oberbalm', 'Oberbalm', '0101000020155500001A4BFAA97C382241C1CB68D7C1440741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515988, 'NT04', 'NL32-02', NULL, 'OBERBAZENHEID', 'Ober-Bazenheid', 'Ober-Bazenheid', '01010000201555000008C21659960F26419AB071207BA90E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515989, 'NT02', 'NL32-02', NULL, 'OBERBILTEN', 'Ober-Bilten', 'Ober-Bilten', '0101000020155500003BBCBC0979F6254157EA1022A9420B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515990, 'LT93', 'NL32-01', NULL, 'OBERBIPP', 'Oberbipp', 'Oberbipp', '01010000201555000057A2821D5ED622419D8E942546790C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515991, 'MT76', 'NL32-02', NULL, 'OBERBUCH', 'Ober-Buch', 'Ober-Buch', '010100002015550000435AEAF1140E25412246368E1B501041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515992, 'MT03', 'NL32-01', NULL, 'OBERBUCHSITEN', 'Oberbuchsiten', 'Oberbuchsiten', '010100002015550000691B4D097B07234137BEE652AA270D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515994, 'LT72', 'NL32-01', NULL, 'OBERBUREN', 'Oberbüren', 'Oberburen', '010100002015550000EB6A1CADB92E224138ED498A36E30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515995, 'LT90', 'NL32-01', NULL, 'OBERBURG', 'Oberburg', 'Oberburg', '0101000020155500001E6850BD38B92241C0DB5FFC38880941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515996, 'NS16', 'NL32-05', NULL, 'OBERCASTELS', 'Obercastels', 'Obercastels', '0101000020155500009E66D377425826419B0B24484FF50441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515997, 'MS18', 'NL32-04', NULL, 'OBERDIESSBACH', 'Oberdiessbach', 'Oberdiessbach', '010100002015550000E3A48C994A802341066CE8B0E4D40641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515998, 'MT50', 'NL32-05', NULL, 'OBERDORF', 'Oberdorf', 'Oberdorf', '01010000201555000045FF5E5BB6B22441E82FA49923B00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515999, 'LT83', 'NL32-01', NULL, 'OBERDORF', 'Oberdorf', 'Oberdorf', '0101000020155500002C3193F9CE73224142419A59A53E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516000, 'MT05', 'NL32-01', NULL, 'OBERDORF', 'Oberdorf', 'Oberdorf', '010100002015550000645560FF2207234141776F991A830E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516001, 'PT00', 'NL32-06', NULL, 'OBEREALP', 'Obere Alp', 'Obere Alp', '010100002015550000EE43EF12CC2F29419680AC9308250941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516002, 'NT45', 'NL32-02', NULL, 'OBEREGG', 'Oberegg', 'Oberegg', '010100002015550000150E6BFB2A2C27416FE558848AFE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516003, 'MT75', 'NL32-02', NULL, 'OBEREMBRACH', 'Oberembrach', 'Oberembrach', '01010000201555000077EEF39426052541F8910C2502B80F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516004, 'LS92', 'NL32-04', NULL, 'OBEREMS', 'Oberems', 'Oberems', '01010000201555000016528CCBDEEC2241C123E9AE9CB6FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516005, 'MT46', 'NL32-02', NULL, 'OBERENDINGEN', 'Oberendingen', 'Oberendingen', '010100002015550000222EF39D6B4024419369710ECE2D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516007, 'MT54', 'NL32-02', NULL, 'OBERENGSTRINGEN', 'Oberengstringen', 'Oberengstringen', '010100002015550000B74E0414F4A3244155027D7803910E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516008, 'MT24', 'NL32-02', NULL, 'OBERENTFELDEN', 'Oberentfelden', 'Oberentfelden', '01010000201555000072C259C98FAE2341CB365DB33DD90D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516009, 'MT25', 'NL32-02', NULL, 'OBERERLINSBACH', 'Obererlinsbach', 'Obererlinsbach', '010100002015550000CE93181A939A23413331401361860E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516011, 'MS27', 'NL32-05', NULL, 'OBERFELD', 'Oberfeld', 'Oberfeld', '010100002015550000B5C7EDCC97D0234155C8C992F2410541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516012, 'MS78', 'NL32-05', NULL, 'OBERFELD', 'Oberfeld', 'Oberfeld', '010100002015550000AC230FAD0E3F2541A08D0C9FFA220741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516013, 'LT92', 'NL32-01', NULL, 'OBERGERLAFINGEN', 'Obergerlafingen', 'Obergerlafingen', '0101000020155500004D6C10C4579B2241F46BEA9037570B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516015, 'MS45', 'NL32-05', NULL, 'OBERGESTELN', 'Obergesteln', 'Obergesteln', '010100002015550000A62B5C1CE85D24416EB30B1B9C900241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516016, 'MT65', 'NL32-02', NULL, 'OBERGLATT', 'Oberglatt', 'Oberglatt', '010100002015550000D1DC7FCC78CA2441A7A5A312B87A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516017, 'MT24', 'NL32-01', NULL, 'OBERGOSGEN', 'Obergösgen', 'Obergosgen', '0101000020155500004E9D05B85E7D2341D6E993FDDAD70D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516018, 'LS88', 'NL32-04', NULL, 'OBERGURZELEN', 'Ober Gurzelen', 'Ober Gurzelen', '0101000020155500003754DC6B03882241380AAA3C77E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516021, 'MT68', 'NL32-02', NULL, 'OBERHALLAU', 'Oberhallau', 'Oberhallau', '010100002015550000C0AD292624B42441D987EE282C521141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516022, 'MT65', 'NL32-02', NULL, 'OBERHAUSEN', 'Oberhausen', 'Oberhausen', '01010000201555000070715E5F8BE824416F1F3DCDAACE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516023, 'NT26', 'NL32-02', NULL, 'OBERHEGI', 'Oberhegi', 'Oberhegi', '010100002015550000458A5CD5FABD26419870EE5461271041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516024, 'NT04', 'NL32-02', NULL, 'OBERHELFENSCHWIL', 'Oberhelfenschwil', 'Oberhelfenschwil', '0101000020155500003C7C124E2924264192ED4B3972FD0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516025, 'LS97', 'NL32-04', NULL, 'OBERHOFEN', 'Oberhofen', 'Oberhofen', '0101000020155500002C9FAED7AAD7224131DECE5851760541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516026, 'MS09', 'NL32-04', NULL, 'OBERHOFEN', 'Oberhofen', 'Oberhofen', '010100002015550000DA39FC02B31C2341D1C0D64954BA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516028, 'MT36', 'NL32-02', NULL, 'OBERHOFENBEIETZGEN', 'Oberhofen bei Etzgen', 'Oberhofen bei Etzgen', '010100002015550000E5F364CF0DE82341820AE05207491041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516030, 'MT80', 'NL32-02', NULL, 'OBERIBERG', 'Oberiberg', 'Oberiberg', '01010000201555000004945DE5F96D25413030F33619A30941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516031, 'MT74', 'NL32-02', NULL, 'OBERILLNAU', 'Ober Illnau', 'Ober Illnau', '010100002015550000C6C67FD134412541E45F41B3309A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516032, 'MT32', 'NL32-02', NULL, 'OBERKIRCH', 'Oberkirch', 'Oberkirch', '01010000201555000035D852D040E1234147DBF18DFF230B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516033, 'MS16', 'NL32-04', NULL, 'OBERLAGER', 'Ober Läger', 'Ober Lager', '010100002015550000BFE3C5F6538123413391DA9502580441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516034, 'MS26', 'NL32-05', NULL, 'OBERLAGER', 'Oberläger', 'Oberlager', '0101000020155500001867B313F3D02341C20F835841940441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516038, 'NS68', 'NL32-05', NULL, 'OBERLARET', 'Ober-Laret', 'Ober-Laret', '010100002015550000A037545318EC2741BDB1F0E021630741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516039, 'MT53', 'NL32-02', NULL, 'OBERLUNKHOFEN', 'Oberlunkhofen', 'Oberlunkhofen', '010100002015550000F3BF7440AF7D2441995CB52DA3330D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516040, 'MS58', 'NL32-05', NULL, 'OBERMATT', 'Obermatt', 'Obermatt', '0101000020155500007A94F69863822441701C12D15E180741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516041, 'MT87', 'NL32-02', NULL, 'OBERNEUFORN', 'Oberneuforn', 'Oberneuforn', '01010000201555000048643A738A6525413D131215D1A91041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516043, 'MT02', 'NL32-01', NULL, 'OBERONZ', 'Oberönz', 'Oberonz', '0101000020155500005B265A7052EA22417A162F6CFF570B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516044, 'LS88', 'NL32-04', NULL, 'OBERPLOTSCH', 'Ober-Plötsch', 'Ober-Plotsch', '01010000201555000073BACB283960224178463E293E230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516045, 'MT10', 'NL32-04', NULL, 'OBERRAMIS', 'Ober Rämis', 'Ober Ramis', '01010000201555000052DBAFBF31302341018AEE8632DC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516046, 'MS59', 'NL32-05', NULL, 'OBERRICKENBACH', 'Oberrickenbach', 'Oberrickenbach', '010100002015550000EE27D67CE3952441AC55CDBC228D0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516047, 'LS84', 'NL32-04', NULL, 'OBERRIED', 'Oberried', 'Oberried', '01010000201555000092E3905355602241156715C276290141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516048, 'MS17', 'NL32-04', NULL, 'OBERRIED', 'Oberried', 'Oberried', '010100002015550000DF3F1058DB802341BD51A73480790541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516050, 'MT63', 'NL32-02', NULL, 'OBERRIEDEN', 'Oberrieden', 'Oberrieden', '01010000201555000051F710D66AEA24410175B15E8FC50C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516051, 'NT44', 'NL32-02', NULL, 'OBERRIET', 'Oberriet', 'Oberriet', '010100002015550000561E11C1583827410A958B7F49A40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516052, 'LS76', 'NL32-04', NULL, 'OBERROHRMOOS', 'Ober Rohrmoos', 'Ober Rohrmoos', '0101000020155500003B615C1D7C062241FC36E19F91A60341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516053, 'MT52', 'NL32-02', NULL, 'OBERRUTI', 'Oberrüti', 'Oberruti', '010100002015550000FA9EEF1B147F24419A21DB516E640B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516054, 'NS07', 'NL32-05', NULL, 'OBERSAXEN', 'Obersaxen', 'Obersaxen', '0101000020155500005C67993D322F26412B57ABBA69D90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516055, 'NS49', 'NL32-05', NULL, 'OBERSAYS', 'Ober-Says', 'Ober-Says', '010100002015550000BCEFFA5EAF4B27415F26EDC731380841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516057, 'MT77', 'NL32-02', NULL, 'OBERSCHLATT', 'Ober-Schlatt', 'Ober-Schlatt', '01010000201555000065C57A8AA73325416211C827001C1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516056, 'MT85', 'NL32-02', NULL, 'OBERSCHLATT', 'Oberschlatt', 'Oberschlatt', '01010000201555000070E3ABB6C98E25416E2CD8582D870F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516058, 'MT70', 'NL32-02', NULL, 'OBERSCHONENBUCH', 'Oberschönenbuch', 'Oberschonenbuch', '010100002015550000800A57D8411F2541122BB75B262A0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516059, 'MT43', 'NL32-02', NULL, 'OBERSCHONGAU', 'Ober-Schongau', 'Ober-Schongau', '01010000201555000046093ECE342F24411841EB924EBC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516060, 'LS67', 'NL32-04', NULL, 'OBERSCHROT', 'Oberschrot', 'Oberschrot', '01010000201555000070582A21CFE821415C4D3ED8FC750541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516062, 'NT20', 'NL32-05', NULL, 'OBERSIEZ', 'Ober Siez', 'Ober Siez', '010100002015550000449BE281F18D2641CCF258DFA60C0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516065, 'MT46', 'NL32-02', NULL, 'OBERSIGGENTHAL', 'Obersiggenthal', 'Obersiggenthal', '01010000201555000016EC17455A542441426A2871A8E80F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516068, 'MS37', 'NL32-05', NULL, 'OBERSTAFEL', 'Ober Stafel', 'Ober Stafel', '010100002015550000F7F4EEDE69F823413BAEADB952430541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516069, 'NS09', 'NL32-05', NULL, 'OBERSTAFEL', 'Ober Stafel', 'Ober Stafel', '01010000201555000062DFDC09702C2641460C480B66E20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516070, 'NS09', 'NL32-05', NULL, 'OBERSTAFFEL', 'Ober Staffel', 'Ober Staffel', '010100002015550000C6612E590EF02541393465622D8B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516071, 'MT87', 'NL32-02', NULL, 'OBERSTAMMHEIM', 'Ober-Stammheim', 'Ober-Stammheim', '0101000020155500002F8350E2CB64254130D25427AC001141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516072, 'LS87', 'NL32-04', NULL, 'OBERSTOCKEN', 'Oberstocken', 'Oberstocken', '010100002015550000FD9A615405922241051C4E93D13B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516073, 'NT11', 'NL32-02', NULL, 'OBERTERZEN', 'Oberterzen', 'Oberterzen', '01010000201555000068C121D70882264128EB72E20D670A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516076, 'MS58', 'NL32-05', NULL, 'OBERTRUBSEEALP', 'Ober Trübsee Alp', 'Ober Trubsee Alp', '0101000020155500005B216268E9822441E8F9519FAE6A0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516077, 'NS27', 'NL32-05', NULL, 'OBERTSCHAPPINA', 'Ober Tschappina', 'Ober Tschappina', '0101000020155500008083805BC4CF264109A9C66B73000541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516078, 'LS89', 'NL32-04', NULL, 'OBERULMIZ', 'Oberulmiz', 'Oberulmiz', '010100002015550000D02A554B584C22414C09A01289B80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516079, 'MT54', 'NL32-02', NULL, 'OBERURDORF', 'Ober Urdorf', 'Ober Urdorf', '0101000020155500000439420B7A9024410C39F5171D560E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516080, 'NT05', 'NL32-02', NULL, 'OBERUZWIL', 'Oberuzwil', 'Oberuzwil', '010100002015550000BB3FAF16732C2641DCD0BA7DC11F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516081, 'NS47', 'NL32-05', NULL, 'OBERVAZ', 'Obervaz', 'Obervaz', '01010000201555000087E7FADAF632274143302A908B440541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516082, 'MS45', 'NL32-05', NULL, 'OBERWALD', 'Oberwald', 'Oberwald', '0101000020155500003CA69DC2BB672441AE08AFB2F4CA0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516083, 'LS79', 'NL32-04', NULL, 'OBERWANGEN', 'Ober-Wangen', 'Ober-Wangen', '010100002015550000034929CDC01A2241E1448BCC8EF20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516084, 'MT95', 'NL32-02', NULL, 'OBERWANGEN', 'Oberwangen', 'Oberwangen', '0101000020155500007FCE6C250FD425417BC0BDC587180F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516085, 'MT56', 'NL32-02', NULL, 'OBERWENINGEN', 'Oberweningen', 'Oberweningen', '0101000020155500009A47B156678524418F54C011F5EA0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516086, 'MT84', 'NL32-02', NULL, 'OBERWETZIKON', 'Ober-Wetzikon', 'Ober-Wetzikon', '01010000201555000054AF37B88269254147E2E54439B50D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516087, 'LS86', 'NL32-04', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '0101000020155500003D627EDD534C2241E1F0153309540441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516088, 'LT71', 'NL32-01', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '010100002015550000786465BA983822411649D02149A90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516089, 'MT54', 'NL32-02', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '01010000201555000068DBEF08567D24410503F80A71A70D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516090, 'LT96', 'NL32-01', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '0101000020155500008E96ACD10A912241D456F082990B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516091, 'MS39', 'NL32-05', NULL, 'OBERWILEN', 'Oberwilen', 'Oberwilen', '010100002015550000F3BE3A81160B24419FF5EC80234D0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516092, 'LT70', 'NL32-04', NULL, 'OBERWOHLEN', 'Ober-Wohlen', 'Ober-Wohlen', '010100002015550000A4DAF680CD1A22412CC7240043A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516093, 'LS98', 'NL32-04', NULL, 'OBERZELG', 'Oberzelg', 'Oberzelg', '0101000020155500006995DABAA7C3224171D8F18ECD230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516094, 'MT53', 'NL32-02', NULL, 'OBFELDEN', 'Obfelden', 'Obfelden', '0101000020155500001B831655BD91244109F1C3CBCCC00C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516095, 'NT11', 'NL32-02', NULL, 'OBSTALDEN', 'Obstalden', 'Obstalden', '0101000020155500002A68E04E1746264179DF4D7481D50A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516100, 'MT02', 'NL32-01', NULL, 'OCHLENBERG', 'Ochlenberg', 'Ochlenberg', '0101000020155500006B9AE7F81EFE224175B1C78C5F1E0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516101, 'MT81', 'NL32-02', NULL, 'OCHSENBODEN', 'Ochsenboden', 'Ochsenboden', '0101000020155500001FB93D43ED9E254179801CC9611A0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516102, 'LT54', 'NL32-01', NULL, 'OCOURT', 'Ocourt', 'Ocourt', '010100002015550000E55EF13DC47D21416BBF0FF5D7D50D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516103, 'MT03', 'NL32-01', NULL, 'OENSINGEN', 'Oensingen', 'Oensingen', '010100002015550000479A08E5AFFD22410BE3F5A19BED0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516105, 'MT65', 'NL32-02', NULL, 'OERLIKON', 'Oerlikon', 'Oerlikon', '010100002015550000D0E6B818B8DE24414E94633A1BCE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516106, 'LT91', 'NL32-01', NULL, 'OESCHBERG', 'Oeschberg', 'Oeschberg', '0101000020155500005958CFE30EB922415C542E7ABCA90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516111, 'MT73', 'NL32-02', NULL, 'OETWILAMSEE', 'Oetwil am See', 'Oetwil am See', '0101000020155500001B50E8B717432541439787A8FFCA0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516112, 'MT55', 'NL32-02', NULL, 'OETWILANDERLIMMAT', 'Oetwil an der Limmat', 'Oetwil an der Limmat', '010100002015550000794E67EF1C86244198163FA556030F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516113, 'LS96', 'NL32-04', NULL, 'OEY', 'Oey', 'Oey', '0101000020155500005AE2B9EC02A62241B53DC3F63F8E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516117, 'MT14', 'NL32-01', NULL, 'OFTRINGEN', 'Oftringen', 'Oftringen', '0101000020155500006A0D7092DE692341D4C2D67F8C630D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516118, 'MT22', 'NL32-01', NULL, 'OHMSTAL', 'Ohmstal', 'Ohmstal', '010100002015550000F29C4D1B687E23412A2169DBE85A0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516119, 'LU50', 'NL32-01', NULL, 'OLEYRES', 'Oleyres', 'Oleyres', '010100002015550000D4D4AA803F6C2141CC155BDDC64F1241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516120, 'MS95', 'NL32-05', NULL, 'OLIVONE', 'Olivone', 'Olivone', '010100002015550000CC40838E4BD925412B20F3489FE10241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516122, 'LS42', 'NL32-04', NULL, 'OLLON', 'Ollon', 'Ollon', '010100002015550000C29EF01676472141C378B399422EFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516123, 'MT14', 'NL32-01', NULL, 'OLTEN', 'Olten', 'Olten', '01010000201555000066AA3E78B1692341483A0D195CD70D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516124, 'KS71', 'NL32-04', NULL, 'ONEX', 'Onex', 'Onex', '0101000020155500008080296608501E4186C3452AF934FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516125, 'LS58', 'NL32-04', NULL, 'ONNENS', 'Onnens', 'Onnens', '010100002015550000F16FCADEA467214153E6769B8A250641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516126, 'LS29', 'NL32-04', NULL, 'ONNENS', 'Onnens', 'Onnens', '010100002015550000F8056C6F63972041717C068825130741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516129, 'MT65', 'NL32-02', NULL, 'OPFIKON', 'Opfikon', 'Opfikon', '010100002015550000260E0C9028F224419FA6596323090F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516130, 'LS27', 'NL32-04', NULL, 'OPPENS', 'Oppens', 'Oppens', '0101000020155500009FA6C4CC4B962041D64B18A7F7430541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516133, 'LS17', 'NL32-04', NULL, 'ORBE', 'Orbe', 'Orbe', '010100002015550000713FF515BF322041D62246A125480541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516136, 'MS75', 'NL32-05', NULL, 'ORELLO', 'Orello', 'Orello', '010100002015550000F40D8D2C112525411A40A551ED480341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516137, 'MT15', 'NL32-01', NULL, 'ORMALINGEN', 'Ormalingen', 'Ormalingen', '010100002015550000BD32F33EA04B2341401AEE4C076C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516140, 'LS35', 'NL32-04', NULL, 'ORONLAVILLE', 'Oron-la-ville', 'Oron-la-ville', '0101000020155500003E143CD3F6D0204106AC187ACA380341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516142, 'LT72', 'NL32-01', NULL, 'ORPUND', 'Orpund', 'Orpund', '01010000201555000076DC7F1955FD2141C02A8BB575E30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516144, 'LR59', 'NL32-04', NULL, 'ORSIERES', 'Orsières', 'Orsieres', '010100002015550000F88DAE96E5A021410EE785C725EEF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516145, 'LS47', 'NL32-04', NULL, 'ORSONNENS', 'Orsonnens', 'Orsonnens', '01010000201555000066CE0FEA883F21412FBB6A02CE3E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516146, 'MS99', 'NL32-05', NULL, 'ORTHALDEN', 'Orthalden', 'Orthalden', '01010000201555000088767F3329D32541502BC9452DDB0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516148, 'LT62', 'NL32-01', NULL, 'ORVIN', 'Orvin', 'Orvin', '010100002015550000A4F87E4826C221416B762724D7570B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516150, 'MS84', 'NL32-05', NULL, 'OSCO', 'Osco', 'Osco', '010100002015550000B89C799229762541B40ECFEFAD2C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516151, 'MS92', 'NL32-05', NULL, 'OSOGNA', 'Osogna', 'Osogna', '010100002015550000FC3CA88DF9F025417C256C234AE5FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516152, 'MT77', 'NL32-02', NULL, 'OSSINGEN', 'Ossingen', 'Ossingen', '01010000201555000072700A0B243E2541AFAC0CA975C51041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516153, 'MT67', 'NL32-02', NULL, 'OSTERFINGEN', 'Osterfingen', 'Osterfingen', '0101000020155500004ACA19D686B424416536279A43181141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516154, 'LT80', 'NL32-04', NULL, 'OSTERMUNDIGEN', 'Ostermundigen', 'Ostermundigen', '0101000020155500007DDA6AEE156A2241B73C937544660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516157, 'MT55', 'NL32-02', NULL, 'OTELFINGEN', 'Otelfingen', 'Otelfingen', '010100002015550000CFA19827F17B2441366C39AAAB760F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516159, 'MT44', 'NL32-02', NULL, 'OTHMARSINGEN', 'Othmarsingen', 'Othmarsingen', '010100002015550000389461FC591A244178A9C029BD8A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516160, 'MT53', 'NL32-02', NULL, 'OTTENBACH', 'Ottenbach', 'Ottenbach', '010100002015550000D5660682B5872441142B50CC36FA0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516161, 'LS15', 'NL32-04', NULL, 'OUCHY', 'Ouchy', 'Ouchy', '01010000201555000090EAD795B06C204157B21B2EC98E0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516162, 'LS51', 'NL32-04', NULL, 'OVRONNAZ', 'Ovronnaz', 'Ovronnaz', '010100002015550000888A8B7B7BAB2141B08FE166D573FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516164, 'LS27', 'NL32-04', NULL, 'PAILLY', 'Pailly', 'Pailly', '010100002015550000AB23948E338C20418A647D4A730A0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516165, 'MS71', 'NL32-05', NULL, 'PALAGNEDRA', 'Palagnedra', 'Palagnedra', '0101000020155500000FA1C43E98202541CC3E536D0942FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516166, 'LS35', 'NL32-04', NULL, 'PALEZIEUX', 'Palézieux', 'Palezieux', '01010000201555000057E18768D1E420414C92485B42FE0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516168, 'LS06', 'NL32-04', NULL, 'PAMPIGNY', 'Pampigny', 'Pampigny', '010100002015550000C39D133510EB1F4145DA63D2E77B0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516169, 'LS42', 'NL32-04', NULL, 'PANEX', 'Panex', 'Panex', '01010000201555000080E56D5C7E512141C98BFF94D12DFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516170, 'NS08', 'NL32-05', NULL, 'PANIX', 'Panix', 'Panix', '010100002015550000301AD4AFE7372641DBC5458CCEC10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516172, 'NS59', 'NL32-05', NULL, 'PANY', 'Pany', 'Pany', '01010000201555000099C411CE50B827413A9B3E84827E0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516173, 'LT80', 'NL32-04', NULL, 'PAPIERMUHLE', 'Papiermühle', 'Papiermuhle', '010100002015550000B64C0DDD136A2241A85ECB452BA00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516177, 'NS06', 'NL32-05', NULL, 'PARDATSCH', 'Pardatsch', 'Pardatsch', '0101000020155500009A9AF8845F27264142E8673B5E430441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516178, 'MS86', 'NL32-05', NULL, 'PARDE', 'Pardè', 'Parde', '01010000201555000067F58FFE8B9B254145BFA12862720441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516179, 'NS47', 'NL32-05', NULL, 'PARPAN', 'Parpan', 'Parpan', '010100002015550000FD523E725C3B2741AAACCC9D202D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516183, 'NT60', 'NL32-05', NULL, 'PARTNUN', 'Partnun', 'Partnun', '0101000020155500006D219F2D89E82741BCBF613B1F320941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516184, 'NS37', 'NL32-05', NULL, 'PASPELS', 'Paspels', 'Paspels', '010100002015550000E6C3B63F130027415AEE4781F9EC0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516186, 'LS25', 'NL32-04', NULL, 'PAUDEX', 'Paudex', 'Paudex', '0101000020155500001C843FEF87802041E917EDB815540241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516189, 'LS48', 'NL32-04', NULL, 'PAYERNE', 'Payerne', 'Payerne', '01010000201555000099918DC83A222141DCA5B014EE9A0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516191, 'MS73', 'NL32-05', NULL, 'PECCIA', 'Peccia', 'Peccia', '0101000020155500001960FA394D272541B5BD809C02060141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516192, 'NR07', 'NL32-08', NULL, 'PEDRINATE', 'Pedrinate', 'Pedrinate', '01010000201555000045984D2A790D26414CBBAEFB00CBF240');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516194, 'NS17', 'NL32-05', NULL, 'PEIDENBAD', 'Peiden Bad', 'Peiden Bad', '010100002015550000F5714030876B2641731D5E07DA6A0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516195, 'NS58', 'NL32-05', NULL, 'PEIST', 'Peist', 'Peist', '0101000020155500009DB6F269507F2741F55FD1F2551C0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516197, 'LS18', 'NL32-04', NULL, 'PENEY', 'Peney', 'Peney', '010100002015550000678750C0853D2041484E4BD52B690641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516198, 'LS26', 'NL32-04', NULL, 'PENEYLEJORAT', 'Peney-le-Jorat', 'Peney-le-Jorat', '010100002015550000247C52876CA92041C00A3300DAE70341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516203, 'LS16', 'NL32-04', NULL, 'PENTHALAZ', 'Penthalaz', 'Penthalaz', '0101000020155500002BE61B1ABE31204112A7C74FC6EC0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516204, 'MT51', 'NL32-02', NULL, 'PERLEN', 'Perlen', 'Perlen', '01010000201555000095982769B8752441A7C9EBC842B60A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516205, 'LT73', 'NL32-01', NULL, 'PERREFITTE', 'Perrefitte', 'Perrefitte', '010100002015550000C2C641F51D1B22411DB6958F6DEC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516206, 'KS94', 'NL32-04', NULL, 'PERROY', 'Perroy', 'Perroy', '010100002015550000BC4A8BD374981F4118944027C5E80141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516207, 'MS93', 'NL32-05', NULL, 'PERSONICO', 'Personico', 'Personico', '01010000201555000062DFB44B07BE25415E285B95779C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516208, 'NS11', 'NL32-05', NULL, 'PERTISE', 'Pertise', 'Pertise', '0101000020155500002CE2A34CD35626418D560BAB17B3FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516209, 'LT62', 'NL32-01', NULL, 'PERY', 'Péry', 'Pery', '010100002015550000CC00B934D6DF21411FC33D0053CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516210, 'LT30', 'NL32-04', NULL, 'PESEUX', 'Peseux', 'Peseux', '0101000020155500008F658F34720521418AD5E298BBDE0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516220, 'NT30', 'NL32-05', NULL, 'PFAFERSDROF', 'Pfäfers Drof', 'Pfafers Drof', '0101000020155500009FE358B19618274167F23E0A671A0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516221, 'LS76', 'NL32-04', NULL, 'PFAFFENRIED', 'Pfaffenried', 'Pfaffenried', '010100002015550000B04F95075B42224178C297E3241A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516222, 'MS67', 'NL32-05', NULL, 'PFAFFENSPRUNG', 'Pfaffensprung', 'Pfaffensprung', '010100002015550000BA8C1C6031052541B5C0899726500541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516225, 'MT82', 'NL32-02', NULL, 'PFAFFIKON', 'Pfäffikon', 'Pfaffikon', '01010000201555000057AE506BA16125413B03F41260E50B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516226, 'MT84', 'NL32-02', NULL, 'PFAFFIKON', 'Pfäffikon', 'Pfaffikon', '010100002015550000F4BD45B10369254140E4395105290E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516227, 'MT13', 'NL32-01', NULL, 'PFAFFNAU', 'Pfaffnau', 'Pfaffnau', '01010000201555000087BE902C7360234157195338CA410C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516229, 'MT33', 'NL32-02', NULL, 'PFEFFIKON', 'Pfeffikon', 'Pfeffikon', '0101000020155500004F4063FCED072441A872F765D7800C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516230, 'LT95', 'NL32-01', NULL, 'PFEFFINGEN', 'Pfeffingen', 'Pfeffingen', '0101000020155500001B279495C3A422411CC39181B02F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516232, 'MT74', 'NL32-02', NULL, 'PFFAFFHAUSEN', 'Pffaffhausen', 'Pffaffhausen', '01010000201555000078B0830DAC0625417EFA894BB2220E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516233, 'MT76', 'NL32-02', NULL, 'PFUNGEN', 'Pfungen', 'Pfungen', '010100002015550000BEE4B9CD850E254135F20E3C34161041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516234, 'MT97', 'NL32-02', NULL, 'PFYN', 'Pfyn', 'Pfyn', '010100002015550000258AF9513DD1254124BE0CC0C2AD1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516235, 'NS00', 'NL32-05', NULL, 'PIANDERA', 'Piandera', 'Piandera', '0101000020155500009742CF0E3F1D26410DE0D69EEC96F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516236, 'NS01', 'NL32-05', NULL, 'PIANEZZO', 'Pianezzo', 'Pianezzo', '010100002015550000FCA8596FB41126410785DDBB25D8FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516237, 'MS62', 'NL32-05', NULL, 'PIANO', 'Piano', 'Piano', '01010000201555000028CD252697D82441CA9B073A2BD8FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516238, 'NS14', 'NL32-05', NULL, 'PIANSANGIACOMO', 'Pian San Giacomo', 'Pian San Giacomo', '010100002015550000C85194DF64852641D1441D48C05A0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516239, 'MS64', 'NL32-05', NULL, 'PIATTO', 'Piatto', 'Piatto', '010100002015550000A7B934F99CF42441BECF83C0B3B00141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516240, 'MS80', 'NL32-05', NULL, 'PIAZZOGNA', 'Piazzogna', 'Piazzogna', '010100002015550000100DFED17E8F25411695907DC5DCFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516244, 'LT72', 'NL32-01', NULL, 'PIETERLEN', 'Pieterlen', 'Pieterlen', '010100002015550000B550F3FD2511224147AE08280C910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516246, 'NS36', 'NL32-05', NULL, 'PIGNIEU', 'Pignieu', 'Pignieu', '010100002015550000EA1F04BE12F926413CCB600FEA1C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516250, 'MS75', 'NL32-05', NULL, 'PIORA', 'Piora', 'Piora', '010100002015550000FF5A4F807D3925418D1F38D264D60241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516251, 'MS75', 'NL32-05', NULL, 'PIOTTA', 'Piotta', 'Piotta', '0101000020155500003FD9EF47B8392541D5BD08B1809C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516253, 'NS17', 'NL32-05', NULL, 'PITASCH', 'Pitasch', 'Pitasch', '010100002015550000571B70277B75264174D6A0FABF6B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516254, 'LS67', 'NL32-04', NULL, 'PLAFFEIEN', 'Plaffeien', 'Plaffeien', '010100002015550000E6EDA852CAF221414D8534C6CDAF0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516256, 'NS43', 'NL32-05', NULL, 'PLANACC', 'Planacc', 'Planacc', '010100002015550000F1A6AB36BE582741763A7CDB3BC20041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516258, 'LR58', 'NL32-07', NULL, 'PLANDELACHAUX', 'Plan-de-la-Chaux', 'Plan-de-la-Chaux', '0101000020155500009749AFE25C962141A0030FD10F50F440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516259, 'LS61', 'NL32-04', NULL, 'PLANFEY', 'Plan Fey', 'Plan Fey', '01010000201555000018583D70C1E7214156DB5C10AAFEFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516260, 'NS44', 'NL32-05', NULL, 'PLANG', 'Plang', 'Plang', '0101000020155500006C1D36D293552741141C01563F910241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516261, 'KS71', 'NL32-04', NULL, 'PLANLESOUATES', 'Plan-les-Ouates', 'Plan-les-Ouates', '010100002015550000CB4C3440A6631E4117CACDB8D3BFFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516262, 'LR69', 'NL32-04', NULL, 'PLANPRO', 'Plan Pro', 'Plan Pro', '010100002015550000E665F3C68CF12141E7C17F1C50ECF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516266, 'LS67', 'NL32-04', NULL, 'PLASSELB', 'Plasselb', 'Plasselb', '010100002015550000EA8A924EDBDE21417C3C8B6714760541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516267, 'MS86', 'NL32-05', NULL, 'PLATTA', 'Platta', 'Platta', '01010000201555000067F58FFE8B9B254145BFA12862720441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516272, 'MT20', 'NL32-02', NULL, 'PLAUNDILSMATTS', 'Plaun dils Matts', 'Plaun dils Matts', '010100002015550000DB8B1ED70E9D234121EDA42DB4180941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516275, 'NS45', 'NL32-05', NULL, 'PLAZBEISCHEN', 'Plaz Beischen', 'Plaz Beischen', '010100002015550000F673C8C7EE71274138A6317F117C0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516276, 'LT75', 'NL32-01', NULL, 'PLEIGNE', 'Pleigne', 'Pleigne', '010100002015550000BAC7365BEAF32141BD807C8805820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516278, 'LS52', 'NL32-04', NULL, 'PONTDENANT', 'Pont-de-Nant', 'Pont-de-Nant', '0101000020155500004FF8EC3A828D2141EC42A5B623D0FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516279, 'NS75', 'NL32-05', NULL, 'PONTE', 'Ponte', 'Ponte', '010100002015550000500F59401D1B28413EA8AF7227CA0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516280, 'MS81', 'NL32-05', NULL, 'PONTEBROLLA', 'Ponte Brolla', 'Ponte Brolla', '0101000020155500001B887DD085662541ABB435B29832FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516283, 'LS48', 'NL32-04', NULL, 'PONTHAUX', 'Ponthaux', 'Ponthaux', '010100002015550000CDDB95D6D95D21416A9A35CC8A990641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516284, 'NS03', 'NL32-05', NULL, 'PONTIRONE', 'Pontirone', 'Pontirone', '0101000020155500001AD14B45E10D264116248B2599DC0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516285, 'MS94', 'NL32-05', NULL, 'PONTOVALENTINO', 'Ponto Valentino', 'Ponto Valentino', '010100002015550000F4B4898622D0254151EB6B4931330241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516286, 'NS64', 'NL32-05', NULL, 'PONTRESINA', 'Pontresina', 'Pontresina', '010100002015550000F4A3331FDD13284178319B62AD6D0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516287, 'LT55', 'NL32-01', NULL, 'PORRENTRUY', 'Porrentruy', 'Porrentruy', '010100002015550000C0529E9A077E21415499E99E78BD0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516288, 'LS36', 'NL32-04', NULL, 'PORSEL', 'Porsel', 'Porsel', '01010000201555000028FCFB7B1BF92041164790B259AB0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516290, 'LS49', 'NL32-04', NULL, 'PORTALBANDESSOUS', 'Portalban- Dessous', 'Portalban- Dessous', '010100002015550000A7CF9975B52C214108ECD41F13F60741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516291, 'KS82', 'NL32-04', NULL, 'PORTDECORSIER', 'Port-de-Corsier', 'Port-de-Corsier', '01010000201555000067E9EFDCF3CA1E41055CE933F36FFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516292, 'MS70', 'NL32-05', NULL, 'PORTORONCO', 'Porto Ronco', 'Porto Ronco', '010100002015550000087A84CA2F5D2541D437FD46EAD5FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516293, 'LS33', 'NL32-04', NULL, 'PORTVALAIS', 'Port-Valais', 'Port-Valais', '010100002015550000377FD665A0F7204130641185CA800041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516296, 'NS83', 'NL32-06', NULL, 'POSCHIAVO', 'Poschiavo', 'Poschiavo', '01010000201555000096DCEDC42372284105F62EC484700041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516302, 'LS73', 'NL32-04', NULL, 'PRACOMBERA', 'Pra Combèra', 'Pra Combera', '0101000020155500002C7ACAF64D4C2241033E4AD21F9CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516303, 'NS82', 'NL32-06', NULL, 'PRADA', 'Prada', 'Prada', '01010000201555000089FCAE2EA57C2841DE586109FE370041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516304, 'PS08', 'NL32-06', NULL, 'PRADELLA', 'Pradella', 'Pradella', '0101000020155500008006242598032941D0D8B06C0ADB0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516305, 'NS48', 'NL32-05', NULL, 'PRADEN', 'Praden', 'Praden', '010100002015550000AB21103C2044274118B2669CD6DB0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516308, 'LS80', 'NL32-04', NULL, 'PRAFLORIC', 'Prafloric', 'Prafloric', '0101000020155500001F963E8BBD8822416F1E9FCC6DD3F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516310, 'NS59', 'NL32-05', NULL, 'PRAGMARTIN', 'Pragmartin', 'Pragmartin', '010100002015550000EF3CAEF9949A2741D607E75E047B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516311, 'LS70', 'NL32-04', NULL, 'PRALONG', 'Pralong', 'Pralong', '0101000020155500004234297D28382241B76078EA992EFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516312, 'LS80', 'NL32-04', NULL, 'PRALOVIN', 'Pralovin', 'Pralovin', '0101000020155500003F98C50694742241CDD9F0851147F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516313, 'NS39', 'NL32-05', NULL, 'PRAMIEISTERS', 'Pramieisters', 'Pramieisters', '01010000201555000027BF259468242741156097FA0AFA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516314, 'KS84', 'NL32-04', NULL, 'PRANGINS', 'Prangins', 'Prangins', '010100002015550000AECCF8D1B00A1F41729DC8453E050141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516315, 'LS61', 'NL32-04', NULL, 'PRARION', 'Prarion', 'Prarion', '01010000201555000032FFD217B1E72141C5FDC1CE1117FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516316, 'LS67', 'NL32-04', NULL, 'PRAROMAN', 'Praroman', 'Praroman', '01010000201555000036D7362818B72141D51FB3946EB00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516318, 'MS84', 'NL32-05', NULL, 'PRATO', 'Prato', 'Prato', '0101000020155500005B968FF7686225418BE907756FF10141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516319, 'MT06', 'NL32-01', NULL, 'PRATTELN', 'Pratteln', 'Pratteln', '010100002015550000B09F682581DF2241B284243FF40B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516322, 'LT50', 'NL32-04', NULL, 'PRAZ', 'Praz', 'Praz', '0101000020155500005383C1AB19862141D3B49DE7FC670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516321, 'NS37', 'NL32-05', NULL, 'PRAZ', 'Präz', 'Praz', '010100002015550000762AC13C99E226417790F1F611B00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516323, 'LR59', 'NL32-07', NULL, 'PRAZDEFORT', 'Praz-de-Fort', 'Praz-de-Fort', '0101000020155500008925EE43A596214173B7E0020F93F640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516325, 'NS55', 'NL32-05', NULL, 'PREDA', 'Preda', 'Preda', '010100002015550000B20A03E455C127419E7FB44326BF0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516326, 'MR99', 'NL32-05', NULL, 'PREGASSONA', 'Pregassona', 'Pregassona', '010100002015550000232B377ABDEB2541F023C4918833F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516327, 'KS82', 'NL32-04', NULL, 'PREGNY', 'Pregny', 'Pregny', '0101000020155500008918E5CFC68D1E4163E2EAC3458CFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516329, 'LT62', 'NL32-01', NULL, 'PRELES', 'Prêles', 'Preles', '010100002015550000CC00B934D6DF21411FC33D0053CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516330, 'KS82', 'NL32-04', NULL, 'PRESINGE', 'Presinge', 'Presinge', '010100002015550000F17AE7634C061F419334CB4DA684FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516331, 'KS82', 'NL32-04', NULL, 'PRIEURE', 'Prieuré', 'Prieure', '01010000201555000097472266ECA01E413C2DB24065A3FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516332, 'LS15', 'NL32-04', NULL, 'PRILLY', 'Prilly', 'Prilly', '010100002015550000C55CDC4ADF4E2041628FE9C0F3C90241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516335, 'LS71', 'NL32-04', NULL, 'PROLIN', 'Prolin', 'Prolin', '010100002015550000469ACF3A2C3822413DD19D713216FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516336, 'NS43', 'NL32-05', NULL, 'PROMONTOGNO', 'Promontogno', 'Promontogno', '0101000020155500002DE8B10E834F2741122E365F634D0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516337, 'MS92', 'NL32-05', NULL, 'PROSITO', 'Prosito', 'Prosito', '01010000201555000095A8F4778BF12541766BB786BDFDFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516338, 'LS29', 'NL32-04', NULL, 'PROVENCE', 'Provence', 'Provence', '0101000020155500009DAF5EF995A120418A0DDC8692860741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516339, 'MS94', 'NL32-05', NULL, 'PRUGIASCO', 'Prugiasco', 'Prugiasco', '0101000020155500006275052A69C62541BE24BDFE8BF80141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516341, 'LS25', 'NL32-04', NULL, 'PUIDOUX', 'Puidoux', 'Puidoux', '01010000201555000037D070247FC62041B4C078B588510241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516343, 'LS15', 'NL32-04', NULL, 'PULLY', 'Pully', 'Pully', '01010000201555000076F1A485AE762041CE8CC60B618E0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48738, 'KS81', 'NL32-04', NULL, 'PUPLINGE', 'Puplinge', 'Puplinge', '010100002015550000F82E580852F11E41CB1635794F9EFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516344, 'MR89', 'NL32-08', NULL, 'PURA', 'Pura', 'Pura', '010100002015550000B1FF259E50B02541C10021054C5BF640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516345, 'MS94', 'NL32-05', NULL, 'PUSCEDDISOPRA', 'Pusced di Sopra', 'Pusced di Sopra', '01010000201555000046E8D6943AC725412551DFDFE14A0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516346, 'MS83', 'NL32-05', NULL, 'PUSCENNEGRO', 'Püscen Negro', 'Puscen Negro', '010100002015550000E7FB988DDC63254140E718DC17960041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516347, 'NT50', 'NL32-05', NULL, 'PUSSEREIN', 'Pusserein', 'Pusserein', '010100002015550000ADCA233B6B8F274184761D8280270941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516348, 'NT11', 'NL32-02', NULL, 'QUARTEN', 'Quarten', 'Quarten', '010100002015550000978C7148B3812641D3BA1525F1A00A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516349, 'MS91', 'NL32-05', NULL, 'QUARTINO', 'Quartino', 'Quartino', '0101000020155500009263519D79B7254158D4C3BD5756FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516353, 'NT11', 'NL32-02', NULL, 'QUINTEN', 'Quinten', 'Quinten', '0101000020155500009FDFBAA39B6D2641F3198A8605D90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516354, 'MS75', 'NL32-05', NULL, 'QUINTO', 'Quinto', 'Quinto', '0101000020155500004D8105C1B34D25410D22D4AAC99D0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516355, 'MS97', 'NL32-05', NULL, 'RABIUS', 'Rabius', 'Rabius', '010100002015550000B4FFA0C281D625414CB73F3081240541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516357, 'LT60', 'NL32-01', NULL, 'RADELFINGEN', 'Radelfingen', 'Radelfingen', '010100002015550000AC13D7105AE921414F5A28754C4E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516358, 'NS45', 'NL32-05', NULL, 'RADONS', 'Radons', 'Radons', '0101000020155500007577022009402741906864C496760341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516359, 'MT67', 'NL32-02', NULL, 'RAFZ', 'Rafz', 'Rafz', '010100002015550000C1712C6278D22441ED69571334C21041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516364, 'MT85', 'NL32-02', NULL, 'RAMISMUHLE', 'Rämismühle', 'Ramismuhle', '010100002015550000DA1574B397712541882AC0FF314B0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516365, 'LT94', 'NL32-01', NULL, 'RAMISWIL', 'Ramiswil', 'Ramiswil', '010100002015550000EACA530A47CC22413075615A99D40D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516366, 'MT88', 'NL32-02', NULL, 'RAMSEN', 'Ramsen', 'Ramsen', '010100002015550000606EBED6987725417CE3C95135581141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516367, 'LS18', 'NL32-04', NULL, 'RANCES', 'Rances', 'Rances', '010100002015550000D5D6FA933F332041F8D9689FD5F50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516368, 'MS00', 'NL32-04', NULL, 'RANDA', 'Randa', 'Randa', '010100002015550000BEB5F0A0D0292341684F925AC2BEF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516370, 'LS83', 'NL32-04', NULL, 'RANDOGNE', 'Randogne', 'Randogne', '010100002015550000F895F5096C74224183F604373C9CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516371, 'MT00', 'NL32-04', NULL, 'RANFLUH', 'Ranflüh', 'Ranfluh', '010100002015550000D37114CF91082341237444A080DB0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516372, 'MS13', 'NL32-04', NULL, 'RANFT', 'Ranft', 'Ranft', '010100002015550000A338AEEAFC502341215E715BC20A0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516373, 'MS49', 'NL32-05', NULL, 'RANFT', 'Ranft', 'Ranft', '010100002015550000FEA69A7CB93C244112DD9DB1204F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516375, 'NT07', 'NL32-02', NULL, 'RAPERSWILEN', 'Raperswilen', 'Raperswilen', '0101000020155500003D1B631AD0F7254190373F4F38E91041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516376, 'LT71', 'NL32-01', NULL, 'RAPPERSWIL', 'Rapperswil', 'Rapperswil', '010100002015550000DBD8713E913822410A46FC81ACC10941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516377, 'MT82', 'NL32-02', NULL, 'RAPPERSWIL', 'Rapperswil', 'Rapperswil', '010100002015550000738B0583F87E254138020F0E50210C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516378, 'MS02', 'NL32-04', NULL, 'RARON', 'Raron', 'Raron', '010100002015550000FDF4D63104292341AB3AACC7502CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516381, 'MS45', 'NL32-05', NULL, 'RATERICHSBODEN', 'Räterichsboden', 'Raterichsboden', '0101000020155500000B10E5093D6724413291E311A4780341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516382, 'MT86', 'NL32-02', NULL, 'RATERSCHEN', 'Räterschen', 'Raterschen', '01010000201555000021797BC9D670254160C1D195E5F80F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516385, 'LS88', 'NL32-04', NULL, 'RATZENBERG', 'Ratzenberg', 'Ratzenberg', '010100002015550000B6BB8168574C224111E6C852D50A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516388, 'MS66', 'NL32-05', NULL, 'REALP', 'Realp', 'Realp', '010100002015550000647AAD0FD6CA24418EF1347082B70341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516389, 'NS37', 'NL32-05', NULL, 'REALTA', 'Realta', 'Realta', '0101000020155500000FE296D52EEC2641299C7872F3EA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516390, 'NS46', 'NL32-05', NULL, 'REAMS', 'Reams', 'Reams', '010100002015550000D12078BCCE5227419510B4FD62260441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516391, 'NT44', 'NL32-02', NULL, 'REBSTEIN', 'Rebstein', 'Rebstein', '01010000201555000066A31F8135402741EA7EB06EC9C60E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516392, 'LS68', 'NL32-04', NULL, 'RECHTHALTEN', 'Rechthalten', 'Rechthalten', '01010000201555000004203A3AEDDE2141EF7EE40CE1E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516393, 'MS44', 'NL32-05', NULL, 'RECKINGEN', 'Reckingen', 'Reckingen', '0101000020155500001DAF100E632C2441924B331CCBE00141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516395, 'LT63', 'NL32-01', NULL, 'RECONVILIER', 'Reconvilier', 'Reconvilier', '0101000020155500006F5C8CC42FCC21415140523D573F0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516397, 'MT55', 'NL32-02', NULL, 'REGENSBERG', 'Regensberg', 'Regensberg', '01010000201555000038DB0218359924416CBA43CB07B20F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516398, 'MT55', 'NL32-02', NULL, 'REGENSDORF', 'Regensdorf', 'Regensdorf', '010100002015550000CE435B1667AD24417E4BAE9E54050F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516399, 'NT35', 'NL32-02', NULL, 'REHETOBEL', 'Rehetobel', 'Rehetobel', '0101000020155500000A99C261E0042741A222AF6F60FA0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516400, 'NS38', 'NL32-05', NULL, 'REICHENAU', 'Reichenau', 'Reichenau', '010100002015550000A589E7676DE02641206466735C0B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516401, 'MS06', 'NL32-04', NULL, 'REICHENBACH', 'Reichenbach', 'Reichenbach', '0101000020155500002583AB9EE8EB2241D6934AC845E10341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516402, 'MT92', 'NL32-02', NULL, 'REICHENBURG', 'Reichenburg', 'Reichenburg', '0101000020155500002B5660CE70E2254100320437FB7A0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516403, 'MT23', 'NL32-01', NULL, 'REIDEN', 'Reiden', 'Reiden', '01010000201555000008F1E0D4CA872341081831F7AF7C0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516404, 'MT05', 'NL32-01', NULL, 'REIGOLDSWIL', 'Reigoldswil', 'Reigoldswil', '01010000201555000012C55BCDD1DF2241D2E818508C820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516405, 'MT33', 'NL32-02', NULL, 'REINACH', 'Reinach', 'Reinach', '01010000201555000065ADBBD4CA07244148241C8ABEBA0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516408, 'NS36', 'NL32-05', NULL, 'REISCHEN', 'Reischen', 'Reischen', '010100002015550000D6A5A63FAC022741604F6304D0570441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516410, 'MT46', 'NL32-02', NULL, 'REKINGEN', 'Rekingen', 'Rekingen', '010100002015550000B2A06E6CB453244184B4FD7924681041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516411, 'MT91', 'NL32-02', NULL, 'REMPEN', 'Rempen', 'Rempen', '0101000020155500007EAF8374A0B12541F7DBEE3E69030B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516412, 'PS08', 'NL32-06', NULL, 'REMUS', 'Remüs', 'Remus', '0101000020155500006240E4A73D2A29418373EA1BA9540741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516413, 'LT42', 'NL32-01', NULL, 'RENAN', 'Renan', 'Renan', '0101000020155500003DE4A5D6071A214126EBBDCC65AD0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516414, 'LS15', 'NL32-04', NULL, 'RENENS', 'Renens', 'Renens', '010100002015550000C55CDC4ADF4E2041628FE9C0F3C90241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516419, 'LS63', 'NL32-04', NULL, 'REUSCH', 'Reusch', 'Reusch', '010100002015550000C6F3082F16DE2141E5F12EED4E7C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516421, 'LS97', 'NL32-04', NULL, 'REUTIGEN', 'Reutigen', 'Reutigen', '0101000020155500001FCB8922E0B92241BCD9071536020541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516431, 'NS38', 'NL32-05', NULL, 'RHAZUNS', 'Rhäzüns', 'Rhazuns', '010100002015550000B68DEDAE26E12641AC2307DB98970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516433, 'MT67', 'NL32-02', NULL, 'RHEINAU', 'Rheinau', 'Rheinau', '0101000020155500004AB8CBC968F92441B07AA93748E01041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516434, 'NT45', 'NL32-02', NULL, 'RHEINECK', 'Rheineck', 'Rheineck', '010100002015550000E8FA8C3DA03E2741759A32A055AE0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516436, 'MT06', 'NL32-01', NULL, 'RHEINFELDEN', 'Rheinfelden', 'Rheinfelden', '010100002015550000D2763954391A2341E73886044E461041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516460, 'LS56', 'NL32-04', NULL, 'RIAZ', 'Riaz', 'Riaz', '0101000020155500007C2439AEF7702141A266DB23421C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516461, 'MT16', 'NL32-01', NULL, 'RIBURG', 'Riburg', 'Riburg', '010100002015550000ECBD9D4C8E3723418FC91E5689631041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516463, 'MT12', 'NL32-01', NULL, 'RICHENTHAL', 'Richenthal', 'Richenthal', '010100002015550000BFFD03CC42742341EA649CCD5D080C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516464, 'LS99', 'NL32-04', NULL, 'RICHIGEN', 'Richigen', 'Richigen', '010100002015550000AF64FACDA3A52241AFDC0541D9B80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516465, 'MT90', 'NL32-02', NULL, 'RICHISAU', 'Richisau', 'Richisau', '0101000020155500005EB8339983B3254166DCA168296E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516466, 'MT72', 'NL32-02', NULL, 'RICHTERSWIL', 'Richterswil', 'Richterswil', '01010000201555000093F71625F0392541DC3A3EF9AA1C0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516467, 'NT03', 'NL32-02', NULL, 'RICKEN', 'Ricken', 'Ricken', '0101000020155500007D36366149FE25417B90EA5BB5D80C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516468, 'NT05', 'NL32-02', NULL, 'RICKENBACH', 'Rickenbach', 'Rickenbach', '010100002015550000860F0036DE042641AE4B00865B560F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516469, 'MT86', 'NL32-02', NULL, 'RICKENBACH', 'Rickenbach', 'Rickenbach', '010100002015550000514747DE15702541B5E2D1F74C531041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516470, 'LS61', 'NL32-04', NULL, 'RIDDES', 'Riddes', 'Riddes', '010100002015550000CD70300E9CD321413FA40CA7418BFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516471, 'MR09', 'NL32-04', NULL, 'RIED', 'Ried', 'Ried', '010100002015550000ED4A741ED60B23419792AFAE88EEF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516472, 'MS22', 'NL32-05', NULL, 'RIED', 'Ried', 'Ried', '010100002015550000909C354754AB2341FBB4082559A6FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516473, 'MS34', 'NL32-05', NULL, 'RIED', 'Ried', 'Ried', '010100002015550000FA25C491A604244113FB7CF0726B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516474, 'LT60', 'NL32-04', NULL, 'RIED', 'Ried', 'Ried', '01010000201555000077C22F7EA9B721417399FA0E3C670841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516475, 'LS79', 'NL32-04', NULL, 'RIEDBACH', 'Riedbach', 'Riedbach', '010100002015550000AE602EA9DA102241EFCD9F1C822C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516479, 'MS09', 'NL32-04', NULL, 'RIEDBERGLI', 'Riedbergli', 'Riedbergli', '0101000020155500006C406777D3FE2241CAFBF57EA52D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516483, 'LT70', 'NL32-04', NULL, 'RIEDERN', 'Riedern', 'Riedern', '0101000020155500004A356BDBB22422410C04E4AC51660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516484, 'LT93', 'NL32-01', NULL, 'RIEDHOLZ', 'Riedholz', 'Riedholz', '010100002015550000B166E3BE459B2241B668C212EE040C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516486, 'LS86', 'NL32-04', NULL, 'RIEDLI', 'Riedli', 'Riedli', '010100002015550000C5429FF9317E2241B1163CF653E00341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516487, 'MS79', 'NL32-05', NULL, 'RIEDLIG', 'Riedlig', 'Riedlig', '010100002015550000E46AA12F3352254114A50390F3D10741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516488, 'LS78', 'NL32-04', NULL, 'RIEDSTATT', 'Riedstätt', 'Riedstatt', '01010000201555000018A75304BC0622414AC9B12976230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (19205, 'MD45', 'NN32-11', 3, 'RIEHEN', 'Riehen', 'Riehen', '01010000201555000080BDAB3782D0234165AEB47872482A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516489, 'NS17', 'NL32-05', NULL, 'RIEIN', 'Riein', 'Riein', '01010000201555000095ACBB531A7F2641A261F66E8AA60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516490, 'MS79', 'NL32-05', NULL, 'RIEMENSTALDEN', 'Riemenstalden', 'Riemenstalden', '010100002015550000BC9CB3BED6292541546845F1147D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516493, 'LS78', 'NL32-04', NULL, 'RIFFENMATT', 'Riffenmatt', 'Riffenmatt', '01010000201555000012A20CB29A1A2241E67B814174E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516495, 'LS88', 'NL32-04', NULL, 'RIGGISBERG', 'Riggisberg', 'Riggisberg', '010100002015550000A29B11E1376022416BCAB499245D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516497, 'MT51', 'NL32-02', NULL, 'RIGIKALTBAD', 'Rigi Kaltbad', 'Rigi Kaltbad', '010100002015550000360AB2A4C3B1244135AF09D49FD10941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516501, 'MT85', 'NL32-02', NULL, 'RIKON', 'Rikon', 'Rikon', '010100002015550000C707131EC6672541E24FEE97844A0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516504, 'MS17', 'NL32-04', NULL, 'RINGGENBERG', 'Ringgenberg', 'Ringgenberg', '01010000201555000008105E8A2B63234137AE6CE4F6040541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516505, 'NS07', 'NL32-05', NULL, 'RINGGENBERG', 'Ringgenberg', 'Ringgenberg', '010100002015550000FBB86E00CDF325412C3EEBE09E9A0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516506, 'LS86', 'NL32-04', NULL, 'RINGOLDINGEN', 'Ringoldingen', 'Ringoldingen', '010100002015550000D6AC2AB02A7E22410D73C64120540441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516509, 'LS74', 'NL32-04', NULL, 'RISCH', 'Risch', 'Risch', '010100002015550000D9A8DFFD3E102241D577CC27A0290141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516517, 'MS12', 'NL32-04', NULL, 'RITTI', 'Ritti', 'Ritti', '010100002015550000CB6195D96151234155C18EA88AD2FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516518, 'MS12', 'NL32-04', NULL, 'RITTI', 'Ritti', 'Ritti', '010100002015550000CF6B35A0546F2341EAF37B7185BBFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516520, 'MS44', 'NL32-05', NULL, 'RITZINGEN', 'Ritzingen', 'Ritzingen', '0101000020155500005F01F391882C24417EFA4ED0E5A60141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516523, 'MR98', 'NL32-08', NULL, 'RIVASANVITALE', 'Riva San Vitale', 'Riva San Vitale', '010100002015550000106F8EE6FEED25410D6370185095F440');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516524, 'LR59', 'NL32-04', NULL, 'RIVEHAUTE', 'Rive Haute', 'Rive Haute', '0101000020155500008F27EBAFE0AA2141ED5823E84206F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516525, 'MS72', 'NL32-05', NULL, 'RIVEO', 'Riveo', 'Riveo', '010100002015550000878F38E1D41E2541936573BC4EE0FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516529, 'MS90', 'NL32-05', NULL, 'ROBASACCO', 'Robasacco', 'Robasacco', '0101000020155500004BAFDB51DDCB254196B8C04A90E5FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516530, 'LS33', 'NL32-04', NULL, 'ROCHE', 'Roche', 'Roche', '01010000201555000000ECF7ABAF1521410DBF9D65F37F0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516533, 'LT73', 'NL32-01', NULL, 'ROCHES', 'Roches', 'Roches', '01010000201555000003DE3244D42E2241D287EFBB42260D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516535, 'NS37', 'NL32-05', NULL, 'RODELS', 'Rodels', 'Rodels', '010100002015550000B2A1FE407FF6264155E35BDA13B20541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516536, 'LT86', 'NL32-01', NULL, 'RODERSDORF', 'Rodersdorf', 'Rodersdorf', '010100002015550000FD46F40433562241985275CB32A30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516537, 'MS74', 'NL32-05', NULL, 'RODI', 'Rodi', 'Rodi', '010100002015550000A1ED63BF2B582541338BE151A92A0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516538, 'NS35', 'NL32-05', NULL, 'ROFFLASCHLUCHT', 'Rofflaschlucht', 'Rofflaschlucht', '010100002015550000E641D316D5EF26413CCE05A224A80341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516539, 'NS45', 'NL32-05', NULL, 'ROFFNA', 'Roffna', 'Roffna', '01010000201555000098F300F65A682741A1A4053D14410341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516541, 'MT13', 'NL32-01', NULL, 'ROGGWIL', 'Roggwil', 'Roggwil', '0101000020155500001BA0C466262F234168058096BC400C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516542, 'NT26', 'NL32-02', NULL, 'ROGGWIL', 'Roggwil', 'Roggwil', '0101000020155500008EE3E7BB24C82641E8571E10EB0A1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516543, 'MT25', 'NL32-01', NULL, 'ROHR', 'Rohr', 'Rohr', '010100002015550000DA815956167D2341AC4DD5DD92850E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516544, 'MT02', 'NL32-01', NULL, 'ROHRBACH', 'Rohrbach', 'Rohrbach', '010100002015550000A77E6272B02523411242461521E50A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516546, 'MS37', 'NL32-05', NULL, 'ROHRMATTEN', 'Rohrmatten', 'Rohrmatten', '010100002015550000C79A4C5E47162441FC929A9771440541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516547, 'KS94', 'NL32-04', NULL, 'ROLLE', 'Rolle', 'Rolle', '0101000020155500001A9BE91674701F41E8E2D4CEE1E90141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516548, 'LS07', 'NL32-04', NULL, 'ROMAINMOTIER', 'Romainmôtier', 'Romainmotier', '0101000020155500002F548766BF0A20418799232329100541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516549, 'LS05', 'NL32-04', NULL, 'ROMANEL', 'Romanel', 'Romanel', '010100002015550000C8EB9A791627204104C4C012A9050341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516550, 'LS15', 'NL32-04', NULL, 'ROMANEL', 'Romanel', 'Romanel', '01010000201555000090F2E4C82B592041C2291AA84F3D0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516552, 'NT26', 'NL32-02', NULL, 'ROMANSHORN', 'Romanshorn', 'Romanshorn', '010100002015550000CD04F23EB5C6264138F08C20B47E1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516553, 'LS68', 'NL32-04', NULL, 'ROMERSWIL', 'Römerswil', 'Romerswil', '010100002015550000791E1F6130B72141154AB31F3B240641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516554, 'MT42', 'NL32-02', NULL, 'ROMERSWIL', 'Römerswil', 'Romerswil', '010100002015550000571CE56B3B262441E0F60A327E600B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516555, 'LS47', 'NL32-04', NULL, 'ROMONT', 'Romont', 'Romont', '010100002015550000A66909F69D172141066D1BACE6050541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516557, 'NR08', 'NL32-08', NULL, 'RONCAPIANO', 'Roncapiano', 'Roncapiano', '01010000201555000004EBA2521E1626417BC681C1860FF540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516558, 'MS71', 'NL32-05', NULL, 'RONCO', 'Ronco', 'Ronco', '010100002015550000F3D4B6A4F25C25415F380D85B249FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516559, 'MS64', 'NL32-05', NULL, 'RONCO', 'Ronco', 'Ronco', '0101000020155500008DBCE7C202CC24416C07DA19265C0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516561, 'LT62', 'NL32-01', NULL, 'RONDCHATEL', 'Rondchâtel', 'Rondchatel', '010100002015550000651EA03ECDDF21415A8E117E6B910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516562, 'NS36', 'NL32-05', NULL, 'RONGELLEN', 'Rongellen', 'Rongellen', '010100002015550000B6DAB11AF8F72641F79DEE238ECA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516564, 'MT51', 'NL32-02', NULL, 'ROOT', 'Root', 'Root', '010100002015550000368D5123F37F244185B28C2FEF420A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516565, 'LS26', 'NL32-04', NULL, 'ROPRAZ', 'Ropraz', 'Ropraz', '01010000201555000027C346C565B32041DFD702167FE70341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516566, 'MT66', 'NL32-02', NULL, 'RORBAS', 'Rorbas', 'Rorbas', '010100002015550000E55B862CE4F024418C034A5B47321041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516572, 'NT35', 'NL32-02', NULL, 'ROSCHACH', 'Roschach', 'Roschach', '0101000020155500004DFF02EB8E0D27417827334012A90F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516573, 'LT85', 'NL32-01', NULL, 'ROSCHENZ', 'Röschenz', 'Roschenz', '010100002015550000CAA2D97E34562241467CD2CE78F50E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516576, 'LT83', 'NL32-01', NULL, 'ROSEGG', 'Rosegg', 'Rosegg', '010100002015550000F3F75FD0AE7D22410280849FC6040C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516577, 'NS13', 'NL32-05', NULL, 'ROSSA', 'Rossa', 'Rossa', '01010000201555000034549518484A26413E8C7FE2C0A70041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516579, 'LS57', 'NL32-04', NULL, 'ROSSENS', 'Rossens', 'Rossens', '0101000020155500000C34E6F8388521413D2C9CD5633D0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516580, 'LS69', 'NL32-04', NULL, 'ROSSHAUSERN', 'Rosshäusern', 'Rosshausern', '01010000201555000083A8490729E92141D014DCCFE3F20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516581, 'LS54', 'NL32-04', NULL, 'ROSSINIERE', 'Rossinière', 'Rossiniere', '0101000020155500006BBCF2D1477A21414148A95217D90141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516582, 'MS84', 'NL32-05', NULL, 'ROSSURA', 'Rossura', 'Rossura', '010100002015550000AE1B0C2E6994254151D7B584E2F40141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516588, 'LS96', 'NL32-04', NULL, 'ROTHBAD', 'Rothbad', 'Rothbad', '01010000201555000023B7C6FB1D9C2241FE32EADB7BE00341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516589, 'MS08', 'NL32-04', NULL, 'ROTHENBACH', 'Röthenbach', 'Rothenbach', '0101000020155500005DB6C2E218FF224102E53EF0240C0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516591, 'NS37', 'NL32-05', NULL, 'ROTHENBRUNNEN', 'Rothenbrunnen', 'Rothenbrunnen', '01010000201555000074A39268D1EB26413416C718D5240641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516592, 'MT71', 'NL32-02', NULL, 'ROTHENTHURM', 'Rothenthurm', 'Rothenthurm', '0101000020155500007B94A4F7AE31254154BDADDCC2860A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516593, 'MT41', 'NL32-02', NULL, 'ROTHERNBURG', 'Rothernburg', 'Rothernburg', '010100002015550000345A3A37963A24412C6EAD2FB5790A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516595, 'MT13', 'NL32-01', NULL, 'ROTHRIST', 'Rothrist', 'Rothrist', '010100002015550000F392611F1C6023413EAFD47868290D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516598, 'NS43', 'NL32-05', NULL, 'ROTICCIO', 'Roticcio', 'Roticcio', '010100002015550000123BDAB3CA7627412924082C8FC50041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516599, 'MT52', 'NL32-02', NULL, 'ROTKREUZ', 'Rotkreuz', 'Rotkreuz', '01010000201555000018496787E09C24410CD6E7CBFE2B0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516600, 'MS72', 'NL32-05', NULL, 'ROTONDA', 'Rotonda', 'Rotonda', '010100002015550000DC4E1D18CC142541B05CD9FC17DFFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516607, 'LS64', 'NL32-04', NULL, 'ROUGEMONT', 'Rougemont', 'Rougemont', '010100002015550000834DAAA555CA2141E099449ECE110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516609, 'NS11', 'NL32-05', NULL, 'ROVEREDO', 'Roveredo', 'Roveredo', '010100002015550000F78F9573C84C2641396DFF1859B1FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516610, 'MR98', 'NL32-08', NULL, 'ROVIO', 'Rovio', 'Rovio', '0101000020155500007C054FA1D0F7254192FF85ABAC0AF540');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516611, 'LS28', 'NL32-04', NULL, 'ROVRAY', 'Rovray', 'Rovray', '0101000020155500003F93910D9DBE204136E453701F2A0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516616, 'LS89', 'NL32-04', NULL, 'RUBIGEN', 'Rubigen', 'Rubigen', '0101000020155500000A1B00F9DF872241D9FBD916ABB80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516618, 'MT00', 'NL32-04', NULL, 'RUDERSWIL', 'Rüderswil', 'Ruderswil', '010100002015550000F30783D0A9FE2241FEE0A78A59DB0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516619, 'MT67', 'NL32-02', NULL, 'RUDLINGEN', 'Rüdlingen', 'Rudlingen', '01010000201555000044A3F89876E62441C215A923DA881041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516620, 'MT54', 'NL32-02', NULL, 'RUDOLFSTETTEN', 'Rudolfstetten', 'Rudolfstetten', '010100002015550000904F0DD1FC7C2441E95EE8483F1B0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516621, 'LS36', 'NL32-04', NULL, 'RUE', 'Rue', 'Rue', '010100002015550000572526C54ADB20410628332329E60341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516622, 'LS88', 'NL32-04', NULL, 'RUEGGISBERG', 'Rüeggisberg', 'Rueggisberg', '01010000201555000016564ED1564C22410E3F035E08970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516623, 'MS77', 'NL32-05', NULL, 'RUERAS', 'Ruèras', 'Rueras', '0101000020155500007D60765D81362541944847E5FCC60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516625, 'NS18', 'NL32-05', NULL, 'RUEUN', 'Rueun', 'Rueun', '010100002015550000254492EB674C2641D69B414CC04F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516626, 'LS46', 'NL32-04', NULL, 'RUEYRES', 'Rueyres', 'Rueyres', '010100002015550000E8446C3B432B214149EF8E2EB1570441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516628, 'NT02', 'NL32-02', NULL, 'RUFI', 'Rufi', 'Rufi', '01010000201555000048F05308A0092641DE591ECE0CB80B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516630, 'NS17', 'NL32-05', NULL, 'RUIS', 'Ruis', 'Ruis', '0101000020155500005FB8A2BFB84C264101EB7C84DD150641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516631, 'MT56', 'NL32-02', NULL, 'RUMIKON', 'Rümikon', 'Rumikon', '010100002015550000736B963B19712441662359A5D1681041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516632, 'MT65', 'NL32-02', NULL, 'RUMLANG', 'Rümlang', 'Rumlang', '010100002015550000AE0299697DD4244194CECCFA5B410F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516633, 'MT15', 'NL32-01', NULL, 'RUNENBERG', 'Rünenberg', 'Runenberg', '0101000020155500008E49F54F9B5523419C67A04C6EF80E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516634, 'NT34', 'NL32-02', NULL, 'RUPPEN', 'Ruppen', 'Ruppen', '010100002015550000463701D0750F274130131317A1870E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516635, 'MT35', 'NL32-02', NULL, 'RUPPERSWIL', 'Rupperswil', 'Rupperswil', '01010000201555000018C5B52A14E923419E3CA5FBCCC20E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516637, 'LS78', 'NL32-04', NULL, 'RUSCHEGG', 'Rüschegg', 'Ruschegg', '0101000020155500002C4D634F73382241F3460A6841230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516638, 'LS78', 'NL32-04', NULL, 'RUSCHEGGGRABEN', 'Rüschegg-Graben', 'Ruschegg-Graben', '0101000020155500006C794C2E75382241969647D8275D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516639, 'NS18', 'NL32-05', NULL, 'RUSCHEIN', 'Ruschein', 'Ruschein', '0101000020155500003BBB146D3A6A2641D157954F64520641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516640, 'MT63', 'NL32-02', NULL, 'RUSCHLIKON', 'Rüschlikon', 'Ruschlikon', '01010000201555000028115D8027E0244106AF5928CC380D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516643, 'MT84', 'NL32-02', NULL, 'RUSSIKON', 'Russikon', 'Russikon', '010100002015550000C0CC5473EF5E2541B83639E23F620E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516644, 'KS61', 'NL32-04', NULL, 'RUSSIN', 'Russin', 'Russin', '01010000201555000020FDB54082EB1D41866AF5E20E3CFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516645, 'MT52', 'NL32-02', NULL, 'RUSTENSCHWIL', 'Rüstenschwil', 'Rustenschwil', '0101000020155500009290D47FB17424411475C52CA9110C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516646, 'MT31', 'NL32-02', NULL, 'RUSWIL', 'Ruswil', 'Ruswil', '01010000201555000084A0E6D2C0E123414460C5B2643C0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516648, 'NT43', 'NL32-02', NULL, 'RUTHI', 'Rüthi', 'Ruthi', '010100002015550000453605010D252741384E9B2448680D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516649, 'NS09', 'NL32-05', NULL, 'RUTI', 'Rüti', 'Ruti', '010100002015550000FAB1B3F541FA2541C6D969AF14520841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516650, 'LT72', 'NL32-01', NULL, 'RUTI', 'Rüti', 'Ruti', '010100002015550000B3DD66789C38224153388FBA171D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516651, 'MT83', 'NL32-02', NULL, 'RUTI', 'Rüti', 'Ruti', '01010000201555000099B62C592C9225418EC04FA881960C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516653, 'MT60', 'NL32-05', NULL, 'RUTLI', 'Rütli', 'Rutli', '010100002015550000418679BDFA0125413549C0FC8FB40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516654, 'LT80', 'NL32-04', NULL, 'RUTTI', 'Rütti', 'Rutti', '010100002015550000748D3ECC2960224110D58F750DDA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516660, 'LS64', 'NL32-04', NULL, 'SAANEN', 'Saanen', 'Saanen', '0101000020155500006A269DE754DE214125521CC098110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516661, 'LS65', 'NL32-04', NULL, 'SAANENMOSER', 'Saanenmöser', 'Saanenmoser', '01010000201555000086D2980061FC2141BB68C46424850241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516662, 'NS69', 'NL32-05', NULL, 'SAAS', 'Saas', 'Saas', '010100002015550000BAF816CE92CC27414CC31D7A01470841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516663, 'MS10', 'NL32-04', NULL, 'SAASALMAGEL', 'Saas-Almagel', 'Saas-Almagel', '0101000020155500002B60011770842341E0E61F3AC9C2F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516664, 'MS11', 'NL32-04', NULL, 'SAASBALEN', 'Saas-Balen', 'Saas-Balen', '01010000201555000096BB4A07097023419FB376BA281DFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516666, 'MS10', 'NL32-04', NULL, 'SAASFEE', 'Saas-Fee', 'Saas-Fee', '0101000020155500003BFD5D21367023417940584F9135FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516667, 'MS10', 'NL32-04', NULL, 'SAASGRUND', 'Saas-Grund', 'Saas-Grund', '01010000201555000051C66E0A477A23410055B3F61036FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516670, 'MS63', 'NL32-05', NULL, 'SABBIONE', 'Sabbione', 'Sabbione', '0101000020155500008BFA2750A7F524419A3ABB683D8F0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516671, 'MS49', 'NL32-05', NULL, 'SACHSELN', 'Sachseln', 'Sachseln', '010100002015550000883D46B4DE28244122E3EB884E4E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516673, 'LS71', 'NL32-04', NULL, 'SACLENTSE', 'Saclentse', 'Saclentse', '01010000201555000009BD2013E505224151E39A76698AFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516675, 'MT24', 'NL32-01', NULL, 'SAFENWIL', 'Safenwil', 'Safenwil', '01010000201555000007D4DA5B3F91234132CCBB0393640D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516676, 'NS27', 'NL32-05', NULL, 'SAFIENPLATZ', 'Safien Platz', 'Safien Platz', '010100002015550000A39AEC97EEA72641C306B1079AFC0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516680, 'MS33', 'NL32-05', NULL, 'SAFLISCHMATTEN', 'Saflischmatten', 'Saflischmatten', '0101000020155500000DE2B96452052441AF598E17F8490041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516681, 'LS86', 'NL32-04', NULL, 'SAGE', 'Säge', 'Sage', '010100002015550000F975A8DC29922241F9D77A3B86A60341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516683, 'MS08', 'NL32-04', NULL, 'SAGE', 'Säge', 'Sage', '010100002015550000E5619DBD241D23413DA6A1AC07250641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516688, 'NS56', 'NL32-05', NULL, 'SAGLIAZ', 'Sagliaz', 'Sagliaz', '01010000201555000064CB1AC281B6274168E2D478B7310441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516689, 'NS18', 'NL32-05', NULL, 'SAGOGN', 'Sagogn', 'Sagogn', '01010000201555000031EDED44B78726416AB81245FE8E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516690, 'LT63', 'NL32-01', NULL, 'SAICOURT', 'Saicourt', 'Saicourt', '01010000201555000069E826E85EC22141C68779B15C790C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516691, 'LT43', 'NL32-01', NULL, 'SAIGNELEGIER', 'Saignelégier', 'Saignelegier', '0101000020155500004217AF59164C21412E263152697B0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516692, 'LS51', 'NL32-04', NULL, 'SAILLON', 'Saillon', 'Saillon', '0101000020155500007BD73A4470B5214165596BE9F78BFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516693, 'LS29', 'NL32-04', NULL, 'SAINTAUBIN', 'Saint-Aubin', 'Saint-Aubin', '010100002015550000FEA562E05BBF20418E7DD62183850741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516694, 'LS49', 'NL32-04', NULL, 'SAINTAUBIN', 'Saint-Aubin', 'Saint-Aubin', '01010000201555000066205E398A36214124BE5B5CEEBB0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516697, 'LT40', 'NL32-01', NULL, 'SAINTBLAISE', 'Saint-Blaise', 'Saint-Blaise', '01010000201555000064C426110D412141CCE759F5FF500941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516698, 'LT54', 'NL32-01', NULL, 'SAINTBRAIS', 'Saint-Brais', 'Saint-Brais', '010100002015550000DE480FC4439121418FAFD7E5C8270D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516699, 'KS84', 'NL32-04', NULL, 'SAINTCERGUE', 'Saint-Cergue', 'Saint-Cergue', '010100002015550000102F6E2DF9A71E4194DC66960FB60141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516702, 'LS08', 'NL32-04', NULL, 'SAINTECROIX', 'Sainte-Croix', 'Sainte-Croix', '010100002015550000E2DB44A8E01F20413493366F75A40641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516708, 'LS72', 'NL32-04', NULL, 'SAINTGERMAIN', 'Saint-Germain', 'Saint-Germain', '010100002015550000D092E472171A2241148ED84B2ECDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516710, 'LS33', 'NL32-04', NULL, 'SAINTGINGOLPH', 'Saint-Gingolph', 'Saint-Gingolph', '010100002015550000A54A1450AACF204172396959EDBB0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516719, 'LT42', 'NL32-01', NULL, 'SAINTIMIER', 'Saint-Imier', 'Saint-Imier', '010100002015550000329791AE994B2141FDA8FD61FD1F0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516723, 'LS91', 'NL32-04', NULL, 'SAINTJEAN', 'Saint-Jean', 'Saint-Jean', '010100002015550000325EE02CC1A62241A354BE8A2D72FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516724, 'LS72', 'NL32-04', NULL, 'SAINTLEONARD', 'Saint-Léonard', 'Saint-Leonard', '01010000201555000050883D204242224150D2EC48F3CCFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516725, 'KS95', 'NL32-04', NULL, 'SAINTLIVRES', 'Saint-Livres', 'Saint-Livres', '0101000020155500001FC902B4A0AD1F415A759D2EE8950241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516726, 'LS91', 'NL32-04', NULL, 'SAINTLUC', 'Saint-Luc', 'Saint-Luc', '010100002015550000BC98E79FC6B022417CF408A221E6FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516727, 'LS71', 'NL32-04', NULL, 'SAINTMARTIN', 'Saint-Martin', 'Saint-Martin', '010100002015550000DC945A4F4B4C2241C323ADB5F289FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516729, 'LS42', 'NL32-04', NULL, 'SAINTMAURICE', 'Saint-Maurice', 'Saint-Maurice', '010100002015550000BE11DE340E4721416166FB8248EBFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516733, 'LS61', 'NL32-04', NULL, 'SAINTPIERREDECLAGES', 'Saint-Pierre-de-Clages', 'Saint-Pierre-de-Clages', '01010000201555000003C0BACDA5D3214133B13DA50DFFFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516734, 'LS05', 'NL32-04', NULL, 'SAINTPREX', 'Saint-Prex', 'Saint-Prex', '010100002015550000A37631A569082041474E0245881F0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516735, 'LS72', 'NL32-04', NULL, 'SAINTROMAIN', 'Saint-Romain', 'Saint-Romain', '010100002015550000D275914A44422241A71887668BB4FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516736, 'LS15', 'NL32-04', NULL, 'SAINTSULPICE', 'Saint-Sulpice', 'Saint-Sulpice', '010100002015550000101233EDB84420418A3F10777F900241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516737, 'LS19', 'NL32-04', NULL, 'SAINTSULPICE', 'Saint-Sulpice', 'Saint-Sulpice', '010100002015550000784B930F9748204141F01FDE00FE0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516738, 'LT64', 'NL32-01', NULL, 'SAINTURSANNE', 'Saint-Ursanne', 'Saint-Ursanne', '01010000201555000096960E8F2CA521418D1E77191A0F0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516739, 'MS90', 'NL32-05', NULL, 'SALA', 'Sala', 'Sala', '0101000020155500008C08DD90F4CC2541156289467416F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516740, 'MT84', 'NL32-02', NULL, 'SALAND', 'Saland', 'Saland', '010100002015550000B9D64D0B17902541B2ADFAAFAE650E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516744, 'NS45', 'NL32-05', NULL, 'SALATEGNAS', 'Salategnas', 'Salategnas', '010100002015550000D56BCACF227D274126C28D1C90CF0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516745, 'LS46', 'NL32-04', NULL, 'SALES', 'Sâles', 'Sales', '01010000201555000047E1C79924352141760D30978C1D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516746, 'NT33', 'NL32-02', NULL, 'SALEZ', 'Salez', 'Salez', '0101000020155500004BE0AF2DE2122741F42E490DA77E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516747, 'LS93', 'NL32-04', NULL, 'SALGESCH', 'Salgesch', 'Salgesch', '010100002015550000A715419C91A62241983BBFF4C19CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516750, 'NT26', 'NL32-02', NULL, 'SALMSACH', 'Salmsach', 'Salmsach', '010100002015550000605123AA44BD2641043606EB45611041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516752, 'NS46', 'NL32-05', NULL, 'SALUX', 'Salux', 'Salux', '010100002015550000A405697069522741F96EC48443600441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516753, 'LS40', 'NL32-04', NULL, 'SALVAN', 'Salvan', 'Salvan', '0101000020155500006CB9127BA250214168FD74871034FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516754, 'NS65', 'NL32-05', NULL, 'SAMADEN', 'Samaden', 'Samaden', '0101000020155500009C452C5188FE274149763504CC180341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516761, 'MS74', 'NL32-05', NULL, 'SAMBUCODIFUORI', 'Sambuco di Fuori', 'Sambuco di Fuori', '01010000201555000018796D676826254151C4E09C93ED0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516763, 'PS09', 'NL32-06', NULL, 'SAMNAUN', 'Samnaun', 'Samnaun', '010100002015550000D8C52C052A132941BFEEAF2CDCAC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516764, 'MT72', 'NL32-02', NULL, 'SAMSTAGERN', 'Samstagern', 'Samstagern', '010100002015550000A10D1F444E3025417031F0EF23E20B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516765, 'NS14', 'NL32-05', NULL, 'SANBERNARDINO', 'San Bernardino', 'San Bernardino', '0101000020155500009BD7EC3DBA702641950B031CB4CC0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516768, 'NS73', 'NL32-06', NULL, 'SANCARLO', 'San Carlo', 'San Carlo', '0101000020155500005FC768761E682841E8A9D11E306F0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516769, 'MS64', 'NL32-05', NULL, 'SANCARLO', 'San Carlo', 'San Carlo', '0101000020155500001C53876F02E124410CA8CA73C83B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516770, 'MS74', 'NL32-05', NULL, 'SANCARLO', 'San Carlo', 'San Carlo', '010100002015550000E2615087111D2541B6D756B5493F0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516775, 'LS77', 'NL32-04', NULL, 'SANGERNBODEN', 'Sangernboden', 'Sangernboden', '0101000020155500004C8E6DFE8D1A22413275F850C13B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516780, 'MS86', 'NL32-05', NULL, 'SANGIONS', 'San Gions', 'San Gions', '0101000020155500003CDA0A5F18922541B234630BE4FD0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516781, 'NS06', 'NL32-05', NULL, 'SANGIUSEP', 'San Giusep', 'San Giusep', '010100002015550000FE8121D7112726411737FF29417D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516785, 'MS76', 'NL32-05', NULL, 'SANGOTTARDO', 'San Gottardo', 'San Gottardo', '01010000201555000019CB047C731025411D64F85B63F50341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516794, 'LS68', 'NL32-04', NULL, 'SANKTANTONI', 'Sankt Antoni', 'Sankt Antoni', '01010000201555000017D309FEF7E82141FAD97CA17C970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516795, 'NT60', 'NL32-05', NULL, 'SANKTANTONIEN', 'Sankt Antönien', 'Sankt Antonien', '0101000020155500000A10FB3444CB2741993F928BA1F40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516798, 'NT25', 'NL32-02', NULL, 'SANKTFIDEN', 'Sankt Fiden', 'Sankt Fiden', '01010000201555000006B2AE3594C92641F7C9CD5D452E0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516800, 'NT35', 'NL32-02', 2, 'SANKTGALLEN', 'Sankt Gallen', 'Sankt Gallen', '0101000020155500004DAAF0DDACD2264185B8E2E007A30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516802, 'MT93', 'NL32-02', NULL, 'SANKTGALLENKAPPEL', 'Sankt Gallenkappel', 'Sankt Gallenkappel', '0101000020155500001330A70004E12541701290C9729C0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516803, 'MS02', 'NL32-04', NULL, 'SANKTGERMAN', 'Sankt German', 'Sankt German', '010100002015550000CA502CA7FA32234155D5EC307DA0FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516808, 'MS69', 'NL32-05', NULL, 'SANKTJAKOB', 'Sankt Jakob', 'Sankt Jakob', '010100002015550000E705B4AD3BD12441370975C126CA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516809, 'LT97', 'NL32-01', NULL, 'SANKTJOHANN', 'Sankt Johann', 'Sankt Johann', '01010000201555000014582293B59A2241B8AAC0B65CB91041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516810, 'NT45', 'NL32-02', NULL, 'SANKTMARGRETHEN', 'Sankt Margrethen', 'Sankt Margrethen', '0101000020155500003211A892A75227417B3593819C760F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516811, 'NS16', 'NL32-05', NULL, 'SANKTMARTIN', 'Sankt Martin', 'Sankt Martin', '0101000020155500001DE5916B8A62264193FCB28F4EBC0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516812, 'NS29', 'NL32-05', NULL, 'SANKTMARTIN', 'Sankt Martin', 'Sankt Martin', '0101000020155500005AD5F40DDFC026415FAC1D32D6290841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516813, 'NS64', 'NL32-05', NULL, 'SANKTMORITZ', 'Sankt Moritz', 'Sankt Moritz', '010100002015550000F2E06D6572EB27411E18460A99A20241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516815, 'NS64', 'NL32-05', NULL, 'SANKTMORITZBAD', 'Sankt Moritz-Bad', 'Sankt Moritz-Bad', '010100002015550000F853179B54EC27416F581FE8DA2E0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516818, 'MS01', 'NL32-04', NULL, 'SANKTNIKLAUS', 'Sankt Niklaus', 'Sankt Niklaus', '01010000201555000050CF827B8C2923414689B654F28DFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516819, 'LT83', 'NL32-01', NULL, 'SANKTNIKLAUS', 'Sankt Niklaus', 'Sankt Niklaus', '010100002015550000BD16C259878722410BB7E733B93E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516820, 'NS48', 'NL32-05', NULL, 'SANKTPETER', 'Sankt Peter', 'Sankt Peter', '010100002015550000AAC6E05462752741FB2DC325361B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516822, 'NT14', 'NL32-02', NULL, 'SANKTPETERZELL', 'Sankt Peterzell', 'Sankt Peterzell', '0101000020155500001E6CA18FFC5526415E87F3D0EE8D0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516823, 'LS75', 'NL32-04', NULL, 'SANKTSTEPHAN', 'Sankt Stephan', 'Sankt Stephan', '010100002015550000C768476155382241EF62963FDE840241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516824, 'LS68', 'NL32-04', NULL, 'SANKTURSEN', 'Sankt Ursen', 'Sankt Ursen', '01010000201555000089E9E8D21DCB214160230E47E35D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516826, 'MS80', 'NL32-05', NULL, 'SANNAZZARO', 'San Nazzaro', 'San Nazzaro', '010100002015550000C19EC7076F852541C504D3AF5DDBFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516829, 'NS03', 'NL32-05', NULL, 'SANTADOMENICA', 'Santa Domenica', 'Santa Domenica', '010100002015550000473698CE924026419D7C9AB6016D0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516830, 'NS12', 'NL32-05', NULL, 'SANTAMARIA', 'Santa Maria', 'Santa Maria', '01010000201555000058B54C5C284C2641F5004E6BE398FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516831, 'PS06', 'NL32-06', NULL, 'SANTAMARIA', 'Santa Maria', 'Santa Maria', '01010000201555000079A4803EC9452941F824DF0DA72D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516835, 'NS01', 'NL32-05', NULL, 'SANTANTONIO', 'Sant’Antonio', 'Sant’Antonio', '010100002015550000961D138FD0252641F6AD37D673DBFB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516837, 'NS01', 'NL32-05', NULL, 'SANVITTORE', 'San Vittore', 'San Vittore', '01010000201555000077E06A9BBD422641C687B7E69EAFFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516838, 'LS51', 'NL32-04', NULL, 'SAPINHAUT', 'Sapinhaut', 'Sapinhaut', '010100002015550000809693E247AB21415E42FB23A5A4FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516839, 'NS79', 'NL32-06', NULL, 'SARDASCA', 'Sardasca', 'Sardasca', '0101000020155500004B61BA9EF44428411AA9DCF654A80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516841, 'NT31', 'NL32-02', NULL, 'SARGANS', 'Sargans', 'Sargans', '010100002015550000FB8B2C2E81EF2641CB387DD5D6FD0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516845, 'LT70', 'NL32-04', NULL, 'SARISWIL', 'Säriswil', 'Sariswil', '010100002015550000692FFEB9E9102241C34A626E36DA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516846, 'MT44', 'NL32-02', NULL, 'SARMENSTORF', 'Sarmenstorf', 'Sarmenstorf', '010100002015550000C7410DE3C12E2441504C5DF1036A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516847, 'NS37', 'NL32-05', NULL, 'SARN', 'Sarn', 'Sarn', '010100002015550000762AC13C99E226417790F1F611B00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516848, 'MS49', 'NL32-05', 4, 'SARNEN', 'Sarnen', 'Sarnen', '010100002015550000F76BB0AC93282441B60A442F1AC20741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516853, 'KS72', 'NL32-04', NULL, 'SATIGNY', 'Satigny', 'Satigny', '0101000020155500009716C5DEA6001E4168090E362A22FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516854, 'MT71', 'NL32-02', NULL, 'SATTEL', 'Sattel', 'Sattel', '010100002015550000CC6764D240142541960AC060054B0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516855, 'LS29', 'NL32-04', NULL, 'SAUGES', 'Sauges', 'Sauges', '010100002015550000FEA562E05BBF20418E7DD62183850741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516856, 'LT64', 'NL32-01', NULL, 'SAULCY', 'Saulcy', 'Saulcy', '0101000020155500007EB3B2CDF5A42141B405A81D7A270D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516858, 'MS15', 'NL32-04', NULL, 'SAUSOBERBERG', 'Saus Oberberg', 'Saus Oberberg', '0101000020155500009008C13ED34523419E246A1F036F0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516860, 'LS42', 'NL32-04', NULL, 'SAVATAN', 'Savatan', 'Savatan', '0101000020155500009397AB6A1A5121414D267B51D7EAFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516861, 'LS72', 'NL32-04', NULL, 'SAVIESE', 'Savièse', 'Saviese', '010100002015550000D092E472171A2241148ED84B2ECDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516862, 'LS25', 'NL32-04', NULL, 'SAVIGNY', 'Savigny', 'Savigny', '0101000020155500001F625903E7A820417F1442EA43000341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516863, 'NS46', 'NL32-05', NULL, 'SAVOGNIN', 'Savognin', 'Savognin', '010100002015550000DA0D6C322D5D2741593156C49AED0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516864, 'MR99', 'NL32-05', NULL, 'SAVOSAPAESE', 'Savosa Paese', 'Savosa Paese', '01010000201555000047655001C6CD2541EC9A24B71EBBF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516865, 'NT33', 'NL32-02', NULL, 'SAX', 'Sax', 'Sax', '0101000020155500005AF9312550F526411F9074D7947B0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516866, 'MS16', 'NL32-04', NULL, 'SAXETEN', 'Saxeten', 'Saxeten', '0101000020155500005D489687A03B2341FC3E1992801C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516867, 'LS51', 'NL32-04', NULL, 'SAXON', 'Saxon', 'Saxon', '01010000201555000062C0A52764B52141580929C42B18FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516868, 'NS82', 'NL32-06', NULL, 'SCALA', 'Scala', 'Scala', '01010000201555000076CDD4B72F9D28413D0A08B07A35FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516870, 'NS76', 'NL32-05', NULL, 'SCANFS', 'Scanfs', 'Scanfs', '0101000020155500001E091940134228413BD15A9700430441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516871, 'MS81', 'NL32-05', NULL, 'SCERESIO', 'Sceresio', 'Sceresio', '010100002015550000001EBBAE217A2541E2B82863E11CFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516873, 'MT30', 'NL32-02', NULL, 'SCHACHEN', 'Schachen', 'Schachen', '01010000201555000037A2315E06EC2341CFF22BBD098F0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516879, 'MT78', 'NL32-02', 3, 'SCHAFFHAUSEN', 'Schaffhausen', 'Schaffhausen', '0101000020155500007F95130E190C25418269A9D4AE541141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516884, 'MT34', 'NL32-02', NULL, 'SCHAFISHEIM', 'Schafisheim', 'Schafisheim', '01010000201555000061E5F0C055E92341DF0CDF4EFD4E0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516885, 'MS47', 'NL32-05', NULL, 'SCHAFTELEN', 'Schaftelen', 'Schaftelen', '0101000020155500009D94A61DEB652441AA832EEACD470541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516892, 'MS18', 'NL32-04', NULL, 'SCHANGNAU', 'Schangnau', 'Schangnau', '01010000201555000079EA2147B044234145708D457ED30641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516893, 'NT02', 'NL32-02', NULL, 'SCHANIS', 'Schänis', 'Schanis', '010100002015550000D58B7B40380A2641F90BCE3544440B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516894, 'NS37', 'NL32-05', NULL, 'SCHARANS', 'Scharans', 'Scharans', '010100002015550000BEB66D04C50A27418C477F243D7A0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516895, 'PS07', 'NL32-06', NULL, 'SCHARL', 'S-charl', 'S-charl', '0101000020155500009EB153A2321029419ED34FC533BB0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516896, 'MS19', 'NL32-04', NULL, 'SCHARLIG', 'Schärlig', 'Scharlig', '01010000201555000054E58B2B3C6223414DED629EDA810741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516898, 'MS57', 'NL32-05', NULL, 'SCHARMADLAGER', 'Scharmadläger', 'Scharmadlager', '010100002015550000D1BBBA7A5E6F2441136F1929F3F50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516899, 'MS79', 'NL32-05', NULL, 'SCHATTDORF', 'Schattdorf', 'Schattdorf', '010100002015550000E4C4757D0B212541C33705BEFE5A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516900, 'NS68', 'NL32-05', NULL, 'SCHATZALP', 'Schatzalp', 'Schatzalp', '010100002015550000818B72B81ED92741F655EBCBF5EC0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516902, 'NS38', 'NL32-05', NULL, 'SCHEID', 'Scheid', 'Scheid', '010100002015550000920FA93F55FF2641434DB86CBC600641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516904, 'LT94', 'NL32-01', NULL, 'SCHELTEN', 'Schelten', 'Schelten', '010100002015550000DD92193B44912241345A3989359A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516905, 'MT32', 'NL32-02', NULL, 'SCHENKON', 'Schenkon', 'Schenkon', '0101000020155500005EE70C0C00EB2341718744CF3E5E0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516908, 'LS78', 'NL32-04', NULL, 'SCHERLIAU', 'Scherliau', 'Scherliau', '0101000020155500005446B61B69422241EEADF636D70A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516909, 'NT17', 'NL32-02', NULL, 'SCHERZINGEN', 'Scherzingen', 'Scherzingen', '0101000020155500009095D8E96F6326419E1D870BD9ED1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516910, 'LS97', 'NL32-04', NULL, 'SCHERZLIGEN', 'Scherzligen', 'Scherzligen', '01010000201555000027D9780BBAC322414E5AFEF200B00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516913, 'NT50', 'NL32-05', NULL, 'SCHIERS', 'Schiers', 'Schiers', '010100002015550000BBFB7349EE8527413EF1CB7F7CEC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516916, 'MS39', 'NL32-05', NULL, 'SCHIMBERGBAD', 'Schimbergbad', 'Schimbergbad', '010100002015550000B165418EF6D823412B9E44BBF4320841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516917, 'MT72', 'NL32-02', NULL, 'SCHINDELLEGI', 'Schindellegi', 'Schindellegi', '0101000020155500009ACF48DCA23A254119E19923FA6E0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516919, 'MT35', 'NL32-02', NULL, 'SCHINZNACHBAD', 'Schinznach Bad', 'Schinznach Bad', '0101000020155500007F7E37A798FC234102A88B236BFD0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516920, 'MT35', 'NL32-02', NULL, 'SCHINZNACHDORF', 'Schinznach Dorf', 'Schinznach Dorf', '010100002015550000DB564994D2E8234154E6D2E19C360F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516923, 'NT34', 'NL32-02', NULL, 'SCHLATT', 'Schlatt', 'Schlatt', '01010000201555000028A3957135D52641DAB50D16CD0D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516925, 'MT77', 'NL32-02', NULL, 'SCHLATT', 'Schlatt', 'Schlatt', '01010000201555000065C57A8AA73325416211C827001C1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516926, 'MT87', 'NL32-02', NULL, 'SCHLATTINGEN', 'Schlattingen', 'Schlattingen', '010100002015550000C4767CA9FD502541EC082671F61C1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516927, 'PS09', 'NL32-06', NULL, 'SCHLEINS', 'Schleins', 'Schleins', '010100002015550000B20C139BEA46294118870D9BE3CC0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516928, 'MT68', 'NL32-02', NULL, 'SCHLEITHEIM', 'Schleitheim', 'Schleitheim', '010100002015550000A4C43D1D90B32441C9E5EA6409A91141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516929, 'NS18', 'NL32-05', NULL, 'SCHLEUIS', 'Schleuis', 'Schleuis', '010100002015550000E29E053E2B7426416571D0F949530641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516930, 'MT54', 'NL32-02', NULL, 'SCHLIEREN', 'Schlieren', 'Schlieren', '010100002015550000B74E0414F4A3244155027D7803910E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516933, 'MT33', 'NL32-02', NULL, 'SCHLOSSRUED', 'Schlossrued', 'Schlossrued', '010100002015550000DF94694C8DCC23411ECFB51E8EF20C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516935, 'NS48', 'NL32-05', NULL, 'SCHLUOCHT', 'Schluocht', 'Schluocht', '010100002015550000EE8B3C8DCD39274196C301B9A4140741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516936, 'NS57', 'NL32-05', NULL, 'SCHMELZBODEN', 'Schmelzboden', 'Schmelzboden', '010100002015550000E78F37EA5FB42741067AAF1A16530541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516938, 'MT92', 'NL32-02', NULL, 'SCHMERIKON', 'Schmerikon', 'Schmerikon', '0101000020155500008782476700C42541FBA84A4F5E260C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516939, 'NS57', 'NL32-05', NULL, 'SCHMITTEN', 'Schmitten', 'Schmitten', '010100002015550000E9B02284038327414456A7C472130541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516940, 'LS69', 'NL32-04', NULL, 'SCHMITTEN', 'Schmitten', 'Schmitten', '01010000201555000046774EFD22DF2141A668898E47450741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516943, 'LT71', 'NL32-01', NULL, 'SCHNOTTWIL', 'Schnottwil', 'Schnottwil', '010100002015550000C05CC65BB42E224131D9530F686F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516945, 'MT23', 'NL32-02', NULL, 'SCHOFTLAND', 'Schöftland', 'Schoftland', '010100002015550000A85472F4BCB8234152911C41D42B0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516947, 'LT80', 'NL32-01', NULL, 'SCHONBUHL', 'Schönbühl', 'Schonbuhl', '0101000020155500004D74E618F4732241522634A1E64D0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516948, 'MS69', 'NL32-05', NULL, 'SCHONECK', 'Schöneck', 'Schoneck', '0101000020155500005D5FC3F6A2D0244184BACAA7D6770841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516950, 'MT72', 'NL32-02', NULL, 'SCHONENBERG', 'Schönenberg', 'Schonenberg', '0101000020155500009F83A6E0B5122541460C68D24CE00B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516951, 'NT16', 'NL32-02', NULL, 'SCHONENBERG', 'Schönenberg', 'Schonenberg', '0101000020155500007135DD8D1F522641F521876054221041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516952, 'LT86', 'NL32-01', NULL, 'SCHONENBUCH', 'Schönenbuch', 'Schonenbuch', '0101000020155500000452FC8ECD692241E0896F3B7A281041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516953, 'NT14', 'NL32-02', NULL, 'SCHONENGRUND', 'Schönengrund', 'Schonengrund', '0101000020155500007F528B6783732641CEEA06FF98900D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516954, 'MT24', 'NL32-02', NULL, 'SCHONENWERD', 'Schönenwerd', 'Schonenwerd', '01010000201555000091AF5215C89A23418DB3B53D91120E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516955, 'MT43', 'NL32-02', NULL, 'SCHONGAU', 'Schongau', 'Schongau', '01010000201555000046093ECE342F24411841EB924EBC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516956, 'NT16', 'NL32-02', NULL, 'SCHONHOLZERSWILEN', 'Schönholzerswilen', 'Schonholzerswilen', '010100002015550000C83865F4B4342641A4491F290A211041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516957, 'LS65', 'NL32-04', NULL, 'SCHONRIED', 'Schönried', 'Schonried', '0101000020155500000630648D5BF22141B44478A3514B0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516959, 'MT22', 'NL32-01', NULL, 'SCHOTZ', 'Schötz', 'Schotz', '01010000201555000012B649AC269223414E55DEC7705B0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516961, 'MS46', 'NL32-05', NULL, 'SCHRATTERN', 'Schrättern', 'Schrattern', '010100002015550000144D00C5CE202441242E69833F5D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516964, 'LS94', 'NL32-04', NULL, 'SCHRICKMATTEN', 'Schrickmatten', 'Schrickmatten', '0101000020155500003374CF4D4DB02241A65DADC670110241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516965, 'MT92', 'NL32-02', NULL, 'SCHUBELBACH', 'Schübelbach', 'Schubelbach', '0101000020155500006C6A6332D4C425417419A6CAAF780B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516966, 'NT50', 'NL32-05', NULL, 'SCHUDERS', 'Schuders', 'Schuders', '0101000020155500007E0B861A39A327418EB60D96CD290941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516967, 'LS74', 'NL32-04', NULL, 'SCHULH', 'Schulh', 'Schulh', '01010000201555000083BB5A0E4E1022415A07B53352D70141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516968, 'NS98', 'NL32-06', NULL, 'SCHULS', 'Schuls', 'Schuls', '010100002015550000F390922CA9F92841C815692496D90641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516969, 'MS09', 'NL32-04', NULL, 'SCHUPBACH', 'Schüpbach', 'Schupbach', '0101000020155500006C406777D3FE2241CAFBF57EA52D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516970, 'LT71', 'NL32-01', NULL, 'SCHUPFEN', 'Schüpfen', 'Schupfen', '010100002015550000C6BD2BB9A92E224162B23BA7CB870941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516971, 'MT20', 'NL32-05', NULL, 'SCHUPFHEIM', 'Schüpfheim', 'Schupfheim', '01010000201555000005E236D347A72341C1C2BD744A6B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516973, 'NS67', 'NL32-05', NULL, 'SCHURLIALP', 'Schürlialp', 'Schurlialp', '0101000020155500009E87AE560D0D284172BE8F90BBD10541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516974, 'MT37', 'NL32-02', NULL, 'SCHWADERLOCH', 'Schwaderloch', 'Schwaderloch', '0101000020155500007EB8E237CCE7234164051AF3EF821041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516976, 'MS07', 'NL32-04', NULL, 'SCHWANDEN', 'Schwanden', 'Schwanden', '010100002015550000ACC67F4686F522414AAD9BA6B3760541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516977, 'NT00', 'NL32-05', NULL, 'SCHWANDEN', 'Schwanden', 'Schwanden', '01010000201555000034BF56CD1817264106C811CF2D020941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516978, 'NS19', 'NL32-05', NULL, 'SCHWANDI', 'Schwändi', 'Schwandi', '010100002015550000320FD6387A5326419306F1FA99590841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516979, 'NT00', 'NL32-02', NULL, 'SCHWANDI', 'Schwändi', 'Schwandi', '010100002015550000917876E8CB1626410DA99F85113C0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516980, 'MT30', 'NL32-02', NULL, 'SCHWARZENBERG', 'Schwarzenberg', 'Schwarzenberg', '0101000020155500005CED17D3F3FF2341BE60211FDB550941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516981, 'LS78', 'NL32-04', NULL, 'SCHWARZENBURG', 'Schwarzenburg', 'Schwarzenburg', '01010000201555000096D7BA87BC102241580742921AD10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516982, 'MS08', 'NL32-04', NULL, 'SCHWARZENEGG', 'Schwarzenegg', 'Schwarzenegg', '01010000201555000039D01AE451F52241D5AB26C54C5E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516983, 'MS47', 'NL32-05', NULL, 'SCHWARZENTHAL', 'Schwarzenthal', 'Schwarzenthal', '010100002015550000C08EACC5A35B2441DC66788325BB0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516989, 'LS77', 'NL32-04', NULL, 'SCHWEFELBERGBAD', 'Schwefelbergbad', 'Schwefelbergbad', '010100002015550000A9A3B87160422241088CDC0FA43B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516990, 'LT96', 'NL32-01', NULL, 'SCHWEIZERHALLE', 'Schweizerhalle', 'Schweizerhalle', '01010000201555000056E572A2A7D522418363399BD9281041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516998, 'NT14', 'NL32-02', NULL, 'SCHWELLBRUNN', 'Schwellbrunn', 'Schwellbrunn', '0101000020155500004B6A844E5A7C2641B8E182412D3F0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516999, 'MS17', 'NL32-04', NULL, 'SCHWENDI', 'Schwendi', 'Schwendi', '010100002015550000D7038334215923418BFE9726A23E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517000, 'MS07', 'NL32-04', NULL, 'SCHWENDI', 'Schwendi', 'Schwendi', '010100002015550000F0A2182786EB224134CC57FC76B00541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517002, 'MS39', 'NL32-05', NULL, 'SCHWENDIKALTBAD', 'Schwendikaltbad', 'Schwendikaltbad', '010100002015550000DEBE96D720E32341E40ADF1C7FBF0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517005, 'MT70', 'NL32-02', 3, 'SCHWYZ', 'Schwyz', 'Schwyz', '010100002015550000B4097BA3081F2541CC4D348B0B640941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517009, 'MS95', 'NL32-05', NULL, 'SCONA', 'Scona', 'Scona', '010100002015550000177E83F151C5254160031B8B19E00241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517011, 'NS98', 'NL32-06', NULL, 'SCUOL', 'Scuol', 'Scuol', '010100002015550000F390922CA9F92841C815692496D90641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517012, 'KS82', 'NL32-04', NULL, 'SECHERON', 'Sécheron', 'Secheron', '01010000201555000097472266ECA01E413C2DB24065A3FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517013, 'LS47', 'NL32-04', NULL, 'SEDEILLES', 'Sedeilles', 'Sedeilles', '01010000201555000046C66E13DB2121410E9DFBB355B30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517014, 'MS86', 'NL32-05', NULL, 'SEDRUN', 'Sedrun', 'Sedrun', '0101000020155500009AB438832F7325413379381D5DE30441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517015, 'MT64', 'NL32-02', NULL, 'SEEBACH', 'Seebach', 'Seebach', '010100002015550000D8BB451221DF2441C601CA5A4D5A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517016, 'LT92', 'NL32-01', NULL, 'SEEBERG', 'Seeberg', 'Seeberg', '010100002015550000610B29849ED62241F2EF1132D91D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517017, 'MS69', 'NL32-05', NULL, 'SEEDORF', 'Seedorf', 'Seedorf', '01010000201555000052335BF40C032541B21FAE8C16930741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517018, 'LT71', 'NL32-01', NULL, 'SEEDORF', 'Seedorf', 'Seedorf', '0101000020155500003C9982832DFD21419F1565F00A880941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517020, 'MT84', 'NL32-02', NULL, 'SEEGRABEN', 'Seegräben', 'Seegraben', '0101000020155500000EDE22E76C5F254133C74AAB73EE0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517021, 'MT60', 'NL32-05', NULL, 'SEELISBERG', 'Seelisberg', 'Seelisberg', '010100002015550000F6BD983612F824414575EAE3FAB30841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517022, 'MT44', 'NL32-02', NULL, 'SEENGEN', 'Seengen', 'Seengen', '010100002015550000164FC5E9EC1A24419C5412181FA30D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517025, 'MT70', 'NL32-02', NULL, 'SEEWES', 'Seewes', 'Seewes', '0101000020155500009C05AF7F22152541A95C311F70630941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517026, 'NS17', 'NL32-05', NULL, 'SEEWIS', 'Seewis', 'Seewis', '0101000020155500000C1B57387F74264107F1037A67190641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517030, 'NT40', 'NL32-05', NULL, 'SEEWISIMPRATIGAU', 'Seewis im Prätigau', 'Seewis im Pratigau', '010100002015550000CB870349CF67274182D41D3500230941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517036, 'LS88', 'NL32-04', NULL, 'SEFTIGEN', 'Seftigen', 'Seftigen', '01010000201555000044A180FDFE8722410D2FFA8B5D230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517037, 'NS54', 'NL32-05', NULL, 'SEGLMARIA', 'Segl-Maria', 'Segl-Maria', '0101000020155500002169D97F33C52741E8414DE84AB60141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517041, 'NS68', 'NL32-05', NULL, 'SELFRANGA', 'Selfranga', 'Selfranga', '010100002015550000CAC9F37FF2FF27411F94A34C97650741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517043, 'NS02', 'NL32-05', NULL, 'SELMA', 'Selma', 'Selma', '01010000201555000007AFD35131412641D633DB1C79F2FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517044, 'MT05', 'NL32-01', NULL, 'SELTISBERG', 'Seltisberg', 'Seltisberg', '010100002015550000D33D1E1E53F32241044F216888300F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517045, 'LT82', 'NL32-01', NULL, 'SELZACH', 'Selzach', 'Selzach', '010100002015550000A6C6EC9C5D4C22412F5C4A33C8CA0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517046, 'LS50', 'NL32-04', NULL, 'SEMBRANCHER', 'Sembrancher', 'Sembrancher', '0101000020155500001010BDA60EA12141A1C5989F8A49F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517047, 'MS91', 'NL32-05', NULL, 'SEMENTINA', 'Sementina', 'Sementina', '0101000020155500008E5F7E3841F32541FE15D9AD1747FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517048, 'MT32', 'NL32-02', NULL, 'SEMPACH', 'Sempach', 'Sempach', '01010000201555000012FF2CDFC4122441A1A7CC64E8EB0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517052, 'LS46', 'NL32-04', NULL, 'SEMSALES', 'Semsales', 'Semsales', '010100002015550000B42417CFEB20214133F6619B5A700341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517053, 'MS17', 'NL32-04', NULL, 'SENGG', 'Sengg', 'Sengg', '0101000020155500004F3089970B81234161AF924DB4050541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517054, 'MT85', 'NL32-02', NULL, 'SENNHOF', 'Sennhof', 'Sennhof', '0101000020155500008A7A43FFE4532541ECFD83D416830F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517055, 'NT33', 'NL32-02', NULL, 'SENNWALD', 'Sennwald', 'Sennwald', '010100002015550000618C386F1F1227411D0EBD676CF20C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517057, 'PS08', 'NL32-06', NULL, 'SENT', 'Sent', 'Sent', '01010000201555000086858F5EFE0C2941B92523385D160741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517058, 'MT34', 'NL32-02', NULL, 'SEON', 'Seon', 'Seon', '010100002015550000D21FB7EB6DF32341A623E33D88DB0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517060, 'PS08', 'NL32-06', NULL, 'SERAPLANA', 'Seraplana', 'Seraplana', '010100002015550000BC8683958B3D294151FDE7CD84910741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517065, 'LT40', 'NL32-04', NULL, 'SERRIERES', 'Serrières', 'Serrieres', '010100002015550000F87E6CA7400F2141127D0B498EA40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517066, 'NS67', 'NL32-05', NULL, 'SERTIGDOFLI', 'Sertig Döfli', 'Sertig Dofli', '010100002015550000BE49479135EF2741CC13362206CE0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517067, 'MR89', 'NL32-05', NULL, 'SESSA', 'Sessa', 'Sessa', '010100002015550000E9CF608487912541326241FA863EF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517069, 'NS18', 'NL32-05', NULL, 'SETH', 'Seth', 'Seth', '010100002015550000254492EB674C2641D69B414CC04F0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517071, 'MT76', 'NL32-02', NULL, 'SEUZACH', 'Seuzach', 'Seuzach', '010100002015550000B26C4A8E1F4925412C7AD6A505351041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517072, 'NT31', 'NL32-02', NULL, 'SEVELEN', 'Sevelen', 'Sevelen', '010100002015550000B25FD1EAAA0B2741D7FCF6CB6DE80A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517076, 'KS61', 'NL32-04', NULL, 'SEZEGNIN', 'Sézegnin', 'Sezegnin', '010100002015550000E2B54A4175EA1D41D764AD5D8054FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517078, 'MT68', 'NL32-02', NULL, 'SIBLINGEN', 'Siblingen', 'Siblingen', '010100002015550000A84BFBEDB7BD24411091F4AA636F1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517079, 'MT92', 'NL32-02', NULL, 'SIEBNEN', 'Siebnen', 'Siebnen', '0101000020155500003D689763D1B0254130822EC117B10B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517080, 'NT17', 'NL32-02', NULL, 'SIEGERSHAUSEN', 'Siegershausen', 'Siegershausen', '010100002015550000F0C9F1149E3C2641D8ED415528CF1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517082, 'LS82', 'NL32-04', NULL, 'SIERRE', 'Sierre', 'Sierre', '01010000201555000068C0857F7F88224183909D849828FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517085, 'MS90', 'NL32-05', NULL, 'SIGIRINO', 'Sigirino', 'Sigirino', '0101000020155500004B2902C1AECC2541CFA954403B8AF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517086, 'MT56', 'NL32-02', NULL, 'SIGLISTORF', 'Siglistorf', 'Siglistorf', '0101000020155500003710F40E457124419D63248FDD4B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517089, 'MS09', 'NL32-04', NULL, 'SIGNAU', 'Signau', 'Signau', '010100002015550000F104D837F6F4224176E62BFC99F30741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517090, 'NS17', 'NL32-05', NULL, 'SIGNINA', 'Signina', 'Signina', '010100002015550000AA87057B0D8926414562A3A474A70541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517091, 'NS00', 'NL32-05', NULL, 'SIGNORA', 'Signora', 'Signora', '010100002015550000EECD23F2F21C264112F58CB9B20AFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517092, 'MS07', 'NL32-04', NULL, 'SIGRISWIL', 'Sigriswil', 'Sigriswil', '01010000201555000002B6F8C49EEB22412EB41790AA3C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517098, 'MT62', 'NL32-02', NULL, 'SIHLBRUGGDORF', 'Sihlbrugg Dorf', 'Sihlbrugg Dorf', '010100002015550000F6176B7953F524415419CC0DA3A40B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517100, 'MS78', 'NL32-05', NULL, 'SILENEN', 'Silenen', 'Silenen', '010100002015550000DA5E0FAC1A2C25414CEC836C253A0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517105, 'NS37', 'NL32-05', NULL, 'SILSIMDOMLESCHG', 'Sils im Domleschg', 'Sils im Domleschg', '010100002015550000B8E8B63F30012741B4089F4C553F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517109, 'NS64', 'NL32-05', NULL, 'SILVAPLANA', 'Silvaplana', 'Silvaplana', '010100002015550000B843EF99C5CE2741EA0CD4785BF10141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517117, 'NS79', 'NL32-06', NULL, 'SILVRETTAHAUS', 'Silvrettahaus', 'Silvrettahaus', '0101000020155500005E0FE5E8CC5828411EC1470DF1AA0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517126, 'MS21', 'NL32-05', NULL, 'SIMPLONDORF', 'Simplon Dorf', 'Simplon Dorf', '0101000020155500003AE995F949C023410ACB1A8B3609FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517132, 'MT52', 'NL32-02', NULL, 'SINS', 'Sins', 'Sins', '0101000020155500007FBC73E5BA7E2441DE530C213BD80B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517133, 'LS72', 'NL32-04', 3, 'SION', 'Sion', 'Sion', '0101000020155500008A9B0D37131A224138DC13246259FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517134, 'NT05', 'NL32-02', NULL, 'SIRNACH', 'Sirnach', 'Sirnach', '010100002015550000E1C7142320E72541764D5454DF8D0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517135, 'LT61', 'NL32-01', NULL, 'SISELEN', 'Siselen', 'Siselen', '01010000201555000000B8200DE6B721419CB4E305BE880941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517136, 'MS79', 'NL32-05', NULL, 'SISIKON', 'Sisikon', 'Sisikon', '010100002015550000F986CBE31A0C2541DEA90E19427B0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517137, 'MT05', 'NL32-01', NULL, 'SISSACH', 'Sissach', 'Sissach', '010100002015550000B7964AB85B242341B8B5E25A3D6B0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517140, 'LS37', 'NL32-04', NULL, 'SIVIRIEZ', 'Siviriez', 'Siviriez', '010100002015550000F6A247CB87F9204165A261D2F0920441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517142, 'NS13', 'NL32-05', NULL, 'SOAZZA', 'Soazza', 'Soazza', '010100002015550000668CE2AEB27C26410E7D55254E720041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517143, 'MS93', 'NL32-05', NULL, 'SOBRIO', 'Sobrio', 'Sobrio', '0101000020155500005AB33C6380C7254174EF1B7BFE100141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517144, 'NS43', 'NL32-05', NULL, 'SOGLIO', 'Soglio', 'Soglio', '010100002015550000BC909777773B2741360E43BE3A4B0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517145, 'MS94', 'NL32-05', NULL, 'SOJA', 'Soja', 'Soja', '0101000020155500000D349909D7ED254185C48F6A676F0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517146, 'MS81', 'NL32-05', NULL, 'SOLDUNO', 'Solduno', 'Solduno', '010100002015550000DE2DDD35E07A254172D231128AC1FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517152, 'LT83', 'NL32-01', 3, 'SOLOTHURN', 'Solothurn', 'Solothurn', '010100002015550000A34FAC2BAB7D22411BF60634AE3E0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517154, 'MS72', 'NL32-05', NULL, 'SOMEO', 'Someo', 'Someo', '010100002015550000C288D574E632254190378357C9E2FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517155, 'LR59', 'NL32-04', NULL, 'SOMLAPROZ', 'Somlaproz', 'Somlaproz', '010100002015550000AA077C37C296214156151F01A87AF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517156, 'MT15', 'NL32-01', NULL, 'SOMMERAU', 'Sommerau', 'Sommerau', '010100002015550000314A0184E24123417207831EE9310F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517158, 'NS82', 'NL32-06', NULL, 'SOMPRAI', 'Somprai', 'Somprai', '010100002015550000562230721A732841A788C1B392F9FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517159, 'MS97', 'NL32-05', NULL, 'SOMVIX', 'Somvix', 'Somvix', '010100002015550000BA095600F3D52541EFC62D3248980541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517164, 'LT62', 'NL32-01', NULL, 'SONCEBOZ', 'Sonceboz', 'Sonceboz', '010100002015550000CD19312C5FB8214128C99EE7C5CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517166, 'MS83', 'NL32-05', NULL, 'SONOGNO', 'Sonogno', 'Sonogno', '010100002015550000DFBBE09E25782541F0E5515A8F5D0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517167, 'MS90', 'NL32-05', NULL, 'SONVICO', 'Sonvico', 'Sonvico', '0101000020155500003288A2F23FF525412FED4D61AA1CF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517168, 'LT42', 'NL32-01', NULL, 'SONVILIER', 'Sonvilier', 'Sonvilier', '010100002015550000C09D1248E22D21414EB1AF10CAE60A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517169, 'NT00', 'NL32-05', NULL, 'SOOL', 'Sool', 'Sool', '0101000020155500009EC2903F002126413484036001030941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517170, 'KS71', 'NL32-04', NULL, 'SORAL', 'Soral', 'Soral', '010100002015550000495089CC2D121E4193319FAAD5DDFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517171, 'MS28', 'NL32-05', NULL, 'SORENBERG', 'Sörenberg', 'Sorenberg', '01010000201555000076951AC006A823415AB35EE2FED50641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517172, 'MR99', 'NL32-05', NULL, 'SORENGO', 'Sorengo', 'Sorengo', '01010000201555000058B1BDD221D825413670F7CCDE48F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517173, 'LS57', 'NL32-04', NULL, 'SORENS', 'Sorens', 'Sorens', '0101000020155500006A78AC6436672141B46F6CD725CA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517174, 'MS90', 'NL32-05', NULL, 'SORESINA', 'Soresina', 'Soresina', '010100002015550000F866FC1502B825412A555768C96EFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517175, 'LT63', 'NL32-01', NULL, 'SORNETAN', 'Sornetan', 'Sornetan', '0101000020155500002DD890D744CC214133A615AB26B30C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517176, 'MS73', 'NL32-05', NULL, 'SORNICO', 'Sornico', 'Sornico', '010100002015550000400FBE7D8A312541CF5A61CBBDCC0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517177, 'NS12', 'NL32-05', NULL, 'SORTE', 'Sorte', 'Sorte', '010100002015550000E16BA9B8F1692641F63FE1F1EF11FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517178, 'LS26', 'NL32-04', NULL, 'SOTTENS', 'Sottens', 'Sottens', '010100002015550000266F4549AFA920413252B41AA55B0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517179, 'LT54', 'NL32-01', NULL, 'SOUBEY', 'Soubey', 'Soubey', '010100002015550000D973DEB3DF69214198CF9E2F80280D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517180, 'LS82', 'NL32-04', NULL, 'SOUSSILLON', 'Soussillon', 'Soussillon', '010100002015550000715DB522A29C2241E55856466ECDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517182, 'LT75', 'NL32-01', NULL, 'SOYHIERES', 'Soyhières', 'Soyhieres', '010100002015550000B54C5FEB0F252241F43AEAF9BB810E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517185, 'MS17', 'NL32-04', NULL, 'SPEICHER', 'Speicher', 'Speicher', '0101000020155500008CA71849E25823417425C76654EC0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517186, 'NT34', 'NL32-02', NULL, 'SPEICHER', 'Speicher', 'Speicher', '010100002015550000DAF8A1059AF1264154382F9C74BE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517187, 'LS97', 'NL32-04', NULL, 'SPIEZ', 'Spiez', 'Spiez', '0101000020155500000572FB34C1E12241913EF25ABDC80441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517188, 'MS05', 'NL32-04', NULL, 'SPIGGENGRUND', 'Spiggengrund', 'Spiggengrund', '01010000201555000021B48EF3F71D23413208549A58340341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517190, 'NS65', 'NL32-05', NULL, 'SPINAS', 'Spinas', 'Spinas', '0101000020155500004BD82B151FEA27416877885F36500341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517191, 'MS79', 'NL32-05', NULL, 'SPIRINGEN', 'Spiringen', 'Spiringen', '01010000201555000039B1465470522541FADD3EEF0E980741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517192, 'MS99', 'NL32-05', NULL, 'SPITELRUTI', 'Spitelrüti', 'Spitelruti', '01010000201555000033541672BFAB25417AA0BF984B9E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517193, 'MT10', 'NL32-04', NULL, 'SPITZENHAUS', 'Spitzenhaus', 'Spitzenhaus', '010100002015550000289AFA9AE65723414FBB746520A30841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517198, 'NS25', 'NL32-05', NULL, 'SPLUGEN', 'Splügen', 'Splugen', '010100002015550000840233ACA9B42641528CA31E7E2E0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517208, 'NS47', 'NL32-05', NULL, 'SPORZ', 'Sporz', 'Sporz', '010100002015550000F2774FEB933227417EDAA88D6C7E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517209, 'MT55', 'NL32-02', NULL, 'SPREITENBACH', 'Spreitenbach', 'Spreitenbach', '010100002015550000663A53A6A372244171E229137DC80E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517210, 'MS61', 'NL32-05', NULL, 'SPRUGA', 'Spruga', 'Spruga', '010100002015550000BF15B501BCF72441AD48ABF0A098FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517211, 'NS13', 'NL32-05', NULL, 'STABBIO', 'Stabbio', 'Stabbio', '0101000020155500004A65638ABC8F2641044AC7D0C9210141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517212, 'MR97', 'NL32-08', NULL, 'STABIO', 'Stabio', 'Stabio', '01010000201555000067819E429DDA2541EF2BDC8DDB36F340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517214, 'NS09', 'NL32-05', NULL, 'STACHELBERGBAD', 'Stachelberg Bad', 'Stachelberg Bad', '010100002015550000A58A8A1758F02541BD15018D49510841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517215, 'MT56', 'NL32-02', NULL, 'STADEL', 'Stadel', 'Stadel', '0101000020155500006B9199FA75A22441372527A71F301041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517216, 'MT73', 'NL32-02', NULL, 'STAFA', 'Stäfa', 'Stafa', '0101000020155500004A019C70904325418F4FC00734570C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517217, 'LR99', 'NL32-04', NULL, 'STAFEL', 'Stafel', 'Stafel', '010100002015550000AEA8C59599E32241E6EF01E2CB05F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517218, 'NS36', 'NL32-05', NULL, 'STAFEL', 'Stafel', 'Stafel', '0101000020155500005743E094D01F27411FB75A35ADCE0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517219, 'NS57', 'NL32-05', NULL, 'STAFELALP', 'Stafel Alp', 'Stafel Alp', '010100002015550000F9F41F7B8DC627412AA278F7F13C0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517221, 'NS16', 'NL32-05', NULL, 'STAFELTI', 'Stafelti', 'Stafelti', '010100002015550000EDBE7434904F264160E2DD2DE50C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517223, 'MT23', 'NL32-02', NULL, 'STAFFELBACH', 'Staffelbach', 'Staffelbach', '010100002015550000AC6B2FA9F6B82341FF48BF6C05B80C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517224, 'MS12', 'NL32-04', NULL, 'STALDEN', 'Stalden', 'Stalden', '010100002015550000519A7209765123414AC043EEBE5EFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517225, 'LS99', 'NL32-04', NULL, 'STALDEN', 'Stalden', 'Stalden', '010100002015550000A3EDFA6F8CB92241A0CC4DBB35450741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517226, 'MS49', 'NL32-05', NULL, 'STALDEN', 'Stalden', 'Stalden', '010100002015550000B1088530B9282441BE32CC4B34880741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517227, 'MS11', 'NL32-04', NULL, 'STALDENRIED', 'Staldenried', 'Staldenried', '010100002015550000EE2AE26A965B23414A51F8A665EBFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517229, 'LT96', 'NL32-01', NULL, 'STALLEN', 'Stallen', 'Stallen', '0101000020155500008E96ACD10A912241D456F082990B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517230, 'MT64', 'NL32-02', NULL, 'STALLIKON', 'Stallikon', 'Stallikon', '0101000020155500001B5CB9F292B82441AF538BBF88700D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517231, 'MT87', 'NL32-02', NULL, 'STAMMHEIM', 'Stammheim', 'Stammheim', '0101000020155500002F8350E2CB64254130D25427AC001141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517232, 'NS43', 'NL32-05', NULL, 'STAMPA', 'Stampa', 'Stampa', '0101000020155500002DE8B10E834F2741122E365F634D0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517233, 'MT50', 'NL32-05', 4, 'STANS', 'Stans', 'Stans', '010100002015550000353197235A6D24414BC4F4FCB5AC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517235, 'MT40', 'NL32-05', NULL, 'STANSSTAD', 'Stansstad', 'Stansstad', '010100002015550000B274928171632441EAD8E83D41AC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517236, 'NS35', 'NL32-05', NULL, 'STARLERA', 'Starlera', 'Starlera', '0101000020155500009B94E776420F2741587A050EAFC30241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517240, 'MT34', 'NL32-02', NULL, 'STAUFEN', 'Staufen', 'Staufen', '010100002015550000441AAAC2FFFC2341D5CED6C4B34F0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517241, 'NS06', 'NL32-05', NULL, 'STAVIALAVEDRA', 'Staviala Vedra', 'Staviala Vedra', '010100002015550000D5DD2C1B6C3026411F22F9ECDDF10441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517242, 'MS15', 'NL32-04', NULL, 'STECHELBERG', 'Stechelberg', 'Stechelberg', '0101000020155500002946A563EF6323414C296EBCE1FB0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517243, 'MT97', 'NL32-02', NULL, 'STECKBORN', 'Steckborn', 'Steckborn', '010100002015550000F92D0DCBE3D92541F979BA6CF2211141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517244, 'LS98', 'NL32-04', NULL, 'STEFFISBURG', 'Steffisburg', 'Steffisburg', '0101000020155500006995DABAA7C3224171D8F18ECD230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517245, 'MT94', 'NL32-02', NULL, 'STEG', 'Steg', 'Steg', '01010000201555000027E96F9ACBC12541143784E587F50D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517246, 'MS57', 'NL32-05', NULL, 'STEIN', 'Stein', 'Stein', '0101000020155500004F726018839724419AED761E13840541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517247, 'NT24', 'NL32-02', NULL, 'STEIN', 'Stein', 'Stein', '010100002015550000564799C02AAD264113B48593B67D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517248, 'MT26', 'NL32-01', NULL, 'STEIN', 'Stein', 'Stein', '01010000201555000026D0F14F557C23411DB90DFE6A2A1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517251, 'MT87', 'NL32-02', NULL, 'STEINAMRHEIN', 'Stein am Rhein', 'Stein am Rhein', '010100002015550000B0648C56EC8B25413E582C0F0C021141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517252, 'MT61', 'NL32-02', NULL, 'STEINEN', 'Steinen', 'Steinen', '010100002015550000E376AB85E800254153E523750AD60941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517253, 'MS05', 'NL32-04', NULL, 'STEINENBERG', 'Steinenberg', 'Steinenberg', '0101000020155500001F983DBE0B14234120248CDF46FA0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517254, 'MT61', 'NL32-02', NULL, 'STEINERBERG', 'Steinerberg', 'Steinerberg', '0101000020155500003B4FEAEE03F724410D668D9775D50941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517256, 'MS34', 'NL32-05', NULL, 'STEINHAUS', 'Steinhaus', 'Steinhaus', '01010000201555000044BC12EFC8042441A6F7779E8D310141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517257, 'LS78', 'NL32-04', NULL, 'STEINHAUS', 'Steinhaus', 'Steinhaus', '01010000201555000096D7BA87BC102241580742921AD10641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517258, 'MT52', 'NL32-02', NULL, 'STEINHAUSEN', 'Steinhausen', 'Steinhausen', '0101000020155500003C122FBF0EB024416D88A802B6DA0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517259, 'NS19', 'NL32-05', NULL, 'STEINIBACH', 'Steinibach', 'Steinibach', '01010000201555000079077CB8F63F26413799E9DAFB1D0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517261, 'MT94', 'NL32-02', NULL, 'STERNENBERG', 'Sternenberg', 'Sternenberg', '0101000020155500003068B6C169B725416821143F94680E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517262, 'MT96', 'NL32-02', NULL, 'STETTFURT', 'Stettfurt', 'Stettfurt', '0101000020155500009AFA828290C825418AFC68A394391041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517263, 'LT80', 'NL32-04', NULL, 'STETTLEN', 'Stettlen', 'Stettlen', '010100002015550000288DF0ADD2872241194543295F660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517265, 'MT36', 'NL32-02', NULL, 'STILLI', 'Stilli', 'Stilli', '01010000201555000009BB622B8A0F24413C26A526D90F1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517266, 'MS79', 'NL32-05', NULL, 'STOCK', 'Stock', 'Stock', '01010000201555000077123EAB26202541BB22A72A92420841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517269, 'MT70', 'NL32-05', NULL, 'STOOS', 'Stoos', 'Stoos', '0101000020155500000E930FC26229254103D503E5DEF00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517270, 'NT34', 'NL32-02', NULL, 'STOSS', 'Stoss', 'Stoss', '0101000020155500005BFE5130D70F2741AE310CF7BD4D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517271, 'LS78', 'NL32-04', NULL, 'STOSSEN', 'Stössen', 'Stossen', '0101000020155500002C4D634F73382241F3460A6841230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517272, 'NS58', 'NL32-05', NULL, 'STRASSBERG', 'Strassberg', 'Strassberg', '0101000020155500009BF6B62C9CA627417D3C79F0CA5A0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517274, 'MT13', 'NL32-01', NULL, 'STRENGELBACH', 'Strengelbach', 'Strengelbach', '0101000020155500001C347C39226A234136C99E95D5B50C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517275, 'LT70', 'NL32-04', NULL, 'STUCKISHAUS', 'Stuckishaus', 'Stuckishaus', '0101000020155500003E31A5B070422241CA134FE125A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517277, 'NS56', 'NL32-05', NULL, 'STULS', 'Stuls', 'Stuls', '01010000201555000068B701241DAC27417E2CC6616B6A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517278, 'NS46', 'NL32-05', NULL, 'STURVIS', 'Stürvis', 'Sturvis', '010100002015550000AE0624BABC332741D7E37FBFC9D00441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517279, 'LT71', 'NL32-01', NULL, 'SUBERG', 'Suberg', 'Suberg', '0101000020155500000B7A83D0FD1022410354D532D2C10941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517280, 'LT92', 'NL32-01', NULL, 'SUBINGEN', 'Subingen', 'Subingen', '010100002015550000D926270AE5B822416BD4824541CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517283, 'LS17', 'NL32-04', NULL, 'SUCHY', 'Suchy', 'Suchy', '010100002015550000A2FAD3E7905A204156D3DAA25F460541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517284, 'MS08', 'NL32-04', NULL, 'SUDERN', 'Südern', 'Sudern', '01010000201555000067AE6D86240923417C1AF1657F980641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517286, 'NS25', 'NL32-05', NULL, 'SUFERS', 'Sufers', 'Sufers', '01010000201555000076E488CD41D226414A2A7CDF476B0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517287, 'LT50', 'NL32-04', NULL, 'SUGIEZ', 'Sugiez', 'Sugiez', '010100002015550000D52BA1B829862141DE890795E3A10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517288, 'MT34', 'NL32-02', NULL, 'SUHR', 'Suhr', 'Suhr', '01010000201555000011C23527F5CB234188DD67F413140E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517292, 'NT16', 'NL32-02', NULL, 'SULGEN', 'Sulgen', 'Sulgen', '01010000201555000036D90A22CD512641E0FC2A07473F1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517293, 'NS03', 'NL32-05', NULL, 'SULGONE', 'Sulgone', 'Sulgone', '010100002015550000A4A9DFD88FF9254104CEA699DF140141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517294, 'NS76', 'NL32-05', NULL, 'SULSANA', 'Sulsana', 'Sulsana', '010100002015550000EE2B66109B412841A364F1D8DE7C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517297, 'MT36', 'NL32-02', NULL, 'SULZ', 'Sulz', 'Sulz', '0101000020155500002A03ACC692D423412B504059BC2B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517299, 'MS69', 'NL32-05', NULL, 'SULZTHAL', 'Sulzthal', 'Sulzthal', '01010000201555000062E288F64FC724412D001E459CC90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517300, 'MT00', 'NL32-01', NULL, 'SUMISWALD', 'Sumiswald', 'Sumiswald', '0101000020155500000CC28B2980FE2241FFC6A2FF0D890941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517302, 'MS07', 'NL32-04', NULL, 'SUNDLAUENEN', 'Sundlauenen', 'Sundlauenen', '0101000020155500008ED3EC38861D2341618A65ACA2C90441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517303, 'NS83', 'NL32-06', NULL, 'SURACQUA', 'Suracqua', 'Suracqua', '010100002015550000A90F0678BA8E2841C0AEBCFC27220141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517304, 'NS46', 'NL32-05', NULL, 'SURAVA', 'Surava', 'Surava', '01010000201555000031EF7FDB8A6527411641900837D60441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517306, 'NS87', 'NL32-06', NULL, 'SUREN', 'Suren', 'Suren', '0101000020155500001077C16F32AB28417EF08BE9865A0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517309, 'NS64', 'NL32-05', NULL, 'SURLEJ', 'Surlej', 'Surlej', '010100002015550000584ADEA8C5D82741655D11BE8EF20141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517310, 'NS06', 'NL32-05', NULL, 'SURRHIN', 'Surrhin', 'Surrhin', '0101000020155500000BB17692BA3026416F92D81AFBB70441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517311, 'MT32', 'NL32-02', NULL, 'SURSEE', 'Sursee', 'Sursee', '010100002015550000F5BF098E41D7234198D99A34905D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517312, 'NS87', 'NL32-06', NULL, 'SUS', 'Süs', 'Sus', '01010000201555000032FA2595FB792841D0DAB25CD9190641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517328, 'LS68', 'NL32-04', NULL, 'TAFERS', 'Tafers', 'Tafers', '01010000201555000089E9E8D21DCB214160230E47E35D0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517329, 'NT07', 'NL32-02', NULL, 'TAGERWILEN', 'Tägerwilen', 'Tagerwilen', '010100002015550000053D408D6C282641F822A20136081141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517330, 'NS01', 'NL32-05', NULL, 'TAGLIADA', 'Tagliada', 'Tagliada', '01010000201555000028C2D4C336252641BAF6133CFFC2FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517334, 'NS38', 'NL32-05', NULL, 'TAMINS', 'Tamins', 'Tamins', '010100002015550000A589E7676DE02641206466735C0B0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517335, 'LS33', 'NL32-04', NULL, 'TANAY', 'Tanay', 'Tanay', '010100002015550000C3D4439279E320415ACD333D7F470041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517338, 'MT95', 'NL32-02', NULL, 'TANIKON', 'Tänikon', 'Tanikon', '010100002015550000C85F10EAF6AB254146AA34943BC30F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517339, 'MT83', 'NL32-02', NULL, 'TANN', 'Tann', 'Tann', '010100002015550000B282C7AFE9912541B070101367D00C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517341, 'MS47', 'NL32-05', NULL, 'TANNEN', 'Tannen', 'Tannen', '010100002015550000E6AB14656C6524414C096DFA7DF50541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517345, 'NS98', 'NL32-06', NULL, 'TARASP', 'Tarasp', 'Tarasp', '0101000020155500009F8599EF60DC2841A78AF85E699B0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517346, 'NS37', 'NL32-05', NULL, 'TARTAR', 'Tartar', 'Tartar', '01010000201555000036686BAFE9EC26415384EF5230770541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517347, 'NS49', 'NL32-05', NULL, 'TARVIERSCH', 'Tarviersch', 'Tarviersch', '010100002015550000C22938CD2A2D274162D87D63BDA80841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517348, 'MS00', 'NL32-04', NULL, 'TASCH', 'Täsch', 'Tasch', '0101000020155500002DA2DE16CC152341AFB4B63F75D6F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517349, 'LT61', 'NL32-01', NULL, 'TAUFFELEN', 'Täuffelen', 'Tauffelen', '0101000020155500008BA04856E2C12141620A92FD6BFC0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517350, 'NS07', 'NL32-05', NULL, 'TAVANASA', 'Tavanasa', 'Tavanasa', '0101000020155500000BC3E2CC5A112641D7617043ECD60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517351, 'LT63', 'NL32-01', NULL, 'TAVANNES', 'Tavannes', 'Tavannes', '01010000201555000091F4D54148C2214132ED80808D050C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517352, 'MS90', 'NL32-05', NULL, 'TAVERNE', 'Taverne', 'Taverne', '010100002015550000599F6D6B07D72541D838EF38FB17F940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517356, 'LS52', 'NL32-04', NULL, 'TAVEYANNAZ', 'Taveyannaz', 'Taveyannaz', '010100002015550000A0196604B08D21412231E732872BFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517357, 'MT15', 'NL32-01', NULL, 'TECKNAU', 'Tecknau', 'Tecknau', '0101000020155500006C1CF85586552341FE8082AC56320F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517358, 'MT46', 'NL32-02', NULL, 'TEGERFELDEN', 'Tegerfelden', 'Tegerfelden', '010100002015550000F70225D81B4024410982B35CB6671041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517359, 'MS71', 'NL32-05', NULL, 'TEGNA', 'Tegna', 'Tegna', '01010000201555000024427359785C2541310C67BB4231FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517361, 'MS81', 'NL32-05', NULL, 'TENERO', 'Tenero', 'Tenero', '0101000020155500004027F45FD6A225412CC7AA60F83AFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517362, 'MS96', 'NL32-05', NULL, 'TENIGERBAD', 'Tenigerbad', 'Tenigerbad', '010100002015550000BBADF8D9BEE0254107DC144263EB0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517363, 'NS27', 'NL32-05', NULL, 'TENNA', 'Tenna', 'Tenna', '010100002015550000150B928973BA2641546BD02D0AE60541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517367, 'MS23', 'NL32-05', NULL, 'TERMEN', 'Termen', 'Termen', '0101000020155500000DF1950039AB23413C203A21120D0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517370, 'LS44', 'NL32-04', NULL, 'TERRITET', 'Territet', 'Territet', '0101000020155500004053968AFC1F2141A1BF772D612D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517371, 'MS90', 'NL32-05', NULL, 'TESSERETE', 'Tesserete', 'Tesserete', '010100002015550000B6284E202DEB2541811EF046161BF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517374, 'NT24', 'NL32-02', NULL, 'TEUFEN', 'Teufen', 'Teufen', '0101000020155500008EF70ACFA7CA2641327858AB99800E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517375, 'MT66', 'NL32-02', NULL, 'TEUFEN', 'Teufen', 'Teufen', '010100002015550000F8CF992E14DD2441A2B317D9AA4E1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517377, 'MT34', 'NL32-02', NULL, 'TEUFENTHAL', 'Teufenthal', 'Teufenthal', '0101000020155500008BBDF8C5E0DF234163EF2859EEA00D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517378, 'MS08', 'NL32-04', NULL, 'TEUFFENTHAL', 'Teuffenthal', 'Teuffenthal', '010100002015550000056D26D879EB2241BFD085485DEA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517379, 'NS45', 'NL32-05', NULL, 'TGA', 'Tga', 'Tga', '0101000020155500004B13D4852E552741ABF62CD71FCB0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517380, 'NS47', 'NL32-05', NULL, 'TGANTIENI', 'Tgantieni', 'Tgantieni', '010100002015550000F2774FEB933227417EDAA88D6C7E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517381, 'NS26', 'NL32-05', NULL, 'THAL', 'Thal', 'Thal', '01010000201555000050035D7FFE9E26415859B3DC024E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517382, 'MT35', 'NL32-02', NULL, 'THALHEIM', 'Thalheim', 'Thalheim', '010100002015550000A44AF1164ED523412995781C07FC0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517383, 'MT86', 'NL32-02', NULL, 'THALHEIM', 'Thalheim', 'Thalheim', '010100002015550000D84AF0567152254110348A1E406F1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517385, 'MT63', 'NL32-02', NULL, 'THALWIL', 'Thalwil', 'Thalwil', '0101000020155500007146659035EA2441E124D7A075FF0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517386, 'MT78', 'NL32-02', NULL, 'THAYNGEN', 'Thayngen', 'Thayngen', '0101000020155500009DF58732B93225415CF89E47D08F1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517388, 'LT96', 'NL32-01', NULL, 'THERWIL', 'Therwil', 'Therwil', '010100002015550000FFE0D70910912241C858BE184ADD0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517392, 'LT51', 'NL32-01', NULL, 'THIELLE', 'Thielle', 'Thielle', '01010000201555000072C5B973D35E2141E4343C633F8A0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517393, 'LS97', 'NL32-04', NULL, 'THIERACHERN', 'Thierachern', 'Thierachern', '01010000201555000098B53CEEED9B22419731AC90ADAF0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517394, 'LS27', 'NL32-04', NULL, 'THIERRENS', 'Thierrens', 'Thierrens', '0101000020155500003EE0F9B908B420410F6C8730FB080541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48744, 'KS81', 'NL32-04', NULL, 'THONEX', 'Thônex', 'Thonex', '0101000020155500005D0B9E1374A01E4120C077F59C2FFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517397, 'LT90', 'NL32-01', NULL, 'THORBERG', 'Thorberg', 'Thorberg', '01010000201555000037A00ED5939B2241BA52502F30140941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517398, 'LS79', 'NL32-04', NULL, 'THORISHAUS', 'Thörishaus', 'Thorishaus', '010100002015550000659B3C91BC1A22414F19571EA8B80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517400, 'LS97', 'NL32-04', 3, 'THUN', 'Thun', 'Thun', '0101000020155500008E359006C7B92241C18DC6DAE8AF0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517402, 'MT96', 'NL32-02', NULL, 'THUNDORF', 'Thundorf', 'Thundorf', '010100002015550000AB90E10E5ED22541F53904E0F5391041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517404, 'LT92', 'NL32-01', NULL, 'THUNSTETTEN', 'Thunstetten', 'Thunstetten', '0101000020155500002E7F798129A52241CD1FE2ED17CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517411, 'NS37', 'NL32-05', NULL, 'THUSIS', 'Thusis', 'Thusis', '010100002015550000F89A5AE499F7264121A66D7C6F040541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517419, 'MS55', 'NL32-05', NULL, 'TIEFENBACH', 'Tiefenbach', 'Tiefenbach', '010100002015550000035FC5CF12B72441E818828E8D7C0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517423, 'NS46', 'NL32-05', NULL, 'TIEFENCASTEL', 'Tiefencastel', 'Tiefencastel', '01010000201555000056C4332404522741FD8AF527249A0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517426, 'LS85', 'NL32-04', NULL, 'TIERMATTI', 'Tiermatti', 'Tiermatti', '01010000201555000046841A583E742241F42630B07E6C0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517430, 'NS45', 'NL32-05', NULL, 'TINZEN', 'Tinzen', 'Tinzen', '01010000201555000038A890378D67274179AEFDE7D4B40341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517435, 'MT05', 'NL32-01', NULL, 'TITTERTEN', 'Titterten', 'Titterten', '010100002015550000868843697AF32241B768462DCF820E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517436, 'NT06', 'NL32-02', NULL, 'TOBEL', 'Tobel', 'Tobel', '01010000201555000008DB3F73DFF92541D4F7FB89921E1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517438, 'LS89', 'NL32-04', NULL, 'TOFFEN', 'Toffen', 'Toffen', '010100002015550000B6A24345206A2241289B6531C3440741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517440, 'NS37', 'NL32-05', NULL, 'TOMILS', 'Tomils', 'Tomils', '0101000020155500006B8AA03FB4FF2641313771FEDA260641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517442, 'MS12', 'NL32-04', NULL, 'TORBEL', 'Törbel', 'Torbel', '01010000201555000020429C36574723416280F0CE1CD2FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517445, 'MS94', 'NL32-05', NULL, 'TORRE', 'Torre', 'Torre', '0101000020155500008BAE6EB221DA254158F3726DF5330241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517451, 'LS60', 'NL32-04', NULL, 'TORTIN', 'Tortin', 'Tortin', '01010000201555000086CE90ACC2FB2141FAEB953E272FFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517452, 'MT76', 'NL32-02', NULL, 'TOSS', 'Töss', 'Toss', '010100002015550000A8E23C5CFB3525417693E526F6F40F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517456, 'MT85', 'NL32-02', NULL, 'TOSSEGG', 'Tössegg', 'Tossegg', '0101000020155500000CFE4AB47C8525416CEE9EEFAC120F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517458, 'MT66', 'NL32-02', NULL, 'TOSSRIEDERN', 'Tössriedern', 'Tossriedern', '0101000020155500001C8C337F13D32441B5AD1A31586B1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517469, 'MS15', 'NL32-04', NULL, 'TRACHSELLAUENEN', 'Trachsellauenen', 'Trachsellauenen', '010100002015550000A87D55E91A642341FAE3952116880241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517470, 'MT00', 'NL32-01', NULL, 'TRACHSELWALD', 'Trachselwald', 'Trachselwald', '01010000201555000058EADC0B8EFE22411B56EC30274F0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517471, 'LT53', 'NL32-01', NULL, 'TRAMELAN', 'Tramelan', 'Tramelan', '010100002015550000C50B0E892A8721416E963EC854400C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517472, 'NS37', 'NL32-05', NULL, 'TRANS', 'Trans', 'Trans', '0101000020155500006B8AA03FB4FF2641313771FEDA260641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517473, 'MT57', 'NL32-02', NULL, 'TRASADINGEN', 'Trasadingen', 'Trasadingen', '0101000020155500008737C7D7688D244124366A7741171141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517474, 'LT20', 'NL32-04', NULL, 'TRAVERS', 'Travers', 'Travers', '0101000020155500005F52C8F2278E2041E833BB2C04350841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517477, 'NS16', 'NL32-05', NULL, 'TRAVISASCH', 'Travisasch', 'Travisasch', '010100002015550000D9F991C2806C26419A71BF8E32BD0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517478, 'MT60', 'NL32-05', NULL, 'TREIB', 'Treib', 'Treib', '010100002015550000F6BD983612F824414575EAE3FAB30841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517479, 'KS84', 'NL32-04', NULL, 'TRELEX', 'Trélex', 'Trelex', '010100002015550000245BA85F12CF1E41087F6501FF400141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517486, 'NT40', 'NL32-05', NULL, 'TRETSCH', 'Tretsch', 'Tretsch', '01010000201555000016E07BC0AF36274157195DEAAEE30841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517487, 'LS48', 'NL32-04', NULL, 'TREY', 'Trey', 'Trey', '010100002015550000C6F4A5D1001821416725D79E7EED0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517488, 'LS47', 'NL32-04', NULL, 'TREYFAYES', 'Treyfayes', 'Treyfayes', '010100002015550000A9E6025F5A2B2141A02B4A1F97910441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517489, 'LS57', 'NL32-04', NULL, 'TREYVAUX', 'Treyvaux', 'Treyvaux', '010100002015550000393B499F3099214189649EFBF5760541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517490, 'MT40', 'NL32-02', NULL, 'TRIBSCHEN', 'Tribschen', 'Tribschen', '01010000201555000092584E8AC86224416DDB4BEDD8930941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517491, 'MT33', 'NL32-02', NULL, 'TRIENGEN', 'Triengen', 'Triengen', '0101000020155500004F805B95E8CC23419A80B848D8440C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517492, 'LS40', 'NL32-04', NULL, 'TRIENT', 'Trient', 'Trient', '01010000201555000006E6FF6E3E4621412BD8E4155265F840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517494, 'MT14', 'NL32-01', NULL, 'TRIMBACH', 'Trimbach', 'Trimbach', '010100002015550000F4CDAC11C55F2341F3FDDFD507110E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517495, 'NS49', 'NL32-05', NULL, 'TRIMMIS', 'Trimmis', 'Trimmis', '010100002015550000957C5BA73E382741A0F7F87D29FC0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517497, 'LS99', 'NL32-04', NULL, 'TRIMSTEIN', 'Trimstein', 'Trimstein', '01010000201555000013BD22DFB79B2241F1BBC1B4C7B80741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517498, 'NS28', 'NL32-05', NULL, 'TRINS', 'Trins', 'Trins', '010100002015550000A9805671A2C226411C5C90426B080741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517500, 'NS28', 'NL32-05', NULL, 'TRINSERMUHLE', 'Trinsermühle', 'Trinsermuhle', '010100002015550000FF370D17B4B826412560B18474070741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517501, 'NT34', 'NL32-02', NULL, 'TROGEN', 'Trogen', 'Trogen', '01010000201555000006F004836DFB2641A832AFBA77BF0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517502, 'LS32', 'NL32-04', NULL, 'TROISTORRENTS', 'Troistorrents', 'Troistorrents', '01010000201555000064DA403CD1142141372BB118C0EDFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517503, 'MT10', 'NL32-04', NULL, 'TRUB', 'Trub', 'Trub', '010100002015550000DE983794FB5723415559A1D139690841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517504, 'NT31', 'NL32-02', NULL, 'TRUBBACH', 'Trübbach', 'Trubbach', '0101000020155500008FED0973E902274192ADDA76C0390A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517505, 'MS19', 'NL32-04', NULL, 'TRUBSCHACHEN', 'Trubschachen', 'Trubschachen', '0101000020155500006B694E28643A2341C4068624CAF40741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517506, 'MT77', 'NL32-02', NULL, 'TRULLIKON', 'Trüllikon', 'Trullikon', '0101000020155500006CFCF4BC552A2541FE149153C8E11041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517509, 'MS97', 'NL32-05', NULL, 'TRUN', 'Trun', 'Trun', '01010000201555000018F31AB890E92541AFD41B9EB8D30541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517511, 'MS76', 'NL32-05', NULL, 'TSCHAMUT', 'Tschamut', 'Tschamut', '010100002015550000B882BF7BD941254113C26896456C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517513, 'LS85', 'NL32-04', NULL, 'TSCHENTEN', 'Tschenten', 'Tschenten', '01010000201555000065150C2D49922241B29E9FC8214B0241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517514, 'NS48', 'NL32-05', NULL, 'TSCHIERTSCHEN', 'Tschiertschen', 'Tschiertschen', '01010000201555000029580718FE5727414F5BACEF02DE0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517515, 'LS93', 'NL32-04', NULL, 'TSCHINGEREN', 'Tschingeren', 'Tschingeren', '010100002015550000C988ACFC9EC42241D897E83789080041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517516, 'NS68', 'NL32-05', NULL, 'TSCHUGGEN', 'Tschuggen', 'Tschuggen', '010100002015550000570330C8A01528412E97CE2799800641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517517, 'MT92', 'NL32-02', NULL, 'TUGGEN', 'Tuggen', 'Tuggen', '010100002015550000B06A720047C425419459E66079EC0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517520, 'NS66', 'NL32-05', NULL, 'TUORSDAVANT', 'Tuors Davant', 'Tuors Davant', '0101000020155500000BC2A94B8BD327410DBF7AB806A90441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517521, 'NS26', 'NL32-05', NULL, 'TURAHUS', 'Turahus', 'Turahus', '01010000201555000050035D7FFE9E26415859B3DC024E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517523, 'MT85', 'NL32-02', NULL, 'TURBENTHAL', 'Turbenthal', 'Turbenthal', '010100002015550000129A270C4F8F2541CE0110CF60130F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517524, 'MT45', 'NL32-02', NULL, 'TURGI', 'Turgi', 'Turgi', '010100002015550000E495DDCE422D244196F588E80FAD0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517525, 'LS92', 'NL32-04', NULL, 'TURTMANN', 'Turtmann', 'Turtmann', '0101000020155500003E5C637CD2EC22416CA1A4A4682AFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517530, 'LT51', 'NL32-01', NULL, 'TWANN', 'Twann', 'Twann', '0101000020155500003792F28B51A4214114555B99A0700A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517532, 'MT51', 'NL32-02', NULL, 'UDLIGENSWIL', 'Udligenswil', 'Udligenswil', '010100002015550000DCA355D8A8892441C20EA63A507D0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517533, 'NS49', 'NL32-05', NULL, 'UEBERLANDQUART', 'Ueberlandquart', 'Ueberlandquart', '01010000201555000048718405B65E27410E9F695D23AE0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517534, 'LS79', 'NL32-04', NULL, 'UEBERSTORF', 'Ueberstorf', 'Ueberstorf', '010100002015550000F072418AEBFC2141D7D3098907450741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517535, 'MT83', 'NL32-02', NULL, 'UERIKON', 'Uerikon', 'Uerikon', '0101000020155500008B820E22485725417374713981580C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517536, 'MT23', 'NL32-02', NULL, 'UERKHEIM', 'Uerkheim', 'Uerkheim', '01010000201555000038C5FA050BA52341011615853B2B0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517537, 'MT87', 'NL32-02', NULL, 'UESSLINGEN', 'Uesslingen', 'Uesslingen', '0101000020155500003929A386607925412E08C0828B8D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517538, 'LS98', 'NL32-04', NULL, 'UETENDORF', 'Uetendorf', 'Uetendorf', '01010000201555000029618DECE79B2241A6B7EBEC93E90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517539, 'MT73', 'NL32-02', NULL, 'UETIKON', 'Uetikon', 'Uetikon', '01010000201555000004B2F2D4882525416A13D9421CC90C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517542, 'LT70', 'NL32-04', NULL, 'UETTLIGEN', 'Uettligen', 'Uettligen', '010100002015550000535447BFA12E224111FFCDE416DA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517544, 'MT22', 'NL32-02', NULL, 'UFFIKON', 'Uffikon', 'Uffikon', '0101000020155500000A67DA6893A523419596C9A9B6090C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517545, 'MT11', 'NL32-01', NULL, 'UFHUSEN', 'Ufhusen', 'Ufhusen', '010100002015550000636D85820B612341A09F04D377AC0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517546, 'MT77', 'NL32-02', NULL, 'UHWIESEN', 'Uhwiesen', 'Uhwiesen', '010100002015550000F1F852EC890C25410FB45BACC61A1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517547, 'PS08', 'NL32-06', NULL, 'UINADADORA', 'Uina Dadora', 'Uina Dadora', '010100002015550000CB4AB5DEDE2B2941BF82583115A70641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517548, 'MT54', 'NL32-02', NULL, 'UITIKON', 'Uitikon', 'Uitikon', '01010000201555000001E82C4829AE24417C9DDE31B81D0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517550, 'MS44', 'NL32-05', NULL, 'ULRICHEN', 'Ulrichen', 'Ulrichen', '010100002015550000391F6BDD12542441DA0CDD8945560241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517555, 'LT64', 'NL32-01', NULL, 'UNDERVELIER', 'Undervelier', 'Undervelier', '0101000020155500002428A5EA59CC214118159A46F6260D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517558, 'MT62', 'NL32-02', NULL, 'UNTERAGERI', 'Unterägeri', 'Unterageri', '010100002015550000E068F3A5F5F524415F742392F1F60A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517560, 'MS37', 'NL32-05', NULL, 'UNTERBACH', 'Unterbach', 'Unterbach', '0101000020155500006E681DDA60E423412D94DCFE837C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517559, 'MS02', 'NL32-04', NULL, 'UNTERBACH', 'Unterbäch', 'Unterbach', '01010000201555000011DB1E4426292341552DFF53B944FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517561, 'LS94', 'NL32-04', NULL, 'UNTERBACHEN', 'Unterbächen', 'Unterbachen', '01010000201555000047BFEEAE5DBA2241CC5384D8BA9D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517563, 'NT04', 'NL32-02', NULL, 'UNTERBAZENHEID', 'Unter-Bazenheid', 'Unter-Bazenheid', '01010000201555000008C21659960F26419AB071207BA90E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517564, 'NT02', 'NL32-02', NULL, 'UNTERBILTEN', 'Unter-Bilten', 'Unter-Bilten', '0101000020155500003BBCBC0979F6254157EA1022A9420B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517565, 'MT76', 'NL32-02', NULL, 'UNTERBUCH', 'Unter-Buch', 'Unter-Buch', '010100002015550000435AEAF1140E25412246368E1B501041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517566, 'LS84', 'NL32-04', NULL, 'UNTERDEMBIRG', 'Unter dem Birg', 'Unter dem Birg', '01010000201555000092F6120D5A9C224141D5F3387F9D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517567, 'MT46', 'NL32-02', NULL, 'UNTEREHRENDINGEN', 'Unterehrendingen', 'Unterehrendingen', '010100002015550000A210D9AF295E244135146BE519E90F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517568, 'MS26', 'NL32-05', NULL, 'UNTEREIGER', 'Unter Eiger', 'Unter Eiger', '010100002015550000BD53FF0B709F23418DDD792708E50341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517571, 'MT55', 'NL32-02', NULL, 'UNTERENGSTRINGEN', 'Unterengstringen', 'Unterengstringen', '0101000020155500004A689FFDF09924410588E4186ACA0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517572, 'MT25', 'NL32-02', NULL, 'UNTERERLINSBACH', 'Untererlinsbach', 'Untererlinsbach', '010100002015550000CE93181A939A23413331401361860E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517574, 'LT90', 'NL32-04', NULL, 'UNTERGOMERKINDEN', 'Unter-Gomerkinden', 'Unter-Gomerkinden', '010100002015550000092146D821CD2241A2A12977B6DA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517575, 'MT81', 'NL32-02', NULL, 'UNTERIBERG', 'Unteriberg', 'Unteriberg', '01010000201555000042217863BA6D2541D998A616FEDC0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517576, 'MT74', 'NL32-02', NULL, 'UNTERILLNAU', 'Unter Illnau', 'Unter Illnau', '010100002015550000C6C67FD134412541E45F41B3309A0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517577, 'MT34', 'NL32-02', NULL, 'UNTERKULM', 'Unterkulm', 'Unterkulm', '0101000020155500007F811DC700E023419D0815E806670D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517580, 'NS68', 'NL32-05', NULL, 'UNTERLARET', 'Unter-Laret', 'Unter-Laret', '010100002015550000A037545318EC2741BDB1F0E021630741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517581, 'MS26', 'NL32-05', NULL, 'UNTERLAUCHBUHL', 'Unter Lauchbühl', 'Unter Lauchbuhl', '01010000201555000025BB97ED2FD1234130FFF0E975200441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517582, 'MT54', 'NL32-02', NULL, 'UNTERLUNKHOFEN', 'Unterlunkhofen', 'Unterlunkhofen', '010100002015550000F2CCB2A4827D2441D2C9A41E8A6D0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517584, 'MS89', 'NL32-05', NULL, 'UNTERSCHACHEN', 'Unterschächen', 'Unterschachen', '0101000020155500002027A7D0876625411C634E3C7E5F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517585, 'MT77', 'NL32-02', NULL, 'UNTERSCHLATT', 'Unter-Schlatt', 'Unter-Schlatt', '01010000201555000065C57A8AA73325416211C827001C1141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517586, 'MS09', 'NL32-04', NULL, 'UNTERSCHWENDIMATT', 'Unter Schwendimatt', 'Unter Schwendimatt', '010100002015550000E0608DAF23EB224162D083FEA97F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517588, 'MS17', 'NL32-04', NULL, 'UNTERSEEN', 'Unterseen', 'Unterseen', '010100002015550000D6C2AADB5E4523413A5EC7EB66CA0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517591, 'MT46', 'NL32-02', NULL, 'UNTERSIGGENTHAL', 'Untersiggenthal', 'Untersiggenthal', '0101000020155500006BE99E7F1C2D24411D186FFAF7E60F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517592, 'MT46', 'NL32-02', NULL, 'UNTERSIGGENTHAL', 'Untersiggenthal', 'Untersiggenthal', '01010000201555000007A7F9580754244151C2493D3C2E1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517593, 'MS07', 'NL32-04', NULL, 'UNTERSOHL', 'Unter-Sohl', 'Unter-Sohl', '010100002015550000BC60F17019312341E12F7E237FEB0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517594, 'MS89', 'NL32-05', NULL, 'UNTERSTAFFEL', 'Unter Staffel', 'Unter Staffel', '010100002015550000173C2FE3348D2541AABA89E1D0490841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517595, 'MT87', 'NL32-02', NULL, 'UNTERSTAMMHEIM', 'Unter-Stammheim', 'Unter-Stammheim', '0101000020155500002F8350E2CB64254130D25427AC001141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517596, 'NT11', 'NL32-02', NULL, 'UNTERTERZEN', 'Unterterzen', 'Unterterzen', '01010000201555000071C2A8B95D8126419E37EB75D4DA0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517597, 'NS49', 'NL32-05', NULL, 'UNTERVAZ', 'Untervaz', 'Untervaz', '010100002015550000C65E7BBD8D2D27414E46B0E7DB6E0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517602, 'NT22', 'NL32-02', NULL, 'UNTERWASSER', 'Unterwasser', 'Unterwasser', '010100002015550000CE95DD29499D2641A07696290BFF0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517603, 'MT84', 'NL32-02', NULL, 'UNTERWETZIKON', 'Unter-Wetzikon', 'Unter-Wetzikon', '01010000201555000067EF6D3BC2692541C08A7C71537B0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517604, 'LT70', 'NL32-04', NULL, 'UNTERWOHLEN', 'Unter-Wohlen', 'Unter-Wohlen', '010100002015550000A4DAF680CD1A22412CC7240043A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517615, 'NS37', 'NL32-05', NULL, 'URMEIN', 'Urmein', 'Urmein', '01010000201555000083B47A8352E326419233E2BC4E3C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517616, 'NT24', 'NL32-02', NULL, 'URNASCH', 'Urnäsch', 'Urnasch', '010100002015550000B64E62230A9126411FA3467456930D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517619, 'MS59', 'NL32-05', NULL, 'URNERSTAFEL', 'Urnerstafel', 'Urnerstafel', '010100002015550000C945EA8ABCA92441CE88865A248E0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517620, 'MT02', 'NL32-01', NULL, 'URSENBACH', 'Ursenbach', 'Ursenbach', '0101000020155500007A0EF2A9EE11234127D9AF61C8E40A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517624, 'LT80', 'NL32-01', NULL, 'URTENEN', 'Urtenen', 'Urtenen', '0101000020155500000D609C970B6A224161710CCEC6870941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517626, 'MT74', 'NL32-02', 3, 'USTER', 'Uster', 'Uster', '0101000020155500007D8A58214F3825413336307BF4B10D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517630, 'LS98', 'NL32-04', NULL, 'UTTIGEN', 'Uttigen', 'Uttigen', '01010000201555000063D0E0EAE19B2241050FF0397A230641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517631, 'NT27', 'NL32-02', NULL, 'UTTWIL', 'Uttwil', 'Uttwil', '010100002015550000D80309AAF8A82641BD921A4D369A1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517632, 'LT92', 'NL32-01', NULL, 'UTZENSTORF', 'Utzenstorf', 'Utzenstorf', '010100002015550000AD08D9DB829122415AB4E57A59E30A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517633, 'MT92', 'NL32-02', NULL, 'UZNACH', 'Uznach', 'Uznach', '010100002015550000F733D3EC95E1254142B7882FA9280C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517634, 'NT15', 'NL32-02', NULL, 'UZWIL', 'Uzwil', 'Uzwil', '010100002015550000A777383D45362641239CC3B399200F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517635, 'NR07', 'NL32-08', NULL, 'VACALLO', 'Vacallo', 'Vacallo', '010100002015550000F95D7EA54B1726417383302E6B40F340');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517637, 'MS80', 'NL32-05', NULL, 'VAIRANO', 'Vairano', 'Vairano', '010100002015550000100DFED17E8F25411695907DC5DCFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517643, 'LR39', 'NL32-04', NULL, 'VALANGIN', 'Valangin', 'Valangin', '01010000201555000057F953FF92092141268649DDBF80F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517644, 'NS98', 'NL32-06', NULL, 'VALATSCHA', 'Valatscha', 'Valatscha', '010100002015550000AB4B8E1971D22841FBA6C89EFD990641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517645, 'NS16', 'NL32-05', NULL, 'VALATSCHALP', 'Valatschalp', 'Valatschalp', '01010000201555000070FAE3547A6D2641F8910D4B8B0F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517646, 'NS13', 'NL32-05', NULL, 'VALBELLA', 'Valbella', 'Valbella', '010100002015550000B0309702A8492641B0EF58E7851B0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517647, 'PS06', 'NL32-06', NULL, 'VALCAVA', 'Valcava', 'Valcava', '010100002015550000634F4BF4D03B2941ECD2D55E242C0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517649, 'LS31', 'NL32-04', NULL, 'VALDILLIEZ', 'Val d’Illiez', 'Val d’Illiez', '0101000020155500004DC0CA8AAB0A2141D485E606807AFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517650, 'NS28', 'NL32-05', NULL, 'VALENDAS', 'Valendas', 'Valendas', '0101000020155500005D85ED99FD912641CEAF18F307560641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517651, 'NT30', 'NL32-05', NULL, 'VALENS', 'Valens', 'Valens', '01010000201555000080ABFB1F100F2741DF4139DB7BDF0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517654, 'LS07', 'NL32-04', NULL, 'VALLORBE', 'Vallorbe', 'Vallorbe', '010100002015550000B9B141C34EB21F41B9B31FE0A14C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517658, 'NS16', 'NL32-05', NULL, 'VALSPLATZ', 'Vals Platz', 'Vals Platz', '010100002015550000C5FA33A181632641AE87A615A70E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517659, 'NT20', 'NL32-05', NULL, 'VALTNOVALP', 'Valtnovalp', 'Valtnovalp', '010100002015550000E12CE61C00AC26413C98A81C93D50841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517660, 'NS49', 'NL32-05', NULL, 'VALZEINA', 'Valzeina', 'Valzeina', '010100002015550000407B6D67CD542741B75528A80AAD0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517661, 'KS82', 'NL32-04', NULL, 'VANDOEUVRES', 'Vandœuvres', 'Vandouvres', '010100002015550000DA352D5A94C91E4109340F169A14FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517662, 'NS06', 'NL32-05', NULL, 'VANESCHA', 'Vanescha', 'Vanescha', '010100002015550000B88ECD6DB41D264157D0B564A6080441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517664, 'LS93', 'NL32-04', NULL, 'VAREN', 'Varen', 'Varen', '010100002015550000C53C1DA5A0BA22412FB7E304169DFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517665, 'NS39', 'NL32-05', NULL, 'VASON', 'Vasön', 'Vason', '0101000020155500007C85EBFB87052741F62C639F92A40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517666, 'NS39', 'NL32-05', NULL, 'VATTIS', 'Vättis', 'Vattis', '01010000201555000028B7BDE772F2264101F9055BC62E0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517670, 'LS36', 'NL32-04', NULL, 'VAUDERENS', 'Vauderens', 'Vauderens', '010100002015550000F827E5493DEF2041A4498F308BE50341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517671, 'LT62', 'NL32-01', NULL, 'VAUFFELIN', 'Vauffelin', 'Vauffelin', '010100002015550000F3C864568AF321415E5EB8E93E910B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517672, 'KS97', 'NL32-04', NULL, 'VAULION', 'Vaulion', 'Vaulion', '010100002015550000189497ECEAB11F418864ADECBC120541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517674, 'LS46', 'NL32-04', NULL, 'VAULRUZ', 'Vaulruz', 'Vaulruz', '01010000201555000060BCA4D5004921411DA035E42FE30341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517675, 'LT80', 'NL32-04', NULL, 'VECHIGEN', 'Vechigen', 'Vechigen', '01010000201555000057701E44BC91224182EF96606C660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517682, 'MT45', 'NL32-02', NULL, 'VELTHEIM', 'Veltheim', 'Veltheim', '01010000201555000055C3741FE3232441C2FF9260F1FE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517683, 'MT76', 'NL32-02', NULL, 'VELTHEIM', 'Veltheim', 'Veltheim', '01010000201555000022C96A3384352541E138541D62341041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517685, 'LT65', 'NL32-01', NULL, 'VENDLINCOURT', 'Vendlincourt', 'Vendlincourt', '0101000020155500004B8F5F0171A52141FBB038B2A3300F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517688, 'LS15', 'NL32-04', NULL, 'VENNES', 'Vennes', 'Vennes', '010100002015550000E6900D28F9762041DFE22AA82B020341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517694, 'LS60', 'NL32-04', NULL, 'VERBIER', 'Verbier', 'Verbier', '010100002015550000C90DC35263C92141532E664149BCF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517695, 'KS61', 'NL32-04', NULL, 'VERBOIS', 'Verbois', 'Verbois', '01010000201555000020FDB54082EB1D41866AF5E20E3CFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517696, 'LS82', 'NL32-04', NULL, 'VERCORIN', 'Vercorin', 'Vercorin', '010100002015550000B494E122827E224120E3FAED1DCDFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517698, 'NS12', 'NL32-05', NULL, 'VERDABBIO', 'Verdabbio', 'Verdabbio', '01010000201555000041A533A231562641960F7BB6A19AFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517699, 'MS71', 'NL32-05', NULL, 'VERDASIO', 'Verdasio', 'Verdasio', '010100002015550000C6B6CBD25F20254159ECC33ED2B5FB40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517700, 'MS71', 'NL32-05', NULL, 'VERGELETTO', 'Vergeletto', 'Vergeletto', '010100002015550000CA5BCF9FAA15254135818B37F50FFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517701, 'LS83', 'NL32-04', NULL, 'VERMALA', 'Vermala', 'Vermala', '01010000201555000093914584646A2241577A0A912E9CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517702, 'LT84', 'NL32-01', NULL, 'VERMES', 'Vermes', 'Vermes', '010100002015550000D60FF1EA0E60224184657E5A099A0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517704, 'LS71', 'NL32-04', NULL, 'VERNAMIEGE', 'Vernamiège', 'Vernamiege', '010100002015550000B4C5CE314C4C224156A41D4557E5FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517705, 'LS51', 'NL32-04', NULL, 'VERNAYAZ', 'Vernayaz', 'Vernayaz', '01010000201555000018B54FEBE66E214122F24B79A2A6FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517708, 'LS80', 'NL32-04', NULL, 'VERNEC', 'Vernec', 'Vernec', '0101000020155500003AC2D0665B562241EF6EC36B8E2EFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517709, 'KS72', 'NL32-04', 3, 'VERNIER', 'Vernier', 'Vernier', '0101000020155500007A0D03EAED3C1E417886D4A6EA1DFD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517710, 'NS28', 'NL32-05', NULL, 'VERSAM', 'Versam', 'Versam', '010100002015550000CAD6B81167B926417B55624DB0930641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517711, 'MS71', 'NL32-05', NULL, 'VERSCIO', 'Verscio', 'Verscio', '01010000201555000024427359785C2541310C67BB4231FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517712, 'KS82', 'NL32-04', NULL, 'VERSOIX', 'Versoix', 'Versoix', '010100002015550000C478650046A31E41C48EBC0A4EE6FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517719, 'KS82', 'NL32-04', NULL, 'VESENAZ', 'Vésenaz', 'Vesenaz', '0101000020155500000BD7C38509CA1E41F453E75B6288FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517721, 'LS61', 'NL32-04', NULL, 'VETROZ', 'Vétroz', 'Vetroz', '010100002015550000AB351503DEF121411F10A92F17E6FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517722, 'LS34', 'NL32-04', NULL, 'VEVEY', 'Vevey', 'Vevey', '01010000201555000005CDFCA226EE2041277C0F9092A20141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517723, 'LS71', 'NL32-04', NULL, 'VEX', 'Vex', 'Vex', '010100002015550000DCD04AD731382241A6E83D149771FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517724, 'KS81', 'NL32-04', NULL, 'VEYRIER', 'Veyrier', 'Veyrier', '010100002015550000E3FE3F02AAC81E41CE27621D092DFC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517725, 'LS71', 'NL32-04', NULL, 'VEYSONNAZ', 'Veysonnaz', 'Veysonnaz', '010100002015550000DDC15DB6FD0F224150D52CA6E371FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517726, 'LS44', 'NL32-04', NULL, 'VEYTAUX', 'Veytaux', 'Veytaux', '0101000020155500004053968AFC1F2141A1BF772D612D0141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517730, 'NS82', 'NL32-06', NULL, 'VIANO', 'Viano', 'Viano', '010100002015550000EFDADC7DC3B028413F394B1BBAAEFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517731, 'NS43', 'NL32-05', NULL, 'VICOSOPRANO', 'Vicosoprano', 'Vicosoprano', '01010000201555000042AE99702D6D2741B2165FF2908A0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517732, 'LT84', 'NL32-01', NULL, 'VICQUES', 'Vicques', 'Vicques', '010100002015550000433C739B89422241139787B4F0D30D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517736, 'MR99', 'NL32-05', NULL, 'VIGANELLO', 'Viganello', 'Viganello', '01010000201555000029D461D61AF62541A0E1AA4C56C1F740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517737, 'NS17', 'NL32-05', NULL, 'VIGENS', 'Vigens', 'Vigens', '0101000020155500006D641810FC4D2641305CC16B522E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517739, 'MS65', 'NL32-05', NULL, 'VILLA', 'Villa', 'Villa', '01010000201555000034B47879CED524415B49C54C96960241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517740, 'NS17', 'NL32-05', NULL, 'VILLA', 'Villa', 'Villa', '010100002015550000EEA9713C9F572641DD6CC2A014690541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517743, 'LS47', 'NL32-04', NULL, 'VILLARSELLEGIBLOUX', 'Villarsel-le-Gibloux', 'Villarsel-le-Gibloux', '0101000020155500000C5F821172532141B07BFFB15B3E0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517744, 'LS47', 'NL32-04', NULL, 'VILLARSIVIRIAUX', 'Villarsiviriaux', 'Villarsiviriaux', '0101000020155500008B5984145E532141AA7B949C75040541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517745, 'LS49', 'NL32-04', NULL, 'VILLARSLEGRAND', 'Villars-le-Grand', 'Villars-le-Grand', '010100002015550000A9ADF306624A2141C056D31D78BB0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517746, 'LS58', 'NL32-04', NULL, 'VILLARSSURGLANE', 'Villars-sur-Glâne', 'Villars-sur-Glane', '010100002015550000DEDA71E0798F21410C4473DDB75E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517747, 'LS68', 'NL32-04', NULL, 'VILLARSSURMARLY', 'Villars-sur-Marly', 'Villars-sur-Marly', '010100002015550000068FAC4424B72141F243D0E154EA0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517748, 'LS42', 'NL32-04', NULL, 'VILLARSSUROLLON', 'Villars-sur-Ollon', 'Villars-sur-Ollon', '0101000020155500009B14B7E58E652141E6B44AA6FC2CFF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517749, 'LS56', 'NL32-04', NULL, 'VILLARVOLARD', 'Villarvolard', 'Villarvolard', '010100002015550000EFCD0EC6F884214128D26B6CCB550441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517750, 'LS47', 'NL32-04', NULL, 'VILLAZSAINTPIERRE', 'Villaz-Saint-Pierre', 'Villaz-Saint-Pierre', '0101000020155500006475735B943521417FB1AF6A0A3F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517752, 'LS44', 'NL32-04', NULL, 'VILLENEUVE', 'Villeneuve', 'Villeneuve', '0101000020155500007784459DE41F21411C6513707BF30041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517753, 'LT52', 'NL32-01', NULL, 'VILLERET', 'Villeret', 'Villeret', '010100002015550000B08337116D5F21414C68EC8477590B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517754, 'LS81', 'NL32-04', NULL, 'VILLETTA', 'Villetta', 'Villetta', '010100002015550000AEDBCE186B6022417FE8CA8C5FA2FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517756, 'MT46', 'NL32-02', NULL, 'VILLIGEN', 'Villigen', 'Villigen', '010100002015550000E5E253DA581924414A5C86630A101041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517757, 'MT44', 'NL32-02', NULL, 'VILLMERGEN', 'Villmergen', 'Villmergen', '01010000201555000074E8F845752E2441F6BEE682D2DD0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517758, 'MT35', 'NL32-02', NULL, 'VILLNACHERN', 'Villnachern', 'Villnachern', '010100002015550000F271E4E953FC2341C67D7F2C3B710F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517759, 'NT30', 'NL32-02', NULL, 'VILTERS', 'Vilters', 'Vilters', '010100002015550000E118A93923FA2641D6BCF345158B0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517760, 'KS84', 'NL32-04', NULL, 'VINZEL', 'Vinzel', 'Vinzel', '0101000020155500000CB79824020C1F41688BC730EBB20141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517761, 'LS32', 'NL32-04', NULL, 'VIONNAZ', 'Vionnaz', 'Vionnaz', '0101000020155500004CBD8C8F440B214194921D6F4431FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517762, 'MS80', 'NL32-05', NULL, 'VIRA', 'Vira', 'Vira', '010100002015550000DE5DC0958E992541BC3716AC31DEFA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517764, 'MS62', 'NL32-05', NULL, 'VISLETTO', 'Visletto', 'Visletto', '01010000201555000059E5BE708C0A2541B778D171AE51FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517765, 'MS12', 'NL32-04', NULL, 'VISP', 'Visp', 'Visp', '010100002015550000D6C2F579395123414DEE13E221BAFE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517769, 'MS12', 'NL32-04', NULL, 'VISPERTERMINEN', 'Visperterminen', 'Visperterminen', '01010000201555000025C43B19776523414EA8437973D3FD40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517770, 'LS72', 'NL32-04', NULL, 'VISSE', 'Visse', 'Visse', '01010000201555000054C766D71B102241AB647124AC28FF40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517771, 'LS91', 'NL32-04', NULL, 'VISSOIE', 'Vissoie', 'Vissoie', '010100002015550000BC065361BAA622416A91CBB5F9E5FC40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517775, 'MT60', 'NL32-02', NULL, 'VITZNAU', 'Vitznau', 'Vitznau', '010100002015550000DCDE3FEE0ABC2441026F03495A5E0941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517777, 'MT74', 'NL32-02', NULL, 'VOLKETSWIL', 'Volketswil', 'Volketswil', '01010000201555000048D765679C37254180DF475BA75F0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517779, 'MT13', 'NL32-01', NULL, 'VORDEMWALD', 'Vordemwald', 'Vordemwald', '010100002015550000AA50BF116D5623411C4ED7125FB50C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517780, 'MS88', 'NL32-05', NULL, 'VORDERBODEN', 'Vorder Boden', 'Vorder Boden', '010100002015550000CC2E3D82165D25415818C84A0AEB0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517781, 'MT73', 'NL32-02', NULL, 'VORDERFELD', 'Vorder Feld', 'Vorder Feld', '010100002015550000E865BDDEF907254123C0342A4CC70C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517782, 'LS78', 'NL32-04', NULL, 'VORDERFULTIGEN', 'Vorderfultigen', 'Vorderfultigen', '01010000201555000039467306684222417AC9EDACF0D00641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517785, 'MS37', 'NL32-05', NULL, 'VORDERSTAFEL', 'Vorder Stafel', 'Vorder Stafel', '0101000020155500009D71286AE90B24412B0F34C2C0F10541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517787, 'MT91', 'NL32-02', NULL, 'VORDERTHAL', 'Vorderthal', 'Vorderthal', '010100002015550000A4CDBC3204A82541FF493C32C9C80A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517790, 'MS89', 'NL32-05', NULL, 'VORFRUTT', 'Vorfrutt', 'Vorfrutt', '0101000020155500009786D925D3A125413ECD298D919D0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517791, 'NT20', 'NL32-05', NULL, 'VORSIEZ', 'Vor Siez', 'Vor Siez', '01010000201555000070A5600818A226417DA7454BA1D40841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517792, 'LS33', 'NL32-04', NULL, 'VOUVRY', 'Vouvry', 'Vouvry', '0101000020155500004B7DEEE470012141CC3AAC48B50C0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517793, 'NS06', 'NL32-05', NULL, 'VRIN', 'Vrin', 'Vrin', '010100002015550000598BDF090931264147F4CE37187E0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517795, 'LS46', 'NL32-04', NULL, 'VUADENS', 'Vuadens', 'Vuadens', '010100002015550000C773886EF35C2141B61F0EB5C1E20341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517799, 'LS57', 'NL32-04', NULL, 'VUISTERNENS', 'Vuisternens', 'Vuisternens', '01010000201555000009D55ACE486721416D05F3EE0B040541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517800, 'LS18', 'NL32-04', NULL, 'VUITEBOEUF', 'Vuiteboeuf', 'Vuiteboeuf', '010100002015550000678750C0853D2041484E4BD52B690641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517801, 'LS06', 'NL32-04', NULL, 'VULLIERENS', 'Vullierens', 'Vullierens', '010100002015550000E37C418D4F0920418C1A46F200410341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517803, 'NS98', 'NL32-06', NULL, 'VULPERA', 'Vulpera', 'Vulpera', '010100002015550000166AD48840F028411CDE0B5B479E0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517806, 'LS89', 'NL32-04', NULL, 'WABERN', 'Wabern', 'Wabern', '010100002015550000C6D1C8FF176A2241B96168B05D2C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517807, 'MS08', 'NL32-04', NULL, 'WACHSELDORN', 'Wachseldorn', 'Wachseldorn', '010100002015550000E64D45A734FF2241DF8C223158980641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517808, 'MT73', 'NL32-02', NULL, 'WADENSWIL', 'Wädenswil', 'Wadenswil', '010100002015550000542ADCD3FC252541BE2A1B5550550C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517809, 'MT87', 'NL32-02', NULL, 'WAGENHAUSEN', 'Wagenhausen', 'Wagenhausen', '010100002015550000B0648C56EC8B25413E582C0F0C021141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517816, 'LS97', 'NL32-04', NULL, 'WAHLEN', 'Wahlen', 'Wahlen', '01010000201555000098B53CEEED9B22419731AC90ADAF0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517817, 'LT85', 'NL32-01', NULL, 'WAHLEN', 'Wahlen', 'Wahlen', '0101000020155500007B84366BB2732241AC5FCB8CB5810E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517818, 'LS78', 'NL32-04', NULL, 'WAHLERN', 'Wahlern', 'Wahlern', '0101000020155500002A70B565A71A2241789FDB7527970641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517819, 'MT61', 'NL32-02', NULL, 'WALCHWIL', 'Walchwil', 'Walchwil', '0101000020155500003979D2CFD8CE2441AE8A51D7E8800A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517820, 'MS18', 'NL32-04', NULL, 'WALD', 'Wald', 'Wald', '01010000201555000057B1F5ACC34423415051430F98990641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517821, 'MT93', 'NL32-02', NULL, 'WALD', 'Wald', 'Wald', '010100002015550000D9EABAA30CB92541A2FAE269330D0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517823, 'MT04', 'NL32-01', NULL, 'WALDENBURG', 'Waldenburg', 'Waldenburg', '0101000020155500004948C3AB310723414C0BB95632490E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517824, 'NS28', 'NL32-05', NULL, 'WALDHAUS', 'Waldhaus', 'Waldhaus', '010100002015550000825E1FF8E89A264178D822439D040741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517825, 'MS49', 'NL32-05', NULL, 'WALDHEIM', 'Waldheim', 'Waldheim', '010100002015550000D6D21BCADB5924411AAB63EC02380841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517826, 'NT07', 'NL32-02', NULL, 'WALDI', 'Wäldi', 'Waldi', '01010000201555000078E87F5D2A152641EAC953A46EEA1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517827, 'NT25', 'NL32-02', NULL, 'WALDKIRCH', 'Waldkirch', 'Waldkirch', '010100002015550000510438DEF98D2641E45817F55C9C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517828, 'NT24', 'NL32-02', NULL, 'WALDSTATT', 'Waldstatt', 'Waldstatt', '01010000201555000068E473B8049026415112279902410E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517831, 'LT90', 'NL32-04', NULL, 'WALKRINGEN', 'Walkringen', 'Walkringen', '0101000020155500001351AF9662B922411215A9D1B6660841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517832, 'LS69', 'NL32-04', NULL, 'WALLENBUCH', 'Wallenbuch', 'Wallenbuch', '01010000201555000055C0309367CB214189F47DBA30F30741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517834, 'LS59', 'NL32-04', NULL, 'WALLENRIED', 'Wallenried', 'Wallenried', '010100002015550000BDB0E8ECB68F214149B4195E51460741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517836, 'NT21', 'NL32-02', NULL, 'WALLENSTADT', 'Wallenstadt', 'Wallenstadt', '010100002015550000216820C3E1A82641EA83B6218CDE0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517839, 'MT65', 'NL32-02', NULL, 'WALLISELLEN', 'Wallisellen', 'Wallisellen', '010100002015550000E59932A05EF22441D7365B833CCF0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517841, 'NS07', 'NL32-05', NULL, 'WALTENSBURG', 'Waltensburg', 'Waltensburg', '0101000020155500007F4CED72D5382641883BFC8525140641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517843, 'MT44', 'NL32-02', NULL, 'WALTENSCHWIL', 'Waltenschwil', 'Waltenschwil', '0101000020155500001E7A108C214C24414AABB44A2DA50D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517844, 'MT01', 'NL32-01', NULL, 'WALTERSWIL', 'Walterswil', 'Walterswil', '0101000020155500003BBDAA1FFE112341E2EE9E48E1AA0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517845, 'MT74', 'NL32-02', NULL, 'WALTIKON', 'Waltikon', 'Waltikon', '0101000020155500007F92AE531B072541F1D05D3DE5AE0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517846, 'NT45', 'NL32-02', NULL, 'WALZENHAUSEN', 'Walzenhausen', 'Walzenhausen', '01010000201555000019A39792D6482741543FD16686750F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517847, 'MT92', 'NL32-02', NULL, 'WANGEN', 'Wangen', 'Wangen', '0101000020155500003D689763D1B0254130822EC117B10B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517849, 'MT14', 'NL32-01', NULL, 'WANGEN', 'Wangen', 'Wangen', '01010000201555000090977D902D4C2341725025D2ADD60D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517850, 'LT93', 'NL32-01', NULL, 'WANGENANDERAARE', 'Wangen an der Aare', 'Wangen an der Aare', '010100002015550000DB097EA98CCC22417C9B424C423F0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517851, 'MT96', 'NL32-02', NULL, 'WANGI', 'Wängi', 'Wangi', '010100002015550000A261AA4C1FC9254188C207DB5CFF0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517852, 'NT30', 'NL32-02', NULL, 'WANGS', 'Wangs', 'Wangs', '0101000020155500001E6EB665DFEF2641B20C7592F4C30941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517856, 'MT00', 'NL32-01', NULL, 'WASEN', 'Wasen', 'Wasen', '0101000020155500003069B908311C23414078EC9A89890941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517857, 'MS67', 'NL32-05', NULL, 'WASSEN', 'Wassen', 'Wassen', '010100002015550000FAC0A73768052541320FC9EC41160541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517858, 'NT33', 'NL32-02', NULL, 'WASSERAUEN', 'Wasserauen', 'Wasserauen', '010100002015550000EAC992195AEA2641F6A697133C280D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517861, 'MT67', 'NL32-02', NULL, 'WASTERKINGEN', 'Wasterkingen', 'Wasterkingen', '010100002015550000C091E78B7DB52441146F18FB7E871041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517862, 'LS88', 'NL32-04', NULL, 'WATTENWIL', 'Wattenwil', 'Wattenwil', '0101000020155500005DDA282F117E22418EB9F4236CE90541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517863, 'NT03', 'NL32-02', NULL, 'WATTWIL', 'Wattwil', 'Wattwil', '010100002015550000E051FF3E3C1B264114500786EF4E0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517864, 'MT22', 'NL32-02', NULL, 'WAUWIL', 'Wauwil', 'Wauwil', '01010000201555000045BB93F6C9A52341AA510E4DE8950B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517865, 'NT01', 'NL32-02', NULL, 'WEESEN', 'Weesen', 'Weesen', '010100002015550000C1AC1A78252826413173F9E2D80C0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517866, 'MT16', 'NL32-01', NULL, 'WEGENSTETTEN', 'Wegenstetten', 'Wegenstetten', '010100002015550000BCA49A07B6722341A05CD364C4E00F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517867, 'MT50', 'NL32-02', NULL, 'WEGGIS', 'Weggis', 'Weggis', '0101000020155500009520AF4E299E244100732DD8B4960941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517869, 'LS87', 'NL32-04', NULL, 'WEIERMOOS', 'Weiermoos', 'Weiermoos', '010100002015550000279075C921742241C67958D57CAF0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517870, 'NT06', 'NL32-02', NULL, 'WEINFELDEN', 'Weinfelden', 'Weinfelden', '010100002015550000F3FEB00C2D2026417498CA080C771041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517871, 'MT55', 'NL32-02', NULL, 'WEININGEN', 'Weiningen', 'Weiningen', '0101000020155500004A689FFDF09924410588E4186ACA0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517872, 'NT34', 'NL32-02', NULL, 'WEISSBAD', 'Weissbad', 'Weissbad', '010100002015550000F608A6A69DE92641902AB37D029C0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517873, 'LS76', 'NL32-04', NULL, 'WEISSENBACH', 'Weissenbach', 'Weissenbach', '010100002015550000AC12AA42672E22415F21C21949E00341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517874, 'LS86', 'NL32-04', NULL, 'WEISSENBURG', 'Weissenburg', 'Weissenburg', '010100002015550000C49FB56643602241C788BDE90B540441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517882, 'MT85', 'NL32-02', NULL, 'WEISSLINGEN', 'Weisslingen', 'Weisslingen', '01010000201555000019FA0FE160542541BF5C07A4490F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517885, 'NT20', 'NL32-05', NULL, 'WEISSTANNEN', 'Weisstannen', 'Weisstannen', '0101000020155500000C3672AC8EB52641BE97C78769100941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517886, 'LT83', 'NL32-01', NULL, 'WELSCHENROHR', 'Welschenrohr', 'Welschenrohr', '010100002015550000BEA8970E7A872241F869878070EC0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517887, 'MS16', 'NL32-04', NULL, 'WENGEN', 'Wengen', 'Wengen', '010100002015550000AF92F630A86D2341FC58A15FD0A90341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517888, 'LT71', 'NL32-01', NULL, 'WENGI', 'Wengi', 'Wengi', '010100002015550000129E68FC94382241D5C44BAB7A350A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517889, 'NT32', 'NL32-02', NULL, 'WERDENBERG', 'Werdenberg', 'Werdenberg', '0101000020155500009E9DBEB0AA00274148E8ED5C0E950B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517890, 'MT64', 'NL32-02', NULL, 'WERDHOLZLI', 'Werdhölzli', 'Werdholzli', '01010000201555000075C60F5D70C12441A761103C92920E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517891, 'NS36', 'NL32-05', NULL, 'WERGENSTEIN', 'Wergenstein', 'Wergenstein', '0101000020155500000F07FF10C5E42641893B707EC8540441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517893, 'MT83', 'NL32-02', NULL, 'WERNETSHAUSEN', 'Wernetshausen', 'Wernetshausen', '0101000020155500004AEE38FF3C9B25418403BD7CE8440D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517894, 'MT31', 'NL32-02', NULL, 'WERTHENSTEIN', 'Werthenstein', 'Werthenstein', '0101000020155500004F3CD50E1CD82341640C493941C80941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517897, 'MT45', 'NL32-02', NULL, 'WETTINGEN', 'Wettingen', 'Wettingen', '0101000020155500005C68DD30AD5424413C2466BED8740F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517898, 'MT84', 'NL32-02', NULL, 'WETZIKON', 'Wetzikon', 'Wetzikon', '01010000201555000067EF6D3BC2692541C08A7C71537B0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517899, 'NT06', 'NL32-02', NULL, 'WETZIKON', 'Wetzikon', 'Wetzikon', '0101000020155500001CD9D31BF9E525410B74668CBB3A1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517900, 'LS89', 'NL32-04', NULL, 'WEYERMANNSHAUS', 'Weyermannshaus', 'Weyermannshaus', '010100002015550000DE9D4B1CD7872241B3623E66782C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517902, 'MT64', 'NL32-02', NULL, 'WIEDIKON', 'Wiedikon', 'Wiedikon', '010100002015550000FCCCB845AACB2441674B06A14D1F0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517903, 'LT93', 'NL32-01', NULL, 'WIEDLISBACH', 'Wiedlisbach', 'Wiedlisbach', '01010000201555000028015CB782CC22412F2A2EFC29790C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517906, 'NS57', 'NL32-05', NULL, 'WIESEN', 'Wiesen', 'Wiesen', '01010000201555000083F7CCFA82962741EE2672909A4F0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517907, 'MT86', 'NL32-02', NULL, 'WIESENDANGEN', 'Wiesendangen', 'Wiesendangen', '010100002015550000EC49630CC8662541F9109C8F0F191041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517908, 'NS57', 'NL32-05', NULL, 'WIESENERALP', 'Wieseneralp', 'Wieseneralp', '010100002015550000F5FA052C18962741358227AD7A890541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517910, 'MS66', 'NL32-05', NULL, 'WIGGEN', 'Wiggen', 'Wiggen', '0101000020155500008EA3525604D4244196FA41C7A09F0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517911, 'MS19', 'NL32-04', NULL, 'WIGGEN', 'Wiggen', 'Wiggen', '0101000020155500004A48B2682662234114663103C1BB0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517915, 'NT07', 'NL32-02', NULL, 'WIGOLTINGEN', 'Wigoltingen', 'Wigoltingen', '010100002015550000B249EFC666F8254152E001DE51AF1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517916, 'MT23', 'NL32-01', NULL, 'WIKON', 'Wikon', 'Wikon', '0101000020155500008C6AE6EAB187234195BA057097B60C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517917, 'NT05', 'NL32-02', NULL, 'WIL', 'Wil', 'Wil', '010100002015550000AD3DA71792042641E400421C41900F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517918, 'MT36', 'NL32-02', NULL, 'WIL', 'Wil', 'Wil', '01010000201555000093CBA603EDE723419664F3A2FB651041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517919, 'MT67', 'NL32-02', NULL, 'WIL', 'Wil', 'Wil', '010100002015550000DBD362D816BF2441B448A04CB6A41041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517920, 'MT85', 'NL32-02', NULL, 'WILA', 'Wila', 'Wila', '0101000020155500002CD91995BE85254110EA0ED2C6D80E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517921, 'MT57', 'NL32-02', NULL, 'WILCHINGEN', 'Wilchingen', 'Wilchingen', '0101000020155500007C22105BBFAA2441C11DCC7801181141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517922, 'MT85', 'NL32-02', NULL, 'WILDBERG', 'Wildberg', 'Wildberg', '010100002015550000A8E2C04E18722541D6F01D6165D70E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517923, 'MT34', 'NL32-02', NULL, 'WILDEGG', 'Wildegg', 'Wildegg', '010100002015550000441AAAC2FFFC2341D5CED6C4B34F0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517924, 'MS16', 'NL32-04', NULL, 'WILDERSWIL', 'Wilderswil', 'Wilderswil', '01010000201555000080067C4172452341F13E8DF680900441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517925, 'NT22', 'NL32-02', NULL, 'WILDHAUS', 'Wildhaus', 'Wildhaus', '0101000020155500003F141148E0BA2641EEC030E8E3010C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517929, 'MS03', 'NL32-04', NULL, 'WILER', 'Wiler', 'Wiler', '010100002015550000E85E1DE19614234130D104A431F10041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517930, 'MS07', 'NL32-04', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020155500002C77C9F487FF22411AC3D49EF23C0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517931, 'MS77', 'NL32-05', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020155500009B6EE920D5222541C2036B6ED98B0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517932, 'LT92', 'NL32-01', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020155500003D3FCEA37D912241D2AC97D6401D0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517933, 'MS49', 'NL32-05', NULL, 'WILERBAD', 'Wilerbad', 'Wilerbad', '010100002015550000B1088530B9282441BE32CC4B34880741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517934, 'LT60', 'NL32-04', NULL, 'WILEROLTIGEN', 'Wileroltigen', 'Wileroltigen', '010100002015550000DD6DA4F56FD5214127741102C9A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517935, 'MS37', 'NL32-05', NULL, 'WILLIGEN', 'Willigen', 'Willigen', '010100002015550000E468C5B72F0C2441382E2E5EF57D0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517936, 'MT21', 'NL32-01', NULL, 'WILLISAU', 'Willisau', 'Willisau', '0101000020155500004DCC83C67392234180EA9BD1BBAD0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517938, 'LS97', 'NL32-04', NULL, 'WIMMIS', 'Wimmis', 'Wimmis', '010100002015550000BD51BDACDEC32241E30D62F867C80441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517939, 'MT45', 'NL32-02', NULL, 'WINDISCH', 'Windisch', 'Windisch', '010100002015550000E06BB41498232441AC805C2BC1720F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517940, 'MT56', 'NL32-02', NULL, 'WINDLACH', 'Windlach', 'Windlach', '0101000020155500009556B2C843AC24418C14A9E160301041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517941, 'MT23', 'NL32-02', NULL, 'WINIKON', 'Winikon', 'Winikon', '010100002015550000AF07CD5D30B92341101A3EC636440C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517942, 'MT40', 'NL32-02', NULL, 'WINKEL', 'Winkel', 'Winkel', '010100002015550000B5FC5C850C592441D4EC297F80590941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517943, 'NT24', 'NL32-02', NULL, 'WINKELN', 'Winkeln', 'Winkeln', '010100002015550000E2FD5D0F2A992641F1E619C6B8B50E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517945, 'LS96', 'NL32-04', NULL, 'WINKLEN', 'Winklen', 'Winklen', '010100002015550000AACCC49506CE2241BA2AFFA803A70341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517946, 'MT86', 'NL32-02', 2, 'WINTERTHUR', 'Winterthur', 'Winterthur', '010100002015550000CBEB0D1D69532541DA01A342E4F60F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517949, 'MT64', 'NL32-02', NULL, 'WITIKON', 'Witikon', 'Witikon', '0101000020155500005E7435D000F324412708372D88210E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517950, 'NT25', 'NL32-02', NULL, 'WITTENBACH', 'Wittenbach', 'Wittenbach', '010100002015550000CEA3C4140CBF2641B360068215A10F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517951, 'MT25', 'NL32-01', NULL, 'WITTNAU', 'Wittnau', 'Wittnau', '0101000020155500000EFCFC533E9023410C67FD4EA3A70F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517952, 'NS67', 'NL32-05', NULL, 'WITY', 'Wity', 'Wity', '010100002015550000665D83D5D1E42741AB181E67AD060641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517953, 'LT50', 'NL32-04', NULL, 'WITZWIL', 'Witzwil', 'Witzwil', '010100002015550000864A23D481682141D6A83CBA57DC0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517954, 'LT70', 'NL32-04', NULL, 'WOHLEN', 'Wohlen', 'Wohlen', '010100002015550000A4DAF680CD1A22412CC7240043A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517955, 'MT44', 'NL32-02', NULL, 'WOHLEN', 'Wohlen', 'Wohlen', '0101000020155500005EFBCD75FA4124416BF637708E180E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517957, 'MS59', 'NL32-05', NULL, 'WOLFENSCHIESSEN', 'Wolfenschiessen', 'Wolfenschiessen', '0101000020155500002B74CD289C8B24411A709A4770000841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517958, 'NS68', 'NL32-05', NULL, 'WOLFGANG', 'Wolfgang', 'Wolfgang', '0101000020155500008120CB378AEC27414C8CBD5B42290741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517959, 'MT25', 'NL32-01', NULL, 'WOLFLINSWIL', 'Wölflinswil', 'Wolflinswil', '0101000020155500000C2454BC71902341038443A4D2330F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517961, 'MT03', 'NL32-01', NULL, 'WOLFWIL', 'Wolfwil', 'Wolfwil', '01010000201555000049869F904D1B2341A2856D052FB40C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517962, 'MT21', 'NL32-02', NULL, 'WOLHUSEN', 'Wolhusen', 'Wolhusen', '010100002015550000830AFF8452C42341875A78DA9AC70941');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517963, 'MT72', 'NL32-02', NULL, 'WOLLERAU', 'Wollerau', 'Wollerau', '010100002015550000BE92064A673A2541610935A1DFA80B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517964, 'LS99', 'NL32-04', NULL, 'WORB', 'Worb', 'Worb', '010100002015550000EAB5C8DBAB9B22419C4291FF942C0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517965, 'LT61', 'NL32-01', NULL, 'WORBEN', 'Worben', 'Worben', '010100002015550000A269DC6865F3214124454F5DBA6F0A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517966, 'LT80', 'NL32-04', NULL, 'WORBLAUFEN', 'Worblaufen', 'Worblaufen', '010100002015550000E762F1132B60224117B45DB026A00841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517970, 'LS69', 'NL32-04', NULL, 'WUNNEWIL', 'Wünnewil', 'Wunnewil', '0101000020155500005B3FD5AE18E9214103E0F98A167F0741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517971, 'NT05', 'NL32-02', NULL, 'WUPPENAU', 'Wuppenau', 'Wuppenau', '010100002015550000CBD0E877B5212641A96EA3809BCC0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517973, 'MT46', 'NL32-02', NULL, 'WURENLINGEN', 'Würenlingen', 'Wurenlingen', '010100002015550000B06817C29D362441B3DDDC90982D1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517974, 'MT55', 'NL32-02', NULL, 'WURENLOS', 'Würenlos', 'Wurenlos', '010100002015550000790208014C72244150A06A114C3C0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517975, 'MT06', 'NL32-01', NULL, 'WYHLEN', 'Wyhlen', 'Wyhlen', '010100002015550000D3C967A011F3224131E749070A291041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517976, 'MT03', 'NL32-01', NULL, 'WYNAU', 'Wynau', 'Wynau', '01010000201555000081091B29282523411EF08F555CB40C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517977, 'LT91', 'NL32-01', NULL, 'WYNIGEN', 'Wynigen', 'Wynigen', '010100002015550000470257B7BED62241304BAF8523700A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517978, 'MT11', 'NL32-01', NULL, 'WYSSACHEN', 'Wyssachen', 'Wyssachen', '010100002015550000A892C6CFC62F2341496F267B9B370A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517981, 'LS05', 'NL32-04', NULL, 'YENS', 'Yens', 'Yens', '0101000020155500007C26FE1398D51F4178DA49D7D8940241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (9224695, 'LS28', 'NL32-04', 3, 'YVERDONLESBAINS', 'Yverdon-les-Bains', 'Yverdon-les-Bains', '010100002015550000D796DD98037920410296F52BB82C0641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517984, 'LS28', 'NL32-04', NULL, 'YVONAND', 'Yvonand', 'Yvonand', '010100002015550000FFAC4046CCB42041F47E55C65D640641');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517985, 'LS43', 'NL32-04', NULL, 'YVORNE', 'Yvorne', 'Yvorne', '010100002015550000EB58714692332141BCCC5159640B0041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517986, 'NS27', 'NL32-05', NULL, 'ZALONERHUTTEN', 'Zalöner Hütten', 'Zaloner Hutten', '010100002015550000BCF3C5AD96A726412CE17B1C7C360541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517989, 'LS99', 'NL32-04', NULL, 'ZAZIWIL', 'Zäziwil', 'Zaziwil', '0101000020155500007FCC349253CD2241EB9C150B35B90741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517990, 'MT15', 'NL32-01', NULL, 'ZEGLINGEN', 'Zeglingen', 'Zeglingen', '010100002015550000326E06C7835F23414E1A011DC0BE0E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517991, 'MT35', 'NL32-02', NULL, 'ZEIHEN', 'Zeihen', 'Zeihen', '01010000201555000020E077923ECB2341370A25C2836F0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517992, 'LS84', 'NL32-04', NULL, 'ZELG', 'Zelg', 'Zelg', '01010000201555000092E3905355602241156715C276290141');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517993, 'MT12', 'NL32-01', NULL, 'ZELL', 'Zell', 'Zell', '010100002015550000ECB64CA0D66A2341981224469BE60A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517994, 'MT85', 'NL32-02', NULL, 'ZELL', 'Zell', 'Zell', '0101000020155500008B0D7A46697B25416C1EAD8AE14B0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517995, 'MS12', 'NL32-04', NULL, 'ZENEGGEN', 'Zeneggen', 'Zeneggen', '0101000020155500003E3D6FD0434723417E273E8DE845FE40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517996, 'MR09', 'NL32-04', NULL, 'ZERMATT', 'Zermatt', 'Zermatt', '01010000201555000007A6F1CAE40B2341AEAF3A74BC7AF740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517997, 'MS10', 'NL32-04', NULL, 'ZERMEIGGERN', 'Zermeiggern', 'Zermeiggern', '010100002015550000E26D7D378884234199B28B69FD4EF940');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517999, 'NS87', 'NL32-06', NULL, 'ZERNEZ', 'Zernez', 'Zernez', '010100002015550000C805883F668528419663B7AD986D0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518000, 'NS05', 'NL32-05', NULL, 'ZERVREILA', 'Zervreila', 'Zervreila', '010100002015550000B609CF5E91322641CC9FBC42AA5C0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518001, 'NS05', 'NL32-05', NULL, 'ZERVREILAOBERBODEN', 'Zervreila-Oberboden', 'Zervreila-Oberboden', '010100002015550000B609CF5E91322641CC9FBC42AA5C0341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518002, 'NS05', 'NL32-05', NULL, 'ZERVREILAUNTERBODEN', 'Zervreila-Unterboden', 'Zervreila-Unterboden', '010100002015550000DBA5893D3D3C26414BB6A77466970341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518003, 'NT01', 'NL32-02', NULL, 'ZIEGELBRUCKE', 'Ziegelbrücke', 'Ziegelbrucke', '0101000020155500007A8B4278D00A2641784EE4D97BD00A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518007, 'NT16', 'NL32-02', NULL, 'ZIHLSCHLACHT', 'Zihlschlacht', 'Zihlschlacht', '010100002015550000AA637A315879264151A1BE9A1B241041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518008, 'NS36', 'NL32-05', NULL, 'ZILLIS', 'Zillis', 'Zillis', '010100002015550000D6A5A63FAC022741604F6304D0570441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518009, 'LS89', 'NL32-04', NULL, 'ZIMMERWALD', 'Zimmerwald', 'Zimmerwald', '010100002015550000BA5C30C232602241BAAEBA99BE440741');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518010, 'LS90', 'NL32-04', NULL, 'ZINAL', 'Zinal', 'Zinal', '0101000020155500008D5928E30CC52241CA5373DC81A3FA40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518012, 'NS49', 'NL32-05', NULL, 'ZIZERS', 'Zizers', 'Zizers', '01010000201555000096CC13A7604127417EC4A765FE700841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518013, 'MT13', 'NL32-01', NULL, 'ZOFINGEN', 'Zofingen', 'Zofingen', '010100002015550000FF199D71E5732341C244428CFBEF0C41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518014, 'MT00', 'NL32-04', NULL, 'ZOLLBRUCK', 'Zollbrück', 'Zollbruck', '01010000201555000091E7077BA0082341227BB9F899A10841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518015, 'LT80', 'NL32-04', NULL, 'ZOLLIKOFEN', 'Zollikofen', 'Zollikofen', '010100002015550000748D3ECC2960224110D58F750DDA0841');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518016, 'MT64', 'NL32-02', NULL, 'ZOLLIKON', 'Zollikon', 'Zollikon', '0101000020155500000F16CAEF6CF32441025A8FEFBAAD0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518020, 'LT92', 'NL32-01', NULL, 'ZUCHWIL', 'Zuchwil', 'Zuchwil', '010100002015550000EB299FC04B9B22415407D07A06CB0B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518021, 'NT15', 'NL32-02', NULL, 'ZUCKENRIET', 'Zuckenriet', 'Zuckenriet', '0101000020155500005D35B6DC243F2641B216928823CF0F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518023, 'MT62', 'NL32-02', 3, 'ZUG', 'Zug', 'Zug', '01010000201555000028DFF02E0DCE244198A3B58B80680B41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518028, 'MT61', 'NL32-02', NULL, 'ZUGERSEE', 'Zugersee', 'Zugersee', '0101000020155500008373DFF1E2BA24410CD7FEFFBCB90A41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518030, 'LT94', 'NL32-01', NULL, 'ZULLWIL', 'Zullwil', 'Zullwil', '010100002015550000B47198DDB3AE2241B168A14022480E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518031, 'MS66', 'NL32-05', NULL, 'ZUMDORF', 'Zumdorf', 'Zumdorf', '010100002015550000B8979FD2C9DE2441CFDBFC219BB80341');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518032, 'LS77', 'NL32-04', NULL, 'ZUMHOLZ', 'Zumholz', 'Zumholz', '0101000020155500002DF92C5CBDFC21411E15A58DBAAF0541');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518033, 'MT74', 'NL32-02', NULL, 'ZUMIKON', 'Zumikon', 'Zumikon', '0101000020155500007F92AE531B072541F1D05D3DE5AE0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518038, 'MT05', 'NL32-01', NULL, 'ZUNZGEN', 'Zunzgen', 'Zunzgen', '010100002015550000981766CB7D24234118C1535D6CF70E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518039, 'NS76', 'NL32-05', NULL, 'ZUOZ', 'Zuoz', 'Zuoz', '010100002015550000384D15DC992E2841D50E9BDF8F060441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518040, 'NT24', 'NL32-02', NULL, 'ZURCHERSMUHLE', 'Zürchersmühle', 'Zurchersmuhle', '010100002015550000EB8443C5899A2641618A386628CE0D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518042, 'MT64', 'NL32-02', 1, 'ZURICH', 'Zürich', 'Zurich', '0101000020155500003DBDD28E55DF2441B0DA1C9F66200E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518048, 'MT64', 'NL32-02', NULL, 'ZURICHHORN', 'Zürichhorn', 'Zurichhorn', '01010000201555000066A45C0B8ADF2441D615D0DF7FE60D41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518051, 'MT47', 'NL32-02', NULL, 'ZURZACH', 'Zurzach', 'Zurzach', '0101000020155500003ED58CC9964924412076E84AD5A11041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518052, 'MT16', 'NL32-01', NULL, 'ZUZGEN', 'Zuzgen', 'Zuzgen', '0101000020155500009E2DC86CEB5E23414BEBBDBF0D2A1041');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518053, 'NT05', 'NL32-02', NULL, 'ZUZWIL', 'Zuzwil', 'Zuzwil', '0101000020155500004974398DD42B26410434250F8C930F41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518054, 'MS16', 'NL32-04', NULL, 'ZWEILUTSCHINEN', 'Zweilütschinen', 'Zweilutschinen', '0101000020155500004C828F95826323410D86F40B5F1D0441');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518055, 'LS75', 'NL32-04', NULL, 'ZWEISIMMEN', 'Zweisimmen', 'Zweisimmen', '010100002015550000F7861F2660242241624FC409B9F80241');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518056, 'LT85', 'NL32-01', NULL, 'ZWINGEN', 'Zwingen', 'Zwingen', '0101000020155500002D20FD727F7D2241FC76CD418FF50E41');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518057, 'MS31', 'NL32-05', NULL, 'ZWISCHBERGEN', 'Zwischbergen', 'Zwischbergen', '0101000020155500001F37F8E8A0E823413525B7E30F98FB40');


--
-- TOC entry 2570 (class 2606 OID 62657)
-- Dependencies: 2272 2272
-- Name: pk_uni_staedte_schweiz; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY staedte_schweiz
    ADD CONSTRAINT pk_uni_staedte_schweiz PRIMARY KEY ("UNI");


-- Completed on 2010-01-14 09:43:26 CET

--
-- PostgreSQL database dump complete
--

