--
-- PostgreSQL database dump
--

-- Started on 2007-10-10 23:06:44 CEST

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1661 (class 1259 OID 5191215)
-- Dependencies: 1997 1998 1999 4 641
-- Name: staedte_schweiz; Type: TABLE; Schema: public; Owner: -; Tablespace: 
--

CREATE TABLE staedte_schweiz (
    "UNI" integer NOT NULL,
    "UTM" character(4),
    "JOG" character varying(7),
    "PC" smallint,
    "SORT_NAME" character varying,
    "FULL_NAME" character varying,
    "FULL_NAME_ND" character varying,
    the_geom geometry,
    CONSTRAINT enforce_dims_the_geom CHECK ((ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((srid(the_geom) = 4326))
);


--
-- TOC entry 2003 (class 0 OID 5191215)
-- Dependencies: 1661
-- Data for Name: staedte_schweiz; Type: TABLE DATA; Schema: public; Owner: -
--

INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514346, 'MS81', 'NL32-05', NULL, 'GORDEVIO', 'Gordevio', 'Gordevio', '0101000020E61000000000000000802140ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512576, 'MT95', 'NL32-02', NULL, 'AADORF', 'Aadorf', 'Aadorf', '0101000020E6100000CDCCCCCCCCCC2140AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512578, 'MT24', 'NL32-02', 3, 'AARAU', 'Aarau', 'Aarau', '0101000020E61000009A99999999192040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512580, 'LT61', 'NL32-01', NULL, 'AARBERG', 'Aarberg', 'Aarberg', '0101000020E61000009578E51F22221D406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512581, 'MT14', 'NL32-01', NULL, 'AARBURG', 'Aarburg', 'Aarburg', '0101000020E61000009A99999999991F40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512595, 'MT03', 'NL32-01', NULL, 'AARWANGEN', 'Aarwangen', 'Aarwangen', '0101000020E61000000000000000001F40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512596, 'MT84', 'NL32-02', NULL, 'AATHAL', 'Aathal', 'Aathal', '0101000020E61000004FDDA68988882140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512597, 'LS65', 'NL32-04', NULL, 'ABLANDSCHEN', 'Abländschen', 'Ablandschen', '0101000020E61000003333333333331D40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512598, 'NT25', 'NL32-02', NULL, 'ABTWIL', 'Abtwil', 'Abtwil', '0101000020E6100000E976402322A2224087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512600, 'MT47', 'NL32-02', NULL, 'ACHEBERG', 'Acheberg', 'Acheberg', '0101000020E61000004BBCF20F11912040791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512601, 'MS12', 'NL32-04', NULL, 'ACKERSAND', 'Ackersand', 'Ackersand', '0101000020E61000000421B47977771F40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512602, 'MS86', 'NL32-05', NULL, 'ACLA', 'Acla', 'Acla', '0101000020E6100000E4558CA9AAAA2140DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512603, 'NS47', 'NL32-05', NULL, 'ACLASDAFORA', 'Aclas Dafora', 'Aclas Dafora', '0101000020E61000007EEF2543444423409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512604, 'MS85', 'NL32-05', NULL, 'ACQUACALDA', 'Acquacalda', 'Acquacalda', '0101000020E6100000E4558CA9AAAA214013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512605, 'MS94', 'NL32-05', NULL, 'ACQUAROSSA', 'Acquarossa', 'Acquarossa', '0101000020E61000006666666666E621409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512606, 'LS65', 'NL32-04', NULL, 'ADANNES', 'Adannes', 'Adannes', '0101000020E61000000000000000001D4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512607, 'LS84', 'NL32-04', NULL, 'ADELBODEN', 'Adelboden', 'Adelboden', '0101000020E6100000D1ED804644441E40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512608, 'MT51', 'NL32-02', NULL, 'ADLIGENSWIL', 'Adligenswil', 'Adligenswil', '0101000020E61000008210DABCBBBB2040BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512609, 'MT64', 'NL32-02', NULL, 'ADLISWIL', 'Adliswil', 'Adliswil', '0101000020E61000004FDDA68988082140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512610, 'MS38', 'NL32-05', NULL, 'AECHERLI', 'Aecherli', 'Aecherli', '0101000020E61000001789BFDCDD5D2040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512611, 'LS78', 'NL32-04', NULL, 'AECKENMATT', 'Aeckenmatt', 'Aeckenmatt', '0101000020E61000006666666666661D40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512612, 'LT93', 'NL32-01', NULL, 'AEDERMANNSDORF', 'Aedermannsdorf', 'Aedermannsdorf', '0101000020E61000006666666666661E406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512616, 'MS27', 'NL32-04', NULL, 'AELGAU', 'Aelgäu', 'Aelgau', '0101000020E61000006B871AE0DDDD1F4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512619, 'MS48', 'NL32-05', NULL, 'AELGGIALP', 'Aelggi Alp', 'Aelggi Alp', '0101000020E6100000B1225976777720406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512621, 'MS89', 'NL32-05', NULL, 'AESCH', 'Aesch', 'Aesch', '0101000020E61000009A99999999992140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512622, 'MT43', 'NL32-02', NULL, 'AESCH', 'Aesch', 'Aesch', '0101000020E6100000000000000080204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512623, 'LT95', 'NL32-01', NULL, 'AESCH', 'Aesch', 'Aesch', '0101000020E61000006666666666661E40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512624, 'MS09', 'NL32-04', NULL, 'AESCHAU', 'Aeschau', 'Aeschau', '0101000020E61000009EBA4D1311111F403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512625, 'NT33', 'NL32-02', NULL, 'AESCHER', 'Aescher', 'Aescher', '0101000020E61000001CAA735655D5224013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512626, 'MS06', 'NL32-04', NULL, 'AESCHI', 'Aeschi', 'Aeschi', '0101000020E6100000CDCCCCCCCCCC1E403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512627, 'MS07', 'NL32-04', NULL, 'AESCHLEN', 'Aeschlen', 'Aeschlen', '0101000020E6100000CDCCCCCCCCCC1E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512628, 'LS68', 'NL32-04', NULL, 'AESCHLENBERG', 'Aeschlenberg', 'Aeschlenberg', '0101000020E61000009EBA4D1311111D4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512629, 'MT52', 'NL32-02', NULL, 'AETTENSCHWIL', 'Aettenschwil', 'Aettenschwil', '0101000020E61000008210DABCBBBB204046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512630, 'MT63', 'NL32-02', NULL, 'AEUGST', 'Aeugst', 'Aeugst', '0101000020E6100000B122597677F7204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512631, 'NT06', 'NL32-02', NULL, 'AFFELTRANGEN', 'Affeltrangen', 'Affeltrangen', '0101000020E61000004BBCF20F1111224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512632, 'MT01', 'NL32-01', NULL, 'AFFOLTERN', 'Affoltern', 'Affoltern', '0101000020E61000006245B2ECEEEE1E40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512633, 'MT53', 'NL32-02', NULL, 'AFFOLTERN', 'Affoltern', 'Affoltern', '0101000020E61000006666666666E6204013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512635, 'LS92', 'NL32-04', NULL, 'AGARN', 'Agarn', 'Agarn', '0101000020E61000003854E7ACAAAA1E406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512638, 'LS71', 'NL32-04', NULL, 'AGETTES', 'Agettes', 'Agettes', '0101000020E6100000FCDE4B8688881D409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512639, 'LS17', 'NL32-04', NULL, 'AGIEZ', 'Agiez', 'Agiez', '0101000020E61000009EBA4D1311111A40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512641, 'MR89', 'NL32-08', NULL, 'AGNO', 'Agno', 'Agno', '0101000020E61000003333333333B32140AC4896DDDDFD4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512642, 'MR99', 'NL32-08', NULL, 'AGRA', 'Agra', 'Agra', '0101000020E61000001CAA735655D52140ED5003BCBBFB4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512643, 'LS43', 'NL32-04', NULL, 'AIGLE', 'Aigle', 'Aigle', '0101000020E61000006B871AE0DDDD1B40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512651, 'MS65', 'NL32-05', NULL, 'AIROLO', 'Airolo', 'Airolo', '0101000020E6100000333333333333214013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512652, 'MT22', 'NL32-02', NULL, 'ALBERSWIL', 'Alberswil', 'Alberswil', '0101000020E610000000000000000020403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512653, 'LS55', 'NL32-04', NULL, 'ALBEUVE', 'Albeuve', 'Albeuve', '0101000020E6100000D1ED804644441C4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512654, 'LS93', 'NL32-04', NULL, 'ALBINEN', 'Albinen', 'Albinen', '0101000020E6100000FCDE4B8688881E40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512656, 'LS78', 'NL32-04', NULL, 'ALBLIGEN', 'Albligen', 'Albligen', '0101000020E6100000D1ED804644441D40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512664, 'LT91', 'NL32-01', NULL, 'ALCHENSTORF', 'Alchenstorf', 'Alchenstorf', '0101000020E6100000FCDE4B8688881E40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512669, 'MS54', 'NL32-05', NULL, 'ALLACQUA', 'All’Acqua', 'All’Acqua', '0101000020E6100000B5430DF0EEEE2040AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512672, 'LS04', 'NL32-04', NULL, 'ALLAMAN', 'Allaman', 'Allaman', '0101000020E61000009A99999999991940ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512673, 'LT55', 'NL32-01', NULL, 'ALLE', 'Alle', 'Alle', '0101000020E6100000FCDE4B8688881C4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512674, 'LS97', 'NL32-04', NULL, 'ALLMENDINGEN', 'Allmendingen', 'Allmendingen', '0101000020E6100000C8AB185355551E40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512675, 'LS89', 'NL32-04', NULL, 'ALLMENDINGEN', 'Allmendingen', 'Allmendingen', '0101000020E61000009EBA4D1311111E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512678, 'LT86', 'NL32-01', NULL, 'ALLSCHWIL', 'Allschwil', 'Allschwil', '0101000020E61000009578E51F22221E406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512682, 'NS82', 'NL32-06', NULL, 'ALPEBRAITA', 'Alpe Braita', 'Alpe Braita', '0101000020E61000009A999999991924406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512685, 'MS83', 'NL32-05', NULL, 'ALPEDELLACOSTA', 'Alpe della Costa', 'Alpe della Costa', '0101000020E6100000E4558CA9AAAA2140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512689, 'NS13', 'NL32-05', NULL, 'ALPEDIBOGGIO', 'Alpe di Boggio', 'Alpe di Boggio', '0101000020E61000001789BFDCDD5D2240CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512690, 'NS03', 'NL32-05', NULL, 'ALPEDICAVA', 'Alpe di Cava', 'Alpe di Cava', '0101000020E61000004BBCF20F11112240218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512691, 'NS13', 'NL32-05', NULL, 'ALPEDICORTAS', 'Alpe di Cortas', 'Alpe di Cortas', '0101000020E6100000B5430DF0EE6E22403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512692, 'NS13', 'NL32-05', NULL, 'ALPEDICRASTERA', 'Alpe di Crastera', 'Alpe di Crastera', '0101000020E61000000000000000802240CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512694, 'MS71', 'NL32-05', NULL, 'ALPEDINACCIO', 'Alpe di Naccio', 'Alpe di Naccio', '0101000020E61000001789BFDCDD5D21403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512695, 'NS04', 'NL32-05', NULL, 'ALPEDIQUARNAJO', 'Alpe di Quarnajo', 'Alpe di Quarnajo', '0101000020E61000004FDDA68988082240AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512696, 'NS04', 'NL32-05', NULL, 'ALPEDISCIERU', 'Alpe di Scieru', 'Alpe di Scieru', '0101000020E61000004BBCF20F111122409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512697, 'NS13', 'NL32-05', NULL, 'ALPEDITRESCOLMEN', 'Alpe di Trescolmen', 'Alpe di Trescolmen', '0101000020E61000001CAA7356555522403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512700, 'MS62', 'NL32-05', NULL, 'ALPEPORCARESCIO', 'Alpe Porcarescio', 'Alpe Porcarescio', '0101000020E610000000000000000021400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512701, 'NS04', 'NL32-05', NULL, 'ALPEPULGABIO', 'Alpe Pulgabio', 'Alpe Pulgabio', '0101000020E61000009A9999999919224087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512703, 'MS75', 'NL32-05', NULL, 'ALPERITOM', 'Alpe Ritóm', 'Alpe Ritom', '0101000020E61000001789BFDCDD5D21406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512706, 'MS62', 'NL32-05', NULL, 'ALPESFILLE', 'Alpe Sfille', 'Alpe Sfille', '0101000020E610000000000000000021400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512709, 'NS73', 'NL32-06', NULL, 'ALPGRUM', 'Alp Grüm', 'Alp Grum', '0101000020E61000004BBCF20F11112440DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512711, 'MS64', 'NL32-05', NULL, 'ALPIANO', 'Al Piano', 'Al Piano', '0101000020E6100000333333333333214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512713, 'MS26', 'NL32-05', NULL, 'ALPIGLEN', 'Alpiglen', 'Alpiglen', '0101000020E61000004FDDA68988082040CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512714, 'MS17', 'NL32-04', NULL, 'ALPIGLEN', 'Alpiglen', 'Alpiglen', '0101000020E6100000C8AB185355551F40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512715, 'NS98', 'NL32-06', NULL, 'ALPLARETDADAINT', 'Alp Laret-Dadaint', 'Alp Laret-Dadaint', '0101000020E6100000B5430DF0EE6E24406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512716, 'MS49', 'NL32-05', NULL, 'ALPNACH', 'Alpnach', 'Alpnach', '0101000020E61000004FDDA689888820409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512718, 'MT40', 'NL32-05', NULL, 'ALPNACHSTAD', 'Alpnachstad', 'Alpnachstad', '0101000020E61000004BBCF20F11912040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512720, 'NS35', 'NL32-05', NULL, 'ALPSCHMORRAS', 'Alp Schmorras', 'Alp Schmorras', '0101000020E61000004FDDA689880823406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512724, 'MT71', 'NL32-02', NULL, 'ALPTHAL', 'Alpthal', 'Alpthal', '0101000020E6100000B5430DF0EE6E2140791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512727, 'MS91', 'NL32-05', NULL, 'ALSASSO', 'Al Sasso', 'Al Sasso', '0101000020E61000006666666666E621403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512728, 'MS75', 'NL32-05', NULL, 'ALTANCA', 'Altanca', 'Altanca', '0101000020E61000001789BFDCDD5D214054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512729, 'MS79', 'NL32-05', 4, 'ALTDORF', 'Altdorf', 'Altdorf', '0101000020E6100000CDCCCCCCCC4C2140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512732, 'MT77', 'NL32-02', NULL, 'ALTEN', 'Alten', 'Alten', '0101000020E6100000CDCCCCCCCC4C2140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512733, 'MT82', 'NL32-02', NULL, 'ALTENDORF', 'Altendorf', 'Altendorf', '0101000020E6100000E976402322A2214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512734, 'NT45', 'NL32-02', NULL, 'ALTENRHEIN', 'Altenrhein', 'Altenrhein', '0101000020E61000009A99999999192340AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512738, 'LS68', 'NL32-04', NULL, 'ALTERSWIL', 'Alterswil', 'Alterswil', '0101000020E61000009EBA4D1311111D406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512739, 'NT17', 'NL32-02', NULL, 'ALTERSWILEN', 'Alterswilen', 'Alterswilen', '0101000020E6100000CDCCCCCCCC4C2240218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512740, 'NS38', 'NL32-05', NULL, 'ALTFELSBERG', 'Alt-Felsberg', 'Alt-Felsberg', '0101000020E6100000B122597677F72240CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512742, 'MT22', 'NL32-01', NULL, 'ALTISHOFEN', 'Altishofen', 'Altishofen', '0101000020E61000006B871AE0DDDD1F409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512745, 'NT17', 'NL32-02', NULL, 'ALTNAU', 'Altnau', 'Altnau', '0101000020E61000000000000000802240218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512747, 'NT22', 'NL32-02', NULL, 'ALTSANKTJOHANN', 'Alt Sankt Johann', 'Alt Sankt Johann', '0101000020E61000004BBCF20F1191224046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512748, 'NT44', 'NL32-02', NULL, 'ALTSTATTEN', 'Altstätten', 'Altstatten', '0101000020E61000004BBCF20F11112340DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512749, 'MT94', 'NL32-02', NULL, 'ALTTOGGENBURG', 'Alt Toggenburg', 'Alt Toggenburg', '0101000020E6100000B5430DF0EEEE2140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512751, 'NS47', 'NL32-05', NULL, 'ALVANEU', 'Alvaneu', 'Alvaneu', '0101000020E61000007EEF25434444234046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512754, 'NS47', 'NL32-05', NULL, 'ALVASCHEIN', 'Alvaschein', 'Alvaschein', '0101000020E61000009A9999999919234046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512756, 'NS44', 'NL32-05', NULL, 'AMBACH', 'Am Bach', 'Am Bach', '0101000020E61000004BBCF20F111123409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512757, 'MS74', 'NL32-05', NULL, 'AMBRI', 'Ambri', 'Ambri', '0101000020E61000001789BFDCDD5D21400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512760, 'NT11', 'NL32-02', NULL, 'AMDEN', 'Amden', 'Amden', '0101000020E61000007EEF254344442240DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512762, 'NT26', 'NL32-02', NULL, 'AMRISWIL', 'Amriswil', 'Amriswil', '0101000020E61000009A9999999999224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512763, 'LS97', 'NL32-04', NULL, 'AMSOLDINGEN', 'Amsoldingen', 'Amsoldingen', '0101000020E6100000C8AB185355551E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512765, 'MS77', 'NL32-05', NULL, 'AMSTEG', 'Amsteg', 'Amsteg', '0101000020E61000001CAA73565555214054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512766, 'NS36', 'NL32-05', NULL, 'ANDEER', 'Andeer', 'Andeer', '0101000020E61000001789BFDCDDDD2240CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512769, 'MS66', 'NL32-05', NULL, 'ANDERMATT', 'Andermatt', 'Andermatt', '0101000020E61000003333333333332140DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512770, 'NS08', 'NL32-05', NULL, 'ANDEST', 'Andest', 'Andest', '0101000020E61000008210DABCBB3B224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512771, 'NT25', 'NL32-02', NULL, 'ANDWIL', 'Andwil', 'Andwil', '0101000020E61000004FDDA6898888224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512772, 'NS83', 'NL32-06', NULL, 'ANGELICUSTODI', 'Angeli Custodi', 'Angeli Custodi', '0101000020E6100000E976402322222440218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512773, 'MS84', 'NL32-05', NULL, 'ANGONE', 'Angone', 'Angone', '0101000020E61000008210DABCBBBB214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512774, 'KS82', 'NL32-04', NULL, 'ANIERES', 'Anières', 'Anieres', '0101000020E61000006B871AE0DDDD184013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512776, 'MS95', 'NL32-05', NULL, 'ANVEUDA', 'Anvéuda', 'Anveuda', '0101000020E6100000CDCCCCCCCCCC214013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512777, 'MS94', 'NL32-05', NULL, 'ANZONICO', 'Anzonico', 'Anzonico', '0101000020E61000007EEF254344C4214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512779, 'NT34', 'NL32-02', 4, 'APPENZELL', 'Appenzell', 'Appenzell', '0101000020E6100000CDCCCCCCCCCC2240791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512785, 'LS05', 'NL32-04', NULL, 'APPLES', 'Apples', 'Apples', '0101000020E61000002F127FB9BBBB19406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512786, 'LS71', 'NL32-04', NULL, 'APRO', 'Apro', 'Apro', '0101000020E6100000D1ED804644441D409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512788, 'MS94', 'NL32-05', NULL, 'AQUILA', 'Aquila', 'Aquila', '0101000020E61000006666666666E621400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512789, 'MS82', 'NL32-05', NULL, 'AQUINO', 'Aquino', 'Aquino', '0101000020E6100000E4558CA9AAAA214054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512791, 'LS72', 'NL32-04', NULL, 'ARBAZ', 'Arbaz', 'Arbaz', '0101000020E6100000FCDE4B8688881D4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512792, 'NS01', 'NL32-05', NULL, 'ARBEDO', 'Arbedo', 'Arbedo', '0101000020E61000009A999999991922409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512796, 'NT36', 'NL32-02', NULL, 'ARBON', 'Arbon', 'Arbon', '0101000020E61000001789BFDCDDDD224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512797, 'MS81', 'NL32-05', NULL, 'ARCEGNO', 'Arcegno', 'Arcegno', '0101000020E6100000000000000080214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512798, 'LT72', 'NL32-01', NULL, 'ARCH', 'Arch', 'Arch', '0101000020E61000003854E7ACAAAA1D403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512799, 'LS57', 'NL32-04', NULL, 'ARCONCIEL', 'Arconciel', 'Arconciel', '0101000020E61000000421B47977771C400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512800, 'MS94', 'NL32-05', NULL, 'ARDET', 'Ardet', 'Ardet', '0101000020E6100000CDCCCCCCCCCC2140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512801, 'NS98', 'NL32-06', NULL, 'ARDEZ', 'Ardez', 'Ardez', '0101000020E6100000666666666666244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512802, 'LS61', 'NL32-04', NULL, 'ARDON', 'Ardon', 'Ardon', '0101000020E61000000000000000001D409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512808, 'MS99', 'NL32-05', NULL, 'ARGSEELI', 'Argseeli', 'Argseeli', '0101000020E61000001789BFDCDDDD21403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512809, 'MT06', 'NL32-01', NULL, 'ARISDORF', 'Arisdorf', 'Arisdorf', '0101000020E61000009EBA4D1311111F4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512810, 'MT53', 'NL32-02', NULL, 'ARISTAU', 'Aristau', 'Aristau', '0101000020E61000008210DABCBBBB204013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512811, 'LT95', 'NL32-01', NULL, 'ARLESHEIM', 'Arlesheim', 'Arlesheim', '0101000020E61000000421B47977771E40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512813, 'LS17', 'NL32-04', NULL, 'ARNEX', 'Arnex', 'Arnex', '0101000020E61000009EBA4D1311111A409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512814, 'LS99', 'NL32-04', NULL, 'ARNI', 'Arni', 'Arni', '0101000020E61000009A99999999991E4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512817, 'MS48', 'NL32-05', NULL, 'ARNIALP', 'Arni Alp', 'Arni Alp', '0101000020E61000000000000000802040BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512818, 'MR98', 'NL32-08', NULL, 'AROGNO', 'Arogno', 'Arogno', '0101000020E6100000B5430DF0EEEE21409A99999999F94640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512819, 'LR89', 'NL32-04', NULL, 'AROLLA', 'Arolla', 'Arolla', '0101000020E61000006245B2ECEEEE1D4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512820, 'NS58', 'NL32-05', NULL, 'AROSA', 'Arosa', 'Arosa', '0101000020E61000001CAA73565555234013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512823, 'MR99', 'NL32-05', NULL, 'AROSIO', 'Arosio', 'Arosio', '0101000020E6100000CDCCCCCCCCCC21406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512824, 'NS39', 'NL32-05', NULL, 'ARTASCHIEW', 'Artaschiew', 'Artaschiew', '0101000020E61000004FDDA6898808234087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512825, 'MT61', 'NL32-02', NULL, 'ARTH', 'Arth', 'Arth', '0101000020E61000004FDDA68988082140BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512829, 'LS52', 'NL32-04', NULL, 'ARVEYES', 'Arveyes', 'Arveyes', '0101000020E6100000D1ED804644441C4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512830, 'NS02', 'NL32-05', NULL, 'ARVIGO', 'Arvigo', 'Arvigo', '0101000020E61000008210DABCBB3B22406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512831, 'KS84', 'NL32-04', NULL, 'ARZIER', 'Arzier', 'Arzier', '0101000020E6100000CDCCCCCCCCCC1840ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512833, 'MR98', 'NL32-08', NULL, 'ARZO', 'Arzo', 'Arzo', '0101000020E61000001789BFDCDDDD2140DF7BC91011F14640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512834, 'MS64', 'NL32-05', NULL, 'ARZO', 'Arzo', 'Arzo', '0101000020E610000000000000000021409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512835, 'NS69', 'NL32-05', NULL, 'ASCHARINA', 'Ascharina', 'Ascharina', '0101000020E61000009A999999999923409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512837, 'MS81', 'NL32-05', NULL, 'ASCONA', 'Ascona', 'Ascona', '0101000020E61000004FDDA689888821403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512838, 'LS16', 'NL32-04', NULL, 'ASSENS', 'Assens', 'Assens', '0101000020E61000000421B47977771A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512839, 'MR89', 'NL32-05', NULL, 'ASTANO', 'Astano', 'Astano', '0101000020E6100000E976402322A2214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512840, 'LT64', 'NL32-01', NULL, 'ASUEL', 'Asuel', 'Asuel', '0101000020E6100000CDCCCCCCCCCC1C40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512841, 'LS35', 'NL32-04', NULL, 'ATTALENS', 'Attalens', 'Attalens', '0101000020E61000006666666666661B4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512842, 'MS79', 'NL32-05', NULL, 'ATTINGHAUSEN', 'Attinghausen', 'Attinghausen', '0101000020E61000008210DABCBB3B2140218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512843, 'LT93', 'NL32-01', NULL, 'ATTISWIL', 'Attiswil', 'Attiswil', '0101000020E61000006666666666661E40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512844, 'MT73', 'NL32-02', NULL, 'AU', 'Au', 'Au', '0101000020E61000007EEF254344442140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512845, 'MT94', 'NL32-02', NULL, 'AU', 'Au', 'Au', '0101000020E61000006666666666E62140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512846, 'NT45', 'NL32-02', NULL, 'AU', 'Au', 'Au', '0101000020E61000008210DABCBB3B234046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512847, 'LT96', 'NL32-01', NULL, 'AU', 'Au', 'Au', '0101000020E61000009A99999999991E406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512849, 'LS05', 'NL32-04', NULL, 'AUBONNE', 'Aubonne', 'Aubonne', '0101000020E61000009A99999999991940AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512852, 'MT35', 'NL32-02', NULL, 'AUENSTEIN', 'Auenstein', 'Auenstein', '0101000020E61000007EEF25434444204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512853, 'MS47', 'NL32-05', NULL, 'AUFDEMSTOCK', 'Auf dem Stock', 'Auf dem Stock', '0101000020E6100000B122597677772040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512854, 'NS39', 'NL32-05', NULL, 'AUFDERHOHE', 'Auf der Hohe', 'Auf der Hohe', '0101000020E6100000CDCCCCCCCCCC224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512855, 'NS03', 'NL32-05', NULL, 'AUGIO', 'Augio', 'Augio', '0101000020E61000008210DABCBB3B2240218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512856, 'MT06', 'NL32-01', NULL, 'AUGST', 'Augst', 'Augst', '0101000020E61000006B871AE0DDDD1E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512861, 'LS38', 'NL32-04', NULL, 'AUMONT', 'Aumont', 'Aumont', '0101000020E61000006666666666661B406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512862, 'MS71', 'NL32-05', NULL, 'AURESSIO', 'Auressio', 'Auressio', '0101000020E61000001789BFDCDD5D21409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512863, 'MS72', 'NL32-05', NULL, 'AURIGENO', 'Aurigeno', 'Aurigeno', '0101000020E61000006666666666662140AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512864, 'MS33', 'NL32-05', NULL, 'AUSSERBINN', 'Ausserbinn', 'Ausserbinn', '0101000020E6100000CDCCCCCCCC4C2040DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512865, 'MT86', 'NL32-02', NULL, 'AUSSERDINHARD', 'Ausserdinhard', 'Ausserdinhard', '0101000020E61000004FDDA689888821406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512866, 'MT72', 'NL32-02', NULL, 'AUSSEREALTMATT', 'Äussere Altmatt', 'Aussere Altmatt', '0101000020E61000006666666666662140DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512867, 'NS35', 'NL32-05', NULL, 'AUSSERFERRERA', 'Ausserferrera', 'Ausserferrera', '0101000020E61000001789BFDCDDDD22406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512868, 'NS27', 'NL32-05', NULL, 'AUSSERGLAS', 'Ausserglas', 'Ausserglas', '0101000020E61000003333333333B3224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512869, 'LS70', 'NL32-04', NULL, 'AUSSERHOLLIGEN', 'Ausserholligen', 'Ausserholligen', '0101000020E61000009A99999999991D40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512870, 'LS96', 'NL32-04', NULL, 'AUSSERLATTERBACH', 'Ausser Latterbach', 'Ausser Latterbach', '0101000020E61000006666666666661E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512872, 'MT64', 'NL32-02', NULL, 'AUSSERSIHL', 'Aussersihl', 'Aussersihl', '0101000020E61000009A99999999192140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512873, 'LS47', 'NL32-04', NULL, 'AUTIGNY', 'Autigny', 'Autigny', '0101000020E61000009EBA4D1311111C40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512874, 'LT30', 'NL32-04', NULL, 'AUVERNIER', 'Auvernier', 'Auvernier', '0101000020E61000000421B47977771B40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512875, 'MT52', 'NL32-02', NULL, 'AUW', 'Auw', 'Auw', '0101000020E61000008210DABCBBBB2040ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512877, 'MS71', 'NL32-05', NULL, 'AVEGNO', 'Avegno', 'Avegno', '0101000020E6100000B1225976777721409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512878, 'LS59', 'NL32-04', NULL, 'AVENCHES', 'Avenches', 'Avenches', '0101000020E61000003333333333331C40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512883, 'LS58', 'NL32-04', NULL, 'AVRY', 'Avry', 'Avry', '0101000020E6100000D1ED804644441C4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512886, 'MT70', 'NL32-05', NULL, 'AXENSTEIN', 'Axenstein', 'Axenstein', '0101000020E61000008210DABCBB3B2140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512887, 'LS72', 'NL32-04', NULL, 'AYENT', 'Ayent', 'Ayent', '0101000020E61000003854E7ACAAAA1D4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512888, 'LS91', 'NL32-04', NULL, 'AYER', 'Ayer', 'Ayer', '0101000020E61000006666666666661E4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512889, 'MT62', 'NL32-02', NULL, 'BAAR', 'Baar', 'Baar', '0101000020E61000004FDDA689880821409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512890, 'MT72', 'NL32-02', NULL, 'BACH', 'Bäch', 'Bach', '0101000020E6100000B1225976777721409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512891, 'MT66', 'NL32-02', NULL, 'BACHENBULACH', 'Bachenbülach', 'Bachenbulach', '0101000020E61000004BBCF20F111121400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512892, 'LS96', 'NL32-04', NULL, 'BACHLEN', 'Bächlen', 'Bachlen', '0101000020E6100000D1ED804644441E40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512893, 'MT56', 'NL32-02', NULL, 'BACHS', 'Bachs', 'Bachs', '0101000020E61000001789BFDCDDDD204054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512895, 'MS02', 'NL32-04', NULL, 'BACHTOLEN', 'Bachtolen', 'Bachtolen', '0101000020E61000003333333333331F4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512896, 'MT45', 'NL32-02', NULL, 'BADEN', 'Baden', 'Baden', '0101000020E61000009A99999999992040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512899, 'NT30', 'NL32-02', NULL, 'BADRAGAZ', 'Bad Ragaz', 'Bad Ragaz', '0101000020E610000000000000000023400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512901, 'LS66', 'NL32-04', NULL, 'BADSCHWARZSEE', 'Bad-Schwarzsee', 'Bad-Schwarzsee', '0101000020E61000009578E51F22221D4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512903, 'LS60', 'NL32-04', NULL, 'BAGNES', 'Bagnes', 'Bagnes', '0101000020E61000006B871AE0DDDD1C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512911, 'NT30', 'NL32-05', NULL, 'BALEN', 'Balen', 'Balen', '0101000020E6100000B122597677F72240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512912, 'NR07', 'NL32-08', NULL, 'BALERNA', 'Balerna', 'Balerna', '0101000020E61000000000000000002240CDCCCCCCCCEC4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512916, 'NT45', 'NL32-02', NULL, 'BALGACH', 'Balgach', 'Balgach', '0101000020E6100000333333333333234087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512917, 'LS07', 'NL32-04', NULL, 'BALLAIGUES', 'Ballaigues', 'Ballaigues', '0101000020E61000003854E7ACAAAA1940AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512919, 'KS95', 'NL32-04', NULL, 'BALLENS', 'Ballens', 'Ballens', '0101000020E61000000421B479777719406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512920, 'MT42', 'NL32-02', NULL, 'BALLWIL', 'Ballwil', 'Ballwil', '0101000020E6100000E976402322A220403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512921, 'MS27', 'NL32-05', NULL, 'BALM', 'Balm', 'Balm', '0101000020E6100000E4558CA9AA2A20400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512922, 'LT81', 'NL32-01', NULL, 'BALMBEIMESSEN', 'Balm bei Messen', 'Balm bei Messen', '0101000020E61000002F127FB9BBBB1D40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512924, 'MS88', 'NL32-05', NULL, 'BALMENEGG', 'Balmenegg', 'Balmenegg', '0101000020E61000004FDDA6898888214013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512927, 'MT04', 'NL32-01', NULL, 'BALSTHAL', 'Balsthal', 'Balsthal', '0101000020E61000002F127FB9BBBB1E40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512928, 'MT75', 'NL32-02', NULL, 'BALTENSWIL', 'Baltenswil', 'Baltenswil', '0101000020E6100000CDCCCCCCCC4C214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512929, 'MS12', 'NL32-04', NULL, 'BALTSCHIEDER', 'Baltschieder', 'Baltschieder', '0101000020E61000000421B47977771F406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512931, 'MR89', 'NL32-05', NULL, 'BANCO', 'Banco', 'Banco', '0101000020E61000003333333333B321400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512932, 'LT81', 'NL32-01', NULL, 'BANGERTEN', 'Bangerten', 'Bangerten', '0101000020E61000006245B2ECEEEE1D406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512933, 'MT03', 'NL32-01', NULL, 'BANNWIL', 'Bannwil', 'Bannwil', '0101000020E61000006B871AE0DDDD1E40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512935, 'MS09', 'NL32-04', NULL, 'BARAU', 'Bärau', 'Barau', '0101000020E6100000D1ED804644441F4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512936, 'LS69', 'NL32-04', NULL, 'BARBERECHE', 'Barberêche', 'Barbereche', '0101000020E61000003854E7ACAAAA1C40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512937, 'LS40', 'NL32-04', NULL, 'BARBERINE', 'Barberine', 'Barberine', '0101000020E6100000CDCCCCCCCCCC1B406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512941, 'MT84', 'NL32-02', NULL, 'BARETSWIL', 'Bäretswil', 'Baretswil', '0101000020E61000003333333333B32140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512942, 'LT80', 'NL32-01', NULL, 'BARISWIL', 'Bäriswil', 'Bariswil', '0101000020E61000009EBA4D1311111E4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512943, 'LS90', 'NL32-04', NULL, 'BARMA', 'Barma', 'Barma', '0101000020E6100000FCDE4B8688881E40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512946, 'LS31', 'NL32-04', NULL, 'BARME', 'Barme', 'Barme', '0101000020E6100000C8AB185355551B403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512949, 'LT84', 'NL32-01', NULL, 'BARSCHWIL', 'Bärschwil', 'Barschwil', '0101000020E61000006B871AE0DDDD1D40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512953, 'MT87', 'NL32-02', NULL, 'BASADINGEN', 'Basadingen', 'Basadingen', '0101000020E6100000000000000080214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512954, 'LT96', 'NL32-01', 1, 'BASEL', 'Basel', 'Basel', '0101000020E61000006666666666661E40BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512965, 'LT64', 'NL32-01', NULL, 'BASSECOURT', 'Bassecourt', 'Bassecourt', '0101000020E61000006245B2ECEEEE1C40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512966, 'LS61', 'NL32-04', NULL, 'BASSENENDAZ', 'Basse-Nendaz', 'Basse-Nendaz', '0101000020E61000003333333333331D4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512967, 'MT75', 'NL32-02', NULL, 'BASSERSDORF', 'Bassersdorf', 'Bassersdorf', '0101000020E61000008210DABCBB3B21409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512969, 'NS39', 'NL32-05', NULL, 'BATANJA', 'Batänja', 'Batanja', '0101000020E610000000000000000023403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512970, 'LT81', 'NL32-01', NULL, 'BATTERKINDEN', 'Bätterkinden', 'Batterkinden', '0101000020E61000009578E51F22221E40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512971, 'MS69', 'NL32-05', NULL, 'BAUEN', 'Bauen', 'Bauen', '0101000020E6100000E4558CA9AA2A214046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512972, 'LS18', 'NL32-04', NULL, 'BAULMES', 'Baulmes', 'Baulmes', '0101000020E61000009578E51F22221A4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512973, 'MT84', 'NL32-02', NULL, 'BAUMA', 'Bauma', 'Bauma', '0101000020E61000008210DABCBBBB2140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512975, 'NT45', 'NL32-02', NULL, 'BAURIET', 'Bauriet', 'Bauriet', '0101000020E6100000E4558CA9AA2A2340ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512976, 'LS17', 'NL32-04', NULL, 'BAVOIS', 'Bavois', 'Bavois', '0101000020E6100000D1ED804644441A4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512978, 'NS36', 'NL32-05', NULL, 'BAVUGLS', 'Bavugls', 'Bavugls', '0101000020E6100000B5430DF0EEEE2240CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512980, 'NT04', 'NL32-02', NULL, 'BAZENHEID', 'Bazenheid', 'Bazenheid', '0101000020E6100000E9764023222222403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512982, 'MS07', 'NL32-04', NULL, 'BEATENBERG', 'Beatenberg', 'Beatenberg', '0101000020E61000009578E51F22221F409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512984, 'MT50', 'NL32-05', NULL, 'BECKENRIED', 'Beckenried', 'Beckenried', '0101000020E6100000B5430DF0EEEE2040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512987, 'NS68', 'NL32-05', NULL, 'BEDRA', 'Bedra', 'Bedra', '0101000020E61000007EEF254344C423406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512988, 'MS64', 'NL32-05', NULL, 'BEDRETTO', 'Bedretto', 'Bedretto', '0101000020E610000000000000000021400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512990, 'MT69', 'NL32-02', NULL, 'BEGGINGEN', 'Beggingen', 'Beggingen', '0101000020E61000009A9999999919214013AFFC4344E44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512991, 'KS84', 'NL32-04', NULL, 'BEGNINS', 'Begnins', 'Begnins', '0101000020E6100000000000000000194046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512992, 'NS67', 'NL32-05', NULL, 'BEIDERSAGE', 'Bei der Säge', 'Bei der Sage', '0101000020E6100000E4558CA9AAAA234054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512995, 'MT33', 'NL32-02', NULL, 'BEINWIL', 'Beinwil', 'Beinwil', '0101000020E6100000666666666666204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512996, 'LT94', 'NL32-01', NULL, 'BEINWIL', 'Beinwil', 'Beinwil', '0101000020E6100000C8AB185355551E40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512997, 'MS23', 'NL32-04', NULL, 'BELALP', 'Belalp', 'Belalp', '0101000020E61000006B871AE0DDDD1F40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512998, 'LS58', 'NL32-04', NULL, 'BELFAUX', 'Belfaux', 'Belfaux', '0101000020E61000006666666666661C40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3512999, 'NS56', 'NL32-05', NULL, 'BELLALUNA', 'Bellaluna', 'Bellaluna', '0101000020E610000066666666666623403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513001, 'LT50', 'NL32-04', NULL, 'BELLECHASSE', 'Bellechasse', 'Bellechasse', '0101000020E61000006666666666661C40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513002, 'LT63', 'NL32-01', NULL, 'BELLELAY', 'Bellelay', 'Bellelay', '0101000020E61000003854E7ACAAAA1C4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513003, 'LS59', 'NL32-04', NULL, 'BELLERIVE', 'Bellerive', 'Bellerive', '0101000020E61000009578E51F22221C4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513004, 'KS82', 'NL32-04', NULL, 'BELLEVUE', 'Bellevue', 'Bellevue', '0101000020E61000009A9999999999184054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513005, 'NS01', 'NL32-05', 3, 'BELLINZONA', 'Bellinzona', 'Bellinzona', '0101000020E61000004FDDA689880822409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513006, 'LT61', 'NL32-01', NULL, 'BELLMUND', 'Bellmund', 'Bellmund', '0101000020E61000006245B2ECEEEE1C40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513007, 'MS34', 'NL32-05', NULL, 'BELLWALD', 'Bellwald', 'Bellwald', '0101000020E6100000CDCCCCCCCC4C204046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513009, 'LS25', 'NL32-04', NULL, 'BELMONTSURLAUSANNE', 'Belmont-sur-Lausanne', 'Belmont-sur-Lausanne', '0101000020E6100000CDCCCCCCCCCC1A4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513010, 'LS89', 'NL32-04', NULL, 'BELP', 'Belp', 'Belp', '0101000020E61000000000000000001E40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513012, 'MS55', 'NL32-05', NULL, 'BELVEDERE', 'Belvédère', 'Belvedere', '0101000020E61000007EEF254344C42040BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513013, 'NT02', 'NL32-02', NULL, 'BENKEN', 'Benken', 'Benken', '0101000020E61000004FDDA689880822409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513014, 'MT77', 'NL32-02', NULL, 'BENKEN', 'Benken', 'Benken', '0101000020E6100000CDCCCCCCCC4C21403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513015, 'LS27', 'NL32-04', NULL, 'BERCHER', 'Bercher', 'Bercher', '0101000020E61000006B871AE0DDDD1A409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513016, 'NT17', 'NL32-02', NULL, 'BERG', 'Berg', 'Berg', '0101000020E61000001CAA735655552240791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513018, 'NS56', 'NL32-05', NULL, 'BERGUN', 'Bergün', 'Bergun', '0101000020E61000000000000000802340218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513019, 'MT54', 'NL32-02', NULL, 'BERIKON', 'Berikon', 'Berikon', '0101000020E61000007EEF254344C42040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513020, 'MT68', 'NL32-02', NULL, 'BERINGEN', 'Beringen', 'Beringen', '0101000020E6100000E9764023222221409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513021, 'MS22', 'NL32-05', NULL, 'BERISAL', 'Berisal', 'Berisal', '0101000020E61000009A9999999919204013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513023, 'LS89', 'NL32-04', 1, 'BERN', 'Bern', 'Bern', '0101000020E61000006B871AE0DDDD1D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513029, 'NT45', 'NL32-02', NULL, 'BERNECK', 'Berneck', 'Berneck', '0101000020E6100000333333333333234087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513035, 'KS71', 'NL32-04', NULL, 'BERNEX', 'Bernex', 'Bernex', '0101000020E6100000C8AB18535555184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513044, 'NS74', 'NL32-05', NULL, 'BERNINAHAUSER', 'Berninahäuser', 'Berninahauser', '0101000020E6100000B5430DF0EEEE23409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513047, 'MT32', 'NL32-02', NULL, 'BEROMUNSTER', 'Beromünster', 'Beromunster', '0101000020E61000001789BFDCDD5D20409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513049, 'NT21', 'NL32-02', NULL, 'BERSCHIS', 'Berschis', 'Berschis', '0101000020E61000003333333333B32240CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513050, 'MS81', 'NL32-05', NULL, 'BERZONA', 'Berzona', 'Berzona', '0101000020E61000003333333333B32140ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513055, 'NS09', 'NL32-05', NULL, 'BETSCHWANDEN', 'Betschwanden', 'Betschwanden', '0101000020E61000004FDDA689880822409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513056, 'LS75', 'NL32-04', NULL, 'BETTELRIED', 'Bettelried', 'Bettelried', '0101000020E6100000FCDE4B8688881D4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513057, 'MS23', 'NL32-05', NULL, 'BETTEN', 'Betten', 'Betten', '0101000020E6100000E976402322222040DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513058, 'LT97', 'NL32-01', NULL, 'BETTINGEN', 'Bettingen', 'Bettingen', '0101000020E61000009A99999999991E40CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513059, 'LT82', 'NL32-01', NULL, 'BETTLACH', 'Bettlach', 'Bettlach', '0101000020E61000003854E7ACAAAA1D409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513060, 'LS61', 'NL32-04', NULL, 'BEUSON', 'Beuson', 'Beuson', '0101000020E61000003333333333331D4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513061, 'LT30', 'NL32-04', NULL, 'BEVAIX', 'Bevaix', 'Bevaix', '0101000020E6100000D1ED804644441B4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513063, 'NS65', 'NL32-05', NULL, 'BEVERS', 'Bevers', 'Bevers', '0101000020E61000007EEF254344C423406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513064, 'LT73', 'NL32-01', NULL, 'BEVILARD', 'Bévilard', 'Bevilard', '0101000020E61000009578E51F22221D40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513065, 'LS42', 'NL32-04', NULL, 'BEX', 'Bex', 'Bex', '0101000020E61000009EBA4D1311111C400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513066, 'MT46', 'NL32-02', NULL, 'BEZNAU', 'Beznau', 'Beznau', '0101000020E610000000000000008020400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513069, 'MS93', 'NL32-05', NULL, 'BIASCA', 'Biasca', 'Biasca', '0101000020E6100000B5430DF0EEEE2140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513070, 'MS84', 'NL32-05', NULL, 'BIASCHINA', 'Biaschina', 'Biaschina', '0101000020E61000008210DABCBBBB214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513074, 'MT72', 'NL32-02', NULL, 'BIBERBRUCKE', 'Biberbrücke', 'Biberbrucke', '0101000020E6100000B5430DF0EE6E21403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513075, 'LS69', 'NL32-04', NULL, 'BIBEREN', 'Biberen', 'Biberen', '0101000020E61000006B871AE0DDDD1C4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513076, 'LT92', 'NL32-01', NULL, 'BIBERIST', 'Biberist', 'Biberist', '0101000020E61000003333333333331E4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513077, 'MT79', 'NL32-02', NULL, 'BIBERN', 'Bibern', 'Bibern', '0101000020E61000001789BFDCDD5D214054B7692222E24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513078, 'NS03', 'NL32-05', NULL, 'BIBORGO', 'Biborgo', 'Biborgo', '0101000020E61000009A99999999192240DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513079, 'MT95', 'NL32-02', NULL, 'BICHELSEE', 'Bichelsee', 'Bichelsee', '0101000020E61000001789BFDCDDDD21409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513080, 'MS90', 'NL32-05', NULL, 'BIDOGNO', 'Bidogno', 'Bidogno', '0101000020E6100000B122597677F72140791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513081, 'MS34', 'NL32-05', NULL, 'BIEL', 'Biel', 'Biel', '0101000020E610000066666666666620409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513082, 'LT62', 'NL32-01', 2, 'BIEL', 'Biel', 'Biel', '0101000020E61000000000000000001D4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513086, 'KS95', 'NL32-04', NULL, 'BIERE', 'Bière', 'Biere', '0101000020E6100000C8AB1853555519406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513090, 'LT90', 'NL32-04', NULL, 'BIGENTHAL', 'Bigenthal', 'Bigenthal', '0101000020E61000000421B47977771E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513091, 'LS99', 'NL32-04', NULL, 'BIGLEN', 'Biglen', 'Biglen', '0101000020E61000000421B47977771E4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513092, 'MS73', 'NL32-05', NULL, 'BIGNASCO', 'Bignasco', 'Bignasco', '0101000020E61000008210DABCBB3B2140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513093, 'MS90', 'NL32-05', NULL, 'BIGORIO', 'Bigorio', 'Bigorio', '0101000020E61000006666666666E62140BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513094, 'NT02', 'NL32-02', NULL, 'BILTEN', 'Bilten', 'Bilten', '0101000020E61000004FDDA689880822403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513095, 'MS33', 'NL32-05', NULL, 'BINN', 'Binn', 'Binn', '0101000020E61000001789BFDCDD5D2040218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513102, 'LT96', 'NL32-01', NULL, 'BINNINGEN', 'Binningen', 'Binningen', '0101000020E6100000D1ED804644441E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513105, 'MR99', 'NL32-05', NULL, 'BIOGGIO', 'Bioggio', 'Bioggio', '0101000020E61000007EEF254344C4214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513106, 'LS16', 'NL32-04', NULL, 'BIOLEYORJULAZ', 'Bioley-Orjulaz', 'Bioley-Orjulaz', '0101000020E61000000421B47977771A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513107, 'MT54', 'NL32-02', NULL, 'BIRMENSDORF', 'Birmensdorf', 'Birmensdorf', '0101000020E61000001789BFDCDDDD2040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513109, 'MT45', 'NL32-02', NULL, 'BIRMENSTORF', 'Birmenstorf', 'Birmenstorf', '0101000020E610000000000000008020409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513110, 'MS90', 'NL32-05', NULL, 'BIRONICO', 'Bironico', 'Bironico', '0101000020E61000001789BFDCDDDD2140CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513111, 'MT35', 'NL32-02', NULL, 'BIRR', 'Birr', 'Birr', '0101000020E6100000666666666666204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513113, 'MT33', 'NL32-02', NULL, 'BIRRWIL', 'Birrwil', 'Birrwil', '0101000020E6100000666666666666204013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513115, 'LT96', 'NL32-01', NULL, 'BIRSFELDEN', 'Birsfelden', 'Birsfelden', '0101000020E61000000421B47977771E406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513117, 'MS78', 'NL32-05', NULL, 'BIRTSCHEN', 'Birtschen', 'Birtschen', '0101000020E6100000CDCCCCCCCC4C2140791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513118, 'NT06', 'NL32-02', NULL, 'BISSEGG', 'Bissegg', 'Bissegg', '0101000020E61000009A99999999192240BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513119, 'MR98', 'NL32-08', NULL, 'BISSONE', 'Bissone', 'Bissone', '0101000020E6100000B5430DF0EEEE21409A99999999F94640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513120, 'MS23', 'NL32-04', NULL, 'BITSCH', 'Bitsch', 'Bitsch', '0101000020E61000006B871AE0DDDD1F40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513121, 'NS44', 'NL32-05', NULL, 'BIVIO', 'Bivio', 'Bivio', '0101000020E6100000CDCCCCCCCC4C2340ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513132, 'NS39', 'NL32-05', NULL, 'BLAS', 'Bläs', 'Blas', '0101000020E6100000B122597677F722409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513133, 'MR09', 'NL32-04', NULL, 'BLATTEN', 'Blatten', 'Blatten', '0101000020E61000006245B2ECEEEE1E400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513134, 'MS23', 'NL32-04', NULL, 'BLATTEN', 'Blatten', 'Blatten', '0101000020E61000006245B2ECEEEE1F40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513135, 'MS04', 'NL32-04', NULL, 'BLATTEN', 'Blatten', 'Blatten', '0101000020E6100000D1ED804644441F4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513136, 'MT41', 'NL32-02', NULL, 'BLATTEN', 'Blatten', 'Blatten', '0101000020E610000000000000008020406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513137, 'LT85', 'NL32-01', NULL, 'BLAUEN', 'Blauen', 'Blauen', '0101000020E61000009EBA4D1311111E409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513140, 'LS95', 'NL32-04', NULL, 'BLAUSEE', 'Blausee', 'Blausee', '0101000020E61000003854E7ACAAAA1E4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513148, 'MS34', 'NL32-05', NULL, 'BLITZINGEN', 'Blitzingen', 'Blitzingen', '0101000020E61000001789BFDCDD5D20409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513149, 'LS34', 'NL32-04', NULL, 'BLONAY', 'Blonay', 'Blonay', '0101000020E61000009A99999999991B40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513150, 'LS87', 'NL32-04', NULL, 'BLUMENSTEIN', 'Blumenstein', 'Blumenstein', '0101000020E61000009578E51F22221E40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513153, 'MS46', 'NL32-05', NULL, 'BODEN', 'Boden', 'Boden', '0101000020E61000004FDDA689888820403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513154, 'MS69', 'NL32-05', NULL, 'BODEN', 'Boden', 'Boden', '0101000020E6100000E4558CA9AA2A2140218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513156, 'MS93', 'NL32-05', NULL, 'BODIO', 'Bodio', 'Bodio', '0101000020E6100000CDCCCCCCCCCC2140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513159, 'NS54', 'NL32-05', NULL, 'BOGIA', 'Bögia', 'Bogia', '0101000020E61000001789BFDCDD5D2340ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513160, 'KS83', 'NL32-04', NULL, 'BOGISBOSSEY', 'Bogis-Bossey', 'Bogis-Bossey', '0101000020E61000003854E7ACAAAA1840CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513161, 'NS00', 'NL32-05', NULL, 'BOGNO', 'Bogno', 'Bogno', '0101000020E6100000E976402322222240CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513162, 'MS82', 'NL32-05', NULL, 'BOLASTRO', 'Bolastro', 'Bolastro', '0101000020E61000004FDDA689888821406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513163, 'NS68', 'NL32-05', NULL, 'BOLGEN', 'Bolgen', 'Bolgen', '0101000020E6100000E976402322A2234013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513164, 'LT80', 'NL32-04', NULL, 'BOLL', 'Boll', 'Boll', '0101000020E61000003333333333331E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513166, 'LT80', 'NL32-04', NULL, 'BOLLIGEN', 'Bolligen', 'Bolligen', '0101000020E61000006245B2ECEEEE1D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513168, 'LS76', 'NL32-04', NULL, 'BOLTIGEN', 'Boltigen', 'Boltigen', '0101000020E6100000FCDE4B8688881D40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513169, 'MS69', 'NL32-05', NULL, 'BOLZBACH', 'Bolzbach', 'Bolzbach', '0101000020E6100000E4558CA9AA2A21403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513170, 'NS38', 'NL32-05', NULL, 'BONADUZ', 'Bonaduz', 'Bonaduz', '0101000020E6100000CDCCCCCCCCCC2240BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513171, 'LT56', 'NL32-01', NULL, 'BONCOURT', 'Boncourt', 'Boncourt', '0101000020E61000009EBA4D1311111C400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513172, 'LT66', 'NL32-01', NULL, 'BONFOL', 'Bonfol', 'Bonfol', '0101000020E61000009A99999999991C40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513173, 'MS17', 'NL32-04', NULL, 'BONIGEN', 'Bönigen', 'Bonigen', '0101000020E61000009A99999999991F4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513174, 'MT34', 'NL32-02', NULL, 'BONISWIL', 'Boniswil', 'Boniswil', '0101000020E61000001789BFDCDD5D2040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513176, 'LS67', 'NL32-04', NULL, 'BONNEFONTAINE', 'Bonnefontaine', 'Bonnefontaine', '0101000020E6100000CDCCCCCCCCCC1C40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513178, 'MT54', 'NL32-02', NULL, 'BONSTETTEN', 'Bonstetten', 'Bonstetten', '0101000020E6100000B5430DF0EEEE2040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513179, 'LS29', 'NL32-04', NULL, 'BONVILLARS', 'Bonvillars', 'Bonvillars', '0101000020E61000003854E7ACAAAA1A40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513180, 'KS84', 'NL32-04', NULL, 'BOREX', 'Borex', 'Borex', '0101000020E61000002F127FB9BBBB1840DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513182, 'MS71', 'NL32-05', NULL, 'BORGNONE', 'Borgnone', 'Borgnone', '0101000020E61000007EEF25434444214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513183, 'NS43', 'NL32-05', NULL, 'BORGONOVO', 'Borgonovo', 'Borgonovo', '0101000020E61000003333333333332340CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513184, 'MS17', 'NL32-04', NULL, 'BORT', 'Bort', 'Bort', '0101000020E61000006666666666661F40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513185, 'MS62', 'NL32-05', NULL, 'BOSCOGURIN', 'Bosco Gurin', 'Bosco Gurin', '0101000020E6100000B122597677F72040BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513187, 'LS69', 'NL32-04', NULL, 'BOSINGEN', 'Bösingen', 'Bosingen', '0101000020E61000006B871AE0DDDD1C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513190, 'LS26', 'NL32-04', NULL, 'BOTTENS', 'Bottens', 'Bottens', '0101000020E61000009A99999999991A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513191, 'MT23', 'NL32-02', NULL, 'BOTTENWIL', 'Bottenwil', 'Bottenwil', '0101000020E6100000000000000000204013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513192, 'NT17', 'NL32-02', NULL, 'BOTTIGHOFEN', 'Bottighofen', 'Bottighofen', '0101000020E6100000B5430DF0EE6E2240DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513193, 'LT96', 'NL32-01', NULL, 'BOTTMINGEN', 'Bottmingen', 'Bottmingen', '0101000020E6100000D1ED804644441E4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513194, 'MT46', 'NL32-02', NULL, 'BOTTSTEIN', 'Böttstein', 'Bottstein', '0101000020E6100000B5430DF0EE6E20406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513195, 'LT31', 'NL32-01', NULL, 'BOUDEVILLIERS', 'Boudevilliers', 'Boudevilliers', '0101000020E6100000FCDE4B8688881B4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513196, 'LT30', 'NL32-04', NULL, 'BOUDRY', 'Boudry', 'Boudry', '0101000020E6100000C8AB185355551B409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513197, 'LR68', 'NL32-07', NULL, 'BOURGSAINTPIERRE', 'Bourg-Saint-Pierre', 'Bourg-Saint-Pierre', '0101000020E61000006B871AE0DDDD1C4046E22F7777F74640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513199, 'LS33', 'NL32-04', NULL, 'BOUVERET', 'Bouveret', 'Bouveret', '0101000020E61000006666666666661B40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513200, 'LS50', 'NL32-04', NULL, 'BOVERNIER', 'Bovernier', 'Bovernier', '0101000020E6100000C8AB185355551C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513201, 'LS99', 'NL32-04', NULL, 'BOWIL', 'Bowil', 'Bowil', '0101000020E61000002F127FB9BBBB1E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513202, 'MT35', 'NL32-02', NULL, 'BOZEN', 'Bözen', 'Bozen', '0101000020E6100000E4558CA9AA2A2040AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513203, 'NS76', 'NL32-06', NULL, 'BRAIL', 'Brail', 'Brail', '0101000020E61000004BBCF20F111124403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513205, 'LS72', 'NL32-04', NULL, 'BRAMOIS', 'Bramois', 'Bramois', '0101000020E61000009A99999999991D40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513206, 'NS16', 'NL32-05', NULL, 'BRAND', 'Brand', 'Brand', '0101000020E61000001CAA735655552240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513207, 'LS93', 'NL32-04', NULL, 'BRATSCH', 'Bratsch', 'Bratsch', '0101000020E6100000CDCCCCCCCCCC1E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513209, 'MS99', 'NL32-05', NULL, 'BRAUNWALD', 'Braunwald', 'Braunwald', '0101000020E6100000B122597677F7214046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513210, 'NR09', 'NL32-05', NULL, 'BRE', 'Brè', 'Bre', '0101000020E6100000000000000000224054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513212, 'LR69', 'NL32-04', NULL, 'BRECHOLEY', 'Brecholey', 'Brecholey', '0101000020E6100000D1ED804644441D4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513215, 'NS07', 'NL32-05', NULL, 'BREIL', 'Breíl', 'Breil', '0101000020E6100000E97640232222224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513216, 'MT75', 'NL32-02', NULL, 'BREITE', 'Breite', 'Breite', '0101000020E61000001CAA735655552140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513217, 'LT95', 'NL32-01', NULL, 'BREITENBACH', 'Breitenbach', 'Breitenbach', '0101000020E61000003333333333331E403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513218, 'MS38', 'NL32-05', NULL, 'BREITENFELD', 'Breitenfeld', 'Breitenfeld', '0101000020E6100000333333333333204013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513221, 'LT80', 'NL32-04', NULL, 'BREMGARTEN', 'Bremgarten', 'Bremgarten', '0101000020E6100000CDCCCCCCCCCC1D40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513222, 'MT44', 'NL32-02', NULL, 'BREMGARTEN', 'Bremgarten', 'Bremgarten', '0101000020E6100000E4558CA9AAAA2040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513226, 'LS37', 'NL32-04', NULL, 'BRENLES', 'Brenles', 'Brenles', '0101000020E61000000421B47977771B4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513228, 'MR99', 'NL32-05', NULL, 'BRENO', 'Breno', 'Breno', '0101000020E61000007EEF254344C4214013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513229, 'LS98', 'NL32-04', NULL, 'BRENZIKOFEN', 'Brenzikofen', 'Brenzikofen', '0101000020E61000000421B47977771E40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513231, 'LT95', 'NL32-01', NULL, 'BRETZWIL', 'Bretzwil', 'Bretzwil', '0101000020E61000009A99999999991E403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513232, 'NS46', 'NL32-05', NULL, 'BRIENZ', 'Brienz', 'Brienz', '0101000020E6100000333333333333234087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513233, 'MS27', 'NL32-05', NULL, 'BRIENZ', 'Brienz', 'Brienz', '0101000020E61000004BBCF20F1111204054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513238, 'MS37', 'NL32-05', NULL, 'BRIENZWILER', 'Brienzwiler', 'Brienzwiler', '0101000020E610000033333333333320400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513240, 'MS22', 'NL32-04', NULL, 'BRIG', 'Brig', 'Brig', '0101000020E61000006245B2ECEEEE1F40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513243, 'MS12', 'NL32-04', NULL, 'BRIGERBAD', 'Brigerbad', 'Brigerbad', '0101000020E61000002F127FB9BBBB1F406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513244, 'LS71', 'NL32-04', NULL, 'BRIGNON', 'Brignon', 'Brignon', '0101000020E6100000D1ED804644441D4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513246, 'MS82', 'NL32-05', NULL, 'BRIONE', 'Brione', 'Brione', '0101000020E61000004BBCF20F1191214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513248, 'LT85', 'NL32-01', NULL, 'BRISLACH', 'Brislach', 'Brislach', '0101000020E61000009578E51F22221E4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513249, 'MS70', 'NL32-05', NULL, 'BRISSAGO', 'Brissago', 'Brissago', '0101000020E6100000B5430DF0EE6E2140218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513251, 'MS77', 'NL32-05', NULL, 'BRISTEN', 'Bristen', 'Bristen', '0101000020E61000001789BFDCDD5D214054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513253, 'MT23', 'NL32-01', NULL, 'BRITTNAU', 'Brittnau', 'Brittnau', '0101000020E6100000CDCCCCCCCCCC1F400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513254, 'LS56', 'NL32-04', NULL, 'BROC', 'Broc', 'Broc', '0101000020E61000006666666666661C40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513255, 'MS37', 'NL32-05', NULL, 'BROCH', 'Broch', 'Broch', '0101000020E6100000CDCCCCCCCC4C204046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513256, 'MS73', 'NL32-05', NULL, 'BROGLIO', 'Broglio', 'Broglio', '0101000020E61000001CAA735655552140DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513257, 'NT05', 'NL32-02', NULL, 'BRONSCHHOFEN', 'Bronschhofen', 'Bronschhofen', '0101000020E61000004BBCF20F11112240AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513258, 'MS73', 'NL32-05', NULL, 'BRONTALLO', 'Brontallo', 'Brontallo', '0101000020E61000007EEF254344442140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513259, 'LT20', 'NL32-04', NULL, 'BROTDESSOUS', 'Brot-Dessous', 'Brot-Dessous', '0101000020E61000000000000000001B409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513260, 'LT20', 'NL32-04', NULL, 'BROTPLAMBOZ', 'Brot-Plamboz', 'Brot-Plamboz', '0101000020E61000000000000000001B40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513264, 'MT35', 'NL32-02', NULL, 'BRUGG', 'Brugg', 'Brugg', '0101000020E61000006666666666662040AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513263, 'LT61', 'NL32-01', NULL, 'BRUGG', 'Brügg', 'Brugg', '0101000020E61000009578E51F22221D40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513265, 'NT25', 'NL32-02', NULL, 'BRUGGEN', 'Bruggen', 'Bruggen', '0101000020E6100000E4558CA9AAAA224087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513267, 'MS37', 'NL32-05', NULL, 'BRUNIGEN', 'Brünigen', 'Brunigen', '0101000020E61000007EEF2543444420400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513269, 'NT04', 'NL32-02', NULL, 'BRUNNADERN', 'Brunnadern', 'Brunnadern', '0101000020E61000008210DABCBB3B2240791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513271, 'MT60', 'NL32-05', NULL, 'BRUNNEN', 'Brunnen', 'Brunnen', '0101000020E61000003333333333332140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513272, 'LT81', 'NL32-01', NULL, 'BRUNNENTHAL', 'Brunnenthal', 'Brunnenthal', '0101000020E61000006B871AE0DDDD1D40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513273, 'MR98', 'NL32-08', NULL, 'BRUSINOARSIZIO', 'Brusino Arsizio', 'Brusino Arsizio', '0101000020E61000001789BFDCDDDD214046E22F7777F74640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513274, 'NS82', 'NL32-06', NULL, 'BRUSIO', 'Brusio', 'Brusio', '0101000020E61000008210DABCBB3B244054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513275, 'LS60', 'NL32-04', NULL, 'BRUSON', 'Bruson', 'Bruson', '0101000020E61000006B871AE0DDDD1C40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513276, 'LT50', 'NL32-01', NULL, 'BRUTTELEN', 'Brüttelen', 'Bruttelen', '0101000020E61000009A99999999991C4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513277, 'MT75', 'NL32-02', NULL, 'BRUTTEN', 'Brütten', 'Brutten', '0101000020E61000001CAA735655552140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513278, 'MT75', 'NL32-02', NULL, 'BRUTTISELLEN', 'Brüttisellen', 'Bruttisellen', '0101000020E61000007EEF25434444214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513279, 'MT05', 'NL32-01', NULL, 'BUBENDORF', 'Bubendorf', 'Bubendorf', '0101000020E61000006245B2ECEEEE1E409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513280, 'MT83', 'NL32-02', NULL, 'BUBIKON', 'Bubikon', 'Bubikon', '0101000020E61000009A9999999999214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513281, 'MT76', 'NL32-02', NULL, 'BUCH', 'Buch', 'Buch', '0101000020E61000007EEF2543444421406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513282, 'MT67', 'NL32-02', NULL, 'BUCHBERG', 'Buchberg', 'Buchberg', '0101000020E6100000E976402322222140791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513284, 'MS15', 'NL32-04', NULL, 'BUCHEN', 'Buchen', 'Buchen', '0101000020E61000009A99999999991F40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513285, 'NS59', 'NL32-05', NULL, 'BUCHEN', 'Buchen', 'Buchen', '0101000020E6100000B5430DF0EE6E234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513286, 'NT45', 'NL32-02', NULL, 'BUCHEN', 'Buchen', 'Buchen', '0101000020E61000004BBCF20F11112340ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513287, 'LS98', 'NL32-04', NULL, 'BUCHHOLTERBERG', 'Buchholterberg', 'Buchholterberg', '0101000020E61000003854E7ACAAAA1E40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513288, 'NT35', 'NL32-02', NULL, 'BUCHLER', 'Büchler', 'Buchler', '0101000020E6100000000000000000234087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513289, 'MT51', 'NL32-02', NULL, 'BUCHRAIN', 'Buchrain', 'Buchrain', '0101000020E61000003333333333B32040CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513290, 'NT32', 'NL32-02', NULL, 'BUCHS', 'Buchs', 'Buchs', '0101000020E6100000B5430DF0EEEE224087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513292, 'MT55', 'NL32-02', NULL, 'BUCHS', 'Buchs', 'Buchs', '0101000020E61000001789BFDCDDDD20409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513291, 'MT24', 'NL32-02', NULL, 'BUCHS', 'Buchs', 'Buchs', '0101000020E6100000E976402322222040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513293, 'MT78', 'NL32-02', NULL, 'BUCHTHALEN', 'Buchthalen', 'Buchthalen', '0101000020E6100000CDCCCCCCCC4C21409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513295, 'MS37', 'NL32-05', NULL, 'BUHLEN', 'Bühlen', 'Buhlen', '0101000020E61000003333333333332040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513296, 'NT34', 'NL32-02', NULL, 'BUHLER', 'Bühler', 'Buhler', '0101000020E61000001CAA735655D52240DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513297, 'MS69', 'NL32-05', NULL, 'BUHLRUTI', 'Bühlrüti', 'Buhlruti', '0101000020E61000004FDDA68988082140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513298, 'MT31', 'NL32-02', NULL, 'BUHOLZ', 'Buholz', 'Buholz', '0101000020E6100000E4558CA9AA2A2040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513301, 'LT56', 'NL32-01', NULL, 'BUIX', 'Buix', 'Buix', '0101000020E61000009578E51F22221C40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513302, 'MT66', 'NL32-02', NULL, 'BULACH', 'Bülach', 'Bulach', '0101000020E61000004BBCF20F1111214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513303, 'LS56', 'NL32-04', NULL, 'BULLE', 'Bulle', 'Bulle', '0101000020E6100000D1ED804644441C40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513304, 'LS18', 'NL32-04', NULL, 'BULLET', 'Bullet', 'Bullet', '0101000020E6100000D1ED804644441A40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513305, 'MS18', 'NL32-04', NULL, 'BUMBACH', 'Bumbach', 'Bumbach', '0101000020E61000009A99999999991F406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513306, 'LS79', 'NL32-04', NULL, 'BUMPLIZ', 'Bümpliz', 'Bumpliz', '0101000020E6100000FCDE4B8688881D4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513309, 'LS69', 'NL32-04', NULL, 'BUNDTELS', 'Bundtels', 'Bundtels', '0101000020E61000006B871AE0DDDD1C40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513312, 'MT50', 'NL32-05', NULL, 'BUOCHS', 'Buochs', 'Buochs', '0101000020E61000001CAA735655D52040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513313, 'MT52', 'NL32-02', NULL, 'BUONAS', 'Buonas', 'Buonas', '0101000020E61000006666666666E62040DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513314, 'MS02', 'NL32-04', NULL, 'BURCHEN', 'Bürchen', 'Burchen', '0101000020E6100000D1ED804644441F4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513315, 'LT45', 'NL32-01', NULL, 'BURE', 'Bure', 'Bure', '0101000020E61000000000000000001C409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513319, 'LT72', 'NL32-01', NULL, 'BURENANDERAARE', 'Büren an der Aare', 'Buren an der Aare', '0101000020E61000000421B47977771D40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513320, 'MS59', 'NL32-05', NULL, 'BURENNIDDEMBACH', 'Büren nid dem Bach', 'Buren nid dem Bach', '0101000020E6100000CDCCCCCCCCCC204046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513321, 'LT85', 'NL32-01', NULL, 'BURG', 'Burg', 'Burg', '0101000020E61000002F127FB9BBBB1D409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513322, 'LT91', 'NL32-01', NULL, 'BURGDORF', 'Burgdorf', 'Burgdorf', '0101000020E61000000421B47977771E406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513327, 'LS88', 'NL32-04', NULL, 'BURGISTEIN', 'Burgistein', 'Burgistein', '0101000020E61000006245B2ECEEEE1D4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513328, 'MS38', 'NL32-05', NULL, 'BURGLEN', 'Bürglen', 'Burglen', '0101000020E61000001CAA735655552040BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513329, 'MS79', 'NL32-05', NULL, 'BURGLEN', 'Bürglen', 'Burglen', '0101000020E61000001CAA735655552140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513330, 'NT16', 'NL32-02', NULL, 'BURGLEN', 'Bürglen', 'Burglen', '0101000020E6100000CDCCCCCCCC4C22406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513332, 'MT32', 'NL32-02', NULL, 'BURON', 'Büron', 'Buron', '0101000020E61000003333333333332040ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513333, 'KS94', 'NL32-04', NULL, 'BURSINEL', 'Bursinel', 'Bursinel', '0101000020E6100000333333333333194046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513334, 'KS94', 'NL32-04', NULL, 'BURSINS', 'Bursins', 'Bursins', '0101000020E61000009578E51F222219409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513335, 'LS67', 'NL32-04', NULL, 'BURSTERA', 'Burstera', 'Burstera', '0101000020E61000009578E51F22221D4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513336, 'NS36', 'NL32-05', NULL, 'BURTGAS', 'Burtgas', 'Burtgas', '0101000020E6100000CDCCCCCCCCCC2240CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513337, 'KS84', 'NL32-04', NULL, 'BURTIGNY', 'Burtigny', 'Burtigny', '0101000020E61000000000000000001940ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513338, 'NS02', 'NL32-05', NULL, 'BUSEN', 'Busen', 'Busen', '0101000020E61000008210DABCBB3B224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513340, 'LT84', 'NL32-01', NULL, 'BUSSERACH', 'Büsserach', 'Busserach', '0101000020E61000009578E51F22221E40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513342, 'LS15', 'NL32-04', NULL, 'BUSSIGNY', 'Bussigny', 'Bussigny', '0101000020E6100000D1ED804644441A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513343, 'MT83', 'NL32-02', NULL, 'BUSSKIRCH', 'Busskirch', 'Busskirch', '0101000020E6100000E4558CA9AAAA2140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513344, 'LT71', 'NL32-01', NULL, 'BUSSWIL', 'Busswil', 'Busswil', '0101000020E6100000C8AB185355551D40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513346, 'NT04', 'NL32-02', NULL, 'BUTSCHWIL', 'Bütschwil', 'Butschwil', '0101000020E6100000E976402322222240CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513347, 'LS19', 'NL32-04', NULL, 'BUTTES', 'Buttes', 'Buttes', '0101000020E61000003333333333331A40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513348, 'MT31', 'NL32-02', NULL, 'BUTTISHOLZ', 'Buttisholz', 'Buttisholz', '0101000020E61000003333333333332040CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513349, 'MT43', 'NL32-02', NULL, 'BUTTWIL', 'Buttwil', 'Buttwil', '0101000020E6100000E4558CA9AAAA204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513350, 'MT02', 'NL32-01', NULL, 'BUTZBERG', 'Bützberg', 'Butzberg', '0101000020E61000000000000000001F40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513351, 'MT16', 'NL32-01', NULL, 'BUUS', 'Buus', 'Buus', '0101000020E61000000421B47977771F4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513354, 'NS13', 'NL32-05', NULL, 'CABBIOLO', 'Cabbiolo', 'Cabbiolo', '0101000020E61000006666666666662240791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513355, 'MR99', 'NL32-05', NULL, 'CADEMPINO', 'Cadempino', 'Cadempino', '0101000020E6100000CDCCCCCCCCCC214013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513356, 'MS91', 'NL32-05', NULL, 'CADENAZZO', 'Cadenazzo', 'Cadenazzo', '0101000020E61000006666666666E621403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513357, 'MR99', 'NL32-05', NULL, 'CADRO', 'Cadro', 'Cadro', '0101000020E6100000B122597677F721406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513359, 'MS90', 'NL32-05', NULL, 'CAGIALLO', 'Cagiallo', 'Cagiallo', '0101000020E6100000B122597677F72140BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513360, 'MS93', 'NL32-05', NULL, 'CAGNAGO', 'Cagnago', 'Cagnago', '0101000020E61000007EEF254344C42140DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513361, 'MS84', 'NL32-05', NULL, 'CALA', 'Cala', 'Cala', '0101000020E6100000E976402322A2214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513365, 'NS28', 'NL32-05', NULL, 'CALORTSCH', 'Calörtsch', 'Calortsch', '0101000020E6100000E976402322A2224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513366, 'MS84', 'NL32-05', NULL, 'CALPIOGNA', 'Calpiogna', 'Calpiogna', '0101000020E61000009A99999999992140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513368, 'NS12', 'NL32-05', NULL, 'CAMA', 'Cama', 'Cama', '0101000020E61000001CAA73565555224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513369, 'NS26', 'NL32-05', NULL, 'CAMANA', 'Camana', 'Camana', '0101000020E61000004BBCF20F119122403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513373, 'NS01', 'NL32-05', NULL, 'CAMORINO', 'Camorino', 'Camorino', '0101000020E610000000000000000022403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513374, 'NS82', 'NL32-06', NULL, 'CAMPASCIO', 'Campascio', 'Campascio', '0101000020E61000008210DABCBB3B24400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513375, 'NS64', 'NL32-05', NULL, 'CAMPFER', 'Campfer', 'Campfer', '0101000020E61000009A99999999992340ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513376, 'MS97', 'NL32-05', NULL, 'CAMPLIUN', 'Campliun', 'Campliun', '0101000020E6100000B122597677F721400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513377, 'MS62', 'NL32-05', NULL, 'CAMPO', 'Campo', 'Campo', '0101000020E6100000000000000000214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513378, 'MS64', 'NL32-05', NULL, 'CAMPO', 'Campo', 'Campo', '0101000020E61000004FDDA6898808214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513380, 'MS95', 'NL32-05', NULL, 'CAMPOBLENIO', 'Campo Blenio', 'Campo Blenio', '0101000020E61000001789BFDCDDDD21406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513381, 'NS82', 'NL32-06', NULL, 'CAMPOCOLOGNO', 'Campocologno', 'Campocologno', '0101000020E61000007EEF254344442440AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513385, 'NS75', 'NL32-05', NULL, 'CAMPOVASTO', 'Campovasto', 'Campovasto', '0101000020E61000001789BFDCDDDD2340BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513386, 'NS34', 'NL32-05', NULL, 'CAMPSUT', 'Campsut', 'Campsut', '0101000020E6100000B122597677F72240AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513387, 'MR99', 'NL32-05', NULL, 'CANOBBIO', 'Canobbio', 'Canobbio', '0101000020E61000006666666666E6214013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513388, 'LR68', 'NL32-07', NULL, 'CANTINEDEPROZ', 'Cantine-de-Proz', 'Cantine-de-Proz', '0101000020E6100000CDCCCCCCCCCC1C403333333333F34640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513390, 'MR98', 'NL32-08', NULL, 'CAPOLAGO', 'Capolago', 'Capolago', '0101000020E6100000B122597677F721403333333333F34640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513391, 'NS01', 'NL32-05', NULL, 'CARENA', 'Carena', 'Carena', '0101000020E6100000E4558CA9AA2A224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513392, 'KS71', 'NL32-04', NULL, 'CAROUGE', 'Carouge', 'Carouge', '0101000020E6100000FCDE4B868888184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513393, 'NS28', 'NL32-05', NULL, 'CARRERA', 'Carrera', 'Carrera', '0101000020E61000009A999999999922406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513394, 'KS61', 'NL32-04', NULL, 'CARTIGNY', 'Cartigny', 'Cartigny', '0101000020E61000009EBA4D131111184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513396, 'NS53', 'NL32-05', NULL, 'CASACCIA', 'Casaccia', 'Casaccia', '0101000020E61000001CAA735655552340DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513398, 'NR08', 'NL32-08', NULL, 'CASIMA', 'Casima', 'Casima', '0101000020E61000004BBCF20F11112240DF7BC91011F14640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513399, 'MR99', 'NL32-08', NULL, 'CASLANO', 'Caslano', 'Caslano', '0101000020E61000007EEF254344C42140ED5003BCBBFB4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513404, 'MS94', 'NL32-05', NULL, 'CASSINA', 'Cassina', 'Cassina', '0101000020E61000007EEF254344C42140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513406, 'NR09', 'NL32-05', NULL, 'CASTAGNOLA', 'Castagnola', 'Castagnola', '0101000020E610000000000000000022400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513407, 'NS33', 'NL32-05', NULL, 'CASTASEGNA', 'Castasegna', 'Castasegna', '0101000020E61000004FDDA68988082340791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513412, 'NT60', 'NL32-05', NULL, 'CASTELS', 'Castels', 'Castels', '0101000020E6100000E976402322A22340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513413, 'NR07', 'NL32-08', NULL, 'CASTELSANPIETRO', 'Castel San Pietro', 'Castel San Pietro', '0101000020E61000000000000000002240218436EFEEEE4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513414, 'NS48', 'NL32-05', NULL, 'CASTIEL', 'Castiel', 'Castiel', '0101000020E61000003333333333332340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513415, 'NS01', 'NL32-05', NULL, 'CASTIONE', 'Castione', 'Castione', '0101000020E61000004BBCF20F11112240AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513416, 'MS94', 'NL32-05', NULL, 'CASTRO', 'Castro', 'Castro', '0101000020E61000001789BFDCDDDD2140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513418, 'NS03', 'NL32-05', NULL, 'CAUCO', 'Cauco', 'Cauco', '0101000020E61000008210DABCBB3B2240791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513419, 'LS44', 'NL32-04', NULL, 'CAUX', 'Caux', 'Caux', '0101000020E61000002F127FB9BBBB1B4046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513424, 'MS63', 'NL32-05', NULL, 'CAVERGNO', 'Cavergno', 'Cavergno', '0101000020E61000003333333333332140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513425, 'MS80', 'NL32-05', NULL, 'CAVIANO', 'Caviano', 'Caviano', '0101000020E61000004FDDA68988882140CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513428, 'NS37', 'NL32-05', NULL, 'CAZIS', 'Cazis', 'Cazis', '0101000020E61000001789BFDCDDDD2240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513429, 'NS65', 'NL32-05', NULL, 'CELERINA', 'Celerina', 'Celerina', '0101000020E61000008210DABCBBBB234054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513430, 'KS83', 'NL32-04', NULL, 'CELIGNY', 'Céligny', 'Celigny', '0101000020E6100000CDCCCCCCCCCC1840CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513436, 'MS62', 'NL32-05', NULL, 'CERENTINO', 'Cerentino', 'Cerentino', '0101000020E61000009A999999991921406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513438, 'KS72', 'NL32-04', NULL, 'CERN', 'Cern', 'Cern', '0101000020E61000003333333333331840AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513439, 'LS56', 'NL32-04', NULL, 'CERNIAT', 'Cerniat', 'Cerniat', '0101000020E61000003854E7ACAAAA1C40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513440, 'LT41', 'NL32-01', NULL, 'CERNIER', 'Cernier', 'Cernier', '0101000020E61000009A99999999991B40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513441, 'NS00', 'NL32-05', NULL, 'CERTARA', 'Certara', 'Certara', '0101000020E6100000E976402322222240791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513445, 'MS62', 'NL32-05', NULL, 'CEVIO', 'Cevio', 'Cevio', '0101000020E61000003333333333332140BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513446, 'LS49', 'NL32-04', NULL, 'CHABREY', 'Chabrey', 'Chabrey', '0101000020E61000006245B2ECEEEE1B4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513448, 'LS82', 'NL32-04', NULL, 'CHALAIS', 'Chalais', 'Chalais', '0101000020E61000009EBA4D1311111E4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513450, 'MT52', 'NL32-02', NULL, 'CHAM', 'Cham', 'Cham', '0101000020E6100000B5430DF0EEEE204046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513451, 'KS72', 'NL32-04', NULL, 'CHAMBESY', 'Chambésy', 'Chambesy', '0101000020E6100000FCDE4B86888818400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513452, 'LS61', 'NL32-04', NULL, 'CHAMOSON', 'Chamoson', 'Chamoson', '0101000020E61000006B871AE0DDDD1C409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513454, 'LS28', 'NL32-04', NULL, 'CHAMPAGNE', 'Champagne', 'Champagne', '0101000020E61000009A99999999991A40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513455, 'LS31', 'NL32-04', NULL, 'CHAMPERY', 'Champéry', 'Champery', '0101000020E61000000421B47977771B4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513456, 'LR59', 'NL32-04', NULL, 'CHAMPEX', 'Champex', 'Champex', '0101000020E61000000421B47977771C4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513458, 'LS60', 'NL32-04', NULL, 'CHAMPSEC', 'Champsec', 'Champsec', '0101000020E61000000000000000001D406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513459, 'LS18', 'NL32-04', NULL, 'CHAMPVENT', 'Champvent', 'Champvent', '0101000020E6100000D1ED804644441A4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513460, 'GM21', 'NL31-06', NULL, 'CHANCY', 'Chancy', 'Chancy', '0101000020E61000006B871AE0DDDD17403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513461, 'LS92', 'NL32-04', NULL, 'CHANDOLIN', 'Chandolin', 'Chandolin', '0101000020E6100000C8AB185355551E400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513462, 'KS84', 'NL32-04', NULL, 'CHANGINS', 'Changins', 'Changins', '0101000020E61000006245B2ECEEEE18403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513463, 'NS66', 'NL32-05', NULL, 'CHANTS', 'Chants', 'Chants', '0101000020E6100000E4558CA9AAAA23403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513464, 'LS27', 'NL32-04', NULL, 'CHAPELLE', 'Chapelle', 'Chapelle', '0101000020E61000006245B2ECEEEE1A4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513465, 'LS35', 'NL32-04', NULL, 'CHARDONNE', 'Chardonne', 'Chardonne', '0101000020E6100000D1ED804644441B40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513468, 'LS56', 'NL32-04', NULL, 'CHARMEY', 'Charmey', 'Charmey', '0101000020E61000003854E7ACAAAA1C40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513470, 'LT65', 'NL32-01', NULL, 'CHARMOILLE', 'Charmoille', 'Charmoille', '0101000020E61000006B871AE0DDDD1C4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513472, 'LS50', 'NL32-04', NULL, 'CHARRATLESCHENES', 'Charrat-les-Chênes', 'Charrat-les-Chenes', '0101000020E6100000FCDE4B8688881C40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513479, 'KR72', 'NL32-07', NULL, 'CHATEAUDEBONMONT', 'Château de Bonmont', 'Chateau de Bonmont', '0101000020E6100000FCDE4B8688881840218436EFEEAE4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513480, 'LS54', 'NL32-04', NULL, 'CHATEAUDOEX', 'Château-d’Oex', 'Chateau-d’Oex', '0101000020E6100000FCDE4B8688881C40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513481, 'LS71', 'NL32-04', NULL, 'CHATEAUNEUF', 'Châteauneuf', 'Chateauneuf', '0101000020E6100000C8AB185355551D40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513482, 'KS72', 'NL32-04', NULL, 'CHATELAINE', 'Châtelaine', 'Chatelaine', '0101000020E61000000421B479777718409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513486, 'LS35', 'NL32-04', NULL, 'CHATELSAINTDENIS', 'Châtel-Saint-Denis', 'Chatel-Saint-Denis', '0101000020E61000009A99999999991B4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513487, 'LS47', 'NL32-04', NULL, 'CHATONNAYE', 'Châtonnaye', 'Chatonnaye', '0101000020E61000002F127FB9BBBB1B400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513490, 'LT40', 'NL32-01', NULL, 'CHAUMONTDEPURY', 'Chaumont-de-Pury', 'Chaumont-de-Pury', '0101000020E6100000CDCCCCCCCCCC1B4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513492, 'LS15', 'NL32-04', NULL, 'CHAVANNES', 'Chavannes', 'Chavannes', '0101000020E6100000D1ED804644441A4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513493, 'LS38', 'NL32-04', NULL, 'CHAVANNESLECHENE', 'Chavannes-le-Chêne', 'Chavannes-le-Chene', '0101000020E61000009578E51F22221B4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513494, 'LS47', 'NL32-04', NULL, 'CHAVANNESSOUSORSONNENS', 'Chavannes-sous-Orsonnens', 'Chavannes-sous-Orsonnens', '0101000020E61000006245B2ECEEEE1B40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513495, 'LS17', 'NL32-04', NULL, 'CHAVORNAY', 'Chavornay', 'Chavornay', '0101000020E6100000D1ED804644441A40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513496, 'LS37', 'NL32-04', NULL, 'CHEIRY', 'Cheiry', 'Cheiry', '0101000020E6100000C8AB185355551B400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513497, 'LS50', 'NL32-04', NULL, 'CHEMIN', 'Chemin', 'Chemin', '0101000020E61000006666666666661C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48559, 'KS82', 'NL32-04', NULL, 'CHENEBOUGERIES', 'Chêne-Bougeries', 'Chene-Bougeries', '0101000020E61000003854E7ACAAAA18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513499, 'KS82', 'NL32-04', NULL, 'CHENEBOURG', 'Chêne-Bourg', 'Chene-Bourg', '0101000020E6100000CDCCCCCCCCCC18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513500, 'LS28', 'NL32-04', NULL, 'CHENEPAQUIER', 'Chêne-Pâquier', 'Chene-Paquier', '0101000020E61000009EBA4D1311111B4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513503, 'LS82', 'NL32-04', NULL, 'CHERMIGNONDENBAS', 'Chermignon-d’en Bas', 'Chermignon-d’en Bas', '0101000020E6100000CDCCCCCCCCCC1D4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513504, 'LS82', 'NL32-04', NULL, 'CHERMIGNONDENHAUT', 'Chermignon-d’en Haut', 'Chermignon-d’en Haut', '0101000020E61000006B871AE0DDDD1D4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513505, 'LS16', 'NL32-04', NULL, 'CHESEAUX', 'Cheseaux', 'Cheseaux', '0101000020E61000006666666666661A40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513508, 'LS42', 'NL32-04', NULL, 'CHESIERES', 'Chesières', 'Chesieres', '0101000020E61000003333333333331C406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513509, 'LT44', 'NL32-01', NULL, 'CHEVENEZ', 'Chevenez', 'Chevenez', '0101000020E61000000000000000001C40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513513, 'LS49', 'NL32-04', NULL, 'CHEVROUX', 'Chevroux', 'Chevroux', '0101000020E61000009A99999999991B40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513514, 'LS25', 'NL32-04', NULL, 'CHEXBRES', 'Chexbres', 'Chexbres', '0101000020E61000009578E51F22221B40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513516, 'LS38', 'NL32-04', NULL, 'CHEYRES', 'Cheyres', 'Cheyres', '0101000020E61000009578E51F22221B40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513517, 'LT41', 'NL32-01', NULL, 'CHEZARDSAINTMARTIN', 'Chézard-Saint-Martin', 'Chezard-Saint-Martin', '0101000020E61000002F127FB9BBBB1B40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513518, 'LS39', 'NL32-04', NULL, 'CHEZLEBART', 'Chez-le-Bart', 'Chez-le-Bart', '0101000020E61000009578E51F22221B403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513519, 'NR07', 'NL32-08', NULL, 'CHIASSO', 'Chiasso', 'Chiasso', '0101000020E61000004BBCF20F11112240791563AAAAEA4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513520, 'NS04', 'NL32-05', NULL, 'CHIAVASCO', 'Chiavasco', 'Chiavasco', '0101000020E61000004FDDA6898808224046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513522, 'MS84', 'NL32-05', NULL, 'CHIGGIOGNA', 'Chiggiogna', 'Chiggiogna', '0101000020E6100000E976402322A22140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513525, 'LS82', 'NL32-04', NULL, 'CHIPPIS', 'Chippis', 'Chippis', '0101000020E61000009578E51F22221E4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513526, 'MS84', 'NL32-05', NULL, 'CHIRONICO', 'Chironico', 'Chironico', '0101000020E6100000E4558CA9AAAA214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513528, 'LT74', 'NL32-01', NULL, 'CHOINDEZ', 'Choindez', 'Choindez', '0101000020E6100000FCDE4B8688881D40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513529, 'NS38', 'NL32-05', 3, 'CHUR', 'Chur', 'Chur', '0101000020E61000000000000000002340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513531, 'NS48', 'NL32-05', NULL, 'CHURWALDEN', 'Churwalden', 'Churwalden', '0101000020E61000004BBCF20F1111234013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513533, 'PS06', 'NL32-06', NULL, 'CIERFS', 'Cierfs', 'Cierfs', '0101000020E6100000E4558CA9AAAA2440DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513535, 'LS55', 'NL32-04', NULL, 'CIERNESPICAT', 'Ciernes-Picat', 'Ciernes-Picat', '0101000020E61000003854E7ACAAAA1C400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513536, 'NS00', 'NL32-05', NULL, 'CIMADERA', 'Cimadera', 'Cimadera', '0101000020E61000009A99999999192240791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513537, 'MS62', 'NL32-05', NULL, 'CIMALMOTTO', 'Cimalmotto', 'Cimalmotto', '0101000020E6100000000000000000214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513538, 'NS76', 'NL32-06', NULL, 'CINUSKEL', 'Cinuskel', 'Cinuskel', '0101000020E61000004FDDA68988082440DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513540, 'NS02', 'NL32-05', NULL, 'CLARO', 'Claro', 'Claro', '0101000020E61000004BBCF20F111122400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513542, 'NS67', 'NL32-05', NULL, 'CLAVADEL', 'Clavadel', 'Clavadel', '0101000020E61000009A9999999999234054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513545, 'NS36', 'NL32-05', NULL, 'CLUGIN', 'Clugin', 'Clugin', '0101000020E61000001CAA735655D52240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513551, 'LT55', 'NL32-01', NULL, 'COEUVE', 'Coeuve', 'Coeuve', '0101000020E61000006666666666661C40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513553, 'KS72', 'NL32-04', NULL, 'COINTRIN', 'Cointrin', 'Cointrin', '0101000020E61000000421B47977771840ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513555, 'LT31', 'NL32-01', NULL, 'COLDESROCHES', 'Col des Roches', 'Col des Roches', '0101000020E61000006666666666661B406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513557, 'LS42', 'NL32-04', NULL, 'COLLOMBEY', 'Collombey', 'Collombey', '0101000020E6100000CDCCCCCCCCCC1B4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513559, 'LS41', 'NL32-04', NULL, 'COLLONGES', 'Collonges', 'Collonges', '0101000020E61000009578E51F22221C4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513561, 'LS05', 'NL32-04', NULL, 'COLOMBIER', 'Colombier', 'Colombier', '0101000020E61000006B871AE0DDDD19406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513562, 'LT30', 'NL32-04', NULL, 'COLOMBIER', 'Colombier', 'Colombier', '0101000020E61000000421B47977771B40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513563, 'KS72', 'NL32-04', NULL, 'COLOVREX', 'Colovrex', 'Colovrex', '0101000020E6100000FCDE4B86888818400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513564, 'NS43', 'NL32-05', NULL, 'COLTURA', 'Coltura', 'Coltura', '0101000020E6100000E976402322222340CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513565, 'MR99', 'NL32-05', NULL, 'COMANO', 'Comano', 'Comano', '0101000020E61000001789BFDCDDDD214013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513567, 'LS37', 'NL32-04', NULL, 'COMBREMONTLEPETIT', 'Combremont-le-Petit', 'Combremont-le-Petit', '0101000020E6100000C8AB185355551B400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513568, 'MS61', 'NL32-05', NULL, 'COMOLOGNO', 'Comologno', 'Comologno', '0101000020E6100000E4558CA9AA2A21409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513569, 'MS97', 'NL32-05', NULL, 'COMPADIALS', 'Compadials', 'Compadials', '0101000020E61000001CAA735655D52140AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513570, 'PT00', 'NL32-06', NULL, 'COMPATSCH', 'Compatsch', 'Compatsch', '0101000020E6100000CDCCCCCCCCCC24409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513571, 'KS71', 'NL32-04', NULL, 'COMPESIERES', 'Compesières', 'Compesieres', '0101000020E61000000421B479777718403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513572, 'MS94', 'NL32-05', NULL, 'COMPROVASCO', 'Comprovasco', 'Comprovasco', '0101000020E61000006666666666E621409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513573, 'LS29', 'NL32-04', NULL, 'CONCISE', 'Concise', 'Concise', '0101000020E61000006B871AE0DDDD1A40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513575, 'KS71', 'NL32-04', NULL, 'CONFIGNON', 'Confignon', 'Confignon', '0101000020E6100000C8AB18535555184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513578, 'NS46', 'NL32-05', NULL, 'CONTERS', 'Conters', 'Conters', '0101000020E61000003333333333332340218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513579, 'NS59', 'NL32-05', NULL, 'CONTERS', 'Conters', 'Conters', '0101000020E61000004BBCF20F119123403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513580, 'LS62', 'NL32-04', NULL, 'CONTHEY', 'Conthey', 'Conthey', '0101000020E61000003333333333331D40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513581, 'MS91', 'NL32-05', NULL, 'CONTONE', 'Contone', 'Contone', '0101000020E61000001789BFDCDDDD21403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513582, 'MS81', 'NL32-05', NULL, 'CONTRA', 'Contra', 'Contra', '0101000020E6100000E4558CA9AAAA214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513586, 'LS72', 'NL32-04', NULL, 'COPPET', 'Coppet', 'Coppet', '0101000020E6100000C8AB185355551D4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513587, 'KS83', 'NL32-04', NULL, 'COPPET', 'Coppet', 'Coppet', '0101000020E6100000CDCCCCCCCCCC1840BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513588, 'LS43', 'NL32-04', NULL, 'CORBEYRIER', 'Corbeyrier', 'Corbeyrier', '0101000020E61000006B871AE0DDDD1B40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513589, 'MS71', 'NL32-05', NULL, 'CORCAPOLO', 'Corcapolo', 'Corcapolo', '0101000020E61000001789BFDCDD5D214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513590, 'LS48', 'NL32-04', NULL, 'CORCELLES', 'Corcelles', 'Corcelles', '0101000020E61000006B871AE0DDDD1B40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513591, 'LT83', 'NL32-01', NULL, 'CORCELLES', 'Corcelles', 'Corcelles', '0101000020E61000003854E7ACAAAA1D4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513592, 'LS59', 'NL32-04', NULL, 'CORDAST', 'Cordast', 'Cordast', '0101000020E61000009A99999999991C40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513593, 'LS83', 'NL32-04', NULL, 'CORDONA', 'Cordona', 'Cordona', '0101000020E61000003333333333331E40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513595, 'LT52', 'NL32-01', NULL, 'CORGEMONT', 'Corgémont', 'Corgemont', '0101000020E6100000FCDE4B8688881C4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513596, 'MS81', 'NL32-05', NULL, 'CORIPPO', 'Corippo', 'Corippo', '0101000020E6100000E4558CA9AAAA2140AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513597, 'LS58', 'NL32-04', NULL, 'CORMINBOEUF', 'Corminboeuf', 'Corminboeuf', '0101000020E61000006666666666661C406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513598, 'LT41', 'NL32-01', NULL, 'CORNAUX', 'Cornaux', 'Cornaux', '0101000020E61000009EBA4D1311111C40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513601, 'LT65', 'NL32-01', NULL, 'CORNOL', 'Cornol', 'Cornol', '0101000020E61000003854E7ACAAAA1C403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513602, 'KS82', 'NL32-04', NULL, 'CORSIER', 'Corsier', 'Corsier', '0101000020E61000006B871AE0DDDD184054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513604, 'LS39', 'NL32-04', NULL, 'CORTAILLOD', 'Cortaillod', 'Cortaillod', '0101000020E61000006666666666661B4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513605, 'MS70', 'NL32-05', NULL, 'CORTASCIO', 'Cortascio', 'Cortascio', '0101000020E61000001CAA735655552140218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513606, 'MS74', 'NL32-05', NULL, 'CORTE', 'Corte', 'Corte', '0101000020E61000007EEF254344442140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513607, 'MS63', 'NL32-05', NULL, 'CORTEGRANDE', 'Corte Grande', 'Corte Grande', '0101000020E61000000000000000002140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513608, 'MS63', 'NL32-05', NULL, 'CORTEGRANDE', 'Corte Grande', 'Corte Grande', '0101000020E610000000000000000021403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513611, 'LS06', 'NL32-04', NULL, 'COSSONAY', 'Cossonay', 'Cossonay', '0101000020E61000009EBA4D1311111A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513616, 'LS47', 'NL32-04', NULL, 'COTTENS', 'Cottens', 'Cottens', '0101000020E61000009578E51F22221C400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513620, 'LT74', 'NL32-01', NULL, 'COURFAIVRE', 'Courfaivre', 'Courfaivre', '0101000020E61000009578E51F22221D40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513621, 'LT55', 'NL32-01', NULL, 'COURGENAY', 'Courgenay', 'Courgenay', '0101000020E61000000421B47977771C403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513622, 'LS59', 'NL32-04', NULL, 'COURGEVAUX', 'Courgevaux', 'Courgevaux', '0101000020E61000006666666666661C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513623, 'LS59', 'NL32-04', NULL, 'COURLEVON', 'Courlevon', 'Courlevon', '0101000020E61000006666666666661C40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513624, 'LT74', 'NL32-01', NULL, 'COURRENDLIN', 'Courrendlin', 'Courrendlin', '0101000020E61000000421B47977771D40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513625, 'LT74', 'NL32-01', NULL, 'COURROUX', 'Courroux', 'Courroux', '0101000020E61000000421B47977771D40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513626, 'LT73', 'NL32-01', NULL, 'COURT', 'Court', 'Court', '0101000020E6100000C8AB185355551D40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513627, 'LT55', 'NL32-01', NULL, 'COURTEDOUX', 'Courtedoux', 'Courtedoux', '0101000020E61000009578E51F22221C403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513628, 'LT52', 'NL32-01', NULL, 'COURTELARY', 'Courtelary', 'Courtelary', '0101000020E6100000D1ED804644441C4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513629, 'LT55', 'NL32-01', NULL, 'COURTEMAICHE', 'Courtemaîche', 'Courtemaiche', '0101000020E61000003333333333331C40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513630, 'LS69', 'NL32-04', NULL, 'COURTEPIN', 'Courtepin', 'Courtepin', '0101000020E6100000CDCCCCCCCCCC1C40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513631, 'LT74', 'NL32-01', NULL, 'COURTETELLE', 'Courtételle', 'Courtetelle', '0101000020E6100000D1ED804644441D40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513632, 'LS59', 'NL32-04', NULL, 'COURTION', 'Courtion', 'Courtion', '0101000020E6100000D1ED804644441C40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513633, 'LS71', 'NL32-04', NULL, 'COUTA', 'Couta', 'Couta', '0101000020E6100000FCDE4B8688881D40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513634, 'LS19', 'NL32-04', NULL, 'COUVET', 'Couvet', 'Couvet', '0101000020E6100000FCDE4B8688881A4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513636, 'NS46', 'NL32-05', NULL, 'CRADIGLLAI', 'Cra digl Lai', 'Cra digl Lai', '0101000020E61000004BBCF20F11112340CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513637, 'MS71', 'NL32-05', NULL, 'CRANA', 'Crana', 'Crana', '0101000020E61000008210DABCBB3B2140ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513638, 'LS82', 'NL32-04', NULL, 'CRANS', 'Crans', 'Crans', '0101000020E61000006B871AE0DDDD1D406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513639, 'KS83', 'NL32-04', NULL, 'CRANS', 'Crans', 'Crans', '0101000020E6100000CDCCCCCCCCCC1840218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513641, 'KS83', 'NL32-04', NULL, 'CRASSIER', 'Crassier', 'Crassier', '0101000020E61000003854E7ACAAAA1840218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513642, 'NS54', 'NL32-05', NULL, 'CRASTA', 'Crasta', 'Crasta', '0101000020E61000004FDDA6898888234087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513644, 'LT83', 'NL32-01', NULL, 'CREMINES', 'Crémines', 'Cremines', '0101000020E61000002F127FB9BBBB1D4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513645, 'NS02', 'NL32-05', NULL, 'CRESCIANO', 'Cresciano', 'Cresciano', '0101000020E6100000000000000000224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513646, 'LS59', 'NL32-04', NULL, 'CRESSIER', 'Cressier', 'Cressier', '0101000020E6100000FCDE4B8688881C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513647, 'LT51', 'NL32-01', NULL, 'CRESSIER', 'Cressier', 'Cressier', '0101000020E61000009578E51F22221C406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513648, 'NS34', 'NL32-05', NULL, 'CRESTA', 'Cresta', 'Cresta', '0101000020E61000004FDDA68988082340ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513651, 'MS94', 'NL32-05', NULL, 'CRICH', 'Crich', 'Crich', '0101000020E6100000CDCCCCCCCCCC214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513653, 'LS15', 'NL32-04', NULL, 'CRISSIER', 'Crissier', 'Crissier', '0101000020E6100000C8AB185355551A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513655, 'MS84', 'NL32-05', NULL, 'CROCE', 'Croce', 'Croce', '0101000020E6100000E976402322A22140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513656, 'PS08', 'NL32-06', NULL, 'CRUSCH', 'Crusch', 'Crusch', '0101000020E61000003333333333B32440BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513657, 'LT40', 'NL32-04', NULL, 'CUDREFIN', 'Cudrefin', 'Cudrefin', '0101000020E61000009EBA4D1311111C409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513659, 'MS91', 'NL32-05', NULL, 'CUGNASCO', 'Cugnasco', 'Cugnasco', '0101000020E61000007EEF254344C4214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513660, 'LS16', 'NL32-04', NULL, 'CUGY', 'Cugy', 'Cugy', '0101000020E6100000FCDE4B8688881A40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513661, 'LS38', 'NL32-04', NULL, 'CUGY', 'Cugy', 'Cugy', '0101000020E6100000FCDE4B8688881B40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513662, 'LS25', 'NL32-04', NULL, 'CULLY', 'Cully', 'Cully', '0101000020E61000006245B2ECEEEE1A40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513663, 'NS17', 'NL32-05', NULL, 'CUMBELS', 'Cumbels', 'Cumbels', '0101000020E61000001789BFDCDD5D2240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513665, 'MS86', 'NL32-05', NULL, 'CURAGLIA', 'Curaglia', 'Curaglia', '0101000020E61000008210DABCBBBB214046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513666, 'NS00', 'NL32-05', NULL, 'CURTINA', 'Curtina', 'Curtina', '0101000020E61000004FDDA68988082240791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513668, 'MT77', 'NL32-02', NULL, 'DACHSEN', 'Dachsen', 'Dachsen', '0101000020E61000007EEF25434444214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513669, 'MT22', 'NL32-01', NULL, 'DAGMERSELLEN', 'Dagmersellen', 'Dagmersellen', '0101000020E61000006245B2ECEEEE1F40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513670, 'LS16', 'NL32-04', NULL, 'DAILLENS', 'Daillens', 'Daillens', '0101000020E61000003333333333331A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513672, 'LS82', 'NL32-04', NULL, 'DAILLEY', 'Dailley', 'Dailley', '0101000020E6100000CDCCCCCCCCCC1D40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513673, 'LS41', 'NL32-04', NULL, 'DAILLY', 'Dailly', 'Dailly', '0101000020E61000009578E51F22221C409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513674, 'MS59', 'NL32-05', NULL, 'DALLENWIL', 'Dallenwil', 'Dallenwil', '0101000020E61000007EEF254344C4204087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513675, 'MS84', 'NL32-05', NULL, 'DALPE', 'Dalpe', 'Dalpe', '0101000020E61000004FDDA68988882140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513678, 'LT44', 'NL32-01', NULL, 'DAMVANT', 'Damvant', 'Damvant', '0101000020E61000009A99999999991B40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513679, 'NS04', 'NL32-05', NULL, 'DANDRIO', 'Dandrio', 'Dandrio', '0101000020E61000009A9999999919224046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513680, 'MT24', 'NL32-01', NULL, 'DANIKEN', 'Däniken', 'Daniken', '0101000020E61000006B871AE0DDDD1F40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513681, 'NS07', 'NL32-05', NULL, 'DANIS', 'Danis', 'Danis', '0101000020E61000009A999999991922400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513682, 'KS62', 'NL32-04', NULL, 'DARDAGNY', 'Dardagny', 'Dardagny', '0101000020E610000000000000000018409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513683, 'MS06', 'NL32-04', NULL, 'DARLIGEN', 'Därligen', 'Darligen', '0101000020E61000003333333333331F4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513684, 'LS86', 'NL32-04', NULL, 'DARSTETTEN', 'Därstetten', 'Darstetten', '0101000020E61000006245B2ECEEEE1D403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513685, 'MT45', 'NL32-02', NULL, 'DATTWIL', 'Dättwil', 'Dattwil', '0101000020E61000004BBCF20F119120409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513688, 'NS68', 'NL32-05', NULL, 'DAVOSDORF', 'Davos Dorf', 'Davos Dorf', '0101000020E6100000E4558CA9AAAA2340BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513689, 'NS68', 'NL32-05', NULL, 'DAVOSPLATZ', 'Davos Platz', 'Davos Platz', '0101000020E6100000E4558CA9AAAA2340BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513690, 'NT14', 'NL32-02', NULL, 'DEGERSHEIM', 'Degersheim', 'Degersheim', '0101000020E61000006666666666662240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513691, 'LT80', 'NL32-04', NULL, 'DEISSWIL', 'Deisswil', 'Deisswil', '0101000020E61000009EBA4D1311111E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513692, 'LT93', 'NL32-01', NULL, 'DEITINGEN', 'Deitingen', 'Deitingen', '0101000020E61000000421B47977771E40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513694, 'LT74', 'NL32-01', 3, 'DELEMONT', 'Delémont', 'Delemont', '0101000020E6100000C8AB185355551D40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513696, 'MT25', 'NL32-02', NULL, 'DENSBUREN', 'Densbüren', 'Densburen', '0101000020E61000009A999999991920409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513701, 'LT92', 'NL32-01', NULL, 'DERENDINGEN', 'Derendingen', 'Derendingen', '0101000020E6100000C8AB185355551E409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513703, 'LS54', 'NL32-04', NULL, 'DEVANT', 'Devant', 'Devant', '0101000020E61000000421B47977771C4046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513708, 'MS38', 'NL32-05', NULL, 'DIECHTERSMATT', 'Diechtersmatt', 'Diechtersmatt', '0101000020E61000001789BFDCDD5D2040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513709, 'MT05', 'NL32-01', NULL, 'DIEGTEN', 'Diegten', 'Diegten', '0101000020E61000003333333333331F4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513710, 'MT55', 'NL32-02', NULL, 'DIELSDORF', 'Dielsdorf', 'Dielsdorf', '0101000020E61000006666666666E62040AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513711, 'LS96', 'NL32-04', NULL, 'DIEMTIGEN', 'Diemtigen', 'Diemtigen', '0101000020E6100000D1ED804644441E40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513714, 'NT44', 'NL32-02', NULL, 'DIEPOLDSAU', 'Diepoldsau', 'Diepoldsau', '0101000020E61000007EEF254344442340DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513715, 'NS09', 'NL32-05', NULL, 'DIESBACH', 'Diesbach', 'Diesbach', '0101000020E61000009A9999999919224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513717, 'LT71', 'NL32-01', NULL, 'DIESSBACH', 'Diessbach', 'Diessbach', '0101000020E61000000421B47977771D40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513718, 'LT51', 'NL32-01', NULL, 'DIESSE', 'Diesse', 'Diesse', '0101000020E61000000421B47977771C40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513719, 'MT88', 'NL32-02', NULL, 'DIESSENHOFEN', 'Diessenhofen', 'Diessenhofen', '0101000020E610000000000000008021409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513720, 'MT55', 'NL32-02', 3, 'DIETIKON', 'Dietikon', 'Dietikon', '0101000020E6100000CDCCCCCCCCCC204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513721, 'MT75', 'NL32-02', NULL, 'DIETLIKON', 'Dietlikon', 'Dietlikon', '0101000020E61000008210DABCBB3B214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513722, 'MT52', 'NL32-02', NULL, 'DIETWIL', 'Dietwil', 'Dietwil', '0101000020E6100000CDCCCCCCCCCC20403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513723, 'NS28', 'NL32-05', NULL, 'DIGG', 'Digg', 'Digg', '0101000020E61000003333333333B32240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513724, 'MT86', 'NL32-02', NULL, 'DINHARD', 'Dinhard', 'Dinhard', '0101000020E61000004FDDA689888821406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513725, 'MR99', 'NL32-05', NULL, 'DINO', 'Dino', 'Dino', '0101000020E6100000B122597677F721406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513726, 'MS87', 'NL32-05', NULL, 'DISENTIS', 'Disentis', 'Disentis', '0101000020E61000003333333333B321409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513727, 'MS97', 'NL32-05', NULL, 'DISLA', 'Disla', 'Disla', '0101000020E6100000CDCCCCCCCCCC21409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513728, 'MR29', 'NL32-04', NULL, 'DISTEL', 'Distel', 'Distel', '0101000020E61000006B871AE0DDDD1F4054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513730, 'LS06', 'NL32-04', NULL, 'DIZY', 'Dizy', 'Dizy', '0101000020E61000006245B2ECEEEE1940DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513731, 'MT37', 'NL32-02', NULL, 'DOGERN', 'Dogern', 'Dogern', '0101000020E61000001CAA735655552040CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513739, 'NS38', 'NL32-05', NULL, 'DOMAT', 'Domat', 'Domat', '0101000020E61000006666666666E62240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513741, 'LT41', 'NL32-01', NULL, 'DOMBRESSON', 'Dombresson', 'Dombresson', '0101000020E61000006B871AE0DDDD1B40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513742, 'LS49', 'NL32-04', NULL, 'DOMDIDIER', 'Domdidier', 'Domdidier', '0101000020E61000009EBA4D1311111C40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513745, 'LS37', 'NL32-04', NULL, 'DOMPIERRE', 'Dompierre', 'Dompierre', '0101000020E6100000FCDE4B8688881B409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513746, 'LS49', 'NL32-04', NULL, 'DOMPIERRE', 'Dompierre', 'Dompierre', '0101000020E61000000000000000001C40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513747, 'LS59', 'NL32-04', NULL, 'DONATYRE', 'Donatyre', 'Donatyre', '0101000020E6100000D1ED804644441C40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513748, 'MS94', 'NL32-05', NULL, 'DONGIO', 'Dongio', 'Dongio', '0101000020E61000006666666666E6214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513749, 'LS27', 'NL32-04', NULL, 'DONNELOYE', 'Donneloye', 'Donneloye', '0101000020E61000006B871AE0DDDD1A400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513750, 'MT20', 'NL32-02', NULL, 'DOPPLESCHWAND', 'Doppleschwand', 'Doppleschwand', '0101000020E61000009A9999999919204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513751, 'LS41', 'NL32-04', NULL, 'DORENAZ', 'Dorénaz', 'Dorenaz', '0101000020E61000003333333333331C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513753, 'NS58', 'NL32-05', NULL, 'DORFLI', 'Dörfli', 'Dorfli', '0101000020E61000000000000000802340BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513755, 'LT95', 'NL32-01', NULL, 'DORNACH', 'Dornach', 'Dornach', '0101000020E61000000421B47977771E40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513756, 'LS98', 'NL32-04', NULL, 'DORNHALDEN', 'Dornhalden', 'Dornhalden', '0101000020E61000006666666666661E406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513757, 'NS09', 'NL32-05', NULL, 'DORNHAUS', 'Dornhaus', 'Dornhaus', '0101000020E61000004BBCF20F111122409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513758, 'MT44', 'NL32-02', NULL, 'DOTTIKON', 'Dottikon', 'Dottikon', '0101000020E6100000B122597677772040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513759, 'MT46', 'NL32-02', NULL, 'DOTTINGEN', 'Döttingen', 'Dottingen', '0101000020E61000000000000000802040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513769, 'LR59', 'NL32-07', NULL, 'DRANSE', 'Dranse', 'Dranse', '0101000020E61000002F127FB9BBBB1C40AC4896DDDDFD4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513777, 'LS98', 'NL32-04', NULL, 'DREILIGASS', 'Dreiligass', 'Dreiligass', '0101000020E61000002F127FB9BBBB1E4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513778, 'MS17', 'NL32-04', NULL, 'DREISCHUBEL', 'Dreischübel', 'Dreischubel', '0101000020E6100000C8AB185355551F4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513787, 'MT74', 'NL32-02', NULL, 'DUBENDORF', 'Dübendorf', 'Dubendorf', '0101000020E61000008210DABCBB3B21403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513788, 'LS69', 'NL32-04', NULL, 'DUDINGEN', 'Düdingen', 'Dudingen', '0101000020E6100000CDCCCCCCCCCC1C40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513794, 'NS02', 'NL32-05', NULL, 'DUNO', 'Duno', 'Duno', '0101000020E61000004FDDA6898808224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513797, 'MT83', 'NL32-02', NULL, 'DURNTEN', 'Dürnten', 'Durnten', '0101000020E61000003333333333B3214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513799, 'NS77', 'NL32-05', NULL, 'DURRBODEN', 'Dürrboden', 'Durrboden', '0101000020E61000001CAA735655D52340ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513800, 'MT34', 'NL32-02', NULL, 'DURRENASCH', 'Dürrenäsch', 'Durrenasch', '0101000020E6100000CDCCCCCCCC4C2040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513801, 'MS89', 'NL32-05', NULL, 'DURRENBODEN', 'Dürrenboden', 'Durrenboden', '0101000020E6100000E4558CA9AAAA214046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513802, 'MT01', 'NL32-01', NULL, 'DURRENROTH', 'Dürrenroth', 'Durrenroth', '0101000020E61000009578E51F22221F40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513805, 'NS27', 'NL32-05', NULL, 'DUTJEN', 'Dutjen', 'Dutjen', '0101000020E61000004FDDA6898888224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513806, 'NS17', 'NL32-05', NULL, 'DUVIN', 'Duvin', 'Duvin', '0101000020E6100000B5430DF0EE6E2240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513807, 'KS82', 'NL32-04', NULL, 'EAUXVIVES', 'Eaux-Vives', 'Eaux-Vives', '0101000020E61000009A999999999918409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513810, 'MT41', 'NL32-02', NULL, 'EBIKON', 'Ebikon', 'Ebikon', '0101000020E6100000E4558CA9AAAA2040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513811, 'MS27', 'NL32-04', NULL, 'EBLIGEN', 'Ebligen', 'Ebligen', '0101000020E61000006B871AE0DDDD1F400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513812, 'NT03', 'NL32-02', NULL, 'EBNAT', 'Ebnat', 'Ebnat', '0101000020E61000008210DABCBB3B22400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513814, 'LS16', 'NL32-04', NULL, 'ECHALLENS', 'Echallens', 'Echallens', '0101000020E6100000FCDE4B8688881A40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513815, 'LS56', 'NL32-04', NULL, 'ECHARLENS', 'Echarlens', 'Echarlens', '0101000020E6100000D1ED804644441C403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513816, 'LS61', 'NL32-04', NULL, 'ECONE', 'Ecône', 'Econe', '0101000020E6100000CDCCCCCCCCCC1C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513817, 'LS36', 'NL32-04', NULL, 'ECUBLENS', 'Ecublens', 'Ecublens', '0101000020E61000003333333333331B40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513818, 'LS57', 'NL32-04', NULL, 'ECUVILLENS', 'Ecuvillens', 'Ecuvillens', '0101000020E6100000C8AB185355551C400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513820, 'MT35', 'NL32-02', NULL, 'EFFINGEN', 'Effingen', 'Effingen', '0101000020E61000008210DABCBB3B2040AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513821, 'MT75', 'NL32-02', NULL, 'EFFRETIKON', 'Effretikon', 'Effretikon', '0101000020E61000001789BFDCDD5D214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513822, 'MT04', 'NL32-01', NULL, 'EGERKINGEN', 'Egerkingen', 'Egerkingen', '0101000020E61000009EBA4D1311111F40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513823, 'MT73', 'NL32-02', NULL, 'EGG', 'Egg', 'Egg', '0101000020E61000001789BFDCDD5D21406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513824, 'NS48', 'NL32-05', NULL, 'EGGA', 'Egga', 'Egga', '0101000020E61000004BBCF20F111123406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513825, 'LS94', 'NL32-04', NULL, 'EGGENSCHWAND', 'Eggenschwand', 'Eggenschwand', '0101000020E61000003854E7ACAAAA1E40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513826, 'MT44', 'NL32-02', NULL, 'EGGENWIL', 'Eggenwil', 'Eggenwil', '0101000020E6100000E4558CA9AAAA2040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513827, 'MS12', 'NL32-04', NULL, 'EGGERBERG', 'Eggerberg', 'Eggerberg', '0101000020E61000000421B47977771F40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513828, 'NT35', 'NL32-02', NULL, 'EGGERSRIET', 'Eggersriet', 'Eggersriet', '0101000020E6100000B5430DF0EEEE22409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513830, 'MS09', 'NL32-04', NULL, 'EGGIWIL', 'Eggiwil', 'Eggiwil', '0101000020E61000009578E51F22221F40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513832, 'MT66', 'NL32-02', NULL, 'EGLISAU', 'Eglisau', 'Eglisau', '0101000020E61000009A99999999192140BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513833, 'MT34', 'NL32-02', NULL, 'EGLISWIL', 'Egliswil', 'Egliswil', '0101000020E61000001789BFDCDD5D2040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513834, 'NT26', 'NL32-02', NULL, 'EGNACH', 'Egnach', 'Egnach', '0101000020E61000008210DABCBBBB224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513836, 'MT32', 'NL32-02', NULL, 'EICH', 'Eich', 'Eich', '0101000020E61000001CAA7356555520403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513837, 'NT44', 'NL32-02', NULL, 'EICHBERG', 'Eichberg', 'Eichberg', '0101000020E61000004BBCF20F11112340CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513838, 'MT40', 'NL32-02', NULL, 'EIGENTHAL', 'Eigenthal', 'Eigenthal', '0101000020E6100000B5430DF0EE6E204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513840, 'MT26', 'NL32-01', NULL, 'EIKEN', 'Eiken', 'Eiken', '0101000020E61000006245B2ECEEEE1F4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513841, 'LS97', 'NL32-04', NULL, 'EINIGEN', 'Einigen', 'Einigen', '0101000020E6100000FCDE4B8688881E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513842, 'MT81', 'NL32-02', NULL, 'EINSIEDELN', 'Einsiedeln', 'Einsiedeln', '0101000020E61000000000000000802140218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513844, 'MS02', 'NL32-04', NULL, 'EISCHOLL', 'Eischoll', 'Eischoll', '0101000020E61000009578E51F22221F4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513846, 'LS81', 'NL32-04', NULL, 'EISON', 'Eison', 'Eison', '0101000020E61000006B871AE0DDDD1D403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513847, 'MS11', 'NL32-04', NULL, 'EISTEN', 'Eisten', 'Eisten', '0101000020E61000009A99999999991F409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513849, 'MT86', 'NL32-02', NULL, 'ELGG', 'Elgg', 'Elgg', '0101000020E61000008210DABCBBBB21400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513852, 'MT77', 'NL32-02', NULL, 'ELLIKONAMRHEIN', 'Ellikon am Rhein', 'Ellikon am Rhein', '0101000020E61000008210DABCBB3B2140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513853, 'MT86', 'NL32-02', NULL, 'ELLIKONANDERTHUR', 'Ellikon an der Thur', 'Ellikon an der Thur', '0101000020E6100000E976402322A22140BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513854, 'NS19', 'NL32-05', NULL, 'ELM', 'Elm', 'Elm', '0101000020E61000001CAA73565555224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513855, 'MT86', 'NL32-02', NULL, 'ELSAU', 'Elsau', 'Elsau', '0101000020E61000004BBCF20F1191214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513856, 'LS95', 'NL32-04', NULL, 'ELSIGBACH', 'Elsigbach', 'Elsigbach', '0101000020E61000006666666666661E4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513857, 'MS11', 'NL32-04', NULL, 'EMBD', 'Embd', 'Embd', '0101000020E6100000C8AB185355551F40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513858, 'MT66', 'NL32-02', NULL, 'EMBRACH', 'Embrach', 'Embrach', '0101000020E610000033333333333321400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513860, 'MT41', 'NL32-02', NULL, 'EMMEN', 'Emmen', 'Emmen', '0101000020E61000009A99999999992040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513861, 'MT41', 'NL32-02', NULL, 'EMMENBRUCKE', 'Emmenbrücke', 'Emmenbrucke', '0101000020E61000004FDDA68988882040BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513862, 'MT00', 'NL32-04', NULL, 'EMMENMATT', 'Emmenmatt', 'Emmenmatt', '0101000020E61000000000000000001F409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513865, 'MT60', 'NL32-05', NULL, 'EMMETTEN', 'Emmetten', 'Emmetten', '0101000020E61000004FDDA68988082140ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513867, 'NT17', 'NL32-02', NULL, 'EMMISHOFEN', 'Emmishofen', 'Emmishofen', '0101000020E61000001CAA7356555522403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513868, 'LS30', 'NL32-04', NULL, 'EMOSSON', 'Emosson', 'Emosson', '0101000020E61000003854E7ACAAAA1B40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513875, 'LT80', 'NL32-04', NULL, 'ENGEHALDE', 'Engehalde', 'Engehalde', '0101000020E61000002F127FB9BBBB1D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513876, 'MS58', 'NL32-05', NULL, 'ENGELBERG', 'Engelberg', 'Engelberg', '0101000020E61000001CAA735655D52040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513877, 'LT61', 'NL32-01', NULL, 'ENGELBERG', 'Engelberg', 'Engelberg', '0101000020E61000002F127FB9BBBB1C40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513881, 'NT10', 'NL32-05', NULL, 'ENGI', 'Engi', 'Engi', '0101000020E6100000CDCCCCCCCC4C2240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513887, 'LS57', 'NL32-04', NULL, 'ENLAGOTTAZ', 'En la Gottaz', 'En la Gottaz', '0101000020E61000006666666666661C409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513888, 'NT00', 'NL32-02', NULL, 'ENNENDA', 'Ennenda', 'Ennenda', '0101000020E6100000E4558CA9AA2A224013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513889, 'MT40', 'NL32-05', NULL, 'ENNETBURGEN', 'Ennetbürgen', 'Ennetburgen', '0101000020E6100000E4558CA9AAAA2040AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513890, 'MT20', 'NL32-05', NULL, 'ENNETEGG', 'Ennetegg', 'Ennetegg', '0101000020E61000004FDDA68988082040AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513891, 'LS55', 'NL32-04', NULL, 'ENNEY', 'Enney', 'Enney', '0101000020E6100000C8AB185355551C40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513892, 'LS53', 'NL32-04', NULL, 'ENSEX', 'Ensex', 'Ensex', '0101000020E61000006666666666661C40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513893, 'LS68', 'NL32-04', NULL, 'ENTENMOOS', 'Entenmoos', 'Entenmoos', '0101000020E61000000000000000001D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513895, 'MT20', 'NL32-05', NULL, 'ENTLEBUCH', 'Entlebuch', 'Entlebuch', '0101000020E6100000E976402322222040AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513899, 'LS25', 'NL32-04', NULL, 'EPALINGES', 'Epalinges', 'Epalinges', '0101000020E61000003854E7ACAAAA1A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513900, 'LS17', 'NL32-04', NULL, 'EPAUTHEYRES', 'Epautheyres', 'Epautheyres', '0101000020E6100000FCDE4B8688881A40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513901, 'LS17', 'NL32-04', NULL, 'EPENDES', 'Ependes', 'Ependes', '0101000020E61000000421B47977771A40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513902, 'LS57', 'NL32-04', NULL, 'EPENDES', 'Ependes', 'Ependes', '0101000020E6100000FCDE4B8688881C400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513903, 'LS41', 'NL32-04', NULL, 'EPINASSEY', 'Épinassey', 'Epinassey', '0101000020E61000000000000000001C4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513904, 'MT14', 'NL32-01', NULL, 'EPTINGEN', 'Eptingen', 'Eptingen', '0101000020E6100000D1ED804644441F40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513905, 'LS62', 'NL32-04', NULL, 'ERDE', 'Erde', 'Erde', '0101000020E61000003333333333331D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513907, 'MT11', 'NL32-01', NULL, 'ERISWIL', 'Eriswil', 'Eriswil', '0101000020E61000006666666666661F40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513908, 'MS08', 'NL32-04', NULL, 'ERIZ', 'Eriz', 'Eriz', '0101000020E61000009EBA4D1311111F4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513909, 'LT51', 'NL32-01', NULL, 'ERLACH', 'Erlach', 'Erlach', '0101000020E61000006666666666661C4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513910, 'NT16', 'NL32-02', NULL, 'ERLEN', 'Erlen', 'Erlen', '0101000020E6100000B1225976777722406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513911, 'MT63', 'NL32-02', NULL, 'ERLENBACH', 'Erlenbach', 'Erlenbach', '0101000020E610000033333333333321406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513912, 'LS86', 'NL32-04', NULL, 'ERLENBACHIMSIMMENTAL', 'Erlenbach im Simmental', 'Erlenbach im Simmental', '0101000020E61000003333333333331E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513916, 'NT07', 'NL32-02', NULL, 'ERMATINGEN', 'Ermatingen', 'Ermatingen', '0101000020E6100000E4558CA9AA2A224087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513917, 'MS33', 'NL32-05', NULL, 'ERNEN', 'Ernen', 'Ernen', '0101000020E6100000CDCCCCCCCC4C20403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513919, 'LS93', 'NL32-04', NULL, 'ERSCHMATT', 'Erschmatt', 'Erschmatt', '0101000020E61000002F127FB9BBBB1E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513920, 'LT84', 'NL32-01', NULL, 'ERSCHWIL', 'Erschwil', 'Erschwil', '0101000020E61000009578E51F22221E40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513921, 'LT91', 'NL32-01', NULL, 'ERSIGEN', 'Ersigen', 'Ersigen', '0101000020E6100000C8AB185355551E40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513922, 'MS78', 'NL32-05', NULL, 'ERSTFELD', 'Erstfeld', 'Erstfeld', '0101000020E61000007EEF254344442140BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513923, 'MS12', 'NL32-04', NULL, 'ESCH', 'Esch', 'Esch', '0101000020E61000000421B47977771F4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513924, 'MT42', 'NL32-02', NULL, 'ESCHENBACH', 'Eschenbach', 'Eschenbach', '0101000020E6100000E976402322A22040DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513925, 'MT93', 'NL32-02', NULL, 'ESCHENBACH', 'Eschenbach', 'Eschenbach', '0101000020E61000001CAA735655D52140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513926, 'MT87', 'NL32-02', NULL, 'ESCHENZ', 'Eschenz', 'Eschenz', '0101000020E61000008210DABCBBBB21403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513928, 'NT06', 'NL32-02', NULL, 'ESCHIKOFEN', 'Eschikofen', 'Eschikofen', '0101000020E61000004FDDA68988082240791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513929, 'MT95', 'NL32-02', NULL, 'ESCHLIKON', 'Eschlikon', 'Eschlikon', '0101000020E6100000B5430DF0EEEE2140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513931, 'MS19', 'NL32-04', NULL, 'ESCHOLZMATT', 'Escholzmatt', 'Escholzmatt', '0101000020E61000002F127FB9BBBB1F4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513933, 'KS95', 'NL32-04', NULL, 'ESSERTINESSURROLLE', 'Essertines-sur-Rolle', 'Essertines-sur-Rolle', '0101000020E6100000D1ED8046444419400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513935, 'LS55', 'NL32-04', NULL, 'ESTAVANNENSDESSOUS', 'Estavannens-Dessous', 'Estavannens-Dessous', '0101000020E61000006666666666661C40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513936, 'LS55', 'NL32-04', NULL, 'ESTAVANNENSDESSUS', 'Estavannens-Dessus', 'Estavannens-Dessus', '0101000020E61000006666666666661C40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513938, 'LS39', 'NL32-04', NULL, 'ESTAVAYERLELAC', 'Estavayer-le-Lac', 'Estavayer-le-Lac', '0101000020E61000006666666666661B40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513939, 'LT41', 'NL32-01', NULL, 'ETITSAVAGNIER', 'etit-Savagnier', 'etit-Savagnier', '0101000020E6100000CDCCCCCCCCCC1B406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513940, 'LT95', 'NL32-01', NULL, 'ETTINGEN', 'Ettingen', 'Ettingen', '0101000020E61000003333333333331E40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513941, 'MT22', 'NL32-02', NULL, 'ETTISWIL', 'Ettiswil', 'Ettiswil', '0101000020E61000004FDDA689880820403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513943, 'MT82', 'NL32-02', NULL, 'ETZEL', 'Etzel', 'Etzel', '0101000020E61000009A999999999921403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513945, 'MT36', 'NL32-02', NULL, 'ETZGEN', 'Etzgen', 'Etzgen', '0101000020E61000003333333333332040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513946, 'MT87', 'NL32-02', NULL, 'ETZWILEN', 'Etzwilen', 'Etzwilen', '0101000020E6100000E976402322A221403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513947, 'LS71', 'NL32-04', NULL, 'EUSEIGNE', 'Euseigne', 'Euseigne', '0101000020E61000003854E7ACAAAA1D4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513949, 'MT81', 'NL32-02', NULL, 'EUTHAL', 'Euthal', 'Euthal', '0101000020E6100000E976402322A22140CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513950, 'LT62', 'NL32-01', NULL, 'EVILARD', 'Evilard', 'Evilard', '0101000020E61000006245B2ECEEEE1C403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513951, 'LR49', 'NL32-04', NULL, 'EVIONNAZ', 'Evionnaz', 'Evionnaz', '0101000020E61000009EBA4D1311111C4054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513952, 'LS80', 'NL32-04', NULL, 'EVOLENE', 'Evolène', 'Evolene', '0101000020E61000000000000000001E40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513953, 'LS43', 'NL32-04', NULL, 'EXERGILLOD', 'Exergillod', 'Exergillod', '0101000020E61000009578E51F22221C40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513955, 'MS12', 'NL32-04', NULL, 'EYHOLZ', 'Eyholz', 'Eyholz', '0101000020E61000003854E7ACAAAA1F4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513957, 'KS84', 'NL32-04', NULL, 'EYSINS', 'Eysins', 'Eysins', '0101000020E6100000CDCCCCCCCCCC1840DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513958, 'MS63', 'NL32-05', NULL, 'FAEDO', 'Faedo', 'Faedo', '0101000020E61000009A99999999192140DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513959, 'MS14', 'NL32-04', NULL, 'FAFLERALP', 'Fafleralp', 'Fafleralp', '0101000020E61000006666666666661F4046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513960, 'LS98', 'NL32-04', NULL, 'FAHRNI', 'Fahrni', 'Fahrni', '0101000020E61000003854E7ACAAAA1E406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513961, 'MT43', 'NL32-02', NULL, 'FAHRWANGEN', 'Fahrwangen', 'Fahrwangen', '0101000020E6100000B1225976777720406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513962, 'LT45', 'NL32-01', NULL, 'FAHY', 'Fahy', 'Fahy', '0101000020E6100000CDCCCCCCCCCC1B4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513963, 'MS84', 'NL32-05', NULL, 'FAIDO', 'Faido', 'Faido', '0101000020E61000009A99999999992140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513965, 'MS03', 'NL32-04', NULL, 'FALDUMALP', 'Faldum Alp', 'Faldum Alp', '0101000020E61000000000000000001F40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513966, 'NS18', 'NL32-05', NULL, 'FALERA', 'Falera', 'Falera', '0101000020E6100000B5430DF0EE6E22406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513969, 'MT74', 'NL32-02', NULL, 'FALLANDEN', 'Fällanden', 'Fallanden', '0101000020E61000007EEF254344442140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513970, 'NT40', 'NL32-05', NULL, 'FANAS', 'Fanas', 'Fanas', '0101000020E6100000CDCCCCCCCC4C2340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513971, 'LS82', 'NL32-04', NULL, 'FANG', 'Fang', 'Fang', '0101000020E6100000D1ED804644441E40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513972, 'MT10', 'NL32-04', NULL, 'FANKHAUS', 'Fankhaus', 'Fankhaus', '0101000020E61000009A99999999991F40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513973, 'LS59', 'NL32-04', NULL, 'FAOUG', 'Faoug', 'Faoug', '0101000020E6100000C8AB185355551C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513974, 'NS36', 'NL32-05', NULL, 'FARDUN', 'Fardün', 'Fardun', '0101000020E61000001CAA735655D52240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513975, 'MS67', 'NL32-05', NULL, 'FARNIGEN', 'Färnigen', 'Farnigen', '0101000020E61000004FDDA68988082140AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513977, 'LS57', 'NL32-04', NULL, 'FARVAGNYLEGRAND', 'Farvagny-le-Grand', 'Farvagny-le-Grand', '0101000020E6100000D1ED804644441C40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513978, 'LS57', 'NL32-04', NULL, 'FARVAGNYLEPETIT', 'Farvagny-le-Petit', 'Farvagny-le-Petit', '0101000020E6100000C8AB185355551C40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513983, 'MS06', 'NL32-04', NULL, 'FAULENSEE', 'Faulensee', 'Faulensee', '0101000020E61000006B871AE0DDDD1E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513986, 'MT84', 'NL32-02', NULL, 'FEHRALTORF', 'Fehraltorf', 'Fehraltorf', '0101000020E61000000000000000802140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513987, 'MT96', 'NL32-02', NULL, 'FELBEN', 'Felben', 'Felben', '0101000020E61000001789BFDCDDDD2140791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513988, 'MS33', 'NL32-05', NULL, 'FELD', 'Feld', 'Feld', '0101000020E6100000B5430DF0EE6E2040218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513989, 'MT83', 'NL32-02', NULL, 'FELDBACH', 'Feldbach', 'Feldbach', '0101000020E61000004BBCF20F119121400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513990, 'MT97', 'NL32-02', NULL, 'FELDBACH', 'Feldbach', 'Feldbach', '0101000020E6100000B122597677F7214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513991, 'LT93', 'NL32-01', NULL, 'FELDBRUNNEN', 'Feldbrunnen', 'Feldbrunnen', '0101000020E61000003333333333331E40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513993, 'NS38', 'NL32-05', NULL, 'FELDIS', 'Feldis', 'Feldis', '0101000020E61000001789BFDCDDDD224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513994, 'MT73', 'NL32-02', NULL, 'FELDMEILEN', 'Feldmeilen', 'Feldmeilen', '0101000020E61000008210DABCBB3B214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513995, 'MS57', 'NL32-05', NULL, 'FELDMOOS', 'Feldmoos', 'Feldmoos', '0101000020E6100000CDCCCCCCCCCC2040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513996, 'NT45', 'NL32-02', NULL, 'FELDMOOS', 'Feldmoos', 'Feldmoos', '0101000020E6100000E4558CA9AA2A2340ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3513999, 'NS38', 'NL32-05', NULL, 'FELSBERG', 'Felsberg', 'Felsberg', '0101000020E6100000B122597677F72240CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514000, 'LT80', 'NL32-04', NULL, 'FELSENAU', 'Felsenau', 'Felsenau', '0101000020E61000002F127FB9BBBB1D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514010, 'MS03', 'NL32-04', NULL, 'FERDEN', 'Ferden', 'Ferden', '0101000020E61000000000000000001F40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514011, 'LT60', 'NL32-04', NULL, 'FERENBALM', 'Ferenbalm', 'Ferenbalm', '0101000020E61000006B871AE0DDDD1C409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514012, 'LS85', 'NL32-04', NULL, 'FERMELBERG', 'Fermelberg', 'Fermelberg', '0101000020E61000006245B2ECEEEE1D4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514017, 'LR58', 'NL32-07', NULL, 'FERRET', 'Ferret', 'Ferret', '0101000020E61000006666666666661C4087EA9C5555F54640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514031, 'LS93', 'NL32-04', NULL, 'FESCHEL', 'Feschel', 'Feschel', '0101000020E61000002F127FB9BBBB1E40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514035, 'NS98', 'NL32-06', NULL, 'FETAN', 'Fetan', 'Fetan', '0101000020E6100000B1225976777724406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514038, 'MT78', 'NL32-02', NULL, 'FEUERTHALEN', 'Feuerthalen', 'Feuerthalen', '0101000020E61000007EEF25434444214046E22F7777D74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514039, 'MT72', 'NL32-02', NULL, 'FEUSISBERG', 'Feusisberg', 'Feusisberg', '0101000020E6100000B12259767777214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514040, 'LS64', 'NL32-04', NULL, 'FEUTERSOEY', 'Feutersoey', 'Feutersoey', '0101000020E61000009EBA4D1311111D4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514042, 'LS43', 'NL32-04', NULL, 'FEYDEY', 'Feydey', 'Feydey', '0101000020E61000000000000000001C40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514043, 'NS28', 'NL32-05', NULL, 'FIDAZ', 'Fidaz', 'Fidaz', '0101000020E61000009A99999999992240CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514044, 'NS59', 'NL32-05', NULL, 'FIDERIS', 'Fideris', 'Fideris', '0101000020E6100000B12259767777234087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514047, 'NS69', 'NL32-05', NULL, 'FIDERISERALPDURANNA', 'Fideriser Alp Duranna', 'Fideriser Alp Duranna', '0101000020E61000009A99999999992340218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514048, 'MS33', 'NL32-05', NULL, 'FIESCH', 'Fiesch', 'Fiesch', '0101000020E61000007EEF2543444420403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514049, 'MS34', 'NL32-05', NULL, 'FIESCHERTHAL', 'Fiescherthal', 'Fiescherthal', '0101000020E6100000CDCCCCCCCC4C204087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514050, 'MS74', 'NL32-05', NULL, 'FIESSO', 'Fiesso', 'Fiesso', '0101000020E6100000B5430DF0EE6E2140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514051, 'LS18', 'NL32-04', NULL, 'FIEZ', 'Fiez', 'Fiez', '0101000020E61000000421B47977771A40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514052, 'LS85', 'NL32-04', NULL, 'FILDERICH', 'Filderich', 'Filderich', '0101000020E61000000000000000001E406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514053, 'NS56', 'NL32-05', NULL, 'FILISUR', 'Filisur', 'Filisur', '0101000020E61000001789BFDCDD5D234087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514054, 'NT01', 'NL32-02', NULL, 'FILZBACH', 'Filzbach', 'Filzbach', '0101000020E61000008210DABCBB3B2240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514059, 'MS11', 'NL32-04', NULL, 'FINDELNBEISTALDENREID', 'Findeln bei Staldenreid', 'Findeln bei Staldenreid', '0101000020E61000003854E7ACAAAA1F409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514060, 'LS40', 'NL32-04', NULL, 'FINHAUT', 'Finhaut', 'Finhaut', '0101000020E61000006B871AE0DDDD1B40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514064, 'LR69', 'NL32-04', NULL, 'FIONNAY', 'Fionnay', 'Fionnay', '0101000020E61000003333333333331D4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514066, 'MT94', 'NL32-02', NULL, 'FISCHENTHAL', 'Fischenthal', 'Fischenthal', '0101000020E61000001CAA735655D52140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514067, 'MT95', 'NL32-02', NULL, 'FISCHINGEN', 'Fischingen', 'Fischingen', '0101000020E6100000B5430DF0EEEE214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514068, 'MT67', 'NL32-02', NULL, 'FLAACH', 'Flaach', 'Flaach', '0101000020E61000003333333333332140791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514069, 'LS79', 'NL32-04', NULL, 'FLAMATT', 'Flamatt', 'Flamatt', '0101000020E61000003333333333331D40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514070, 'NT30', 'NL32-02', NULL, 'FLASCH', 'Fläsch', 'Flasch', '0101000020E61000004FDDA6898808234054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514071, 'NT15', 'NL32-02', NULL, 'FLAWIL', 'Flawil', 'Flawil', '0101000020E61000001789BFDCDD5D224087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514074, 'NS37', 'NL32-05', NULL, 'FLERDEN', 'Flerden', 'Flerden', '0101000020E6100000CDCCCCCCCCCC22409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514076, 'LS19', 'NL32-04', NULL, 'FLEURIER', 'Fleurier', 'Fleurier', '0101000020E6100000C8AB185355551A403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514077, 'NS28', 'NL32-05', NULL, 'FLIMS', 'Flims', 'Flims', '0101000020E61000004BBCF20F11912240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514081, 'NS17', 'NL32-05', NULL, 'FLOND', 'Flond', 'Flond', '0101000020E6100000CDCCCCCCCC4C224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514084, 'MS49', 'NL32-05', NULL, 'FLUELI', 'Flüeli', 'Flueli', '0101000020E61000004FDDA68988882040218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514085, 'MS79', 'NL32-05', NULL, 'FLUELN', 'Flüeln', 'Flueln', '0101000020E61000008210DABCBB3B21403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514087, 'LS93', 'NL32-04', NULL, 'FLUHALP', 'Fluhalp', 'Fluhalp', '0101000020E61000003854E7ACAAAA1E403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514090, 'MS29', 'NL32-05', NULL, 'FLUHLI', 'Flühli', 'Fluhli', '0101000020E61000000000000000002040DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514092, 'NT21', 'NL32-02', NULL, 'FLUMS', 'Flums', 'Flums', '0101000020E61000003333333333B32240791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514093, 'MT78', 'NL32-02', NULL, 'FLURLINGEN', 'Flurlingen', 'Flurlingen', '0101000020E61000007EEF25434444214046E22F7777D74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514095, 'LT31', 'NL32-01', NULL, 'FONTAINEMELON', 'Fontainemelon', 'Fontainemelon', '0101000020E6100000FCDE4B8688881B406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514096, 'MS65', 'NL32-05', NULL, 'FONTANA', 'Fontana', 'Fontana', '0101000020E6100000E97640232222214054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514097, 'NS98', 'NL32-06', NULL, 'FONTANA', 'Fontana', 'Fontana', '0101000020E61000004FDDA6898888244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514098, 'LT55', 'NL32-01', NULL, 'FONTENAIS', 'Fontenais', 'Fontenais', '0101000020E6100000C8AB185355551C403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514101, 'LS35', 'NL32-04', NULL, 'FOREL', 'Forel', 'Forel', '0101000020E6100000D1ED804644441B406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514102, 'LS37', 'NL32-04', NULL, 'FOREL', 'Forel', 'Forel', '0101000020E6100000D1ED804644441B40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514103, 'MS82', 'NL32-05', NULL, 'FORNA', 'Forna', 'Forna', '0101000020E61000008210DABCBBBB21406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514104, 'MR89', 'NL32-08', NULL, 'FORNASETTE', 'Fornasette', 'Fornasette', '0101000020E61000004BBCF20F11912140ED5003BCBBFB4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514107, 'MS63', 'NL32-05', NULL, 'FOROGLIO', 'Foroglio', 'Foroglio', '0101000020E61000009A99999999192140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514108, 'KS83', 'NL32-04', NULL, 'FOUNEX', 'Founex', 'Founex', '0101000020E6100000CDCCCCCCCCCC1840791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514113, 'LT60', 'NL32-04', NULL, 'FRASCHELS', 'Fräschels', 'Fraschels', '0101000020E61000006B871AE0DDDD1C40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514114, 'MS83', 'NL32-05', NULL, 'FRASCO', 'Frasco', 'Frasco', '0101000020E61000009A99999999992140791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514115, 'LT81', 'NL32-01', NULL, 'FRAUBRUNNEN', 'Fraubrunnen', 'Fraubrunnen', '0101000020E61000009EBA4D1311111E40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514116, 'MT96', 'NL32-02', 3, 'FRAUENFELD', 'Frauenfeld', 'Frauenfeld', '0101000020E6100000CDCCCCCCCCCC21406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514117, 'LT70', 'NL32-04', NULL, 'FRAUENKAPPELEN', 'Frauenkappelen', 'Frauenkappelen', '0101000020E6100000C8AB185355551D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514118, 'NS57', 'NL32-05', NULL, 'FRAUENKIRCH', 'Frauenkirch', 'Frauenkirch', '0101000020E61000004BBCF20F119123400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514124, 'MS43', 'NL32-05', NULL, 'FREICHE', 'Freiche', 'Freiche', '0101000020E61000000000000000802040DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514125, 'LT96', 'NL32-01', NULL, 'FREIDORF', 'Freidorf', 'Freidorf', '0101000020E6100000FCDE4B8688881E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514126, 'MT82', 'NL32-02', NULL, 'FREIENBACH', 'Freienbach', 'Freienbach', '0101000020E610000000000000008021409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514127, 'LS52', 'NL32-04', NULL, 'FRENIERES', 'Frenières', 'Frenieres', '0101000020E6100000D1ED804644441C4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514128, 'MT06', 'NL32-01', NULL, 'FRENKENDORF', 'Frenkendorf', 'Frenkendorf', '0101000020E61000006B871AE0DDDD1E400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514130, 'LS58', 'NL32-04', 3, 'FRIBOURG', 'Fribourg', 'Fribourg', '0101000020E61000009A99999999991C406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514134, 'MT26', 'NL32-02', NULL, 'FRICK', 'Frick', 'Frick', '0101000020E61000004FDDA689880820400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514135, 'MT04', 'NL32-01', NULL, 'FRIEDAU', 'Friedau', 'Friedau', '0101000020E61000003333333333331F40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514136, 'LT60', 'NL32-04', NULL, 'FRIESWIL', 'Frieswil', 'Frieswil', '0101000020E61000009EBA4D1311111D40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514137, 'MS83', 'NL32-05', NULL, 'FRODA', 'Froda', 'Froda', '0101000020E61000004FDDA68988882140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514138, 'MS64', 'NL32-05', NULL, 'FRODA', 'Froda', 'Froda', '0101000020E6100000E4558CA9AA2A21409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514140, 'LS26', 'NL32-04', NULL, 'FROIDEVILLE', 'Froideville', 'Froideville', '0101000020E61000002F127FB9BBBB1A40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514142, 'LS45', 'NL32-04', NULL, 'FRUENCE', 'Fruence', 'Fruence', '0101000020E61000003854E7ACAAAA1B4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514143, 'NS05', 'NL32-05', NULL, 'FRUNT', 'Frunt', 'Frunt', '0101000020E61000008210DABCBB3B2240791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514144, 'LS95', 'NL32-04', NULL, 'FRUTIGEN', 'Frutigen', 'Frutigen', '0101000020E61000009A99999999991E40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514145, 'MS48', 'NL32-05', NULL, 'FRUTT', 'Frutt', 'Frutt', '0101000020E61000004FDDA6898888204013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514146, 'LS84', 'NL32-04', NULL, 'FUHRE', 'Fuhre', 'Fuhre', '0101000020E6100000D1ED804644441E40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514147, 'PS06', 'NL32-06', NULL, 'FULDERA', 'Fuldera', 'Fuldera', '0101000020E61000008210DABCBBBB2440218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514148, 'MT13', 'NL32-01', NULL, 'FULENBACH', 'Fulenbach', 'Fulenbach', '0101000020E6100000C8AB185355551F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514149, 'MT37', 'NL32-02', NULL, 'FULL', 'Full', 'Full', '0101000020E61000006666666666662040791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514150, 'MT06', 'NL32-01', NULL, 'FULLINSDORF', 'Füllinsdorf', 'Fullinsdorf', '0101000020E61000000000000000001F400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514151, 'LS51', 'NL32-04', NULL, 'FULLY', 'Fully', 'Fully', '0101000020E61000006666666666661C40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514160, 'NT30', 'NL32-05', NULL, 'FURKELS', 'Furkels', 'Furkels', '0101000020E61000000000000000002340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514161, 'NS59', 'NL32-05', NULL, 'FURNA', 'Furna', 'Furna', '0101000020E61000001CAA73565555234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514163, 'NS37', 'NL32-05', NULL, 'FURSTENAUBRUCK', 'Fürstenaubruck', 'Furstenaubruck', '0101000020E61000006666666666E62240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514164, 'NS17', 'NL32-05', NULL, 'FURTH', 'Furth', 'Furth', '0101000020E61000001789BFDCDD5D22409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514165, 'MS74', 'NL32-05', NULL, 'FUSIO', 'Fusio', 'Fusio', '0101000020E6100000CDCCCCCCCC4C214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514167, 'MT68', 'NL32-02', NULL, 'GACHLINGEN', 'Gächlingen', 'Gachlingen', '0101000020E61000000000000000002140ED5003BCBBDB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514168, 'MT86', 'NL32-02', NULL, 'GACHNANG', 'Gachnang', 'Gachnang', '0101000020E61000003333333333B3214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514169, 'MS57', 'NL32-05', NULL, 'GADMEN', 'Gadmen', 'Gadmen', '0101000020E61000003333333333B32040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514170, 'NS67', 'NL32-05', NULL, 'GADMEN', 'Gadmen', 'Gadmen', '0101000020E6100000CDCCCCCCCCCC23400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514173, 'NT20', 'NL32-05', NULL, 'GAFARRA', 'Gafarra', 'Gafarra', '0101000020E61000008210DABCBBBB2240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514174, 'NT60', 'NL32-05', NULL, 'GAFIEN', 'Gafien', 'Gafien', '0101000020E61000003333333333B32340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514175, 'NT34', 'NL32-02', NULL, 'GAIS', 'Gais', 'Gais', '0101000020E61000006666666666E62240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514178, 'MS11', 'NL32-04', NULL, 'GALGERN', 'Galgern', 'Galgern', '0101000020E6100000FCDE4B8688881F4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514183, 'LS93', 'NL32-04', NULL, 'GALM', 'Galm', 'Galm', '0101000020E61000002F127FB9BBBB1E40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514185, 'LT50', 'NL32-04', NULL, 'GALMIZ', 'Galmiz', 'Galmiz', '0101000020E61000009A99999999991C409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514186, 'LT51', 'NL32-01', NULL, 'GALS', 'Gals', 'Gals', '0101000020E61000003333333333331C4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514187, 'MS03', 'NL32-04', NULL, 'GAMPEL', 'Gampel', 'Gampel', '0101000020E61000006245B2ECEEEE1E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514188, 'LT50', 'NL32-01', NULL, 'GAMPELEN', 'Gampelen', 'Gampelen', '0101000020E61000003333333333331C4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514189, 'NT32', 'NL32-02', NULL, 'GAMS', 'Gams', 'Gams', '0101000020E61000001789BFDCDDDD22409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514190, 'MS12', 'NL32-04', NULL, 'GAMSEN', 'Gamsen', 'Gamsen', '0101000020E6100000CDCCCCCCCCCC1F406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514191, 'NR09', 'NL32-05', NULL, 'GANDRIA', 'Gandria', 'Gandria', '0101000020E610000000000000000022400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514193, 'LT83', 'NL32-01', NULL, 'GANSBRUNNEN', 'Gänsbrunnen', 'Gansbrunnen', '0101000020E61000006B871AE0DDDD1D400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514194, 'NT04', 'NL32-02', NULL, 'GANTERSCHWIL', 'Ganterschwil', 'Ganterschwil', '0101000020E6100000E4558CA9AA2A2240DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514208, 'MT45', 'NL32-02', NULL, 'GEBENSTORF', 'Gebenstorf', 'Gebenstorf', '0101000020E6100000B122597677772040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514209, 'MT42', 'NL32-02', NULL, 'GELFINGEN', 'Gelfingen', 'Gelfingen', '0101000020E6100000000000000080204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514212, 'MT15', 'NL32-01', NULL, 'GELTERKINDEN', 'Gelterkinden', 'Gelterkinden', '0101000020E61000006666666666661F40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514216, 'LS93', 'NL32-04', NULL, 'GEMMIPASS', 'Gemmipass', 'Gemmipass', '0101000020E61000000421B47977771E403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514218, 'LT95', 'NL32-01', NULL, 'GEMPEN', 'Gempen', 'Gempen', '0101000020E61000009A99999999991E40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514223, 'MR97', 'NL32-08', NULL, 'GENESTRERIO', 'Genestrerio', 'Genestrerio', '0101000020E61000006666666666E62140CDCCCCCCCCEC4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514231, 'KS82', 'NL32-04', 1, 'GENEVE', 'Genève', 'Geneve', '0101000020E61000003854E7ACAAAA18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514243, 'KS84', 'NL32-04', NULL, 'GENOLIER', 'Genolier', 'Genolier', '0101000020E6100000CDCCCCCCCCCC184046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514248, 'MS47', 'NL32-05', NULL, 'GENTHALHUTTEN', 'Genthalhütten', 'Genthalhutten', '0101000020E61000004BBCF20F11912040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514250, 'LS79', 'NL32-04', NULL, 'GERETSRIED', 'Geretsried', 'Geretsried', '0101000020E6100000C8AB185355551D40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514253, 'LT80', 'NL32-04', NULL, 'GERISTEIN', 'Geristein', 'Geristein', '0101000020E61000009EBA4D1311111E40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514254, 'LT92', 'NL32-01', NULL, 'GERLAFINGEN', 'Gerlafingen', 'Gerlafingen', '0101000020E6100000D1ED804644441E4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514256, 'MT86', 'NL32-02', NULL, 'GERLIKON', 'Gerlikon', 'Gerlikon', '0101000020E61000008210DABCBBBB214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514257, 'MT41', 'NL32-02', NULL, 'GERLISWIL', 'Gerliswil', 'Gerliswil', '0101000020E61000004FDDA68988882040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514258, 'MS80', 'NL32-05', NULL, 'GERRA', 'Gerra', 'Gerra', '0101000020E61000004BBCF20F11912140218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514259, 'MS82', 'NL32-05', NULL, 'GERRA', 'Gerra', 'Gerra', '0101000020E61000009A99999999992140BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514261, 'MT60', 'NL32-05', NULL, 'GERSAU', 'Gersau', 'Gersau', '0101000020E61000004BBCF20F11112140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514262, 'MS58', 'NL32-05', NULL, 'GERSCHNIALP', 'Gerschnialp', 'Gerschnialp', '0101000020E61000001CAA735655D52040BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514264, 'LS88', 'NL32-04', NULL, 'GERZENSEE', 'Gerzensee', 'Gerzensee', '0101000020E61000003333333333331E40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514265, 'MS44', 'NL32-05', NULL, 'GESCHINEN', 'Geschinen', 'Geschinen', '0101000020E61000004BBCF20F11912040AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514266, 'MT22', 'NL32-01', NULL, 'GETTNAU', 'Gettnau', 'Gettnau', '0101000020E61000006B871AE0DDDD1F40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514267, 'MT32', 'NL32-02', NULL, 'GEUENSEE', 'Geuensee', 'Geuensee', '0101000020E610000033333333333320409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514268, 'MS64', 'NL32-05', NULL, 'GHEIBA', 'Gheiba', 'Gheiba', '0101000020E6100000333333333333214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514270, 'MT93', 'NL32-02', NULL, 'GIBSWIL', 'Gibswil', 'Gibswil', '0101000020E61000001CAA735655D521406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514271, 'MS27', 'NL32-05', NULL, 'GIDISDORF', 'Gidisdorf', 'Gidisdorf', '0101000020E61000004BBCF20F111120409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514272, 'LS74', 'NL32-04', NULL, 'GIEBEL', 'Giebel', 'Giebel', '0101000020E61000002F127FB9BBBB1D40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514273, 'MS27', 'NL32-05', NULL, 'GIESSBACH', 'Giessbach', 'Giessbach', '0101000020E61000004FDDA68988082040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514278, 'LS68', 'NL32-04', NULL, 'GIFFERS', 'Giffers', 'Giffers', '0101000020E61000006B871AE0DDDD1C4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514280, 'KS94', 'NL32-04', NULL, 'GILLY', 'Gilly', 'Gilly', '0101000020E610000033333333333319409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514281, 'KS95', 'NL32-04', NULL, 'GIMEL', 'Gimel', 'Gimel', '0101000020E6100000333333333333194054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514282, 'MS15', 'NL32-04', NULL, 'GIMMELWALD', 'Gimmelwald', 'Gimmelwald', '0101000020E6100000FCDE4B8688881F406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514286, 'KS84', 'NL32-04', NULL, 'GINGINS', 'Gingins', 'Gingins', '0101000020E61000002F127FB9BBBB18403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514287, 'MS93', 'NL32-05', NULL, 'GIORNICO', 'Giornico', 'Giornico', '0101000020E61000007EEF254344C42140DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514288, 'NS02', 'NL32-05', NULL, 'GIOVA', 'Giova', 'Giova', '0101000020E61000008210DABCBB3B224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514289, 'MT26', 'NL32-02', NULL, 'GIPFOBERFRICK', 'Gipf-Oberfrick', 'Gipf-Oberfrick', '0101000020E610000000000000000020400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514290, 'MT84', 'NL32-02', NULL, 'GIRENBAD', 'Girenbad', 'Girenbad', '0101000020E61000003333333333B32140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514291, 'MT85', 'NL32-02', NULL, 'GIRENBAD', 'Girenbad', 'Girenbad', '0101000020E61000003333333333B321409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514294, 'MS38', 'NL32-05', NULL, 'GISWIL', 'Giswil', 'Giswil', '0101000020E61000001789BFDCDD5D2040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514295, 'NS01', 'NL32-05', NULL, 'GIUBIASCO', 'Giubiasco', 'Giubiasco', '0101000020E6100000000000000000224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514296, 'MS72', 'NL32-05', NULL, 'GIUMAGLIO', 'Giumaglio', 'Giumaglio', '0101000020E61000001789BFDCDD5D214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514297, 'KS84', 'NL32-04', NULL, 'GIVRINS', 'Givrins', 'Givrins', '0101000020E6100000CDCCCCCCCCCC184087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514298, 'KS94', 'NL32-04', NULL, 'GLAND', 'Gland', 'Gland', '0101000020E61000009EBA4D131111194046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514302, 'NS57', 'NL32-05', NULL, 'GLARIS', 'Glaris', 'Glaris', '0101000020E61000004FDDA68988882340AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514307, 'NT00', 'NL32-02', 4, 'GLARUS', 'Glarus', 'Glarus', '0101000020E6100000E97640232222224013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514311, 'MT65', 'NL32-02', NULL, 'GLATTBRUGG', 'Glattbrugg', 'Glattbrugg', '0101000020E6100000E4558CA9AA2A214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514313, 'NT15', 'NL32-02', NULL, 'GLATTBURG', 'Glattburg', 'Glattburg', '0101000020E61000001789BFDCDD5D224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514314, 'NS25', 'NL32-05', NULL, 'GLATTENBERG', 'Glattenberg', 'Glattenberg', '0101000020E61000008210DABCBBBB2240791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514315, 'MT66', 'NL32-02', NULL, 'GLATTFELDEN', 'Glattfelden', 'Glattfelden', '0101000020E610000000000000000021406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514322, 'MS55', 'NL32-05', NULL, 'GLETSCH', 'Gletsch', 'Gletsch', '0101000020E61000003333333333B320406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514323, 'LS44', 'NL32-04', NULL, 'GLION', 'Glion', 'Glion', '0101000020E61000002F127FB9BBBB1B4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514324, 'MS22', 'NL32-04', NULL, 'GLIS', 'Glis', 'Glis', '0101000020E61000006B871AE0DDDD1F406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514327, 'LT64', 'NL32-01', NULL, 'GLOVELIER', 'Glovelier', 'Glovelier', '0101000020E6100000CDCCCCCCCCCC1C40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514329, 'MS20', 'NL32-05', NULL, 'GMEINALP', 'Gmeinalp', 'Gmeinalp', '0101000020E6100000E4558CA9AA2A2040218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514330, 'NS01', 'NL32-05', NULL, 'GNOSCA', 'Gnosca', 'Gnosca', '0101000020E61000004FDDA68988082240AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514331, 'NT35', 'NL32-02', NULL, 'GOLDACH', 'Goldach', 'Goldach', '0101000020E6100000B5430DF0EEEE2240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514333, 'MT61', 'NL32-02', NULL, 'GOLDAU', 'Goldau', 'Goldau', '0101000020E61000009A999999991921406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514334, 'MT93', 'NL32-02', NULL, 'GOLDINGEN', 'Goldingen', 'Goldingen', '0101000020E6100000B5430DF0EEEE214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514335, 'MS08', 'NL32-04', NULL, 'GOLDIWIL', 'Goldiwil', 'Goldiwil', '0101000020E6100000CDCCCCCCCCCC1E4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514336, 'MS17', 'NL32-04', NULL, 'GOLDSWIL', 'Goldswil', 'Goldswil', '0101000020E6100000FCDE4B8688881F409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514337, 'LS06', 'NL32-04', NULL, 'GOLLION', 'Gollion', 'Gollion', '0101000020E61000009EBA4D1311111A40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514338, 'NT02', 'NL32-02', NULL, 'GOMMISWALD', 'Gommiswald', 'Gommiswald', '0101000020E61000004FDDA68988082240ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514340, 'MT12', 'NL32-01', NULL, 'GONDISWIL', 'Gondiswil', 'Gondiswil', '0101000020E61000000421B47977771F40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514341, 'MS31', 'NL32-05', NULL, 'GONDO', 'Gondo', 'Gondo', '0101000020E61000007EEF2543444420409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514342, 'NT24', 'NL32-02', NULL, 'GONTEN', 'Gonten', 'Gonten', '0101000020E6100000E4558CA9AAAA2240791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514343, 'MT33', 'NL32-02', NULL, 'GONTENSCHWIL', 'Gontenschwil', 'Gontenschwil', '0101000020E61000007EEF25434444204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514344, 'MS03', 'NL32-04', NULL, 'GOPPENSTEIN', 'Goppenstein', 'Goppenstein', '0101000020E61000000000000000001F40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514345, 'MS23', 'NL32-05', NULL, 'GOPPISBERG', 'Goppisberg', 'Goppisberg', '0101000020E61000009A99999999192040DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514347, 'MS81', 'NL32-05', NULL, 'GORDOLA', 'Gordola', 'Gordola', '0101000020E61000003333333333B3214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514348, 'NS01', 'NL32-05', NULL, 'GORDUNO', 'Gorduno', 'Gorduno', '0101000020E61000004FDDA68988082240ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514349, 'LS29', 'NL32-04', NULL, 'GORGIER', 'Gorgier', 'Gorgier', '0101000020E61000009EBA4D1311111B403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514354, 'MS66', 'NL32-05', NULL, 'GOSCHENEN', 'Göschenen', 'Goschenen', '0101000020E6100000E4558CA9AA2A214087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514355, 'MS66', 'NL32-05', NULL, 'GOSCHENENALP', 'Göschenenalp', 'Goschenenalp', '0101000020E6100000B122597677F720403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514358, 'MT44', 'NL32-02', NULL, 'GOSLIKON', 'Göslikon', 'Goslikon', '0101000020E61000009A99999999992040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514359, 'MT83', 'NL32-02', NULL, 'GOSSAU', 'Gossau', 'Gossau', '0101000020E610000000000000008021406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514360, 'NT15', 'NL32-02', NULL, 'GOSSAU', 'Gossau', 'Gossau', '0101000020E6100000000000000080224087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514364, 'LS51', 'NL32-04', NULL, 'GOTTEFREY', 'Gottefrey', 'Gottefrey', '0101000020E61000003854E7ACAAAA1C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514368, 'NT17', 'NL32-02', NULL, 'GOTTLIEBEN', 'Gottlieben', 'Gottlieben', '0101000020E61000007EEF25434444224087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514370, 'LS16', 'NL32-04', NULL, 'GOUMOENSLAVILLE', 'Goumoens-la-Ville', 'Goumoens-la-Ville', '0101000020E61000006666666666661A403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514372, 'NT32', 'NL32-02', NULL, 'GRABS', 'Grabs', 'Grabs', '0101000020E61000001789BFDCDDDD22409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514373, 'MS01', 'NL32-04', NULL, 'GRACHEN', 'Grächen', 'Grachen', '0101000020E6100000C8AB185355551F4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514375, 'MS59', 'NL32-05', NULL, 'GRAFENORT', 'Grafenort', 'Grafenort', '0101000020E61000008210DABCBBBB2040218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514376, 'LS06', 'NL32-04', NULL, 'GRANCY', 'Grancy', 'Grancy', '0101000020E61000006B871AE0DDDD1940CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514380, 'LS49', 'NL32-04', NULL, 'GRANDCOUR', 'Grandcour', 'Grandcour', '0101000020E61000002F127FB9BBBB1B40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514386, 'LT44', 'NL32-01', NULL, 'GRANDFONTAINE', 'Grandfontaine', 'Grandfontaine', '0101000020E61000002F127FB9BBBB1B40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514396, 'LT41', 'NL32-01', NULL, 'GRANDSAVAGNIER', 'Grand-Savagnier', 'Grand-Savagnier', '0101000020E61000006B871AE0DDDD1B406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514397, 'LS48', 'NL32-04', NULL, 'GRANDSIVAZ', 'Grandsivaz', 'Grandsivaz', '0101000020E61000006245B2ECEEEE1B4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514398, 'LS18', 'NL32-04', NULL, 'GRANDSON', 'Grandson', 'Grandson', '0101000020E6100000FCDE4B8688881A40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514399, 'LT83', 'NL32-01', NULL, 'GRANDVAL', 'Grandval', 'Grandval', '0101000020E61000003854E7ACAAAA1D4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514400, 'LS55', 'NL32-04', NULL, 'GRANDVILLARD', 'Grandvillard', 'Grandvillard', '0101000020E61000006666666666661C406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514403, 'LS38', 'NL32-04', NULL, 'GRANGES', 'Granges', 'Granges', '0101000020E61000009A99999999991B4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514405, 'LS82', 'NL32-04', NULL, 'GRANGESPRESSION', 'Granges-près-Sion', 'Granges-pres-Sion', '0101000020E61000006B871AE0DDDD1D4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514406, 'MT34', 'NL32-02', NULL, 'GRANICHEN', 'Gränichen', 'Granichen', '0101000020E61000003333333333332040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514418, 'LS71', 'NL32-04', NULL, 'GRAVELON', 'Gravelon', 'Gravelon', '0101000020E61000002F127FB9BBBB1D40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514419, 'MR99', 'NL32-05', NULL, 'GRAVESANO', 'Gravesano', 'Gravesano', '0101000020E6100000CDCCCCCCCCCC21406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514430, 'MT74', 'NL32-02', NULL, 'GREIFENSEE', 'Greifensee', 'Greifensee', '0101000020E61000001CAA735655552140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514432, 'LT95', 'NL32-01', NULL, 'GRELLINGEN', 'Grellingen', 'Grellingen', '0101000020E6100000C8AB185355551E4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514433, 'LT72', 'NL32-01', NULL, 'GRENCHEN', 'Grenchen', 'Grenchen', '0101000020E6100000FCDE4B8688881D4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514434, 'MS23', 'NL32-05', NULL, 'GRENGIOLS', 'Grengiols', 'Grengiols', '0101000020E6100000E4558CA9AA2A2040218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514437, 'MT51', 'NL32-02', NULL, 'GREPPEN', 'Greppen', 'Greppen', '0101000020E61000001789BFDCDDDD20406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514439, 'MS71', 'NL32-05', NULL, 'GRESSO', 'Gresso', 'Gresso', '0101000020E61000008210DABCBB3B2140ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514440, 'MS84', 'NL32-05', NULL, 'GRIBBIO', 'Gribbio', 'Gribbio', '0101000020E6100000E976402322A22140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514446, 'MS05', 'NL32-04', NULL, 'GRIESALP', 'Griesalp', 'Griesalp', '0101000020E61000000000000000001F406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514451, 'LS91', 'NL32-04', NULL, 'GRIMENTZ', 'Grimentz', 'Grimentz', '0101000020E6100000C8AB185355551E4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514452, 'LS72', 'NL32-04', NULL, 'GRIMISUAT', 'Grimisuat', 'Grimisuat', '0101000020E6100000FCDE4B8688881D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514453, 'LS85', 'NL32-04', NULL, 'GRIMMIALP', 'Grimmialp', 'Grimmialp', '0101000020E61000006245B2ECEEEE1D40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514457, 'MS37', 'NL32-05', NULL, 'GRINDELFELD', 'Grindelfeld', 'Grindelfeld', '0101000020E61000007EEF2543444420409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514458, 'MS26', 'NL32-05', NULL, 'GRINDELWALD', 'Grindelwald', 'Grindelwald', '0101000020E61000009A99999999192040218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514459, 'PS09', 'NL32-06', NULL, 'GRIOSCH', 'Griosch', 'Griosch', '0101000020E6100000E4558CA9AAAA2440DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514463, 'LS75', 'NL32-04', NULL, 'GRODOEY', 'Grodoey', 'Grodoey', '0101000020E61000009A99999999991D4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514464, 'LS58', 'NL32-04', NULL, 'GROLLEY', 'Grolley', 'Grolley', '0101000020E6100000C8AB185355551C40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514466, 'LS82', 'NL32-04', NULL, 'GRONE', 'Grône', 'Grone', '0101000020E6100000CDCCCCCCCCCC1D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514467, 'NS12', 'NL32-05', NULL, 'GRONO', 'Grono', 'Grono', '0101000020E6100000CDCCCCCCCC4C22400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514468, 'LT71', 'NL32-01', NULL, 'GROSSAFFOLTERN', 'Grossaffoltern', 'Grossaffoltern', '0101000020E61000006666666666661D40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514469, 'NS67', 'NL32-05', NULL, 'GROSSALPEN', 'Grossalpen', 'Grossalpen', '0101000020E61000003333333333B32340ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514470, 'MT77', 'NL32-02', NULL, 'GROSSANDELFINGEN', 'Grossandelfingen', 'Grossandelfingen', '0101000020E61000001789BFDCDD5D2140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514480, 'NS98', 'NL32-06', NULL, 'GROSSFETAN', 'Gross-Fetan', 'Gross-Fetan', '0101000020E6100000B1225976777724406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514481, 'LS69', 'NL32-04', NULL, 'GROSSGURMELS', 'Gross Gurmels', 'Gross Gurmels', '0101000020E61000003854E7ACAAAA1C40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514482, 'LS99', 'NL32-04', NULL, 'GROSSHOCHSTETTEN', 'Gross Höchstetten', 'Gross Hochstetten', '0101000020E6100000FCDE4B8688881E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514491, 'MT22', 'NL32-02', NULL, 'GROSSWANGEN', 'Grosswangen', 'Grosswangen', '0101000020E61000009A99999999192040DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514495, 'LS91', 'NL32-04', NULL, 'GRUBEN', 'Gruben', 'Gruben', '0101000020E6100000CDCCCCCCCCCC1E409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514497, 'LS64', 'NL32-04', NULL, 'GRUND', 'Grund', 'Grund', '0101000020E61000009EBA4D1311111D409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514498, 'MS47', 'NL32-05', NULL, 'GRUND', 'Grund', 'Grund', '0101000020E61000000000000000802040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514499, 'LS88', 'NL32-04', NULL, 'GRUNDBACH', 'Grundbach', 'Grundbach', '0101000020E61000006245B2ECEEEE1D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514500, 'MT83', 'NL32-02', NULL, 'GRUNINGEN', 'Grüningen', 'Gruningen', '0101000020E6100000000000000080214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514501, 'NT40', 'NL32-05', NULL, 'GRUSCH', 'Grüsch', 'Grusch', '0101000020E61000007EEF254344442340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514504, 'LS56', 'NL32-04', NULL, 'GRUYERES', 'Gruyères', 'Gruyeres', '0101000020E6100000C8AB185355551C40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514505, 'LS52', 'NL32-04', NULL, 'GRYON', 'Gryon', 'Gryon', '0101000020E61000006666666666661C4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514506, 'LS64', 'NL32-04', NULL, 'GSTAAD', 'Gstaad', 'Gstaad', '0101000020E61000009578E51F22221D40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514508, 'LS63', 'NL32-04', NULL, 'GSTEIG', 'Gsteig', 'Gsteig', '0101000020E61000009EBA4D1311111D40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514509, 'MS16', 'NL32-04', NULL, 'GSTEIG', 'Gsteig', 'Gsteig', '0101000020E6100000FCDE4B8688881F4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514510, 'NS88', 'NL32-06', NULL, 'GUARDA', 'Guarda', 'Guarda', '0101000020E6100000CDCCCCCCCC4C244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514511, 'MT62', 'NL32-02', NULL, 'GUBEL', 'Gubel', 'Gubel', '0101000020E6100000E97640232222214087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514513, 'LS59', 'NL32-04', NULL, 'GUEVAUX', 'Guévaux', 'Guevaux', '0101000020E61000003333333333331C4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514515, 'LS78', 'NL32-04', NULL, 'GUGGISBERG', 'Guggisberg', 'Guggisberg', '0101000020E6100000C8AB185355551D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514520, 'NS13', 'NL32-05', NULL, 'GUMEGNA', 'Gumegna', 'Gumegna', '0101000020E61000000000000000802240218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514521, 'LT80', 'NL32-04', NULL, 'GUMLIGEN', 'Gümligen', 'Gumligen', '0101000020E61000000000000000001E40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514522, 'LS74', 'NL32-04', NULL, 'GUMMELI', 'Gummeli', 'Gummeli', '0101000020E61000009A99999999991D4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514523, 'LS69', 'NL32-04', NULL, 'GUMMENEN', 'Gümmenen', 'Gummenen', '0101000020E61000000000000000001D4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514527, 'MS07', 'NL32-04', NULL, 'GUNTEN', 'Gunten', 'Gunten', '0101000020E6100000CDCCCCCCCCCC1E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514529, 'MT14', 'NL32-01', NULL, 'GUNZGEN', 'Gunzgen', 'Gunzgen', '0101000020E6100000D1ED804644441F40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514530, 'MT32', 'NL32-02', NULL, 'GUNZWIL', 'Gunzwil', 'Gunzwil', '0101000020E61000001789BFDCDD5D2040ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514531, 'NS15', 'NL32-05', NULL, 'GURALETSCH', 'Guraletsch', 'Guraletsch', '0101000020E61000007EEF254344442240791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514534, 'LS88', 'NL32-04', NULL, 'GURNIGELBAD', 'Gurnigelbad', 'Gurnigelbad', '0101000020E6100000CDCCCCCCCCCC1D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514537, 'MS77', 'NL32-05', NULL, 'GURTNELLEN', 'Gurtnellen', 'Gurtnellen', '0101000020E61000007EEF2543444421400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514539, 'LS84', 'NL32-04', NULL, 'GUTSCH', 'Gütsch', 'Gutsch', '0101000020E6100000CDCCCCCCCCCC1D40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514540, 'MS46', 'NL32-05', NULL, 'GUTTANNEN', 'Guttannen', 'Guttannen', '0101000020E61000004BBCF20F1191204087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514541, 'NT27', 'NL32-02', NULL, 'GUTTINGEN', 'Güttingen', 'Guttingen', '0101000020E61000004BBCF20F11912240CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514542, 'LS97', 'NL32-04', NULL, 'GWATT', 'Gwatt', 'Gwatt', '0101000020E61000000421B47977771E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514546, 'MS17', 'NL32-04', NULL, 'HABKERN', 'Habkern', 'Habkern', '0101000020E61000006666666666661F40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514547, 'MT35', 'NL32-02', NULL, 'HABSBURG', 'Habsburg', 'Habsburg', '0101000020E61000001789BFDCDD5D2040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514549, 'MT96', 'NL32-02', NULL, 'HAGENBUCH', 'Hagenbuch', 'Hagenbuch', '0101000020E6100000CDCCCCCCCCCC214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514550, 'MT14', 'NL32-01', NULL, 'HAGENDORF', 'Hägendorf', 'Hagendorf', '0101000020E6100000C8AB185355551F40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514551, 'NT25', 'NL32-02', NULL, 'HAGGENSCHWIL', 'Häggenschwil', 'Haggenschwil', '0101000020E61000003333333333B32240AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514552, 'MT44', 'NL32-02', NULL, 'HAGGLINGEN', 'Hägglingen', 'Hagglingen', '0101000020E61000000000000000802040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514553, 'LT61', 'NL32-01', NULL, 'HAGNECK', 'Hagneck', 'Hagneck', '0101000020E61000002F127FB9BBBB1C40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514556, 'NS39', 'NL32-05', NULL, 'HALDENSTEIN', 'Haldenstein', 'Haldenstein', '0101000020E61000004FDDA68988082340DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514557, 'LS89', 'NL32-04', NULL, 'HALEN', 'Halen', 'Halen', '0101000020E61000006B871AE0DDDD1D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514558, 'MT58', 'NL32-02', NULL, 'HALLAU', 'Hallau', 'Hallau', '0101000020E6100000B5430DF0EEEE20409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514564, 'MS39', 'NL32-05', NULL, 'HALTEN', 'Halten', 'Halten', '0101000020E61000001CAA7356555520403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514565, 'MT43', 'NL32-02', NULL, 'HAMIKON', 'Hämikon', 'Hamikon', '0101000020E61000004BBCF20F11912040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514567, 'MS46', 'NL32-05', NULL, 'HANDEGG', 'Handegg', 'Handegg', '0101000020E61000009A99999999992040218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514568, 'MS11', 'NL32-04', NULL, 'HANNIGALP', 'Hannigalp', 'Hannigalp', '0101000020E61000000421B47977771F409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514572, 'MT20', 'NL32-05', NULL, 'HASLE', 'Hasle', 'Hasle', '0101000020E61000009A99999999192040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514573, 'LT90', 'NL32-01', NULL, 'HASLE', 'Hasle', 'Hasle', '0101000020E6100000FCDE4B8688881E4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514574, 'NT24', 'NL32-02', NULL, 'HASLEN', 'Haslen', 'Haslen', '0101000020E61000008210DABCBBBB2240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514578, 'LS96', 'NL32-04', NULL, 'HASLI', 'Hasli', 'Hasli', '0101000020E61000009A99999999991E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514580, 'NS09', 'NL32-05', NULL, 'HATZINGEN', 'Hätzingen', 'Hatzingen', '0101000020E61000004BBCF20F111122409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514581, 'LS80', 'NL32-04', NULL, 'HAUDERES', 'Haudères', 'Hauderes', '0101000020E61000009EBA4D1311111E40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514582, 'MT14', 'NL32-01', NULL, 'HAUENSTEIN', 'Hauenstein', 'Hauenstein', '0101000020E61000000421B47977771F40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514583, 'NT25', 'NL32-02', NULL, 'HAUPTWIL', 'Hauptwil', 'Hauptwil', '0101000020E61000004BBCF20F11912240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514584, 'MS37', 'NL32-05', NULL, 'HAUSEN', 'Hausen', 'Hausen', '0101000020E61000001CAA735655552040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514585, 'MT63', 'NL32-02', NULL, 'HAUSEN', 'Hausen', 'Hausen', '0101000020E61000004BBCF20F111121400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514587, 'LS57', 'NL32-04', NULL, 'HAUTERIVE', 'Hauterive', 'Hauterive', '0101000020E61000006666666666661C400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514589, 'LS56', 'NL32-04', NULL, 'HAUTEVILLE', 'Hauteville', 'Hauteville', '0101000020E61000000421B47977771C4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514591, 'NT44', 'NL32-02', NULL, 'HEERBRUGG', 'Heerbrugg', 'Heerbrugg', '0101000020E61000007EEF2543444423403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514593, 'MT86', 'NL32-02', NULL, 'HEGI', 'Hegi', 'Hegi', '0101000020E61000004FDDA689888821400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514594, 'MS09', 'NL32-04', NULL, 'HEIDBUHL', 'Heidbühl', 'Heidbuhl', '0101000020E61000003333333333331F40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514595, 'NT45', 'NL32-02', NULL, 'HEIDEN', 'Heiden', 'Heiden', '0101000020E61000004BBCF20F1111234046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514596, 'LS97', 'NL32-04', NULL, 'HEILIGENSCHWENDI', 'Heiligenschwendi', 'Heiligenschwendi', '0101000020E61000002F127FB9BBBB1E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514597, 'LS98', 'NL32-04', NULL, 'HEIMBERG', 'Heimberg', 'Heimberg', '0101000020E61000006666666666661E406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514598, 'MS08', 'NL32-04', NULL, 'HEIMENSCHWAND', 'Heimenschwand', 'Heimenschwand', '0101000020E6100000CDCCCCCCCCCC1E40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514599, 'LT91', 'NL32-01', NULL, 'HEIMISWIL', 'Heimiswil', 'Heimiswil', '0101000020E61000009A99999999991E406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514601, 'LS78', 'NL32-04', NULL, 'HEITENRIED', 'Heitenried', 'Heitenried', '0101000020E61000003333333333331D40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514602, 'MS89', 'NL32-05', NULL, 'HEITMANNSEGG', 'Heitmannsegg', 'Heitmannsegg', '0101000020E61000009A99999999992140218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514603, 'MT31', 'NL32-02', NULL, 'HELLBUHL', 'Hellbühl', 'Hellbuhl', '0101000020E61000006666666666662040BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514607, 'NT13', 'NL32-02', NULL, 'HEMBERG', 'Hemberg', 'Hemberg', '0101000020E61000001789BFDCDD5D22406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514608, 'MT88', 'NL32-02', NULL, 'HEMISHOFEN', 'Hemishofen', 'Hemishofen', '0101000020E6100000E4558CA9AAAA214046E22F7777D74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514610, 'MT68', 'NL32-02', NULL, 'HEMMENTHAL', 'Hemmenthal', 'Hemmenthal', '0101000020E61000009A99999999192140AC4896DDDDDD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514611, 'MT15', 'NL32-01', NULL, 'HEMMIKEN', 'Hemmiken', 'Hemmiken', '0101000020E61000000421B47977771F40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514612, 'NT05', 'NL32-02', NULL, 'HENAU', 'Henau', 'Henau', '0101000020E61000008210DABCBB3B22409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514613, 'MT44', 'NL32-02', NULL, 'HENDSCHIKEN', 'Hendschiken', 'Hendschiken', '0101000020E6100000B5430DF0EE6E2040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514615, 'MT76', 'NL32-02', NULL, 'HENGGART', 'Henggart', 'Henggart', '0101000020E61000001789BFDCDD5D21406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514616, 'LT93', 'NL32-01', NULL, 'HERBETSWIL', 'Herbetswil', 'Herbetswil', '0101000020E6100000C8AB185355551E406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514617, 'MT78', 'NL32-02', NULL, 'HERBLINGEN', 'Herblingen', 'Herblingen', '0101000020E61000001CAA735655552140ED5003BCBBDB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514619, 'MS01', 'NL32-04', NULL, 'HERBRIGGEN', 'Herbriggen', 'Herbriggen', '0101000020E61000003333333333331F403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514621, 'MT97', 'NL32-02', NULL, 'HERDERN', 'Herdern', 'Herdern', '0101000020E6100000CDCCCCCCCCCC2140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514622, 'LS71', 'NL32-04', NULL, 'HEREMENCE', 'Hérémence', 'Heremence', '0101000020E61000009A99999999991D4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514626, 'MS99', 'NL32-05', NULL, 'HERGERSBODEN', 'Hergersboden', 'Hergersboden', '0101000020E6100000CDCCCCCCCCCC2140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514627, 'MT40', 'NL32-05', NULL, 'HERGISWIL', 'Hergiswil', 'Hergiswil', '0101000020E6100000E976402322A22040AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514628, 'MT21', 'NL32-01', NULL, 'HERGISWIL', 'Hergiswil', 'Hergiswil', '0101000020E6100000CDCCCCCCCCCC1F40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514630, 'NT24', 'NL32-02', 3, 'HERISAU', 'Herisau', 'Herisau', '0101000020E61000004FDDA689888822403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514631, 'KS83', 'NL32-04', NULL, 'HERMANCE', 'Hermance', 'Hermance', '0101000020E61000006245B2ECEEEE18406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514633, 'MT44', 'NL32-02', NULL, 'HERMETSCHWIL', 'Hermetschwil', 'Hermetschwil', '0101000020E6100000E4558CA9AAAA2040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514634, 'LS88', 'NL32-04', NULL, 'HERMISWIL', 'Hermiswil', 'Hermiswil', '0101000020E61000006B871AE0DDDD1D40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514635, 'NT17', 'NL32-02', NULL, 'HERRENHOF', 'Herrenhof', 'Herrenhof', '0101000020E6100000B122597677772240791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514636, 'MT73', 'NL32-02', NULL, 'HERRLIBERG', 'Herrliberg', 'Herrliberg', '0101000020E61000008210DABCBB3B214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514637, 'MT50', 'NL32-02', NULL, 'HERTENSTEIN', 'Hertenstein', 'Hertenstein', '0101000020E6100000CDCCCCCCCCCC204013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514638, 'MT46', 'NL32-02', NULL, 'HERTENSTEIN', 'Hertenstein', 'Hertenstein', '0101000020E61000009A999999999920400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514639, 'MT25', 'NL32-02', NULL, 'HERZBERG', 'Herzberg', 'Herzberg', '0101000020E61000004BBCF20F1111204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514640, 'MT02', 'NL32-01', NULL, 'HERZOGENBUCHSEE', 'Herzogenbuchsee', 'Herzogenbuchsee', '0101000020E6100000CDCCCCCCCCCC1E4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514641, 'LT82', 'NL32-01', NULL, 'HESSIGKOFEN', 'Hessigkofen', 'Hessigkofen', '0101000020E61000006B871AE0DDDD1D403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514642, 'MT76', 'NL32-02', NULL, 'HETTLINGEN', 'Hettlingen', 'Hettlingen', '0101000020E610000066666666666621406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514643, 'MT42', 'NL32-02', NULL, 'HILDISRIEDEN', 'Hildisrieden', 'Hildisrieden', '0101000020E6100000B1225976777720403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514644, 'LS97', 'NL32-04', NULL, 'HILTERFINGEN', 'Hilterfingen', 'Hilterfingen', '0101000020E61000009A99999999991E40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514645, 'LT95', 'NL32-01', NULL, 'HIMMELRIED', 'Himmelried', 'Himmelried', '0101000020E6100000C8AB185355551E4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514646, 'LT80', 'NL32-01', NULL, 'HINDELBANK', 'Hindelbank', 'Hindelbank', '0101000020E61000009578E51F22221E4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514647, 'NT10', 'NL32-05', NULL, 'HINTERDORF', 'Hinterdorf', 'Hinterdorf', '0101000020E61000001CAA735655552240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514648, 'LS63', 'NL32-04', NULL, 'HINTEREWINDSPILLEN', 'Hintere-Windspillen', 'Hintere-Windspillen', '0101000020E61000003333333333331D403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514650, 'MS58', 'NL32-05', NULL, 'HINTERHORBIS', 'Hinter Horbis', 'Hinter Horbis', '0101000020E61000001789BFDCDDDD2040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514651, 'LT70', 'NL32-04', NULL, 'HINTERKAPPELEN', 'Hinterkappelen', 'Hinterkappelen', '0101000020E6100000FCDE4B8688881D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514652, 'NT45', 'NL32-02', NULL, 'HINTERLOCHEN', 'Hinterlochen', 'Hinterlochen', '0101000020E61000009A999999991923409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514653, 'MS09', 'NL32-04', NULL, 'HINTERNETSCHBUHL', 'Hinter Netschbühl', 'Hinter Netschbuhl', '0101000020E61000009EBA4D1311111F40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514654, 'NS15', 'NL32-05', NULL, 'HINTERRHEIN', 'Hinterrhein', 'Hinterrhein', '0101000020E6100000666666666666224013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514656, 'LS63', 'NL32-04', NULL, 'HINTERWALLEGG', 'Hinter Wallegg', 'Hinter Wallegg', '0101000020E61000000000000000001D403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514658, 'MT83', 'NL32-02', NULL, 'HINWIL', 'Hinwil', 'Hinwil', '0101000020E6100000E4558CA9AAAA21406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514659, 'LS78', 'NL32-04', NULL, 'HIRSCHHORN', 'Hirschhorn', 'Hirschhorn', '0101000020E6100000FCDE4B8688881D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514660, 'MT62', 'NL32-02', NULL, 'HIRZEL', 'Hirzel', 'Hirzel', '0101000020E61000003333333333332140ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514661, 'MT84', 'NL32-02', NULL, 'HITTNAU', 'Hittnau', 'Hittnau', '0101000020E6100000E4558CA9AAAA2140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514662, 'MT43', 'NL32-02', NULL, 'HITZKIRCH', 'Hitzkirch', 'Hitzkirch', '0101000020E61000004FDDA68988882040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514665, 'MT42', 'NL32-02', NULL, 'HOCHDORF', 'Hochdorf', 'Hochdorf', '0101000020E61000004BBCF20F1191204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514667, 'PS19', 'NL32-06', NULL, 'HOCHFINSTERMUNZ', 'Hochfinstermünz', 'Hochfinstermunz', '0101000020E6100000000000000000254046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514668, 'LT95', 'NL32-01', NULL, 'HOCHWALD', 'Hochwald', 'Hochwald', '0101000020E6100000FCDE4B8688881E409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514670, 'NT35', 'NL32-02', NULL, 'HOF', 'Hof', 'Hof', '0101000020E61000000000000000002340ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514671, 'MT79', 'NL32-02', NULL, 'HOFEN', 'Hofen', 'Hofen', '0101000020E61000001CAA73565555214013AFFC4344E44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514672, 'LT85', 'NL32-01', NULL, 'HOFSTETTEN', 'Hofstetten', 'Hofstetten', '0101000020E61000009EBA4D1311111E40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514673, 'MT85', 'NL32-02', NULL, 'HOFSTETTEN', 'Hofstetten', 'Hofstetten', '0101000020E61000003333333333B32140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514675, 'NS34', 'NL32-05', NULL, 'HOHENHAUS', 'Hohenhaus', 'Hohenhaus', '0101000020E6100000B5430DF0EEEE22409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514676, 'MT42', 'NL32-02', NULL, 'HOHENRAIN', 'Hohenrain', 'Hohenrain', '0101000020E6100000E976402322A2204046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514684, 'MS37', 'NL32-05', NULL, 'HOHFLUH', 'Hohfluh', 'Hohfluh', '0101000020E61000001789BFDCDD5D20400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514687, 'MT04', 'NL32-01', NULL, 'HOLDERBANK', 'Holderbank', 'Holderbank', '0101000020E61000000000000000001F40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514688, 'MS11', 'NL32-04', NULL, 'HOLLERBIEL', 'Hollerbiel', 'Hollerbiel', '0101000020E61000002F127FB9BBBB1F403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514690, 'MT05', 'NL32-01', NULL, 'HOLSTEIN', 'Hölstein', 'Holstein', '0101000020E61000009EBA4D1311111F4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514691, 'MS58', 'NL32-05', NULL, 'HOLZHOSTATT', 'Holzhostatt', 'Holzhostatt', '0101000020E61000001789BFDCDDDD20406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514692, 'MT83', 'NL32-02', NULL, 'HOMBRECHTIKON', 'Hombrechtikon', 'Hombrechtikon', '0101000020E61000004FDDA689888821400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514693, 'NT07', 'NL32-02', NULL, 'HOMBURG', 'Homburg', 'Homburg', '0101000020E61000000000000000002240DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514694, 'LS96', 'NL32-04', NULL, 'HONDRICH', 'Hondrich', 'Hondrich', '0101000020E61000003854E7ACAAAA1E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514695, 'MT64', 'NL32-02', NULL, 'HONGG', 'Höngg', 'Hongg', '0101000020E610000000000000000021403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514696, 'MT63', 'NL32-02', NULL, 'HORGEN', 'Horgen', 'Horgen', '0101000020E6100000E4558CA9AA2A214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514697, 'MT97', 'NL32-02', NULL, 'HORHAUSEN', 'Hörhausen', 'Horhausen', '0101000020E6100000B5430DF0EEEE2140DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514698, 'NT35', 'NL32-02', NULL, 'HORN', 'Horn', 'Horn', '0101000020E6100000B5430DF0EEEE2240AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514699, 'LS74', 'NL32-04', NULL, 'HORNKESSEL', 'Hornkessel', 'Hornkessel', '0101000020E6100000D1ED804644441D40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514702, 'MT36', 'NL32-02', NULL, 'HORNUSSEN', 'Hornussen', 'Hornussen', '0101000020E6100000E4558CA9AA2A20400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514703, 'MT40', 'NL32-02', NULL, 'HORW', 'Horw', 'Horw', '0101000020E61000009A9999999999204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514705, 'MS66', 'NL32-05', NULL, 'HOSPENTHAL', 'Hospenthal', 'Hospenthal', '0101000020E6100000E976402322222140218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514706, 'LS42', 'NL32-04', NULL, 'HUEMOZ', 'Huémoz', 'Huemoz', '0101000020E61000009EBA4D1311111C4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514707, 'MT94', 'NL32-02', NULL, 'HULFTEGG', 'Hulftegg', 'Hulftegg', '0101000020E6100000B5430DF0EEEE2140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514708, 'MS69', 'NL32-05', NULL, 'HUNDWALD', 'Hundwald', 'Hundwald', '0101000020E61000004BBCF20F11112140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514709, 'NT24', 'NL32-02', NULL, 'HUNDWIL', 'Hundwil', 'Hundwil', '0101000020E6100000E976402322A22240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514710, 'MT52', 'NL32-02', NULL, 'HUNENBERG', 'Hünenberg', 'Hunenberg', '0101000020E61000001CAA735655D5204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514711, 'LS97', 'NL32-04', NULL, 'HUNIBACH', 'Hünibach', 'Hunibach', '0101000020E61000009A99999999991E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514713, 'MT67', 'NL32-02', NULL, 'HUNTWANGEN', 'Hüntwangen', 'Huntwangen', '0101000020E6100000B122597677F72040CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514714, 'LS89', 'NL32-04', NULL, 'HUNZIGENBRUGG', 'Hunzigenbrügg', 'Hunzigenbrugg', '0101000020E61000009578E51F22221E40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514716, 'MT82', 'NL32-02', NULL, 'HURDEN', 'Hurden', 'Hurden', '0101000020E61000009A99999999992140ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514719, 'MS67', 'NL32-05', NULL, 'HUSEN', 'Husen', 'Husen', '0101000020E6100000E4558CA9AA2A2140ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514722, 'LT10', 'NL32-04', NULL, 'HUTTENBERG', 'Hüttenberg', 'Huttenberg', '0101000020E61000009578E51F22221A4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514723, 'MT96', 'NL32-02', NULL, 'HUTTLINGEN', 'Hüttlingen', 'Huttlingen', '0101000020E6100000B122597677F72140BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514724, 'MT11', 'NL32-01', NULL, 'HUTTWIL', 'Huttwil', 'Huttwil', '0101000020E61000006666666666661F40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514725, 'MT87', 'NL32-02', NULL, 'HUTTWILEN', 'Hüttwilen', 'Huttwilen', '0101000020E61000008210DABCBBBB2140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514726, 'MT70', 'NL32-02', NULL, 'IBACH', 'Ibach', 'Ibach', '0101000020E6100000CDCCCCCCCC4C214054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514727, 'LS73', 'NL32-04', NULL, 'IFFIGEN', 'Iffigen', 'Iffigen', '0101000020E61000002F127FB9BBBB1D403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514729, 'NS49', 'NL32-05', NULL, 'IGIS', 'Igis', 'Igis', '0101000020E6100000E4558CA9AA2A23409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514732, 'NS17', 'NL32-05', NULL, 'ILANZ', 'Ilanz', 'Ilanz', '0101000020E6100000666666666666224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514734, 'NS96', 'NL32-06', NULL, 'ILFUORN', 'Il Fuorn', 'Il Fuorn', '0101000020E6100000B5430DF0EE6E244087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514735, 'MT70', 'NL32-05', NULL, 'ILLGAU', 'Illgau', 'Illgau', '0101000020E6100000B122597677772140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514737, 'LT70', 'NL32-04', NULL, 'ILLISWIL', 'Illiswil', 'Illiswil', '0101000020E6100000C8AB185355551D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514738, 'MT74', 'NL32-02', NULL, 'ILLNAU', 'Illnau', 'Illnau', '0101000020E6100000B5430DF0EE6E21403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514741, 'LS66', 'NL32-04', NULL, 'IMFANG', 'Im Fang', 'Im Fang', '0101000020E61000000000000000001D40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514743, 'LS77', 'NL32-04', NULL, 'IMKLOSTER', 'Im Kloster', 'Im Kloster', '0101000020E61000003333333333331D40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514745, 'MT51', 'NL32-02', NULL, 'IMMENSEE', 'Immensee', 'Immensee', '0101000020E6100000B5430DF0EEEE2040CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514746, 'MS80', 'NL32-05', NULL, 'INDEMINI', 'Indemini', 'Indemini', '0101000020E6100000E976402322A22140CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514747, 'LS93', 'NL32-04', NULL, 'INDEN', 'Inden', 'Inden', '0101000020E61000000421B47977771E40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514749, 'MS65', 'NL32-05', NULL, 'INDERSCHWEIG', 'In der Schweig', 'In der Schweig', '0101000020E61000000000000000002140791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514750, 'MT70', 'NL32-02', NULL, 'INGENBOHL', 'Ingenbohl', 'Ingenbohl', '0101000020E61000008210DABCBB3B21400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514752, 'NS26', 'NL32-05', NULL, 'INNERCAMANA', 'Innercamana', 'Innercamana', '0101000020E61000004BBCF20F1191224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514753, 'NS35', 'NL32-05', NULL, 'INNERFERRERA', 'Innerferrera', 'Innerferrera', '0101000020E61000001789BFDCDDDD224054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514755, 'NS27', 'NL32-05', NULL, 'INNERHOF', 'Inner Hof', 'Inner Hof', '0101000020E61000008210DABCBBBB224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514756, 'NS48', 'NL32-05', NULL, 'INNERPRADEN', 'Inner Praden', 'Inner Praden', '0101000020E6100000E4558CA9AA2A2340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514759, 'MT91', 'NL32-02', NULL, 'INNERTHAL', 'Innerthal', 'Innerthal', '0101000020E61000001CAA735655D52140CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514760, 'MS47', 'NL32-05', NULL, 'INNERTKIRCHEN', 'Innertkirchen', 'Innertkirchen', '0101000020E6100000B5430DF0EE6E20409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514762, 'LT50', 'NL32-01', NULL, 'INS', 'Ins', 'Ins', '0101000020E61000006666666666661C4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514764, 'MS17', 'NL32-04', NULL, 'INTERLAKEN', 'Interlaken', 'Interlaken', '0101000020E61000006666666666661F4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514765, 'MS71', 'NL32-05', NULL, 'INTRAGNA', 'Intragna', 'Intragna', '0101000020E6100000666666666666214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514767, 'MS77', 'NL32-05', NULL, 'INTSCHI', 'Intschi', 'Intschi', '0101000020E61000001CAA73565555214054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514768, 'MT41', 'NL32-02', NULL, 'INWIL', 'Inwil', 'Inwil', '0101000020E6100000E4558CA9AAAA2040218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514769, 'MS92', 'NL32-05', NULL, 'IRAGNA', 'Iragna', 'Iragna', '0101000020E6100000B5430DF0EEEE2140BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514771, 'MT84', 'NL32-02', NULL, 'IRGENHAUSEN', 'Irgenhausen', 'Irgenhausen', '0101000020E61000009A99999999992140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514773, 'MS17', 'NL32-04', NULL, 'ISELTWALD', 'Iseltwald', 'Iseltwald', '0101000020E6100000CDCCCCCCCCCC1F409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514774, 'MS16', 'NL32-04', NULL, 'ISENFLUH', 'Isenfluh', 'Isenfluh', '0101000020E6100000FCDE4B8688881F40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514776, 'MS69', 'NL32-05', NULL, 'ISENTHAL', 'Isenthal', 'Isenthal', '0101000020E61000009A9999999919214087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514777, 'MR89', 'NL32-05', NULL, 'ISEO', 'Iseo', 'Iseo', '0101000020E61000008210DABCBBBB21400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514778, 'LS61', 'NL32-04', NULL, 'ISERABLES', 'Iserables', 'Iserables', '0101000020E61000000000000000001D403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514779, 'MS69', 'NL32-05', NULL, 'ISLETEN', 'Isleten', 'Isleten', '0101000020E6100000E4558CA9AA2A214087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514780, 'MT86', 'NL32-02', NULL, 'ISLIKON', 'Islikon', 'Islikon', '0101000020E61000003333333333B321406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514781, 'NS54', 'NL32-05', NULL, 'ISOLA', 'Isola', 'Isola', '0101000020E6100000B12259767777234087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514782, 'MS90', 'NL32-05', NULL, 'ISONE', 'Isone', 'Isone', '0101000020E6100000B122597677F72140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514784, 'LR59', 'NL32-04', NULL, 'ISSERT', 'Issert', 'Issert', '0101000020E61000000421B47977771C400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514785, 'LS82', 'NL32-04', NULL, 'ITRAVERS', 'Itravers', 'Itravers', '0101000020E61000006245B2ECEEEE1D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514787, 'MT26', 'NL32-02', NULL, 'ITTENTHAL', 'Ittenthal', 'Ittenthal', '0101000020E61000009A9999999919204054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514788, 'MT97', 'NL32-02', NULL, 'ITTINGEN', 'Ittingen', 'Ittingen', '0101000020E61000007EEF254344C42140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514789, 'LT70', 'NL32-04', NULL, 'JAGGISBACHAU', 'Jaggisbachau', 'Jaggisbachau', '0101000020E6100000D1ED804644441D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514790, 'LS66', 'NL32-04', NULL, 'JAUN', 'Jaun', 'Jaun', '0101000020E61000009578E51F22221D40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514793, 'LS42', 'NL32-04', NULL, 'JAVERNE', 'Javerne', 'Javerne', '0101000020E61000003333333333331C40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514794, 'LT81', 'NL32-01', NULL, 'JEGENSTORF', 'Jegenstorf', 'Jegenstorf', '0101000020E61000000000000000001E406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514795, 'NS39', 'NL32-05', NULL, 'JELI', 'Jeli', 'Jeli', '0101000020E61000004FDDA6898808234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514796, 'NS59', 'NL32-05', NULL, 'JENAZ', 'Jenaz', 'Jenaz', '0101000020E6100000666666666666234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514797, 'NT40', 'NL32-02', NULL, 'JENINS', 'Jenins', 'Jenins', '0101000020E6100000E9764023222223400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514799, 'LT60', 'NL32-04', NULL, 'JERISBERGHOF', 'Jerisberghof', 'Jerisberghof', '0101000020E6100000CDCCCCCCCCCC1C409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514800, 'LS69', 'NL32-04', NULL, 'JEUSS', 'Jeuss', 'Jeuss', '0101000020E61000003854E7ACAAAA1C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514802, 'MT83', 'NL32-02', NULL, 'JONA', 'Jona', 'Jona', '0101000020E61000003333333333B321400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514803, 'MT53', 'NL32-02', NULL, 'JONEN', 'Jonen', 'Jonen', '0101000020E6100000CDCCCCCCCCCC20406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514804, 'NT05', 'NL32-02', NULL, 'JONSCHWIL', 'Jonschwil', 'Jonschwil', '0101000020E6100000E4558CA9AA2A224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514815, 'NS44', 'NL32-05', NULL, 'JUF', 'Juf', 'Juf', '0101000020E6100000E4558CA9AA2A23409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514827, 'KS92', 'NL32-04', NULL, 'JUSSY', 'Jussy', 'Jussy', '0101000020E61000009578E51F222219400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514828, 'MT06', 'NL32-01', NULL, 'KAISERAUGST', 'Kaiseraugst', 'Kaiseraugst', '0101000020E61000006B871AE0DDDD1E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514830, 'MS38', 'NL32-05', NULL, 'KAISERSTUHL', 'Kaiserstuhl', 'Kaiserstuhl', '0101000020E61000001CAA735655552040BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514831, 'MT56', 'NL32-02', NULL, 'KAISERSTUHL', 'Kaiserstuhl', 'Kaiserstuhl', '0101000020E61000001CAA735655D52040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514832, 'MT26', 'NL32-02', NULL, 'KAISTEN', 'Kaisten', 'Kaisten', '0101000020E61000004BBCF20F1111204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514833, 'LS64', 'NL32-04', NULL, 'KALBERHONI', 'Kalberhöni', 'Kalberhoni', '0101000020E61000000000000000001D40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514834, 'MT97', 'NL32-02', NULL, 'KALCHRAIN', 'Kalchrain', 'Kalchrain', '0101000020E61000001CAA735655D52140218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514835, 'LS78', 'NL32-04', NULL, 'KALCHSTATTEN', 'Kalchstätten', 'Kalchstatten', '0101000020E61000003333333333331D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514837, 'LT60', 'NL32-01', NULL, 'KALLNACH', 'Kallnach', 'Kallnach', '0101000020E61000006245B2ECEEEE1C4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514839, 'NT02', 'NL32-02', NULL, 'KALTBRUNN', 'Kaltbrunn', 'Kaltbrunn', '0101000020E61000004BBCF20F11112240ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514841, 'LS95', 'NL32-04', NULL, 'KANDERGRUND', 'Kandergrund', 'Kandergrund', '0101000020E61000003854E7ACAAAA1E406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514843, 'LS94', 'NL32-04', NULL, 'KANDERSTEG', 'Kandersteg', 'Kandersteg', '0101000020E61000003854E7ACAAAA1E40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514846, 'MT63', 'NL32-02', NULL, 'KAPPEL', 'Kappel', 'Kappel', '0101000020E61000004FDDA68988082140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514847, 'NT03', 'NL32-02', NULL, 'KAPPEL', 'Kappel', 'Kappel', '0101000020E61000008210DABCBB3B224054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514849, 'LT61', 'NL32-01', NULL, 'KAPPELEN', 'Kappelen', 'Kappelen', '0101000020E61000000000000000001D406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514850, 'LT60', 'NL32-04', NULL, 'KAPPELI', 'Käppeli', 'Kappeli', '0101000020E61000006245B2ECEEEE1C40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514853, 'MT90', 'NL32-02', NULL, 'KASERN', 'Käsern', 'Kasern', '0101000020E61000001789BFDCDDDD21400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514854, 'MS33', 'NL32-05', NULL, 'KASERSTATT', 'Käserstatt', 'Kaserstatt', '0101000020E61000001CAA7356555520403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514855, 'MT40', 'NL32-02', NULL, 'KASTANIENBAUM', 'Kastanienbaum', 'Kastanienbaum', '0101000020E6100000E4558CA9AAAA204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514856, 'NS18', 'NL32-05', NULL, 'KASTRIS', 'Kästris', 'Kastris', '0101000020E6100000B5430DF0EE6E224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514858, 'MT86', 'NL32-02', NULL, 'KEFIKON', 'Kefikon', 'Kefikon', '0101000020E6100000E976402322A221406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514859, 'LS89', 'NL32-04', NULL, 'KEHRSATZ', 'Kehrsatz', 'Kehrsatz', '0101000020E61000006B871AE0DDDD1D403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514860, 'MT50', 'NL32-05', NULL, 'KEHRSITEN', 'Kehrsiten', 'Kehrsiten', '0101000020E61000008210DABCBBBB2040AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514862, 'MS18', 'NL32-04', NULL, 'KEMMERIBODENBAD', 'Kemmeribodenbad', 'Kemmeribodenbad', '0101000020E61000003854E7ACAAAA1F406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514864, 'MT75', 'NL32-02', NULL, 'KEMPTTHAL', 'Kemptthal', 'Kemptthal', '0101000020E610000066666666666621409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514868, 'LT81', 'NL32-01', NULL, 'KERNENRIED', 'Kernenried', 'Kernenried', '0101000020E61000003333333333331E40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514869, 'MS49', 'NL32-05', NULL, 'KERNS', 'Kerns', 'Kerns', '0101000020E61000004BBCF20F119120403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514870, 'LT60', 'NL32-04', NULL, 'KERZERS', 'Kerzers', 'Kerzers', '0101000020E6100000CDCCCCCCCCCC1C40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514872, 'NT27', 'NL32-02', NULL, 'KESSWIL', 'Kesswil', 'Kesswil', '0101000020E61000009A99999999992240791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514873, 'LS96', 'NL32-04', NULL, 'KIEN', 'Kien', 'Kien', '0101000020E61000002F127FB9BBBB1E40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514874, 'MS27', 'NL32-05', NULL, 'KIENHOLZ', 'Kienholz', 'Kienholz', '0101000020E61000009A999999991920400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514875, 'MS05', 'NL32-04', NULL, 'KIENTAL', 'Kiental', 'Kiental', '0101000020E61000006245B2ECEEEE1E40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514879, 'LS98', 'NL32-04', NULL, 'KIESEN', 'Kiesen', 'Kiesen', '0101000020E6100000D1ED804644441E40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514884, 'MT64', 'NL32-02', NULL, 'KILCHBERG', 'Kilchberg', 'Kilchberg', '0101000020E61000009A99999999192140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514885, 'MT55', 'NL32-02', NULL, 'KILLWANGEN', 'Killwangen', 'Killwangen', '0101000020E61000003333333333B3204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514886, 'MS79', 'NL32-05', NULL, 'KINZERALP', 'Kinzeralp', 'Kinzeralp', '0101000020E6100000B12259767777214087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514888, 'MS03', 'NL32-04', NULL, 'KIPPEL', 'Kippel', 'Kippel', '0101000020E61000009EBA4D1311111F403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514889, 'LT91', 'NL32-01', NULL, 'KIRCHBERG', 'Kirchberg', 'Kirchberg', '0101000020E6100000C8AB185355551E40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514890, 'NT05', 'NL32-02', NULL, 'KIRCHBERG', 'Kirchberg', 'Kirchberg', '0101000020E61000004BBCF20F1111224087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514891, 'MT86', 'NL32-02', NULL, 'KIRCHDINHARD', 'Kirchdinhard', 'Kirchdinhard', '0101000020E61000004BBCF20F119121406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514892, 'LS88', 'NL32-04', NULL, 'KIRCHDORF', 'Kirchdorf', 'Kirchdorf', '0101000020E61000003333333333331E40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514893, 'LT70', 'NL32-01', NULL, 'KIRCHLINDACH', 'Kirchlindach', 'Kirchlindach', '0101000020E61000003854E7ACAAAA1D400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514897, 'LT96', 'NL32-01', NULL, 'KLEINBASEL', 'Klein-Basel', 'Klein-Basel', '0101000020E6100000C8AB185355551E40BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514898, 'MT02', 'NL32-01', NULL, 'KLEINDIETWIL', 'Kleindietwil', 'Kleindietwil', '0101000020E61000009578E51F22221F40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514903, 'LS89', 'NL32-04', NULL, 'KLEINHOCHSTETTEN', 'Kleinhöchstetten', 'Kleinhochstetten', '0101000020E61000009578E51F22221E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514904, 'LT97', 'NL32-01', NULL, 'KLEINHUNINGEN', 'Kleinhüningen', 'Kleinhuningen', '0101000020E6100000C8AB185355551E40791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514905, 'LT85', 'NL32-01', NULL, 'KLEINLUTZEL', 'Kleinlützel', 'Kleinlutzel', '0101000020E61000003854E7ACAAAA1D4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514914, 'MT47', 'NL32-02', NULL, 'KLINGNAU', 'Klingnau', 'Klingnau', '0101000020E61000000000000000802040791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514921, 'NA62', 'NM32-08', NULL, 'KLOSTERSBRUCKE', 'Klosters Brücke', 'Klosters Brucke', '0101000020E61000007EEF254344C42340218436EFEEEE4840');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514922, 'NS69', 'NL32-05', NULL, 'KLOSTERSDORF', 'Klosters Dorf', 'Klosters Dorf', '0101000020E61000008210DABCBBBB2340DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514924, 'NS69', 'NL32-05', NULL, 'KLOSTERSPLATZ', 'Klosters Platz', 'Klosters Platz', '0101000020E61000008210DABCBBBB2340218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514925, 'NS69', 'NL32-05', NULL, 'KLOSTERSSERNEUS', 'Klosters Serneus', 'Klosters Serneus', '0101000020E6100000E4558CA9AAAA2340DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514927, 'MT65', 'NL32-02', NULL, 'KLOTEN', 'Kloten', 'Kloten', '0101000020E6100000E4558CA9AA2A21409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514928, 'LS86', 'NL32-04', NULL, 'KLUSI', 'Klusi', 'Klusi', '0101000020E61000009578E51F22221E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514929, 'MT53', 'NL32-02', NULL, 'KNONAU', 'Knonau', 'Knonau', '0101000020E61000006666666666E62040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514930, 'MT22', 'NL32-02', NULL, 'KNUTWIL', 'Knutwil', 'Knutwil', '0101000020E6100000E9764023222220409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514931, 'MT47', 'NL32-02', NULL, 'KOBLENZ', 'Koblenz', 'Koblenz', '0101000020E6100000B122597677772040218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514933, 'MT85', 'NL32-02', NULL, 'KOLLBRUNN', 'Kollbrunn', 'Kollbrunn', '0101000020E61000004BBCF20F119121409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514934, 'MT24', 'NL32-02', NULL, 'KOLLIKEN', 'Kölliken', 'Kolliken', '0101000020E61000004FDDA68988082040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514935, 'LS79', 'NL32-04', 3, 'KONIZ', 'Köniz', 'Koniz', '0101000020E61000003854E7ACAAAA1D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514938, 'LS99', 'NL32-04', NULL, 'KONOLFINGEN', 'Konolfingen', 'Konolfingen', '0101000020E6100000FCDE4B8688881E40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514940, 'LS99', 'NL32-04', NULL, 'KONOLFINGENDORF', 'Konolfingen Dorf', 'Konolfingen Dorf', '0101000020E6100000FCDE4B8688881E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514942, 'LT92', 'NL32-01', NULL, 'KOPPIGEN', 'Koppigen', 'Koppigen', '0101000020E61000006666666666661E40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514943, 'NT16', 'NL32-02', NULL, 'KRADOLF', 'Kradolf', 'Kradolf', '0101000020E6100000666666666666224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514944, 'MS06', 'NL32-04', NULL, 'KRATTIGEN', 'Krattigen', 'Krattigen', '0101000020E61000006245B2ECEEEE1E403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514946, 'LT90', 'NL32-01', NULL, 'KRAUCHTHAL', 'Krauchthal', 'Krauchthal', '0101000020E6100000D1ED804644441E4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514947, 'MS27', 'NL32-05', NULL, 'KRAUTMETTLI', 'Krautmettli', 'Krautmettli', '0101000020E61000009A99999999192040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514948, 'MT00', 'NL32-04', NULL, 'KREUZBRUCKE', 'Kreuzbrücke', 'Kreuzbrucke', '0101000020E61000003333333333331F409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514950, 'NT17', 'NL32-02', NULL, 'KREUZLINGEN', 'Kreuzlingen', 'Kreuzlingen', '0101000020E61000001789BFDCDD5D22403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514951, 'LS69', 'NL32-04', NULL, 'KRIECHENWIL', 'Kriechenwil', 'Kriechenwil', '0101000020E61000006245B2ECEEEE1C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514953, 'NS68', 'NL32-05', NULL, 'KRIEGSMATTE', 'Kriegsmatte', 'Kriegsmatte', '0101000020E61000007EEF254344C4234013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514954, 'LT92', 'NL32-01', NULL, 'KRIEGSTETTEN', 'Kriegstetten', 'Kriegstetten', '0101000020E61000006666666666661E4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514956, 'MT40', 'NL32-02', 3, 'KRIENS', 'Kriens', 'Kriens', '0101000020E61000004BBCF20F1191204013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514958, 'NT04', 'NL32-02', NULL, 'KRINAU', 'Krinau', 'Krinau', '0101000020E61000009A99999999192240BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514959, 'NT25', 'NL32-02', NULL, 'KRONBUHL', 'Kronbühl', 'Kronbuhl', '0101000020E61000007EEF254344C422409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514962, 'MS19', 'NL32-04', NULL, 'KROSCHENBRUNNEN', 'Kröschenbrunnen', 'Kroschenbrunnen', '0101000020E6100000FCDE4B8688881F403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514963, 'NT13', 'NL32-02', NULL, 'KRUMMENAU', 'Krummenau', 'Krummenau', '0101000020E61000001CAA735655552240AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514965, 'NS59', 'NL32-05', NULL, 'KUBLIS', 'Küblis', 'Kublis', '0101000020E610000000000000008023403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514966, 'MT62', 'NL32-02', NULL, 'KUENZ', 'Kuenz', 'Kuenz', '0101000020E6100000E97640232222214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514968, 'MS68', 'NL32-05', NULL, 'KULM', 'Kulm', 'Kulm', '0101000020E61000003333333333332140791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514969, 'MT61', 'NL32-02', NULL, 'KULM', 'Kulm', 'Kulm', '0101000020E6100000B122597677F720406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514971, 'NS57', 'NL32-05', NULL, 'KUMMA', 'Kumma', 'Kumma', '0101000020E61000004BBCF20F119123400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514973, 'MT44', 'NL32-02', NULL, 'KUNTEN', 'Künten', 'Kunten', '0101000020E6100000E976402322A22040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514979, 'MT64', 'NL32-02', NULL, 'KUSNACHT', 'Küsnacht', 'Kusnacht', '0101000020E6100000E4558CA9AA2A2140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514980, 'MT51', 'NL32-02', NULL, 'KUSSNACHT', 'Küssnacht', 'Kussnacht', '0101000020E61000001789BFDCDDDD2040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514983, 'MT25', 'NL32-02', NULL, 'KUTTIGEN', 'Küttigen', 'Kuttigen', '0101000020E61000009A9999999919204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514984, 'LT82', 'NL32-01', NULL, 'KUTTIGKOFEN', 'Küttigkofen', 'Kuttigkofen', '0101000020E61000000000000000001E40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514985, 'MT85', 'NL32-02', NULL, 'KYBURG', 'Kyburg', 'Kyburg', '0101000020E610000000000000008021409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514986, 'NS18', 'NL32-05', NULL, 'LAAX', 'Laax', 'Laax', '0101000020E610000000000000008022406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514988, 'LS41', 'NL32-04', NULL, 'LABALMAZ', 'La Balmaz', 'La Balmaz', '0101000020E61000009578E51F22221C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514989, 'LS70', 'NL32-04', NULL, 'LABARMA', 'La Barma', 'La Barma', '0101000020E6100000FCDE4B8688881D406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514992, 'KS96', 'NL32-04', NULL, 'LABBAYE', 'L’Abbaye', 'L’Abbaye', '0101000020E6100000D1ED8046444419403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3514997, 'LT10', 'NL32-04', NULL, 'LABREVINE', 'La Brévine', 'La Brevine', '0101000020E61000006666666666661A40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515001, 'LT53', 'NL32-01', NULL, 'LACHAUX', 'La Chaux', 'La Chaux', '0101000020E61000009578E51F22221C40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515003, 'LT32', 'NL32-01', 3, 'LACHAUXDEFONDS', 'La Chaux-de-Fonds', 'La Chaux-de-Fonds', '0101000020E61000006666666666661B40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515006, 'MT82', 'NL32-02', NULL, 'LACHEN', 'Lachen', 'Lachen', '0101000020E61000003333333333B3214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515007, 'LS34', 'NL32-04', NULL, 'LACHIESAZ', 'La Chièsaz', 'La Chiesaz', '0101000020E6100000FCDE4B8688881B40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515009, 'LS53', 'NL32-04', NULL, 'LACOMBALLAZ', 'La Comballaz', 'La Comballaz', '0101000020E6100000D1ED804644441C40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515012, 'LS09', 'NL32-04', NULL, 'LACOTEAUXFEES', 'La Côte-aux-Fées', 'La Cote-aux-Fees', '0101000020E61000006245B2ECEEEE1940218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515013, 'KS72', 'NL32-04', NULL, 'LACOULOUVRENIERE', 'La Coulouvrenière', 'La Coulouvreniere', '0101000020E6100000FCDE4B86888818409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515014, 'LS71', 'NL32-04', NULL, 'LACRETA', 'La Crêta', 'La Creta', '0101000020E61000002F127FB9BBBB1D4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515015, 'KS75', 'NL32-04', NULL, 'LACURE', 'La Cure', 'La Cure', '0101000020E6100000C8AB185355551840ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515017, 'KS97', 'NL32-04', NULL, 'LADERNIER', 'La Dernier', 'La Dernier', '0101000020E6100000FCDE4B86888819409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515018, 'LS95', 'NL32-04', NULL, 'LADHOLZ', 'Ladholz', 'Ladholz', '0101000020E61000006666666666661E4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515019, 'NS39', 'NL32-05', NULL, 'LADILS', 'Ladils', 'Ladils', '0101000020E61000001789BFDCDDDD224046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515020, 'NS18', 'NL32-05', NULL, 'LADIR', 'Ladir', 'Ladir', '0101000020E610000066666666666622406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515025, 'LT32', 'NL32-01', NULL, 'LAFERRIERE', 'La Ferrière', 'La Ferriere', '0101000020E6100000FCDE4B8688881B40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515026, 'LS62', 'NL32-04', NULL, 'LAFONTAINE', 'La Fontaine', 'La Fontaine', '0101000020E61000003333333333331D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515027, 'LS53', 'NL32-04', NULL, 'LAFORCLAZ', 'La Forclaz', 'La Forclaz', '0101000020E6100000D1ED804644441C40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515028, 'LR58', 'NL32-07', NULL, 'LAFOULY', 'La Fouly', 'La Fouly', '0101000020E6100000C8AB185355551C4046E22F7777F74640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515032, 'LS72', 'NL32-04', NULL, 'LAGIETEDELE', 'La Giète Délé', 'La Giete Dele', '0101000020E61000002F127FB9BBBB1D406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515035, 'LS80', 'NL32-04', NULL, 'LAGOUILLE', 'La Gouille', 'La Gouille', '0101000020E61000006245B2ECEEEE1D406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515036, 'LT62', 'NL32-01', NULL, 'LAHEUTTE', 'La Heutte', 'La Heutte', '0101000020E61000006B871AE0DDDD1C4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515042, 'LT53', 'NL32-01', NULL, 'LAJOUX', 'Lajoux', 'Lajoux', '0101000020E6100000FCDE4B8688881C4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515043, 'MS12', 'NL32-04', NULL, 'LALDEN', 'Lalden', 'Lalden', '0101000020E61000009A99999999991F406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515044, 'LS54', 'NL32-04', NULL, 'LALECHERETTE', 'La Lécherette', 'La Lecherette', '0101000020E61000000421B47977771C4046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515050, 'LT51', 'NL32-01', NULL, 'LAMBOING', 'Lamboing', 'Lamboing', '0101000020E61000009A99999999991C40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515052, 'LS51', 'NL32-04', NULL, 'LAMEREUNE', 'La Méreune', 'La Mereune', '0101000020E6100000D1ED804644441C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515053, 'LR89', 'NL32-04', NULL, 'LAMONTA', 'La Monta', 'La Monta', '0101000020E61000006245B2ECEEEE1D4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515060, 'NS02', 'NL32-05', NULL, 'LANDARENCA', 'Landarenca', 'Landarenca', '0101000020E61000008210DABCBB3B2240BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515061, 'MS29', 'NL32-05', NULL, 'LANDBRUGG', 'Landbrugg', 'Landbrugg', '0101000020E6100000000000000000204046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515062, 'LT90', 'NL32-04', NULL, 'LANDISWIL', 'Landiswil', 'Landiswil', '0101000020E61000003854E7ACAAAA1E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515063, 'NS49', 'NL32-05', NULL, 'LANDQUART', 'Landquart', 'Landquart', '0101000020E6100000E9764023222223409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515065, 'NS49', 'NL32-05', NULL, 'LANDQUARTFABRIKEN', 'Landquart Fabriken', 'Landquart Fabriken', '0101000020E6100000E9764023222223409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515069, 'LT51', 'NL32-01', NULL, 'LANEUVEVILLE', 'La Neuveville', 'La Neuveville', '0101000020E61000006666666666661C40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515071, 'MT04', 'NL32-01', NULL, 'LANGENBRUCK', 'Langenbruck', 'Langenbruck', '0101000020E61000000000000000001F40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515072, 'LS97', 'NL32-04', NULL, 'LANGENSCHACHEN', 'Längenschachen', 'Langenschachen', '0101000020E61000002F127FB9BBBB1E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515075, 'MT02', 'NL32-01', NULL, 'LANGENTHAL', 'Langenthal', 'Langenthal', '0101000020E61000009578E51F22221F40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515078, 'MT00', 'NL32-04', NULL, 'LANGNAU', 'Langnau', 'Langnau', '0101000020E61000009EBA4D1311111F409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515079, 'MT22', 'NL32-01', NULL, 'LANGNAU', 'Langnau', 'Langnau', '0101000020E6100000CDCCCCCCCCCC1F40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515080, 'MT63', 'NL32-02', NULL, 'LANGNAU', 'Langnau', 'Langnau', '0101000020E61000004BBCF20F1111214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515081, 'NT17', 'NL32-02', NULL, 'LANGRICKENBACH', 'Langrickenbach', 'Langrickenbach', '0101000020E6100000B122597677772240791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515083, 'NS58', 'NL32-05', NULL, 'LANGWIES', 'Langwies', 'Langwies', '0101000020E61000006666666666662340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515085, 'LS80', 'NL32-04', NULL, 'LANNAZ', 'Lannaz', 'Lannaz', '0101000020E61000006245B2ECEEEE1D40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515089, 'LS60', 'NL32-04', NULL, 'LAPERREYRE', 'La Perreyre', 'La Perreyre', '0101000020E61000009EBA4D1311111D40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515091, 'KS61', 'NL32-04', NULL, 'LAPLAINE', 'La Plaine', 'La Plaine', '0101000020E6100000000000000000184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515093, 'KS71', 'NL32-04', NULL, 'LAPRAILLE', 'La Praille', 'La Praille', '0101000020E61000000421B4797777184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515094, 'LS07', 'NL32-04', NULL, 'LAPRAZ', 'La Praz', 'La Praz', '0101000020E61000003854E7ACAAAA194087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515098, 'KS84', 'NL32-04', NULL, 'LAREDOUTE', 'La Redoute', 'La Redoute', '0101000020E61000006245B2ECEEEE1840DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515099, 'NS42', 'NL32-05', NULL, 'LARET', 'Laret', 'Laret', '0101000020E61000003333333333332340BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515100, 'NS68', 'NL32-05', NULL, 'LARET', 'Laret', 'Laret', '0101000020E61000003333333333B32340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515101, 'LT62', 'NL32-01', NULL, 'LAREUCHENETTE', 'La Reuchenette', 'La Reuchenette', '0101000020E61000000000000000001D4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515103, 'LS57', 'NL32-04', NULL, 'LAROCHE', 'La Roche', 'La Roche', '0101000020E6100000FCDE4B8688881C409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515104, 'NS83', 'NL32-06', NULL, 'LAROSA', 'La Rösa', 'La Rosa', '0101000020E6100000E9764023222224403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515105, 'LS93', 'NL32-04', NULL, 'LARSI', 'Larsi', 'Larsi', '0101000020E61000006666666666661E40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515109, 'LT31', 'NL32-01', NULL, 'LASAGNE', 'La Sagne', 'La Sagne', '0101000020E61000003333333333331B406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515111, 'LS17', 'NL32-04', NULL, 'LASARRAZ', 'La Sarraz', 'La Sarraz', '0101000020E61000009EBA4D1311111A4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515115, 'LS54', 'NL32-04', NULL, 'LATINE', 'La Tine', 'La Tine', '0101000020E61000003333333333331C40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515116, 'LS80', 'NL32-04', NULL, 'LATOUR', 'La Tour', 'La Tour', '0101000020E61000000000000000001E40CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515117, 'LS34', 'NL32-04', NULL, 'LATOURDEPEILZ', 'La Tour-de-Peilz', 'La Tour-de-Peilz', '0101000020E61000000421B47977771B409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515118, 'LS56', 'NL32-04', NULL, 'LATOURDETREME', 'La Tour-de-Trême', 'La Tour-de-Treme', '0101000020E6100000D1ED804644441C40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515119, 'NS56', 'NL32-05', NULL, 'LATSCH', 'Latsch', 'Latsch', '0101000020E61000000000000000802340DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515120, 'LS74', 'NL32-04', NULL, 'LAUENEN', 'Lauenen', 'Lauenen', '0101000020E6100000C8AB185355551D4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515121, 'MT60', 'NL32-02', NULL, 'LAUERZ', 'Lauerz', 'Lauerz', '0101000020E6100000E4558CA9AA2A214013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515123, 'MT15', 'NL32-01', NULL, 'LAUFELFINGEN', 'Läufelfingen', 'Laufelfingen', '0101000020E61000006666666666661F403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515125, 'LT85', 'NL32-01', NULL, 'LAUFEN', 'Laufen', 'Laufen', '0101000020E61000000000000000001E4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515126, 'MT78', 'NL32-02', NULL, 'LAUFEN', 'Laufen', 'Laufen', '0101000020E61000008210DABCBB3B214046E22F7777D74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515127, 'MT26', 'NL32-02', NULL, 'LAUFENBURG', 'Laufenburg', 'Laufenburg', '0101000020E61000009A99999999192040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515128, 'LS69', 'NL32-04', NULL, 'LAUPEN', 'Laupen', 'Laupen', '0101000020E61000000000000000001D403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515129, 'LT94', 'NL32-01', NULL, 'LAUPERSDORF', 'Laupersdorf', 'Laupersdorf', '0101000020E61000009A99999999991E40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515130, 'MT00', 'NL32-04', NULL, 'LAUPERSWIL', 'Lauperswil', 'Lauperswil', '0101000020E61000006245B2ECEEEE1E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515131, 'NS01', 'NL32-05', NULL, 'LAURA', 'Laura', 'Laura', '0101000020E61000003333333333332240ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515132, 'LS25', 'NL32-04', 1, 'LAUSANNE', 'Lausanne', 'Lausanne', '0101000020E61000003854E7ACAAAA1A4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515133, 'MT05', 'NL32-01', NULL, 'LAUSEN', 'Lausen', 'Lausen', '0101000020E61000000000000000001F40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515134, 'MS16', 'NL32-04', NULL, 'LAUTERBRUNNEN', 'Lauterbrunnen', 'Lauterbrunnen', '0101000020E61000009A99999999991F40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515144, 'MS82', 'NL32-05', NULL, 'LAVERTEZZO', 'Lavertezzo', 'Lavertezzo', '0101000020E6100000E4558CA9AAAA21400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515145, 'LS42', 'NL32-04', NULL, 'LAVEY', 'Lavey', 'Lavey', '0101000020E61000009578E51F22221C40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515146, 'LS41', 'NL32-04', NULL, 'LAVEYLESBAINS', 'Lavey-les-Bains', 'Lavey-les-Bains', '0101000020E61000009578E51F22221C409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515148, 'NS87', 'NL32-06', NULL, 'LAVIN', 'Lavin', 'Lavin', '0101000020E6100000333333333333244054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515150, 'MS84', 'NL32-05', NULL, 'LAVORGO', 'Lavorgo', 'Lavorgo', '0101000020E6100000E4558CA9AAAA21409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515151, 'MS33', 'NL32-05', NULL, 'LAX', 'Lax', 'Lax', '0101000020E61000008210DABCBB3B2040DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515154, 'KS86', 'NL32-04', NULL, 'LEBRASSUS', 'Le Brassus', 'Le Brassus', '0101000020E61000006B871AE0DDDD1840791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515155, 'LS57', 'NL32-04', NULL, 'LEBRY', 'Le Bry', 'Le Bry', '0101000020E6100000C8AB185355551C409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515156, 'LS60', 'NL32-04', NULL, 'LECHABLE', 'Le Châble', 'Le Chable', '0101000020E6100000CDCCCCCCCCCC1C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515157, 'LS25', 'NL32-04', NULL, 'LECHALETAGOBET', 'Le Chalet-à-Gobet', 'Le Chalet-a-Gobet', '0101000020E61000002F127FB9BBBB1A40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515158, 'LS34', 'NL32-04', NULL, 'LECHATELARD', 'Le Châtelard', 'Le Chatelard', '0101000020E61000003854E7ACAAAA1B409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515159, 'LS25', 'NL32-04', NULL, 'LECHATELARD', 'Le Châtelard', 'Le Chatelard', '0101000020E61000002F127FB9BBBB1A400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515161, 'LS48', 'NL32-04', NULL, 'LECHELLES', 'Léchelles', 'Lechelles', '0101000020E61000009EBA4D1311111C40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515162, 'KS86', 'NL32-04', NULL, 'LECHENIT', 'Le Chenit', 'Le Chenit', '0101000020E61000006245B2ECEEEE1840CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515166, 'LS54', 'NL32-04', NULL, 'LECONTOUR', 'Le Contour', 'Le Contour', '0101000020E61000009A99999999991C4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515167, 'LS46', 'NL32-04', NULL, 'LECRET', 'Le Crêt', 'Le Cret', '0101000020E61000002F127FB9BBBB1B40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515171, 'LS40', 'NL32-04', NULL, 'LEFAYS', 'Le Fays', 'Le Fays', '0101000020E61000009578E51F22221C40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515173, 'NS12', 'NL32-05', NULL, 'LEGGIA', 'Leggia', 'Leggia', '0101000020E61000001CAA73565555224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515178, 'KS72', 'NL32-04', NULL, 'LEGRANDSACONNEX', 'Le Grand-Saconnex', 'Le Grand-Saconnex', '0101000020E6100000FCDE4B8688881840AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515180, 'MT37', 'NL32-02', NULL, 'LEIBSTADT', 'Leibstadt', 'Leibstadt', '0101000020E61000001789BFDCDD5D2040791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515181, 'NT16', 'NL32-02', NULL, 'LEIMBACH', 'Leimbach', 'Leimbach', '0101000020E61000001789BFDCDD5D2240BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515182, 'NS16', 'NL32-05', NULL, 'LEIS', 'Leis', 'Leis', '0101000020E61000001CAA735655552240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515183, 'MS06', 'NL32-04', NULL, 'LEISSIGEN', 'Leissigen', 'Leissigen', '0101000020E61000009EBA4D1311111F403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515187, 'LT51', 'NL32-01', NULL, 'LELANDERON', 'Le Landeron', 'Le Landeron', '0101000020E6100000D1ED804644441C406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515189, 'MS90', 'NL32-05', NULL, 'LELGIO', 'Lelgio', 'Lelgio', '0101000020E61000006666666666E62140791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515190, 'MS29', 'NL32-04', NULL, 'LELIN', 'Lelin', 'Lelin', '0101000020E61000006B871AE0DDDD1F4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515193, 'LT21', 'NL32-01', NULL, 'LELOCLE', 'Le Locle', 'Le Locle', '0101000020E61000000000000000001B40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515200, 'LS15', 'NL32-04', NULL, 'LEMONTSURLAUSANNE', 'Le Mont-sur-Lausanne', 'Le Mont-sur-Lausanne', '0101000020E6100000FCDE4B8688881A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515202, 'LT72', 'NL32-01', NULL, 'LENGNAU', 'Lengnau', 'Lengnau', '0101000020E61000000421B47977771D4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515203, 'LS74', 'NL32-04', NULL, 'LENK', 'Lenk', 'Lenk', '0101000020E61000002F127FB9BBBB1D409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515206, 'LT43', 'NL32-01', NULL, 'LENOIRMONT', 'Le Noirmont', 'Le Noirmont', '0101000020E6100000CDCCCCCCCCCC1B40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515207, 'LS82', 'NL32-04', NULL, 'LENS', 'Lens', 'Lens', '0101000020E6100000CDCCCCCCCCCC1D4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515208, 'NS47', 'NL32-05', NULL, 'LENZ', 'Lenz', 'Lenz', '0101000020E6100000E97640232222234046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515209, 'MT34', 'NL32-02', NULL, 'LENZBURG', 'Lenzburg', 'Lenzburg', '0101000020E61000001789BFDCDD5D2040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515211, 'NS47', 'NL32-05', NULL, 'LENZERHEIDE', 'Lenzerheide', 'Lenzerheide', '0101000020E61000009A999999991923400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515213, 'LT41', 'NL32-01', NULL, 'LEPAQUIER', 'Le Pâquier', 'Le Paquier', '0101000020E61000006245B2ECEEEE1B40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515216, 'LT42', 'NL32-01', NULL, 'LEPEUCHAPATTE', 'Le Peuchapatte', 'Le Peuchapatte', '0101000020E6100000CDCCCCCCCCCC1B409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515217, 'KS97', 'NL32-04', NULL, 'LEPONT', 'Le Pont', 'Le Pont', '0101000020E6100000D1ED80464444194087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515222, 'NS82', 'NL32-06', NULL, 'LEPRESE', 'Le Prese', 'Le Prese', '0101000020E6100000E4558CA9AA2A24406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515227, 'KS71', 'NL32-04', NULL, 'LESACACIAS', 'Les Acacias', 'Les Acacias', '0101000020E6100000FCDE4B868888184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515230, 'LS44', 'NL32-04', NULL, 'LESAVANTS', 'Les Avants', 'Les Avants', '0101000020E6100000CDCCCCCCCCCC1B409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515231, 'LS19', 'NL32-04', NULL, 'LESBAYARDS', 'Les Bayards', 'Les Bayards', '0101000020E61000009EBA4D1311111A4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515232, 'LT42', 'NL32-01', NULL, 'LESBOIS', 'Les Bois', 'Les Bois', '0101000020E61000009A99999999991B4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515233, 'LT21', 'NL32-01', NULL, 'LESBRENETS', 'Les Brenets', 'Les Brenets', '0101000020E6100000CDCCCCCCCCCC1A40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515234, 'LT42', 'NL32-01', NULL, 'LESBREULEUX', 'Les Breuleux', 'Les Breuleux', '0101000020E61000000000000000001C409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515235, 'KS97', 'NL32-04', NULL, 'LESCHARBONNIERES', 'Les Charbonnières', 'Les Charbonnieres', '0101000020E6100000D1ED80464444194087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515236, 'KS72', 'NL32-04', NULL, 'LESCHARMILLES', 'Les Charmilles', 'Les Charmilles', '0101000020E61000000421B479777718409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515237, 'LT30', 'NL32-01', NULL, 'LESCOEUDRES', 'Les Coeudres', 'Les Coeudres', '0101000020E61000009EBA4D1311111B4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515239, 'LS42', 'NL32-04', NULL, 'LESDEVENS', 'Les Dévens', 'Les Devens', '0101000020E61000000000000000001C4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515241, 'LS53', 'NL32-04', NULL, 'LESDIABLERETS', 'Les Diablerets', 'Les Diablerets', '0101000020E61000009A99999999991C40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515243, 'KS86', 'NL32-04', NULL, 'LESENTIER', 'Le Sentier', 'Le Sentier', '0101000020E61000006245B2ECEEEE1840218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515244, 'LS53', 'NL32-04', NULL, 'LESEPEY', 'Le Sépey', 'Le Sepey', '0101000020E61000003333333333331C40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515245, 'LS51', 'NL32-04', NULL, 'LESGARETTES', 'Les Garettes', 'Les Garettes', '0101000020E61000006666666666661C4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515246, 'LT31', 'NL32-01', NULL, 'LESGENEVEYSSURCOFFRANE', 'Les Geneveys-sur-Coffrane', 'Les Geneveys-sur-Coffrane', '0101000020E61000006666666666661B4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515247, 'LT53', 'NL32-01', NULL, 'LESGENEVEZ', 'Les Genevez', 'Les Genevez', '0101000020E6100000FCDE4B8688881C400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515249, 'LT31', 'NL32-01', NULL, 'LESHAUTSGENEVEYS', 'Les Hauts-Geneveys', 'Les Hauts-Geneveys', '0101000020E6100000FCDE4B8688881B406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515251, 'LS40', 'NL32-04', NULL, 'LESMARECOTTES', 'Les Marécottes', 'Les Marecottes', '0101000020E61000000000000000001C40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515252, 'LS54', 'NL32-04', NULL, 'LESMOSSES', 'Les Mosses', 'Les Mosses', '0101000020E61000000421B47977771C403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515253, 'LS54', 'NL32-04', NULL, 'LESMOULINS', 'Les Moulins', 'Les Moulins', '0101000020E61000000421B47977771C40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515254, 'KS82', 'NL32-04', NULL, 'LESPAQUIS', 'Les Pâquis', 'Les Paquis', '0101000020E61000003854E7ACAAAA18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515256, 'LS52', 'NL32-04', NULL, 'LESPLANSSURBEX', 'Les Plans-sur-Bex', 'Les Plans-sur-Bex', '0101000020E61000006666666666661C4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515257, 'LS34', 'NL32-04', NULL, 'LESPLEIADES', 'Les Pléiades', 'Les Pleiades', '0101000020E6100000FCDE4B8688881B40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515258, 'LT43', 'NL32-01', NULL, 'LESPOMMERATS', 'Les Pommerats', 'Les Pommerats', '0101000020E61000006245B2ECEEEE1B4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515260, 'LT20', 'NL32-01', NULL, 'LESPONTSDEMARTEL', 'Les Ponts-de-Martel', 'Les Ponts-de-Martel', '0101000020E61000006245B2ECEEEE1A400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515263, 'LS50', 'NL32-04', NULL, 'LESRAPPES', 'Les Rappes', 'Les Rappes', '0101000020E6100000C8AB185355551C40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515266, 'LS55', 'NL32-04', NULL, 'LESSOC', 'Lessoc', 'Lessoc', '0101000020E6100000D1ED804644441C400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515267, 'LS35', 'NL32-04', NULL, 'LESTHIOLEYRES', 'Les Thioleyres', 'Les Thioleyres', '0101000020E61000009578E51F22221B4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515269, 'LS50', 'NL32-04', NULL, 'LESVALETTES', 'Les Valettes', 'Les Valettes', '0101000020E6100000D1ED804644441C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515270, 'LS09', 'NL32-04', NULL, 'LESVERRIERES', 'Les Verrières', 'Les Verrieres', '0101000020E61000006B871AE0DDDD19403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515272, 'MT64', 'NL32-02', NULL, 'LETTEN', 'Letten', 'Letten', '0101000020E61000004BBCF20F111121403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515273, 'NT00', 'NL32-05', NULL, 'LEUGGELBACH', 'Leuggelbach', 'Leuggelbach', '0101000020E61000009A99999999192240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515274, 'LS93', 'NL32-04', NULL, 'LEUK', 'Leuk', 'Leuk', '0101000020E6100000FCDE4B8688881E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515275, 'LS93', 'NL32-04', NULL, 'LEUKERBAD', 'Leukerbad', 'Leukerbad', '0101000020E6100000FCDE4B8688881E40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515277, 'NT06', 'NL32-02', NULL, 'LEUTMERKEN', 'Leutmerken', 'Leutmerken', '0101000020E61000009A999999991922406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515278, 'MT34', 'NL32-02', NULL, 'LEUTWIL', 'Leutwil', 'Leutwil', '0101000020E61000001CAA735655552040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515279, 'LT82', 'NL32-01', NULL, 'LEUZIGEN', 'Leuzigen', 'Leuzigen', '0101000020E6100000CDCCCCCCCCCC1D4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515280, 'KS85', 'NL32-04', NULL, 'LEVAUD', 'Le Vaud', 'Le Vaud', '0101000020E61000006245B2ECEEEE1840AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515282, 'LS90', 'NL32-04', NULL, 'LEVICHIESSO', 'Le Vichiesso', 'Le Vichiesso', '0101000020E6100000FCDE4B8688881E40CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515283, 'LS43', 'NL32-04', NULL, 'LEYSIN', 'Leysin', 'Leysin', '0101000020E61000009EBA4D1311111C40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515284, 'LS61', 'NL32-04', NULL, 'LEYTRON', 'Leytron', 'Leytron', '0101000020E6100000CDCCCCCCCCCC1C4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515286, 'NT04', 'NL32-02', NULL, 'LICHTENSTEIG', 'Lichtensteig', 'Lichtensteig', '0101000020E6100000E4558CA9AA2A2240791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515287, 'LR59', 'NL32-04', NULL, 'LIDDES', 'Liddes', 'Liddes', '0101000020E61000002F127FB9BBBB1C400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515288, 'LS89', 'NL32-04', NULL, 'LIEBEFELD', 'Liebefeld', 'Liebefeld', '0101000020E61000002F127FB9BBBB1D4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515289, 'LS69', 'NL32-04', NULL, 'LIEBISTORF', 'Liebistorf', 'Liebistorf', '0101000020E6100000CDCCCCCCCCCC1C4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515290, 'MT42', 'NL32-02', NULL, 'LIELI', 'Lieli', 'Lieli', '0101000020E61000009A999999999920409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515291, 'NT43', 'NL32-02', NULL, 'LIENZ', 'Lienz', 'Lienz', '0101000020E61000004BBCF20F1111234013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515292, 'LT85', 'NL32-01', NULL, 'LIESBERG', 'Liesberg', 'Liesberg', '0101000020E61000002F127FB9BBBB1D403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515293, 'MT05', 'NL32-01', 3, 'LIESTAL', 'Liestal', 'Liestal', '0101000020E61000006245B2ECEEEE1E40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515295, 'LT51', 'NL32-01', NULL, 'LIGERZ', 'Ligerz', 'Ligerz', '0101000020E61000009A99999999991C40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515296, 'LT51', 'NL32-01', NULL, 'LIGNIERES', 'Lignières', 'Lignieres', '0101000020E6100000D1ED804644441C40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515297, 'MR97', 'NL32-08', NULL, 'LIGORNETTO', 'Ligornetto', 'Ligornetto', '0101000020E61000006666666666E62140218436EFEEEE4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515300, 'MT75', 'NL32-02', NULL, 'LINDAU', 'Lindau', 'Lindau', '0101000020E61000001CAA7356555521409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515302, 'LS98', 'NL32-04', NULL, 'LINDEN', 'Linden', 'Linden', '0101000020E61000002F127FB9BBBB1E40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515305, 'LT50', 'NL32-04', NULL, 'LINDENHOF', 'Lindenhof', 'Lindenhof', '0101000020E6100000D1ED804644441C40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515306, 'LT80', 'NL32-04', NULL, 'LINDENTHAL', 'Lindenthal', 'Lindenthal', '0101000020E61000003333333333331E40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515309, 'NS09', 'NL32-05', NULL, 'LINTHAL', 'Linthal', 'Linthal', '0101000020E6100000000000000000224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515315, 'MS89', 'NL32-05', NULL, 'LIPPLISBUHL', 'Lipplisbühl', 'Lipplisbuhl', '0101000020E6100000000000000080214046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515317, 'LS06', 'NL32-04', NULL, 'LISLE', 'L’Isle', 'L’Isle', '0101000020E61000003854E7ACAAAA1940218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515318, 'MT41', 'NL32-02', NULL, 'LITTAU', 'Littau', 'Littau', '0101000020E610000000000000008020406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515319, 'LT90', 'NL32-04', NULL, 'LITTEWIL', 'Littewil', 'Littewil', '0101000020E6100000C8AB185355551E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515321, 'NS53', 'NL32-05', NULL, 'LOBBIA', 'Löbbia', 'Lobbia', '0101000020E61000001CAA735655552340DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515322, 'MS81', 'NL32-05', 4, 'LOCARNO', 'Locarno', 'Locarno', '0101000020E61000009A9999999999214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515325, 'MS45', 'NL32-05', NULL, 'LOCH', 'Loch', 'Loch', '0101000020E6100000E976402322A2204054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515326, 'MS66', 'NL32-05', NULL, 'LOCH', 'Loch', 'Loch', '0101000020E610000033333333333321403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515327, 'MS71', 'NL32-05', NULL, 'LOCO', 'Loco', 'Loco', '0101000020E61000001CAA7356555521409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515328, 'MS72', 'NL32-05', NULL, 'LODANO', 'Lodano', 'Lodano', '0101000020E61000001789BFDCDD5D21400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515329, 'MS92', 'NL32-05', NULL, 'LODRINO', 'Lodrino', 'Lodrino', '0101000020E6100000B5430DF0EEEE21406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515330, 'MS38', 'NL32-05', NULL, 'LOHALP', 'Lohalp', 'Lohalp', '0101000020E6100000E4558CA9AA2A2040CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515331, 'NS36', 'NL32-05', NULL, 'LOHN', 'Lohn', 'Lohn', '0101000020E61000001CAA735655D522403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515332, 'MT78', 'NL32-02', NULL, 'LOHN', 'Lohn', 'Lohn', '0101000020E61000001CAA7356555521400000000000E04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515334, 'MT96', 'NL32-02', NULL, 'LOMMIS', 'Lommis', 'Lommis', '0101000020E6100000B122597677F7214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515336, 'KS85', 'NL32-04', NULL, 'LONGIROD', 'Longirod', 'Longirod', '0101000020E61000000000000000001940AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515344, 'MS80', 'NL32-05', NULL, 'LOSONE', 'Losone', 'Losone', '0101000020E61000000000000000802140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515345, 'NS12', 'NL32-05', NULL, 'LOSTALLO', 'Lostallo', 'Lostallo', '0101000020E610000066666666666622406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515346, 'MT24', 'NL32-01', NULL, 'LOSTORF', 'Lostorf', 'Lostorf', '0101000020E6100000CDCCCCCCCCCC1F40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515353, 'MS94', 'NL32-05', NULL, 'LOTTIGNA', 'Lottigna', 'Lottigna', '0101000020E61000006666666666E62140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515354, 'MT02', 'NL32-01', NULL, 'LOTZWIL', 'Lotzwil', 'Lotzwil', '0101000020E61000009578E51F22221F4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515355, 'LS60', 'NL32-04', NULL, 'LOURTIER', 'Lourtier', 'Lourtier', '0101000020E61000009EBA4D1311111D406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515356, 'MS83', 'NL32-05', NULL, 'LOVALD', 'Lovald', 'Lovald', '0101000020E61000000000000000802140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515360, 'PS06', 'NL32-06', NULL, 'LU', 'Lü', 'Lu', '0101000020E61000008210DABCBBBB2440DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515365, 'LS37', 'NL32-04', NULL, 'LUCENS', 'Lucens', 'Lucens', '0101000020E6100000C8AB185355551B40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515374, 'NT00', 'NL32-05', NULL, 'LUCHSINGEN', 'Luchsingen', 'Luchsingen', '0101000020E61000004BBCF20F11112240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515375, 'MS94', 'NL32-05', NULL, 'LUDIANO', 'Ludiano', 'Ludiano', '0101000020E6100000B5430DF0EEEE214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515378, 'MR99', 'NL32-05', 3, 'LUGANO', 'Lugano', 'Lugano', '0101000020E6100000B5430DF0EEEE21400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515383, 'LS39', 'NL32-04', NULL, 'LULLY', 'Lully', 'Lully', '0101000020E6100000C8AB185355551B40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515384, 'NS16', 'NL32-05', NULL, 'LUMBREIN', 'Lumbrein', 'Lumbrein', '0101000020E61000007EEF25434444224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515386, 'NS01', 'NL32-05', NULL, 'LUMINO', 'Lumino', 'Lumino', '0101000020E6100000E976402322222240ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515389, 'MS38', 'NL32-05', NULL, 'LUNGERN', 'Lungern', 'Lungern', '0101000020E61000001CAA7356555520406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515394, 'NS16', 'NL32-05', NULL, 'LUNSCHANIA', 'Lunschania', 'Lunschania', '0101000020E61000001CAA73565555224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515395, 'LS69', 'NL32-04', NULL, 'LURTIGEN', 'Lurtigen', 'Lurtigen', '0101000020E61000003854E7ACAAAA1C4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515397, 'MT51', 'NL32-02', NULL, 'LUTERBACH', 'Luterbach', 'Luterbach', '0101000020E61000006666666666E62040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515398, 'LT93', 'NL32-01', NULL, 'LUTERBACH', 'Luterbach', 'Luterbach', '0101000020E6100000C8AB185355551E40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515399, 'MT11', 'NL32-01', NULL, 'LUTHERN', 'Luthern', 'Luthern', '0101000020E61000003854E7ACAAAA1F40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515400, 'NT04', 'NL32-02', NULL, 'LUTISBURG', 'Lütisburg', 'Lutisburg', '0101000020E6100000E4558CA9AA2A22403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515403, 'LS25', 'NL32-04', NULL, 'LUTRY', 'Lutry', 'Lutry', '0101000020E6100000CDCCCCCCCCCC1A4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515405, 'MS27', 'NL32-05', NULL, 'LUTSCHENTAL', 'Lütschental', 'Lutschental', '0101000020E61000004BBCF20F111120409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515406, 'MS16', 'NL32-04', NULL, 'LUTSCHENTHAL', 'Lütschenthal', 'Lutschenthal', '0101000020E61000002F127FB9BBBB1F40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515410, 'LT90', 'NL32-01', NULL, 'LUTZELFLUH', 'Lützelflüh', 'Lutzelfluh', '0101000020E61000002F127FB9BBBB1E4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515412, 'NS17', 'NL32-05', NULL, 'LUVIS', 'Luvis', 'Luvis', '0101000020E61000001789BFDCDD5D224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515413, 'NS59', 'NL32-05', NULL, 'LUZEIN', 'Luzein', 'Luzein', '0101000020E6100000000000000080234087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515415, 'MT41', 'NL32-02', 2, 'LUZERN', 'Luzern', 'Luzern', '0101000020E61000004FDDA68988882040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515419, 'NT30', 'NL32-02', NULL, 'LUZIENSTEIG', 'Luziensteig', 'Luziensteig', '0101000020E61000004FDDA6898808234013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515420, 'LT71', 'NL32-01', NULL, 'LYSS', 'Lyss', 'Lyss', '0101000020E61000003333333333331D40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515421, 'LT91', 'NL32-01', NULL, 'LYSSACH', 'Lyssach', 'Lyssach', '0101000020E6100000C8AB185355551E40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515425, 'MT02', 'NL32-01', NULL, 'MADISWIL', 'Madiswil', 'Madiswil', '0101000020E61000009578E51F22221F4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515431, 'NS04', 'NL32-05', NULL, 'MADRA', 'Madra', 'Madra', '0101000020E61000009A9999999919224046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515434, 'NS75', 'NL32-05', NULL, 'MADULEIN', 'Madulein', 'Madulein', '0101000020E61000001789BFDCDDDD2340791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515435, 'MS81', 'NL32-05', NULL, 'MAGADINO', 'Magadino', 'Magadino', '0101000020E61000008210DABCBBBB21403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515437, 'MT06', 'NL32-01', NULL, 'MAGDEN', 'Magden', 'Magden', '0101000020E61000003333333333331F4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515438, 'NT14', 'NL32-02', NULL, 'MAGDENAU', 'Magdenau', 'Magdenau', '0101000020E61000001CAA7356555522403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515441, 'MS72', 'NL32-05', NULL, 'MAGGIA', 'Maggia', 'Maggia', '0101000020E610000066666666666621400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515450, 'LT62', 'NL32-01', NULL, 'MAGGLINGEN', 'Magglingen', 'Magglingen', '0101000020E61000006B871AE0DDDD1C403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515451, 'MR89', 'NL32-08', NULL, 'MAGLIASINA', 'Magliasina', 'Magliasina', '0101000020E61000008210DABCBBBB2140ED5003BCBBFB4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515454, 'LS61', 'NL32-04', NULL, 'MAGNOT', 'Magnot', 'Magnot', '0101000020E61000009EBA4D1311111D40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515455, 'NT40', 'NL32-02', NULL, 'MAIENFELD', 'Maienfeld', 'Maienfeld', '0101000020E61000004BBCF20F1111234054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515457, 'MT16', 'NL32-01', NULL, 'MAISPRACH', 'Maisprach', 'Maisprach', '0101000020E6100000C8AB185355551F4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515459, 'NS48', 'NL32-05', NULL, 'MALADERS', 'Maladers', 'Maladers', '0101000020E61000009A99999999192340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515460, 'NT40', 'NL32-05', NULL, 'MALANS', 'Malans', 'Malans', '0101000020E6100000E976402322222340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515462, 'NS48', 'NL32-05', NULL, 'MALIX', 'Malix', 'Malix', '0101000020E61000004BBCF20F111123406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515463, 'LT63', 'NL32-01', NULL, 'MALLERAY', 'Malleray', 'Malleray', '0101000020E61000009EBA4D1311111D40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515464, 'NS45', 'NL32-05', NULL, 'MALMIGIUER', 'Malmigiuer', 'Malmigiuer', '0101000020E6100000E976402322222340791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515468, 'NS53', 'NL32-05', NULL, 'MALOJA', 'Maloja', 'Maloja', '0101000020E610000066666666666623403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515471, 'MT30', 'NL32-02', NULL, 'MALTERS', 'Malters', 'Malters', '0101000020E61000001789BFDCDD5D204013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515472, 'MS93', 'NL32-05', NULL, 'MALVAGLIA', 'Malvaglia', 'Malvaglia', '0101000020E6100000B122597677F721403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515473, 'MT97', 'NL32-02', NULL, 'MAMMERN', 'Mammern', 'Mammern', '0101000020E61000001CAA735655D521403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515474, 'PS08', 'NL32-06', NULL, 'MANAS', 'Manas', 'Manas', '0101000020E61000008210DABCBBBB2440CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515475, 'MT73', 'NL32-02', NULL, 'MANNEDORF', 'Männedorf', 'Mannedorf', '0101000020E61000001789BFDCDD5D21400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515476, 'LS48', 'NL32-04', NULL, 'MANNENS', 'Mannens', 'Mannens', '0101000020E61000006B871AE0DDDD1B406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515478, 'MR99', 'NL32-05', NULL, 'MANNO', 'Manno', 'Manno', '0101000020E6100000CDCCCCCCCCCC214013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515479, 'LS75', 'NL32-04', NULL, 'MANNRIED', 'Mannried', 'Mannried', '0101000020E6100000FCDE4B8688881D40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515480, 'LS35', 'NL32-04', NULL, 'MARACON', 'Maracon', 'Maracon', '0101000020E61000000421B47977771B406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515481, 'MS18', 'NL32-04', NULL, 'MARBACH', 'Marbach', 'Marbach', '0101000020E6100000FCDE4B8688881F40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515484, 'KS85', 'NL32-04', NULL, 'MARCHISSY', 'Marchissy', 'Marchissy', '0101000020E61000006245B2ECEEEE1840AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515486, 'LT85', 'NL32-01', NULL, 'MARIASTEIN', 'Mariastein', 'Mariastein', '0101000020E61000009EBA4D1311111E40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515487, 'LT40', 'NL32-01', NULL, 'MARIN', 'Marin', 'Marin', '0101000020E61000000000000000001C4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515491, 'LS58', 'NL32-04', NULL, 'MARLYLEGRAND', 'Marly-le-Grand', 'Marly-le-Grand', '0101000020E61000009A99999999991C4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515493, 'NS44', 'NL32-05', NULL, 'MARMORERA', 'Marmorera', 'Marmorera', '0101000020E6100000CDCCCCCCCC4C2340AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515494, 'MR98', 'NL32-08', NULL, 'MAROGGIA', 'Maroggia', 'Maroggia', '0101000020E6100000B122597677F7214087EA9C5555F54640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515495, 'LS56', 'NL32-04', NULL, 'MARSENS', 'Marsens', 'Marsens', '0101000020E6100000D1ED804644441C403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515496, 'NT07', 'NL32-02', NULL, 'MARSTETTEN', 'Märstetten', 'Marstetten', '0101000020E6100000E976402322222240CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515498, 'MT77', 'NL32-02', NULL, 'MARTHALEN', 'Marthalen', 'Marthalen', '0101000020E6100000CDCCCCCCCC4C2140218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515501, 'LS50', 'NL32-04', NULL, 'MARTIGNYBOURG', 'Martigny-Bourg', 'Martigny-Bourg', '0101000020E6100000C8AB185355551C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515502, 'LS50', 'NL32-04', NULL, 'MARTIGNYCOMBE', 'Martigny-Combe', 'Martigny-Combe', '0101000020E6100000C8AB185355551C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515503, 'LS50', 'NL32-04', NULL, 'MARTIGNYCROIX', 'Martigny-Croix', 'Martigny-Croix', '0101000020E61000006666666666661C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515504, 'LS50', 'NL32-04', NULL, 'MARTIGNYVILLE', 'Martigny-Ville', 'Martigny-Ville', '0101000020E6100000C8AB185355551C40CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515506, 'PS19', 'NL32-06', NULL, 'MARTINSBRUCK', 'Martinsbruck', 'Martinsbruck', '0101000020E6100000B5430DF0EEEE2440DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515507, 'NT06', 'NL32-02', NULL, 'MARWIL', 'Märwil', 'Marwil', '0101000020E6100000E4558CA9AA2A224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515508, 'LT80', 'NL32-04', NULL, 'MARZILI', 'Marzili', 'Marzili', '0101000020E61000002F127FB9BBBB1D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515509, 'NS49', 'NL32-05', NULL, 'MASANS', 'Masans', 'Masans', '0101000020E61000004BBCF20F11112340DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515510, 'NS57', 'NL32-05', NULL, 'MASCHENBODEN', 'Mäschenboden', 'Maschenboden', '0101000020E61000004BBCF20F1191234046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515511, 'MT53', 'NL32-02', NULL, 'MASCHWANDEN', 'Maschwanden', 'Maschwanden', '0101000020E61000001CAA735655D52040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515512, 'LS71', 'NL32-04', NULL, 'MASE', 'Mase', 'Mase', '0101000020E61000002F127FB9BBBB1D4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515514, 'MR99', 'NL32-05', NULL, 'MASSAGNO', 'Massagno', 'Massagno', '0101000020E61000006666666666E6214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515515, 'NT40', 'NL32-05', NULL, 'MASTRILS', 'Mastrils', 'Mastrils', '0101000020E61000004BBCF20F11112340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515516, 'LS52', 'NL32-04', NULL, 'MATELON', 'Matélon', 'Matelon', '0101000020E61000006666666666661C4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515517, 'NS36', 'NL32-05', NULL, 'MATHON', 'Mathon', 'Mathon', '0101000020E6100000CDCCCCCCCCCC2240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515518, 'NT10', 'NL32-05', NULL, 'MATT', 'Matt', 'Matt', '0101000020E61000001CAA735655552240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515519, 'LT80', 'NL32-04', NULL, 'MATTE', 'Matte', 'Matte', '0101000020E6100000CDCCCCCCCCCC1D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515520, 'MS65', 'NL32-05', NULL, 'MATTELI', 'Mätteli', 'Matteli', '0101000020E61000004BBCF20F11112140791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515521, 'LS74', 'NL32-04', NULL, 'MATTEN', 'Matten', 'Matten', '0101000020E61000003854E7ACAAAA1D40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515522, 'MS16', 'NL32-04', NULL, 'MATTEN', 'Matten', 'Matten', '0101000020E61000000421B47977771F4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515524, 'LS89', 'NL32-04', NULL, 'MATTENHOF', 'Mattenhof', 'Mattenhof', '0101000020E61000002F127FB9BBBB1D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515533, 'LT93', 'NL32-01', NULL, 'MATZENDORF', 'Matzendorf', 'Matzendorf', '0101000020E61000000421B47977771E406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515534, 'LS79', 'NL32-04', NULL, 'MATZENRIED', 'Matzenried', 'Matzenried', '0101000020E6100000C8AB185355551D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515535, 'MT96', 'NL32-02', NULL, 'MATZINGEN', 'Matzingen', 'Matzingen', '0101000020E61000001789BFDCDDDD214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515536, 'LS19', 'NL32-04', NULL, 'MAUBORGET', 'Mauborget', 'Mauborget', '0101000020E61000000421B47977771A40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515538, 'MT22', 'NL32-02', NULL, 'MAUENSEE', 'Mauensee', 'Mauensee', '0101000020E6100000E97640232222204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515539, 'MT74', 'NL32-02', NULL, 'MAUR', 'Maur', 'Maur', '0101000020E61000001CAA735655552140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515540, 'MS07', 'NL32-04', NULL, 'MAUREN', 'Mauren', 'Mauren', '0101000020E61000003333333333331F409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515541, 'LR79', 'NL32-04', NULL, 'MAUVOISIN', 'Mauvoisin', 'Mauvoisin', '0101000020E6100000C8AB185355551D400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515545, 'LS91', 'NL32-04', NULL, 'MAYOUX', 'Mayoux', 'Mayoux', '0101000020E6100000C8AB185355551E40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515547, 'MS90', 'NL32-05', NULL, 'MEDEGLIA', 'Medeglia', 'Medeglia', '0101000020E61000001789BFDCDDDD2140218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515551, 'MS86', 'NL32-05', NULL, 'MEDELS', 'Medels', 'Medels', '0101000020E61000003333333333B3214087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515554, 'NS25', 'NL32-05', NULL, 'MEDELSIMRHEINWALD', 'Medels im Rheinwald', 'Medels im Rheinwald', '0101000020E61000004BBCF20F1191224013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515556, 'NS58', 'NL32-05', NULL, 'MEDERGEN', 'Medergen', 'Medergen', '0101000020E6100000B1225976777723406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515557, 'MT51', 'NL32-02', NULL, 'MEGGEN', 'Meggen', 'Meggen', '0101000020E61000007EEF254344C420406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515561, 'NS07', 'NL32-05', NULL, 'MEIERHOF', 'Meierhof', 'Meierhof', '0101000020E610000033333333333322400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515562, 'MT51', 'NL32-02', NULL, 'MEIERSKAPPEL', 'Meierskappel', 'Meierskappel', '0101000020E61000001789BFDCDDDD2040218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515563, 'MT73', 'NL32-02', NULL, 'MEILEN', 'Meilen', 'Meilen', '0101000020E61000007EEF25434444214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48736, 'KS82', 'NL32-04', NULL, 'MEINIER', 'Meinier', 'Meinier', '0101000020E61000006245B2ECEEEE1840AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515565, 'LT72', 'NL32-01', NULL, 'MEINISBERG', 'Meinisberg', 'Meinisberg', '0101000020E61000006666666666661D4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515566, 'MS37', 'NL32-05', NULL, 'MEIRINGEN', 'Meiringen', 'Meiringen', '0101000020E61000001789BFDCDD5D2040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515567, 'MT43', 'NL32-02', NULL, 'MEISTERSCHWANDEN', 'Meisterschwanden', 'Meisterschwanden', '0101000020E6100000B1225976777720406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515570, 'NR08', 'NL32-08', NULL, 'MELANO', 'Melano', 'Melano', '0101000020E6100000000000000000224046E22F7777F74640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515571, 'MT12', 'NL32-01', NULL, 'MELCHNAU', 'Melchnau', 'Melchnau', '0101000020E6100000C8AB185355551F4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515572, 'MS48', 'NL32-05', NULL, 'MELCHTAL', 'Melchtal', 'Melchtal', '0101000020E61000004BBCF20F11912040CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515574, 'NS01', 'NL32-05', NULL, 'MELERA', 'Melera', 'Melera', '0101000020E6100000E4558CA9AA2A224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515580, 'MR98', 'NL32-08', NULL, 'MELIDE', 'Melide', 'Melide', '0101000020E61000006666666666E621409A99999999F94640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515581, 'MT45', 'NL32-02', NULL, 'MELLINGEN', 'Mellingen', 'Mellingen', '0101000020E61000004FDDA6898888204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515582, 'NT31', 'NL32-02', NULL, 'MELS', 'Mels', 'Mels', '0101000020E61000001CAA735655D522406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515583, 'MR97', 'NL32-08', NULL, 'MENDRISIO', 'Mendrisio', 'Mendrisio', '0101000020E6100000B122597677F72140218436EFEEEE4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515586, 'MT33', 'NL32-02', NULL, 'MENZIKEN', 'Menziken', 'Menziken', '0101000020E61000001789BFDCDD5D20400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515587, 'MT62', 'NL32-02', NULL, 'MENZINGEN', 'Menzingen', 'Menzingen', '0101000020E6100000E4558CA9AA2A214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515588, 'MT21', 'NL32-02', NULL, 'MENZNAU', 'Menznau', 'Menznau', '0101000020E61000004BBCF20F11112040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515593, 'LS82', 'NL32-04', NULL, 'MERDESSONNET', 'Merdessonnet', 'Merdessonnet', '0101000020E61000006B871AE0DDDD1D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515594, 'MT53', 'NL32-02', NULL, 'MERENSCHWAND', 'Merenschwand', 'Merenschwand', '0101000020E61000008210DABCBBBB20400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515595, 'MS81', 'NL32-05', NULL, 'MERGOSCIA', 'Mergoscia', 'Mergoscia', '0101000020E61000003333333333B321409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515596, 'MR98', 'NL32-08', NULL, 'MERIDE', 'Meride', 'Meride', '0101000020E61000006666666666E621403333333333F34640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515597, 'MT78', 'NL32-02', NULL, 'MERISHAUSEN', 'Merishausen', 'Merishausen', '0101000020E610000033333333333321400000000000E04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515598, 'MS07', 'NL32-04', NULL, 'MERLIGEN', 'Merligen', 'Merligen', '0101000020E61000006245B2ECEEEE1E409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515600, 'LT84', 'NL32-01', NULL, 'MERVELIER', 'Mervelier', 'Mervelier', '0101000020E61000006245B2ECEEEE1D40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515603, 'NS13', 'NL32-05', NULL, 'MESOCCO', 'Mesocco', 'Mesocco', '0101000020E6100000B122597677772240DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515606, 'LT81', 'NL32-01', NULL, 'MESSEN', 'Messen', 'Messen', '0101000020E6100000CDCCCCCCCCCC1D40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515607, 'LS95', 'NL32-04', NULL, 'METSCH', 'Metsch', 'Metsch', '0101000020E61000000421B47977771E400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515608, 'MT96', 'NL32-02', NULL, 'METTENDORF', 'Mettendorf', 'Mettendorf', '0101000020E6100000B5430DF0EEEE2140BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515609, 'NT06', 'NL32-02', NULL, 'METTLEN', 'Mettlen', 'Mettlen', '0101000020E61000008210DABCBB3B224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515610, 'MT53', 'NL32-02', NULL, 'METTMENSTETTEN', 'Mettmenstetten', 'Mettmenstetten', '0101000020E6100000B5430DF0EEEE20400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515611, 'LT85', 'NL32-01', NULL, 'METZERLEN', 'Metzerlen', 'Metzerlen', '0101000020E61000006B871AE0DDDD1D409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515612, 'LS41', 'NL32-04', NULL, 'MEX', 'Mex', 'Mex', '0101000020E61000006245B2ECEEEE1B4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515613, 'KS72', 'NL32-04', NULL, 'MEYRIN', 'Meyrin', 'Meyrin', '0101000020E6100000D1ED804644441840ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515614, 'LS47', 'NL32-04', NULL, 'MEZIERES', 'Mézières', 'Mezieres', '0101000020E61000002F127FB9BBBB1B4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515615, 'MS90', 'NL32-05', NULL, 'MEZZOVICO', 'Mezzovico', 'Mezzovico', '0101000020E61000001CAA735655D52140791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515618, 'LT65', 'NL32-01', NULL, 'MIECOURT', 'Miécourt', 'Miecourt', '0101000020E61000002F127FB9BBBB1C4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515619, 'LS83', 'NL32-04', NULL, 'MIEGE', 'Miège', 'Miege', '0101000020E61000003333333333331E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515620, 'LS41', 'NL32-04', NULL, 'MIEVILLE', 'Miéville', 'Mieville', '0101000020E61000009578E51F22221C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515621, 'MR89', 'NL32-05', NULL, 'MIGLIEGLIA', 'Miglieglia', 'Miglieglia', '0101000020E61000003333333333B3214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515622, 'LS93', 'NL32-04', NULL, 'MILIUT', 'Miliüt', 'Miliut', '0101000020E61000000421B47977771E40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515623, 'MS81', 'NL32-05', NULL, 'MINUSIO', 'Minusio', 'Minusio', '0101000020E6100000E976402322A2214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515625, 'NS82', 'NL32-06', NULL, 'MIRALAGO', 'Miralago', 'Miralago', '0101000020E6100000333333333333244013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515630, 'LS95', 'NL32-04', NULL, 'MITHOLZ', 'Mitholz', 'Mitholz', '0101000020E61000003854E7ACAAAA1E4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515632, 'MS38', 'NL32-05', NULL, 'MITTELARNI', 'Mittel Arni', 'Mittel Arni', '0101000020E6100000E4558CA9AA2A20406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515636, 'MS03', 'NL32-04', NULL, 'MITTHAL', 'Mitthal', 'Mitthal', '0101000020E61000000000000000001F40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515639, 'NT60', 'NL32-02', NULL, 'MITTLERSASS', 'Mittlersass', 'Mittlersass', '0101000020E6100000E4558CA9AAAA23400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515641, 'NT04', 'NL32-02', NULL, 'MOGELSBERG', 'Mogelsberg', 'Mogelsberg', '0101000020E61000008210DABCBB3B2240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515642, 'MS72', 'NL32-05', NULL, 'MOGHEGNO', 'Moghegno', 'Moghegno', '0101000020E61000001789BFDCDD5D2140AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515643, 'MS74', 'NL32-05', NULL, 'MOGNO', 'Mogno', 'Mogno', '0101000020E61000001CAA73565555214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515644, 'MT16', 'NL32-01', NULL, 'MOHLIN', 'Möhlin', 'Mohlin', '0101000020E61000006666666666661F406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515647, 'MS38', 'NL32-05', NULL, 'MOHRLIALP', 'Möhrlialp', 'Mohrlialp', '0101000020E61000008210DABCBB3B2040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515651, 'MS92', 'NL32-05', NULL, 'MOLENO', 'Moleno', 'Moleno', '0101000020E6100000B122597677F7214054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515655, 'KS96', 'NL32-04', NULL, 'MOLLENS', 'Mollens', 'Mollens', '0101000020E61000000421B47977771940791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515656, 'LS46', 'NL32-04', NULL, 'MOLLETTES', 'Mollettes', 'Mollettes', '0101000020E61000009EBA4D1311111C40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515657, 'NT01', 'NL32-02', NULL, 'MOLLIS', 'Mollis', 'Mollis', '0101000020E6100000E4558CA9AA2A2240791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515658, 'NT21', 'NL32-02', NULL, 'MOLS', 'Mols', 'Mols', '0101000020E61000004BBCF20F11912240CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515659, 'MS86', 'NL32-05', NULL, 'MOMPETAVETSCH', 'Mompetavetsch', 'Mompetavetsch', '0101000020E6100000E4558CA9AAAA214046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515662, 'NS69', 'NL32-05', NULL, 'MONBIEL', 'Monbiel', 'Monbiel', '0101000020E61000001CAA735655D52340218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515664, 'MT74', 'NL32-02', NULL, 'MONCHALTORF', 'Mönchaltorf', 'Monchaltorf', '0101000020E6100000B5430DF0EE6E2140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515665, 'NS46', 'NL32-05', NULL, 'MONS', 'Mons', 'Mons', '0101000020E61000009A999999991923403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515666, 'NS57', 'NL32-05', NULL, 'MONSTEIN', 'Monstein', 'Monstein', '0101000020E61000004FDDA689888823409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515667, 'LS15', 'NL32-04', NULL, 'MONTAGIBERT', 'Montagibert', 'Montagibert', '0101000020E6100000FCDE4B8688881A4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515668, 'MR99', 'NL32-08', NULL, 'MONTAGNOLA', 'Montagnola', 'Montagnola', '0101000020E61000001CAA735655D52140AC4896DDDDFD4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515669, 'LS51', 'NL32-04', NULL, 'MONTAGNON', 'Montagnon', 'Montagnon', '0101000020E61000003854E7ACAAAA1C4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515670, 'LS18', 'NL32-04', NULL, 'MONTAGNY', 'Montagny', 'Montagny', '0101000020E61000000421B47977771A4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515672, 'LS48', 'NL32-04', NULL, 'MONTAGNYLAVILLE', 'Montagny-la-Ville', 'Montagny-la-Ville', '0101000020E61000006245B2ECEEEE1B40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515673, 'LS82', 'NL32-04', NULL, 'MONTANA', 'Montana', 'Montana', '0101000020E61000006B871AE0DDDD1D406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515675, 'LS82', 'NL32-04', NULL, 'MONTANAVILLAGE', 'Montana-Village', 'Montana-Village', '0101000020E61000000000000000001E406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515680, 'LS54', 'NL32-04', NULL, 'MONTBOVON', 'Montbovon', 'Montbovon', '0101000020E61000003333333333331C40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515682, 'LS17', 'NL32-04', NULL, 'MONTCHERAND', 'Montcherand', 'Montcherand', '0101000020E61000009EBA4D1311111A40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515683, 'MS75', 'NL32-05', NULL, 'MONTE', 'Monte', 'Monte', '0101000020E61000007EEF2543444421406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515688, 'NS01', 'NL32-05', NULL, 'MONTECARASSO', 'Monte Carasso', 'Monte Carasso', '0101000020E6100000000000000000224046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515690, 'MS90', 'NL32-05', NULL, 'MONTECENERI', 'Monte Ceneri', 'Monte Ceneri', '0101000020E61000007EEF254344C42140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515699, 'LT53', 'NL32-01', NULL, 'MONTFAUCON', 'Montfaucon', 'Montfaucon', '0101000020E6100000D1ED804644441C4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515700, 'LS42', 'NL32-04', NULL, 'MONTHEY', 'Monthey', 'Monthey', '0101000020E6100000CDCCCCCCCCCC1B400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515703, 'MS81', 'NL32-05', NULL, 'MONTIDELLATRINITA', 'Monti della Trinità', 'Monti della Trinita', '0101000020E61000004BBCF20F1191214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515704, 'NS01', 'NL32-05', NULL, 'MONTIDICO', 'Monti di Cò', 'Monti di Co', '0101000020E6100000E4558CA9AA2A22409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515705, 'NS11', 'NL32-05', NULL, 'MONTIDILANES', 'Monti di Lanés', 'Monti di Lanes', '0101000020E61000001CAA735655552240ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515707, 'MS91', 'NL32-05', NULL, 'MONTIDIODRO', 'Monti di Odro', 'Monti di Odro', '0101000020E61000007EEF254344C42140AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515708, 'MS90', 'NL32-05', NULL, 'MONTIDIPIANTURINO', 'Monti di Pianturino', 'Monti di Pianturino', '0101000020E61000006666666666E62140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515711, 'LT56', 'NL32-01', NULL, 'MONTIGNEZ', 'Montignez', 'Montignez', '0101000020E61000003333333333331C40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515713, 'NS01', 'NL32-05', NULL, 'MONTIMONEDA', 'Monti Moneda', 'Monti Moneda', '0101000020E6100000E97640232222224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515715, 'NS01', 'NL32-05', NULL, 'MONTIRUSCADA', 'Monti Ruscada', 'Monti Ruscada', '0101000020E6100000333333333333224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515716, 'NS11', 'NL32-05', NULL, 'MONTIVIFF', 'Monti Viff', 'Monti Viff', '0101000020E61000007EEF254344442240ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515717, 'LS06', 'NL32-04', NULL, 'MONTLAVILLE', 'Mont-la-Ville', 'Mont-la-Ville', '0101000020E61000003854E7ACAAAA1940DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515720, 'LS34', 'NL32-04', 4, 'MONTREUX', 'Montreux', 'Montreux', '0101000020E61000003854E7ACAAAA1B4046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515721, 'KS96', 'NL32-04', NULL, 'MONTRICHER', 'Montricher', 'Montricher', '0101000020E6100000FCDE4B8688881940CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515722, 'KS94', 'NL32-04', NULL, 'MONTSURROLLE', 'Mont-sur-Rolle', 'Mont-sur-Rolle', '0101000020E6100000C8AB185355551940ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515723, 'MT23', 'NL32-02', NULL, 'MOOSLEERAU', 'Moosleerau', 'Moosleerau', '0101000020E61000009A9999999919204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515728, 'NR07', 'NL32-08', NULL, 'MORBIOINFERIORE', 'Morbio Inferiore', 'Morbio Inferiore', '0101000020E61000004BBCF20F11112240CDCCCCCCCCEC4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515729, 'NR07', 'NL32-08', NULL, 'MORBIOSUPERIORE', 'Morbio Superiore', 'Morbio Superiore', '0101000020E61000004BBCF20F11112240218436EFEEEE4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515731, 'LS42', 'NL32-04', NULL, 'MORCLES', 'Morcles', 'Morcles', '0101000020E61000009578E51F22221C40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515733, 'MR98', 'NL32-08', NULL, 'MORCOTE', 'Morcote', 'Morcote', '0101000020E61000001CAA735655D5214087EA9C5555F54640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515734, 'MS23', 'NL32-05', NULL, 'MOREL', 'Mörel', 'Morel', '0101000020E61000004BBCF20F11112040218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515735, 'LS39', 'NL32-04', NULL, 'MORENS', 'Morens', 'Morens', '0101000020E61000009A99999999991B40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515736, 'MT71', 'NL32-02', NULL, 'MORGARTEN', 'Morgarten', 'Morgarten', '0101000020E61000008210DABCBB3B2140CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515738, 'LS05', 'NL32-04', NULL, 'MORGES', 'Morges', 'Morges', '0101000020E61000000000000000001A4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515739, 'LS87', 'NL32-04', NULL, 'MORGETEN', 'Morgeten', 'Morgeten', '0101000020E61000002F127FB9BBBB1D4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515741, 'LS32', 'NL32-04', NULL, 'MORGINS', 'Morgins', 'Morgins', '0101000020E61000006666666666661B40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515745, 'LT61', 'NL32-01', NULL, 'MORIGEN', 'Mörigen', 'Morigen', '0101000020E61000006B871AE0DDDD1C40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515746, 'MT35', 'NL32-02', NULL, 'MORIKEN', 'Möriken', 'Moriken', '0101000020E61000001789BFDCDD5D204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515748, 'NS17', 'NL32-05', NULL, 'MORISSEN', 'Morissen', 'Morissen', '0101000020E61000001789BFDCDD5D2240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515751, 'MT70', 'NL32-05', NULL, 'MORSCHACH', 'Morschach', 'Morschach', '0101000020E61000007EEF254344442140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515752, 'NT35', 'NL32-02', NULL, 'MORSCHWIL', 'Mörschwil', 'Morschwil', '0101000020E61000001CAA735655D52240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515753, 'NS74', 'NL32-05', NULL, 'MORTERATSCH', 'Morteratsch', 'Morteratsch', '0101000020E61000001789BFDCDDDD23409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515757, 'MS81', 'NL32-05', NULL, 'MOSCIA', 'Moscia', 'Moscia', '0101000020E610000000000000008021403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515758, 'NT04', 'NL32-02', NULL, 'MOSNANG', 'Mosnang', 'Mosnang', '0101000020E61000004BBCF20F11112240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515759, 'MS71', 'NL32-05', NULL, 'MOSOGNO', 'Mosogno', 'Mosogno', '0101000020E61000007EEF25434444214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515761, 'LS19', 'NL32-04', NULL, 'MOTIERS', 'Môtiers', 'Motiers', '0101000020E61000006666666666661A4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515762, 'LS70', 'NL32-04', NULL, 'MOTOT', 'Motôt', 'Motot', '0101000020E61000009A99999999991D40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515763, 'MS94', 'NL32-05', NULL, 'MOTTO', 'Motto', 'Motto', '0101000020E6100000B122597677F7214046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515764, 'LS37', 'NL32-04', NULL, 'MOUDON', 'Moudon', 'Moudon', '0101000020E61000003333333333331B4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515765, 'LT73', 'NL32-01', NULL, 'MOUTIER', 'Moutier', 'Moutier', '0101000020E61000000421B47977771D4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515766, 'LT75', 'NL32-01', NULL, 'MOVELIER', 'Movelier', 'Movelier', '0101000020E61000003333333333331D4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515767, 'MR99', 'NL32-05', NULL, 'MUGENA', 'Mugena', 'Mugena', '0101000020E61000007EEF254344C421406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515768, 'NR08', 'NL32-08', NULL, 'MUGGIO', 'Muggio', 'Muggio', '0101000020E61000009A999999991922403333333333F34640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515769, 'MT24', 'NL32-02', NULL, 'MUHEN', 'Muhen', 'Muhen', '0101000020E61000009A99999999192040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515770, 'MT53', 'NL32-02', NULL, 'MUHLAU', 'Mühlau', 'Muhlau', '0101000020E61000007EEF254344C42040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515771, 'MS34', 'NL32-05', NULL, 'MUHLEBACH', 'Mühlebach', 'Muhlebach', '0101000020E61000001CAA73565555204087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515772, 'LT60', 'NL32-04', NULL, 'MUHLEBERG', 'Mühleberg', 'Muhleberg', '0101000020E61000000000000000001D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515773, 'NT11', 'NL32-02', NULL, 'MUHLEHORN', 'Mühlehorn', 'Muhlehorn', '0101000020E61000001CAA735655552240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515774, 'NS45', 'NL32-05', NULL, 'MUHLEN', 'Mühlen', 'Muhlen', '0101000020E61000008210DABCBB3B234054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515775, 'LS88', 'NL32-04', NULL, 'MUHLETHURNEN', 'Mühlethurnen', 'Muhlethurnen', '0101000020E61000000000000000001E40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515776, 'MT94', 'NL32-02', NULL, 'MUHLRUTI', 'Mühlrüti', 'Muhlruti', '0101000020E6100000B122597677F72140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515777, 'NS37', 'NL32-05', NULL, 'MULDAIN', 'Muldain', 'Muldain', '0101000020E61000004FDDA689880823409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515779, 'NT07', 'NL32-02', NULL, 'MULLHEIM', 'Müllheim', 'Mullheim', '0101000020E61000000000000000002240CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515780, 'MT04', 'NL32-01', NULL, 'MUMLISWIL', 'Mümliswil', 'Mumliswil', '0101000020E6100000CDCCCCCCCCCC1E40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515781, 'MT16', 'NL32-01', NULL, 'MUMPF', 'Mumpf', 'Mumpf', '0101000020E61000003854E7ACAAAA1F406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515782, 'LT80', 'NL32-01', NULL, 'MUNCHENBUCHSEE', 'Münchenbuchsee', 'Munchenbuchsee', '0101000020E6100000CDCCCCCCCCCC1D4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515783, 'LT96', 'NL32-01', NULL, 'MUNCHENSTEIN', 'Münchenstein', 'Munchenstein', '0101000020E61000000421B47977771E4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515784, 'NT05', 'NL32-02', NULL, 'MUNCHWILEN', 'Münchwilen', 'Munchwilen', '0101000020E610000000000000000022409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515785, 'MS12', 'NL32-04', NULL, 'MUND', 'Mund', 'Mund', '0101000020E61000002F127FB9BBBB1F40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515788, 'LS99', 'NL32-04', NULL, 'MUNSINGEN', 'Münsingen', 'Munsingen', '0101000020E6100000D1ED804644441E40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515789, 'MS44', 'NL32-05', NULL, 'MUNSTER', 'Münster', 'Munster', '0101000020E61000004FDDA68988882040AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515792, 'NT17', 'NL32-02', NULL, 'MUNSTERLINGEN', 'Münsterlingen', 'Munsterlingen', '0101000020E6100000B122597677772240DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515798, 'LT50', 'NL32-01', NULL, 'MUNSTSCHEMIER', 'Münstschemier', 'Munstschemier', '0101000020E6100000FCDE4B8688881C400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515799, 'NS46', 'NL32-05', NULL, 'MUNTER', 'Munter', 'Munter', '0101000020E61000004BBCF20F11112340DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515800, 'NT26', 'NL32-02', NULL, 'MUOLEN', 'Muolen', 'Muolen', '0101000020E6100000E976402322A2224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515803, 'MT80', 'NL32-05', NULL, 'MUOTATHAL', 'Muotathal', 'Muotathal', '0101000020E61000004FDDA68988882140ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515814, 'NT11', 'NL32-02', NULL, 'MURG', 'Murg', 'Murg', '0101000020E6100000B5430DF0EE6E2240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515816, 'MT13', 'NL32-01', NULL, 'MURGENTHAL', 'Murgenthal', 'Murgenthal', '0101000020E6100000D1ED804644441F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515817, 'LS89', 'NL32-04', NULL, 'MURI', 'Muri', 'Muri', '0101000020E61000006245B2ECEEEE1D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515818, 'MT43', 'NL32-02', NULL, 'MURI', 'Muri', 'Muri', '0101000020E6100000E4558CA9AAAA204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515820, 'MS15', 'NL32-04', NULL, 'MURREN', 'Mürren', 'Murren', '0101000020E6100000FCDE4B8688881F40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515821, 'LS59', 'NL32-04', NULL, 'MURTEN', 'Murten', 'Murten', '0101000020E61000000421B47977771C4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515824, 'MS39', 'NL32-05', NULL, 'MUSSEN', 'Müssen', 'Mussen', '0101000020E6100000E4558CA9AA2A2040218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515825, 'PS06', 'NL32-06', NULL, 'MUSTAIR', 'Müstair', 'Mustair', '0101000020E61000001789BFDCDDDD2440DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515827, 'NS36', 'NL32-05', NULL, 'MUTTEN', 'Mutten', 'Mutten', '0101000020E6100000B122597677F7224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515828, 'LT96', 'NL32-01', NULL, 'MUTTENZ', 'Muttenz', 'Muttenz', '0101000020E61000009A99999999991E4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515831, 'MT00', 'NL32-04', NULL, 'MUTZLENBERG', 'Mützlenberg', 'Mutzlenberg', '0101000020E61000006B871AE0DDDD1E40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515836, 'NT01', 'NL32-02', NULL, 'NAFELS', 'Näfels', 'Nafels', '0101000020E6100000E976402322222240CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515837, 'MT74', 'NL32-02', NULL, 'NANIKON', 'Nänikon', 'Nanikon', '0101000020E61000006666666666662140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515843, 'NS36', 'NL32-05', NULL, 'NARGLIESA', 'Nargliesa', 'Nargliesa', '0101000020E61000004FDDA689880823403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515844, 'NS45', 'NL32-05', NULL, 'NASCHAREGNAS', 'Nascharegnas', 'Nascharegnas', '0101000020E610000033333333333323406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515845, 'MS23', 'NL32-04', NULL, 'NATERS', 'Naters', 'Naters', '0101000020E61000006245B2ECEEEE1F40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515852, 'LS72', 'NL32-04', NULL, 'NAX', 'Nax', 'Nax', '0101000020E61000002F127FB9BBBB1D40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515853, 'NS55', 'NL32-05', NULL, 'NAZ', 'Naz', 'Naz', '0101000020E61000004FDDA68988882340791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515854, 'MT22', 'NL32-01', NULL, 'NEBIKON', 'Nebikon', 'Nebikon', '0101000020E61000006B871AE0DDDD1F4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515855, 'NT14', 'NL32-02', NULL, 'NECKER', 'Necker', 'Necker', '0101000020E61000007EEF254344442240CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515856, 'MT76', 'NL32-02', NULL, 'NEFTENBACH', 'Neftenbach', 'Neftenbach', '0101000020E61000001CAA73565555214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515857, 'MS94', 'NL32-05', NULL, 'NEGRENTINO', 'Negrentino', 'Negrentino', '0101000020E61000001789BFDCDDDD2140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515863, 'MS47', 'NL32-05', NULL, 'NESSENTHAL', 'Nessenthal', 'Nessenthal', '0101000020E61000009A99999999992040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515864, 'NT12', 'NL32-02', NULL, 'NESSLAU', 'Nesslau', 'Nesslau', '0101000020E61000006666666666662240ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515866, 'NT01', 'NL32-02', NULL, 'NETSTAL', 'Netstal', 'Netstal', '0101000020E61000009A999999991922406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515869, 'LT40', 'NL32-01', 3, 'NEUCHATEL', 'Neuchâtel', 'Neuchatel', '0101000020E61000006B871AE0DDDD1B400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515873, 'MT32', 'NL32-02', NULL, 'NEUDORF', 'Neudorf', 'Neudorf', '0101000020E6100000666666666666204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515882, 'MT45', 'NL32-02', NULL, 'NEUENHOF', 'Neuenhof', 'Neuenhof', '0101000020E6100000E976402322A220409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515883, 'MT31', 'NL32-02', NULL, 'NEUENKIRCH', 'Neuenkirch', 'Neuenkirch', '0101000020E61000006666666666662040CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515884, 'LT96', 'NL32-01', NULL, 'NEUEWELT', 'Neuewelt', 'Neuewelt', '0101000020E61000000421B47977771E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515885, 'NS38', 'NL32-05', NULL, 'NEUFELSBERG', 'Neu-Felsberg', 'Neu-Felsberg', '0101000020E6100000B122597677F72240CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515886, 'MS07', 'NL32-04', NULL, 'NEUHAUS', 'Neuhaus', 'Neuhaus', '0101000020E6100000D1ED804644441F4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515887, 'MT78', 'NL32-02', NULL, 'NEUHAUSEM', 'Neuhausem', 'Neuhausem', '0101000020E61000008210DABCBB3B214046E22F7777D74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515889, 'MT62', 'NL32-02', NULL, 'NEUHEIM', 'Neuheim', 'Neuheim', '0101000020E6100000E4558CA9AA2A21409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515890, 'NS27', 'NL32-05', NULL, 'NEUKIRCH', 'Neukirch', 'Neukirch', '0101000020E6100000E976402322A22240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515892, 'NT26', 'NL32-02', NULL, 'NEUKIRCH', 'Neukirch', 'Neukirch', '0101000020E61000008210DABCBBBB224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515894, 'NS17', 'NL32-05', NULL, 'NEUKIRCHBEIILANZ', 'Neukirch bei Ilanz', 'Neukirch bei Ilanz', '0101000020E6100000CDCCCCCCCC4C22400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515895, 'MT00', 'NL32-04', NULL, 'NEUMUHLE', 'Neumühle', 'Neumuhle', '0101000020E61000000000000000001F40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515897, 'MT68', 'NL32-02', NULL, 'NEUNKIRCH', 'Neunkirch', 'Neunkirch', '0101000020E610000000000000000021409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515898, 'NT12', 'NL32-02', NULL, 'NEUSANKTJOHANN', 'Neu Sankt Johann', 'Neu Sankt Johann', '0101000020E61000001789BFDCDD5D2240ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515900, 'LS58', 'NL32-04', NULL, 'NEYRUZ', 'Neyruz', 'Neyruz', '0101000020E6100000D1ED804644441C4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515901, 'LT61', 'NL32-01', NULL, 'NIDAU', 'Nidau', 'Nidau', '0101000020E61000006245B2ECEEEE1C40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515904, 'NT00', 'NL32-05', NULL, 'NIDFURN', 'Nidfurn', 'Nidfurn', '0101000020E61000009A99999999192240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515910, 'MT03', 'NL32-01', NULL, 'NIEDERBIPP', 'Niederbipp', 'Niederbipp', '0101000020E61000002F127FB9BBBB1E4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515911, 'MT03', 'NL32-01', NULL, 'NIEDERBUCHSITEN', 'Niederbuchsiten', 'Niederbuchsiten', '0101000020E61000000000000000001F4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515912, 'NT15', 'NL32-02', NULL, 'NIEDERBUREN', 'Niederbüren', 'Niederburen', '0101000020E610000066666666666622409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515913, 'MT25', 'NL32-02', NULL, 'NIEDERERLINSBACH', 'Niedererlinsbach', 'Niedererlinsbach', '0101000020E610000000000000000020403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515914, 'MS03', 'NL32-04', NULL, 'NIEDERGAMPEL', 'Niedergampel', 'Niedergampel', '0101000020E61000006B871AE0DDDD1E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515917, 'MS02', 'NL32-04', NULL, 'NIEDERGESTELN', 'Niedergesteln', 'Niedergesteln', '0101000020E61000009578E51F22221F40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515918, 'MT24', 'NL32-01', NULL, 'NIEDERGOSGEN', 'Niedergösgen', 'Niedergosgen', '0101000020E61000006B871AE0DDDD1F40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515919, 'MT34', 'NL32-02', NULL, 'NIEDERHALLWIL', 'Niederhallwil', 'Niederhallwil', '0101000020E61000001789BFDCDD5D2040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515920, 'NT15', 'NL32-02', NULL, 'NIEDERHELFENSCHWIL', 'Niederhelfenschwil', 'Niederhelfenschwil', '0101000020E61000001789BFDCDD5D2240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515921, 'MT34', 'NL32-02', NULL, 'NIEDERLENZ', 'Niederlenz', 'Niederlenz', '0101000020E61000001789BFDCDD5D20403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515922, 'NS19', 'NL32-05', NULL, 'NIEDERN', 'Niedern', 'Niedern', '0101000020E61000001789BFDCDD5D22403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515923, 'NT00', 'NL32-05', NULL, 'NIEDERNSTAFEL', 'Niedern Stafel', 'Niedern Stafel', '0101000020E6100000E4558CA9AA2A2240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515924, 'MS59', 'NL32-05', NULL, 'NIEDERRICKENBACH', 'Niederrickenbach', 'Niederrickenbach', '0101000020E61000001789BFDCDDDD204087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515925, 'MS17', 'NL32-04', NULL, 'NIEDERRIED', 'Niederried', 'Niederried', '0101000020E61000003854E7ACAAAA1F40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515926, 'MT45', 'NL32-02', NULL, 'NIEDERROHRDORF', 'Niederrohrdorf', 'Niederrohrdorf', '0101000020E61000009A9999999999204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515927, 'LS79', 'NL32-04', NULL, 'NIEDERSCHERLI', 'Niederscherli', 'Niederscherli', '0101000020E6100000FCDE4B8688881D40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515928, 'MT43', 'NL32-02', NULL, 'NIEDERSCHONGAU', 'Nieder-Schongau', 'Nieder-Schongau', '0101000020E6100000000000000080204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515929, 'NT26', 'NL32-02', NULL, 'NIEDERSOMMERI', 'Niedersommeri', 'Niedersommeri', '0101000020E61000004BBCF20F11912240BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515931, 'MS68', 'NL32-05', NULL, 'NIEDERSURENENALP', 'Nieder Surenen Alp', 'Nieder Surenen Alp', '0101000020E6100000B122597677F7204013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515933, 'NT01', 'NL32-02', NULL, 'NIEDERURNEN', 'Niederurnen', 'Niederurnen', '0101000020E61000009A99999999192240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515934, 'NT05', 'NL32-02', NULL, 'NIEDERUZWIL', 'Niederuzwil', 'Niederuzwil', '0101000020E61000008210DABCBB3B224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515935, 'MS34', 'NL32-05', NULL, 'NIEDERWALD', 'Niederwald', 'Niederwald', '0101000020E61000001789BFDCDD5D204046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515936, 'MT56', 'NL32-02', NULL, 'NIEDERWENINGEN', 'Niederweningen', 'Niederweningen', '0101000020E61000008210DABCBBBB204054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515937, 'LS98', 'NL32-04', NULL, 'NIEDERWICHTRACH', 'Niederwichtrach', 'Niederwichtrach', '0101000020E6100000C8AB185355551E40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515943, 'LT51', 'NL32-01', NULL, 'NODS', 'Nods', 'Nods', '0101000020E6100000C8AB185355551C40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515944, 'MT67', 'NL32-02', NULL, 'NOHL', 'Nohl', 'Nohl', '0101000020E6100000333333333333214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515946, 'LT20', 'NL32-04', NULL, 'NOIRAIGUE', 'Noiraigue', 'Noiraigue', '0101000020E61000006245B2ECEEEE1A409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515950, 'NT46', 'NL32-02', NULL, 'NONNENHORN', 'Nonnenhorn', 'Nonnenhorn', '0101000020E61000003333333333332340BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515951, 'NS12', 'NL32-05', NULL, 'NORANTOLA', 'Norantola', 'Norantola', '0101000020E61000001CAA73565555224013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515956, 'LS48', 'NL32-04', NULL, 'NOREAZ', 'Noréaz', 'Noreaz', '0101000020E61000009EBA4D1311111C406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515957, 'MT32', 'NL32-02', NULL, 'NOTTWIL', 'Nottwil', 'Nottwil', '0101000020E61000007EEF254344442040DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515958, 'MR89', 'NL32-05', NULL, 'NOVAGGIO', 'Novaggio', 'Novaggio', '0101000020E61000008210DABCBBBB214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515959, 'LS18', 'NL32-04', NULL, 'NOVALLES', 'Novalles', 'Novalles', '0101000020E61000006666666666661A40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515960, 'MR97', 'NL32-08', NULL, 'NOVAZZANO', 'Novazzano', 'Novazzano', '0101000020E6100000B5430DF0EEEE2140791563AAAAEA4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515961, 'LS61', 'NL32-04', NULL, 'NOVELI', 'Noveli', 'Noveli', '0101000020E6100000D1ED804644441D40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515964, 'NS15', 'NL32-05', NULL, 'NUFENEN', 'Nufenen', 'Nufenen', '0101000020E6100000000000000080224013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515967, 'LT95', 'NL32-01', NULL, 'NUNNINGEN', 'Nunningen', 'Nunningen', '0101000020E61000006666666666661E403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515968, 'MT75', 'NL32-02', NULL, 'NURENSDORF', 'Nürensdorf', 'Nurensdorf', '0101000020E6100000CDCCCCCCCC4C21409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515969, 'MT80', 'NL32-05', NULL, 'NUSCHLAU', 'Nuschlau', 'Nuschlau', '0101000020E61000000000000000802140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515970, 'MT87', 'NL32-02', NULL, 'NUSSBAUMEN', 'Nussbaumen', 'Nussbaumen', '0101000020E6100000E976402322A22140218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515971, 'LS85', 'NL32-04', NULL, 'NYDEGG', 'Nydegg', 'Nydegg', '0101000020E61000006245B2ECEEEE1D406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515972, 'KS84', 'NL32-04', NULL, 'NYON', 'Nyon', 'Nyon', '0101000020E61000000000000000001940DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515974, 'NT26', 'NL32-02', NULL, 'OBERAACH', 'Oberaach', 'Oberaach', '0101000020E61000004FDDA68988882240BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515979, 'NS57', 'NL32-05', NULL, 'OBERALP', 'Oberalp', 'Oberalp', '0101000020E61000004BBCF20F11912340ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515985, 'LS79', 'NL32-04', NULL, 'OBERBALM', 'Oberbalm', 'Oberbalm', '0101000020E61000009A99999999991D40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515988, 'NT04', 'NL32-02', NULL, 'OBERBAZENHEID', 'Ober-Bazenheid', 'Ober-Bazenheid', '0101000020E6100000E9764023222222403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515989, 'NT02', 'NL32-02', NULL, 'OBERBILTEN', 'Ober-Bilten', 'Ober-Bilten', '0101000020E61000004FDDA689880822403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515990, 'LT93', 'NL32-01', NULL, 'OBERBIPP', 'Oberbipp', 'Oberbipp', '0101000020E61000003854E7ACAAAA1E400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515991, 'MT76', 'NL32-02', NULL, 'OBERBUCH', 'Ober-Buch', 'Ober-Buch', '0101000020E61000007EEF2543444421406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515992, 'MT03', 'NL32-01', NULL, 'OBERBUCHSITEN', 'Oberbuchsiten', 'Oberbuchsiten', '0101000020E61000000000000000001F406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515994, 'LT72', 'NL32-01', NULL, 'OBERBUREN', 'Oberbüren', 'Oberburen', '0101000020E6100000FCDE4B8688881D40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515995, 'LT90', 'NL32-01', NULL, 'OBERBURG', 'Oberburg', 'Oberburg', '0101000020E61000000421B47977771E4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515996, 'NS16', 'NL32-05', NULL, 'OBERCASTELS', 'Obercastels', 'Obercastels', '0101000020E61000001CAA73565555224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515997, 'MS18', 'NL32-04', NULL, 'OBERDIESSBACH', 'Oberdiessbach', 'Oberdiessbach', '0101000020E6100000CDCCCCCCCCCC1F40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515998, 'MT50', 'NL32-05', NULL, 'OBERDORF', 'Oberdorf', 'Oberdorf', '0101000020E6100000B5430DF0EEEE2040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3515999, 'LT83', 'NL32-01', NULL, 'OBERDORF', 'Oberdorf', 'Oberdorf', '0101000020E61000000000000000001E40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516000, 'MT05', 'NL32-01', NULL, 'OBERDORF', 'Oberdorf', 'Oberdorf', '0101000020E61000000000000000001F403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516001, 'PT00', 'NL32-06', NULL, 'OBEREALP', 'Obere Alp', 'Obere Alp', '0101000020E6100000CDCCCCCCCCCC2440ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516002, 'NT45', 'NL32-02', NULL, 'OBEREGG', 'Oberegg', 'Oberegg', '0101000020E61000009A9999999919234087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516003, 'MT75', 'NL32-02', NULL, 'OBEREMBRACH', 'Oberembrach', 'Oberembrach', '0101000020E61000008210DABCBB3B2140AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516004, 'LS92', 'NL32-04', NULL, 'OBEREMS', 'Oberems', 'Oberems', '0101000020E6100000CDCCCCCCCCCC1E4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516005, 'MT46', 'NL32-02', NULL, 'OBERENDINGEN', 'Oberendingen', 'Oberendingen', '0101000020E61000004BBCF20F1191204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516007, 'MT54', 'NL32-02', NULL, 'OBERENGSTRINGEN', 'Oberengstringen', 'Oberengstringen', '0101000020E61000006666666666E620403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516008, 'MT24', 'NL32-02', NULL, 'OBERENTFELDEN', 'Oberentfelden', 'Oberentfelden', '0101000020E61000004BBCF20F11112040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516009, 'MT25', 'NL32-02', NULL, 'OBERERLINSBACH', 'Obererlinsbach', 'Obererlinsbach', '0101000020E610000000000000000020403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516011, 'MS27', 'NL32-05', NULL, 'OBERFELD', 'Oberfeld', 'Oberfeld', '0101000020E6100000E4558CA9AA2A2040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516012, 'MS78', 'NL32-05', NULL, 'OBERFELD', 'Oberfeld', 'Oberfeld', '0101000020E61000006666666666662140CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516013, 'LT92', 'NL32-01', NULL, 'OBERGERLAFINGEN', 'Obergerlafingen', 'Obergerlafingen', '0101000020E6100000D1ED804644441E4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516015, 'MS45', 'NL32-05', NULL, 'OBERGESTELN', 'Obergesteln', 'Obergesteln', '0101000020E6100000E976402322A2204054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516016, 'MT65', 'NL32-02', NULL, 'OBERGLATT', 'Oberglatt', 'Oberglatt', '0101000020E61000004FDDA68988082140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516017, 'MT24', 'NL32-01', NULL, 'OBERGOSGEN', 'Obergösgen', 'Obergosgen', '0101000020E6100000CDCCCCCCCCCC1F40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516018, 'LS88', 'NL32-04', NULL, 'OBERGURZELEN', 'Ober Gurzelen', 'Ober Gurzelen', '0101000020E61000009578E51F22221E4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516021, 'MT68', 'NL32-02', NULL, 'OBERHALLAU', 'Oberhallau', 'Oberhallau', '0101000020E6100000B122597677F720409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516022, 'MT65', 'NL32-02', NULL, 'OBERHAUSEN', 'Oberhausen', 'Oberhausen', '0101000020E6100000E97640232222214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516023, 'NT26', 'NL32-02', NULL, 'OBERHEGI', 'Oberhegi', 'Oberhegi', '0101000020E61000008210DABCBBBB224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516024, 'NT04', 'NL32-02', NULL, 'OBERHELFENSCHWIL', 'Oberhelfenschwil', 'Oberhelfenschwil', '0101000020E61000003333333333332240CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516025, 'LS97', 'NL32-04', NULL, 'OBERHOFEN', 'Oberhofen', 'Oberhofen', '0101000020E61000003854E7ACAAAA1E40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516026, 'MS09', 'NL32-04', NULL, 'OBERHOFEN', 'Oberhofen', 'Oberhofen', '0101000020E61000009578E51F22221F403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516028, 'MT36', 'NL32-02', NULL, 'OBERHOFENBEIETZGEN', 'Oberhofen bei Etzgen', 'Oberhofen bei Etzgen', '0101000020E61000007EEF2543444420406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516030, 'MT80', 'NL32-02', NULL, 'OBERIBERG', 'Oberiberg', 'Oberiberg', '0101000020E61000004BBCF20F1191214013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516031, 'MT74', 'NL32-02', NULL, 'OBERILLNAU', 'Ober Illnau', 'Ober Illnau', '0101000020E6100000B5430DF0EE6E21403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516032, 'MT32', 'NL32-02', NULL, 'OBERKIRCH', 'Oberkirch', 'Oberkirch', '0101000020E61000008210DABCBB3B20403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516033, 'MS16', 'NL32-04', NULL, 'OBERLAGER', 'Ober Läger', 'Ober Lager', '0101000020E6100000CDCCCCCCCCCC1F403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516034, 'MS26', 'NL32-05', NULL, 'OBERLAGER', 'Oberläger', 'Oberlager', '0101000020E6100000E4558CA9AA2A204087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516038, 'NS68', 'NL32-05', NULL, 'OBERLARET', 'Ober-Laret', 'Ober-Laret', '0101000020E61000003333333333B32340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516039, 'MT53', 'NL32-02', NULL, 'OBERLUNKHOFEN', 'Oberlunkhofen', 'Oberlunkhofen', '0101000020E61000007EEF254344C420406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516040, 'MS58', 'NL32-05', NULL, 'OBERMATT', 'Obermatt', 'Obermatt', '0101000020E61000007EEF254344C42040CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516041, 'MT87', 'NL32-02', NULL, 'OBERNEUFORN', 'Oberneuforn', 'Oberneuforn', '0101000020E61000004BBCF20F11912140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516043, 'MT02', 'NL32-01', NULL, 'OBERONZ', 'Oberönz', 'Oberonz', '0101000020E6100000CDCCCCCCCCCC1E4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516044, 'LS88', 'NL32-04', NULL, 'OBERPLOTSCH', 'Ober-Plötsch', 'Ober-Plotsch', '0101000020E61000006B871AE0DDDD1D4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516045, 'MT10', 'NL32-04', NULL, 'OBERRAMIS', 'Ober Rämis', 'Ober Ramis', '0101000020E6100000D1ED804644441F40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516046, 'MS59', 'NL32-05', NULL, 'OBERRICKENBACH', 'Oberrickenbach', 'Oberrickenbach', '0101000020E61000001CAA735655D52040DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516047, 'LS84', 'NL32-04', NULL, 'OBERRIED', 'Oberried', 'Oberried', '0101000020E61000006B871AE0DDDD1D4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516048, 'MS17', 'NL32-04', NULL, 'OBERRIED', 'Oberried', 'Oberried', '0101000020E6100000CDCCCCCCCCCC1F40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516050, 'MT63', 'NL32-02', NULL, 'OBERRIEDEN', 'Oberrieden', 'Oberrieden', '0101000020E6100000E97640232222214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516051, 'NT44', 'NL32-02', NULL, 'OBERRIET', 'Oberriet', 'Oberriet', '0101000020E6100000E976402322222340BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516052, 'LS76', 'NL32-04', NULL, 'OBERROHRMOOS', 'Ober Rohrmoos', 'Ober Rohrmoos', '0101000020E6100000D1ED804644441D40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516053, 'MT52', 'NL32-02', NULL, 'OBERRUTI', 'Oberrüti', 'Oberruti', '0101000020E61000007EEF254344C4204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516054, 'NS07', 'NL32-05', NULL, 'OBERSAXEN', 'Obersaxen', 'Obersaxen', '0101000020E610000033333333333322400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516055, 'NS49', 'NL32-05', NULL, 'OBERSAYS', 'Ober-Says', 'Ober-Says', '0101000020E6100000E4558CA9AA2A234087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516057, 'MT77', 'NL32-02', NULL, 'OBERSCHLATT', 'Ober-Schlatt', 'Ober-Schlatt', '0101000020E6100000666666666666214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516056, 'MT85', 'NL32-02', NULL, 'OBERSCHLATT', 'Oberschlatt', 'Oberschlatt', '0101000020E61000003333333333B32140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516058, 'MT70', 'NL32-02', NULL, 'OBERSCHONENBUCH', 'Oberschönenbuch', 'Oberschonenbuch', '0101000020E6100000CDCCCCCCCC4C21400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516059, 'MT43', 'NL32-02', NULL, 'OBERSCHONGAU', 'Ober-Schongau', 'Ober-Schongau', '0101000020E6100000000000000080204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516060, 'LS67', 'NL32-04', NULL, 'OBERSCHROT', 'Oberschrot', 'Oberschrot', '0101000020E61000009EBA4D1311111D40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516062, 'NT20', 'NL32-05', NULL, 'OBERSIEZ', 'Ober Siez', 'Ober Siez', '0101000020E61000004FDDA68988882240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516065, 'MT46', 'NL32-02', NULL, 'OBERSIGGENTHAL', 'Obersiggenthal', 'Obersiggenthal', '0101000020E6100000E976402322A220400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516068, 'MS37', 'NL32-05', NULL, 'OBERSTAFEL', 'Ober Stafel', 'Ober Stafel', '0101000020E6100000CDCCCCCCCC4C2040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516069, 'NS09', 'NL32-05', NULL, 'OBERSTAFEL', 'Ober Stafel', 'Ober Stafel', '0101000020E610000033333333333322403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516070, 'NS09', 'NL32-05', NULL, 'OBERSTAFFEL', 'Ober Staffel', 'Ober Staffel', '0101000020E610000000000000000022409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516071, 'MT87', 'NL32-02', NULL, 'OBERSTAMMHEIM', 'Ober-Stammheim', 'Ober-Stammheim', '0101000020E61000004BBCF20F119121403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516072, 'LS87', 'NL32-04', NULL, 'OBERSTOCKEN', 'Oberstocken', 'Oberstocken', '0101000020E61000003333333333331E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516073, 'NT11', 'NL32-02', NULL, 'OBERTERZEN', 'Oberterzen', 'Oberterzen', '0101000020E61000000000000000802240791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516076, 'MS58', 'NL32-05', NULL, 'OBERTRUBSEEALP', 'Ober Trübsee Alp', 'Ober Trubsee Alp', '0101000020E61000007EEF254344C420406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516077, 'NS27', 'NL32-05', NULL, 'OBERTSCHAPPINA', 'Ober Tschappina', 'Ober Tschappina', '0101000020E61000008210DABCBBBB224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516078, 'LS89', 'NL32-04', NULL, 'OBERULMIZ', 'Oberulmiz', 'Oberulmiz', '0101000020E61000002F127FB9BBBB1D403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516079, 'MT54', 'NL32-02', NULL, 'OBERURDORF', 'Ober Urdorf', 'Ober Urdorf', '0101000020E61000001CAA735655D52040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516080, 'NT05', 'NL32-02', NULL, 'OBERUZWIL', 'Oberuzwil', 'Oberuzwil', '0101000020E61000008210DABCBB3B224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516081, 'NS47', 'NL32-05', NULL, 'OBERVAZ', 'Obervaz', 'Obervaz', '0101000020E61000004BBCF20F111123409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516082, 'MS45', 'NL32-05', NULL, 'OBERWALD', 'Oberwald', 'Oberwald', '0101000020E6100000E4558CA9AAAA204013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516083, 'LS79', 'NL32-04', NULL, 'OBERWANGEN', 'Ober-Wangen', 'Ober-Wangen', '0101000020E61000006666666666661D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516084, 'MT95', 'NL32-02', NULL, 'OBERWANGEN', 'Oberwangen', 'Oberwangen', '0101000020E6100000B5430DF0EEEE214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516085, 'MT56', 'NL32-02', NULL, 'OBERWENINGEN', 'Oberweningen', 'Oberweningen', '0101000020E6100000CDCCCCCCCCCC20400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516086, 'MT84', 'NL32-02', NULL, 'OBERWETZIKON', 'Ober-Wetzikon', 'Ober-Wetzikon', '0101000020E61000004BBCF20F11912140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516087, 'LS86', 'NL32-04', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '0101000020E61000002F127FB9BBBB1D403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516088, 'LT71', 'NL32-01', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '0101000020E61000009A99999999991D40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516089, 'MT54', 'NL32-02', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '0101000020E61000007EEF254344C42040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516090, 'LT96', 'NL32-01', NULL, 'OBERWIL', 'Oberwil', 'Oberwil', '0101000020E61000003333333333331E4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516091, 'MS39', 'NL32-05', NULL, 'OBERWILEN', 'Oberwilen', 'Oberwilen', '0101000020E61000001789BFDCDD5D2040218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516092, 'LT70', 'NL32-04', NULL, 'OBERWOHLEN', 'Ober-Wohlen', 'Ober-Wohlen', '0101000020E61000006666666666661D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516093, 'LS98', 'NL32-04', NULL, 'OBERZELG', 'Oberzelg', 'Oberzelg', '0101000020E6100000FCDE4B8688881E4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516094, 'MT53', 'NL32-02', NULL, 'OBFELDEN', 'Obfelden', 'Obfelden', '0101000020E61000001CAA735655D5204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516095, 'NT11', 'NL32-02', NULL, 'OBSTALDEN', 'Obstalden', 'Obstalden', '0101000020E6100000CDCCCCCCCC4C2240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516100, 'MT02', 'NL32-01', NULL, 'OCHLENBERG', 'Ochlenberg', 'Ochlenberg', '0101000020E61000006245B2ECEEEE1E403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516101, 'MT81', 'NL32-02', NULL, 'OCHSENBODEN', 'Ochsenboden', 'Ochsenboden', '0101000020E61000008210DABCBBBB2140BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516102, 'LT54', 'NL32-01', NULL, 'OCOURT', 'Ocourt', 'Ocourt', '0101000020E6100000C8AB185355551C40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516103, 'MT03', 'NL32-01', NULL, 'OENSINGEN', 'Oensingen', 'Oensingen', '0101000020E61000006245B2ECEEEE1E4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516105, 'MT65', 'NL32-02', NULL, 'OERLIKON', 'Oerlikon', 'Oerlikon', '0101000020E61000009A9999999919214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516106, 'LT91', 'NL32-01', NULL, 'OESCHBERG', 'Oeschberg', 'Oeschberg', '0101000020E61000000421B47977771E40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516111, 'MT73', 'NL32-02', NULL, 'OETWILAMSEE', 'Oetwil am See', 'Oetwil am See', '0101000020E6100000B5430DF0EE6E214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516112, 'MT55', 'NL32-02', NULL, 'OETWILANDERLIMMAT', 'Oetwil an der Limmat', 'Oetwil an der Limmat', '0101000020E6100000CDCCCCCCCCCC204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516113, 'LS96', 'NL32-04', NULL, 'OEY', 'Oey', 'Oey', '0101000020E6100000C8AB185355551E4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516117, 'MT14', 'NL32-01', NULL, 'OFTRINGEN', 'Oftringen', 'Oftringen', '0101000020E61000003854E7ACAAAA1F40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516118, 'MT22', 'NL32-01', NULL, 'OHMSTAL', 'Ohmstal', 'Ohmstal', '0101000020E6100000CDCCCCCCCCCC1F4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516119, 'LU50', 'NL32-01', NULL, 'OLEYRES', 'Oleyres', 'Oleyres', '0101000020E61000003333333333331C40CDCCCCCCCCEC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516120, 'MS95', 'NL32-05', NULL, 'OLIVONE', 'Olivone', 'Olivone', '0101000020E61000006666666666E6214013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516122, 'LS42', 'NL32-04', NULL, 'OLLON', 'Ollon', 'Ollon', '0101000020E61000000000000000001C406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516123, 'MT14', 'NL32-01', NULL, 'OLTEN', 'Olten', 'Olten', '0101000020E61000003854E7ACAAAA1F40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516124, 'KS71', 'NL32-04', NULL, 'ONEX', 'Onex', 'Onex', '0101000020E6100000666666666666184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516125, 'LS58', 'NL32-04', NULL, 'ONNENS', 'Onnens', 'Onnens', '0101000020E61000003333333333331C4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516126, 'LS29', 'NL32-04', NULL, 'ONNENS', 'Onnens', 'Onnens', '0101000020E6100000CDCCCCCCCCCC1A40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516129, 'MT65', 'NL32-02', NULL, 'OPFIKON', 'Opfikon', 'Opfikon', '0101000020E6100000E4558CA9AA2A214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516130, 'LS27', 'NL32-04', NULL, 'OPPENS', 'Oppens', 'Oppens', '0101000020E6100000CDCCCCCCCCCC1A40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516133, 'LS17', 'NL32-04', NULL, 'ORBE', 'Orbe', 'Orbe', '0101000020E61000009578E51F22221A40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516136, 'MS75', 'NL32-05', NULL, 'ORELLO', 'Orello', 'Orello', '0101000020E6100000CDCCCCCCCC4C2140BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516137, 'MT15', 'NL32-01', NULL, 'ORMALINGEN', 'Ormalingen', 'Ormalingen', '0101000020E61000000421B47977771F40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516140, 'LS35', 'NL32-04', NULL, 'ORONLAVILLE', 'Oron-la-ville', 'Oron-la-ville', '0101000020E61000003333333333331B40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516142, 'LT72', 'NL32-01', NULL, 'ORPUND', 'Orpund', 'Orpund', '0101000020E61000003333333333331D40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516144, 'LR59', 'NL32-04', NULL, 'ORSIERES', 'Orsières', 'Orsieres', '0101000020E61000009A99999999991C4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516145, 'LS47', 'NL32-04', NULL, 'ORSONNENS', 'Orsonnens', 'Orsonnens', '0101000020E61000006245B2ECEEEE1B40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516146, 'MS99', 'NL32-05', NULL, 'ORTHALDEN', 'Orthalden', 'Orthalden', '0101000020E61000006666666666E621403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516148, 'LT62', 'NL32-01', NULL, 'ORVIN', 'Orvin', 'Orvin', '0101000020E6100000CDCCCCCCCCCC1C4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516150, 'MS84', 'NL32-05', NULL, 'OSCO', 'Osco', 'Osco', '0101000020E61000004BBCF20F11912140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516151, 'MS92', 'NL32-05', NULL, 'OSOGNA', 'Osogna', 'Osogna', '0101000020E6100000B122597677F72140BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516152, 'MT77', 'NL32-02', NULL, 'OSSINGEN', 'Ossingen', 'Ossingen', '0101000020E6100000B5430DF0EE6E2140218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516153, 'MT67', 'NL32-02', NULL, 'OSTERFINGEN', 'Osterfingen', 'Osterfingen', '0101000020E6100000B122597677F7204087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516154, 'LT80', 'NL32-04', NULL, 'OSTERMUNDIGEN', 'Ostermundigen', 'Ostermundigen', '0101000020E61000006245B2ECEEEE1D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516157, 'MT55', 'NL32-02', NULL, 'OTELFINGEN', 'Otelfingen', 'Otelfingen', '0101000020E61000007EEF254344C42040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516159, 'MT44', 'NL32-02', NULL, 'OTHMARSINGEN', 'Othmarsingen', 'Othmarsingen', '0101000020E6100000B5430DF0EE6E20403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516160, 'MT53', 'NL32-02', NULL, 'OTTENBACH', 'Ottenbach', 'Ottenbach', '0101000020E6100000CDCCCCCCCCCC204013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516161, 'LS15', 'NL32-04', NULL, 'OUCHY', 'Ouchy', 'Ouchy', '0101000020E6100000FCDE4B8688881A4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516162, 'LS51', 'NL32-04', NULL, 'OVRONNAZ', 'Ovronnaz', 'Ovronnaz', '0101000020E61000003854E7ACAAAA1C409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516164, 'LS27', 'NL32-04', NULL, 'PAILLY', 'Pailly', 'Pailly', '0101000020E61000002F127FB9BBBB1A409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516165, 'MS71', 'NL32-05', NULL, 'PALAGNEDRA', 'Palagnedra', 'Palagnedra', '0101000020E61000007EEF2543444421403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516166, 'LS35', 'NL32-04', NULL, 'PALEZIEUX', 'Palézieux', 'Palezieux', '0101000020E6100000C8AB185355551B406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516168, 'LS06', 'NL32-04', NULL, 'PAMPIGNY', 'Pampigny', 'Pampigny', '0101000020E61000002F127FB9BBBB1940791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516169, 'LS42', 'NL32-04', NULL, 'PANEX', 'Panex', 'Panex', '0101000020E61000009EBA4D1311111C406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516170, 'NS08', 'NL32-05', NULL, 'PANIX', 'Panix', 'Panix', '0101000020E61000008210DABCBB3B2240BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516172, 'NS59', 'NL32-05', NULL, 'PANY', 'Pany', 'Pany', '0101000020E61000004FDDA6898888234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516173, 'LT80', 'NL32-04', NULL, 'PAPIERMUHLE', 'Papiermühle', 'Papiermuhle', '0101000020E61000006245B2ECEEEE1D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516177, 'NS06', 'NL32-05', NULL, 'PARDATSCH', 'Pardatsch', 'Pardatsch', '0101000020E6100000E4558CA9AA2A2240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516178, 'MS86', 'NL32-05', NULL, 'PARDE', 'Pardè', 'Parde', '0101000020E61000003333333333B321403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516179, 'NS47', 'NL32-05', NULL, 'PARPAN', 'Parpan', 'Parpan', '0101000020E61000009A9999999919234054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516183, 'NT60', 'NL32-05', NULL, 'PARTNUN', 'Partnun', 'Partnun', '0101000020E61000003333333333B32340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516184, 'NS37', 'NL32-05', NULL, 'PASPELS', 'Paspels', 'Paspels', '0101000020E61000006666666666E622400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516186, 'LS25', 'NL32-04', NULL, 'PAUDEX', 'Paudex', 'Paudex', '0101000020E61000003854E7ACAAAA1A400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516189, 'LS48', 'NL32-04', NULL, 'PAYERNE', 'Payerne', 'Payerne', '0101000020E61000002F127FB9BBBB1B40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516191, 'MS73', 'NL32-05', NULL, 'PECCIA', 'Peccia', 'Peccia', '0101000020E6100000CDCCCCCCCC4C21403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516192, 'NR07', 'NL32-08', NULL, 'PEDRINATE', 'Pedrinate', 'Pedrinate', '0101000020E61000004FDDA68988082240791563AAAAEA4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516194, 'NS17', 'NL32-05', NULL, 'PEIDENBAD', 'Peiden Bad', 'Peiden Bad', '0101000020E61000006666666666662240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516195, 'NS58', 'NL32-05', NULL, 'PEIST', 'Peist', 'Peist', '0101000020E61000001CAA735655552340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516197, 'LS18', 'NL32-04', NULL, 'PENEY', 'Peney', 'Peney', '0101000020E61000003333333333331A406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516198, 'LS26', 'NL32-04', NULL, 'PENEYLEJORAT', 'Peney-le-Jorat', 'Peney-le-Jorat', '0101000020E61000006245B2ECEEEE1A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516203, 'LS16', 'NL32-04', NULL, 'PENTHALAZ', 'Penthalaz', 'Penthalaz', '0101000020E61000009578E51F22221A40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516204, 'MT51', 'NL32-02', NULL, 'PERLEN', 'Perlen', 'Perlen', '0101000020E61000008210DABCBBBB2040218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516205, 'LT73', 'NL32-01', NULL, 'PERREFITTE', 'Perrefitte', 'Perrefitte', '0101000020E61000006666666666661D4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516206, 'KS94', 'NL32-04', NULL, 'PERROY', 'Perroy', 'Perroy', '0101000020E61000000421B47977771940ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516207, 'MS93', 'NL32-05', NULL, 'PERSONICO', 'Personico', 'Personico', '0101000020E6100000CDCCCCCCCCCC2140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516208, 'NS11', 'NL32-05', NULL, 'PERTISE', 'Pertise', 'Pertise', '0101000020E6100000CDCCCCCCCC4C2240AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516209, 'LT62', 'NL32-01', NULL, 'PERY', 'Péry', 'Pery', '0101000020E61000000000000000001D409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516210, 'LT30', 'NL32-04', NULL, 'PESEUX', 'Peseux', 'Peseux', '0101000020E6100000FCDE4B8688881B40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516220, 'NT30', 'NL32-05', NULL, 'PFAFERSDROF', 'Pfäfers Drof', 'Pfafers Drof', '0101000020E61000000000000000002340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516221, 'LS76', 'NL32-04', NULL, 'PFAFFENRIED', 'Pfaffenried', 'Pfaffenried', '0101000020E61000003854E7ACAAAA1D40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516222, 'MS67', 'NL32-05', NULL, 'PFAFFENSPRUNG', 'Pfaffensprung', 'Pfaffensprung', '0101000020E61000003333333333332140ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516225, 'MT82', 'NL32-02', NULL, 'PFAFFIKON', 'Pfäffikon', 'Pfaffikon', '0101000020E61000004FDDA689888821409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516226, 'MT84', 'NL32-02', NULL, 'PFAFFIKON', 'Pfäffikon', 'Pfaffikon', '0101000020E61000004BBCF20F11912140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516227, 'MT13', 'NL32-01', NULL, 'PFAFFNAU', 'Pfaffnau', 'Pfaffnau', '0101000020E61000009A99999999991F40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516229, 'MT33', 'NL32-02', NULL, 'PFEFFIKON', 'Pfeffikon', 'Pfeffikon', '0101000020E61000001789BFDCDD5D20400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516230, 'LT95', 'NL32-01', NULL, 'PFEFFINGEN', 'Pfeffingen', 'Pfeffingen', '0101000020E6100000C8AB185355551E409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516232, 'MT74', 'NL32-02', NULL, 'PFFAFFHAUSEN', 'Pffaffhausen', 'Pffaffhausen', '0101000020E61000008210DABCBB3B2140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516233, 'MT76', 'NL32-02', NULL, 'PFUNGEN', 'Pfungen', 'Pfungen', '0101000020E61000007EEF25434444214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516234, 'MT97', 'NL32-02', NULL, 'PFYN', 'Pfyn', 'Pfyn', '0101000020E6100000B5430DF0EEEE2140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516235, 'NS00', 'NL32-05', NULL, 'PIANDERA', 'Piandera', 'Piandera', '0101000020E61000009A99999999192240791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516236, 'NS01', 'NL32-05', NULL, 'PIANEZZO', 'Pianezzo', 'Pianezzo', '0101000020E61000004BBCF20F1111224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516237, 'MS62', 'NL32-05', NULL, 'PIANO', 'Piano', 'Piano', '0101000020E61000004FDDA6898808214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516238, 'NS14', 'NL32-05', NULL, 'PIANSANGIACOMO', 'Pian San Giacomo', 'Pian San Giacomo', '0101000020E6100000B12259767777224087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516239, 'MS64', 'NL32-05', NULL, 'PIATTO', 'Piatto', 'Piatto', '0101000020E6100000E9764023222221409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516240, 'MS80', 'NL32-05', NULL, 'PIAZZOGNA', 'Piazzogna', 'Piazzogna', '0101000020E6100000E976402322A22140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516244, 'LT72', 'NL32-01', NULL, 'PIETERLEN', 'Pieterlen', 'Pieterlen', '0101000020E6100000C8AB185355551D4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516246, 'NS36', 'NL32-05', NULL, 'PIGNIEU', 'Pignieu', 'Pignieu', '0101000020E61000001789BFDCDDDD2240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516250, 'MS75', 'NL32-05', NULL, 'PIORA', 'Piora', 'Piora', '0101000020E61000001789BFDCDD5D214013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516251, 'MS75', 'NL32-05', NULL, 'PIOTTA', 'Piotta', 'Piotta', '0101000020E61000001789BFDCDD5D214054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516253, 'NS17', 'NL32-05', NULL, 'PITASCH', 'Pitasch', 'Pitasch', '0101000020E6100000B5430DF0EE6E2240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516254, 'LS67', 'NL32-04', NULL, 'PLAFFEIEN', 'Plaffeien', 'Plaffeien', '0101000020E61000009578E51F22221D400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516256, 'NS43', 'NL32-05', NULL, 'PLANACC', 'Planacc', 'Planacc', '0101000020E6100000E4558CA9AA2A2340218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516258, 'LR58', 'NL32-07', NULL, 'PLANDELACHAUX', 'Plan-de-la-Chaux', 'Plan-de-la-Chaux', '0101000020E6100000FCDE4B8688881C403333333333F34640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516259, 'LS61', 'NL32-04', NULL, 'PLANFEY', 'Plan Fey', 'Plan Fey', '0101000020E61000009EBA4D1311111D4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516260, 'NS44', 'NL32-05', NULL, 'PLANG', 'Plang', 'Plang', '0101000020E6100000E4558CA9AA2A23400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516261, 'KS71', 'NL32-04', NULL, 'PLANLESOUATES', 'Plan-les-Ouates', 'Plan-les-Ouates', '0101000020E61000000421B4797777184087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516262, 'LR69', 'NL32-04', NULL, 'PLANPRO', 'Plan Pro', 'Plan Pro', '0101000020E61000009578E51F22221D4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516266, 'LS67', 'NL32-04', NULL, 'PLASSELB', 'Plasselb', 'Plasselb', '0101000020E61000000000000000001D40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516267, 'MS86', 'NL32-05', NULL, 'PLATTA', 'Platta', 'Platta', '0101000020E61000003333333333B321403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516272, 'MT20', 'NL32-02', NULL, 'PLAUNDILSMATTS', 'Plaun dils Matts', 'Plaun dils Matts', '0101000020E610000000000000000020400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516275, 'NS45', 'NL32-05', NULL, 'PLAZBEISCHEN', 'Plaz Beischen', 'Plaz Beischen', '0101000020E61000007EEF254344442340BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516276, 'LT75', 'NL32-01', NULL, 'PLEIGNE', 'Pleigne', 'Pleigne', '0101000020E61000009578E51F22221D403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516278, 'LS52', 'NL32-04', NULL, 'PONTDENANT', 'Pont-de-Nant', 'Pont-de-Nant', '0101000020E61000000421B47977771C400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516279, 'NS75', 'NL32-05', NULL, 'PONTE', 'Ponte', 'Ponte', '0101000020E61000001CAA735655D52340791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516280, 'MS81', 'NL32-05', NULL, 'PONTEBROLLA', 'Ponte Brolla', 'Ponte Brolla', '0101000020E6100000000000000080214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516283, 'LS48', 'NL32-04', NULL, 'PONTHAUX', 'Ponthaux', 'Ponthaux', '0101000020E61000009578E51F22221C40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516284, 'NS03', 'NL32-05', NULL, 'PONTIRONE', 'Pontirone', 'Pontirone', '0101000020E61000004BBCF20F11112240DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516285, 'MS94', 'NL32-05', NULL, 'PONTOVALENTINO', 'Ponto Valentino', 'Ponto Valentino', '0101000020E61000001789BFDCDDDD2140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516286, 'NS64', 'NL32-05', NULL, 'PONTRESINA', 'Pontresina', 'Pontresina', '0101000020E6100000CDCCCCCCCCCC2340AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516287, 'LT55', 'NL32-01', NULL, 'PORRENTRUY', 'Porrentruy', 'Porrentruy', '0101000020E6100000C8AB185355551C4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516288, 'LS36', 'NL32-04', NULL, 'PORSEL', 'Porsel', 'Porsel', '0101000020E61000000421B47977771B40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516290, 'LS49', 'NL32-04', NULL, 'PORTALBANDESSOUS', 'Portalban- Dessous', 'Portalban- Dessous', '0101000020E6100000CDCCCCCCCCCC1B4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516291, 'KS82', 'NL32-04', NULL, 'PORTDECORSIER', 'Port-de-Corsier', 'Port-de-Corsier', '0101000020E6100000CDCCCCCCCCCC184054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516292, 'MS70', 'NL32-05', NULL, 'PORTORONCO', 'Porto Ronco', 'Porto Ronco', '0101000020E6100000B122597677772140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516293, 'LS33', 'NL32-04', NULL, 'PORTVALAIS', 'Port-Valais', 'Port-Valais', '0101000020E61000000421B47977771B40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516296, 'NS83', 'NL32-06', NULL, 'POSCHIAVO', 'Poschiavo', 'Poschiavo', '0101000020E61000009A99999999192440791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516302, 'LS73', 'NL32-04', NULL, 'PRACOMBERA', 'Pra Combèra', 'Pra Combera', '0101000020E61000002F127FB9BBBB1D40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516303, 'NS82', 'NL32-06', NULL, 'PRADA', 'Prada', 'Prada', '0101000020E6100000E976402322222440BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516304, 'PS08', 'NL32-06', NULL, 'PRADELLA', 'Pradella', 'Pradella', '0101000020E6100000E976402322A224406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516305, 'NS48', 'NL32-05', NULL, 'PRADEN', 'Praden', 'Praden', '0101000020E6100000E976402322222340BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516308, 'LS80', 'NL32-04', NULL, 'PRAFLORIC', 'Prafloric', 'Prafloric', '0101000020E61000009578E51F22221E40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516310, 'NS59', 'NL32-05', NULL, 'PRAGMARTIN', 'Pragmartin', 'Pragmartin', '0101000020E6100000B5430DF0EE6E234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516311, 'LS70', 'NL32-04', NULL, 'PRALONG', 'Pralong', 'Pralong', '0101000020E61000009A99999999991D40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516312, 'LS80', 'NL32-04', NULL, 'PRALOVIN', 'Pralovin', 'Pralovin', '0101000020E61000000000000000001E40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516313, 'NS39', 'NL32-05', NULL, 'PRAMIEISTERS', 'Pramieisters', 'Pramieisters', '0101000020E61000004FDDA689880823403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516314, 'KS84', 'NL32-04', NULL, 'PRANGINS', 'Prangins', 'Prangins', '0101000020E610000000000000000019403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516315, 'LS61', 'NL32-04', NULL, 'PRARION', 'Prarion', 'Prarion', '0101000020E61000009EBA4D1311111D403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516316, 'LS67', 'NL32-04', NULL, 'PRAROMAN', 'Praroman', 'Praroman', '0101000020E61000002F127FB9BBBB1C400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516318, 'MS84', 'NL32-05', NULL, 'PRATO', 'Prato', 'Prato', '0101000020E61000000000000000802140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516319, 'MT06', 'NL32-01', NULL, 'PRATTELN', 'Pratteln', 'Pratteln', '0101000020E61000002F127FB9BBBB1E4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516322, 'LT50', 'NL32-04', NULL, 'PRAZ', 'Praz', 'Praz', '0101000020E61000006666666666661C409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516321, 'NS37', 'NL32-05', NULL, 'PRAZ', 'Präz', 'Praz', '0101000020E6100000CDCCCCCCCCCC2240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516323, 'LR59', 'NL32-07', NULL, 'PRAZDEFORT', 'Praz-de-Fort', 'Praz-de-Fort', '0101000020E6100000FCDE4B8688881C40AC4896DDDDFD4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516325, 'NS55', 'NL32-05', NULL, 'PREDA', 'Preda', 'Preda', '0101000020E61000004FDDA68988882340791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516326, 'MR99', 'NL32-05', NULL, 'PREGASSONA', 'Pregassona', 'Pregassona', '0101000020E6100000B5430DF0EEEE214013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516327, 'KS82', 'NL32-04', NULL, 'PREGNY', 'Pregny', 'Pregny', '0101000020E61000009A99999999991840AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516329, 'LT62', 'NL32-01', NULL, 'PRELES', 'Prêles', 'Preles', '0101000020E61000000000000000001D409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516330, 'KS82', 'NL32-04', NULL, 'PRESINGE', 'Presinge', 'Presinge', '0101000020E61000000000000000001940AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516331, 'KS82', 'NL32-04', NULL, 'PRIEURE', 'Prieuré', 'Prieure', '0101000020E61000003854E7ACAAAA18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516332, 'LS15', 'NL32-04', NULL, 'PRILLY', 'Prilly', 'Prilly', '0101000020E6100000C8AB185355551A4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516335, 'LS71', 'NL32-04', NULL, 'PROLIN', 'Prolin', 'Prolin', '0101000020E61000009A99999999991D403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516336, 'NS43', 'NL32-05', NULL, 'PROMONTOGNO', 'Promontogno', 'Promontogno', '0101000020E6100000E976402322222340791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516337, 'MS92', 'NL32-05', NULL, 'PROSITO', 'Prosito', 'Prosito', '0101000020E6100000B122597677F7214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516338, 'LS29', 'NL32-04', NULL, 'PROVENCE', 'Provence', 'Provence', '0101000020E61000006B871AE0DDDD1A40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516339, 'MS94', 'NL32-05', NULL, 'PRUGIASCO', 'Prugiasco', 'Prugiasco', '0101000020E61000001CAA735655D52140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516341, 'LS25', 'NL32-04', NULL, 'PUIDOUX', 'Puidoux', 'Puidoux', '0101000020E61000009578E51F22221B400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516343, 'LS15', 'NL32-04', NULL, 'PULLY', 'Pully', 'Pully', '0101000020E61000009A99999999991A4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48738, 'KS81', 'NL32-04', NULL, 'PUPLINGE', 'Puplinge', 'Puplinge', '0101000020E61000006245B2ECEEEE18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516344, 'MR89', 'NL32-08', NULL, 'PURA', 'Pura', 'Pura', '0101000020E61000008210DABCBBBB2140ED5003BCBBFB4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516345, 'MS94', 'NL32-05', NULL, 'PUSCEDDISOPRA', 'Pusced di Sopra', 'Pusced di Sopra', '0101000020E61000001CAA735655D5214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516346, 'MS83', 'NL32-05', NULL, 'PUSCENNEGRO', 'Püscen Negro', 'Puscen Negro', '0101000020E61000000000000000802140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516347, 'NT50', 'NL32-05', NULL, 'PUSSEREIN', 'Pusserein', 'Pusserein', '0101000020E61000006666666666662340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516348, 'NT11', 'NL32-02', NULL, 'QUARTEN', 'Quarten', 'Quarten', '0101000020E61000000000000000802240CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516349, 'MS91', 'NL32-05', NULL, 'QUARTINO', 'Quartino', 'Quartino', '0101000020E61000007EEF254344C421403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516353, 'NT11', 'NL32-02', NULL, 'QUINTEN', 'Quinten', 'Quinten', '0101000020E6100000B5430DF0EE6E2240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516354, 'MS75', 'NL32-05', NULL, 'QUINTO', 'Quinto', 'Quinto', '0101000020E6100000B5430DF0EE6E214054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516355, 'MS97', 'NL32-05', NULL, 'RABIUS', 'Rabius', 'Rabius', '0101000020E61000006666666666E621409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516357, 'LT60', 'NL32-01', NULL, 'RADELFINGEN', 'Radelfingen', 'Radelfingen', '0101000020E61000009EBA4D1311111D4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516358, 'NS45', 'NL32-05', NULL, 'RADONS', 'Radons', 'Radons', '0101000020E61000009A99999999192340BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516359, 'MT67', 'NL32-02', NULL, 'RAFZ', 'Rafz', 'Rafz', '0101000020E61000004BBCF20F11112140218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516364, 'MT85', 'NL32-02', NULL, 'RAMISMUHLE', 'Rämismühle', 'Ramismuhle', '0101000020E61000009A999999999921409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516365, 'LT94', 'NL32-01', NULL, 'RAMISWIL', 'Ramiswil', 'Ramiswil', '0101000020E61000009A99999999991E40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516366, 'MT88', 'NL32-02', NULL, 'RAMSEN', 'Ramsen', 'Ramsen', '0101000020E6100000E976402322A221409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516367, 'LS18', 'NL32-04', NULL, 'RANCES', 'Rances', 'Rances', '0101000020E61000009578E51F22221A4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516368, 'MS00', 'NL32-04', NULL, 'RANDA', 'Randa', 'Randa', '0101000020E61000003333333333331F40CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516370, 'LS83', 'NL32-04', NULL, 'RANDOGNE', 'Randogne', 'Randogne', '0101000020E61000000000000000001E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516371, 'MT00', 'NL32-04', NULL, 'RANFLUH', 'Ranflüh', 'Ranfluh', '0101000020E61000000000000000001F40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516372, 'MS13', 'NL32-04', NULL, 'RANFT', 'Ranft', 'Ranft', '0101000020E61000000421B47977771F40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516373, 'MS49', 'NL32-05', NULL, 'RANFT', 'Ranft', 'Ranft', '0101000020E61000004FDDA68988882040218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516375, 'NT07', 'NL32-02', NULL, 'RAPERSWILEN', 'Raperswilen', 'Raperswilen', '0101000020E61000004BBCF20F11112240DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516376, 'LT71', 'NL32-01', NULL, 'RAPPERSWIL', 'Rapperswil', 'Rapperswil', '0101000020E61000009A99999999991D406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516377, 'MT82', 'NL32-02', NULL, 'RAPPERSWIL', 'Rapperswil', 'Rapperswil', '0101000020E6100000E976402322A22140ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516378, 'MS02', 'NL32-04', NULL, 'RARON', 'Raron', 'Raron', '0101000020E61000003333333333331F406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516381, 'MS45', 'NL32-05', NULL, 'RATERICHSBODEN', 'Räterichsboden', 'Raterichsboden', '0101000020E6100000E4558CA9AAAA2040791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516382, 'MT86', 'NL32-02', NULL, 'RATERSCHEN', 'Räterschen', 'Raterschen', '0101000020E61000009A999999999921400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516385, 'LS88', 'NL32-04', NULL, 'RATZENBERG', 'Ratzenberg', 'Ratzenberg', '0101000020E61000002F127FB9BBBB1D40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516388, 'MS66', 'NL32-05', NULL, 'REALP', 'Realp', 'Realp', '0101000020E61000000000000000002140CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516389, 'NS37', 'NL32-05', NULL, 'REALTA', 'Realta', 'Realta', '0101000020E61000001CAA735655D522400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516390, 'NS46', 'NL32-05', NULL, 'REAMS', 'Reams', 'Reams', '0101000020E6100000E4558CA9AA2A2340218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516391, 'NT44', 'NL32-02', NULL, 'REBSTEIN', 'Rebstein', 'Rebstein', '0101000020E6100000E4558CA9AA2A23403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516392, 'LS68', 'NL32-04', NULL, 'RECHTHALTEN', 'Rechthalten', 'Rechthalten', '0101000020E61000000000000000001D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516393, 'MS44', 'NL32-05', NULL, 'RECKINGEN', 'Reckingen', 'Reckingen', '0101000020E6100000B122597677772040ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516395, 'LT63', 'NL32-01', NULL, 'RECONVILIER', 'Reconvilier', 'Reconvilier', '0101000020E61000006B871AE0DDDD1C40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516397, 'MT55', 'NL32-02', NULL, 'REGENSBERG', 'Regensberg', 'Regensberg', '0101000020E61000001789BFDCDDDD2040AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516398, 'MT55', 'NL32-02', NULL, 'REGENSDORF', 'Regensdorf', 'Regensdorf', '0101000020E6100000B5430DF0EEEE204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516399, 'NT35', 'NL32-02', NULL, 'REHETOBEL', 'Rehetobel', 'Rehetobel', '0101000020E6100000B122597677F7224087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516400, 'NS38', 'NL32-05', NULL, 'REICHENAU', 'Reichenau', 'Reichenau', '0101000020E6100000CDCCCCCCCCCC2240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516401, 'MS06', 'NL32-04', NULL, 'REICHENBACH', 'Reichenbach', 'Reichenbach', '0101000020E6100000CDCCCCCCCCCC1E40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516402, 'MT92', 'NL32-02', NULL, 'REICHENBURG', 'Reichenburg', 'Reichenburg', '0101000020E6100000B122597677F7214087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516403, 'MT23', 'NL32-01', NULL, 'REIDEN', 'Reiden', 'Reiden', '0101000020E61000006B871AE0DDDD1F400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516404, 'MT05', 'NL32-01', NULL, 'REIGOLDSWIL', 'Reigoldswil', 'Reigoldswil', '0101000020E61000002F127FB9BBBB1E403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516405, 'MT33', 'NL32-02', NULL, 'REINACH', 'Reinach', 'Reinach', '0101000020E61000001789BFDCDD5D204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516408, 'NS36', 'NL32-05', NULL, 'REISCHEN', 'Reischen', 'Reischen', '0101000020E61000006666666666E62240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516410, 'MT46', 'NL32-02', NULL, 'REKINGEN', 'Rekingen', 'Rekingen', '0101000020E6100000E976402322A22040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516411, 'MT91', 'NL32-02', NULL, 'REMPEN', 'Rempen', 'Rempen', '0101000020E6100000CDCCCCCCCCCC2140DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516412, 'PS08', 'NL32-06', NULL, 'REMUS', 'Remüs', 'Remus', '0101000020E61000007EEF254344C42440791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516413, 'LT42', 'NL32-01', NULL, 'RENAN', 'Renan', 'Renan', '0101000020E61000003854E7ACAAAA1B40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516414, 'LS15', 'NL32-04', NULL, 'RENENS', 'Renens', 'Renens', '0101000020E6100000C8AB185355551A4013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516419, 'LS63', 'NL32-04', NULL, 'REUSCH', 'Reusch', 'Reusch', '0101000020E61000000000000000001D40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516421, 'LS97', 'NL32-04', NULL, 'REUTIGEN', 'Reutigen', 'Reutigen', '0101000020E61000000421B47977771E409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516431, 'NS38', 'NL32-05', NULL, 'RHAZUNS', 'Rhäzüns', 'Rhazuns', '0101000020E6100000CDCCCCCCCCCC22406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516433, 'MT67', 'NL32-02', NULL, 'RHEINAU', 'Rheinau', 'Rheinau', '0101000020E61000003333333333332140DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516434, 'NT45', 'NL32-02', NULL, 'RHEINECK', 'Rheineck', 'Rheineck', '0101000020E6100000E4558CA9AA2A2340ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516436, 'MT06', 'NL32-01', NULL, 'RHEINFELDEN', 'Rheinfelden', 'Rheinfelden', '0101000020E61000009578E51F22221F406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516460, 'LS56', 'NL32-04', NULL, 'RIAZ', 'Riaz', 'Riaz', '0101000020E6100000D1ED804644441C40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516461, 'MT16', 'NL32-01', NULL, 'RIBURG', 'Riburg', 'Riburg', '0101000020E6100000C8AB185355551F40BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516463, 'MT12', 'NL32-01', NULL, 'RICHENTHAL', 'Richenthal', 'Richenthal', '0101000020E61000002F127FB9BBBB1F40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516464, 'LS99', 'NL32-04', NULL, 'RICHIGEN', 'Richigen', 'Richigen', '0101000020E6100000C8AB185355551E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516465, 'MT90', 'NL32-02', NULL, 'RICHISAU', 'Richisau', 'Richisau', '0101000020E6100000CDCCCCCCCCCC214054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516466, 'MT72', 'NL32-02', NULL, 'RICHTERSWIL', 'Richterswil', 'Richterswil', '0101000020E61000006666666666662140ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516467, 'NT03', 'NL32-02', NULL, 'RICKEN', 'Ricken', 'Ricken', '0101000020E61000004BBCF20F1111224054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516468, 'NT05', 'NL32-02', NULL, 'RICKENBACH', 'Rickenbach', 'Rickenbach', '0101000020E61000009A999999991922409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516469, 'MT86', 'NL32-02', NULL, 'RICKENBACH', 'Rickenbach', 'Rickenbach', '0101000020E61000009A999999999921406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516470, 'LS61', 'NL32-04', NULL, 'RIDDES', 'Riddes', 'Riddes', '0101000020E61000006245B2ECEEEE1C4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516471, 'MR09', 'NL32-04', NULL, 'RIED', 'Ried', 'Ried', '0101000020E61000000000000000001F4013AFFC4344044740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516472, 'MS22', 'NL32-05', NULL, 'RIED', 'Ried', 'Ried', '0101000020E61000004FDDA68988082040BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516473, 'MS34', 'NL32-05', NULL, 'RIED', 'Ried', 'Ried', '0101000020E61000001CAA73565555204046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516474, 'LT60', 'NL32-04', NULL, 'RIED', 'Ried', 'Ried', '0101000020E61000002F127FB9BBBB1C409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516475, 'LS79', 'NL32-04', NULL, 'RIEDBACH', 'Riedbach', 'Riedbach', '0101000020E6100000C8AB185355551D4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516479, 'MS09', 'NL32-04', NULL, 'RIEDBERGLI', 'Riedbergli', 'Riedbergli', '0101000020E61000006245B2ECEEEE1E4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516483, 'LT70', 'NL32-04', NULL, 'RIEDERN', 'Riedern', 'Riedern', '0101000020E61000000421B47977771D409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516484, 'LT93', 'NL32-01', NULL, 'RIEDHOLZ', 'Riedholz', 'Riedholz', '0101000020E6100000D1ED804644441E40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516486, 'LS86', 'NL32-04', NULL, 'RIEDLI', 'Riedli', 'Riedli', '0101000020E61000009EBA4D1311111E40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516487, 'MS79', 'NL32-05', NULL, 'RIEDLIG', 'Riedlig', 'Riedlig', '0101000020E6100000B1225976777721403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516488, 'LS78', 'NL32-04', NULL, 'RIEDSTATT', 'Riedstätt', 'Riedstatt', '0101000020E6100000D1ED804644441D4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (19205, 'MD45', 'NN32-11', 3, 'RIEHEN', 'Riehen', 'Riehen', '0101000020E61000001CAA735655552040DF7BC91011714A40');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516489, 'NS17', 'NL32-05', NULL, 'RIEIN', 'Riein', 'Riein', '0101000020E6100000B122597677772240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516490, 'MS79', 'NL32-05', NULL, 'RIEMENSTALDEN', 'Riemenstalden', 'Riemenstalden', '0101000020E61000001CAA7356555521409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516493, 'LS78', 'NL32-04', NULL, 'RIFFENMATT', 'Riffenmatt', 'Riffenmatt', '0101000020E61000006666666666661D4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516495, 'LS88', 'NL32-04', NULL, 'RIGGISBERG', 'Riggisberg', 'Riggisberg', '0101000020E61000006B871AE0DDDD1D406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516497, 'MT51', 'NL32-02', NULL, 'RIGIKALTBAD', 'Rigi Kaltbad', 'Rigi Kaltbad', '0101000020E6100000B5430DF0EEEE20406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516501, 'MT85', 'NL32-02', NULL, 'RIKON', 'Rikon', 'Rikon', '0101000020E61000004BBCF20F119121409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516504, 'MS17', 'NL32-04', NULL, 'RINGGENBERG', 'Ringgenberg', 'Ringgenberg', '0101000020E61000009A99999999991F409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516505, 'NS07', 'NL32-05', NULL, 'RINGGENBERG', 'Ringgenberg', 'Ringgenberg', '0101000020E61000000000000000002240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516506, 'LS86', 'NL32-04', NULL, 'RINGOLDINGEN', 'Ringoldingen', 'Ringoldingen', '0101000020E61000009EBA4D1311111E403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516509, 'LS74', 'NL32-04', NULL, 'RISCH', 'Risch', 'Risch', '0101000020E6100000C8AB185355551D4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516517, 'MS12', 'NL32-04', NULL, 'RITTI', 'Ritti', 'Ritti', '0101000020E61000000421B47977771F400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516518, 'MS12', 'NL32-04', NULL, 'RITTI', 'Ritti', 'Ritti', '0101000020E61000003854E7ACAAAA1F4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516520, 'MS44', 'NL32-05', NULL, 'RITZINGEN', 'Ritzingen', 'Ritzingen', '0101000020E6100000B1225976777720409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516523, 'MR98', 'NL32-08', NULL, 'RIVASANVITALE', 'Riva San Vitale', 'Riva San Vitale', '0101000020E6100000B5430DF0EEEE21403333333333F34640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516524, 'LR59', 'NL32-04', NULL, 'RIVEHAUTE', 'Rive Haute', 'Rive Haute', '0101000020E61000003854E7ACAAAA1C400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516525, 'MS72', 'NL32-05', NULL, 'RIVEO', 'Riveo', 'Riveo', '0101000020E61000007EEF25434444214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516529, 'MS90', 'NL32-05', NULL, 'ROBASACCO', 'Robasacco', 'Robasacco', '0101000020E61000001CAA735655D52140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516530, 'LS33', 'NL32-04', NULL, 'ROCHE', 'Roche', 'Roche', '0101000020E61000003854E7ACAAAA1B40218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516533, 'LT73', 'NL32-01', NULL, 'ROCHES', 'Roches', 'Roches', '0101000020E6100000FCDE4B8688881D406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516535, 'NS37', 'NL32-05', NULL, 'RODELS', 'Rodels', 'Rodels', '0101000020E61000001789BFDCDDDD2240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516536, 'LT86', 'NL32-01', NULL, 'RODERSDORF', 'Rodersdorf', 'Rodersdorf', '0101000020E6100000CDCCCCCCCCCC1D40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516537, 'MS74', 'NL32-05', NULL, 'RODI', 'Rodi', 'Rodi', '0101000020E6100000B122597677772140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516538, 'NS35', 'NL32-05', NULL, 'ROFFLASCHLUCHT', 'Rofflaschlucht', 'Rofflaschlucht', '0101000020E61000001CAA735655D52240791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516539, 'NS45', 'NL32-05', NULL, 'ROFFNA', 'Roffna', 'Roffna', '0101000020E61000008210DABCBB3B23406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516541, 'MT13', 'NL32-01', NULL, 'ROGGWIL', 'Roggwil', 'Roggwil', '0101000020E6100000D1ED804644441F40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516542, 'NT26', 'NL32-02', NULL, 'ROGGWIL', 'Roggwil', 'Roggwil', '0101000020E61000007EEF254344C422400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516543, 'MT25', 'NL32-01', NULL, 'ROHR', 'Rohr', 'Rohr', '0101000020E6100000CDCCCCCCCCCC1F403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516544, 'MT02', 'NL32-01', NULL, 'ROHRBACH', 'Rohrbach', 'Rohrbach', '0101000020E61000003333333333331F40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516546, 'MS37', 'NL32-05', NULL, 'ROHRMATTEN', 'Rohrmatten', 'Rohrmatten', '0101000020E61000006666666666662040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516547, 'KS94', 'NL32-04', NULL, 'ROLLE', 'Rolle', 'Rolle', '0101000020E6100000C8AB185355551940ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516548, 'LS07', 'NL32-04', NULL, 'ROMAINMOTIER', 'Romainmôtier', 'Romainmotier', '0101000020E61000006B871AE0DDDD19409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516549, 'LS05', 'NL32-04', NULL, 'ROMANEL', 'Romanel', 'Romanel', '0101000020E61000009EBA4D1311111A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516550, 'LS15', 'NL32-04', NULL, 'ROMANEL', 'Romanel', 'Romanel', '0101000020E61000006666666666661A40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516552, 'NT26', 'NL32-02', NULL, 'ROMANSHORN', 'Romanshorn', 'Romanshorn', '0101000020E61000007EEF254344C42240BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516553, 'LS68', 'NL32-04', NULL, 'ROMERSWIL', 'Römerswil', 'Romerswil', '0101000020E61000002F127FB9BBBB1C4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516554, 'MT42', 'NL32-02', NULL, 'ROMERSWIL', 'Römerswil', 'Romerswil', '0101000020E6100000B12259767777204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516555, 'LS47', 'NL32-04', NULL, 'ROMONT', 'Romont', 'Romont', '0101000020E61000003854E7ACAAAA1B409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516557, 'NR08', 'NL32-08', NULL, 'RONCAPIANO', 'Roncapiano', 'Roncapiano', '0101000020E61000004BBCF20F1111224087EA9C5555F54640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516558, 'MS71', 'NL32-05', NULL, 'RONCO', 'Ronco', 'Ronco', '0101000020E6100000B1225976777721403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516559, 'MS64', 'NL32-05', NULL, 'RONCO', 'Ronco', 'Ronco', '0101000020E610000000000000000021400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516561, 'LT62', 'NL32-01', NULL, 'RONDCHATEL', 'Rondchâtel', 'Rondchatel', '0101000020E61000000000000000001D4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516562, 'NS36', 'NL32-05', NULL, 'RONGELLEN', 'Rongellen', 'Rongellen', '0101000020E61000001789BFDCDDDD224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516564, 'MT51', 'NL32-02', NULL, 'ROOT', 'Root', 'Root', '0101000020E61000007EEF254344C42040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516565, 'LS26', 'NL32-04', NULL, 'ROPRAZ', 'Ropraz', 'Ropraz', '0101000020E61000000000000000001B40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516566, 'MT66', 'NL32-02', NULL, 'RORBAS', 'Rorbas', 'Rorbas', '0101000020E6100000E4558CA9AA2A214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516572, 'NT35', 'NL32-02', NULL, 'ROSCHACH', 'Roschach', 'Roschach', '0101000020E61000000000000000002340ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516573, 'LT85', 'NL32-01', NULL, 'ROSCHENZ', 'Röschenz', 'Roschenz', '0101000020E6100000CDCCCCCCCCCC1D4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516576, 'LT83', 'NL32-01', NULL, 'ROSEGG', 'Rosegg', 'Rosegg', '0101000020E61000009EBA4D1311111E40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516577, 'NS13', 'NL32-05', NULL, 'ROSSA', 'Rossa', 'Rossa', '0101000020E61000007EEF254344442240218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516579, 'LS57', 'NL32-04', NULL, 'ROSSENS', 'Rossens', 'Rossens', '0101000020E61000006666666666661C40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516580, 'LS69', 'NL32-04', NULL, 'ROSSHAUSERN', 'Rosshäusern', 'Rosshausern', '0101000020E61000009EBA4D1311111D4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516581, 'LS54', 'NL32-04', NULL, 'ROSSINIERE', 'Rossinière', 'Rossiniere', '0101000020E6100000C8AB185355551C40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516582, 'MS84', 'NL32-05', NULL, 'ROSSURA', 'Rossura', 'Rossura', '0101000020E6100000E4558CA9AAAA2140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516588, 'LS96', 'NL32-04', NULL, 'ROTHBAD', 'Rothbad', 'Rothbad', '0101000020E6100000D1ED804644441E40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516589, 'MS08', 'NL32-04', NULL, 'ROTHENBACH', 'Röthenbach', 'Rothenbach', '0101000020E61000006245B2ECEEEE1E40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516591, 'NS37', 'NL32-05', NULL, 'ROTHENBRUNNEN', 'Rothenbrunnen', 'Rothenbrunnen', '0101000020E61000001CAA735655D5224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516592, 'MT71', 'NL32-02', NULL, 'ROTHENTHURM', 'Rothenthurm', 'Rothenthurm', '0101000020E61000001789BFDCDD5D2140CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516593, 'MT41', 'NL32-02', NULL, 'ROTHERNBURG', 'Rothernburg', 'Rothernburg', '0101000020E61000004FDDA68988882040CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516595, 'MT13', 'NL32-01', NULL, 'ROTHRIST', 'Rothrist', 'Rothrist', '0101000020E61000009A99999999991F406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516598, 'NS43', 'NL32-05', NULL, 'ROTICCIO', 'Roticcio', 'Roticcio', '0101000020E61000007EEF254344442340218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516599, 'MT52', 'NL32-02', NULL, 'ROTKREUZ', 'Rotkreuz', 'Rotkreuz', '0101000020E61000001789BFDCDDDD20403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516600, 'MS72', 'NL32-05', NULL, 'ROTONDA', 'Rotonda', 'Rotonda', '0101000020E61000008210DABCBB3B214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516607, 'LS64', 'NL32-04', NULL, 'ROUGEMONT', 'Rougemont', 'Rougemont', '0101000020E61000006B871AE0DDDD1C40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516609, 'NS11', 'NL32-05', NULL, 'ROVEREDO', 'Roveredo', 'Roveredo', '0101000020E61000007EEF254344442240AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516610, 'MR98', 'NL32-08', NULL, 'ROVIO', 'Rovio', 'Rovio', '0101000020E6100000B122597677F7214087EA9C5555F54640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516611, 'LS28', 'NL32-04', NULL, 'ROVRAY', 'Rovray', 'Rovray', '0101000020E61000009EBA4D1311111B4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516616, 'LS89', 'NL32-04', NULL, 'RUBIGEN', 'Rubigen', 'Rubigen', '0101000020E61000009578E51F22221E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516618, 'MT00', 'NL32-04', NULL, 'RUDERSWIL', 'Rüderswil', 'Ruderswil', '0101000020E61000006245B2ECEEEE1E40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516619, 'MT67', 'NL32-02', NULL, 'RUDLINGEN', 'Rüdlingen', 'Rudlingen', '0101000020E6100000E976402322222140791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516620, 'MT54', 'NL32-02', NULL, 'RUDOLFSTETTEN', 'Rudolfstetten', 'Rudolfstetten', '0101000020E61000007EEF254344C42040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516621, 'LS36', 'NL32-04', NULL, 'RUE', 'Rue', 'Rue', '0101000020E6100000D1ED804644441B40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516622, 'LS88', 'NL32-04', NULL, 'RUEGGISBERG', 'Rüeggisberg', 'Rueggisberg', '0101000020E61000002F127FB9BBBB1D40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516623, 'MS77', 'NL32-05', NULL, 'RUERAS', 'Ruèras', 'Rueras', '0101000020E61000001789BFDCDD5D21400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516625, 'NS18', 'NL32-05', NULL, 'RUEUN', 'Rueun', 'Rueun', '0101000020E6100000CDCCCCCCCC4C224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516626, 'LS46', 'NL32-04', NULL, 'RUEYRES', 'Rueyres', 'Rueyres', '0101000020E6100000CDCCCCCCCCCC1B403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516628, 'NT02', 'NL32-02', NULL, 'RUFI', 'Rufi', 'Rufi', '0101000020E61000009A9999999919224046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516630, 'NS17', 'NL32-05', NULL, 'RUIS', 'Ruis', 'Ruis', '0101000020E6100000CDCCCCCCCC4C224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516631, 'MT56', 'NL32-02', NULL, 'RUMIKON', 'Rümikon', 'Rumikon', '0101000020E61000008210DABCBBBB2040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516632, 'MT65', 'NL32-02', NULL, 'RUMLANG', 'Rümlang', 'Rumlang', '0101000020E61000004BBCF20F111121409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516633, 'MT15', 'NL32-01', NULL, 'RUNENBERG', 'Rünenberg', 'Runenberg', '0101000020E6100000FCDE4B8688881F4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516634, 'NT34', 'NL32-02', NULL, 'RUPPEN', 'Ruppen', 'Ruppen', '0101000020E61000000000000000002340DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516635, 'MT35', 'NL32-02', NULL, 'RUPPERSWIL', 'Rupperswil', 'Rupperswil', '0101000020E61000007EEF25434444204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516637, 'LS78', 'NL32-04', NULL, 'RUSCHEGG', 'Rüschegg', 'Ruschegg', '0101000020E61000009A99999999991D4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516638, 'LS78', 'NL32-04', NULL, 'RUSCHEGGGRABEN', 'Rüschegg-Graben', 'Ruschegg-Graben', '0101000020E61000009A99999999991D406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516639, 'NS18', 'NL32-05', NULL, 'RUSCHEIN', 'Ruschein', 'Ruschein', '0101000020E6100000666666666666224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516640, 'MT63', 'NL32-02', NULL, 'RUSCHLIKON', 'Rüschlikon', 'Ruschlikon', '0101000020E61000009A999999991921406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516643, 'MT84', 'NL32-02', NULL, 'RUSSIKON', 'Russikon', 'Russikon', '0101000020E61000004FDDA68988882140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516644, 'KS61', 'NL32-04', NULL, 'RUSSIN', 'Russin', 'Russin', '0101000020E61000009EBA4D131111184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516645, 'MT52', 'NL32-02', NULL, 'RUSTENSCHWIL', 'Rüstenschwil', 'Rustenschwil', '0101000020E61000008210DABCBBBB2040ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516646, 'MT31', 'NL32-02', NULL, 'RUSWIL', 'Ruswil', 'Ruswil', '0101000020E61000008210DABCBB3B2040791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516648, 'NT43', 'NL32-02', NULL, 'RUTHI', 'Rüthi', 'Ruthi', '0101000020E61000004BBCF20F111123406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516649, 'NS09', 'NL32-05', NULL, 'RUTI', 'Rüti', 'Ruti', '0101000020E61000004FDDA6898808224046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516650, 'LT72', 'NL32-01', NULL, 'RUTI', 'Rüti', 'Ruti', '0101000020E61000009A99999999991D403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516651, 'MT83', 'NL32-02', NULL, 'RUTI', 'Rüti', 'Ruti', '0101000020E61000003333333333B321400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516653, 'MT60', 'NL32-05', NULL, 'RUTLI', 'Rütli', 'Rutli', '0101000020E61000003333333333332140ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516654, 'LT80', 'NL32-04', NULL, 'RUTTI', 'Rütti', 'Rutti', '0101000020E61000006B871AE0DDDD1D40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516660, 'LS64', 'NL32-04', NULL, 'SAANEN', 'Saanen', 'Saanen', '0101000020E61000000000000000001D40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516661, 'LS65', 'NL32-04', NULL, 'SAANENMOSER', 'Saanenmöser', 'Saanenmoser', '0101000020E61000003333333333331D4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516662, 'NS69', 'NL32-05', NULL, 'SAAS', 'Saas', 'Saas', '0101000020E61000009A9999999999234087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516663, 'MS10', 'NL32-04', NULL, 'SAASALMAGEL', 'Saas-Almagel', 'Saas-Almagel', '0101000020E6100000CDCCCCCCCCCC1F40CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516664, 'MS11', 'NL32-04', NULL, 'SAASBALEN', 'Saas-Balen', 'Saas-Balen', '0101000020E61000003854E7ACAAAA1F403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516666, 'MS10', 'NL32-04', NULL, 'SAASFEE', 'Saas-Fee', 'Saas-Fee', '0101000020E61000003854E7ACAAAA1F40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516667, 'MS10', 'NL32-04', NULL, 'SAASGRUND', 'Saas-Grund', 'Saas-Grund', '0101000020E61000002F127FB9BBBB1F40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516670, 'MS63', 'NL32-05', NULL, 'SABBIONE', 'Sabbione', 'Sabbione', '0101000020E6100000E976402322222140218436EFEE2E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516671, 'MS49', 'NL32-05', NULL, 'SACHSELN', 'Sachseln', 'Sachseln', '0101000020E6100000B122597677772040218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516673, 'LS71', 'NL32-04', NULL, 'SACLENTSE', 'Saclentse', 'Saclentse', '0101000020E6100000D1ED804644441D4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516675, 'MT24', 'NL32-01', NULL, 'SAFENWIL', 'Safenwil', 'Safenwil', '0101000020E61000006245B2ECEEEE1F40BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516676, 'NS27', 'NL32-05', NULL, 'SAFIENPLATZ', 'Safien Platz', 'Safien Platz', '0101000020E61000009A9999999999224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516680, 'MS33', 'NL32-05', NULL, 'SAFLISCHMATTEN', 'Saflischmatten', 'Saflischmatten', '0101000020E61000001CAA735655552040CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516681, 'LS86', 'NL32-04', NULL, 'SAGE', 'Säge', 'Sage', '0101000020E61000003333333333331E40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516683, 'MS08', 'NL32-04', NULL, 'SAGE', 'Säge', 'Sage', '0101000020E61000009578E51F22221F4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516688, 'NS56', 'NL32-05', NULL, 'SAGLIAZ', 'Sagliaz', 'Sagliaz', '0101000020E61000000000000000802340218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516689, 'NS18', 'NL32-05', NULL, 'SAGOGN', 'Sagogn', 'Sagogn', '0101000020E610000000000000008022406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516690, 'LT63', 'NL32-01', NULL, 'SAICOURT', 'Saicourt', 'Saicourt', '0101000020E6100000CDCCCCCCCCCC1C400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516691, 'LT43', 'NL32-01', NULL, 'SAIGNELEGIER', 'Saignelégier', 'Saignelegier', '0101000020E61000000000000000001C400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516692, 'LS51', 'NL32-04', NULL, 'SAILLON', 'Saillon', 'Saillon', '0101000020E61000002F127FB9BBBB1C4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516693, 'LS29', 'NL32-04', NULL, 'SAINTAUBIN', 'Saint-Aubin', 'Saint-Aubin', '0101000020E61000009EBA4D1311111B40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516694, 'LS49', 'NL32-04', NULL, 'SAINTAUBIN', 'Saint-Aubin', 'Saint-Aubin', '0101000020E61000006B871AE0DDDD1B403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516697, 'LT40', 'NL32-01', NULL, 'SAINTBLAISE', 'Saint-Blaise', 'Saint-Blaise', '0101000020E61000006245B2ECEEEE1B4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516698, 'LT54', 'NL32-01', NULL, 'SAINTBRAIS', 'Saint-Brais', 'Saint-Brais', '0101000020E61000000421B47977771C406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516699, 'KS84', 'NL32-04', NULL, 'SAINTCERGUE', 'Saint-Cergue', 'Saint-Cergue', '0101000020E61000003854E7ACAAAA18409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516702, 'LS08', 'NL32-04', NULL, 'SAINTECROIX', 'Sainte-Croix', 'Sainte-Croix', '0101000020E61000000000000000001A40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516708, 'LS72', 'NL32-04', NULL, 'SAINTGERMAIN', 'Saint-Germain', 'Saint-Germain', '0101000020E61000006666666666661D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516710, 'LS33', 'NL32-04', NULL, 'SAINTGINGOLPH', 'Saint-Gingolph', 'Saint-Gingolph', '0101000020E61000003333333333331B40DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516719, 'LT42', 'NL32-01', NULL, 'SAINTIMIER', 'Saint-Imier', 'Saint-Imier', '0101000020E61000000000000000001C403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516723, 'LS91', 'NL32-04', NULL, 'SAINTJEAN', 'Saint-Jean', 'Saint-Jean', '0101000020E6100000C8AB185355551E409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516724, 'LS72', 'NL32-04', NULL, 'SAINTLEONARD', 'Saint-Léonard', 'Saint-Leonard', '0101000020E61000003854E7ACAAAA1D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516725, 'KS95', 'NL32-04', NULL, 'SAINTLIVRES', 'Saint-Livres', 'Saint-Livres', '0101000020E6100000FCDE4B868888194054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516726, 'LS91', 'NL32-04', NULL, 'SAINTLUC', 'Saint-Luc', 'Saint-Luc', '0101000020E61000006666666666661E40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516727, 'LS71', 'NL32-04', NULL, 'SAINTMARTIN', 'Saint-Martin', 'Saint-Martin', '0101000020E61000002F127FB9BBBB1D4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516729, 'LS42', 'NL32-04', NULL, 'SAINTMAURICE', 'Saint-Maurice', 'Saint-Maurice', '0101000020E61000000000000000001C40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516733, 'LS61', 'NL32-04', NULL, 'SAINTPIERREDECLAGES', 'Saint-Pierre-de-Clages', 'Saint-Pierre-de-Clages', '0101000020E61000006245B2ECEEEE1C4046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516734, 'LS05', 'NL32-04', NULL, 'SAINTPREX', 'Saint-Prex', 'Saint-Prex', '0101000020E61000006B871AE0DDDD1940AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516735, 'LS72', 'NL32-04', NULL, 'SAINTROMAIN', 'Saint-Romain', 'Saint-Romain', '0101000020E61000003854E7ACAAAA1D4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516736, 'LS15', 'NL32-04', NULL, 'SAINTSULPICE', 'Saint-Sulpice', 'Saint-Sulpice', '0101000020E6100000D1ED804644441A4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516737, 'LS19', 'NL32-04', NULL, 'SAINTSULPICE', 'Saint-Sulpice', 'Saint-Sulpice', '0101000020E6100000D1ED804644441A4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516738, 'LT64', 'NL32-01', NULL, 'SAINTURSANNE', 'Saint-Ursanne', 'Saint-Ursanne', '0101000020E61000009A99999999991C40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516739, 'MS90', 'NL32-05', NULL, 'SALA', 'Sala', 'Sala', '0101000020E61000001CAA735655D52140BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516740, 'MT84', 'NL32-02', NULL, 'SALAND', 'Saland', 'Saland', '0101000020E61000003333333333B32140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516744, 'NS45', 'NL32-05', NULL, 'SALATEGNAS', 'Salategnas', 'Salategnas', '0101000020E6100000CDCCCCCCCC4C234054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516745, 'LS46', 'NL32-04', NULL, 'SALES', 'Sâles', 'Sales', '0101000020E61000006B871AE0DDDD1B40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516746, 'NT33', 'NL32-02', NULL, 'SALEZ', 'Salez', 'Salez', '0101000020E61000000000000000002340AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516747, 'LS93', 'NL32-04', NULL, 'SALGESCH', 'Salgesch', 'Salgesch', '0101000020E6100000C8AB185355551E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516750, 'NT26', 'NL32-02', NULL, 'SALMSACH', 'Salmsach', 'Salmsach', '0101000020E61000008210DABCBBBB22406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516752, 'NS46', 'NL32-05', NULL, 'SALUX', 'Salux', 'Salux', '0101000020E6100000E4558CA9AA2A2340DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516753, 'LS40', 'NL32-04', NULL, 'SALVAN', 'Salvan', 'Salvan', '0101000020E61000009EBA4D1311111C40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516754, 'NS65', 'NL32-05', NULL, 'SAMADEN', 'Samaden', 'Samaden', '0101000020E61000008210DABCBBBB234013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516761, 'MS74', 'NL32-05', NULL, 'SAMBUCODIFUORI', 'Sambuco di Fuori', 'Sambuco di Fuori', '0101000020E6100000CDCCCCCCCC4C2140ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516763, 'PS09', 'NL32-06', NULL, 'SAMNAUN', 'Samnaun', 'Samnaun', '0101000020E61000003333333333B3244046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516764, 'MT72', 'NL32-02', NULL, 'SAMSTAGERN', 'Samstagern', 'Samstagern', '0101000020E61000001789BFDCDD5D21409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516765, 'NS14', 'NL32-05', NULL, 'SANBERNARDINO', 'San Bernardino', 'San Bernardino', '0101000020E610000066666666666622409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516768, 'NS73', 'NL32-06', NULL, 'SANCARLO', 'San Carlo', 'San Carlo', '0101000020E61000004BBCF20F11112440791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516769, 'MS64', 'NL32-05', NULL, 'SANCARLO', 'San Carlo', 'San Carlo', '0101000020E61000004BBCF20F1111214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516770, 'MS74', 'NL32-05', NULL, 'SANCARLO', 'San Carlo', 'San Carlo', '0101000020E61000007EEF25434444214087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516775, 'LS77', 'NL32-04', NULL, 'SANGERNBODEN', 'Sangernboden', 'Sangernboden', '0101000020E61000006666666666661D40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516780, 'MS86', 'NL32-05', NULL, 'SANGIONS', 'San Gions', 'San Gions', '0101000020E6100000E4558CA9AAAA2140218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516781, 'NS06', 'NL32-05', NULL, 'SANGIUSEP', 'San Giusep', 'San Giusep', '0101000020E6100000E4558CA9AA2A22403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516785, 'MS76', 'NL32-05', NULL, 'SANGOTTARDO', 'San Gottardo', 'San Gottardo', '0101000020E61000008210DABCBB3B2140218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516794, 'LS68', 'NL32-04', NULL, 'SANKTANTONI', 'Sankt Antoni', 'Sankt Antoni', '0101000020E61000009EBA4D1311111D40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516795, 'NT60', 'NL32-05', NULL, 'SANKTANTONIEN', 'Sankt Antönien', 'Sankt Antonien', '0101000020E61000009A99999999992340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516798, 'NT25', 'NL32-02', NULL, 'SANKTFIDEN', 'Sankt Fiden', 'Sankt Fiden', '0101000020E61000007EEF254344C4224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516800, 'NT35', 'NL32-02', 2, 'SANKTGALLEN', 'Sankt Gallen', 'Sankt Gallen', '0101000020E6100000CDCCCCCCCCCC2240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516802, 'MT93', 'NL32-02', NULL, 'SANKTGALLENKAPPEL', 'Sankt Gallenkappel', 'Sankt Gallenkappel', '0101000020E6100000B122597677F721400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516803, 'MS02', 'NL32-04', NULL, 'SANKTGERMAN', 'Sankt German', 'Sankt German', '0101000020E6100000D1ED804644441F40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516808, 'MS69', 'NL32-05', NULL, 'SANKTJAKOB', 'Sankt Jakob', 'Sankt Jakob', '0101000020E61000004FDDA689880821403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516809, 'LT97', 'NL32-01', NULL, 'SANKTJOHANN', 'Sankt Johann', 'Sankt Johann', '0101000020E6100000D1ED804644441E40218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516810, 'NT45', 'NL32-02', NULL, 'SANKTMARGRETHEN', 'Sankt Margrethen', 'Sankt Margrethen', '0101000020E61000008210DABCBB3B23409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516811, 'NS16', 'NL32-05', NULL, 'SANKTMARTIN', 'Sankt Martin', 'Sankt Martin', '0101000020E61000001789BFDCDD5D224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516812, 'NS29', 'NL32-05', NULL, 'SANKTMARTIN', 'Sankt Martin', 'Sankt Martin', '0101000020E61000003333333333B3224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516813, 'NS64', 'NL32-05', NULL, 'SANKTMORITZ', 'Sankt Moritz', 'Sankt Moritz', '0101000020E6100000E4558CA9AAAA23400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516815, 'NS64', 'NL32-05', NULL, 'SANKTMORITZBAD', 'Sankt Moritz-Bad', 'Sankt Moritz-Bad', '0101000020E6100000E4558CA9AAAA2340ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516818, 'MS01', 'NL32-04', NULL, 'SANKTNIKLAUS', 'Sankt Niklaus', 'Sankt Niklaus', '0101000020E61000003333333333331F4087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516819, 'LT83', 'NL32-01', NULL, 'SANKTNIKLAUS', 'Sankt Niklaus', 'Sankt Niklaus', '0101000020E61000009578E51F22221E40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516820, 'NS48', 'NL32-05', NULL, 'SANKTPETER', 'Sankt Peter', 'Sankt Peter', '0101000020E6100000CDCCCCCCCC4C2340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516822, 'NT14', 'NL32-02', NULL, 'SANKTPETERZELL', 'Sankt Peterzell', 'Sankt Peterzell', '0101000020E61000001789BFDCDD5D2240BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516823, 'LS75', 'NL32-04', NULL, 'SANKTSTEPHAN', 'Sankt Stephan', 'Sankt Stephan', '0101000020E61000009A99999999991D4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516824, 'LS68', 'NL32-04', NULL, 'SANKTURSEN', 'Sankt Ursen', 'Sankt Ursen', '0101000020E61000006B871AE0DDDD1C406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516826, 'MS80', 'NL32-05', NULL, 'SANNAZZARO', 'San Nazzaro', 'San Nazzaro', '0101000020E61000009A99999999992140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516829, 'NS03', 'NL32-05', NULL, 'SANTADOMENICA', 'Santa Domenica', 'Santa Domenica', '0101000020E61000008210DABCBB3B2240CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516830, 'NS12', 'NL32-05', NULL, 'SANTAMARIA', 'Santa Maria', 'Santa Maria', '0101000020E61000007EEF25434444224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516831, 'PS06', 'NL32-06', NULL, 'SANTAMARIA', 'Santa Maria', 'Santa Maria', '0101000020E61000001CAA735655D52440CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516835, 'NS01', 'NL32-05', NULL, 'SANTANTONIO', 'Sant’Antonio', 'Sant’Antonio', '0101000020E6100000E97640232222224087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516837, 'NS01', 'NL32-05', NULL, 'SANVITTORE', 'San Vittore', 'San Vittore', '0101000020E61000008210DABCBB3B2240AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516838, 'LS51', 'NL32-04', NULL, 'SAPINHAUT', 'Sapinhaut', 'Sapinhaut', '0101000020E61000003854E7ACAAAA1C40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516839, 'NS79', 'NL32-06', NULL, 'SARDASCA', 'Sardasca', 'Sardasca', '0101000020E61000000000000000002440218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516841, 'NT31', 'NL32-02', NULL, 'SARGANS', 'Sargans', 'Sargans', '0101000020E61000001789BFDCDDDD22406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516845, 'LT70', 'NL32-04', NULL, 'SARISWIL', 'Säriswil', 'Sariswil', '0101000020E6100000C8AB185355551D40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516846, 'MT44', 'NL32-02', NULL, 'SARMENSTORF', 'Sarmenstorf', 'Sarmenstorf', '0101000020E61000000000000000802040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516847, 'NS37', 'NL32-05', NULL, 'SARN', 'Sarn', 'Sarn', '0101000020E6100000CDCCCCCCCCCC2240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516848, 'MS49', 'NL32-05', 4, 'SARNEN', 'Sarnen', 'Sarnen', '0101000020E6100000B1225976777720403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516853, 'KS72', 'NL32-04', NULL, 'SATIGNY', 'Satigny', 'Satigny', '0101000020E61000009578E51F22221840ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516854, 'MT71', 'NL32-02', NULL, 'SATTEL', 'Sattel', 'Sattel', '0101000020E61000007EEF254344442140791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516855, 'LS29', 'NL32-04', NULL, 'SAUGES', 'Sauges', 'Sauges', '0101000020E61000009EBA4D1311111B40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516856, 'LT64', 'NL32-01', NULL, 'SAULCY', 'Saulcy', 'Saulcy', '0101000020E61000009A99999999991C406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516858, 'MS15', 'NL32-04', NULL, 'SAUSOBERBERG', 'Saus Oberberg', 'Saus Oberberg', '0101000020E61000006666666666661F40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516860, 'LS42', 'NL32-04', NULL, 'SAVATAN', 'Savatan', 'Savatan', '0101000020E61000009EBA4D1311111C40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516861, 'LS72', 'NL32-04', NULL, 'SAVIESE', 'Savièse', 'Saviese', '0101000020E61000006666666666661D400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516862, 'LS25', 'NL32-04', NULL, 'SAVIGNY', 'Savigny', 'Savigny', '0101000020E61000006245B2ECEEEE1A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516863, 'NS46', 'NL32-05', NULL, 'SAVOGNIN', 'Savognin', 'Savognin', '0101000020E61000003333333333332340CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516864, 'MR99', 'NL32-05', NULL, 'SAVOSAPAESE', 'Savosa Paese', 'Savosa Paese', '0101000020E61000001CAA735655D5214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516865, 'NT33', 'NL32-02', NULL, 'SAX', 'Sax', 'Sax', '0101000020E61000006666666666E62240AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516866, 'MS16', 'NL32-04', NULL, 'SAXETEN', 'Saxeten', 'Saxeten', '0101000020E6100000C8AB185355551F40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516867, 'LS51', 'NL32-04', NULL, 'SAXON', 'Saxon', 'Saxon', '0101000020E61000002F127FB9BBBB1C403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516868, 'NS82', 'NL32-06', NULL, 'SCALA', 'Scala', 'Scala', '0101000020E61000008210DABCBB3B2440AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516870, 'NS76', 'NL32-05', NULL, 'SCANFS', 'Scanfs', 'Scanfs', '0101000020E6100000B122597677F72340218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516871, 'MS81', 'NL32-05', NULL, 'SCERESIO', 'Sceresio', 'Sceresio', '0101000020E61000004BBCF20F11912140ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516873, 'MT30', 'NL32-02', NULL, 'SCHACHEN', 'Schachen', 'Schachen', '0101000020E61000007EEF25434444204013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516879, 'MT78', 'NL32-02', 3, 'SCHAFFHAUSEN', 'Schaffhausen', 'Schaffhausen', '0101000020E61000007EEF2543444421409A99999999D94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516884, 'MT34', 'NL32-02', NULL, 'SCHAFISHEIM', 'Schafisheim', 'Schafisheim', '0101000020E61000007EEF254344442040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516885, 'MS47', 'NL32-05', NULL, 'SCHAFTELEN', 'Schaftelen', 'Schaftelen', '0101000020E6100000E4558CA9AAAA2040ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516892, 'MS18', 'NL32-04', NULL, 'SCHANGNAU', 'Schangnau', 'Schangnau', '0101000020E61000006666666666661F40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516893, 'NT02', 'NL32-02', NULL, 'SCHANIS', 'Schänis', 'Schanis', '0101000020E61000009A999999991922403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516894, 'NS37', 'NL32-05', NULL, 'SCHARANS', 'Scharans', 'Scharans', '0101000020E6100000B5430DF0EEEE2240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516895, 'PS07', 'NL32-06', NULL, 'SCHARL', 'S-charl', 'S-charl', '0101000020E6100000E4558CA9AAAA2440ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516896, 'MS19', 'NL32-04', NULL, 'SCHARLIG', 'Schärlig', 'Scharlig', '0101000020E61000009A99999999991F40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516898, 'MS57', 'NL32-05', NULL, 'SCHARMADLAGER', 'Scharmadläger', 'Scharmadlager', '0101000020E61000003333333333B3204054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516899, 'MS79', 'NL32-05', NULL, 'SCHATTDORF', 'Schattdorf', 'Schattdorf', '0101000020E6100000CDCCCCCCCC4C2140218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516900, 'NS68', 'NL32-05', NULL, 'SCHATZALP', 'Schatzalp', 'Schatzalp', '0101000020E6100000E976402322A22340BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516902, 'NS38', 'NL32-05', NULL, 'SCHEID', 'Scheid', 'Scheid', '0101000020E61000006666666666E6224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516904, 'LT94', 'NL32-01', NULL, 'SCHELTEN', 'Schelten', 'Schelten', '0101000020E61000003333333333331E40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516905, 'MT32', 'NL32-02', NULL, 'SCHENKON', 'Schenkon', 'Schenkon', '0101000020E61000007EEF25434444204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516908, 'LS78', 'NL32-04', NULL, 'SCHERLIAU', 'Scherliau', 'Scherliau', '0101000020E61000003854E7ACAAAA1D40CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516909, 'NT17', 'NL32-02', NULL, 'SCHERZINGEN', 'Scherzingen', 'Scherzingen', '0101000020E6100000B5430DF0EE6E2240DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516910, 'LS97', 'NL32-04', NULL, 'SCHERZLIGEN', 'Scherzligen', 'Scherzligen', '0101000020E6100000FCDE4B8688881E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516913, 'NT50', 'NL32-05', NULL, 'SCHIERS', 'Schiers', 'Schiers', '0101000020E61000001789BFDCDD5D2340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516916, 'MS39', 'NL32-05', NULL, 'SCHIMBERGBAD', 'Schimbergbad', 'Schimbergbad', '0101000020E6100000333333333333204046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516917, 'MT72', 'NL32-02', NULL, 'SCHINDELLEGI', 'Schindellegi', 'Schindellegi', '0101000020E6100000666666666666214087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516919, 'MT35', 'NL32-02', NULL, 'SCHINZNACHBAD', 'Schinznach Bad', 'Schinznach Bad', '0101000020E61000001CAA73565555204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516920, 'MT35', 'NL32-02', NULL, 'SCHINZNACHDORF', 'Schinznach Dorf', 'Schinznach Dorf', '0101000020E61000007EEF2543444420409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516923, 'NT34', 'NL32-02', NULL, 'SCHLATT', 'Schlatt', 'Schlatt', '0101000020E6100000CDCCCCCCCCCC2240CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516925, 'MT77', 'NL32-02', NULL, 'SCHLATT', 'Schlatt', 'Schlatt', '0101000020E6100000666666666666214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516926, 'MT87', 'NL32-02', NULL, 'SCHLATTINGEN', 'Schlattingen', 'Schlattingen', '0101000020E6100000000000000080214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516927, 'PS09', 'NL32-06', NULL, 'SCHLEINS', 'Schleins', 'Schleins', '0101000020E61000001789BFDCDDDD2440218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516928, 'MT68', 'NL32-02', NULL, 'SCHLEITHEIM', 'Schleitheim', 'Schleitheim', '0101000020E6100000B122597677F720400000000000E04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516929, 'NS18', 'NL32-05', NULL, 'SCHLEUIS', 'Schleuis', 'Schleuis', '0101000020E6100000B5430DF0EE6E224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516930, 'MT54', 'NL32-02', NULL, 'SCHLIEREN', 'Schlieren', 'Schlieren', '0101000020E61000006666666666E620403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516933, 'MT33', 'NL32-02', NULL, 'SCHLOSSRUED', 'Schlossrued', 'Schlossrued', '0101000020E6100000E4558CA9AA2A204013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516935, 'NS48', 'NL32-05', NULL, 'SCHLUOCHT', 'Schluocht', 'Schluocht', '0101000020E61000009A99999999192340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516936, 'NS57', 'NL32-05', NULL, 'SCHMELZBODEN', 'Schmelzboden', 'Schmelzboden', '0101000020E610000000000000008023409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516938, 'MT92', 'NL32-02', NULL, 'SCHMERIKON', 'Schmerikon', 'Schmerikon', '0101000020E61000001789BFDCDDDD2140ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516939, 'NS57', 'NL32-05', NULL, 'SCHMITTEN', 'Schmitten', 'Schmitten', '0101000020E61000001CAA73565555234046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516940, 'LS69', 'NL32-04', NULL, 'SCHMITTEN', 'Schmitten', 'Schmitten', '0101000020E61000000000000000001D40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516943, 'LT71', 'NL32-01', NULL, 'SCHNOTTWIL', 'Schnottwil', 'Schnottwil', '0101000020E6100000FCDE4B8688881D40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516945, 'MT23', 'NL32-02', NULL, 'SCHOFTLAND', 'Schöftland', 'Schoftland', '0101000020E61000009A999999991920406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516947, 'LT80', 'NL32-01', NULL, 'SCHONBUHL', 'Schönbühl', 'Schonbuhl', '0101000020E61000000000000000001E4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516948, 'MS69', 'NL32-05', NULL, 'SCHONECK', 'Schöneck', 'Schoneck', '0101000020E61000004FDDA689880821409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516950, 'MT72', 'NL32-02', NULL, 'SCHONENBERG', 'Schönenberg', 'Schonenberg', '0101000020E61000007EEF2543444421409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516951, 'NT16', 'NL32-02', NULL, 'SCHONENBERG', 'Schönenberg', 'Schonenberg', '0101000020E61000001789BFDCDD5D224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516952, 'LT86', 'NL32-01', NULL, 'SCHONENBUCH', 'Schönenbuch', 'Schonenbuch', '0101000020E61000006245B2ECEEEE1D4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516953, 'NT14', 'NL32-02', NULL, 'SCHONENGRUND', 'Schönengrund', 'Schonengrund', '0101000020E6100000B122597677772240BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516954, 'MT24', 'NL32-02', NULL, 'SCHONENWERD', 'Schönenwerd', 'Schonenwerd', '0101000020E61000000000000000002040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516955, 'MT43', 'NL32-02', NULL, 'SCHONGAU', 'Schongau', 'Schongau', '0101000020E6100000000000000080204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516956, 'NT16', 'NL32-02', NULL, 'SCHONHOLZERSWILEN', 'Schönholzerswilen', 'Schonholzerswilen', '0101000020E61000007EEF25434444224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516957, 'LS65', 'NL32-04', NULL, 'SCHONRIED', 'Schönried', 'Schonried', '0101000020E61000009578E51F22221D400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516959, 'MT22', 'NL32-01', NULL, 'SCHOTZ', 'Schötz', 'Schotz', '0101000020E61000006245B2ECEEEE1F4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516961, 'MS46', 'NL32-05', NULL, 'SCHRATTERN', 'Schrättern', 'Schrattern', '0101000020E6100000B5430DF0EE6E20403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516964, 'LS94', 'NL32-04', NULL, 'SCHRICKMATTEN', 'Schrickmatten', 'Schrickmatten', '0101000020E61000006666666666661E40AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516965, 'MT92', 'NL32-02', NULL, 'SCHUBELBACH', 'Schübelbach', 'Schubelbach', '0101000020E61000001789BFDCDDDD214087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516966, 'NT50', 'NL32-05', NULL, 'SCHUDERS', 'Schuders', 'Schuders', '0101000020E6100000B122597677772340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516967, 'LS74', 'NL32-04', NULL, 'SCHULH', 'Schulh', 'Schulh', '0101000020E6100000C8AB185355551D40ED5003BCBB3B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516968, 'NS98', 'NL32-06', NULL, 'SCHULS', 'Schuls', 'Schuls', '0101000020E61000009A999999999924406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516969, 'MS09', 'NL32-04', NULL, 'SCHUPBACH', 'Schüpbach', 'Schupbach', '0101000020E61000006245B2ECEEEE1E4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516970, 'LT71', 'NL32-01', NULL, 'SCHUPFEN', 'Schüpfen', 'Schupfen', '0101000020E6100000FCDE4B8688881D4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516971, 'MT20', 'NL32-05', NULL, 'SCHUPFHEIM', 'Schüpfheim', 'Schupfheim', '0101000020E61000004FDDA689880820409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516973, 'NS67', 'NL32-05', NULL, 'SCHURLIALP', 'Schürlialp', 'Schurlialp', '0101000020E6100000CDCCCCCCCCCC2340AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516974, 'MT37', 'NL32-02', NULL, 'SCHWADERLOCH', 'Schwaderloch', 'Schwaderloch', '0101000020E61000007EEF254344442040791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516976, 'MS07', 'NL32-04', NULL, 'SCHWANDEN', 'Schwanden', 'Schwanden', '0101000020E61000006B871AE0DDDD1E40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516977, 'NT00', 'NL32-05', NULL, 'SCHWANDEN', 'Schwanden', 'Schwanden', '0101000020E6100000E976402322222240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516978, 'NS19', 'NL32-05', NULL, 'SCHWANDI', 'Schwändi', 'Schwandi', '0101000020E61000001CAA73565555224046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516979, 'NT00', 'NL32-02', NULL, 'SCHWANDI', 'Schwändi', 'Schwandi', '0101000020E6100000E9764023222222400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516980, 'MT30', 'NL32-02', NULL, 'SCHWARZENBERG', 'Schwarzenberg', 'Schwarzenberg', '0101000020E61000001CAA73565555204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516981, 'LS78', 'NL32-04', NULL, 'SCHWARZENBURG', 'Schwarzenburg', 'Schwarzenburg', '0101000020E6100000C8AB185355551D40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516982, 'MS08', 'NL32-04', NULL, 'SCHWARZENEGG', 'Schwarzenegg', 'Schwarzenegg', '0101000020E61000006B871AE0DDDD1E406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516983, 'MS47', 'NL32-05', NULL, 'SCHWARZENTHAL', 'Schwarzenthal', 'Schwarzenthal', '0101000020E6100000E976402322A220400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516989, 'LS77', 'NL32-04', NULL, 'SCHWEFELBERGBAD', 'Schwefelbergbad', 'Schwefelbergbad', '0101000020E61000003854E7ACAAAA1D40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516990, 'LT96', 'NL32-01', NULL, 'SCHWEIZERHALLE', 'Schweizerhalle', 'Schweizerhalle', '0101000020E61000003854E7ACAAAA1E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516998, 'NT14', 'NL32-02', NULL, 'SCHWELLBRUNN', 'Schwellbrunn', 'Schwellbrunn', '0101000020E61000000000000000802240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3516999, 'MS17', 'NL32-04', NULL, 'SCHWENDI', 'Schwendi', 'Schwendi', '0101000020E6100000FCDE4B8688881F40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517000, 'MS07', 'NL32-04', NULL, 'SCHWENDI', 'Schwendi', 'Schwendi', '0101000020E6100000CDCCCCCCCCCC1E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517002, 'MS39', 'NL32-05', NULL, 'SCHWENDIKALTBAD', 'Schwendikaltbad', 'Schwendikaltbad', '0101000020E61000008210DABCBB3B20403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517005, 'MT70', 'NL32-02', 3, 'SCHWYZ', 'Schwyz', 'Schwyz', '0101000020E6100000CDCCCCCCCC4C214054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517009, 'MS95', 'NL32-05', NULL, 'SCONA', 'Scona', 'Scona', '0101000020E61000001CAA735655D5214013AFFC4344444740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517011, 'NS98', 'NL32-06', NULL, 'SCUOL', 'Scuol', 'Scuol', '0101000020E61000009A999999999924406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517012, 'KS82', 'NL32-04', NULL, 'SECHERON', 'Sécheron', 'Secheron', '0101000020E61000003854E7ACAAAA18409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517013, 'LS47', 'NL32-04', NULL, 'SEDEILLES', 'Sedeilles', 'Sedeilles', '0101000020E61000002F127FB9BBBB1B400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517014, 'MS86', 'NL32-05', NULL, 'SEDRUN', 'Sedrun', 'Sedrun', '0101000020E61000004BBCF20F1191214046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517015, 'MT64', 'NL32-02', NULL, 'SEEBACH', 'Seebach', 'Seebach', '0101000020E61000009A99999999192140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517016, 'LT92', 'NL32-01', NULL, 'SEEBERG', 'Seeberg', 'Seeberg', '0101000020E61000003854E7ACAAAA1E403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517017, 'MS69', 'NL32-05', NULL, 'SEEDORF', 'Seedorf', 'Seedorf', '0101000020E61000003333333333332140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517018, 'LT71', 'NL32-01', NULL, 'SEEDORF', 'Seedorf', 'Seedorf', '0101000020E61000003333333333331D4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517020, 'MT84', 'NL32-02', NULL, 'SEEGRABEN', 'Seegräben', 'Seegraben', '0101000020E61000004FDDA68988882140CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517021, 'MT60', 'NL32-05', NULL, 'SEELISBERG', 'Seelisberg', 'Seelisberg', '0101000020E6100000E4558CA9AA2A2140ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517022, 'MT44', 'NL32-02', NULL, 'SEENGEN', 'Seengen', 'Seengen', '0101000020E6100000B5430DF0EE6E2040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517025, 'MT70', 'NL32-02', NULL, 'SEEWES', 'Seewes', 'Seewes', '0101000020E61000007EEF25434444214054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517026, 'NS17', 'NL32-05', NULL, 'SEEWIS', 'Seewis', 'Seewis', '0101000020E6100000B5430DF0EE6E224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517030, 'NT40', 'NL32-05', NULL, 'SEEWISIMPRATIGAU', 'Seewis im Prätigau', 'Seewis im Pratigau', '0101000020E61000007EEF254344442340AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517036, 'LS88', 'NL32-04', NULL, 'SEFTIGEN', 'Seftigen', 'Seftigen', '0101000020E61000009578E51F22221E4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517037, 'NS54', 'NL32-05', NULL, 'SEGLMARIA', 'Segl-Maria', 'Segl-Maria', '0101000020E61000004FDDA6898888234046E22F7777374740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517041, 'NS68', 'NL32-05', NULL, 'SELFRANGA', 'Selfranga', 'Selfranga', '0101000020E61000007EEF254344C42340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517043, 'NS02', 'NL32-05', NULL, 'SELMA', 'Selma', 'Selma', '0101000020E61000008210DABCBB3B2240BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517044, 'MT05', 'NL32-01', NULL, 'SELTISBERG', 'Seltisberg', 'Seltisberg', '0101000020E61000006B871AE0DDDD1E409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517045, 'LT82', 'NL32-01', NULL, 'SELZACH', 'Selzach', 'Selzach', '0101000020E61000002F127FB9BBBB1D409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517046, 'LS50', 'NL32-04', NULL, 'SEMBRANCHER', 'Sembrancher', 'Sembrancher', '0101000020E61000009A99999999991C40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517047, 'MS91', 'NL32-05', NULL, 'SEMENTINA', 'Sementina', 'Sementina', '0101000020E6100000B122597677F7214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517048, 'MT32', 'NL32-02', NULL, 'SEMPACH', 'Sempach', 'Sempach', '0101000020E61000006666666666662040DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517052, 'LS46', 'NL32-04', NULL, 'SEMSALES', 'Semsales', 'Semsales', '0101000020E61000002F127FB9BBBB1B40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517053, 'MS17', 'NL32-04', NULL, 'SENGG', 'Sengg', 'Sengg', '0101000020E6100000CDCCCCCCCCCC1F409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517054, 'MT85', 'NL32-02', NULL, 'SENNHOF', 'Sennhof', 'Sennhof', '0101000020E61000000000000000802140ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517055, 'NT33', 'NL32-02', NULL, 'SENNWALD', 'Sennwald', 'Sennwald', '0101000020E6100000000000000000234054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517057, 'PS08', 'NL32-06', NULL, 'SENT', 'Sent', 'Sent', '0101000020E6100000E4558CA9AAAA2440BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517058, 'MT34', 'NL32-02', NULL, 'SEON', 'Seon', 'Seon', '0101000020E6100000CDCCCCCCCC4C2040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517060, 'PS08', 'NL32-06', NULL, 'SERAPLANA', 'Seraplana', 'Seraplana', '0101000020E61000001CAA735655D52440CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517065, 'LT40', 'NL32-04', NULL, 'SERRIERES', 'Serrières', 'Serrieres', '0101000020E61000009A99999999991B40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517066, 'NS67', 'NL32-05', NULL, 'SERTIGDOFLI', 'Sertig Döfli', 'Sertig Dofli', '0101000020E61000003333333333B32340AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517067, 'MR89', 'NL32-05', NULL, 'SESSA', 'Sessa', 'Sessa', '0101000020E6100000E976402322A221400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517069, 'NS18', 'NL32-05', NULL, 'SETH', 'Seth', 'Seth', '0101000020E6100000CDCCCCCCCC4C224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517071, 'MT76', 'NL32-02', NULL, 'SEUZACH', 'Seuzach', 'Seuzach', '0101000020E6100000B12259767777214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517072, 'NT31', 'NL32-02', NULL, 'SEVELEN', 'Sevelen', 'Sevelen', '0101000020E6100000B122597677F72240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517076, 'KS61', 'NL32-04', NULL, 'SEZEGNIN', 'Sézegnin', 'Sezegnin', '0101000020E61000009EBA4D13111118403333333333134740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517078, 'MT68', 'NL32-02', NULL, 'SIBLINGEN', 'Siblingen', 'Siblingen', '0101000020E61000000000000000002140ED5003BCBBDB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517079, 'MT92', 'NL32-02', NULL, 'SIEBNEN', 'Siebnen', 'Siebnen', '0101000020E6100000CDCCCCCCCCCC214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517080, 'NT17', 'NL32-02', NULL, 'SIEGERSHAUSEN', 'Siegershausen', 'Siegershausen', '0101000020E6100000CDCCCCCCCC4C2240218436EFEECE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517082, 'LS82', 'NL32-04', NULL, 'SIERRE', 'Sierre', 'Sierre', '0101000020E61000009578E51F22221E406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517085, 'MS90', 'NL32-05', NULL, 'SIGIRINO', 'Sigirino', 'Sigirino', '0101000020E61000001CAA735655D52140791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517086, 'MT56', 'NL32-02', NULL, 'SIGLISTORF', 'Siglistorf', 'Siglistorf', '0101000020E61000008210DABCBBBB20406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517089, 'MS09', 'NL32-04', NULL, 'SIGNAU', 'Signau', 'Signau', '0101000020E61000006B871AE0DDDD1E4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517090, 'NS17', 'NL32-05', NULL, 'SIGNINA', 'Signina', 'Signina', '0101000020E61000000000000000802240AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517091, 'NS00', 'NL32-05', NULL, 'SIGNORA', 'Signora', 'Signora', '0101000020E61000009A99999999192240CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517092, 'MS07', 'NL32-04', NULL, 'SIGRISWIL', 'Sigriswil', 'Sigriswil', '0101000020E6100000CDCCCCCCCCCC1E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517098, 'MT62', 'NL32-02', NULL, 'SIHLBRUGGDORF', 'Sihlbrugg Dorf', 'Sihlbrugg Dorf', '0101000020E6100000E4558CA9AA2A214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517100, 'MS78', 'NL32-05', NULL, 'SILENEN', 'Silenen', 'Silenen', '0101000020E61000001CAA73565555214013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517105, 'NS37', 'NL32-05', NULL, 'SILSIMDOMLESCHG', 'Sils im Domleschg', 'Sils im Domleschg', '0101000020E61000006666666666E622409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517109, 'NS64', 'NL32-05', NULL, 'SILVAPLANA', 'Silvaplana', 'Silvaplana', '0101000020E61000004BBCF20F119123409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517117, 'NS79', 'NL32-06', NULL, 'SILVRETTAHAUS', 'Silvrettahaus', 'Silvrettahaus', '0101000020E61000004BBCF20F11112440218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517126, 'MS21', 'NL32-05', NULL, 'SIMPLONDORF', 'Simplon Dorf', 'Simplon Dorf', '0101000020E61000009A9999999919204046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517132, 'MT52', 'NL32-02', NULL, 'SINS', 'Sins', 'Sins', '0101000020E61000007EEF254344C420409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517133, 'LS72', 'NL32-04', 3, 'SION', 'Sion', 'Sion', '0101000020E61000006666666666661D40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517134, 'NT05', 'NL32-02', NULL, 'SIRNACH', 'Sirnach', 'Sirnach', '0101000020E61000000000000000002240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517135, 'LT61', 'NL32-01', NULL, 'SISELEN', 'Siselen', 'Siselen', '0101000020E61000002F127FB9BBBB1C4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517136, 'MS79', 'NL32-05', NULL, 'SISIKON', 'Sisikon', 'Sisikon', '0101000020E61000008210DABCBB3B21409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517137, 'MT05', 'NL32-01', NULL, 'SISSACH', 'Sissach', 'Sissach', '0101000020E61000003333333333331F40ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517140, 'LS37', 'NL32-04', NULL, 'SIVIRIEZ', 'Siviriez', 'Siviriez', '0101000020E61000000421B47977771B4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517142, 'NS13', 'NL32-05', NULL, 'SOAZZA', 'Soazza', 'Soazza', '0101000020E6100000B5430DF0EE6E2240CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517143, 'MS93', 'NL32-05', NULL, 'SOBRIO', 'Sobrio', 'Sobrio', '0101000020E61000001CAA735655D521403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517144, 'NS43', 'NL32-05', NULL, 'SOGLIO', 'Soglio', 'Soglio', '0101000020E61000004BBCF20F11112340791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517145, 'MS94', 'NL32-05', NULL, 'SOJA', 'Soja', 'Soja', '0101000020E6100000B122597677F721400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517146, 'MS81', 'NL32-05', NULL, 'SOLDUNO', 'Solduno', 'Solduno', '0101000020E61000004BBCF20F1191214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517152, 'LT83', 'NL32-01', 3, 'SOLOTHURN', 'Solothurn', 'Solothurn', '0101000020E61000009EBA4D1311111E40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517154, 'MS72', 'NL32-05', NULL, 'SOMEO', 'Someo', 'Someo', '0101000020E61000001CAA73565555214013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517155, 'LR59', 'NL32-04', NULL, 'SOMLAPROZ', 'Somlaproz', 'Somlaproz', '0101000020E6100000FCDE4B8688881C4054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517156, 'MT15', 'NL32-01', NULL, 'SOMMERAU', 'Sommerau', 'Sommerau', '0101000020E61000006666666666661F409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517158, 'NS82', 'NL32-06', NULL, 'SOMPRAI', 'Somprai', 'Somprai', '0101000020E61000009A999999991924406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517159, 'MS97', 'NL32-05', NULL, 'SOMVIX', 'Somvix', 'Somvix', '0101000020E61000006666666666E62140AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517164, 'LT62', 'NL32-01', NULL, 'SONCEBOZ', 'Sonceboz', 'Sonceboz', '0101000020E61000002F127FB9BBBB1C409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517166, 'MS83', 'NL32-05', NULL, 'SONOGNO', 'Sonogno', 'Sonogno', '0101000020E61000004BBCF20F11912140CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517167, 'MS90', 'NL32-05', NULL, 'SONVICO', 'Sonvico', 'Sonvico', '0101000020E6100000B122597677F72140BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517168, 'LT42', 'NL32-01', NULL, 'SONVILIER', 'Sonvilier', 'Sonvilier', '0101000020E6100000CDCCCCCCCCCC1B40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517169, 'NT00', 'NL32-05', NULL, 'SOOL', 'Sool', 'Sool', '0101000020E6100000E4558CA9AA2A2240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517170, 'KS71', 'NL32-04', NULL, 'SORAL', 'Soral', 'Soral', '0101000020E61000003333333333331840DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517171, 'MS28', 'NL32-05', NULL, 'SORENBERG', 'Sörenberg', 'Sorenberg', '0101000020E61000004FDDA68988082040791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517172, 'MR99', 'NL32-05', NULL, 'SORENGO', 'Sorengo', 'Sorengo', '0101000020E61000001789BFDCDDDD21400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517173, 'LS57', 'NL32-04', NULL, 'SORENS', 'Sorens', 'Sorens', '0101000020E61000003333333333331C4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517174, 'MS90', 'NL32-05', NULL, 'SORESINA', 'Soresina', 'Soresina', '0101000020E61000007EEF254344C42140218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517175, 'LT63', 'NL32-01', NULL, 'SORNETAN', 'Sornetan', 'Sornetan', '0101000020E61000006B871AE0DDDD1C4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517176, 'MS73', 'NL32-05', NULL, 'SORNICO', 'Sornico', 'Sornico', '0101000020E61000001CAA735655552140DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517177, 'NS12', 'NL32-05', NULL, 'SORTE', 'Sorte', 'Sorte', '0101000020E61000001789BFDCDD5D224013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517178, 'LS26', 'NL32-04', NULL, 'SOTTENS', 'Sottens', 'Sottens', '0101000020E61000006245B2ECEEEE1A403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517179, 'LT54', 'NL32-01', NULL, 'SOUBEY', 'Soubey', 'Soubey', '0101000020E61000003333333333331C406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517180, 'LS82', 'NL32-04', NULL, 'SOUSSILLON', 'Soussillon', 'Soussillon', '0101000020E6100000D1ED804644441E400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517182, 'LT75', 'NL32-01', NULL, 'SOYHIERES', 'Soyhières', 'Soyhieres', '0101000020E61000000421B47977771D403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517185, 'MS17', 'NL32-04', NULL, 'SPEICHER', 'Speicher', 'Speicher', '0101000020E6100000FCDE4B8688881F4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517186, 'NT34', 'NL32-02', NULL, 'SPEICHER', 'Speicher', 'Speicher', '0101000020E61000006666666666E622403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517187, 'LS97', 'NL32-04', NULL, 'SPIEZ', 'Spiez', 'Spiez', '0101000020E61000002F127FB9BBBB1E4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517188, 'MS05', 'NL32-04', NULL, 'SPIGGENGRUND', 'Spiggengrund', 'Spiggengrund', '0101000020E61000009578E51F22221F40BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517190, 'NS65', 'NL32-05', NULL, 'SPINAS', 'Spinas', 'Spinas', '0101000020E6100000E4558CA9AAAA23406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517191, 'MS79', 'NL32-05', NULL, 'SPIRINGEN', 'Spiringen', 'Spiringen', '0101000020E6100000B122597677772140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517192, 'MS99', 'NL32-05', NULL, 'SPITELRUTI', 'Spitelrüti', 'Spitelruti', '0101000020E61000007EEF254344C42140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517193, 'MT10', 'NL32-04', NULL, 'SPITZENHAUS', 'Spitzenhaus', 'Spitzenhaus', '0101000020E6100000FCDE4B8688881F40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517198, 'NS25', 'NL32-05', NULL, 'SPLUGEN', 'Splügen', 'Splugen', '0101000020E6100000E976402322A222406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517208, 'NS47', 'NL32-05', NULL, 'SPORZ', 'Sporz', 'Sporz', '0101000020E61000004BBCF20F11112340ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517209, 'MT55', 'NL32-02', NULL, 'SPREITENBACH', 'Spreitenbach', 'Spreitenbach', '0101000020E61000008210DABCBBBB204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517210, 'MS61', 'NL32-05', NULL, 'SPRUGA', 'Spruga', 'Spruga', '0101000020E6100000E9764023222221409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517211, 'NS13', 'NL32-05', NULL, 'STABBIO', 'Stabbio', 'Stabbio', '0101000020E610000000000000008022403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517212, 'MR97', 'NL32-08', NULL, 'STABIO', 'Stabio', 'Stabio', '0101000020E61000001789BFDCDDDD2140CDCCCCCCCCEC4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517214, 'NS09', 'NL32-05', NULL, 'STACHELBERGBAD', 'Stachelberg Bad', 'Stachelberg Bad', '0101000020E6100000000000000000224046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517215, 'MT56', 'NL32-02', NULL, 'STADEL', 'Stadel', 'Stadel', '0101000020E61000006666666666E6204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517216, 'MT73', 'NL32-02', NULL, 'STAFA', 'Stäfa', 'Stafa', '0101000020E6100000B5430DF0EE6E2140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517217, 'LR99', 'NL32-04', NULL, 'STAFEL', 'Stafel', 'Stafel', '0101000020E61000002F127FB9BBBB1E400000000000004740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517218, 'NS36', 'NL32-05', NULL, 'STAFEL', 'Stafel', 'Stafel', '0101000020E6100000000000000000234087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517219, 'NS57', 'NL32-05', NULL, 'STAFELALP', 'Stafel Alp', 'Stafel Alp', '0101000020E61000004BBCF20F1191234054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517221, 'NS16', 'NL32-05', NULL, 'STAFELTI', 'Stafelti', 'Stafelti', '0101000020E6100000CDCCCCCCCC4C2240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517223, 'MT23', 'NL32-02', NULL, 'STAFFELBACH', 'Staffelbach', 'Staffelbach', '0101000020E61000009A9999999919204054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517224, 'MS12', 'NL32-04', NULL, 'STALDEN', 'Stalden', 'Stalden', '0101000020E61000000421B47977771F40AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517225, 'LS99', 'NL32-04', NULL, 'STALDEN', 'Stalden', 'Stalden', '0101000020E61000000421B47977771E40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517226, 'MS49', 'NL32-05', NULL, 'STALDEN', 'Stalden', 'Stalden', '0101000020E6100000B122597677772040DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517227, 'MS11', 'NL32-04', NULL, 'STALDENRIED', 'Staldenried', 'Staldenried', '0101000020E6100000FCDE4B8688881F40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517229, 'LT96', 'NL32-01', NULL, 'STALLEN', 'Stallen', 'Stallen', '0101000020E61000003333333333331E4054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517230, 'MT64', 'NL32-02', NULL, 'STALLIKON', 'Stallikon', 'Stallikon', '0101000020E6100000B122597677F72040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517231, 'MT87', 'NL32-02', NULL, 'STAMMHEIM', 'Stammheim', 'Stammheim', '0101000020E61000004BBCF20F119121403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517232, 'NS43', 'NL32-05', NULL, 'STAMPA', 'Stampa', 'Stampa', '0101000020E6100000E976402322222340791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517233, 'MT50', 'NL32-05', 4, 'STANS', 'Stans', 'Stans', '0101000020E61000003333333333B32040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517235, 'MT40', 'NL32-05', NULL, 'STANSSTAD', 'Stansstad', 'Stansstad', '0101000020E6100000E4558CA9AAAA2040ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517236, 'NS35', 'NL32-05', NULL, 'STARLERA', 'Starlera', 'Starlera', '0101000020E6100000B5430DF0EEEE224054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517240, 'MT34', 'NL32-02', NULL, 'STAUFEN', 'Staufen', 'Staufen', '0101000020E61000001CAA735655552040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517241, 'NS06', 'NL32-05', NULL, 'STAVIALAVEDRA', 'Staviala Vedra', 'Staviala Vedra', '0101000020E6100000333333333333224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517242, 'MS15', 'NL32-04', NULL, 'STECHELBERG', 'Stechelberg', 'Stechelberg', '0101000020E61000009A99999999991F406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517243, 'MT97', 'NL32-02', NULL, 'STECKBORN', 'Steckborn', 'Steckborn', '0101000020E6100000B122597677F7214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517244, 'LS98', 'NL32-04', NULL, 'STEFFISBURG', 'Steffisburg', 'Steffisburg', '0101000020E6100000FCDE4B8688881E4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517245, 'MT94', 'NL32-02', NULL, 'STEG', 'Steg', 'Steg', '0101000020E61000001789BFDCDDDD2140CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517246, 'MS57', 'NL32-05', NULL, 'STEIN', 'Stein', 'Stein', '0101000020E61000001CAA735655D52040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517247, 'NT24', 'NL32-02', NULL, 'STEIN', 'Stein', 'Stein', '0101000020E6100000E4558CA9AAAA2240DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517248, 'MT26', 'NL32-01', NULL, 'STEIN', 'Stein', 'Stein', '0101000020E6100000CDCCCCCCCCCC1F4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517251, 'MT87', 'NL32-02', NULL, 'STEINAMRHEIN', 'Stein am Rhein', 'Stein am Rhein', '0101000020E61000003333333333B321403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517252, 'MT61', 'NL32-02', NULL, 'STEINEN', 'Steinen', 'Steinen', '0101000020E610000033333333333321406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517253, 'MS05', 'NL32-04', NULL, 'STEINENBERG', 'Steinenberg', 'Steinenberg', '0101000020E61000009EBA4D1311111F406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517254, 'MT61', 'NL32-02', NULL, 'STEINERBERG', 'Steinerberg', 'Steinerberg', '0101000020E6100000E4558CA9AA2A21406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517256, 'MS34', 'NL32-05', NULL, 'STEINHAUS', 'Steinhaus', 'Steinhaus', '0101000020E61000001CAA73565555204087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517257, 'LS78', 'NL32-04', NULL, 'STEINHAUS', 'Steinhaus', 'Steinhaus', '0101000020E6100000C8AB185355551D40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517258, 'MT52', 'NL32-02', NULL, 'STEINHAUSEN', 'Steinhausen', 'Steinhausen', '0101000020E6100000B5430DF0EEEE20409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517259, 'NS19', 'NL32-05', NULL, 'STEINIBACH', 'Steinibach', 'Steinibach', '0101000020E61000007EEF25434444224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517261, 'MT94', 'NL32-02', NULL, 'STERNENBERG', 'Sternenberg', 'Sternenberg', '0101000020E61000001CAA735655D52140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517262, 'MT96', 'NL32-02', NULL, 'STETTFURT', 'Stettfurt', 'Stettfurt', '0101000020E61000006666666666E6214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517263, 'LT80', 'NL32-04', NULL, 'STETTLEN', 'Stettlen', 'Stettlen', '0101000020E61000009578E51F22221E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517265, 'MT36', 'NL32-02', NULL, 'STILLI', 'Stilli', 'Stilli', '0101000020E6100000666666666666204054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517266, 'MS79', 'NL32-05', NULL, 'STOCK', 'Stock', 'Stock', '0101000020E6100000CDCCCCCCCC4C214046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517269, 'MT70', 'NL32-05', NULL, 'STOOS', 'Stoos', 'Stoos', '0101000020E61000001CAA735655552140AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517270, 'NT34', 'NL32-02', NULL, 'STOSS', 'Stoss', 'Stoss', '0101000020E61000000000000000002340218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517271, 'LS78', 'NL32-04', NULL, 'STOSSEN', 'Stössen', 'Stossen', '0101000020E61000009A99999999991D4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517272, 'NS58', 'NL32-05', NULL, 'STRASSBERG', 'Strassberg', 'Strassberg', '0101000020E6100000B122597677772340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517274, 'MT13', 'NL32-01', NULL, 'STRENGELBACH', 'Strengelbach', 'Strengelbach', '0101000020E61000003854E7ACAAAA1F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517275, 'LT70', 'NL32-04', NULL, 'STUCKISHAUS', 'Stuckishaus', 'Stuckishaus', '0101000020E61000003854E7ACAAAA1D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517277, 'NS56', 'NL32-05', NULL, 'STULS', 'Stuls', 'Stuls', '0101000020E6100000B122597677772340DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517278, 'NS46', 'NL32-05', NULL, 'STURVIS', 'Stürvis', 'Sturvis', '0101000020E61000004BBCF20F1111234087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517279, 'LT71', 'NL32-01', NULL, 'SUBERG', 'Suberg', 'Suberg', '0101000020E6100000C8AB185355551D406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517280, 'LT92', 'NL32-01', NULL, 'SUBINGEN', 'Subingen', 'Subingen', '0101000020E61000000421B47977771E409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517283, 'LS17', 'NL32-04', NULL, 'SUCHY', 'Suchy', 'Suchy', '0101000020E61000006666666666661A40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517284, 'MS08', 'NL32-04', NULL, 'SUDERN', 'Südern', 'Sudern', '0101000020E61000000000000000001F40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517286, 'NS25', 'NL32-05', NULL, 'SUFERS', 'Sufers', 'Sufers', '0101000020E61000008210DABCBBBB2240BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517287, 'LT50', 'NL32-04', NULL, 'SUGIEZ', 'Sugiez', 'Sugiez', '0101000020E61000006666666666661C40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517288, 'MT34', 'NL32-02', NULL, 'SUHR', 'Suhr', 'Suhr', '0101000020E6100000E4558CA9AA2A2040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517292, 'NT16', 'NL32-02', NULL, 'SULGEN', 'Sulgen', 'Sulgen', '0101000020E61000001789BFDCDD5D224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517293, 'NS03', 'NL32-05', NULL, 'SULGONE', 'Sulgone', 'Sulgone', '0101000020E610000000000000000022403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517294, 'NS76', 'NL32-05', NULL, 'SULSANA', 'Sulsana', 'Sulsana', '0101000020E6100000B122597677F72340DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517297, 'MT36', 'NL32-02', NULL, 'SULZ', 'Sulz', 'Sulz', '0101000020E6100000333333333333204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517299, 'MS69', 'NL32-05', NULL, 'SULZTHAL', 'Sulzthal', 'Sulzthal', '0101000020E610000000000000000021403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517300, 'MT00', 'NL32-01', NULL, 'SUMISWALD', 'Sumiswald', 'Sumiswald', '0101000020E61000006245B2ECEEEE1E4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517302, 'MS07', 'NL32-04', NULL, 'SUNDLAUENEN', 'Sundlauenen', 'Sundlauenen', '0101000020E61000009578E51F22221F4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517303, 'NS83', 'NL32-06', NULL, 'SURACQUA', 'Suracqua', 'Suracqua', '0101000020E61000003333333333332440DF7BC91011314740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517304, 'NS46', 'NL32-05', NULL, 'SURAVA', 'Surava', 'Surava', '0101000020E61000008210DABCBB3B234087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517306, 'NS87', 'NL32-06', NULL, 'SUREN', 'Suren', 'Suren', '0101000020E61000001CAA73565555244054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517309, 'NS64', 'NL32-05', NULL, 'SURLEJ', 'Surlej', 'Surlej', '0101000020E61000009A999999999923409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517310, 'NS06', 'NL32-05', NULL, 'SURRHIN', 'Surrhin', 'Surrhin', '0101000020E6100000333333333333224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517311, 'MT32', 'NL32-02', NULL, 'SURSEE', 'Sursee', 'Sursee', '0101000020E6100000333333333333204087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517312, 'NS87', 'NL32-06', NULL, 'SUS', 'Süs', 'Sus', '0101000020E6100000E4558CA9AA2A24400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517328, 'LS68', 'NL32-04', NULL, 'TAFERS', 'Tafers', 'Tafers', '0101000020E61000006B871AE0DDDD1C406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517329, 'NT07', 'NL32-02', NULL, 'TAGERWILEN', 'Tägerwilen', 'Tagerwilen', '0101000020E61000008210DABCBB3B22403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517330, 'NS01', 'NL32-05', NULL, 'TAGLIADA', 'Tagliada', 'Tagliada', '0101000020E6100000E9764023222222409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517334, 'NS38', 'NL32-05', NULL, 'TAMINS', 'Tamins', 'Tamins', '0101000020E6100000CDCCCCCCCCCC2240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517335, 'LS33', 'NL32-04', NULL, 'TANAY', 'Tanay', 'Tanay', '0101000020E6100000C8AB185355551B40CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517338, 'MT95', 'NL32-02', NULL, 'TANIKON', 'Tänikon', 'Tanikon', '0101000020E6100000CDCCCCCCCCCC2140AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517339, 'MT83', 'NL32-02', NULL, 'TANN', 'Tann', 'Tann', '0101000020E61000003333333333B3214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517341, 'MS47', 'NL32-05', NULL, 'TANNEN', 'Tannen', 'Tannen', '0101000020E6100000E4558CA9AAAA204054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517345, 'NS98', 'NL32-06', NULL, 'TARASP', 'Tarasp', 'Tarasp', '0101000020E6100000000000000080244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517346, 'NS37', 'NL32-05', NULL, 'TARTAR', 'Tartar', 'Tartar', '0101000020E61000001CAA735655D52240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517347, 'NS49', 'NL32-05', NULL, 'TARVIERSCH', 'Tarviersch', 'Tarviersch', '0101000020E61000004BBCF20F111123409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517348, 'MS00', 'NL32-04', NULL, 'TASCH', 'Täsch', 'Tasch', '0101000020E61000009EBA4D1311111F40BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517349, 'LT61', 'NL32-01', NULL, 'TAUFFELEN', 'Täuffelen', 'Tauffelen', '0101000020E6100000CDCCCCCCCCCC1C40BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517350, 'NS07', 'NL32-05', NULL, 'TAVANASA', 'Tavanasa', 'Tavanasa', '0101000020E61000009A999999991922400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517351, 'LT63', 'NL32-01', NULL, 'TAVANNES', 'Tavannes', 'Tavannes', '0101000020E6100000CDCCCCCCCCCC1C40ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517352, 'MS90', 'NL32-05', NULL, 'TAVERNE', 'Taverne', 'Taverne', '0101000020E61000001789BFDCDDDD2140BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517356, 'LS52', 'NL32-04', NULL, 'TAVEYANNAZ', 'Taveyannaz', 'Taveyannaz', '0101000020E61000000421B47977771C406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517357, 'MT15', 'NL32-01', NULL, 'TECKNAU', 'Tecknau', 'Tecknau', '0101000020E6100000FCDE4B8688881F409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517358, 'MT46', 'NL32-02', NULL, 'TEGERFELDEN', 'Tegerfelden', 'Tegerfelden', '0101000020E61000004BBCF20F11912040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517359, 'MS71', 'NL32-05', NULL, 'TEGNA', 'Tegna', 'Tegna', '0101000020E6100000B12259767777214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517361, 'MS81', 'NL32-05', NULL, 'TENERO', 'Tenero', 'Tenero', '0101000020E61000003333333333B3214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517362, 'MS96', 'NL32-05', NULL, 'TENIGERBAD', 'Tenigerbad', 'Tenigerbad', '0101000020E6100000B5430DF0EEEE214046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517363, 'NS27', 'NL32-05', NULL, 'TENNA', 'Tenna', 'Tenna', '0101000020E6100000E4558CA9AAAA22400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517367, 'MS23', 'NL32-05', NULL, 'TERMEN', 'Termen', 'Termen', '0101000020E61000004FDDA68988082040791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517370, 'LS44', 'NL32-04', NULL, 'TERRITET', 'Territet', 'Territet', '0101000020E61000002F127FB9BBBB1B4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517371, 'MS90', 'NL32-05', NULL, 'TESSERETE', 'Tesserete', 'Tesserete', '0101000020E6100000B5430DF0EEEE2140BA1DD08888084740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517374, 'NT24', 'NL32-02', NULL, 'TEUFEN', 'Teufen', 'Teufen', '0101000020E61000007EEF254344C42240DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517375, 'MT66', 'NL32-02', NULL, 'TEUFEN', 'Teufen', 'Teufen', '0101000020E61000009A999999991921406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517377, 'MT34', 'NL32-02', NULL, 'TEUFENTHAL', 'Teufenthal', 'Teufenthal', '0101000020E61000008210DABCBB3B2040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517378, 'MS08', 'NL32-04', NULL, 'TEUFFENTHAL', 'Teuffenthal', 'Teuffenthal', '0101000020E6100000CDCCCCCCCCCC1E4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517379, 'NS45', 'NL32-05', NULL, 'TGA', 'Tga', 'Tga', '0101000020E6100000E4558CA9AA2A234054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517380, 'NS47', 'NL32-05', NULL, 'TGANTIENI', 'Tgantieni', 'Tgantieni', '0101000020E61000004BBCF20F11112340ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517381, 'NS26', 'NL32-05', NULL, 'THAL', 'Thal', 'Thal', '0101000020E61000004BBCF20F11912240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517382, 'MT35', 'NL32-02', NULL, 'THALHEIM', 'Thalheim', 'Thalheim', '0101000020E6100000333333333333204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517383, 'MT86', 'NL32-02', NULL, 'THALHEIM', 'Thalheim', 'Thalheim', '0101000020E61000000000000000802140BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517385, 'MT63', 'NL32-02', NULL, 'THALWIL', 'Thalwil', 'Thalwil', '0101000020E6100000E97640232222214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517386, 'MT78', 'NL32-02', NULL, 'THAYNGEN', 'Thayngen', 'Thayngen', '0101000020E61000006666666666662140AC4896DDDDDD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517388, 'LT96', 'NL32-01', NULL, 'THERWIL', 'Therwil', 'Therwil', '0101000020E61000003333333333331E400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517392, 'LT51', 'NL32-01', NULL, 'THIELLE', 'Thielle', 'Thielle', '0101000020E61000009578E51F22221C4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517393, 'LS97', 'NL32-04', NULL, 'THIERACHERN', 'Thierachern', 'Thierachern', '0101000020E6100000D1ED804644441E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517394, 'LS27', 'NL32-04', NULL, 'THIERRENS', 'Thierrens', 'Thierrens', '0101000020E61000000000000000001B409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (48744, 'KS81', 'NL32-04', NULL, 'THONEX', 'Thônex', 'Thonex', '0101000020E61000003854E7ACAAAA184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517397, 'LT90', 'NL32-01', NULL, 'THORBERG', 'Thorberg', 'Thorberg', '0101000020E6100000D1ED804644441E400000000000804740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517398, 'LS79', 'NL32-04', NULL, 'THORISHAUS', 'Thörishaus', 'Thorishaus', '0101000020E61000006666666666661D403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517400, 'LS97', 'NL32-04', 3, 'THUN', 'Thun', 'Thun', '0101000020E61000000421B47977771E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517402, 'MT96', 'NL32-02', NULL, 'THUNDORF', 'Thundorf', 'Thundorf', '0101000020E6100000B5430DF0EEEE214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517404, 'LT92', 'NL32-01', NULL, 'THUNSTETTEN', 'Thunstetten', 'Thunstetten', '0101000020E6100000C8AB185355551E409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517411, 'NS37', 'NL32-05', NULL, 'THUSIS', 'Thusis', 'Thusis', '0101000020E61000001789BFDCDDDD224046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517419, 'MS55', 'NL32-05', NULL, 'TIEFENBACH', 'Tiefenbach', 'Tiefenbach', '0101000020E6100000B5430DF0EEEE2040791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517423, 'NS46', 'NL32-05', NULL, 'TIEFENCASTEL', 'Tiefencastel', 'Tiefencastel', '0101000020E6100000E4558CA9AA2A23403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517426, 'LS85', 'NL32-04', NULL, 'TIERMATTI', 'Tiermatti', 'Tiermatti', '0101000020E61000000000000000001E40791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517430, 'NS45', 'NL32-05', NULL, 'TINZEN', 'Tinzen', 'Tinzen', '0101000020E61000008210DABCBB3B2340791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517435, 'MT05', 'NL32-01', NULL, 'TITTERTEN', 'Titterten', 'Titterten', '0101000020E61000006B871AE0DDDD1E403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517436, 'NT06', 'NL32-02', NULL, 'TOBEL', 'Tobel', 'Tobel', '0101000020E61000004BBCF20F1111224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517438, 'LS89', 'NL32-04', NULL, 'TOFFEN', 'Toffen', 'Toffen', '0101000020E61000006245B2ECEEEE1D40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517440, 'NS37', 'NL32-05', NULL, 'TOMILS', 'Tomils', 'Tomils', '0101000020E61000006666666666E6224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517442, 'MS12', 'NL32-04', NULL, 'TORBEL', 'Törbel', 'Torbel', '0101000020E61000006666666666661F400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517445, 'MS94', 'NL32-05', NULL, 'TORRE', 'Torre', 'Torre', '0101000020E61000006666666666E62140AC4896DDDD3D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517451, 'LS60', 'NL32-04', NULL, 'TORTIN', 'Tortin', 'Tortin', '0101000020E61000003333333333331D40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517452, 'MT76', 'NL32-02', NULL, 'TOSS', 'Töss', 'Toss', '0101000020E610000066666666666621400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517456, 'MT85', 'NL32-02', NULL, 'TOSSEGG', 'Tössegg', 'Tossegg', '0101000020E6100000E4558CA9AAAA214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517458, 'MT66', 'NL32-02', NULL, 'TOSSRIEDERN', 'Tössriedern', 'Tossriedern', '0101000020E61000004BBCF20F11112140BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517469, 'MS15', 'NL32-04', NULL, 'TRACHSELLAUENEN', 'Trachsellauenen', 'Trachsellauenen', '0101000020E61000009A99999999991F4054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517470, 'MT00', 'NL32-01', NULL, 'TRACHSELWALD', 'Trachselwald', 'Trachselwald', '0101000020E61000006245B2ECEEEE1E4054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517471, 'LT53', 'NL32-01', NULL, 'TRAMELAN', 'Tramelan', 'Tramelan', '0101000020E61000006666666666661C40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517472, 'NS37', 'NL32-05', NULL, 'TRANS', 'Trans', 'Trans', '0101000020E61000006666666666E6224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517473, 'MT57', 'NL32-02', NULL, 'TRASADINGEN', 'Trasadingen', 'Trasadingen', '0101000020E61000001CAA735655D5204087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517474, 'LT20', 'NL32-04', NULL, 'TRAVERS', 'Travers', 'Travers', '0101000020E61000002F127FB9BBBB1A4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517477, 'NS16', 'NL32-05', NULL, 'TRAVISASCH', 'Travisasch', 'Travisasch', '0101000020E6100000666666666666224087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517478, 'MT60', 'NL32-05', NULL, 'TREIB', 'Treib', 'Treib', '0101000020E6100000E4558CA9AA2A2140ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517479, 'KS84', 'NL32-04', NULL, 'TRELEX', 'Trélex', 'Trelex', '0101000020E6100000CDCCCCCCCCCC184087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517486, 'NT40', 'NL32-05', NULL, 'TRETSCH', 'Tretsch', 'Tretsch', '0101000020E61000009A99999999192340ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517487, 'LS48', 'NL32-04', NULL, 'TREY', 'Trey', 'Trey', '0101000020E61000003854E7ACAAAA1B4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517488, 'LS47', 'NL32-04', NULL, 'TREYFAYES', 'Treyfayes', 'Treyfayes', '0101000020E6100000CDCCCCCCCCCC1B4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517489, 'LS57', 'NL32-04', NULL, 'TREYVAUX', 'Treyvaux', 'Treyvaux', '0101000020E6100000FCDE4B8688881C40AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517490, 'MT40', 'NL32-02', NULL, 'TRIBSCHEN', 'Tribschen', 'Tribschen', '0101000020E6100000E4558CA9AAAA204013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517491, 'MT33', 'NL32-02', NULL, 'TRIENGEN', 'Triengen', 'Triengen', '0101000020E6100000E4558CA9AA2A2040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517492, 'LS40', 'NL32-04', NULL, 'TRIENT', 'Trient', 'Trient', '0101000020E61000000000000000001C406666666666064740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517494, 'MT14', 'NL32-01', NULL, 'TRIMBACH', 'Trimbach', 'Trimbach', '0101000020E61000009A99999999991F40218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517495, 'NS49', 'NL32-05', NULL, 'TRIMMIS', 'Trimmis', 'Trimmis', '0101000020E61000009A999999991923403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517497, 'LS99', 'NL32-04', NULL, 'TRIMSTEIN', 'Trimstein', 'Trimstein', '0101000020E6100000D1ED804644441E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517498, 'NS28', 'NL32-05', NULL, 'TRINS', 'Trins', 'Trins', '0101000020E61000003333333333B32240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517500, 'NS28', 'NL32-05', NULL, 'TRINSERMUHLE', 'Trinsermühle', 'Trinsermuhle', '0101000020E6100000E4558CA9AAAA2240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517501, 'NT34', 'NL32-02', NULL, 'TROGEN', 'Trogen', 'Trogen', '0101000020E6100000B5430DF0EEEE22403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517502, 'LS32', 'NL32-04', NULL, 'TROISTORRENTS', 'Troistorrents', 'Troistorrents', '0101000020E61000003854E7ACAAAA1B40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517503, 'MT10', 'NL32-04', NULL, 'TRUB', 'Trub', 'Trub', '0101000020E6100000FCDE4B8688881F409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517504, 'NT31', 'NL32-02', NULL, 'TRUBBACH', 'Trübbach', 'Trubbach', '0101000020E6100000B5430DF0EEEE2240BA1DD08888884740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517505, 'MS19', 'NL32-04', NULL, 'TRUBSCHACHEN', 'Trubschachen', 'Trubschachen', '0101000020E6100000C8AB185355551F4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517506, 'MT77', 'NL32-02', NULL, 'TRULLIKON', 'Trüllikon', 'Trullikon', '0101000020E61000001789BFDCDD5D2140DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517509, 'MS97', 'NL32-05', NULL, 'TRUN', 'Trun', 'Trun', '0101000020E6100000B122597677F721400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517511, 'MS76', 'NL32-05', NULL, 'TSCHAMUT', 'Tschamut', 'Tschamut', '0101000020E610000066666666666621403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517513, 'LS85', 'NL32-04', NULL, 'TSCHENTEN', 'Tschenten', 'Tschenten', '0101000020E61000003333333333331E400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517514, 'NS48', 'NL32-05', NULL, 'TSCHIERTSCHEN', 'Tschiertschen', 'Tschiertschen', '0101000020E61000003333333333332340BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517515, 'LS93', 'NL32-04', NULL, 'TSCHINGEREN', 'Tschingeren', 'Tschingeren', '0101000020E6100000FCDE4B8688881E40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517516, 'NS68', 'NL32-05', NULL, 'TSCHUGGEN', 'Tschuggen', 'Tschuggen', '0101000020E61000001CAA735655D5234013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517517, 'MT92', 'NL32-02', NULL, 'TUGGEN', 'Tuggen', 'Tuggen', '0101000020E61000001789BFDCDDDD21409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517520, 'NS66', 'NL32-05', NULL, 'TUORSDAVANT', 'Tuors Davant', 'Tuors Davant', '0101000020E61000009A999999999923403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517521, 'NS26', 'NL32-05', NULL, 'TURAHUS', 'Turahus', 'Turahus', '0101000020E61000004BBCF20F11912240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517523, 'MT85', 'NL32-02', NULL, 'TURBENTHAL', 'Turbenthal', 'Turbenthal', '0101000020E61000003333333333B3214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517524, 'MT45', 'NL32-02', NULL, 'TURGI', 'Turgi', 'Turgi', '0101000020E61000000000000000802040AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517525, 'LS92', 'NL32-04', NULL, 'TURTMANN', 'Turtmann', 'Turtmann', '0101000020E6100000CDCCCCCCCCCC1E406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517530, 'LT51', 'NL32-01', NULL, 'TWANN', 'Twann', 'Twann', '0101000020E61000009A99999999991C40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517532, 'MT51', 'NL32-02', NULL, 'UDLIGENSWIL', 'Udligenswil', 'Udligenswil', '0101000020E6100000CDCCCCCCCCCC2040CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517533, 'NS49', 'NL32-05', NULL, 'UEBERLANDQUART', 'Ueberlandquart', 'Ueberlandquart', '0101000020E61000008210DABCBB3B23409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517534, 'LS79', 'NL32-04', NULL, 'UEBERSTORF', 'Ueberstorf', 'Ueberstorf', '0101000020E61000003333333333331D40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517535, 'MT83', 'NL32-02', NULL, 'UERIKON', 'Uerikon', 'Uerikon', '0101000020E61000000000000000802140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517536, 'MT23', 'NL32-02', NULL, 'UERKHEIM', 'Uerkheim', 'Uerkheim', '0101000020E61000004FDDA689880820406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517537, 'MT87', 'NL32-02', NULL, 'UESSLINGEN', 'Uesslingen', 'Uesslingen', '0101000020E6100000E976402322A22140791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517538, 'LS98', 'NL32-04', NULL, 'UETENDORF', 'Uetendorf', 'Uetendorf', '0101000020E6100000D1ED804644441E4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517539, 'MT73', 'NL32-02', NULL, 'UETIKON', 'Uetikon', 'Uetikon', '0101000020E61000001CAA73565555214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517542, 'LT70', 'NL32-04', NULL, 'UETTLIGEN', 'Uettligen', 'Uettligen', '0101000020E6100000FCDE4B8688881D40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517544, 'MT22', 'NL32-02', NULL, 'UFFIKON', 'Uffikon', 'Uffikon', '0101000020E61000004FDDA68988082040ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517545, 'MT11', 'NL32-01', NULL, 'UFHUSEN', 'Ufhusen', 'Ufhusen', '0101000020E61000009A99999999991F40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517546, 'MT77', 'NL32-02', NULL, 'UHWIESEN', 'Uhwiesen', 'Uhwiesen', '0101000020E61000007EEF25434444214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517547, 'PS08', 'NL32-06', NULL, 'UINADADORA', 'Uina Dadora', 'Uina Dadora', '0101000020E61000007EEF254344C4244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517548, 'MT54', 'NL32-02', NULL, 'UITIKON', 'Uitikon', 'Uitikon', '0101000020E6100000B5430DF0EEEE2040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517550, 'MS44', 'NL32-05', NULL, 'ULRICHEN', 'Ulrichen', 'Ulrichen', '0101000020E61000009A999999999920400000000000404740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517555, 'LT64', 'NL32-01', NULL, 'UNDERVELIER', 'Undervelier', 'Undervelier', '0101000020E61000006B871AE0DDDD1C406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517558, 'MT62', 'NL32-02', NULL, 'UNTERAGERI', 'Unterägeri', 'Unterageri', '0101000020E6100000E4558CA9AA2A2140DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517560, 'MS37', 'NL32-05', NULL, 'UNTERBACH', 'Unterbach', 'Unterbach', '0101000020E61000008210DABCBB3B2040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517559, 'MS02', 'NL32-04', NULL, 'UNTERBACH', 'Unterbäch', 'Unterbach', '0101000020E61000003333333333331F4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517561, 'LS94', 'NL32-04', NULL, 'UNTERBACHEN', 'Unterbächen', 'Unterbachen', '0101000020E61000000421B47977771E409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517563, 'NT04', 'NL32-02', NULL, 'UNTERBAZENHEID', 'Unter-Bazenheid', 'Unter-Bazenheid', '0101000020E6100000E9764023222222403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517564, 'NT02', 'NL32-02', NULL, 'UNTERBILTEN', 'Unter-Bilten', 'Unter-Bilten', '0101000020E61000004FDDA689880822403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517565, 'MT76', 'NL32-02', NULL, 'UNTERBUCH', 'Unter-Buch', 'Unter-Buch', '0101000020E61000007EEF2543444421406666666666C64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517566, 'LS84', 'NL32-04', NULL, 'UNTERDEMBIRG', 'Unter dem Birg', 'Unter dem Birg', '0101000020E6100000D1ED804644441E409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517567, 'MT46', 'NL32-02', NULL, 'UNTEREHRENDINGEN', 'Unterehrendingen', 'Unterehrendingen', '0101000020E6100000E4558CA9AAAA20400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517568, 'MS26', 'NL32-05', NULL, 'UNTEREIGER', 'Unter Eiger', 'Unter Eiger', '0101000020E61000000000000000002040218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517571, 'MT55', 'NL32-02', NULL, 'UNTERENGSTRINGEN', 'Unterengstringen', 'Unterengstringen', '0101000020E61000001789BFDCDDDD204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517572, 'MT25', 'NL32-02', NULL, 'UNTERERLINSBACH', 'Untererlinsbach', 'Untererlinsbach', '0101000020E610000000000000000020403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517574, 'LT90', 'NL32-04', NULL, 'UNTERGOMERKINDEN', 'Unter-Gomerkinden', 'Unter-Gomerkinden', '0101000020E61000009A99999999991E40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517575, 'MT81', 'NL32-02', NULL, 'UNTERIBERG', 'Unteriberg', 'Unteriberg', '0101000020E61000004BBCF20F119121406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517576, 'MT74', 'NL32-02', NULL, 'UNTERILLNAU', 'Unter Illnau', 'Unter Illnau', '0101000020E6100000B5430DF0EE6E21403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517577, 'MT34', 'NL32-02', NULL, 'UNTERKULM', 'Unterkulm', 'Unterkulm', '0101000020E61000008210DABCBB3B2040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517580, 'NS68', 'NL32-05', NULL, 'UNTERLARET', 'Unter-Laret', 'Unter-Laret', '0101000020E61000003333333333B32340CDCCCCCCCC6C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517581, 'MS26', 'NL32-05', NULL, 'UNTERLAUCHBUHL', 'Unter Lauchbühl', 'Unter Lauchbuhl', '0101000020E6100000E4558CA9AA2A2040DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517582, 'MT54', 'NL32-02', NULL, 'UNTERLUNKHOFEN', 'Unterlunkhofen', 'Unterlunkhofen', '0101000020E61000007EEF254344C42040BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517584, 'MS89', 'NL32-05', NULL, 'UNTERSCHACHEN', 'Unterschächen', 'Unterschachen', '0101000020E61000004FDDA68988882140218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517585, 'MT77', 'NL32-02', NULL, 'UNTERSCHLATT', 'Unter-Schlatt', 'Unter-Schlatt', '0101000020E6100000666666666666214087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517586, 'MS09', 'NL32-04', NULL, 'UNTERSCHWENDIMATT', 'Unter Schwendimatt', 'Unter Schwendimatt', '0101000020E6100000CDCCCCCCCCCC1E40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517588, 'MS17', 'NL32-04', NULL, 'UNTERSEEN', 'Unterseen', 'Unterseen', '0101000020E61000006666666666661F4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517591, 'MT46', 'NL32-02', NULL, 'UNTERSIGGENTHAL', 'Untersiggenthal', 'Untersiggenthal', '0101000020E610000000000000008020400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517592, 'MT46', 'NL32-02', NULL, 'UNTERSIGGENTHAL', 'Untersiggenthal', 'Untersiggenthal', '0101000020E6100000E976402322A2204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517593, 'MS07', 'NL32-04', NULL, 'UNTERSOHL', 'Unter-Sohl', 'Unter-Sohl', '0101000020E6100000D1ED804644441F4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517594, 'MS89', 'NL32-05', NULL, 'UNTERSTAFFEL', 'Unter Staffel', 'Unter Staffel', '0101000020E6100000E4558CA9AAAA214046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517595, 'MT87', 'NL32-02', NULL, 'UNTERSTAMMHEIM', 'Unter-Stammheim', 'Unter-Stammheim', '0101000020E61000004BBCF20F119121403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517596, 'NT11', 'NL32-02', NULL, 'UNTERTERZEN', 'Unterterzen', 'Unterterzen', '0101000020E61000000000000000802240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517597, 'NS49', 'NL32-05', NULL, 'UNTERVAZ', 'Untervaz', 'Untervaz', '0101000020E61000004BBCF20F1111234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517602, 'NT22', 'NL32-02', NULL, 'UNTERWASSER', 'Unterwasser', 'Unterwasser', '0101000020E61000009A999999999922409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517603, 'MT84', 'NL32-02', NULL, 'UNTERWETZIKON', 'Unter-Wetzikon', 'Unter-Wetzikon', '0101000020E61000004BBCF20F11912140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517604, 'LT70', 'NL32-04', NULL, 'UNTERWOHLEN', 'Unter-Wohlen', 'Unter-Wohlen', '0101000020E61000006666666666661D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517615, 'NS37', 'NL32-05', NULL, 'URMEIN', 'Urmein', 'Urmein', '0101000020E6100000CDCCCCCCCCCC22409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517616, 'NT24', 'NL32-02', NULL, 'URNASCH', 'Urnäsch', 'Urnasch', '0101000020E61000004BBCF20F11912240BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517619, 'MS59', 'NL32-05', NULL, 'URNERSTAFEL', 'Urnerstafel', 'Urnerstafel', '0101000020E61000006666666666E62040DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517620, 'MT02', 'NL32-01', NULL, 'URSENBACH', 'Ursenbach', 'Ursenbach', '0101000020E61000009EBA4D1311111F40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517624, 'LT80', 'NL32-01', NULL, 'URTENEN', 'Urtenen', 'Urtenen', '0101000020E61000006245B2ECEEEE1D4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517626, 'MT74', 'NL32-02', 3, 'USTER', 'Uster', 'Uster', '0101000020E61000006666666666662140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517630, 'LS98', 'NL32-04', NULL, 'UTTIGEN', 'Uttigen', 'Uttigen', '0101000020E6100000D1ED804644441E4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517631, 'NT27', 'NL32-02', NULL, 'UTTWIL', 'Uttwil', 'Uttwil', '0101000020E6100000E4558CA9AAAA2240791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517632, 'LT92', 'NL32-01', NULL, 'UTZENSTORF', 'Utzenstorf', 'Utzenstorf', '0101000020E61000003333333333331E40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517633, 'MT92', 'NL32-02', NULL, 'UZNACH', 'Uznach', 'Uznach', '0101000020E6100000B122597677F72140ED5003BCBB9B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517634, 'NT15', 'NL32-02', NULL, 'UZWIL', 'Uzwil', 'Uzwil', '0101000020E61000007EEF25434444224046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517635, 'NR07', 'NL32-08', NULL, 'VACALLO', 'Vacallo', 'Vacallo', '0101000020E61000004BBCF20F11112240CDCCCCCCCCEC4640');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517637, 'MS80', 'NL32-05', NULL, 'VAIRANO', 'Vairano', 'Vairano', '0101000020E6100000E976402322A22140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517643, 'LR39', 'NL32-04', NULL, 'VALANGIN', 'Valangin', 'Valangin', '0101000020E61000009A99999999991B4054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517644, 'NS98', 'NL32-06', NULL, 'VALATSCHA', 'Valatscha', 'Valatscha', '0101000020E6100000B12259767777244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517645, 'NS16', 'NL32-05', NULL, 'VALATSCHALP', 'Valatschalp', 'Valatschalp', '0101000020E61000006666666666662240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517646, 'NS13', 'NL32-05', NULL, 'VALBELLA', 'Valbella', 'Valbella', '0101000020E61000007EEF2543444422403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517647, 'PS06', 'NL32-06', NULL, 'VALCAVA', 'Valcava', 'Valcava', '0101000020E6100000CDCCCCCCCCCC2440CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517649, 'LS31', 'NL32-04', NULL, 'VALDILLIEZ', 'Val d’Illiez', 'Val d’Illiez', '0101000020E61000009A99999999991B409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517650, 'NS28', 'NL32-05', NULL, 'VALENDAS', 'Valendas', 'Valendas', '0101000020E61000004FDDA6898888224013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517651, 'NT30', 'NL32-05', NULL, 'VALENS', 'Valens', 'Valens', '0101000020E6100000B122597677F72240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517654, 'LS07', 'NL32-04', NULL, 'VALLORBE', 'Vallorbe', 'Vallorbe', '0101000020E6100000FCDE4B8688881940ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517658, 'NS16', 'NL32-05', NULL, 'VALSPLATZ', 'Vals Platz', 'Vals Platz', '0101000020E61000001789BFDCDD5D2240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517659, 'NT20', 'NL32-05', NULL, 'VALTNOVALP', 'Valtnovalp', 'Valtnovalp', '0101000020E6100000E976402322A22240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517660, 'NS49', 'NL32-05', NULL, 'VALZEINA', 'Valzeina', 'Valzeina', '0101000020E610000033333333333323409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517661, 'KS82', 'NL32-04', NULL, 'VANDOEUVRES', 'Vandœuvres', 'Vandouvres', '0101000020E6100000CDCCCCCCCCCC1840ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517662, 'NS06', 'NL32-05', NULL, 'VANESCHA', 'Vanescha', 'Vanescha', '0101000020E6100000E976402322222240218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517664, 'LS93', 'NL32-04', NULL, 'VAREN', 'Varen', 'Varen', '0101000020E61000000421B47977771E40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517665, 'NS39', 'NL32-05', NULL, 'VASON', 'Vasön', 'Vason', '0101000020E6100000B5430DF0EEEE22409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517666, 'NS39', 'NL32-05', NULL, 'VATTIS', 'Vättis', 'Vattis', '0101000020E61000001789BFDCDDDD224087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517670, 'LS36', 'NL32-04', NULL, 'VAUDERENS', 'Vauderens', 'Vauderens', '0101000020E61000006666666666661B40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517671, 'LT62', 'NL32-01', NULL, 'VAUFFELIN', 'Vauffelin', 'Vauffelin', '0101000020E61000009578E51F22221D4046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517672, 'KS97', 'NL32-04', NULL, 'VAULION', 'Vaulion', 'Vaulion', '0101000020E6100000FCDE4B86888819409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517674, 'LS46', 'NL32-04', NULL, 'VAULRUZ', 'Vaulruz', 'Vaulruz', '0101000020E61000000000000000001C40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517675, 'LT80', 'NL32-04', NULL, 'VECHIGEN', 'Vechigen', 'Vechigen', '0101000020E61000003333333333331E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517682, 'MT45', 'NL32-02', NULL, 'VELTHEIM', 'Veltheim', 'Veltheim', '0101000020E6100000B12259767777204046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517683, 'MT76', 'NL32-02', NULL, 'VELTHEIM', 'Veltheim', 'Veltheim', '0101000020E6100000666666666666214013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517685, 'LT65', 'NL32-01', NULL, 'VENDLINCOURT', 'Vendlincourt', 'Vendlincourt', '0101000020E61000009A99999999991C409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517688, 'LS15', 'NL32-04', NULL, 'VENNES', 'Vennes', 'Vennes', '0101000020E61000009A99999999991A406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517694, 'LS60', 'NL32-04', NULL, 'VERBIER', 'Verbier', 'Verbier', '0101000020E61000006B871AE0DDDD1C40CDCCCCCCCC0C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517695, 'KS61', 'NL32-04', NULL, 'VERBOIS', 'Verbois', 'Verbois', '0101000020E61000009EBA4D131111184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517696, 'LS82', 'NL32-04', NULL, 'VERCORIN', 'Vercorin', 'Vercorin', '0101000020E61000009EBA4D1311111E400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517698, 'NS12', 'NL32-05', NULL, 'VERDABBIO', 'Verdabbio', 'Verdabbio', '0101000020E6100000CDCCCCCCCC4C224054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517699, 'MS71', 'NL32-05', NULL, 'VERDASIO', 'Verdasio', 'Verdasio', '0101000020E61000007EEF25434444214087EA9C5555154740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517700, 'MS71', 'NL32-05', NULL, 'VERGELETTO', 'Vergeletto', 'Vergeletto', '0101000020E61000008210DABCBB3B2140ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517701, 'LS83', 'NL32-04', NULL, 'VERMALA', 'Vermala', 'Vermala', '0101000020E61000006245B2ECEEEE1D40BA1DD08888284740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517702, 'LT84', 'NL32-01', NULL, 'VERMES', 'Vermes', 'Vermes', '0101000020E61000006B871AE0DDDD1D40791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517704, 'LS71', 'NL32-04', NULL, 'VERNAMIEGE', 'Vernamiège', 'Vernamiege', '0101000020E61000002F127FB9BBBB1D40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517705, 'LS51', 'NL32-04', NULL, 'VERNAYAZ', 'Vernayaz', 'Vernayaz', '0101000020E6100000D1ED804644441C40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517708, 'LS80', 'NL32-04', NULL, 'VERNEC', 'Vernec', 'Vernec', '0101000020E6100000CDCCCCCCCCCC1D40218436EFEE0E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517709, 'KS72', 'NL32-04', 3, 'VERNIER', 'Vernier', 'Vernier', '0101000020E6100000C8AB185355551840ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517710, 'NS28', 'NL32-05', NULL, 'VERSAM', 'Versam', 'Versam', '0101000020E6100000E4558CA9AAAA22406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517711, 'MS71', 'NL32-05', NULL, 'VERSCIO', 'Verscio', 'Verscio', '0101000020E6100000B12259767777214046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517712, 'KS82', 'NL32-04', NULL, 'VERSOIX', 'Versoix', 'Versoix', '0101000020E61000003854E7ACAAAA184013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517719, 'KS82', 'NL32-04', NULL, 'VESENAZ', 'Vésenaz', 'Vesenaz', '0101000020E6100000CDCCCCCCCCCC1840AC4896DDDD1D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517721, 'LS61', 'NL32-04', NULL, 'VETROZ', 'Vétroz', 'Vetroz', '0101000020E61000009578E51F22221D40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517722, 'LS34', 'NL32-04', NULL, 'VEVEY', 'Vevey', 'Vevey', '0101000020E61000006666666666661B409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517723, 'LS71', 'NL32-04', NULL, 'VEX', 'Vex', 'Vex', '0101000020E61000009A99999999991D409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517724, 'KS81', 'NL32-04', NULL, 'VEYRIER', 'Veyrier', 'Veyrier', '0101000020E6100000CDCCCCCCCCCC184046E22F7777174740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517725, 'LS71', 'NL32-04', NULL, 'VEYSONNAZ', 'Veysonnaz', 'Veysonnaz', '0101000020E6100000C8AB185355551D409A99999999194740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517726, 'LS44', 'NL32-04', NULL, 'VEYTAUX', 'Veytaux', 'Veytaux', '0101000020E61000002F127FB9BBBB1B4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517730, 'NS82', 'NL32-06', NULL, 'VIANO', 'Viano', 'Viano', '0101000020E6100000CDCCCCCCCC4C24400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517731, 'NS43', 'NL32-05', NULL, 'VICOSOPRANO', 'Vicosoprano', 'Vicosoprano', '0101000020E61000008210DABCBB3B2340CDCCCCCCCC2C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517732, 'LT84', 'NL32-01', NULL, 'VICQUES', 'Vicques', 'Vicques', '0101000020E61000003854E7ACAAAA1D40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517736, 'MR99', 'NL32-05', NULL, 'VIGANELLO', 'Viganello', 'Viganello', '0101000020E6100000B122597677F7214054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517737, 'NS17', 'NL32-05', NULL, 'VIGENS', 'Vigens', 'Vigens', '0101000020E6100000CDCCCCCCCC4C22409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517739, 'MS65', 'NL32-05', NULL, 'VILLA', 'Villa', 'Villa', '0101000020E61000004FDDA6898808214054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517740, 'NS17', 'NL32-05', NULL, 'VILLA', 'Villa', 'Villa', '0101000020E61000001CAA735655552240ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517743, 'LS47', 'NL32-04', NULL, 'VILLARSELLEGIBLOUX', 'Villarsel-le-Gibloux', 'Villarsel-le-Gibloux', '0101000020E61000009EBA4D1311111C40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517744, 'LS47', 'NL32-04', NULL, 'VILLARSIVIRIAUX', 'Villarsiviriaux', 'Villarsiviriaux', '0101000020E61000009EBA4D1311111C409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517745, 'LS49', 'NL32-04', NULL, 'VILLARSLEGRAND', 'Villars-le-Grand', 'Villars-le-Grand', '0101000020E61000000000000000001C403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517746, 'LS58', 'NL32-04', NULL, 'VILLARSSURGLANE', 'Villars-sur-Glâne', 'Villars-sur-Glane', '0101000020E61000000421B47977771C406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517747, 'LS68', 'NL32-04', NULL, 'VILLARSSURMARLY', 'Villars-sur-Marly', 'Villars-sur-Marly', '0101000020E61000002F127FB9BBBB1C4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517748, 'LS42', 'NL32-04', NULL, 'VILLARSSUROLLON', 'Villars-sur-Ollon', 'Villars-sur-Ollon', '0101000020E61000003333333333331C406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517749, 'LS56', 'NL32-04', NULL, 'VILLARVOLARD', 'Villarvolard', 'Villarvolard', '0101000020E61000006666666666661C403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517750, 'LS47', 'NL32-04', NULL, 'VILLAZSAINTPIERRE', 'Villaz-Saint-Pierre', 'Villaz-Saint-Pierre', '0101000020E61000006B871AE0DDDD1B40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517752, 'LS44', 'NL32-04', NULL, 'VILLENEUVE', 'Villeneuve', 'Villeneuve', '0101000020E61000002F127FB9BBBB1B403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517753, 'LT52', 'NL32-01', NULL, 'VILLERET', 'Villeret', 'Villeret', '0101000020E61000009578E51F22221C4087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517754, 'LS81', 'NL32-04', NULL, 'VILLETTA', 'Villetta', 'Villetta', '0101000020E61000006B871AE0DDDD1D40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517756, 'MT46', 'NL32-02', NULL, 'VILLIGEN', 'Villigen', 'Villigen', '0101000020E6100000B5430DF0EE6E204054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517757, 'MT44', 'NL32-02', NULL, 'VILLMERGEN', 'Villmergen', 'Villmergen', '0101000020E61000000000000000802040CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517758, 'MT35', 'NL32-02', NULL, 'VILLNACHERN', 'Villnachern', 'Villnachern', '0101000020E61000001CAA735655552040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517759, 'NT30', 'NL32-02', NULL, 'VILTERS', 'Vilters', 'Vilters', '0101000020E61000006666666666E6224054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517760, 'KS84', 'NL32-04', NULL, 'VINZEL', 'Vinzel', 'Vinzel', '0101000020E610000000000000000019409A99999999394740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517761, 'LS32', 'NL32-04', NULL, 'VIONNAZ', 'Vionnaz', 'Vionnaz', '0101000020E61000009A99999999991B406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517762, 'MS80', 'NL32-05', NULL, 'VIRA', 'Vira', 'Vira', '0101000020E6100000E4558CA9AAAA2140DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517764, 'MS62', 'NL32-05', NULL, 'VISLETTO', 'Visletto', 'Visletto', '0101000020E610000033333333333321406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517765, 'MS12', 'NL32-04', NULL, 'VISP', 'Visp', 'Visp', '0101000020E61000000421B47977771F4013AFFC4344244740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517769, 'MS12', 'NL32-04', NULL, 'VISPERTERMINEN', 'Visperterminen', 'Visperterminen', '0101000020E61000009A99999999991F400000000000204740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517770, 'LS72', 'NL32-04', NULL, 'VISSE', 'Visse', 'Visse', '0101000020E6100000C8AB185355551D406666666666264740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517771, 'LS91', 'NL32-04', NULL, 'VISSOIE', 'Vissoie', 'Vissoie', '0101000020E6100000C8AB185355551E40ED5003BCBB1B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517775, 'MT60', 'NL32-02', NULL, 'VITZNAU', 'Vitznau', 'Vitznau', '0101000020E6100000B122597677F7204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517777, 'MT74', 'NL32-02', NULL, 'VOLKETSWIL', 'Volketswil', 'Volketswil', '0101000020E61000006666666666662140DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517779, 'MT13', 'NL32-01', NULL, 'VORDEMWALD', 'Vordemwald', 'Vordemwald', '0101000020E6100000FCDE4B8688881F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517780, 'MS88', 'NL32-05', NULL, 'VORDERBODEN', 'Vorder Boden', 'Vorder Boden', '0101000020E61000000000000000802140791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517781, 'MT73', 'NL32-02', NULL, 'VORDERFELD', 'Vorder Feld', 'Vorder Feld', '0101000020E61000008210DABCBB3B214054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517782, 'LS78', 'NL32-04', NULL, 'VORDERFULTIGEN', 'Vorderfultigen', 'Vorderfultigen', '0101000020E61000003854E7ACAAAA1D40791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517785, 'MS37', 'NL32-05', NULL, 'VORDERSTAFEL', 'Vorder Stafel', 'Vorder Stafel', '0101000020E61000001789BFDCDD5D204054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517787, 'MT91', 'NL32-02', NULL, 'VORDERTHAL', 'Vorderthal', 'Vorderthal', '0101000020E61000007EEF254344C42140218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517790, 'MS89', 'NL32-05', NULL, 'VORFRUTT', 'Vorfrutt', 'Vorfrutt', '0101000020E61000008210DABCBBBB2140DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517791, 'NT20', 'NL32-05', NULL, 'VORSIEZ', 'Vor Siez', 'Vor Siez', '0101000020E61000009A99999999992240ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517792, 'LS33', 'NL32-04', NULL, 'VOUVRY', 'Vouvry', 'Vouvry', '0101000020E6100000FCDE4B8688881B40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517793, 'NS06', 'NL32-05', NULL, 'VRIN', 'Vrin', 'Vrin', '0101000020E610000033333333333322403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517795, 'LS46', 'NL32-04', NULL, 'VUADENS', 'Vuadens', 'Vuadens', '0101000020E61000009578E51F22221C40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517799, 'LS57', 'NL32-04', NULL, 'VUISTERNENS', 'Vuisternens', 'Vuisternens', '0101000020E61000003333333333331C409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517800, 'LS18', 'NL32-04', NULL, 'VUITEBOEUF', 'Vuiteboeuf', 'Vuiteboeuf', '0101000020E61000003333333333331A406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517801, 'LS06', 'NL32-04', NULL, 'VULLIERENS', 'Vullierens', 'Vullierens', '0101000020E61000006B871AE0DDDD1940BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517803, 'NS98', 'NL32-06', NULL, 'VULPERA', 'Vulpera', 'Vulpera', '0101000020E61000004BBCF20F1191244013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517806, 'LS89', 'NL32-04', NULL, 'WABERN', 'Wabern', 'Wabern', '0101000020E61000006245B2ECEEEE1D4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517807, 'MS08', 'NL32-04', NULL, 'WACHSELDORN', 'Wachseldorn', 'Wachseldorn', '0101000020E61000006245B2ECEEEE1E40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517808, 'MT73', 'NL32-02', NULL, 'WADENSWIL', 'Wädenswil', 'Wadenswil', '0101000020E61000001CAA735655552140AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517809, 'MT87', 'NL32-02', NULL, 'WAGENHAUSEN', 'Wagenhausen', 'Wagenhausen', '0101000020E61000003333333333B321403333333333D34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517816, 'LS97', 'NL32-04', NULL, 'WAHLEN', 'Wahlen', 'Wahlen', '0101000020E6100000D1ED804644441E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517817, 'LT85', 'NL32-01', NULL, 'WAHLEN', 'Wahlen', 'Wahlen', '0101000020E61000000000000000001E403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517818, 'LS78', 'NL32-04', NULL, 'WAHLERN', 'Wahlern', 'Wahlern', '0101000020E61000006666666666661D40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517819, 'MT61', 'NL32-02', NULL, 'WALCHWIL', 'Walchwil', 'Walchwil', '0101000020E61000004FDDA68988082140CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517820, 'MS18', 'NL32-04', NULL, 'WALD', 'Wald', 'Wald', '0101000020E61000006666666666661F40BA1DD08888684740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517821, 'MT93', 'NL32-02', NULL, 'WALD', 'Wald', 'Wald', '0101000020E61000001CAA735655D5214013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517823, 'MT04', 'NL32-01', NULL, 'WALDENBURG', 'Waldenburg', 'Waldenburg', '0101000020E61000000000000000001F40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517824, 'NS28', 'NL32-05', NULL, 'WALDHAUS', 'Waldhaus', 'Waldhaus', '0101000020E61000004BBCF20F11912240791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517825, 'MS49', 'NL32-05', NULL, 'WALDHEIM', 'Waldheim', 'Waldheim', '0101000020E6100000E976402322A2204046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517826, 'NT07', 'NL32-02', NULL, 'WALDI', 'Wäldi', 'Waldi', '0101000020E6100000E4558CA9AA2A2240DF7BC91011D14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517827, 'NT25', 'NL32-02', NULL, 'WALDKIRCH', 'Waldkirch', 'Waldkirch', '0101000020E61000004BBCF20F11912240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517828, 'NT24', 'NL32-02', NULL, 'WALDSTATT', 'Waldstatt', 'Waldstatt', '0101000020E61000004BBCF20F11912240218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517831, 'LT90', 'NL32-04', NULL, 'WALKRINGEN', 'Walkringen', 'Walkringen', '0101000020E61000000421B47977771E409A99999999794740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517832, 'LS69', 'NL32-04', NULL, 'WALLENBUCH', 'Wallenbuch', 'Wallenbuch', '0101000020E61000006B871AE0DDDD1C4087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517834, 'LS59', 'NL32-04', NULL, 'WALLENRIED', 'Wallenried', 'Wallenried', '0101000020E61000000421B47977771C40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517836, 'NT21', 'NL32-02', NULL, 'WALLENSTADT', 'Wallenstadt', 'Wallenstadt', '0101000020E6100000E976402322A22240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517839, 'MT65', 'NL32-02', NULL, 'WALLISELLEN', 'Wallisellen', 'Wallisellen', '0101000020E6100000E4558CA9AA2A214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517841, 'NS07', 'NL32-05', NULL, 'WALTENSBURG', 'Waltensburg', 'Waltensburg', '0101000020E61000008210DABCBB3B224054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517843, 'MT44', 'NL32-02', NULL, 'WALTENSCHWIL', 'Waltenschwil', 'Waltenschwil', '0101000020E61000009A99999999992040791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517844, 'MT01', 'NL32-01', NULL, 'WALTERSWIL', 'Walterswil', 'Walterswil', '0101000020E61000009EBA4D1311111F40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517845, 'MT74', 'NL32-02', NULL, 'WALTIKON', 'Waltikon', 'Waltikon', '0101000020E61000008210DABCBB3B2140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517846, 'NT45', 'NL32-02', NULL, 'WALZENHAUSEN', 'Walzenhausen', 'Walzenhausen', '0101000020E610000033333333333323409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517847, 'MT92', 'NL32-02', NULL, 'WANGEN', 'Wangen', 'Wangen', '0101000020E6100000CDCCCCCCCCCC214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517849, 'MT14', 'NL32-01', NULL, 'WANGEN', 'Wangen', 'Wangen', '0101000020E61000000421B47977771F40CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517850, 'LT93', 'NL32-01', NULL, 'WANGENANDERAARE', 'Wangen an der Aare', 'Wangen an der Aare', '0101000020E61000009A99999999991E40AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517851, 'MT96', 'NL32-02', NULL, 'WANGI', 'Wängi', 'Wangi', '0101000020E61000006666666666E621400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517852, 'NT30', 'NL32-02', NULL, 'WANGS', 'Wangs', 'Wangs', '0101000020E61000001789BFDCDDDD224013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517856, 'MT00', 'NL32-01', NULL, 'WASEN', 'Wasen', 'Wasen', '0101000020E61000009578E51F22221F4013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517857, 'MS67', 'NL32-05', NULL, 'WASSEN', 'Wassen', 'Wassen', '0101000020E610000033333333333321409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517858, 'NT33', 'NL32-02', NULL, 'WASSERAUEN', 'Wasserauen', 'Wasserauen', '0101000020E61000001789BFDCDDDD224013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517861, 'MT67', 'NL32-02', NULL, 'WASTERKINGEN', 'Wasterkingen', 'Wasterkingen', '0101000020E6100000B122597677F72040791563AAAACA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517862, 'LS88', 'NL32-04', NULL, 'WATTENWIL', 'Wattenwil', 'Wattenwil', '0101000020E61000009EBA4D1311111E4054B7692222624740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517863, 'NT03', 'NL32-02', NULL, 'WATTWIL', 'Wattwil', 'Wattwil', '0101000020E6100000E4558CA9AA2A22406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517864, 'MT22', 'NL32-02', NULL, 'WAUWIL', 'Wauwil', 'Wauwil', '0101000020E61000004FDDA6898808204046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517865, 'NT01', 'NL32-02', NULL, 'WEESEN', 'Weesen', 'Weesen', '0101000020E61000003333333333332240DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517866, 'MT16', 'NL32-01', NULL, 'WEGENSTETTEN', 'Wegenstetten', 'Wegenstetten', '0101000020E61000002F127FB9BBBB1F400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517867, 'MT50', 'NL32-02', NULL, 'WEGGIS', 'Weggis', 'Weggis', '0101000020E61000001789BFDCDDDD204013AFFC4344844740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517869, 'LS87', 'NL32-04', NULL, 'WEIERMOOS', 'Weiermoos', 'Weiermoos', '0101000020E61000000000000000001E400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517870, 'NT06', 'NL32-02', NULL, 'WEINFELDEN', 'Weinfelden', 'Weinfelden', '0101000020E61000003333333333332240BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517871, 'MT55', 'NL32-02', NULL, 'WEININGEN', 'Weiningen', 'Weiningen', '0101000020E61000001789BFDCDDDD204087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517872, 'NT34', 'NL32-02', NULL, 'WEISSBAD', 'Weissbad', 'Weissbad', '0101000020E61000001789BFDCDDDD2240BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517873, 'LS76', 'NL32-04', NULL, 'WEISSENBACH', 'Weissenbach', 'Weissenbach', '0101000020E6100000FCDE4B8688881D40218436EFEE4E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517874, 'LS86', 'NL32-04', NULL, 'WEISSENBURG', 'Weissenburg', 'Weissenburg', '0101000020E61000006B871AE0DDDD1D403333333333534740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517882, 'MT85', 'NL32-02', NULL, 'WEISSLINGEN', 'Weisslingen', 'Weisslingen', '0101000020E6100000000000000080214046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517885, 'NT20', 'NL32-05', NULL, 'WEISSTANNEN', 'Weisstannen', 'Weisstannen', '0101000020E6100000E4558CA9AAAA2240AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517886, 'LT83', 'NL32-01', NULL, 'WELSCHENROHR', 'Welschenrohr', 'Welschenrohr', '0101000020E61000009578E51F22221E4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517887, 'MS16', 'NL32-04', NULL, 'WENGEN', 'Wengen', 'Wengen', '0101000020E61000003854E7ACAAAA1F40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517888, 'LT71', 'NL32-01', NULL, 'WENGI', 'Wengi', 'Wengi', '0101000020E61000009A99999999991D40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517889, 'NT32', 'NL32-02', NULL, 'WERDENBERG', 'Werdenberg', 'Werdenberg', '0101000020E6100000B5430DF0EEEE224087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517890, 'MT64', 'NL32-02', NULL, 'WERDHOLZLI', 'Werdhölzli', 'Werdholzli', '0101000020E610000000000000000021403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517891, 'NS36', 'NL32-05', NULL, 'WERGENSTEIN', 'Wergenstein', 'Wergenstein', '0101000020E6100000CDCCCCCCCCCC2240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517893, 'MT83', 'NL32-02', NULL, 'WERNETSHAUSEN', 'Wernetshausen', 'Wernetshausen', '0101000020E61000008210DABCBBBB21406666666666A64740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517894, 'MT31', 'NL32-02', NULL, 'WERTHENSTEIN', 'Werthenstein', 'Werthenstein', '0101000020E610000033333333333320406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517897, 'MT45', 'NL32-02', NULL, 'WETTINGEN', 'Wettingen', 'Wettingen', '0101000020E6100000E976402322A22040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517898, 'MT84', 'NL32-02', NULL, 'WETZIKON', 'Wetzikon', 'Wetzikon', '0101000020E61000004BBCF20F11912140BA1DD08888A84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517899, 'NT06', 'NL32-02', NULL, 'WETZIKON', 'Wetzikon', 'Wetzikon', '0101000020E6100000000000000000224013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517900, 'LS89', 'NL32-04', NULL, 'WEYERMANNSHAUS', 'Weyermannshaus', 'Weyermannshaus', '0101000020E61000009578E51F22221E4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517902, 'MT64', 'NL32-02', NULL, 'WIEDIKON', 'Wiedikon', 'Wiedikon', '0101000020E61000004FDDA68988082140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517903, 'LT93', 'NL32-01', NULL, 'WIEDLISBACH', 'Wiedlisbach', 'Wiedlisbach', '0101000020E61000009A99999999991E400000000000A04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517906, 'NS57', 'NL32-05', NULL, 'WIESEN', 'Wiesen', 'Wiesen', '0101000020E610000066666666666623409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517907, 'MT86', 'NL32-02', NULL, 'WIESENDANGEN', 'Wiesendangen', 'Wiesendangen', '0101000020E61000004BBCF20F1191214054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517908, 'NS57', 'NL32-05', NULL, 'WIESENERALP', 'Wieseneralp', 'Wieseneralp', '0101000020E61000006666666666662340ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517910, 'MS66', 'NL32-05', NULL, 'WIGGEN', 'Wiggen', 'Wiggen', '0101000020E61000004FDDA6898808214087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517911, 'MS19', 'NL32-04', NULL, 'WIGGEN', 'Wiggen', 'Wiggen', '0101000020E61000009A99999999991F403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517915, 'NT07', 'NL32-02', NULL, 'WIGOLTINGEN', 'Wigoltingen', 'Wigoltingen', '0101000020E61000004BBCF20F11112240CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517916, 'MT23', 'NL32-01', NULL, 'WIKON', 'Wikon', 'Wikon', '0101000020E61000006B871AE0DDDD1F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517917, 'NT05', 'NL32-02', NULL, 'WIL', 'Wil', 'Wil', '0101000020E61000009A99999999192240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517918, 'MT36', 'NL32-02', NULL, 'WIL', 'Wil', 'Wil', '0101000020E61000007EEF254344442040BA1DD08888C84740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517919, 'MT67', 'NL32-02', NULL, 'WIL', 'Wil', 'Wil', '0101000020E61000000000000000002140CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517920, 'MT85', 'NL32-02', NULL, 'WILA', 'Wila', 'Wila', '0101000020E6100000E4558CA9AAAA214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517921, 'MT57', 'NL32-02', NULL, 'WILCHINGEN', 'Wilchingen', 'Wilchingen', '0101000020E6100000B5430DF0EEEE204087EA9C5555D54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517922, 'MT85', 'NL32-02', NULL, 'WILDBERG', 'Wildberg', 'Wildberg', '0101000020E61000009A9999999999214087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517923, 'MT34', 'NL32-02', NULL, 'WILDEGG', 'Wildegg', 'Wildegg', '0101000020E61000001CAA735655552040DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517924, 'MS16', 'NL32-04', NULL, 'WILDERSWIL', 'Wilderswil', 'Wilderswil', '0101000020E61000006666666666661F4087EA9C5555554740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517925, 'NT22', 'NL32-02', NULL, 'WILDHAUS', 'Wildhaus', 'Wildhaus', '0101000020E61000003333333333B322409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517929, 'MS03', 'NL32-04', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020E61000009EBA4D1311111F403333333333334740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517930, 'MS07', 'NL32-04', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020E61000006245B2ECEEEE1E40ED5003BCBB5B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517931, 'MS77', 'NL32-05', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020E6100000CDCCCCCCCC4C2140AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517932, 'LT92', 'NL32-01', NULL, 'WILER', 'Wiler', 'Wiler', '0101000020E61000003333333333331E403333333333934740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517933, 'MS49', 'NL32-05', NULL, 'WILERBAD', 'Wilerbad', 'Wilerbad', '0101000020E6100000B122597677772040DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517934, 'LT60', 'NL32-04', NULL, 'WILEROLTIGEN', 'Wileroltigen', 'Wileroltigen', '0101000020E61000006245B2ECEEEE1C40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517935, 'MS37', 'NL32-05', NULL, 'WILLIGEN', 'Willigen', 'Willigen', '0101000020E61000001789BFDCDD5D2040AC4896DDDD5D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517936, 'MT21', 'NL32-01', NULL, 'WILLISAU', 'Willisau', 'Willisau', '0101000020E61000006245B2ECEEEE1F40218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517938, 'LS97', 'NL32-04', NULL, 'WIMMIS', 'Wimmis', 'Wimmis', '0101000020E6100000FCDE4B8688881E4046E22F7777574740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517939, 'MT45', 'NL32-02', NULL, 'WINDISCH', 'Windisch', 'Windisch', '0101000020E6100000B122597677772040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517940, 'MT56', 'NL32-02', NULL, 'WINDLACH', 'Windlach', 'Windlach', '0101000020E6100000B5430DF0EEEE204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517941, 'MT23', 'NL32-02', NULL, 'WINIKON', 'Winikon', 'Winikon', '0101000020E61000009A99999999192040AC4896DDDD9D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517942, 'MT40', 'NL32-02', NULL, 'WINKEL', 'Winkel', 'Winkel', '0101000020E6100000E976402322A2204054B7692222824740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517943, 'NT24', 'NL32-02', NULL, 'WINKELN', 'Winkeln', 'Winkeln', '0101000020E61000009A999999999922403333333333B34740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517945, 'LS96', 'NL32-04', NULL, 'WINKLEN', 'Winklen', 'Winklen', '0101000020E61000009A99999999991E40CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517946, 'MT86', 'NL32-02', 2, 'WINTERTHUR', 'Winterthur', 'Winterthur', '0101000020E610000000000000008021400000000000C04740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517949, 'MT64', 'NL32-02', NULL, 'WITIKON', 'Witikon', 'Witikon', '0101000020E6100000E4558CA9AA2A2140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517950, 'NT25', 'NL32-02', NULL, 'WITTENBACH', 'Wittenbach', 'Wittenbach', '0101000020E61000008210DABCBBBB2240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517951, 'MT25', 'NL32-01', NULL, 'WITTNAU', 'Wittnau', 'Wittnau', '0101000020E61000006245B2ECEEEE1F40AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517952, 'NS67', 'NL32-05', NULL, 'WITY', 'Wity', 'Wity', '0101000020E6100000E4558CA9AAAA23400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517953, 'LT50', 'NL32-04', NULL, 'WITZWIL', 'Witzwil', 'Witzwil', '0101000020E61000003333333333331C40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517954, 'LT70', 'NL32-04', NULL, 'WOHLEN', 'Wohlen', 'Wohlen', '0101000020E61000006666666666661D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517955, 'MT44', 'NL32-02', NULL, 'WOHLEN', 'Wohlen', 'Wohlen', '0101000020E61000004BBCF20F11912040218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517957, 'MS59', 'NL32-05', NULL, 'WOLFENSCHIESSEN', 'Wolfenschiessen', 'Wolfenschiessen', '0101000020E6100000CDCCCCCCCCCC204087EA9C5555754740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517958, 'NS68', 'NL32-05', NULL, 'WOLFGANG', 'Wolfgang', 'Wolfgang', '0101000020E61000003333333333B32340791563AAAA6A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517959, 'MT25', 'NL32-01', NULL, 'WOLFLINSWIL', 'Wölflinswil', 'Wolflinswil', '0101000020E61000006245B2ECEEEE1F409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517961, 'MT03', 'NL32-01', NULL, 'WOLFWIL', 'Wolfwil', 'Wolfwil', '0101000020E61000009578E51F22221F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517962, 'MT21', 'NL32-02', NULL, 'WOLHUSEN', 'Wolhusen', 'Wolhusen', '0101000020E6100000E9764023222220406666666666864740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517963, 'MT72', 'NL32-02', NULL, 'WOLLERAU', 'Wollerau', 'Wollerau', '0101000020E6100000666666666666214046E22F7777974740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517964, 'LS99', 'NL32-04', NULL, 'WORB', 'Worb', 'Worb', '0101000020E6100000D1ED804644441E4046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517965, 'LT61', 'NL32-01', NULL, 'WORBEN', 'Worben', 'Worben', '0101000020E61000009578E51F22221D40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517966, 'LT80', 'NL32-04', NULL, 'WORBLAUFEN', 'Worblaufen', 'Worblaufen', '0101000020E61000006B871AE0DDDD1D40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517970, 'LS69', 'NL32-04', NULL, 'WUNNEWIL', 'Wünnewil', 'Wunnewil', '0101000020E61000009EBA4D1311111D40DF7BC91011714740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517971, 'NT05', 'NL32-02', NULL, 'WUPPENAU', 'Wuppenau', 'Wuppenau', '0101000020E61000003333333333332240AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517973, 'MT46', 'NL32-02', NULL, 'WURENLINGEN', 'Würenlingen', 'Wurenlingen', '0101000020E61000004FDDA6898888204013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517974, 'MT55', 'NL32-02', NULL, 'WURENLOS', 'Würenlos', 'Wurenlos', '0101000020E61000008210DABCBBBB20409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517975, 'MT06', 'NL32-01', NULL, 'WYHLEN', 'Wyhlen', 'Wyhlen', '0101000020E61000006B871AE0DDDD1E4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517976, 'MT03', 'NL32-01', NULL, 'WYNAU', 'Wynau', 'Wynau', '0101000020E61000003333333333331F4054B7692222A24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517977, 'LT91', 'NL32-01', NULL, 'WYNIGEN', 'Wynigen', 'Wynigen', '0101000020E61000003854E7ACAAAA1E40CDCCCCCCCC8C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517978, 'MT11', 'NL32-01', NULL, 'WYSSACHEN', 'Wyssachen', 'Wyssachen', '0101000020E6100000D1ED804644441F40791563AAAA8A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517981, 'LS05', 'NL32-04', NULL, 'YENS', 'Yens', 'Yens', '0101000020E61000003854E7ACAAAA194054B7692222424740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (9224695, 'LS28', 'NL32-04', 3, 'YVERDONLESBAINS', 'Yverdon-les-Bains', 'Yverdon-les-Bains', '0101000020E61000009A99999999991A4013AFFC4344644740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517984, 'LS28', 'NL32-04', NULL, 'YVONAND', 'Yvonand', 'Yvonand', '0101000020E61000000000000000001B406666666666664740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517985, 'LS43', 'NL32-04', NULL, 'YVORNE', 'Yvorne', 'Yvorne', '0101000020E61000006B871AE0DDDD1B40791563AAAA2A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517986, 'NS27', 'NL32-05', NULL, 'ZALONERHUTTEN', 'Zalöner Hütten', 'Zaloner Hutten', '0101000020E61000009A999999999922409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517989, 'LS99', 'NL32-04', NULL, 'ZAZIWIL', 'Zäziwil', 'Zaziwil', '0101000020E61000009A99999999991E403333333333734740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517990, 'MT15', 'NL32-01', NULL, 'ZEGLINGEN', 'Zeglingen', 'Zeglingen', '0101000020E61000009A99999999991F4087EA9C5555B54740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517991, 'MT35', 'NL32-02', NULL, 'ZEIHEN', 'Zeihen', 'Zeihen', '0101000020E6100000E4558CA9AA2A2040ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517992, 'LS84', 'NL32-04', NULL, 'ZELG', 'Zelg', 'Zelg', '0101000020E61000006B871AE0DDDD1D4087EA9C5555354740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517993, 'MT12', 'NL32-01', NULL, 'ZELL', 'Zell', 'Zell', '0101000020E61000003854E7ACAAAA1F40DF7BC91011914740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517994, 'MT85', 'NL32-02', NULL, 'ZELL', 'Zell', 'Zell', '0101000020E6100000E976402322A221409A99999999B94740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517995, 'MS12', 'NL32-04', NULL, 'ZENEGGEN', 'Zeneggen', 'Zeneggen', '0101000020E61000006666666666661F4054B7692222224740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517996, 'MR09', 'NL32-04', NULL, 'ZERMATT', 'Zermatt', 'Zermatt', '0101000020E61000000000000000001F4054B7692222024740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517997, 'MS10', 'NL32-04', NULL, 'ZERMEIGGERN', 'Zermeiggern', 'Zermeiggern', '0101000020E6100000CDCCCCCCCCCC1F40791563AAAA0A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3517999, 'NS87', 'NL32-06', NULL, 'ZERNEZ', 'Zernez', 'Zernez', '0101000020E610000033333333333324409A99999999594740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518000, 'NS05', 'NL32-05', NULL, 'ZERVREILA', 'Zervreila', 'Zervreila', '0101000020E61000003333333333332240BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518001, 'NS05', 'NL32-05', NULL, 'ZERVREILAOBERBODEN', 'Zervreila-Oberboden', 'Zervreila-Oberboden', '0101000020E61000003333333333332240BA1DD08888484740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518002, 'NS05', 'NL32-05', NULL, 'ZERVREILAUNTERBODEN', 'Zervreila-Unterboden', 'Zervreila-Unterboden', '0101000020E61000008210DABCBB3B2240791563AAAA4A4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518003, 'NT01', 'NL32-02', NULL, 'ZIEGELBRUCKE', 'Ziegelbrücke', 'Ziegelbrucke', '0101000020E61000009A99999999192240218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518007, 'NT16', 'NL32-02', NULL, 'ZIHLSCHLACHT', 'Zihlschlacht', 'Zihlschlacht', '0101000020E6100000000000000080224054B7692222C24740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518008, 'NS36', 'NL32-05', NULL, 'ZILLIS', 'Zillis', 'Zillis', '0101000020E61000006666666666E62240DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518009, 'LS89', 'NL32-04', NULL, 'ZIMMERWALD', 'Zimmerwald', 'Zimmerwald', '0101000020E61000006B871AE0DDDD1D40218436EFEE6E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518010, 'LS90', 'NL32-04', NULL, 'ZINAL', 'Zinal', 'Zinal', '0101000020E6100000FCDE4B8688881E40DF7BC91011114740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518012, 'NS49', 'NL32-05', NULL, 'ZIZERS', 'Zizers', 'Zizers', '0101000020E6100000E97640232222234046E22F7777774740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518013, 'MT13', 'NL32-01', NULL, 'ZOFINGEN', 'Zofingen', 'Zofingen', '0101000020E61000002F127FB9BBBB1F4013AFFC4344A44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518014, 'MT00', 'NL32-04', NULL, 'ZOLLBRUCK', 'Zollbrück', 'Zollbruck', '0101000020E61000000000000000001F40ED5003BCBB7B4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518015, 'LT80', 'NL32-04', NULL, 'ZOLLIKOFEN', 'Zollikofen', 'Zollikofen', '0101000020E61000006B871AE0DDDD1D40AC4896DDDD7D4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518016, 'MT64', 'NL32-02', NULL, 'ZOLLIKON', 'Zollikon', 'Zollikon', '0101000020E6100000E4558CA9AA2A2140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518020, 'LT92', 'NL32-01', NULL, 'ZUCHWIL', 'Zuchwil', 'Zuchwil', '0101000020E6100000D1ED804644441E409A99999999994740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518021, 'NT15', 'NL32-02', NULL, 'ZUCKENRIET', 'Zuckenriet', 'Zuckenriet', '0101000020E6100000CDCCCCCCCC4C2240AC4896DDDDBD4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518023, 'MT62', 'NL32-02', 3, 'ZUG', 'Zug', 'Zug', '0101000020E61000004FDDA6898808214087EA9C5555954740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518028, 'MT61', 'NL32-02', NULL, 'ZUGERSEE', 'Zugersee', 'Zugersee', '0101000020E6100000B122597677F72040218436EFEE8E4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518030, 'LT94', 'NL32-01', NULL, 'ZULLWIL', 'Zullwil', 'Zullwil', '0101000020E61000006666666666661E40DF7BC91011B14740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518031, 'MS66', 'NL32-05', NULL, 'ZUMDORF', 'Zumdorf', 'Zumdorf', '0101000020E61000004BBCF20F11112140CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518032, 'LS77', 'NL32-04', NULL, 'ZUMHOLZ', 'Zumholz', 'Zumholz', '0101000020E61000003333333333331D400000000000604740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518033, 'MT74', 'NL32-02', NULL, 'ZUMIKON', 'Zumikon', 'Zumikon', '0101000020E61000008210DABCBB3B2140791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518038, 'MT05', 'NL32-01', NULL, 'ZUNZGEN', 'Zunzgen', 'Zunzgen', '0101000020E61000003333333333331F4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518039, 'NS76', 'NL32-05', NULL, 'ZUOZ', 'Zuoz', 'Zuoz', '0101000020E61000006666666666E62340CDCCCCCCCC4C4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518040, 'NT24', 'NL32-02', NULL, 'ZURCHERSMUHLE', 'Zürchersmühle', 'Zurchersmuhle', '0101000020E61000009A99999999992240791563AAAAAA4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518042, 'MT64', 'NL32-02', 1, 'ZURICH', 'Zürich', 'Zurich', '0101000020E61000009A99999999192140218436EFEEAE4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518048, 'MT64', 'NL32-02', NULL, 'ZURICHHORN', 'Zürichhorn', 'Zurichhorn', '0101000020E61000009A99999999192140CDCCCCCCCCAC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518051, 'MT47', 'NL32-02', NULL, 'ZURZACH', 'Zurzach', 'Zurzach', '0101000020E61000009A99999999992040CDCCCCCCCCCC4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518052, 'MT16', 'NL32-01', NULL, 'ZUZGEN', 'Zuzgen', 'Zuzgen', '0101000020E61000009A99999999991F4013AFFC4344C44740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518053, 'NT05', 'NL32-02', NULL, 'ZUZWIL', 'Zuzwil', 'Zuzwil', '0101000020E61000008210DABCBB3B2240ED5003BCBBBB4740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518054, 'MS16', 'NL32-04', NULL, 'ZWEILUTSCHINEN', 'Zweilütschinen', 'Zweilutschinen', '0101000020E61000009A99999999991F40DF7BC91011514740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518055, 'LS75', 'NL32-04', NULL, 'ZWEISIMMEN', 'Zweisimmen', 'Zweisimmen', '0101000020E61000000421B47977771D406666666666464740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518056, 'LT85', 'NL32-01', NULL, 'ZWINGEN', 'Zwingen', 'Zwingen', '0101000020E61000009EBA4D1311111E4046E22F7777B74740');
INSERT INTO staedte_schweiz ("UNI", "UTM", "JOG", "PC", "SORT_NAME", "FULL_NAME", "FULL_NAME_ND", the_geom) VALUES (-3518057, 'MS31', 'NL32-05', NULL, 'ZWISCHBERGEN', 'Zwischbergen', 'Zwischbergen', '0101000020E61000008210DABCBB3B204087EA9C5555154740');


--
-- TOC entry 2002 (class 2606 OID 5191221)
-- Dependencies: 1661 1661
-- Name: pk_uni_staedte_schweiz; Type: CONSTRAINT; Schema: public; Owner: -; Tablespace: 
--

ALTER TABLE ONLY staedte_schweiz
    ADD CONSTRAINT pk_uni_staedte_schweiz PRIMARY KEY ("UNI");


--
-- TOC entry 2000 (class 1259 OID 5191225)
-- Dependencies: 1429 1661
-- Name: in_the_geom; Type: INDEX; Schema: public; Owner: -; Tablespace: 
--

CREATE INDEX in_the_geom ON staedte_schweiz USING gist (the_geom);


-- Completed on 2007-10-10 23:06:47 CEST

--
-- PostgreSQL database dump complete
--

