/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.worldfiletool;

import ch.hsr.worldfiletool.GUI_Swing;
import ch.hsr.worldfiletool.RotateImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class WorldFileTool {
    private static final String version = "0.3.3";
    String name = "";
    String color = "";
    String image = "";
    String view = "";
    String north = "";
    String west = "";
    String south = "";
    String east = "";
    String floor = "0";
    String maptype = "0";
    String priority = "0";
    private String input;
    double rot_y = 0.0;
    double rot_x = 0.0;
    double image_height = 0.0;
    double image_width = 0.0;
    String ext = "";
    String wf_ext = "";
    String[] values = new String[]{this.name, this.image, this.north, this.west, this.south, this.east, this.floor, this.maptype, this.priority};
    static GUI_Swing guiswing;
    private static final String wait = "wait";
    private static final String arrow = "arrow";

    public static void main(String[] args) {
        guiswing = new GUI_Swing();
        guiswing.create_gui(version);
    }

    public void read_kml(String path, File file) {
        this.clear();
        boolean foundImage = false;
        StringBuffer temp = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                temp.append(line + "\n");
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            this.error_message("File Not Found", e.getMessage());
        }
        catch (IOException e) {
            System.out.println("read kml " + e);
        }
        this.input = temp.toString();
        this.name = this.extract("<name>", "</name>").trim();
        this.color = this.extract("<color>", "</color>").trim();
        this.view = this.extract("<viewBoundScale>", "</viewBoundScale>").trim();
        this.image = this.extract("<href>", "</href>").trim();
        this.north = this.extract("<north>", "</north>").trim();
        this.west = this.extract("<west>", "</west>").trim();
        this.south = this.extract("<south>", "</south>").trim();
        this.east = this.extract("<east>", "</east>").trim();
        String rotation = this.extract("<rotation>", "</rotation>").trim();
        String[] ext = new String[]{"jpg", "jpeg", "png", "gif", "tif", "tiff"};
        if (this.check_ext(new File(this.image), ext)) {
            this.get_image_data(new File(path + File.separator + this.image));
            foundImage = true;
        }
        if (!foundImage) {
            this.error_message("WorldFileTool - " + this.image + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
        } else if (foundImage && !rotation.isEmpty() && !rotation.equals("0")) {
            try {
                if (!(this.north.isEmpty() || this.south.isEmpty() || this.west.isEmpty() || this.east.isEmpty())) {
                    File imagefile = new File(path + File.separator + this.image);
                    File imagefile_ori = new File(this.rename(path + File.separator + this.image, "." + this.ext, "_ori." + this.ext));
                    imagefile.renameTo(imagefile_ori);
                    ImageIO.write((RenderedImage)ImageIO.read(imagefile_ori), this.ext, imagefile);
                    this.setCursor(wait);
                    ImageIO.write((RenderedImage)RotateImage.rotate_image(new File(path + File.separator + this.image), Double.valueOf(rotation)), this.ext, new File(path + File.separator + this.image));
                    this.setCursor(arrow);
                    this.calc_new_values(path);
                } else {
                    this.error_message("Verify your coordinates", "Could not read coordinates from kml therefore no rotation has been made");
                }
            }
            catch (IOException e) {
                this.error_message("WorldFileTool - " + this.image + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
                return;
            }
        }
        this.save_data();
    }

    public void read_image(String path, File file) {
        this.clear();
        this.get_image_data(file);
        if (this.check_ext(file, new String[]{"jpg", "jpeg"})) {
            this.read_worldfile(this.rename(file.toString(), "jpe?g", "jgw"));
        } else if (this.check_ext(file, new String[]{"png"})) {
            this.read_worldfile(this.rename(file.toString(), "png", "pgw"));
        } else if (this.check_ext(file, new String[]{"gif"})) {
            this.read_worldfile(this.rename(file.toString(), "gif", "gfw"));
        } else if (this.check_ext(file, new String[]{"tif", "tiff"})) {
            this.read_worldfile(this.rename(file.toString(), "tiff?", "tfw"));
        }
        if (this.rot_x != 0.0 || this.rot_y != 0.0) {
            try {
                File imagefile = new File(this.image);
                File imagefile_ori = new File(this.rename(this.image, "." + this.ext, "_ori." + this.ext));
                imagefile.renameTo(imagefile_ori);
                ImageIO.write((RenderedImage)ImageIO.read(imagefile_ori), this.ext, imagefile);
                this.setCursor(wait);
                ImageIO.write((RenderedImage)RotateImage.rotate_vectors(file, this.rot_x, this.rot_y), this.ext, new File(this.image));
                this.setCursor(arrow);
                this.calc_new_values(path);
            }
            catch (IOException e) {
                this.error_message("WorldFileTool - " + this.image + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
                return;
            }
        }
        this.save_data();
    }

    private void calc_new_values(String path) {
        double north = Double.valueOf(this.north);
        double south = Double.valueOf(this.south);
        double west = Double.valueOf(this.west);
        double east = Double.valueOf(this.east);
        double image_height = this.image_height;
        double image_width = this.image_width;
        double diff_vert = Math.abs(north - south);
        double diff_horiz = Math.abs(west - east);
        double yFactor = diff_vert / image_height;
        double xFactor = diff_horiz / image_width;
        this.get_image_data(new File(path + File.separator + this.image));
        double diff_height = Math.abs(image_height - this.image_height);
        double diff_width = Math.abs(image_width - this.image_width);
        if (north > south) {
            this.north = String.valueOf(north + diff_height * yFactor / 2.0);
            this.south = String.valueOf(south - diff_height * yFactor / 2.0);
        } else if (south > north) {
            this.north = String.valueOf(north - diff_height * yFactor / 2.0);
            this.south = String.valueOf(south + diff_height * yFactor / 2.0);
        }
        if (west > east) {
            this.west = String.valueOf(west + diff_width * xFactor / 2.0);
            this.east = String.valueOf(east - diff_width * xFactor / 2.0);
        } else if (east > west) {
            this.west = String.valueOf(west - diff_width * xFactor / 2.0);
            this.east = String.valueOf(east + diff_width * xFactor / 2.0);
        }
    }

    String rename(String file, String regex, String repl) {
        return Pattern.compile(regex, 2).matcher(file).replaceAll(repl);
    }

    boolean check_ext(File file, String[] ext) {
        boolean found = false;
        for (int i = 0; i < ext.length; ++i) {
            if (!file.getName().toLowerCase().endsWith(ext[i])) continue;
            if (ext[i].equalsIgnoreCase("jpg") || ext[i].equalsIgnoreCase("jpeg")) {
                this.wf_ext = "jgw";
            } else if (ext[i].equalsIgnoreCase("png")) {
                this.wf_ext = "pgw";
            } else if (ext[i].equalsIgnoreCase("gif")) {
                this.wf_ext = "gfw";
            } else if (ext[i].equalsIgnoreCase("tif") || ext[i].equalsIgnoreCase("tiff")) {
                this.wf_ext = "tfw";
            }
            found = true;
            this.ext = ext[i];
            break;
        }
        return found;
    }

    private void read_worldfile(String file) {
        double pix_x = 0.0;
        double pix_y = 0.0;
        double x_coord = 0.0;
        double y_coord = 0.0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            pix_x = Double.valueOf(br.readLine().trim());
            this.rot_y = Double.valueOf(br.readLine().trim());
            this.rot_x = Double.valueOf(br.readLine().trim());
            pix_y = Double.valueOf(br.readLine().trim());
            x_coord = Double.valueOf(br.readLine().trim());
            y_coord = Double.valueOf(br.readLine().trim());
            br.close();
        }
        catch (FileNotFoundException e) {
            this.error_message("WorldFileTool - File not found", e.getMessage());
            return;
        }
        catch (IOException e) {
            this.error_message("WorldFileTool - Could not write file", e.getMessage());
            return;
        }
        if (!(-180.0 < x_coord && x_coord < 180.0 && -90.0 < y_coord && y_coord < 90.0)) {
            this.error_message("WorldFileTool - Wrong coordinate system", "Convert your coordinates to the geographic coordinate system and retry");
        } else {
            this.north = String.valueOf(y_coord);
            this.west = String.valueOf(x_coord);
            this.east = String.valueOf(x_coord + this.image_width * pix_x);
            this.south = String.valueOf(y_coord + this.image_height * pix_y);
        }
    }

    private String extract(String start, String end) {
        String str = "";
        if (this.input.contains(start)) {
            String[] split = this.input.split(start);
            split = split[1].split(end);
            str = split[0];
        }
        return str;
    }

    private void get_image_data(File file) {
        this.image = file.getName().toString();
        try {
            BufferedImage bi = ImageIO.read(file);
            this.image_height = bi.getHeight();
            this.image_width = bi.getWidth();
        }
        catch (IOException e) {
            System.out.println("get_image_data " + e);
        }
    }

    public void write_kml(File file) {
        if (this.color.isEmpty()) {
            this.color = "cfffffff";
        }
        if (this.view.isEmpty()) {
            this.view = "0.75";
        }
        this.input = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\">\n<GroundOverlay>\n    <name>" + this.name + "</name>" + "\n" + "    <color>" + this.color + "</color>" + "\n" + "    <Icon>" + "\n" + "        <href>" + this.image + "</href>" + "\n" + "        <viewBoundScale>" + this.view + "</viewBoundScale>" + "\n" + "    </Icon>" + "\n" + "    <LatLonBox>" + "\n" + "        <north>" + this.north + "</north>" + "\n" + "        <west>" + this.west + "</west>" + "\n" + "        <south>" + this.south + "</south>" + "\n" + "        <east>" + this.east + "</east>" + "\n" + "    </LatLonBox>" + "\n" + "    <Metadata>" + "\n" + "        <floor>" + this.floor + "</floor>" + "\n" + "        <background>" + this.maptype + "</background>" + "\n" + "        <priority>" + this.priority + "</priority>" + "\n" + "    </Metadata>" + "\n" + "</GroundOverlay>" + "\n" + "</kml>" + "\n";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.input);
            bw.close();
        }
        catch (IOException e) {
            this.error_message("WorldFileTool - File not saved", e.getMessage());
        }
    }

    public void write_wf(File file) {
        double y_coord = Double.valueOf(this.north);
        double x_coord = Double.valueOf(this.west);
        double pix_x = (Double.valueOf(this.east) - x_coord) / this.image_width;
        double pix_y = (Double.valueOf(this.south) - y_coord) / this.image_height;
        this.input = pix_x + "\n" + 0 + "\n" + 0 + "\n" + pix_y + "\n" + x_coord + "\n" + y_coord + "\n";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.input);
            bw.close();
        }
        catch (IOException e) {
            this.error_message("WorldFileTool - File not saved", e.getMessage());
            return;
        }
        this.error_message("WorldFileTool - File saved", "Successfully exported to " + file);
    }

    private void save_data() {
        this.values = new String[]{this.name, this.image, this.north, this.west, this.south, this.east, this.floor, this.maptype, this.priority};
    }

    private void clear() {
        this.name = "(unnamed)";
        this.image = "";
        this.north = "";
        this.west = "";
        this.south = "";
        this.east = "";
    }

    private void error_message(String text, String message) {
        guiswing.error_message(text, message);
    }

    private void setCursor(String cursor) {
        if (cursor == wait) {
            guiswing.setCursor(3);
        } else if (cursor == arrow) {
            guiswing.setCursor(0);
        }
    }
}

