/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.worldfiletool;

import ch.hsr.worldfiletool.WorldFileTool;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.junit.Assert;
import org.junit.Test;

public class WorldFileToolTest {
    WorldFileTool wft;

    @Test
    public void testMain() {
        WorldFileTool.main(new String[0]);
        Assert.assertNotNull((Object)WorldFileTool.guiswing);
    }

    @Test
    public void testRead_kml() {
        int[] angles;
        for (int angle : angles = new int[]{45, 135, 225, 315}) {
            File testfile = new File("testkml.kml");
            this.create_test_image();
            String kml_test = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\">\n<GroundOverlay>\n    <name>test</name>\n    <Icon>\n        <href>testimage.png</href>\n        <viewBoundScale>0.75</viewBoundScale>\n    </Icon>\n    <LatLonBox>\n        <north>47.22384390486059</north>\n        <west>8.815489285344636</west>\n        <south>47.22345122640866</south>\n        <east>8.816304349533887</east>\n        <rotation>" + angle + "</rotation>" + "\n" + "    </LatLonBox>" + "\n" + "    <Metadata>" + "\n" + "        <floor>0</floor>" + "\n" + "        <background>0</background>" + "\n" + "        <priority>0</priority>" + "\n" + "    </Metadata>" + "\n" + "</GroundOverlay>" + "\n" + "</kml>" + "\n";
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(testfile));
                bw.write(kml_test);
                bw.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            this.wft = new WorldFileTool();
            this.wft.read_kml(System.getProperty("user.dir"), testfile);
            Assert.assertEquals((String)"Name", (Object)this.wft.name, (Object)"test");
            Assert.assertEquals((String)"View", (Object)this.wft.view, (Object)"0.75");
            Assert.assertEquals((String)"Image", (Object)this.wft.image, (Object)"testimage.png");
            Assert.assertEquals((String)"North", (Object)this.wft.north, (Object)"47.22385666691027");
            Assert.assertEquals((String)"West", (Object)this.wft.west, (Object)"8.81502877407771");
            Assert.assertEquals((String)"South", (Object)this.wft.south, (Object)"47.22343846435898");
            Assert.assertEquals((String)"East", (Object)this.wft.east, (Object)"8.816764860800813");
            Assert.assertEquals((String)"Image Height", (Object)this.wft.image_height, (Object)213);
            Assert.assertEquals((String)"Image Width", (Object)this.wft.image_width, (Object)213);
            this.del_test_files();
        }
    }

    @Test
    public void testRead_image() {
        int[][] coord;
        for (int[] xy : coord = new int[][]{{-1, 0}, {0, 0}, {1, 0}}) {
            String image_test = "0.0057987615\n" + xy[0] + "\n" + xy[1] + "\n" + "-0.0057987615" + "\n" + "5.2211660445" + "\n" + "48.1645342726" + "\n";
            try {
                this.create_test_image();
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File("testimage.pgw")));
                bw.write(image_test);
                bw.close();
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
            this.wft = new WorldFileTool();
            this.wft.read_image(System.getProperty("user.dir"), new File("testimage.png"));
            Assert.assertEquals((String)"Image", (Object)this.wft.image, (Object)"testimage.png");
            Assert.assertEquals((String)"North", (Object)this.wft.north, (Object)"48.1645342726");
            Assert.assertEquals((String)"West", (Object)this.wft.west, (Object)"5.2211660445");
            Assert.assertEquals((String)"South", (Object)this.wft.south, (Object)"47.0047819726");
            Assert.assertEquals((String)"East", (Object)this.wft.east, (Object)"5.801042194500001");
            Assert.assertEquals((String)"Image Height", (Object)this.wft.image_height, (Object)200);
            Assert.assertEquals((String)"Image Width", (Object)this.wft.image_width, (Object)100);
            this.del_test_files();
        }
    }

    @Test
    public void testCheck_ext() {
        String[] ext = new String[]{"jpg", "jpeg", "png", "gif", "tif", "tiff"};
        this.wft = new WorldFileTool();
        Assert.assertFalse((boolean)this.wft.check_ext(new File("testfile"), ext));
        Assert.assertTrue((boolean)this.wft.check_ext(new File("testfile.jpg"), ext));
        Assert.assertTrue((boolean)this.wft.check_ext(new File("testfile.png"), ext));
        Assert.assertTrue((boolean)this.wft.check_ext(new File("testfile.gif"), ext));
        Assert.assertTrue((boolean)this.wft.check_ext(new File("testfile.tif"), ext));
        Assert.assertTrue((boolean)this.wft.check_ext(new File("testfile.tiff"), ext));
    }

    public void create_test_image() {
        File testimage = new File("testimage.png");
        BufferedImage bitest = new BufferedImage(100, 200, 1);
        try {
            ImageIO.write((RenderedImage)bitest, "png", testimage);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void del_test_files() {
        new File("testimage.png").delete();
        new File("testimage_ori.png").delete();
        new File("testimage.pgw").delete();
        new File("testkml.kml").delete();
    }
}

