/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.worldfiletool.logic;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class Data {
    private String name = "";
    private String color = "";
    private String image = "";
    private String view = "";
    private String north = "";
    private String west = "";
    private String south = "";
    private String east = "";
    private String floor = "0";
    private String maptype = "0";
    private String priority = "0";
    private double rot_y = 0.0;
    private double rot_x = 0.0;
    private double image_height = 0.0;
    private double image_width = 0.0;
    private String ext = "";
    private String wf_ext = "";
    private String[] values = new String[]{this.name, this.image, this.north, this.west, this.south, this.east, this.floor, this.maptype, this.priority};

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getNorth() {
        return this.north;
    }

    public void setNorth(String north) {
        this.north = north;
    }

    public String getWest() {
        return this.west;
    }

    public void setWest(String west) {
        this.west = west;
    }

    public String getSouth() {
        return this.south;
    }

    public void setSouth(String south) {
        this.south = south;
    }

    public String getEast() {
        return this.east;
    }

    public void setEast(String east) {
        this.east = east;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getMaptype() {
        return this.maptype;
    }

    public void setMaptype(String maptype) {
        this.maptype = maptype;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public double getRot_y() {
        return this.rot_y;
    }

    public void setRot_y(double rot_y) {
        this.rot_y = rot_y;
    }

    public double getRot_x() {
        return this.rot_x;
    }

    public void setRot_x(double rot_x) {
        this.rot_x = rot_x;
    }

    public double getImage_height() {
        return this.image_height;
    }

    public void setImage_height(double image_height) {
        this.image_height = image_height;
    }

    public double getImage_width() {
        return this.image_width;
    }

    public void setImage_width(double image_width) {
        this.image_width = image_width;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues() {
        this.values = new String[]{this.name, this.image, this.north, this.west, this.south, this.east, this.floor, this.maptype, this.priority};
    }

    public void setExtension(String ext) {
        this.ext = ext;
    }

    public String getExtension() {
        return this.ext;
    }

    public void setWorldFileExt(String wf_ext) {
        this.wf_ext = wf_ext;
    }

    public String getWorldFileExt() {
        return this.wf_ext;
    }

    void reset() {
        this.name = "(unnamed)";
        this.image = "";
        this.north = "";
        this.west = "";
        this.south = "";
        this.east = "";
    }

    void calc_new_values(String path) {
        double north = Double.valueOf(this.north);
        double south = Double.valueOf(this.south);
        double west = Double.valueOf(this.west);
        double east = Double.valueOf(this.east);
        double image_height = this.image_height;
        double image_width = this.image_width;
        double delta_y = Math.abs(north - south);
        double delta_x = Math.abs(west - east);
        double yScale = delta_y / image_height;
        double xScale = delta_x / image_width;
        this.get_image_data(new File(path + File.separator + this.image));
        double delta_h = Math.abs(image_height - this.image_height);
        double delta_w = Math.abs(image_width - this.image_width);
        if (north > south) {
            this.north = String.valueOf(north + delta_h * yScale / 2.0);
            this.south = String.valueOf(south - delta_h * yScale / 2.0);
        } else if (south > north) {
            this.north = String.valueOf(north - delta_h * yScale / 2.0);
            this.south = String.valueOf(south + delta_h * yScale / 2.0);
        }
        if (west > east) {
            this.west = String.valueOf(west + delta_w * xScale / 2.0);
            this.east = String.valueOf(east - delta_w * xScale / 2.0);
        } else if (east > west) {
            this.west = String.valueOf(west - delta_w * xScale / 2.0);
            this.east = String.valueOf(east + delta_w * xScale / 2.0);
        }
    }

    public boolean check_ext(File file, String[] ext) {
        boolean found = false;
        for (int i = 0; i < ext.length; ++i) {
            if (!file.getName().toLowerCase().endsWith(ext[i])) continue;
            if (ext[i].equalsIgnoreCase("jpg") || ext[i].equalsIgnoreCase("jpeg")) {
                this.wf_ext = "jgw";
            } else if (ext[i].equalsIgnoreCase("png")) {
                this.wf_ext = "pgw";
            } else if (ext[i].equalsIgnoreCase("gif")) {
                this.wf_ext = "gfw";
            } else if (ext[i].equalsIgnoreCase("tif") || ext[i].equalsIgnoreCase("tiff")) {
                this.wf_ext = "tfw";
            }
            found = true;
            this.ext = ext[i];
            break;
        }
        return found;
    }

    void get_image_data(File file) {
        this.setImage(file.getName().toString());
        try {
            BufferedImage bi = ImageIO.read(file);
            this.image_height = bi.getHeight();
            this.image_width = bi.getWidth();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public String rename(String file, String regex, String repl) {
        return Pattern.compile(regex, 2).matcher(file).replaceAll(repl);
    }
}

