/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.worldfiletool.logic;

import ch.hsr.ifs.worldfiletool.logic.Data;
import ch.hsr.ifs.worldfiletool.ui.WorldFileTool_GUI;
import ch.hsr.ifs.worldfiletool.util.RotateImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;

public class KML {
    private WorldFileTool_GUI guiswing;
    private Data data;
    private String input;

    public KML(WorldFileTool_GUI guiswing, Data data, String input) {
        this.guiswing = guiswing;
        this.data = data;
        this.input = input;
    }

    public void parse_kml(String path, File file) {
        this.data.reset();
        boolean foundImage = false;
        StringBuffer temp = new StringBuffer();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                temp.append(line + "\n");
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            this.guiswing.messagebox("File Not Found", e.getMessage());
        }
        catch (IOException e) {
            System.out.println("read kml " + e);
        }
        this.input = temp.toString();
        this.data.setName(this.extract("<name>", "</name>").trim());
        this.data.setColor(this.extract("<color>", "</color>").trim());
        this.data.setView(this.extract("<viewBoundScale>", "</viewBoundScale>").trim());
        this.data.setImage(this.extract("<href>", "</href>").trim());
        this.data.setNorth(this.extract("<north>", "</north>").trim());
        this.data.setWest(this.extract("<west>", "</west>").trim());
        this.data.setSouth(this.extract("<south>", "</south>").trim());
        this.data.setEast(this.extract("<east>", "</east>").trim());
        String rotation = this.extract("<rotation>", "</rotation>").trim();
        String[] ext = new String[]{"jpg", "jpeg", "png", "gif", "tif", "tiff"};
        if (this.data.check_ext(new File(this.data.getImage()), ext)) {
            this.data.get_image_data(new File(path + File.separator + this.data.getImage()));
            foundImage = true;
        }
        if (!foundImage) {
            this.guiswing.messagebox("WorldFileTool - " + this.data.getImage() + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
        } else if (foundImage && !rotation.isEmpty() && !rotation.equals("0")) {
            String wait = "wait";
            String arrow = "arrow";
            try {
                if (!(this.data.getNorth().isEmpty() || this.data.getSouth().isEmpty() || this.data.getWest().isEmpty() || this.data.getEast().isEmpty())) {
                    File imagefile = new File(path + File.separator + this.data.getImage());
                    File imagefile_ori = new File(this.data.rename(path + File.separator + this.data.getImage(), "." + this.data.getExtension(), "_ori." + this.data.getExtension()));
                    imagefile.renameTo(imagefile_ori);
                    ImageIO.write((RenderedImage)ImageIO.read(imagefile_ori), this.data.getExtension(), imagefile);
                    this.guiswing.setCursor(wait);
                    ImageIO.write((RenderedImage)RotateImage.rotate_angle(new File(path + File.separator + this.data.getImage()), Double.valueOf(rotation)), this.data.getExtension(), new File(path + File.separator + this.data.getImage()));
                    this.guiswing.setCursor(arrow);
                    this.data.calc_new_values(path);
                } else {
                    this.guiswing.messagebox("Verify your coordinates", "Could not read coordinates from kml therefore no rotation has been made");
                }
            }
            catch (IOException e) {
                this.guiswing.messagebox("WorldFileTool - " + this.data.getImage() + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
                return;
            }
        }
        this.data.setValues();
    }

    private String extract(String start, String end) {
        String str = "";
        if (this.input.contains(start)) {
            String[] split = this.input.split(start);
            split = split[1].split(end);
            str = split[0];
        }
        return str;
    }

    public void write_kml(File file) {
        if (this.data.getColor().isEmpty()) {
            this.data.setColor("cfffffff");
        }
        if (this.data.getView().isEmpty()) {
            this.data.setView("0.75");
        }
        this.input = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.2\">\n<GroundOverlay>\n    <name>" + this.data.getName() + "</name>" + "\n" + "    <color>" + this.data.getColor() + "</color>" + "\n" + "    <Icon>" + "\n" + "        <href>" + this.data.getImage() + "</href>" + "\n" + "        <viewBoundScale>" + this.data.getView() + "</viewBoundScale>" + "\n" + "    </Icon>" + "\n" + "    <LatLonBox>" + "\n" + "        <north>" + this.data.getNorth() + "</north>" + "\n" + "        <west>" + this.data.getWest() + "</west>" + "\n" + "        <south>" + this.data.getSouth() + "</south>" + "\n" + "        <east>" + this.data.getEast() + "</east>" + "\n" + "    </LatLonBox>" + "\n" + "    <Metadata>" + "\n" + "        <floor>" + this.data.getFloor() + "</floor>" + "\n" + "        <background>" + this.data.getMaptype() + "</background>" + "\n" + "        <priority>" + this.data.getPriority() + "</priority>" + "\n" + "    </Metadata>" + "\n" + "</GroundOverlay>" + "\n" + "</kml>" + "\n";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.input);
            bw.close();
        }
        catch (IOException e) {
            this.guiswing.messagebox("WorldFileTool - File not saved", e.getMessage());
        }
    }
}

