/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.worldfiletool.logic;

import ch.hsr.ifs.worldfiletool.logic.Data;
import ch.hsr.ifs.worldfiletool.ui.WorldFileTool_GUI;
import ch.hsr.ifs.worldfiletool.util.RotateImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;

public class WorldFile {
    private WorldFileTool_GUI gui;
    private Data data;
    private String input;

    public WorldFile(WorldFileTool_GUI guiswing, Data data, String input) {
        this.gui = guiswing;
        this.data = data;
        this.input = input;
    }

    public void parse_worldfile(String path, File file) {
        this.data.reset();
        this.data.get_image_data(file);
        if (this.data.check_ext(file, new String[]{"jpg", "jpeg"})) {
            this.parse(this.data.rename(file.toString(), "jpe?g", "jgw"));
        } else if (this.data.check_ext(file, new String[]{"png"})) {
            this.parse(this.data.rename(file.toString(), "png", "pgw"));
        } else if (this.data.check_ext(file, new String[]{"gif"})) {
            this.parse(this.data.rename(file.toString(), "gif", "gfw"));
        } else if (this.data.check_ext(file, new String[]{"tif", "tiff"})) {
            this.parse(this.data.rename(file.toString(), "tiff?", "tfw"));
        }
        if (this.data.getRot_x() != 0.0 || this.data.getRot_y() != 0.0) {
            String wait = "wait";
            String arrow = "arrow";
            try {
                File imagefile = new File(this.data.getImage());
                File imagefile_ori = new File(this.data.rename(this.data.getImage(), "." + this.data.getExtension(), "_ori." + this.data.getExtension()));
                imagefile.renameTo(imagefile_ori);
                ImageIO.write((RenderedImage)ImageIO.read(imagefile_ori), this.data.getExtension(), imagefile);
                this.gui.setCursor(wait);
                ImageIO.write((RenderedImage)RotateImage.rotate_vectors(file, this.data.getRot_x(), this.data.getRot_y()), this.data.getExtension(), new File(this.data.getImage()));
                this.gui.setCursor(arrow);
                this.data.calc_new_values(path);
            }
            catch (IOException e) {
                this.gui.messagebox("WorldFileTool - " + this.data.getImage() + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
                return;
            }
        }
        this.data.setValues();
    }

    private void parse(String file) {
        double lon_per_pixel = 0.0;
        double lat_per_pixel = 0.0;
        double upperleft_lon = 0.0;
        double upperleft_lat = 0.0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            lon_per_pixel = Double.valueOf(br.readLine().trim());
            this.data.setRot_y(Double.valueOf(br.readLine().trim()));
            this.data.setRot_x(Double.valueOf(br.readLine().trim()));
            lat_per_pixel = Double.valueOf(br.readLine().trim());
            upperleft_lon = Double.valueOf(br.readLine().trim());
            upperleft_lat = Double.valueOf(br.readLine().trim());
            br.close();
        }
        catch (FileNotFoundException e) {
            this.gui.messagebox("WorldFileTool - File not found", e.getMessage());
            return;
        }
        catch (IOException e) {
            this.gui.messagebox("WorldFileTool - Could not read file", e.getMessage());
            return;
        }
        if (!(-180.0 < upperleft_lon && upperleft_lon < 180.0 && -90.0 < upperleft_lat && upperleft_lat < 90.0)) {
            this.gui.messagebox("WorldFileTool - Wrong coordinate system", "Convert your coordinates to the geographic coordinate system and retry");
        } else {
            this.data.setNorth(String.valueOf(upperleft_lat));
            this.data.setWest(String.valueOf(upperleft_lon));
            this.data.setEast(String.valueOf(upperleft_lon + this.data.getImage_width() * lon_per_pixel));
            this.data.setSouth(String.valueOf(upperleft_lat + this.data.getImage_height() * lat_per_pixel));
        }
    }

    public void write_wf(File file) {
        double upperleft_lat = Double.valueOf(this.data.getNorth());
        double upperleft_lon = Double.valueOf(this.data.getWest());
        double lon_per_pixel = (Double.valueOf(this.data.getEast()) - upperleft_lon) / this.data.getImage_width();
        double lat_per_pixel = (Double.valueOf(this.data.getSouth()) - upperleft_lat) / this.data.getImage_height();
        this.input = lon_per_pixel + "\n" + 0 + "\n" + 0 + "\n" + lat_per_pixel + "\n" + upperleft_lon + "\n" + upperleft_lat + "\n";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.input);
            bw.close();
        }
        catch (IOException e) {
            this.gui.messagebox("WorldFileTool - File not saved", e.getMessage());
            return;
        }
        this.gui.messagebox("WorldFileTool - File saved", "Successfully exported to " + file);
    }
}

