/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.ifs.worldfiletool.ui;

import ch.hsr.ifs.worldfiletool.ui.About;
import ch.hsr.ifs.worldfiletool.ui.WorldFileTool_GUI;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Components {
    JButton create_button(String text, Rectangle rect, int event) {
        JButton button = new JButton();
        button.setText(text);
        button.setBounds(rect);
        button.setToolTipText(text);
        button.setFont(new Font("Arial", 0, 11));
        button.setMnemonic(event);
        return button;
    }

    JTextField create_textfield(String lbl, Rectangle rect, JPanel panel) {
        JLabel label = new JLabel();
        label.setText(lbl);
        label.setBounds(rect);
        label.setFont(new Font("Arial", 0, 11));
        panel.add(label);
        JTextField text = new JTextField();
        text.setBounds(rect.x, rect.y + 15, rect.width, rect.height + 5);
        JPopupMenu popupMenu = this.popupMenu(text);
        text.setComponentPopupMenu(popupMenu);
        return text;
    }

    void check_image(File file, JLabel icon) {
        String tooltip;
        String pic;
        if (file.exists()) {
            pic = "/ch/hsr/ifs/worldfiletool/ui/images/tick.png";
            tooltip = "File found";
        } else {
            pic = "/ch/hsr/ifs/worldfiletool/ui/images/cross.png";
            tooltip = "File does not exists";
        }
        icon.setIcon(new ImageIcon(this.getClass().getResource(pic)));
        icon.setToolTipText(tooltip);
    }

    void save(Properties properties) {
        try {
            properties.store(new FileWriter("WorldFileTool.cfg"), "WorldFileTool Config");
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    void load(Properties properties) {
        try {
            properties.load(new FileReader("WorldFileTool.cfg"));
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    JMenuBar menu_bar(final WorldFileTool_GUI gui) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setFont(new Font("Arial", 0, 11));
        String[] text = new String[]{"Import File...", "Export as KML...", "Export as World File"};
        int[] event = new int[]{73, 75, 87};
        String lbl_import = "import";
        String lbl_kml = "kml";
        String lbl_wf = "wf";
        String[] action = new String[]{"import", "kml", "wf"};
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "import") {
                    gui.import_file();
                } else if (e.getActionCommand() == "kml") {
                    gui.export_kml();
                } else if (e.getActionCommand() == "wf") {
                    gui.export_worldfile();
                }
            }
        };
        for (int i = 0; i < text.length; ++i) {
            if (i == 1) {
                fileMenu.addSeparator();
            }
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(text[i]);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(event[i], 128));
            menuItem.setFont(new Font("Arial", 0, 11));
            menuItem.setActionCommand(action[i]);
            menuItem.addActionListener(menuListener);
            fileMenu.add(menuItem);
        }
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem();
        exitItem.setText("Exit");
        exitItem.setFont(new Font("Arial", 0, 11));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                gui.save_and_exit();
            }
        });
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setFont(new Font("Arial", 0, 11));
        JMenuItem aboutItem = new JMenuItem();
        aboutItem.setText("About");
        aboutItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        aboutItem.setFont(new Font("Arial", 0, 11));
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new About();
            }
        });
        helpMenu.add(aboutItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    JPopupMenu popupMenu(final JTextField textField) {
        JPopupMenu popupMenu = new JPopupMenu();
        String[] menuItems = new String[]{"Cut", "Copy", "Paste", "Clear"};
        ActionListener mouseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Cut")) {
                    textField.cut();
                } else if (event.getActionCommand().equals("Copy")) {
                    textField.copy();
                } else if (event.getActionCommand().equals("Paste")) {
                    textField.paste();
                } else if (event.getActionCommand().equals("Clear")) {
                    textField.setText("");
                }
            }
        };
        for (int i = 0; i < menuItems.length; ++i) {
            JMenuItem menuItem = new JMenuItem(menuItems[i]);
            if (i == 3) {
                popupMenu.addSeparator();
            }
            menuItem.addActionListener(mouseListener);
            popupMenu.add(menuItem);
        }
        return popupMenu;
    }
}

