/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.worldfiletool.logic;

import ch.hsr.worldfiletool.logic.Data;
import ch.hsr.worldfiletool.ui.GUI_Swing;
import ch.hsr.worldfiletool.util.RotateImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.imageio.ImageIO;

public class WorldFile {
    private GUI_Swing guiswing;
    private Data data;
    private String input;

    public WorldFile(GUI_Swing guiswing, Data data, String input) {
        this.guiswing = guiswing;
        this.data = data;
        this.input = input;
    }

    public void parse_worldfile(String path, File file) {
        this.data.reset();
        this.data.get_image_data(file);
        if (this.data.check_ext(file, new String[]{"jpg", "jpeg"})) {
            this.parse(this.data.rename(file.toString(), "jpe?g", "jgw"));
        } else if (this.data.check_ext(file, new String[]{"png"})) {
            this.parse(this.data.rename(file.toString(), "png", "pgw"));
        } else if (this.data.check_ext(file, new String[]{"gif"})) {
            this.parse(this.data.rename(file.toString(), "gif", "gfw"));
        } else if (this.data.check_ext(file, new String[]{"tif", "tiff"})) {
            this.parse(this.data.rename(file.toString(), "tiff?", "tfw"));
        }
        if (this.data.getRot_x() != 0.0 || this.data.getRot_y() != 0.0) {
            String wait = "wait";
            String arrow = "arrow";
            try {
                File imagefile = new File(this.data.getImage());
                File imagefile_ori = new File(this.data.rename(this.data.getImage(), "." + this.data.getExtension(), "_ori." + this.data.getExtension()));
                imagefile.renameTo(imagefile_ori);
                ImageIO.write((RenderedImage)ImageIO.read(imagefile_ori), this.data.getExtension(), imagefile);
                this.guiswing.setCursor(wait);
                ImageIO.write((RenderedImage)RotateImage.rotate_vectors(file, this.data.getRot_x(), this.data.getRot_y()), this.data.getExtension(), new File(this.data.getImage()));
                this.guiswing.setCursor(arrow);
                this.data.calc_new_values(path);
            }
            catch (IOException e) {
                this.guiswing.messagebox("WorldFileTool - " + this.data.getImage() + " not found", "The image should be either in JPG, PNG, GIF or TIFF and in a relative path.");
                return;
            }
        }
        this.data.setValues();
    }

    private void parse(String file) {
        double pix_x = 0.0;
        double pix_y = 0.0;
        double x_coord = 0.0;
        double y_coord = 0.0;
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            pix_x = Double.valueOf(br.readLine().trim());
            this.data.setRot_y(Double.valueOf(br.readLine().trim()));
            this.data.setRot_x(Double.valueOf(br.readLine().trim()));
            pix_y = Double.valueOf(br.readLine().trim());
            x_coord = Double.valueOf(br.readLine().trim());
            y_coord = Double.valueOf(br.readLine().trim());
            br.close();
        }
        catch (FileNotFoundException e) {
            this.guiswing.messagebox("WorldFileTool - File not found", e.getMessage());
            return;
        }
        catch (IOException e) {
            this.guiswing.messagebox("WorldFileTool - Could not read file", e.getMessage());
            return;
        }
        if (!(-180.0 < x_coord && x_coord < 180.0 && -90.0 < y_coord && y_coord < 90.0)) {
            this.guiswing.messagebox("WorldFileTool - Wrong coordinate system", "Convert your coordinates to the geographic coordinate system and retry");
        } else {
            this.data.setNorth(String.valueOf(y_coord));
            this.data.setWest(String.valueOf(x_coord));
            this.data.setEast(String.valueOf(x_coord + this.data.getImage_width() * pix_x));
            this.data.setSouth(String.valueOf(y_coord + this.data.getImage_height() * pix_y));
        }
    }

    public void write_wf(File file) {
        double y_coord = Double.valueOf(this.data.getNorth());
        double x_coord = Double.valueOf(this.data.getWest());
        double pix_x = (Double.valueOf(this.data.getEast()) - x_coord) / this.data.getImage_width();
        double pix_y = (Double.valueOf(this.data.getSouth()) - y_coord) / this.data.getImage_height();
        this.input = pix_x + "\n" + 0 + "\n" + 0 + "\n" + pix_y + "\n" + x_coord + "\n" + y_coord + "\n";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(this.input);
            bw.close();
        }
        catch (IOException e) {
            this.guiswing.messagebox("WorldFileTool - File not saved", e.getMessage());
            return;
        }
        this.guiswing.messagebox("WorldFileTool - File saved", "Successfully exported to " + file);
    }
}

