/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.worldfiletool.ui;

import ch.hsr.worldfiletool.logic.Data;
import ch.hsr.worldfiletool.logic.KML;
import ch.hsr.worldfiletool.logic.WorldFile;
import ch.hsr.worldfiletool.ui.About;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GUI_Swing
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel panel;
    private JTextField name;
    private JTextField image;
    private JTextField north;
    private JTextField west;
    private JTextField south;
    private JTextField east;
    private JTextField floor;
    private JComboBox maptype;
    private JTextField priority;
    private JLabel icon;
    private File path = new File(System.getProperty("user.dir"));
    private File file;
    private Properties properties = new Properties();
    private final String lastpath = "lastpath";
    private KML kml;
    private WorldFile wf;
    private Data data = new Data();

    public GUI_Swing() {
        String input = "";
        this.kml = new KML(this, this.data, input);
        this.wf = new WorldFile(this, this.data, input);
    }

    public void create_gui(String version) {
        this.load();
        this.setTitle("WorldFileTool " + version);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setSize(285, 430);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/ch/hsr/worldfiletool/ui/images/icon.jpg")).getImage());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - 250) / 2, (dim.height - 600) / 2);
        this.panel = new JPanel();
        this.panel.setLayout(null);
        JButton button_openkml = this.create_button("Import File...", new Rectangle(15, 310, 120, 25), 73);
        button_openkml.setMnemonic(73);
        button_openkml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI_Swing.this.import_file();
            }
        });
        JButton button_savekml = this.create_button("Export as KML...", new Rectangle(145, 310, 120, 25), 75);
        button_savekml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI_Swing.this.export_kml();
            }
        });
        JButton button_openwf = this.create_button("Export as World File", new Rectangle(145, 340, 120, 25), 87);
        button_openwf.setFont(new Font("Arial", 0, 9));
        button_openwf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI_Swing.this.export_worldfile();
            }
        });
        JButton button_exit = this.create_button("Exit", new Rectangle(15, 340, 120, 25), 69);
        button_exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI_Swing.this.save_and_exit();
            }
        });
        JMenuBar menuBar = this.menu_bar();
        this.setJMenuBar(menuBar);
        this.icon = new JLabel();
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/ch/hsr/worldfiletool/ui/images/cross.png")));
        this.icon.setBounds(245, 65, 20, 20);
        this.icon.setToolTipText("File does not exists");
        KeyListener numListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char k = e.getKeyChar();
                if (k <= ',' || k >= ':') {
                    e.setKeyChar('\f');
                }
            }
        };
        KeyListener fileListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                GUI_Swing.this.check_image(new File(GUI_Swing.this.path + File.separator + GUI_Swing.this.image.getText()));
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.name = this.create_text("Name", new Rectangle(15, 5, 250, 15));
        this.image = this.create_text("Image", new Rectangle(15, 50, 225, 15));
        this.image.addKeyListener(fileListener);
        this.north = this.create_text("North*", new Rectangle(15, 100, 120, 15));
        this.north.addKeyListener(numListener);
        this.west = this.create_text("West*", new Rectangle(145, 100, 120, 15));
        this.west.addKeyListener(numListener);
        this.south = this.create_text("South*", new Rectangle(15, 140, 120, 15));
        this.south.addKeyListener(numListener);
        this.east = this.create_text("East*", new Rectangle(145, 140, 120, 15));
        this.east.addKeyListener(numListener);
        this.floor = this.create_text("Floor", new Rectangle(15, 200, 120, 15));
        this.floor.setText("0");
        this.floor.addKeyListener(numListener);
        this.priority = this.create_text("Priority", new Rectangle(15, 240, 120, 15));
        this.priority.setText("0");
        this.priority.addKeyListener(numListener);
        JLabel req_worldfile = new JLabel();
        req_worldfile.setBounds(18, 270, 150, 30);
        req_worldfile.setText("*required for world file");
        req_worldfile.setFont(new Font("Arial", 0, 11));
        JLabel lbl_maptype = new JLabel();
        lbl_maptype.setText("Map Type");
        lbl_maptype.setBounds(145, 200, 120, 15);
        lbl_maptype.setFont(new Font("Arial", 0, 11));
        this.maptype = new JComboBox();
        String[] type = new String[]{"Buildings", "Landscape", "Others"};
        for (int i = 0; i < type.length; ++i) {
            this.maptype.addItem(type[i]);
        }
        this.maptype.setFont(new Font("Arial", 0, 11));
        this.maptype.setBounds(145, 215, 120, 19);
        this.maptype.setSelectedIndex(0);
        JComponent[] elements = new JComponent[]{button_openkml, button_savekml, button_openwf, button_exit, this.icon, this.name, this.image, this.north, this.west, this.south, this.east, this.floor, this.priority, req_worldfile, lbl_maptype, this.maptype};
        for (int i = 0; i < elements.length; ++i) {
            this.panel.add(elements[i]);
        }
        this.add(this.panel);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                GUI_Swing.this.save_and_exit();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.setVisible(true);
    }

    public void import_file() {
        int result;
        JFileChooser fc = new JFileChooser(){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), "The selected file already exists. Do you want to overwrite it?", "The file already exists", 1, 3);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fc.setDialogTitle("WorldFileTool - Import...");
        fc.setFileFilter(new FileNameExtensionFilter("KML (*.kml) / Image (*.jpg; *.png; *.gif; *.tiff)", "kml", "jpg", "jpeg", "png", "gif", "tif", "tiff"));
        fc.setFileSelectionMode(2);
        if (this.properties.containsKey("lastpath")) {
            fc.setCurrentDirectory(new File(this.properties.getProperty("lastpath")));
        }
        if ((result = fc.showOpenDialog(null)) == 0) {
            this.file = fc.getSelectedFile();
            this.path = fc.getCurrentDirectory();
            this.properties.setProperty("lastpath", this.path.toString());
            if (this.file.getName().toLowerCase().endsWith("kml")) {
                this.clear();
                this.kml.parse_kml(this.path.toString(), this.file);
                this.update_textfields();
                this.check_image(new File(this.path + File.separator + this.image.getText()));
            } else if (this.data.check_ext(this.file, new String[]{"jpg", "jpeg", "png", "gif", "tif", "tiff"})) {
                this.clear();
                this.wf.parse_worldfile(this.path.toString(), this.file);
                this.update_textfields();
                this.check_image(new File(this.path + File.separator + this.image.getText()));
            }
        }
    }

    public void export_kml() {
        int result;
        if (!this.floor.getText().contains(".") && !this.floor.getText().isEmpty()) {
            if (Integer.valueOf(this.floor.getText()) < -99 || 99 < Integer.valueOf(this.floor.getText())) {
                this.messagebox("WorldFileTool - Not valid Floor", "Choose an integer between -99 and 99 (default: 0)");
                return;
            }
        } else {
            this.messagebox("WorldFileTool - Not valid Floor", "Choose an integer between -99 and 99 (default: 0)");
            return;
        }
        if (!(this.priority.getText().contains(".") || this.priority.getText().isEmpty() || this.priority.getText().contains("-"))) {
            if (100 < Integer.valueOf(this.priority.getText())) {
                this.messagebox("WorldFileTool - Not valid Priority", "Choose an integer between 1 and 100 or 0 for unknown");
                return;
            }
        } else {
            this.messagebox("WorldFileTool - Not valid Priority", "Choose an integer between 1 and 100 or 0 for unknown");
            return;
        }
        if (this.name.getText().isEmpty() || this.image.getText().isEmpty() || this.north.getText().isEmpty() || this.west.getText().isEmpty() || this.south.getText().isEmpty() || this.east.getText().isEmpty()) {
            this.messagebox("WorldFileTool - Empty Textboxes", "Not all Textboxes are filled");
            return;
        }
        if (this.floor.getText().isEmpty()) {
            this.floor.setText("0");
        }
        if (this.priority.getText().isEmpty()) {
            this.priority.setText("0");
        }
        this.setContent();
        JFileChooser fc = new JFileChooser(){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), "The selected file already exists. Do you want to overwrite it?", "The file already exists", 1, 3);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith("kml") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Google Earth KML-File (*.kml)";
            }
        });
        fc.setFileSelectionMode(2);
        fc.setDialogTitle("Save as KML");
        if (this.properties.containsKey("lastpath")) {
            fc.setCurrentDirectory(new File(this.properties.getProperty("lastpath")));
        }
        String[] ext = new String[]{"jpg", "jpeg", "png", "gif", "tif", "tiff"};
        if (this.file != null) {
            for (int i = 0; i < ext.length; ++i) {
                if (this.file.getName().toLowerCase().endsWith(ext[i])) {
                    fc.setSelectedFile(new File(Pattern.compile("." + ext[i], 2).matcher(this.file.toString()).replaceAll(".kml")));
                    break;
                }
                fc.setSelectedFile(new File(this.file.toString()));
            }
        }
        if ((result = fc.showSaveDialog(null)) == 0) {
            this.file = fc.getSelectedFile();
            if (this.file.toString().endsWith(".kml")) {
                this.kml.write_kml(this.file);
            } else {
                this.kml.write_kml(new File(this.file.getName() + ".kml"));
            }
        }
    }

    public void export_worldfile() {
        if (this.north.getText().isEmpty() || this.west.getText().isEmpty() || this.south.getText().isEmpty() || this.east.getText().isEmpty()) {
            this.messagebox("WorldFileTool - Empty Textboxes", "Not all required Textboxes for a WorldFile are filled");
            return;
        }
        this.setContent();
        String file = this.data.rename(this.data.getImage(), "." + this.data.getExtension(), "." + this.data.getWorldFileExt());
        if (this.path != null) {
            if (!new File(file).exists()) {
                this.wf.write_wf(new File(this.path + File.separator + file));
            } else if (this.data.getExtension().isEmpty() && this.data.getWorldFileExt().isEmpty()) {
                this.wf.write_wf(new File(this.path + File.separator + this.image.getText()));
            } else {
                int result = JOptionPane.showConfirmDialog(null, "The file already exists. Do you want to overwrite it?", "WorldFileTool - File already exists", 0);
                switch (result) {
                    case 0: {
                        this.wf.write_wf(new File(this.path + File.separator + file));
                    }
                    case 1: {
                        return;
                    }
                }
            }
        } else {
            this.messagebox("WorldFileTool - File not saved", "Could not save " + file);
        }
    }

    private JButton create_button(String text, Rectangle rect, int event) {
        JButton button = new JButton();
        button.setText(text);
        button.setBounds(rect);
        button.setToolTipText(text);
        button.setFont(new Font("Arial", 0, 11));
        button.setMnemonic(event);
        return button;
    }

    private JTextField create_text(String lbl, Rectangle rect) {
        JLabel label = new JLabel();
        label.setText(lbl);
        label.setBounds(rect);
        label.setFont(new Font("Arial", 0, 11));
        this.panel.add(label);
        JTextField text = new JTextField();
        text.setBounds(rect.x, rect.y + 15, rect.width, rect.height + 5);
        JPopupMenu popupMenu = this.popupMenu(text);
        text.setComponentPopupMenu(popupMenu);
        return text;
    }

    private void clear() {
        this.name.setText("(unnamed)");
        this.image.setText("");
        this.north.setText("");
        this.west.setText("");
        this.south.setText("");
        this.east.setText("");
    }

    private void update_textfields() {
        this.name.setText(this.data.getName());
        this.image.setText(this.data.getImage());
        this.north.setText(this.data.getNorth());
        this.west.setText(this.data.getWest());
        this.south.setText(this.data.getSouth());
        this.east.setText(this.data.getEast());
    }

    private void setContent() {
        this.data.setName(this.name.getText().trim());
        this.data.setImage(this.image.getText().trim());
        this.data.setNorth(this.north.getText().trim());
        this.data.setWest(this.west.getText().trim());
        this.data.setSouth(this.south.getText().trim());
        this.data.setEast(this.east.getText().trim());
        this.data.setFloor(this.floor.getText().trim());
        this.data.setMaptype(this.maptype.getSelectedItem().toString());
        if (this.data.getMaptype().equalsIgnoreCase("Buildings")) {
            this.data.setMaptype("0");
        } else if (this.data.getMaptype().equalsIgnoreCase("Landscape")) {
            this.data.setMaptype("1");
        } else if (this.data.getMaptype().equalsIgnoreCase("Others")) {
            this.data.setMaptype("2");
        }
        this.data.setPriority(this.priority.getText().trim());
    }

    private void check_image(File file) {
        String tooltip;
        String pic;
        if (file.exists()) {
            pic = "/ch/hsr/worldfiletool/ui/images/tick.png";
            tooltip = "File found";
        } else {
            pic = "/ch/hsr/worldfiletool/ui/images/cross.png";
            tooltip = "File does not exists";
        }
        this.icon.setIcon(new ImageIcon(this.getClass().getResource(pic)));
        this.icon.setToolTipText(tooltip);
    }

    public void messagebox(String text, String message) {
        JOptionPane.showMessageDialog(null, message, text, 1);
    }

    private void save() {
        try {
            this.properties.store(new FileWriter("WorldFileTool.cfg"), "WorldFileTool Config");
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void load() {
        try {
            this.properties.load(new FileReader("WorldFileTool.cfg"));
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    private void save_and_exit() {
        this.save();
        String type = "";
        if (this.maptype.getSelectedItem().equals("Buildings")) {
            type = "0";
        } else if (this.maptype.getSelectedItem().equals("Landscape")) {
            type = "1";
        } else if (this.maptype.getSelectedItem().equals("Others")) {
            type = "2";
        }
        String[] values = new String[]{this.name.getText(), this.image.getText(), this.north.getText(), this.west.getText(), this.south.getText(), this.east.getText(), this.floor.getText(), type, this.priority.getText()};
        int result = 0;
        if (!Arrays.asList(this.data.getValues()).containsAll(Arrays.asList(values))) {
            result = JOptionPane.showConfirmDialog(null, "Data has changed. Do you really want to quit?", "WorldFileTool - Quit?", 0);
        }
        switch (result) {
            case 0: {
                System.exit(0);
            }
            case 1: {
                return;
            }
        }
    }

    public void setCursor(String cursor) {
        if (cursor == "wait") {
            this.setCursor(new Cursor(3));
        } else if (cursor == "arrow") {
            this.setCursor(new Cursor(0));
        }
    }

    private JMenuBar menu_bar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setFont(new Font("Arial", 0, 11));
        String[] text = new String[]{"Import File...", "Export as KML...", "Export as World File"};
        int[] event = new int[]{73, 75, 87};
        String lbl_import = "import";
        String lbl_kml = "kml";
        String lbl_wf = "wf";
        String[] action = new String[]{"import", "kml", "wf"};
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "import") {
                    GUI_Swing.this.import_file();
                } else if (e.getActionCommand() == "kml") {
                    GUI_Swing.this.export_kml();
                } else if (e.getActionCommand() == "wf") {
                    GUI_Swing.this.export_worldfile();
                }
            }
        };
        for (int i = 0; i < text.length; ++i) {
            if (i == 1) {
                fileMenu.addSeparator();
            }
            JMenuItem menuItem = new JMenuItem();
            menuItem.setText(text[i]);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(event[i], 128));
            menuItem.setFont(new Font("Arial", 0, 11));
            menuItem.setActionCommand(action[i]);
            menuItem.addActionListener(menuListener);
            fileMenu.add(menuItem);
        }
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem();
        exitItem.setText("Exit");
        exitItem.setFont(new Font("Arial", 0, 11));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI_Swing.this.save_and_exit();
            }
        });
        fileMenu.add(exitItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setFont(new Font("Arial", 0, 11));
        JMenuItem aboutItem = new JMenuItem();
        aboutItem.setText("About");
        aboutItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        aboutItem.setFont(new Font("Arial", 0, 11));
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new About();
            }
        });
        helpMenu.add(aboutItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JPopupMenu popupMenu(final JTextField textField) {
        JPopupMenu popupMenu = new JPopupMenu();
        String[] menuItems = new String[]{"Cut", "Copy", "Paste", "Clear"};
        ActionListener mouseListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getActionCommand().equals("Cut")) {
                    textField.cut();
                } else if (event.getActionCommand().equals("Copy")) {
                    textField.copy();
                } else if (event.getActionCommand().equals("Paste")) {
                    textField.paste();
                } else if (event.getActionCommand().equals("Clear")) {
                    textField.setText("");
                }
            }
        };
        for (int i = 0; i < menuItems.length; ++i) {
            JMenuItem menuItem = new JMenuItem(menuItems[i]);
            if (i == 3) {
                popupMenu.addSeparator();
            }
            menuItem.addActionListener(mouseListener);
            popupMenu.add(menuItem);
        }
        return popupMenu;
    }
}

