# -*- coding: utf-8 -*-
"""
geister.py
Zählt wie viele Male Shakespeare das Wort 'ghost', 'Ghost', 'GHOST' oder ähnlich
verwendet hat in seinem Leben.
"""
import time

# Einlesen von Shakepeare's gesammelten Werken:
f = open('pg100.txt')
shakespeare = f.read()

# Zuerst mal alles in Kleinbuchstaben umwandeln, damit wir alle Varianten von
# 'ghost' abfangen:
shakespeare = shakespeare.lower()

# Nun haben wir zwei Möglichkeiten:
# 1. Den Text in eine Liste Wörter auftrennen, und die Wörter zählen wo 'ghost'
#    vorkommt.
# 2. Die Funktion find() gibt uns ja den Index zurück wo das Wort gefunden 
#    wurde. find() hat auch ein optionales Argument 'start', wo man sagen kann
#    von welcher Stelle im String an gesucht werden soll. Durch intelligentes
#    Definieren einer Variablen können wir so die Geister auch zählen.
# Hier folgen beide Möglichkeiten... Damit wir wissen, welche Methode schneller
# ist haben wir noch die Zeit für beide Möglichkeiten gemessen. Das geht ganz
# einfach mit dem time-Modul. Die Funktion time im time-Modul gibt die Anzahl
# Sekunden (mit ein paar Dezimalstellen) die seit dem Anfang der Computer-Epoche
# vergangen sind (normalerweise der 1.1.1970 auf Linux-Systemen)

# Möglichkeit 1 mit Wörter auftrennen
start_zeit_1 = time.time()
woerter = shakespeare.split(' ')
anzahl_geister = 0
for wort in woerter:
    if wort.find('ghost') > -1:
        anzahl_geister += 1

end_zeit_1 = time.time()

# Möglichkeit 2 mit String durchlaufen
start_zeit_2 = time.time()
anzahl_geister_2 = 0
string_index = 0    # Das ist diese 'intelligente' Variable
while True:
    geist = shakespeare.find('ghost', string_index)
    if geist < 0:   # Falls keinen Geist mehr, brechen wir aus der Schlaufe aus
        break
    anzahl_geister_2 += 1
    string_index = geist + 1    # String Index vorwärts schieben

end_zeit_2 = time.time()


# Nun sind wir fertig, also Resultat ausgeben
print "Shakepeare brauchte %i Geister in seinem Leben" % anzahl_geister
print "Shakepeare brauchte wirklich %i Geister" % anzahl_geister_2

print "Die 1. Moeglichkeit Geister zu zaehlen (Woerter auftrennen) brauchte %f Sekunden" % (end_zeit_1 - start_zeit_1, )
print "Die 2. Moeglichkeit Geister zu zaehlen (String durchlaufen) brauchte %f Sekunden" % (end_zeit_2 - start_zeit_2, )
print "Moeglichkeit 2 ist um ein Faktor %f schneller!" % ((end_zeit_1 - start_zeit_1) / (end_zeit_2 - start_zeit_2), )

print '''"Die ich rief, die Geister,\nWerd' ich nun nicht los."\n(Nein, das ist nicht von Shakespeare!)'''

