# -*- coding: utf-8 -*-
"""
haeufigste_woerter.py
Findet das häufigste Wort in Shakespeare's gesammelten Werken.
Findet auch das häufigste Wort das länger ist als 5 Buchstaben.
"""

# Einlesen von Shakepeare's gesammelten Werken:
f = open('pg100.txt')
shakespeare = f.read()

# Alles in Kleinbuchstaben umwandeln, da dies ja dasselbe Wort bleibt...
shakespeare = shakespeare.lower()

# In Wörter auftrennen
woerter = shakespeare.split(' ')

# Einzelne Wörter zählen mit Hilfe eines Dictionnaires
word_count = {}
for wort in woerter:
    w = wort.strip()    # Leerzeichen um das Wort entfernen
    if len(w) > 0:
        word_count[w] = word_count.get(w, 0) + 1

# Nun haben wir alle Wörter gezählt und wir können nochmals durch den
# Dictionnaire gehen und schauen was das häufigste Wort ist.
haeufigstes_wort = ''
anzahl_vorkommen = 0
for wort in word_count:
    if word_count[wort] > anzahl_vorkommen:
        haeufigstes_wort = wort
        anzahl_vorkommen = word_count[wort]

print "Das haeufigste Wort ist '%s' mit %i Vorkommen." % (haeufigstes_wort, anzahl_vorkommen)

# Und nun noch alle Wörter mit mindestens 5 Buchstaben: sehr ähnlich!
haeufigstes_wort = ''
anzahl_vorkommen = 0
for wort in word_count:
    if len(wort) >= 5 and word_count[wort] > anzahl_vorkommen:
        haeufigstes_wort = wort
        anzahl_vorkommen = word_count[wort]

print "Das haeufigste Wort mit mindestens 5 Buchstaben ist '%s' mit %i Vorkommen." % (haeufigstes_wort, anzahl_vorkommen)


