# -*- coding: utf-8 -*-
import json, os, sys
import shapely.geometry

def kantone(json_file):
    fp = open(json_file)
    fc = json.load(fp)      # FeatureCollection lesen
    kant_dict = {}          # Resultat-Dictionnaire
    for feat in fc['features']:
        name = feat['properties']['Nom_abbr']
        geom = shapely.geometry.asShape(feat['geometry'])
        kant_dict[name] = geom.area / 1000000       # Fläche in km2
    return kant_dict


def main():
    if len(sys.argv) < 2:
        # Wird ausgeführt wenn das Programm nicht korrekt aufgerufen wurde
        print """kantone.py
        Gibt Namen und Bevoelkerung fuer jeden Kanton aus.
        Funktionsweise:
            python kantone.py geojson_file
        """
        sys.exit()
    
    # Programm ausführen, das heisst, etwas Nützliches machen
    json_file = sys.argv[1]
    if not os.path.exists(json_file):
        print "Fehler. Datei '%s' existiert nicht."
        sys.exit()
    
    kant_dict = kantone(json_file)
    
    # Dictionnaire ausgeben
    print 'Kanton\tFlaeche [km2]'
    for kanton in kant_dict:
        print '%s\t%s' % (kanton, kant_dict[kanton])
    
    # Und nun den Dictionnaire sortiert nach Fläche ausgeben
    # (grosse Kantone zuerst)
    print ''        # Eine Leerzeile
    print 'Kantone sortiert nach Flaeche (absteigend):'
    print 'Kanton\tFlaeche [km2]'
    for kanton in sorted(kant_dict, key=kant_dict.get, reverse=True):
        print '%s\t%s' % (kanton, kant_dict[kanton])


if __name__ == '__main__':
    main()

